/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.indicator.IndicatorGroupApplicationService;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.constants.AssessTableConfConstants;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class AttachAreaIndicatorEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(AttachAreaIndicatorEdit.class);
    private final AssessActivityApplicationService service = AssessActivityApplicationService.getInstance();
    private final IndicatorGroupApplicationService indicatorService = IndicatorGroupApplicationService.getInstance();
    private final ActEvalObjManageDomainService ACTEVALOBJMANAGE_DOMAIN_SERVICE = ActEvalObjManageDomainService.getInstance();
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final String MUST_INPUT = "mustinput";
    private static final String[] TEXTS = new String[]{"keyacttype", "keyactnumber", "milestone", "perfindctr"};
    private static final String[] MULLINE_TEXTS = new String[]{"keyactname", "yardstick", "remarks", "customfield"};

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryAttachConfigByPk(confId);
        List fieldEntryEvaDtos = (List)formShowParameter.getCustomParam("fieldEntryEvaDtoList");
        if (ObjectUtils.isEmpty((Object)fieldEntryEvaDtos)) {
            DrawAreaUtils.drawIndicatorField(args, conf, AssessTableConfConstants.ATTACH_IGNORE_FIELD);
        } else {
            DrawAreaUtils.drawIndicatorField(args, conf, new String[0], AssessRuleConstants.ATTACH_AREA_PK, fieldEntryEvaDtos);
        }
    }

    private boolean isInIgnore(String[] ignores, String fieldKey) {
        for (String str : ignores) {
            if (HRStringUtils.isEmpty((String)fieldKey) || !HRStringUtils.equals((String)str, (String)fieldKey)) continue;
            return true;
        }
        return false;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryAttachConfigByPk(confId);
        this.setTitleText(formShowParameter.getStatus(), conf);
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        HashSet<String> mustInputs = new HashSet<String>(16);
        for (Object fieldInfo : entryEntity) {
            DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
            LOG.info("AttachAreaIndicatorEdit.afterBindData areaField :{}", (Object)areaField);
            if (!areaField.getBoolean("ismustinput")) continue;
            String fieldKey = fieldInfo.getString("areafield.number");
            LOG.info("AttachAreaIndicatorEdit.afterBindData fieldKey :{},ignore: {}", (Object)fieldKey, (Object)AssessTableConfConstants.ATTACH_IGNORE_FIELD);
            if (this.isInIgnore(AssessTableConfConstants.ATTACH_IGNORE_FIELD, fieldKey)) continue;
            mustInputs.add(fieldKey);
        }
        StringBuffer mustInputsb = new StringBuffer();
        for (String must : mustInputs) {
            mustInputsb.append(must);
            mustInputsb.append(",");
        }
        String mustInputstr = mustInputsb.substring(0, mustInputsb.length() - 1);
        this.getPageCache().put(MUST_INPUT, mustInputstr);
        LOG.info("AttachAreaIndicatorEdit.afterBindData mustInputs : {}", mustInputs);
    }

    private void setTitleText(OperationStatus status, DynamicObject conf) {
        String text = "";
        switch (status) {
            case ADDNEW: {
                text = ResManager.loadKDString((String)"\u6dfb\u52a0{0}\u6307\u6807", (String)"AttachAreaIndicatorEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{conf.getString("areacustname")});
                break;
            }
            case EDIT: {
                text = ResManager.loadKDString((String)"\u7f16\u8f91{0}\u6307\u6807", (String)"AttachAreaIndicatorEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{conf.getString("areacustname")});
                break;
            }
            case VIEW: {
                text = ResManager.loadKDString((String)"\u67e5\u770b{0}\u6307\u6807", (String)"AttachAreaIndicatorEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{conf.getString("areacustname")});
                break;
            }
        }
        Label titleLabel = (Label)this.getControl("titlelabel");
        titleLabel.setText(text);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        if (status != OperationStatus.ADDNEW) {
            return;
        }
        Long instanceId = (Long)parameter.getCustomParam("instanceid");
        this.getModel().setValue("instanceid", (Object)instanceId);
        Integer indReqSize = null == parameter.getCustomParam("indReqSize") ? Integer.valueOf(0) : (Integer)parameter.getCustomParam("indReqSize");
        this.getModel().setValue("entryseq", (Object)(indReqSize + 1));
    }

    protected boolean checkActivityPermission() {
        boolean hasRight = this.getView().getFormShowParameter().isHasRight();
        if (hasRight) {
            return hasRight;
        }
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8003\u6838\u6d3b\u52a8\u7684\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u6743\u9650", (String)"AttachAreaIndicatorEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        long id = this.getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            this.getPageCache().put("addflag", "true");
        } else {
            this.getPageCache().put("addflag", "false");
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            String[] mustInputs;
            if (!this.checkActivityPermission()) {
                args.setCancel(true);
                return;
            }
            Object indicatorGroup = this.getView().getFormShowParameter().getCustomParam("indicatorgroup");
            if (this.indicatorService.isProcessOrDistrActevalObj(indicatorGroup)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u5bf9\u5e94\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u53ef\u7f16\u8f91\u6307\u6807\u3002", (String)"AttachAreaIndicatorEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            IFormView objGenInstView = this.getView().getParentView();
            DynamicObject pDataEntity = objGenInstView.getModel().getDataEntity(true);
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            Long cId = dataEntity.getLong("id");
            String mustInputstr = this.getPageCache().get(MUST_INPUT);
            for (String fieldKey : mustInputs = mustInputstr.split(",")) {
                String valueStr;
                Object value = dataEntity.get(fieldKey);
                LOG.info("AttachAreaIndicatorEdit.beforeDoOperation: fieldKey: {},value: {}", (Object)fieldKey, value);
                if (value == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"AttachAreaIndicatorEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (value instanceof OrmLocaleValue) {
                    OrmLocaleValue ormLocaleValue = (OrmLocaleValue)value;
                    boolean isEmpty = true;
                    Collection values = ormLocaleValue.values();
                    for (Object ormLocaleValueStr : values) {
                        if (HRStringUtils.isEmpty((String)ormLocaleValueStr)) continue;
                        isEmpty = false;
                        break;
                    }
                    if (isEmpty) {
                        LOG.info("AttachAreaIndicatorEdit.beforeDoOperation ormLocaleValue is empty, fieldKey:{}", (Object)fieldKey);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"AttachAreaIndicatorEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                if (!(value instanceof String) || !HRStringUtils.isEmpty((String)(valueStr = (String)value))) continue;
                LOG.info("AttachAreaIndicatorEdit.beforeDoOperation valueStr is empty, fieldKey:{}", (Object)fieldKey);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"AttachAreaIndicatorEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String nameOri = dataEntity.getString("keyactname");
            String name = "";
            if (!HRStringUtils.isEmpty((String)nameOri)) {
                name = nameOri.trim();
            }
            if (!name.equals(nameOri)) {
                this.getModel().setValue("keyactname", (Object)name);
            }
            if (!HRStringUtils.isEmpty((String)name) && HRStringUtils.isEmpty((String)name.trim())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5173\u952e\u4e3e\u63aa\u540d\u79f0\u201d\u3002", (String)"AttachAreaIndicatorEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dynamicObject1 = pDataEntity;
            if ("epa_attachareaind_assign".equals(this.getView().getFormShowParameter().getFormId())) {
                dynamicObject1 = APP_SERVICE.getObjAttachareaIns(Long.valueOf(pDataEntity.getLong("id")));
            }
            DynamicObjectCollection entryentity = dynamicObject1.getDynamicObjectCollection("entryentity");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String currentNodeStr = (String)formShowParameter.getCustomParam("currentNodeId");
            Long nodeId = 0L;
            Integer index = 0;
            if (!HRStringUtils.isEmpty((String)currentNodeStr)) {
                nodeId = Long.parseLong(currentNodeStr);
                index = this.ACTEVALOBJMANAGE_DOMAIN_SERVICE.getIndexByNodeId(nodeId);
            }
            DynamicObjectCollection entryentityNew = new DynamicObjectCollection();
            if (index == 0) {
                entryentityNew = entryentity;
            } else {
                for (DynamicObject dynamicObject : entryentity) {
                    if (dynamicObject.getInt("addnodeindex") > index) continue;
                    entryentityNew.add((Object)dynamicObject);
                }
            }
            for (DynamicObject dynamicObject : entryentityNew) {
                if (cId.equals(0L)) {
                    if (!name.equals(dynamicObject.getString("keyactname"))) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u5df2\u6709\u201c{0}\u201d\u76f8\u540c\u7684\u5173\u952e\u4e3e\u63aa\u540d\u79f0\uff0c\u4e0d\u80fd\u6dfb\u52a0/\u7f16\u8f91\u3002", (String)"AttachAreaIndicatorEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{name}));
                    args.setCancel(true);
                    return;
                }
                if (cId.equals((Long)dynamicObject.getPkValue()) || !name.equals(dynamicObject.getString("keyactname"))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u5df2\u6709\u201c{0}\u201d\u76f8\u540c\u7684\u5173\u952e\u4e3e\u63aa\u540d\u79f0\uff0c\u4e0d\u80fd\u6dfb\u52a0/\u7f16\u8f91\u3002", (String)"AttachAreaIndicatorEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{name}));
                args.setCancel(true);
                return;
            }
            long pId = pDataEntity.getLong("id");
            if (this.indicatorService.checkNameIndicatorAreaEntry(AssessRuleConstants.ATTACH_AREA_PK, Long.valueOf(pId), name)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u4e2d\u5df2\u6709\u8bc4\u4f30\u5bf9\u8c61\u76f8\u540c\u5173\u952e\u4e3e\u63aa\u540d\u79f0\u7684\u6307\u6807\uff0c\u4e0d\u80fd\u6dfb\u52a0/\u7f16\u8f91\u3002", (String)"AttachAreaIndicatorEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        boolean isSuccess = !ObjectUtils.isEmpty((Object)args.getOperationResult()) && args.getOperationResult().isSuccess();
        String addflag = this.getPageCache().get("addflag");
        if (isSuccess && "save".equals(operateKey)) {
            if ("true".equals(addflag)) {
                long pId = this.getView().getParentView().getModel().getDataEntity().getLong("id");
                this.indicatorService.addObjIndicatorAreaEntry(AssessRuleConstants.ATTACH_AREA_PK, Long.valueOf(pId), this.getModel().getDataEntity());
            } else {
                this.indicatorService.updateObjIndicatorAreaEntry(AssessRuleConstants.ATTACH_AREA_PK, this.getModel().getDataEntity());
            }
            this.getView().returnDataToParent(this.getModel().getDataEntity().getPkValue());
        }
    }
}

