/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssignManagerApplicationService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.domain.indicator.imp.helper.DataValidateServiceHelper;
import kd.opmc.epa.business.domain.mp.entityservice.MpRuleEntityService;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetEntryVO;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetVO;
import kd.opmc.epa.business.utils.ActivityPermissionUtils;
import kd.opmc.epa.formplugin.web.utils.MpRuleUtils;

public class BatchAddActivityPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static Log LOGGER = LogFactory.getLog(BatchAddActivityPlugin.class);
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APP = AssessActivityApplicationService.getInstance();
    private static final AssignManagerApplicationService ASSIGN_MANAGER_APPLICATION_SERVICE = AssignManagerApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final AssessSchemeApplicationService SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final MpRuleEntityService MP_RULE_ENTITY_SERVICE = MpRuleEntityService.getInstance();
    private static final String YEAR = "year";
    private static final String MUL_EXECUTE_SCHEME = "mulexecutescheme";
    private static final String ADD_ACTIVITY = "addactivity";
    private static final String SAVE_ACTIVITY = "saveactivity";
    private static final String EXECUTE_SCHEME_F7 = "executeschemef7";
    private static final String F7_ASSESS_SCOPE = "fbasedataid.assessscope";
    private static final String GEN_ACTIVITY_SUCCESS = "genActivitySuccess";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit timeTag = (BasedataEdit)this.getControl(MUL_EXECUTE_SCHEME);
        timeTag.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit executeSchemeF7 = (MulBasedataEdit)this.getControl(EXECUTE_SCHEME_F7);
        executeSchemeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scheme = (BasedataEdit)this.getControl("scheme");
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)ADD_ACTIVITY)) {
            Object year = this.getModel().getValue(YEAR);
            Object mulExecuteScheme = this.getModel().getValue(MUL_EXECUTE_SCHEME);
            if (ObjectUtils.isEmpty((Object)year)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e74\u4efd\u672a\u586b\u5199", (String)"BatchAddActivityPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (ObjectUtils.isEmpty((Object)mulExecuteScheme)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8003\u6838\u6267\u884c\u8ba1\u5212\u3002", (String)"BatchAddActivityPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private boolean checkEvalActivity() {
        DynamicObjectCollection executeSchemeColl = this.getModel().getEntryEntity("entryentity");
        if (ObjectUtils.isEmpty((Object)executeSchemeColl)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u751f\u6210\u7684\u6570\u636e\u3002", (String)"BatchAddActivityPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return false;
        }
        List schemeIdList = executeSchemeColl.stream().map(executeScheme -> executeScheme.getLong("executescheme.scheme.id")).collect(Collectors.toList());
        DynamicObject[] schemeDynObjArr = ASSESS_SCHEME_APPLICATION_SERVICE.getSchemeArrBySchemeIdList(schemeIdList);
        List schemeStoppedNameList = Arrays.stream(schemeDynObjArr).filter(schemeDynObj -> HRStringUtils.equals((String)schemeDynObj.getString("schstatus"), (String)"20")).map(schemeDynObj -> schemeDynObj.getString("name")).collect(Collectors.toList());
        if (!schemeStoppedNameList.isEmpty()) {
            String schemeStoppedName = String.join((CharSequence)",", schemeStoppedNameList);
            String errorMsg = String.format(ResManager.loadKDString((String)"%s\u8003\u6838\u8ba1\u5212\u5df2\u7ec8\u6b62\uff0c\u4e0d\u53ef\u751f\u6210\u8003\u6838\u6d3b\u52a8", (String)"BatchAddActivityPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]), schemeStoppedName);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        Date year = this.getModel().getDataEntity().getDate(YEAR);
        List executeSchemeIdList = executeSchemeColl.stream().map(executeScheme -> executeScheme.getLong("executescheme.id")).collect(Collectors.toList());
        DynamicObject[] activityDynObjArr = ASSESS_ACTIVITY_APP.queryActivityByExecuteSchemeIdList(executeSchemeIdList, year);
        Map<Long, DynamicObject> executeSchemeActivityMap = Arrays.stream(activityDynObjArr).collect(Collectors.toMap(activityDynObj -> activityDynObj.getLong("executescheme.id"), activityDynObj -> activityDynObj));
        ArrayList<String> existActivityExecuteSchemeList = new ArrayList<String>(executeSchemeActivityMap.size());
        for (DynamicObject col : executeSchemeColl) {
            long executeId = col.getLong("executescheme.id");
            DynamicObject activityDynObj2 = executeSchemeActivityMap.get(executeId);
            if (activityDynObj2 == null) continue;
            existActivityExecuteSchemeList.add(col.getString("executescheme.name"));
        }
        if (!existActivityExecuteSchemeList.isEmpty()) {
            String joinStr = String.join((CharSequence)"\u3001", existActivityExecuteSchemeList);
            String errorMsg = String.format(ResManager.loadKDString((String)"%s-\u5df2\u751f\u6210\u8003\u6838\u6d3b\u52a8\u3002", (String)"BatchAddActivityPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]), joinStr);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        return true;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTips();
        if (this.getModel().getValue("scheme") == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{MUL_EXECUTE_SCHEME});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        DynamicObjectCollection executeSchemeDynObjColl = this.getModel().getEntryEntity("entryentity");
        Date year = this.getModel().getDataEntity().getDate(YEAR);
        if (HRStringUtils.equals((String)operateKey, (String)ADD_ACTIVITY)) {
            List currExecuteSchemeIds = executeSchemeDynObjColl.stream().map(currActivity -> currActivity.getLong("executescheme.id")).collect(Collectors.toList());
            int yearInt = HRDateTimeUtils.getYear((Date)year);
            DynamicObjectCollection executeSchemeByYearColl = ASSESS_ACTIVITY_APP.queryExecuteSchemeByPeriod(String.valueOf(yearInt));
            MulBasedataEdit executeSchemeF7 = (MulBasedataEdit)this.getControl(EXECUTE_SCHEME_F7);
            QFilter filter = new QFilter("id", "not in", currExecuteSchemeIds);
            List executedSchemeIdList = executeSchemeByYearColl.stream().map(dynObj -> dynObj.getLong("executescheme.id")).collect(Collectors.toList());
            DynamicObject[] executeSchemeArr = ASSESS_ACTIVITY_APP.queryAssessSchemeArr(executedSchemeIdList);
            HashSet<Long> executeSchemeIdSet = new HashSet<Long>(executeSchemeArr.length);
            for (DynamicObject executeSchemeDynObj : executeSchemeArr) {
                Date endYear;
                if (executeSchemeDynObj.getDynamicObject("scheme") == null) continue;
                Date startYear = executeSchemeDynObj.getDate("scheme.startyear");
                if (year.compareTo(startYear) >= 0) {
                    executeSchemeIdSet.add(executeSchemeDynObj.getLong("id"));
                }
                if ((endYear = executeSchemeDynObj.getDate("scheme.endyear")) == null || year.compareTo(endYear) > 0) continue;
                executeSchemeIdSet.add(executeSchemeDynObj.getLong("id"));
            }
            filter.and("id", "in", executeSchemeIdSet);
            executeSchemeF7.setQFilter(filter);
            executeSchemeF7.click();
        } else if (HRStringUtils.equals((String)operateKey, (String)SAVE_ACTIVITY)) {
            this.batchMutexCheckAndGenActivity();
        }
    }

    private void batchMutexCheckAndGenActivity() {
        DynamicObjectCollection executeSchemeDynObjColl = this.getModel().getEntryEntity("entryentity");
        Map<String, DynamicObject> idExecuteSchemeMap = executeSchemeDynObjColl.stream().collect(Collectors.toMap(executeSchemeDynObj -> executeSchemeDynObj.getString("executescheme.id"), executeSchemeDynObj -> executeSchemeDynObj));
        try (DataMutex dataMutex = DataMutex.create();){
            ArrayList mutexLockInfoList = new ArrayList(executeSchemeDynObjColl.size());
            HashMap executeSchemeIdMuteInfoMap = new HashMap(executeSchemeDynObjColl.size());
            for (DynamicObject executeSchemeDynObj2 : executeSchemeDynObjColl) {
                HashMap<String, Object> mutexInfoMap = new HashMap<String, Object>(16);
                mutexInfoMap.put("dataObjId", executeSchemeDynObj2.getString("executescheme.id"));
                mutexInfoMap.put("entityKey", "epa_executescheme");
                mutexInfoMap.put("operationKey", "modify");
                mutexInfoMap.put("isStrict", true);
                mutexInfoMap.put("callSource", "default");
                mutexInfoMap.put("dataObjNumber", executeSchemeDynObj2.getString("name"));
                mutexLockInfoList.add(mutexInfoMap);
                executeSchemeIdMuteInfoMap.put(executeSchemeDynObj2.getString("executescheme.id"), mutexInfoMap);
            }
            ArrayList<String> lockFailedList = new ArrayList<String>();
            ArrayList releaseLockList = new ArrayList();
            Map batchRequireMap = dataMutex.batchrequire(mutexLockInfoList);
            for (Map.Entry entry : batchRequireMap.entrySet()) {
                Boolean locked = (Boolean)entry.getValue();
                String executeSchemeId = (String)entry.getKey();
                if (locked != null && !locked.booleanValue()) {
                    DynamicObject executeSchemeDynObj3 = idExecuteSchemeMap.get(executeSchemeId);
                    lockFailedList.add(executeSchemeDynObj3.getString("executescheme.name"));
                    continue;
                }
                releaseLockList.add(executeSchemeIdMuteInfoMap.get(executeSchemeId));
            }
            if (!lockFailedList.isEmpty()) {
                String lockMsg = String.format(ResManager.loadKDString((String)"%s\u8003\u6838\u6267\u884c\u8ba1\u5212\u6b63\u5728\u751f\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"BatchAddActivityPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", lockFailedList));
                this.getView().showErrorNotification(lockMsg);
                if (!releaseLockList.isEmpty()) {
                    dataMutex.batchRelease(releaseLockList);
                }
                return;
            }
            Date year = this.getModel().getDataEntity().getDate(YEAR);
            if (this.checkEvalActivity()) {
                this.genAssessActivityAndSave(executeSchemeDynObjColl, year);
                this.getView().getPageCache().put(GEN_ACTIVITY_SUCCESS, Boolean.TRUE.toString());
                this.getView().close();
            }
            dataMutex.batchRelease(mutexLockInfoList);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            String errorMsg = ResManager.loadKDString((String)"\u751f\u6210\u8003\u6838\u6d3b\u52a8\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BatchAddActivityPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String genActivitySuccess = this.getView().getPageCache().get(GEN_ACTIVITY_SUCCESS);
        if (Boolean.TRUE.toString().equals(genActivitySuccess)) {
            HashMap<String, String> showSuccessTipsMap = new HashMap<String, String>(2);
            showSuccessTipsMap.put(GEN_ACTIVITY_SUCCESS, Boolean.TRUE.toString());
            this.getView().returnDataToParent(showSuccessTipsMap);
        }
    }

    private void genAssessActivityAndSave(DynamicObjectCollection executeSchemeDynObjColl, Date year) {
        int yearInt = HRDateTimeUtils.getYear((Date)year);
        String[] batchNumber = ASSESS_ACTIVITY_APP.getBatchNumber(executeSchemeDynObjColl.size());
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject[] needSaveActivityDynObjArr = new DynamicObject[executeSchemeDynObjColl.size()];
        Map<Long, DynamicObject> timeTagIdDynObjMap = this.getTimeTagIdDynObjMap(executeSchemeDynObjColl);
        Map<Long, DynamicObject> workFlowIdDynObjMap = this.getWorkFlowDynObjMap(executeSchemeDynObjColl);
        Map<Long, List<DynamicObject>> assessGroupIdMap = this.getAssessGroupIdDynObjMap(executeSchemeDynObjColl);
        Map<Long, Long> passNodeMap = this.getPassNodeSettingValue(executeSchemeDynObjColl);
        for (int i = 0; i < executeSchemeDynObjColl.size(); ++i) {
            DynamicObject executeSchemeDynObj = (DynamicObject)executeSchemeDynObjColl.get(i);
            DynamicObject emptyAssessActivityDynObj = this.setEmptyAssessActivityByExecuteScheme(year, yearInt, batchNumber[i], currUserId, timeTagIdDynObjMap, executeSchemeDynObj);
            this.setTimePlanEntry(workFlowIdDynObjMap, executeSchemeDynObj, emptyAssessActivityDynObj);
            this.setAssessGroupEntry(assessGroupIdMap, executeSchemeDynObj, emptyAssessActivityDynObj);
            emptyAssessActivityDynObj.set("processpermsetting", (Object)passNodeMap.get(executeSchemeDynObj.getLong("executescheme.id")));
            needSaveActivityDynObjArr[i] = emptyAssessActivityDynObj;
        }
        ActivityPermissionUtils.setActivityAndCopyFlow((DynamicObject[])needSaveActivityDynObjArr);
        ASSESS_ACTIVITY_APP.saveActivity(needSaveActivityDynObjArr);
    }

    private DynamicObject setEmptyAssessActivityByExecuteScheme(Date year, int yearInt, String number, long currUserId, Map<Long, DynamicObject> timeTagIdDynObjMap, DynamicObject executeSchemeDynObj) {
        DynamicObject scheme;
        DynamicObject emptyAssessActivityDynObj = ASSESS_ACTIVITY_APP.genEmptyAssessActivityDynObj();
        emptyAssessActivityDynObj.set(YEAR, (Object)year);
        emptyAssessActivityDynObj.set("executescheme", executeSchemeDynObj.get("executescheme"));
        emptyAssessActivityDynObj.set("scheme", (Object)executeSchemeDynObj.getLong("executescheme.scheme.id"));
        long timeTagId = executeSchemeDynObj.getLong("executescheme.timetag.id");
        DynamicObject timeTag = timeTagIdDynObjMap.get(timeTagId);
        String period = yearInt + timeTag.getString("name");
        String periodName = this.getPeriodName(timeTag, yearInt);
        emptyAssessActivityDynObj.set("period", (Object)period);
        emptyAssessActivityDynObj.set("periodname", (Object)periodName);
        emptyAssessActivityDynObj.set("name", executeSchemeDynObj.get("name"));
        emptyAssessActivityDynObj.set("number", (Object)number);
        emptyAssessActivityDynObj.set("activitystatus", (Object)ActivityStatusEnum.TO_BE_EXECUTE.getValue());
        emptyAssessActivityDynObj.set("status", (Object)"C");
        emptyAssessActivityDynObj.set("enable", (Object)"1");
        emptyAssessActivityDynObj.set("creator", (Object)currUserId);
        emptyAssessActivityDynObj.set("periodstartdate", executeSchemeDynObj.get("daterangefield_startdate"));
        emptyAssessActivityDynObj.set("periodenddate", executeSchemeDynObj.get("daterangefield_enddate"));
        emptyAssessActivityDynObj.set("adminorg", executeSchemeDynObj.getDynamicObject("executescheme").get("adminorg"));
        emptyAssessActivityDynObj.set("org", executeSchemeDynObj.getDynamicObject("executescheme").get("org"));
        DynamicObject rule = null;
        if (this.getModel().getDataEntity().getDynamicObject("scheme").getDynamicObject("mprule") != null && this.getModel().getDataEntity().getDynamicObject("scheme").getBoolean("isneedmpgenway") && (scheme = this.getModel().getDataEntity().getDynamicObject("scheme")).getDynamicObject("mpsoptimetag") != null) {
            boolean showMpruleFlex;
            DynamicObject excutescheme = executeSchemeDynObj.getDynamicObject("executescheme");
            boolean bl = showMpruleFlex = excutescheme.getDynamicObject("timetag").getLong("id") == scheme.getDynamicObject("mpsoptimetag").getLong("ID");
            if (showMpruleFlex) {
                MpRuleSetVO mpRuleSetVO = this.getMpRuleSetVO();
                rule = MP_RULE_ENTITY_SERVICE.saveByVo(mpRuleSetVO, Long.valueOf(0L));
                emptyAssessActivityDynObj.set("mprule", (Object)rule);
                emptyAssessActivityDynObj.set("isneedmpgenway", (Object)this.getModel().getDataEntity().getDynamicObject("scheme").getBoolean("isneedmpgenway"));
                emptyAssessActivityDynObj.set("isgenextmpsop", this.getModel().getDataEntity().getDynamicObject("scheme").get("isgenextmpsop"));
                emptyAssessActivityDynObj.set("mpsopcategory", this.getModel().getDataEntity().getDynamicObject("scheme").get("mpsopcategory"));
                emptyAssessActivityDynObj.set("mpgenway", this.getModel().getDataEntity().getDynamicObject("scheme").get("mpgenway"));
            }
        }
        return emptyAssessActivityDynObj;
    }

    private MpRuleSetVO getMpRuleSetVO() {
        MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
        ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
        mpRuleSetVO.setEntryentities(entryentities);
        Long mpRuleId = this.getModel().getDataEntity().getDynamicObject("scheme").getDynamicObject("mprule").getLong("id");
        DynamicObject mpRule = MP_RULE_ENTITY_SERVICE.queryOne(mpRuleId);
        MpRuleUtils.buildVoByMpRule(mpRule, mpRuleSetVO, entryentities);
        return mpRuleSetVO;
    }

    private Map<Long, Long> getPassNodeSettingValue(DynamicObjectCollection executeSchemeDynObjColl) {
        List excuteSchemeIds = executeSchemeDynObjColl.stream().map(executeSchemeDynObj -> executeSchemeDynObj.getLong("executescheme.id")).collect(Collectors.toList());
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"0");
        filter.and(new QFilter("excutescheme", "in", excuteSchemeIds));
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"epa_processpermsetting", (String)"id,excutescheme.id", (QFilter[])new QFilter[]{filter}, (String)"createtime desc");
        if (datas.length > 0) {
            return Arrays.stream(datas).collect(Collectors.toMap(DynamicObject2 -> DynamicObject2.getLong("excutescheme.id"), DynamicObject2 -> DynamicObject2.getLong("id"), (key1, key2) -> key1, HashMap::new));
        }
        return new HashMap<Long, Long>();
    }

    private void setAssessGroupEntry(Map<Long, List<DynamicObject>> assessGroupIdMap, DynamicObject executeSchemeDynObj, DynamicObject emptyAssessActivityDynObj) {
        DynamicObjectCollection assessGroupEntry = emptyAssessActivityDynObj.getDynamicObjectCollection("assgroupentry");
        long assessScopeId = executeSchemeDynObj.getLong("executescheme.assessscope.id");
        List<DynamicObject> assessGroupList = assessGroupIdMap.get(assessScopeId);
        for (int j = 0; j < assessGroupList.size(); ++j) {
            DynamicObject assessGroup = assessGroupList.get(j);
            DynamicObject newAssessGroup = assessGroupEntry.addNew();
            newAssessGroup.set("assgroup", (Object)assessGroup.getLong("id"));
            newAssessGroup.set("seq", (Object)j);
        }
    }

    private void setTimePlanEntry(Map<Long, DynamicObject> workFlowIdDynObjMap, DynamicObject executeSchemeDynObj, DynamicObject emptyAssessActivityDynObj) {
        long workFlowId = executeSchemeDynObj.getLong("executescheme.perfworkflow.id");
        DynamicObject workFlowDynObj = workFlowIdDynObjMap.get(workFlowId);
        DynamicObjectCollection nodeSettingColl = workFlowDynObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection timePlanEntry = emptyAssessActivityDynObj.getDynamicObjectCollection("timeplanentry");
        for (int j = 0; j < nodeSettingColl.size(); ++j) {
            DynamicObject nodeSetting = (DynamicObject)nodeSettingColl.get(j);
            if (!nodeSetting.getBoolean("isshow")) continue;
            DynamicObject timePlan = timePlanEntry.addNew();
            timePlan.set("activity", (Object)nodeSetting.getLong("node.id"));
            timePlan.set("seq", (Object)j);
        }
    }

    private Map<Long, DynamicObject> getWorkFlowDynObjMap(DynamicObjectCollection executeSchemeDynObjColl) {
        List workFlowIdList = executeSchemeDynObjColl.stream().map(executeSchemeDynObj -> executeSchemeDynObj.getLong("executescheme.perfworkflow.id")).collect(Collectors.toList());
        DynamicObject[] workFlowArr = ASSESS_ACTIVITY_APP.queryWorkFlowArr(workFlowIdList);
        return Arrays.stream(workFlowArr).collect(Collectors.toMap(workFlowDynObj -> workFlowDynObj.getLong("id"), workFlowDynObj -> workFlowDynObj));
    }

    private Map<Long, List<DynamicObject>> getAssessGroupIdDynObjMap(DynamicObjectCollection executeSchemeDynObjColl) {
        List executeSchemeAssessGroupIdList = executeSchemeDynObjColl.stream().map(executeSchemeDynObj -> executeSchemeDynObj.getLong("executescheme.assessscope.id")).collect(Collectors.toList());
        DynamicObject[] assessGroupArr = ASSESS_ACTIVITY_APP.queryListByScopeIdList(executeSchemeAssessGroupIdList);
        return Arrays.stream(assessGroupArr).collect(Collectors.groupingBy(assessGroupDynObj -> assessGroupDynObj.getLong("objectscope.id")));
    }

    private Map<Long, DynamicObject> getTimeTagIdDynObjMap(DynamicObjectCollection executeSchemeDynObjColl) {
        List timeTagIdList = executeSchemeDynObjColl.stream().map(executeSchemeDynObj -> executeSchemeDynObj.getLong("executescheme.timetag.id")).collect(Collectors.toList());
        DynamicObject[] timeTagArr = ASSESS_ACTIVITY_APP.queryTimeTagArr(timeTagIdList);
        return Arrays.stream(timeTagArr).collect(Collectors.toMap(timeTagDynObj -> timeTagDynObj.getLong("id"), timeTagDynObj -> timeTagDynObj));
    }

    private String getPeriodName(DynamicObject timeTag, int yearInt) {
        DynamicObject cycleType = timeTag.getDynamicObject("cycletype");
        String periodName = ResManager.loadKDString((String)"%1$s\u5e74", (String)"BatchAddActivityPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{yearInt});
        if (!HRStringUtils.equals((String)timeTag.getString("number"), (String)"101010_S")) {
            periodName = HRStringUtils.equals((String)timeTag.getString("number"), (String)"102010_S") ? ResManager.loadKDString((String)"%1$s\u4e0a\u534a\u5e74", (String)"BatchAddActivityPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{periodName}) : (HRStringUtils.equals((String)timeTag.getString("number"), (String)"102020_S") ? ResManager.loadKDString((String)"%1$s\u4e0b\u534a\u5e74", (String)"BatchAddActivityPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[]{periodName}) : periodName + timeTag.getString("name").substring(1) + cycleType.getString("name"));
        }
        return periodName;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)EXECUTE_SCHEME_F7)) {
            DynamicObjectCollection executeSchemes = (DynamicObjectCollection)this.getModel().getValue(EXECUTE_SCHEME_F7);
            if (ObjectUtils.isEmpty((Object)executeSchemes)) {
                return;
            }
            this.addActivityEntry(executeSchemes);
            this.getModel().setValue(EXECUTE_SCHEME_F7, null);
        } else if (HRStringUtils.equals((String)name, (String)MUL_EXECUTE_SCHEME)) {
            this.initActivity();
        } else if (HRStringUtils.equals((String)name, (String)YEAR)) {
            this.getModel().setValue(MUL_EXECUTE_SCHEME, null);
            this.clearActivityEntry();
            this.setMulExecuteSchemeEnable(e);
        } else if (HRStringUtils.equals((String)name, (String)"scheme")) {
            ChangeData[] changeSet = e.getChangeSet();
            Object oldValue = changeSet[0].getOldValue();
            Object newValue = changeSet[0].getNewValue();
            if (oldValue == null) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"executescheme"});
            } else {
                this.clearActivityEntry();
                this.setMulExecuteSchemeEnable(e);
            }
            if (newValue == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"executescheme"});
                this.clearActivityEntry();
                this.setMulExecuteSchemeEnable(e);
            } else if (!newValue.equals(oldValue)) {
                this.clearActivityEntry();
                this.setMulExecuteSchemeEnable(e);
            }
        }
    }

    private void setMulExecuteSchemeEnable(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        if (oldValue == null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{MUL_EXECUTE_SCHEME});
        } else {
            this.getModel().setValue(MUL_EXECUTE_SCHEME, null);
        }
        if (newValue == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{MUL_EXECUTE_SCHEME});
        }
    }

    private void initActivity() {
        Date year = (Date)this.getModel().getValue(YEAR);
        DynamicObjectCollection mulExecuteScheme = this.getModel().getDataEntity().getDynamicObjectCollection(MUL_EXECUTE_SCHEME);
        if (!ObjectUtils.isEmpty((Object)year) && !ObjectUtils.isEmpty((Object)mulExecuteScheme)) {
            this.clearActivityEntry();
            this.initActivityEntry((List<DynamicObject>)mulExecuteScheme, true);
        }
    }

    private void clearActivityEntry() {
        this.getModel().deleteEntryData("entryentity");
    }

    private void addActivityEntry(DynamicObjectCollection executeSchemes) {
        if (!this.checkPermission(executeSchemes, F7_ASSESS_SCOPE)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"BatchAddActivityPlugin_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        List<DynamicObject> executeSchemeList = executeSchemes.stream().map(executeScheme -> executeScheme.getDynamicObject("fbasedataid")).sorted(Comparator.comparing(executeScheme -> executeScheme.getString("timetag.number"))).collect(Collectors.toList());
        this.initActivityEntry(executeSchemeList, false);
    }

    private void initActivityEntry(List<DynamicObject> executeSchemeList, boolean mulFlag) {
        int year = HRDateTimeUtils.getYear((Date)((Date)this.getModel().getValue(YEAR)));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("executescheme", new Object[0]);
        vs.addField("name", new Object[0]);
        vs.addField("daterangefield_startdate", new Object[0]);
        vs.addField("daterangefield_enddate", new Object[0]);
        String schemeProperty = mulFlag ? "fbasedataid.scheme.id" : "scheme.id";
        List<Long> schemeIdList = executeSchemeList.stream().map(executeSchemeDynObj -> executeSchemeDynObj.getLong(schemeProperty)).collect(Collectors.toList());
        Map<Long, Map<String, DynamicObject>> schemeIdCycleSchemeMap = this.getCycleSchemeDynObjMap(schemeIdList);
        this.setTableValueSetter(executeSchemeList, mulFlag, year, vs, schemeProperty, schemeIdCycleSchemeMap);
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void setTableValueSetter(List<DynamicObject> executeSchemeList, boolean mulFlag, int year, TableValueSetter vs, String schemeProperty, Map<Long, Map<String, DynamicObject>> schemeIdCycleSchemeMap) {
        String timeTagProperty = mulFlag ? "fbasedataid.timetag.name" : "timetag.name";
        String assessGroupProperty = mulFlag ? "fbasedataid.assessscope.name" : "assessscope.name";
        String idProperty = mulFlag ? "fbasedataid.id" : "id";
        for (DynamicObject executeSchemeDy : executeSchemeList) {
            long schemeId = executeSchemeDy.getLong(schemeProperty);
            String timeTagName = executeSchemeDy.getString(timeTagProperty);
            Map<String, DynamicObject> periodFlagPeriodConfMap = schemeIdCycleSchemeMap.get(schemeId);
            Date periodStartDate = null;
            Date periodEndDate = null;
            DynamicObject periodConfDynObj = periodFlagPeriodConfMap.get(timeTagName);
            if (periodConfDynObj != null) {
                String periodStart = periodConfDynObj.getString("periodstart");
                String periodEnd = periodConfDynObj.getString("periodend");
                try {
                    periodStartDate = HRDateTimeUtils.parseDate((String)(year + "-" + periodStart));
                    periodEndDate = periodStart.compareTo(periodEnd) > 0 ? HRDateTimeUtils.parseDate((String)(year + 1 + "-" + periodEnd)) : HRDateTimeUtils.parseDate((String)(year + "-" + periodEnd));
                }
                catch (ParseException e) {
                    LOGGER.error((Throwable)e);
                }
            }
            String activityName = String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s\u8003\u6838\u6d3b\u52a8", (String)"BatchAddActivityPlugin_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]), String.valueOf(year), executeSchemeDy.getString(timeTagProperty), executeSchemeDy.getString(assessGroupProperty));
            vs.addRow(new Object[]{executeSchemeDy.get(idProperty), activityName, periodStartDate, periodEndDate});
        }
    }

    private Map<Long, Map<String, DynamicObject>> getCycleSchemeDynObjMap(List<Long> schemeIdList) {
        DynamicObject[] schemeDynObjArr = ASSESS_SCHEME_APPLICATION_SERVICE.getSchemeArrBySchemeIdList(schemeIdList);
        HashMap<Long, Map<String, DynamicObject>> schemeIdCycleSchemeMap = new HashMap<Long, Map<String, DynamicObject>>(16);
        for (DynamicObject schemeDynObj : schemeDynObjArr) {
            long schemeId = schemeDynObj.getLong("id");
            Map cycleSchemeDynObjMap = schemeIdCycleSchemeMap.computeIfAbsent(schemeId, k -> new HashMap(16));
            if (schemeDynObj.getBoolean("isperiodassess")) {
                DynamicObjectCollection periodConfColl = schemeDynObj.getDynamicObjectCollection("periodconfentity");
                for (DynamicObject periodConfDynObj : periodConfColl) {
                    DynamicObjectCollection periodConfEntryEntity = periodConfDynObj.getDynamicObjectCollection("pcyclescheme.entryentity");
                    if (periodConfEntryEntity == null) continue;
                    for (DynamicObject entryEntity : periodConfEntryEntity) {
                        cycleSchemeDynObjMap.put(entryEntity.getString("periodflag"), entryEntity);
                    }
                }
                continue;
            }
            DynamicObject cycleSchemeDynObj = schemeDynObj.getDynamicObject("cyclescheme");
            if (cycleSchemeDynObj == null) continue;
            DynamicObjectCollection cycleSchemeSettingColl = cycleSchemeDynObj.getDynamicObjectCollection("entryentity");
            Map<String, DynamicObject> periodFlagCycleSchemeMap = cycleSchemeSettingColl.stream().collect(Collectors.toMap(periodConf -> periodConf.getString("periodflag"), periodConf -> periodConf));
            cycleSchemeDynObjMap.putAll(periodFlagCycleSchemeMap);
        }
        return schemeIdCycleSchemeMap;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        ListFilterParameter listFilterParameter;
        ListShowParameter showParameter;
        String f7 = ((Control)event.getSource()).getKey();
        if (HRStringUtils.equals((String)f7, (String)MUL_EXECUTE_SCHEME)) {
            showParameter = (ListShowParameter)event.getFormShowParameter();
            listFilterParameter = showParameter.getListFilterParameter();
            Date dateTime = this.getModel().getDataEntity().getDate(YEAR);
            int year = HRDateTimeUtils.getYear((Date)dateTime);
            DynamicObjectCollection executeSchemeDynObjColl = ASSESS_ACTIVITY_APP.queryExecuteSchemeByPeriod(String.valueOf(year));
            List executedSchemeIdList = executeSchemeDynObjColl.stream().map(dynObj -> dynObj.getLong("executescheme.id")).collect(Collectors.toList());
            DynamicObject[] executeSchemeArr = ASSESS_ACTIVITY_APP.queryAssessSchemeArr(executedSchemeIdList);
            HashSet<Long> executeSchemeIdSet = new HashSet<Long>(executeSchemeArr.length);
            for (DynamicObject executeSchemeDynObj : executeSchemeArr) {
                Date endYear;
                Date startYear = executeSchemeDynObj.getDate("scheme.startyear");
                if (startYear != null && dateTime.compareTo(startYear) >= 0) {
                    executeSchemeIdSet.add(executeSchemeDynObj.getLong("id"));
                }
                if ((endYear = executeSchemeDynObj.getDate("scheme.endyear")) == null || dateTime.compareTo(endYear) > 0) continue;
                executeSchemeIdSet.add(executeSchemeDynObj.getLong("id"));
            }
            listFilterParameter.setFilter(new QFilter("id", "in", executeSchemeIdSet));
            if (this.getModel().getValue("scheme") != null) {
                listFilterParameter.setFilter(new QFilter("scheme.id", "=", (Object)((DynamicObject)this.getModel().getValue("scheme")).getLong("id")));
            }
            String appId = DataValidateServiceHelper.getBizAppId((String)"epa_activity");
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"36", (String)appId, (String)"epa_activity", (String)"47150e89000000ac");
            if (!result.hasAllOrgPerm()) {
                listFilterParameter.setFilter(new QFilter("scheme.org", "in", (Object)result.getHasPermOrgs()));
            }
        }
        if ("scheme".equals(f7)) {
            showParameter = (ListShowParameter)event.getFormShowParameter();
            listFilterParameter = showParameter.getListFilterParameter();
            String appId = DataValidateServiceHelper.getBizAppId((String)"epa_activity");
            String orgViewType = PermCommonUtil.getPermOrgViewScheme((String)"epa_activity");
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)appId, (String)"epa_activity", (String)"47150e89000000ac");
            if (!result.hasAllOrgPerm()) {
                listFilterParameter.setFilter(new QFilter("org", "in", (Object)result.getHasPermOrgs()));
            }
        }
    }

    private void initTips() {
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = ASSESS_ACTIVITY_APP.getTips("epa_batchaddactivity", "name", dy);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            HashMap<String, String> contentMap = new HashMap<String, String>(16);
            contentMap.put("zh_CN", tipContent);
            map.put("content", contentMap);
            map.put("type", "text");
            entryGrid.setColumnProperty("name", "tips", map);
        }
    }

    private void setScopeFilter(QFilter filter) {
        List<Long> scopeIds = this.getScopeIds();
        if (!ObjectUtils.isEmpty(scopeIds)) {
            QFilter qFilter = new QFilter("assessscope", "in", scopeIds);
            filter.and(qFilter);
        }
    }

    private List<DynamicObject> setScopeFilterList(List<DynamicObject> executeSchemeList) {
        List<Long> scopeIds = this.getScopeIds();
        if (!ObjectUtils.isEmpty(scopeIds)) {
            executeSchemeList = executeSchemeList.stream().filter(dy -> {
                long id = dy.getDynamicObject("assessscope").getLong("id");
                return scopeIds.contains(id);
            }).collect(Collectors.toList());
        }
        return executeSchemeList;
    }

    private boolean checkPermission(DynamicObjectCollection dys, String dyStr) {
        String pageId;
        String string = pageId = null == this.getView().getParentView().getParentView() ? "" : this.getView().getParentView().getParentView().getPageId();
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement")) {
            List ids = dys.stream().map(obj -> (Long)obj.getDynamicObject(dyStr).getPkValue()).collect(Collectors.toList());
            List<Long> scopeIds = this.getScopeIds();
            if (!ObjectUtils.isEmpty(scopeIds)) {
                return scopeIds.containsAll(ids);
            }
        }
        return true;
    }

    private List<Long> getScopeIds() {
        boolean scopeCheck;
        DynamicObject manager;
        String pageId = this.getView().getParentView().getParentView().getPageId();
        List<Long> scopeIds = new ArrayList<Long>(10);
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty((Object)(manager = this.getManagerData())) && !(scopeCheck = manager.getBoolean("isscopecheck"))) {
            DynamicObjectCollection scopes = manager.getDynamicObjectCollection("objectscope");
            scopeIds = scopes.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        return scopeIds;
    }

    private boolean checkItemPermission() {
        DynamicObject manager = this.getManagerData();
        if (!ObjectUtils.isEmpty((Object)manager)) {
            String manageItems = manager.getString("manageitems");
            return manageItems.contains("2");
        }
        return true;
    }

    private DynamicObject getManagerData() {
        long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        long sysUserId = RequestContext.get().getCurrUserId();
        return ASSIGN_MANAGER_APPLICATION_SERVICE.queryBySchmeIdAndUserId(Long.valueOf(schemeId), sysUserId);
    }
}

