/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.domain.activitymanage.entity.ActObjStatBo;
import kd.opmc.epa.business.domain.mp.entityservice.MpRuleEntityService;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetEntryVO;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetVO;
import kd.opmc.epa.business.domain.timetag.enums.ActivityTimeStampEnums;
import kd.opmc.epa.business.task.StartUpActivityAddActObjectTask;
import kd.opmc.epa.formplugin.web.activity.bo.CyclePeriodDateRange;
import kd.opmc.epa.formplugin.web.utils.ActivityDispatchUtils;
import kd.opmc.epa.formplugin.web.utils.MpRuleUtils;
import kd.opmc.pbs.business.application.service.PerfParamConfigApplicationService;

public class EvaluationActivityEdit
extends HRDataBaseEdit {
    private static Log LOGGER = LogFactory.getLog(EvaluationActivityEdit.class);
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final MpRuleEntityService MP_RULE_ENTITY_SERVICE = MpRuleEntityService.getInstance();
    private static final PerfParamConfigApplicationService PERF_PARAM_CONFIG_APPLICATION_SERVICE = PerfParamConfigApplicationService.getInstance();
    private static final String TREE_PERIOD = "treeperiod";
    private static final String TREE_DATE_RANGE_FIELD = "treedaterangefield";
    private static final String TREE_ENTRY_ENTITY = "treeentryentity";
    private static final Map<Long, String> CYCLE_TYPE_MAP = new HashMap<Long, String>(){
        private static final long serialVersionUID = -4814761800890911507L;
        {
            this.put(1363179570613844992L, "Y");
            this.put(1363179723043240960L, "H");
            this.put(1363180109330260992L, "Q");
            this.put(1363180276724933632L, "M");
        }
    };
    private static final String IS_NEEDMPGENWAY = "isneedmpgenway";
    private static final String MP_GENWAY = "mpgenway";
    private static final String MP_RULE = "mp_rule";
    private static final Long CYCLE_YEAR = 1363179570613844992L;

    public void afterCreateNewData(EventObject e) {
        if (!PERF_PARAM_CONFIG_APPLICATION_SERVICE.isOpenPerfSum()) {
            this.getModel().setValue(IS_NEEDMPGENWAY, (Object)false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultValueByCustom();
        this.setAssessFormAndWorkFlow();
        this.setTreeEntryEntityDefaultValue();
        this.updateTreeEntryDateRange();
        this.hideSaveandStartupButton();
        this.mpRuleFlexVisible();
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        if (StringUtils.isNotBlank((CharSequence)source) && "epa_processmanage".equals(source)) {
            String pageId = this.getView().getPageId();
            Label activitytitle = (Label)this.getControl("activitytitle");
            if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
                activitytitle.setText(ResManager.loadKDString((String)"\u4fee\u6539\u57fa\u672c\u4fe1\u606f", (String)"EvaluationActivityEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else {
                activitytitle.setText(ResManager.loadKDString((String)"\u67e5\u770b\u57fa\u672c\u4fe1\u606f", (String)"EvaluationActivityEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap21"});
        }
        this.getModel().setDataChanged(false);
    }

    private void mpRuleFlexVisible() {
        if (!PERF_PARAM_CONFIG_APPLICATION_SERVICE.isOpenPerfSum()) {
            Boolean isNeedMpGenWay = (Boolean)this.getModel().getValue(IS_NEEDMPGENWAY);
            if (isNeedMpGenWay.booleanValue()) {
                this.initFormula();
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
            return;
        }
        DynamicObject scheme = this.getModel().getDataEntity().getDynamicObject("scheme");
        if (scheme.getDynamicObject("mpsoptimetag") != null) {
            boolean showMpruleFlex;
            DynamicObject excutescheme = this.getModel().getDataEntity().getDynamicObject("executescheme");
            boolean bl = showMpruleFlex = excutescheme.getDynamicObject("timetag").getLong("id") == scheme.getDynamicObject("mpsoptimetag").getLong("ID");
            if (showMpruleFlex) {
                this.setMpRuleDefaultValue();
            }
            this.setMustInputValue();
            this.getView().setVisible(Boolean.valueOf(showMpruleFlex), new String[]{"flexpanelap4"});
        } else {
            DynamicObject cycleType = scheme.getDynamicObject("cycletype");
            String tagName = this.getModel().getDataEntity().getDynamicObject("executescheme").getDynamicObject("timetag").getString("name");
            ActivityTimeStampEnums timeStampEnums = ActivityTimeStampEnums.getEndTimeStampByType((Long)cycleType.getLong("id"));
            boolean showMpruleFlex = false;
            if (timeStampEnums != null) {
                showMpruleFlex = HRStringUtils.equalsIgnoreCase((String)tagName, (String)timeStampEnums.getTag());
            }
            if (this.getModel().getValue(MP_GENWAY) == null || "".equals(this.getModel().getValue(MP_GENWAY))) {
                this.getModel().setValue(MP_GENWAY, (Object)1);
                this.getView().updateView(MP_GENWAY);
            }
            this.setMustInputValue();
            if ((CYCLE_YEAR.longValue() == cycleType.getLong("id") && scheme.getBoolean("isperiodassess") || CYCLE_YEAR.longValue() != cycleType.getLong("id")) && showMpruleFlex) {
                this.setMpRuleDefaultValue();
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
            }
        }
        boolean enable = "20".equals(this.getModel().getValue("activitystatus"));
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{IS_NEEDMPGENWAY, MP_GENWAY, "mpruleset"});
        this.getView().updateView(IS_NEEDMPGENWAY);
        this.getView().updateView(MP_GENWAY);
        this.getView().updateView("mpruleset");
    }

    private void setTreeEntryEntityDefaultValue() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter valueSetter = new TableValueSetter(new String[0]);
        valueSetter.addField(TREE_PERIOD, new Object[0]);
        valueSetter.addField(TREE_DATE_RANGE_FIELD, new Object[0]);
        long schemeId = this.getModel().getDataEntity().getLong("executescheme.scheme.id");
        DynamicObject schemeDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.querySchemeById(schemeId);
        Date dateTime = this.getModel().getDataEntity().getDate("year");
        boolean isPeriodAssess = schemeDynObj.getBoolean("isperiodassess");
        if (isPeriodAssess) {
            DynamicObjectCollection periodConfColl = schemeDynObj.getDynamicObjectCollection("periodconfentity");
            LinkedHashMap<String, String> parentMap = new LinkedHashMap<String, String>(16);
            for (int i = 0; i < periodConfColl.size(); ++i) {
                DynamicObject entryEntity = (DynamicObject)periodConfColl.get(i);
                long cycleTypeId = entryEntity.getLong("pcycletype.id");
                if (i > 0) {
                    parentMap.put(CYCLE_TYPE_MAP.get(cycleTypeId), CYCLE_TYPE_MAP.get(((DynamicObject)periodConfColl.get(i - 1)).getLong("pcycletype.id")));
                    continue;
                }
                parentMap.put(CYCLE_TYPE_MAP.get(cycleTypeId), "P0");
            }
            List<CyclePeriodDateRange> cyclePeriodDateRanges = CyclePeriodDateRange.genAllCyclePeriodDateRange(parentMap, periodConfColl, dateTime);
            for (CyclePeriodDateRange cyclePeriodDataRange : cyclePeriodDateRanges) {
                this.createTopPeriodDateRange(cyclePeriodDataRange);
            }
        } else {
            DynamicObject cycleSchemeDynObj = schemeDynObj.getDynamicObject("cyclescheme");
            DynamicObject cycleTypeDynObj = schemeDynObj.getDynamicObject("cycletype");
            int year = HRDateTimeUtils.getYear((Date)dateTime);
            List<CyclePeriodDateRange> cyclePeriodDateRanges = CyclePeriodDateRange.genCyclePeriodDateRange(cycleSchemeDynObj, cycleTypeDynObj, year);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String newDateStr = "";
            try {
                for (CyclePeriodDateRange periodAndDateRange : cyclePeriodDateRanges) {
                    String[] dateRange = periodAndDateRange.getDateRange().split("~");
                    Date startDate = formatter.parse(dateRange[0]);
                    Date endDate = formatter.parse(dateRange[1]);
                    newDateStr = periodAndDateRange.getDateRange();
                    if (startDate.compareTo(endDate) > 0) {
                        String[] dateStr = dateRange[1].split("-");
                        dateStr[0] = Integer.parseInt(dateStr[0]) + 1 + "";
                        newDateStr = dateRange[0] + "~" + dateStr[0] + "-" + dateStr[1] + "-" + dateStr[2];
                    }
                    valueSetter.addRow(new Object[]{periodAndDateRange.getFormatPeriod(), newDateStr});
                }
            }
            catch (ParseException e) {
                LOGGER.error(e.getMessage());
            }
        }
        model.batchCreateNewEntryRow(TREE_ENTRY_ENTITY, valueSetter);
        model.endInit();
        this.getView().updateView(TREE_ENTRY_ENTITY);
    }

    private void createTopPeriodDateRange(CyclePeriodDateRange topCyclePeriodDataRange) {
        int createNewEntryRow = this.getModel().createNewEntryRow(TREE_ENTRY_ENTITY);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, createNewEntryRow);
        entryRowEntity.set(TREE_PERIOD, (Object)topCyclePeriodDataRange.getFormatPeriod());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String[] dateRange = topCyclePeriodDataRange.getDateRange().split("~");
        String newDateStr = topCyclePeriodDataRange.getDateRange();
        try {
            Date startDate = formatter.parse(dateRange[0]);
            Date endDate = formatter.parse(dateRange[1]);
            if (startDate.compareTo(endDate) > 0) {
                String[] dateStr = dateRange[1].split("-");
                dateStr[0] = Integer.parseInt(dateStr[0]) + 1 + "";
                newDateStr = dateRange[0] + "~" + dateStr[0] + "-" + dateStr[1] + "-" + dateStr[2];
            }
            entryRowEntity.set(TREE_DATE_RANGE_FIELD, (Object)newDateStr);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage());
        }
        List<CyclePeriodDateRange> children = topCyclePeriodDataRange.getChildCyclePeriodDateRange();
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (CyclePeriodDateRange childrenNode : children) {
            this.createChildPeriodDateRange(childrenNode, createNewEntryRow);
        }
    }

    private void createChildPeriodDateRange(CyclePeriodDateRange childPeriodDateRange, int position) {
        int insertEntryRow = this.getModel().insertEntryRow(TREE_ENTRY_ENTITY, position);
        DynamicObject childRowEntity = this.getModel().getEntryRowEntity(TREE_ENTRY_ENTITY, insertEntryRow);
        childRowEntity.set(TREE_PERIOD, (Object)childPeriodDateRange.getFormatPeriod());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String[] dateRange = childPeriodDateRange.getDateRange().split("~");
        String newDateStr = childPeriodDateRange.getDateRange();
        try {
            Date startDate = formatter.parse(dateRange[0]);
            Date endDate = formatter.parse(dateRange[1]);
            if (startDate.compareTo(endDate) > 0) {
                String[] dateStr = dateRange[1].split("-");
                dateStr[0] = Integer.parseInt(dateStr[0]) + 1 + "";
                newDateStr = dateRange[0] + "~" + dateStr[0] + "-" + dateStr[1] + "-" + dateStr[2];
            }
            childRowEntity.set(TREE_DATE_RANGE_FIELD, (Object)newDateStr);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage());
        }
        List<CyclePeriodDateRange> childrenPeriodDateRangeList = childPeriodDateRange.getChildCyclePeriodDateRange();
        if (CollectionUtils.isEmpty(childrenPeriodDateRangeList)) {
            return;
        }
        for (CyclePeriodDateRange tempChildPeriodDateRange : childrenPeriodDateRangeList) {
            this.createChildPeriodDateRange(tempChildPeriodDateRange, insertEntryRow);
        }
    }

    private void setDefaultValueByCustom() {
        this.setYearAndExecuteScheme();
        BillOperationStatus billStatus = ((BaseShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        if (BillOperationStatus.ADDNEW.equals((Object)billStatus)) {
            Date yearDateTime = this.getModel().getDataEntity().getDate("year");
            int yearInt = HRDateTimeUtils.getYear((Date)yearDateTime);
            this.setPeriodNameAndPeriod(yearInt);
            this.setNameAndNumber(yearInt);
            this.setActivityStartAndEndDate();
            this.setPassNodeSettingValue();
        } else {
            String activityStatus = this.getModel().getDataEntity().getString("activitystatus");
            if (ActivityStatusEnum.EXECUTING.getValue().equals(activityStatus) || ActivityStatusEnum.COMPLETED.getValue().equals(activityStatus)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield"});
            }
        }
    }

    private void setPassNodeSettingValue() {
        DynamicObject executeSchemeDy = this.getModel().getDataEntity().getDynamicObject("executescheme");
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"0");
        filter.and(new QFilter("excutescheme", "=", (Object)executeSchemeDy.getLong("id")));
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"epa_processpermsetting", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"createtime desc");
        if (datas.length > 0) {
            this.getModel().setValue("processpermsetting", datas[0].getPkValue());
        }
    }

    private void setNameAndNumber(int yearInt) {
        DynamicObject executeSchemeDy = this.getModel().getDataEntity().getDynamicObject("executescheme");
        String activityName = String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s\u8003\u6838\u6d3b\u52a8", (String)"EvaluationActivityEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), String.valueOf(yearInt), executeSchemeDy.getString("timetag.name"), executeSchemeDy.getString("assessscope.name"));
        this.getModel().setValue("name", (Object)activityName);
        String number = CodeRuleServiceHelper.getNumber((String)"epa_activity", (DynamicObject)this.getModel().getDataEntity(), null);
        if (!HRStringUtils.isEmpty((String)number)) {
            this.getModel().setValue("number", (Object)number);
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
    }

    private void setPeriodNameAndPeriod(int yearInt) {
        long timeTagId = this.getModel().getDataEntity().getLong("executescheme.timetag.id");
        DynamicObject timeTag = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryTimmTag(timeTagId);
        String period = yearInt + timeTag.getString("name");
        String periodName = this.getPeriodName(timeTag, yearInt);
        this.getModel().setValue("period", (Object)period);
        this.getModel().setValue("periodname", (Object)periodName);
    }

    private void setYearAndExecuteScheme() {
        Object year = this.getView().getFormShowParameter().getCustomParam("year");
        Object executeScheme = this.getView().getFormShowParameter().getCustomParam("executescheme");
        if (!Objects.isNull(year)) {
            this.getModel().setValue("year", year);
            this.getView().setEnable(Boolean.FALSE, new String[]{"year"});
        }
        if (!Objects.isNull(executeScheme)) {
            this.getModel().setValue("executescheme", executeScheme);
            this.getModel().setValue("scheme", (Object)this.getModel().getDataEntity().getLong("executescheme.scheme.id"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"executescheme"});
        }
    }

    private void setActivityStartAndEndDate() {
        int year = HRDateTimeUtils.getYear((Date)this.getModel().getDataEntity().getDate("year"));
        long schemeId = this.getModel().getDataEntity().getLong("scheme.id");
        String timeTagName = this.getModel().getDataEntity().getString("executescheme.timetag.name");
        Map<Long, Map<String, DynamicObject>> schemeIdCycleSchemeMap = this.getCycleSchemeDynObjMap();
        Map<String, DynamicObject> periodFlagPeriodConfMap = schemeIdCycleSchemeMap.get(schemeId);
        Date periodStartDate = null;
        Date periodEndDate = null;
        DynamicObject periodConfDynObj = periodFlagPeriodConfMap.get(timeTagName);
        if (periodConfDynObj != null) {
            String periodStart = periodConfDynObj.getString("periodstart");
            String periodEnd = periodConfDynObj.getString("periodend");
            try {
                periodStartDate = HRDateTimeUtils.parseDate((String)(year + "-" + periodStart));
                if (periodStart.compareTo(periodEnd) > 0) {
                    ++year;
                }
                periodEndDate = HRDateTimeUtils.parseDate((String)(year + "-" + periodEnd));
            }
            catch (ParseException e) {
                LOGGER.error((Throwable)e);
            }
        }
        this.getModel().setValue("periodstartdate", periodStartDate);
        this.getModel().setValue("periodenddate", periodEndDate);
    }

    private Map<Long, Map<String, DynamicObject>> getCycleSchemeDynObjMap() {
        long schemeId = this.getModel().getDataEntity().getLong("scheme.id");
        List<Long> schemeIdList = Collections.singletonList(schemeId);
        DynamicObject[] schemeDynObjArr = ASSESS_SCHEME_APPLICATION_SERVICE.getSchemeArrBySchemeIdList(schemeIdList);
        HashMap<Long, Map<String, DynamicObject>> schemeIdCycleSchemeMap = new HashMap<Long, Map<String, DynamicObject>>(16);
        for (DynamicObject schemeDynObj : schemeDynObjArr) {
            long tempSchemeId = schemeDynObj.getLong("id");
            Map cycleSchemeDynObjMap = schemeIdCycleSchemeMap.computeIfAbsent(tempSchemeId, k -> new HashMap(16));
            if (schemeDynObj.getBoolean("isperiodassess")) {
                DynamicObjectCollection periodConfColl = schemeDynObj.getDynamicObjectCollection("periodconfentity");
                for (DynamicObject periodConfDynObj : periodConfColl) {
                    DynamicObjectCollection periodConfEntryEntity = periodConfDynObj.getDynamicObjectCollection("pcyclescheme.entryentity");
                    if (periodConfEntryEntity == null) continue;
                    for (DynamicObject entryEntity : periodConfEntryEntity) {
                        cycleSchemeDynObjMap.put(entryEntity.getString("periodflag"), entryEntity);
                    }
                }
                continue;
            }
            DynamicObject cycleSchemeDynObj = schemeDynObj.getDynamicObject("cyclescheme");
            if (cycleSchemeDynObj == null) continue;
            DynamicObjectCollection cycleSchemeSettingColl = cycleSchemeDynObj.getDynamicObjectCollection("entryentity");
            Map<String, DynamicObject> periodFlagCycleSchemeMap = cycleSchemeSettingColl.stream().collect(Collectors.toMap(periodConf -> periodConf.getString("periodflag"), periodConf -> periodConf));
            cycleSchemeDynObjMap.putAll(periodFlagCycleSchemeMap);
        }
        return schemeIdCycleSchemeMap;
    }

    private String getPeriodName(DynamicObject timeTag, int yearInt) {
        DynamicObject cycleType = timeTag.getDynamicObject("cycletype");
        String periodName = ResManager.loadKDString((String)"%1$s\u5e74", (String)"EvaluationActivityEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{yearInt});
        if (!HRStringUtils.equals((String)timeTag.getString("number"), (String)"101010_S")) {
            periodName = HRStringUtils.equals((String)timeTag.getString("number"), (String)"102010_S") ? ResManager.loadKDString((String)"%1$s\u4e0a\u534a\u5e74", (String)"EvaluationActivityEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{periodName}) : (HRStringUtils.equals((String)timeTag.getString("number"), (String)"102020_S") ? ResManager.loadKDString((String)"%1$s\u4e0b\u534a\u5e74", (String)"EvaluationActivityEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{periodName}) : periodName + timeTag.getString("name").substring(1) + cycleType.getString("name"));
        }
        return periodName;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "": 
            case "executescheme": {
                this.setAssessFormAndWorkFlow();
                break;
            }
            case "periodstartdate": 
            case "periodenddate": {
                this.updateTreeEntryDateRange();
                break;
            }
            case "isneedmpgenway": 
            case "mpgenway": {
                if (e.getChangeSet()[0].getNewValue() == null || "".equals(e.getChangeSet()[0].getNewValue())) {
                    this.getModel().setValue(MP_GENWAY, e.getChangeSet()[0].getOldValue());
                    break;
                }
                this.setMpRuleVisible();
                break;
            }
        }
    }

    private void updateTreeEntryDateRange() {
        String period = this.getModel().getDataEntity().getString("period");
        long schemeId = this.getModel().getDataEntity().getLong("scheme.id");
        long assessScopeId = this.getModel().getDataEntity().getLong("executescheme.assessscope.id");
        DynamicObject[] createdActivityArrByScheme = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryActivityArrBySchemeId(schemeId, assessScopeId);
        Map<String, DynamicObject> periodActivityDynObjMap = Arrays.stream(createdActivityArrByScheme).collect(Collectors.toMap(activityDynObj -> activityDynObj.getString("period"), activityDynObj -> activityDynObj));
        DynamicObjectCollection treePeriodDynObjColl = this.getModel().getDataEntity(true).getDynamicObjectCollection(TREE_ENTRY_ENTITY);
        boolean updateTreeEntryFlag = false;
        for (DynamicObject treePeriodDynObj : treePeriodDynObjColl) {
            DynamicObject activityDynObj2;
            String formatEndDate;
            String treePeriod = treePeriodDynObj.getString(TREE_PERIOD);
            if (treePeriod.equals(period)) {
                String formatStartDate;
                Date startDate = this.getModel().getDataEntity().getDate("periodstartdate");
                Date endDate = this.getModel().getDataEntity().getDate("periodenddate");
                if (startDate != null && endDate == null) {
                    formatStartDate = HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
                    treePeriodDynObj.set(TREE_DATE_RANGE_FIELD, (Object)formatStartDate);
                }
                if (endDate != null && startDate == null) {
                    formatEndDate = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
                    treePeriodDynObj.set(TREE_DATE_RANGE_FIELD, (Object)formatEndDate);
                }
                if (startDate != null && endDate != null) {
                    formatStartDate = HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
                    String formatEndDate2 = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
                    treePeriodDynObj.set(TREE_DATE_RANGE_FIELD, (Object)(formatStartDate + "~" + formatEndDate2));
                }
                updateTreeEntryFlag = true;
            }
            if ((activityDynObj2 = periodActivityDynObjMap.get(treePeriod)) == null) continue;
            String formatStartDate = HRDateTimeUtils.format((Date)activityDynObj2.getDate("periodstartdate"), (String)"yyyy-MM-dd");
            formatEndDate = HRDateTimeUtils.format((Date)activityDynObj2.getDate("periodenddate"), (String)"yyyy-MM-dd");
            treePeriodDynObj.set(TREE_DATE_RANGE_FIELD, (Object)(formatStartDate + "~" + formatEndDate));
            updateTreeEntryFlag = true;
        }
        if (updateTreeEntryFlag) {
            this.getView().updateView(TREE_ENTRY_ENTITY);
        }
    }

    private void setAssessFormAndWorkFlow() {
        if (this.getModel().getDataEntity().getDynamicObject("assessform") == null) {
            DynamicObject assessFormDynObj = this.getModel().getDataEntity().getDynamicObject("executescheme.assessform");
            this.getModel().setValue("assessform", (Object)assessFormDynObj);
        }
        if (this.getModel().getDataEntity().getDynamicObject("perfworkflow") == null) {
            DynamicObject perfWorkFlowDynObj = this.getModel().getDataEntity().getDynamicObject("executescheme.perfworkflow");
            this.getModel().setValue("perfworkflow", (Object)perfWorkFlowDynObj);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject assessActivity;
        long activityId;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        String caption = FormMetadataCache.getFormConfig((String)"epa_activity").getCaption().getLocaleValue();
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"47156aff000000ac");
        if (!hasPermission) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EvaluationActivityEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]), caption));
            args.setCancel(true);
            return;
        }
        this.setMustInputValue();
        if ("donothing_savestartup".equals(operateKey) && (activityId = this.getView().getModel().getDataEntity().getLong("id")) != 0L && !HRStringUtils.equals((String)(assessActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId)).getString("activitystatus"), (String)ActivityStatusEnum.TO_BE_EXECUTE.getValue())) {
            String message = "";
            switch (assessActivity.getString("activitystatus")) {
                case "30": {
                    message = ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u6267\u884c\u4e2d\uff0c\u4e0d\u652f\u6301\u518d\u6b21\u542f\u52a8\u3002", (String)"EvaluationActivityEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "40": {
                    message = ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u4e0d\u652f\u6301\u518d\u6b21\u542f\u52a8\u3002", (String)"EvaluationActivityEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    break;
                }
            }
            this.getView().showErrorNotification(message);
            args.setCancel(true);
            this.getView().invokeOperation("refresh");
        }
        if ("mpruleset".equals(operateKey)) {
            args.setCancel(true);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("epa_mpruleset");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mpruleset"));
            formShowParameter.setCustomParam("scheme", (Object)this.getModel().getDataEntity().getDynamicObject("scheme").getLong("id"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            if (StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get("tempvo"))) {
                if (this.getModel().getValue("mprule") != null) {
                    MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
                    ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
                    MpRuleUtils.buildVoByMpRule((DynamicObject)this.getModel().getValue("mprule"), mpRuleSetVO, entryentities);
                    formShowParameter.setCustomParam("tempvo", JSON.toJSON((Object)mpRuleSetVO));
                }
            } else {
                formShowParameter.setCustomParam("tempvo", (Object)this.getView().getPageCache().get("tempvo"));
            }
            this.getView().showForm(formShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("donothing_save".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().getPageCache().put("savestartup", "false");
            DynamicObject executeSchemeDynObj = this.getModel().getDataEntity().getDynamicObject("executescheme");
            long executeSchemeId = executeSchemeDynObj.getLong("id");
            try (DataMutex dataMutex = DataMutex.create();){
                MutexLockInfo mutexLockInfo = new MutexLockInfo();
                mutexLockInfo.setDataObjId(String.valueOf(executeSchemeId));
                mutexLockInfo.setEntityNumber("epa_executescheme");
                mutexLockInfo.setOperationKey("modify");
                mutexLockInfo.setStrict(true);
                mutexLockInfo.setCallSource("default");
                mutexLockInfo.setDataObjNumber(executeSchemeDynObj.getString("name"));
                boolean require = dataMutex.require(mutexLockInfo);
                if (!require) {
                    String lockMsg = String.format(ResManager.loadKDString((String)"%s-\u8be5\u8003\u6838\u6267\u884c\u8ba1\u5212\u6b63\u5728\u751f\u6210\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"EvaluationActivityEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]), this.getModel().getDataEntity().getString("executescheme.name"));
                    this.getView().showErrorNotification(lockMsg);
                    return;
                }
                DynamicObject rule = null;
                boolean genway = false;
                if (!"".equals(this.getModel().getValue(MP_GENWAY)) && this.getModel().getValue(MP_GENWAY) != null) {
                    boolean bl = genway = Integer.parseInt((String)this.getModel().getValue(MP_GENWAY)) != 2;
                }
                if (this.getModel().getDataEntity().getDynamicObject("scheme").getDynamicObject("mprule") != null && ((Boolean)this.getModel().getValue(IS_NEEDMPGENWAY)).booleanValue() && genway) {
                    MpRuleSetVO mpRuleSetVO = this.getMpRuleSetVO();
                    rule = this.getModel().getDataEntity().getDynamicObject("mprule") != null && this.getModel().getDataEntity().getDynamicObject("mprule").getLong("id") != this.getModel().getDataEntity().getDynamicObject("scheme").getDynamicObject("mprule").getLong("id") ? MP_RULE_ENTITY_SERVICE.saveByVo(mpRuleSetVO, Long.valueOf(this.getModel().getDataEntity().getDynamicObject("mprule").getLong("id"))) : MP_RULE_ENTITY_SERVICE.saveByVo(mpRuleSetVO, Long.valueOf(0L));
                    this.getModel().setValue("mprule", (Object)rule);
                } else {
                    this.getModel().setValue("mprule", null);
                }
                this.getView().invokeOperation("save");
                dataMutex.release(String.valueOf(executeSchemeId), "epa_executescheme", "modify");
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                String errorMsg = ResManager.loadKDString((String)"\u751f\u6210\u8003\u6838\u6d3b\u52a8\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EvaluationActivityEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
            }
        } else if ("donothing_savestartup".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().getPageCache().put("savestartup", "true");
            DynamicObject executeSchemeDynObj = this.getModel().getDataEntity().getDynamicObject("executescheme");
            long executeSchemeId = executeSchemeDynObj.getLong("id");
            try (DataMutex dataMutex = DataMutex.create();){
                MutexLockInfo mutexLockInfo = new MutexLockInfo();
                mutexLockInfo.setDataObjId(String.valueOf(executeSchemeId));
                mutexLockInfo.setEntityNumber("epa_executescheme");
                mutexLockInfo.setOperationKey("modify");
                mutexLockInfo.setStrict(true);
                mutexLockInfo.setCallSource("default");
                mutexLockInfo.setDataObjNumber(executeSchemeDynObj.getString("name"));
                boolean require = dataMutex.require(mutexLockInfo);
                if (!require) {
                    String lockMsg = String.format(ResManager.loadKDString((String)"%s-\u8be5\u8003\u6838\u6267\u884c\u8ba1\u5212\u6b63\u5728\u751f\u6210\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"EvaluationActivityEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]), this.getModel().getDataEntity().getString("executescheme.name"));
                    this.getView().showErrorNotification(lockMsg);
                    return;
                }
                DynamicObject rule = null;
                boolean genway = false;
                if (!"".equals(this.getModel().getValue(MP_GENWAY)) && this.getModel().getValue(MP_GENWAY) != null) {
                    boolean bl = genway = Integer.parseInt((String)this.getModel().getValue(MP_GENWAY)) != 2;
                }
                if (this.getModel().getDataEntity().getDynamicObject("scheme").getDynamicObject("mprule") != null && ((Boolean)this.getModel().getValue(IS_NEEDMPGENWAY)).booleanValue() && genway) {
                    MpRuleSetVO mpRuleSetVO = this.getMpRuleSetVO();
                    rule = this.getModel().getDataEntity().getDynamicObject("mprule") != null && this.getModel().getDataEntity().getDynamicObject("mprule").getLong("id") != this.getModel().getDataEntity().getDynamicObject("scheme").getDynamicObject("mprule").getLong("id") ? MP_RULE_ENTITY_SERVICE.saveByVo(mpRuleSetVO, Long.valueOf(this.getModel().getDataEntity().getDynamicObject("mprule").getLong("id"))) : MP_RULE_ENTITY_SERVICE.saveByVo(mpRuleSetVO, Long.valueOf(0L));
                    this.getModel().setValue("mprule", (Object)rule);
                } else {
                    this.getModel().setValue("mprule", null);
                }
                this.getView().invokeOperation("save");
                dataMutex.release(String.valueOf(executeSchemeId), "epa_executescheme", "modify");
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                String errorMsg = ResManager.loadKDString((String)"\u751f\u6210\u8003\u6838\u6d3b\u52a8\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EvaluationActivityEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
            }
        } else if ("save".equals(operateKey) && operationResult.isSuccess()) {
            String savestartup = this.getView().getPageCache().get("savestartup");
            if ("true".equals(savestartup)) {
                operationResult.setShowMessage(Boolean.FALSE.booleanValue());
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_activitystartup");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("activity_id", (Object)this.getView().getModel().getDataEntity().getLong("id"));
                Date startDate = this.getModel().getDataEntity().getDate("periodstartdate");
                Date endDate = this.getModel().getDataEntity().getDate("periodenddate");
                if (startDate != null && endDate != null) {
                    String formatStartDate = HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
                    String formatEndDate = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
                    showParameter.setCustomParam("periodstartdate", (Object)formatStartDate);
                    showParameter.setCustomParam("periodenddate", (Object)formatEndDate);
                }
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_activity"));
                this.getView().showForm(showParameter);
            }
        } else if ("refresh".equals(operateKey)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonsavestart"});
        }
    }

    private MpRuleSetVO getMpRuleSetVO() {
        MpRuleSetVO mpRuleSetVO = null;
        if (!StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get("tempvo"))) {
            mpRuleSetVO = (MpRuleSetVO)JSON.parseObject((String)this.getView().getPageCache().get("tempvo"), MpRuleSetVO.class);
        }
        if (mpRuleSetVO == null) {
            mpRuleSetVO = new MpRuleSetVO();
            ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
            mpRuleSetVO.setEntryentities(entryentities);
            Long mpRuleId = this.getModel().getDataEntity().getDynamicObject("scheme").getDynamicObject("mprule").getLong("id");
            DynamicObject mpRule = MP_RULE_ENTITY_SERVICE.queryOne(mpRuleId);
            MpRuleUtils.buildVoByMpRule(mpRule, mpRuleSetVO, entryentities);
        }
        return mpRuleSetVO;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        long actId = this.getView().getModel().getDataEntity().getLong("id");
        String actName = this.getView().getModel().getDataEntity().getString("name");
        switch (actionId) {
            case "epa_activity": {
                Map result = (Map)closedCallBackEvent.getReturnData();
                if (result == null) {
                    return;
                }
                Long activityId = (Long)result.get("activityId");
                DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
                activityDynObj.set("activitystatus", (Object)ActivityStatusEnum.EXECUTING.getValue());
                activityDynObj.set("startupdate", (Object)new Date());
                ASSESS_ACTIVITY_APPLICATION_SERVICE.updateActivityDynObj(activityDynObj);
                if (HRStringUtils.equals((String)((String)result.get("data")), (String)"1")) {
                    this.startUpAddEvaluationObjects(activityId);
                    break;
                }
                this.getView().invokeOperation("refresh");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_activitysaveandstart");
                showParameter.getCustomParams().put("activityId", actId);
                showParameter.getCustomParams().put("activityName", actName);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u63d0\u793a", (String)"EvaluationActivityEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                showParameter.setHasRight(true);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_activitysaveandstart"));
                showParameter.getCustomParams().put("source", this.getView().getFormShowParameter().getCustomParam("source"));
                this.getView().showForm(showParameter);
                break;
            }
            case "auto_add_evaluation_objects": {
                Map resultMap = (Map)closedCallBackEvent.getReturnData();
                if (resultMap == null) {
                    return;
                }
                ArrayList<Long> activityIds = new ArrayList<Long>(10);
                activityIds.add(actId);
                Map map = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.countActObjStatusByActivityIds(activityIds);
                ActObjStatBo actObjStatBo = (ActObjStatBo)map.get(actId);
                String title = null;
                title = actObjStatBo != null ? ResManager.loadKDString((String)"\u6210\u529f\u6dfb\u52a0{0}\u6761\u3002", (String)"EvaluationActivityEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{actObjStatBo.getJoined()}) : ResManager.loadKDString((String)"\u6210\u529f\u6dfb\u52a0{0}\u6761\u3002", (String)"EvaluationActivityEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{0});
                this.getView().invokeOperation("refresh");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_activitysaveandstart");
                showParameter.getCustomParams().put("title", title);
                showParameter.getCustomParams().put("activityId", actId);
                showParameter.getCustomParams().put("activityName", actName);
                showParameter.getCustomParams().put("source", this.getView().getFormShowParameter().getCustomParam("source"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u63d0\u793a", (String)"EvaluationActivityEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                showParameter.setHasRight(true);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_activitysaveandstart"));
                this.getView().showForm(showParameter);
                break;
            }
            case "epa_activitysaveandstart": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (HRObjectUtils.isEmpty((Object)returnData)) {
                    return;
                }
                Long activityId = (Long)returnData.get("activityId");
                String activityName = (String)returnData.get("activityName");
                BaseShowParameter baseShowParameter = new BaseShowParameter();
                baseShowParameter.setFormId("epa_processmanage");
                baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                baseShowParameter.setStatus(OperationStatus.VIEW);
                baseShowParameter.setPkId((Object)activityId);
                baseShowParameter.setPageId(this.getView().getPageId() + this.getView().getFormShowParameter().getAppId() + activityId);
                String caption = String.format(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406-%s", (String)"EvaluationActivityEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]), activityName);
                baseShowParameter.setCaption(caption);
                this.getView().showForm((FormShowParameter)baseShowParameter);
                break;
            }
            case "mpruleset": {
                MpRuleSetVO returndata = (MpRuleSetVO)closedCallBackEvent.getReturnData();
                if (returndata == null) break;
                this.getModel().setValue("mpruleformula", (Object)returndata.getMpformula());
                this.getView().updateView("mpruleformula");
                this.getView().getPageCache().put("tempvo", JSON.toJSONString((Object)returndata));
            }
        }
    }

    private void startUpAddEvaluationObjects(Long activityId) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("activity_id", activityId);
        ActivityDispatchUtils.dispatch((AbstractFormPlugin)this, params, StartUpActivityAddActObjectTask.class.getName(), ResManager.loadKDString((String)"\u542f\u52a8\u6d3b\u52a8", (String)"EvaluationActivityEdit_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]), true, "auto_add_evaluation_objects");
    }

    private void hideSaveandStartupButton() {
        DynamicObject assessActivity;
        long activityId = this.getView().getModel().getDataEntity().getLong("id");
        if (activityId != 0L && !HRStringUtils.equals((String)(assessActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId)).getString("activitystatus"), (String)ActivityStatusEnum.TO_BE_EXECUTE.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonsavestart"});
        }
    }

    private void setMpRuleVisible() {
        Boolean visible = (Boolean)this.getModel().getValue(IS_NEEDMPGENWAY);
        DynamicObject cycleType = this.getModel().getDataEntity().getDynamicObject("scheme").getDynamicObject("cycletype");
        if (cycleType != null) {
            if (CYCLE_YEAR.longValue() == cycleType.getLong("id") && !this.getModel().getDataEntity().getDynamicObject("scheme").getBoolean("isperiodassess")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
            } else if (CYCLE_YEAR.longValue() == cycleType.getLong("id") && this.getModel().getDataEntity().getDynamicObject("scheme").getBoolean("isperiodassess")) {
                this.lableSetText("labelap31", ResManager.loadKDString((String)"\u5e74\u5ea6\u9700\u6c47\u603b", (String)"EvaluationActivityEdit_15", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
                this.lableSetText("labelap4", ResManager.loadKDString((String)"\uff08\u5f00\u542f\u540e\uff0c\u5e74\u5ea6\u7ed3\u679c\u53ef\u7531\u5404\u8003\u6838\u5468\u671f\u7ed3\u679c\u4e0e\u5e74\u5ea6\u8bc4\u4f30\u7ed3\u679c\u6c47\u603b\u751f\u6210\u3002\uff09", (String)"EvaluationActivityEdit_16", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(MP_GENWAY, (Object)1);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{MP_GENWAY});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap4"});
            } else {
                this.lableSetText("labelap31", ResManager.loadKDString((String)"\u751f\u6210\u5e74\u5ea6\u7ed3\u679c", (String)"EvaluationActivityEdit_17", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
                this.lableSetText("labelap4", ResManager.loadKDString((String)"\uff08\u5f00\u542f\u540e\uff0c\u9ed8\u8ba4\u8003\u6838\u8ba1\u5212\u5185\u6700\u540e\u4e00\u4e2a\u8003\u6838\u5468\u671f\u5c06\u8fdb\u884c\u5e74\u5ea6\u7ed3\u679c\u751f\u6210\u3002\uff09", (String)"EvaluationActivityEdit_18", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{MP_GENWAY});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap4"});
            }
            if (visible.booleanValue()) {
                this.initFormula();
            }
            this.getView().setVisible(visible, new String[]{"flexpanelap52"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
        }
        IDataEntityProperty property = this.getModel().getProperty("mpruleformula");
        Boolean mustInput = false;
        if (!"".equals(this.getModel().getValue(MP_GENWAY)) && this.getModel().getValue(MP_GENWAY) != null) {
            mustInput = Integer.parseInt((String)this.getModel().getValue(MP_GENWAY)) != 2;
        }
        if (property instanceof FieldProp) {
            ((FieldProp)property).setMustInput(visible != false && mustInput != false);
        } else if (property instanceof BasedataProp) {
            ((BasedataProp)property).setMustInput(visible != false && mustInput != false);
        }
        this.getView().setVisible(mustInput, new String[]{"flexpanelap71"});
    }

    private void initFormula() {
        MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
        ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
        mpRuleSetVO.setEntryentities(entryentities);
        if (!StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get("tempvo"))) {
            mpRuleSetVO = (MpRuleSetVO)JSON.parseObject((String)this.getView().getPageCache().get("tempvo"), MpRuleSetVO.class);
        } else if (this.getModel().getValue("mprule") != null) {
            Long ruleId = this.getModel().getDataEntity().getDynamicObject("mprule").getLong("id");
            DynamicObject mpRuleDyn = MP_RULE_ENTITY_SERVICE.queryOne(ruleId);
            MpRuleUtils.buildVoByMpRule(mpRuleDyn, mpRuleSetVO, entryentities);
        } else if (((DynamicObject)this.getModel().getValue("scheme")).getDynamicObject("mprule") != null) {
            Long ruleId = this.getModel().getDataEntity().getDynamicObject("scheme").getDynamicObject("mprule").getLong("id");
            DynamicObject mpRuleDyn = MP_RULE_ENTITY_SERVICE.queryOne(ruleId);
            MpRuleUtils.buildVoByMpRule(mpRuleDyn, mpRuleSetVO, entryentities);
        } else {
            MpRuleUtils.buildMpRuleFromScheme(mpRuleSetVO, entryentities, (DynamicObject)this.getModel().getValue("scheme"));
            this.getModel().setValue("mpruleformula", (Object)mpRuleSetVO.getMpformula());
            this.getView().updateView("mpruleformula");
        }
        this.getModel().setValue("mpruleformula", (Object)mpRuleSetVO.getMpformula());
        this.getView().updateView("mpruleformula");
        this.getView().getPageCache().put("tempvo", JSON.toJSONString((Object)mpRuleSetVO));
    }

    private Boolean setMustInputValue() {
        Boolean visible = (Boolean)this.getModel().getValue(IS_NEEDMPGENWAY);
        IDataEntityProperty property = this.getModel().getProperty("mpruleformula");
        Boolean mustInput = false;
        if (!"".equals(this.getModel().getValue(MP_GENWAY)) && this.getModel().getValue(MP_GENWAY) != null) {
            mustInput = Integer.parseInt((String)this.getModel().getValue(MP_GENWAY)) != 2;
        }
        if (property instanceof FieldProp) {
            ((FieldProp)property).setMustInput(visible != false && mustInput != false);
        } else if (property instanceof BasedataProp) {
            ((BasedataProp)property).setMustInput(visible != false && mustInput != false);
        }
        return visible;
    }

    private void lableSetText(String key, String text) {
        IFormView view = this.getView();
        Label label = (Label)view.getControl(key);
        if (ObjectUtils.isEmpty((Object)label)) {
            return;
        }
        label.setText(text == null ? "" : text);
    }

    private void setMpRuleDefaultValue() {
        DynamicObject scheme = this.getModel().getDataEntity().getDynamicObject("scheme");
        if (this.getModel().getValue("mprule") == null && this.getModel().getDataEntity().getLong("id") == 0L) {
            this.getModel().setValue("isgenextmpsop", scheme.get("isgenextmpsop"));
            this.getModel().setValue("mpsopcategory", scheme.get("mpsopcategory"));
            this.getModel().setValue(MP_GENWAY, scheme.get(MP_GENWAY));
            this.getModel().setValue(IS_NEEDMPGENWAY, scheme.get(IS_NEEDMPGENWAY));
        }
        this.setMpRuleVisible();
    }
}

