/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;

public class GenAreaIndReqEdit
extends HRDataBaseEdit {
    private final AssessActivityApplicationService service = AssessActivityApplicationService.getInstance();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long instanceId = (Long)parameter.getCustomParam("instanceid");
        this.getModel().setValue("instanceid", (Object)instanceId);
        Integer indReqSize = (Integer)parameter.getCustomParam("indReqSize");
        this.getModel().setValue("entryseq", (Object)indReqSize);
        Boolean isAllowEval = (Boolean)parameter.getCustomParam("isAllowEval");
        this.getView().setVisible(isAllowEval, new String[]{"score"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (!HRStringUtils.equals((String)"save", (String)operateKey)) {
            return;
        }
        DynamicObject indicatorType = this.getModel().getDataEntity().getDynamicObject("indicatortype");
        Long instanceId = (Long)this.getModel().getValue("instanceid");
        String validateMsg = this.service.validateAssessTableIndicatorReq(instanceId, indicatorType);
        if (!HRStringUtils.isEmpty((String)validateMsg)) {
            this.getView().showErrorNotification(validateMsg);
            args.setCancel(true);
        }
        this.validateScore(args);
    }

    private void validateScore(BeforeDoOperationEventArgs args) {
        BigDecimal indicatorScore;
        String maxScoreOfSystemStr = this.getView().getParentView().getPageCache().get("maxScoreOfSystem");
        BigDecimal maxScoreOfSystem = new BigDecimal(maxScoreOfSystemStr);
        BigDecimal areaScore = (BigDecimal)this.getView().getParentView().getModel().getValue("areascore");
        DynamicObjectCollection indicatorEntry = this.getView().getParentView().getModel().getEntryEntity("indreqentity");
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        BigDecimal currentSum = indicatorEntry.stream().filter(Objects::nonNull).filter(indicator -> !indicator.getPkValue().equals(pkValue)).map(indicator -> indicator.getBigDecimal("score")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (currentSum.add(indicatorScore = (BigDecimal)this.getModel().getValue("score")).compareTo(areaScore) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u6307\u6807\u7c7b\u578b\u5206\u503c\u4e0d\u80fd\u8d85\u8fc7\u533a\u57df\u5206\u503c", (String)"GenAreaIndReqEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            this.validateMaxScoreSystem(args, maxScoreOfSystem, currentSum, indicatorScore);
        }
    }

    private void validateMaxScoreSystem(BeforeDoOperationEventArgs args, BigDecimal maxScoreOfSystem, BigDecimal currentSum, BigDecimal indicatorScore) {
        if (currentSum.add(indicatorScore).compareTo(maxScoreOfSystem) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u6307\u6807\u7c7b\u578b\u5206\u503c\u4e0d\u80fd\u8d85\u8fc7\u5206\u5236\u6700\u9ad8\u57fa\u51c6\u5206{0}", (String)"GenAreaIndReqEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{maxScoreOfSystem}));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTips();
    }

    private void initTips() {
        this.setTips("scoretype");
    }

    private void setTips(String key) {
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = this.service.getTips("epa_genareaindreq", key, dy);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipContent));
            props.put("tips", tips);
            this.getView().updateControlMetadata(key, props);
        }
    }
}

