/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.indicator.IndicatorGroupApplicationService;
import kd.opmc.epa.business.utils.NumberValidateUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.constants.AssessTableConfConstants;
import kd.opmc.epa.common.enums.assessrule.AdjustTypeEnum;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.activity.extpoint.AreaIndicatorPermissionService;
import kd.opmc.epa.formplugin.web.activity.extpoint.impl.AreaIndicatorPermissionServiceImpl;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class GenAreaIndicatorEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(GenAreaIndicatorEdit.class);
    private final AssessActivityApplicationService service = AssessActivityApplicationService.getInstance();
    private final IndicatorGroupApplicationService indicatorService = IndicatorGroupApplicationService.getInstance();
    private final Set<String> validateNumberFiled = Sets.newHashSet((Object[])new String[]{"qualitytarget", "qualitydare", "qualitybase", "qualityres"});
    private static final String MUST_INPUT = "mustinput";
    private static final String[] TEXTS = new String[]{"indctrname", "qualitytarget", "unit", "indctrnumber", "indctrsource", "customfiled1", "customfiled2"};
    private static final String[] BIGTEXTS = new String[]{"evaldesc"};
    private static final String[] MULLINE_TEXTS = new String[]{"indctrdesc", "evalcriteria", "remarks", "finishdesc", "customfiled3", "customfiled4", "customfiled5"};

    public GenAreaIndicatorEdit() {
        NumberValidateUtils.removeNotValidateField(this.validateNumberFiled);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        if (confId == null) {
            return;
        }
        DynamicObject conf = this.service.queryNormalConfigByPk(confId);
        Object evaSumLimitObj = formShowParameter.getCustomParam("evasumlimit");
        String evaSumLimit = "40";
        if (evaSumLimitObj instanceof String) {
            evaSumLimit = (String)evaSumLimitObj;
        }
        if (EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
            DrawAreaUtils.drawGenIndicatorField(args, conf, AssessTableConfConstants.GEN_IGNORE_FIELD, true);
        } else {
            DrawAreaUtils.drawIndicatorField(args, conf, AssessTableConfConstants.GEN_IGNORE_FIELD);
        }
    }

    private boolean isInIgnore(String[] ignores, String fieldKey) {
        for (String str : ignores) {
            if (HRStringUtils.isEmpty((String)fieldKey) || !HRStringUtils.equals((String)str, (String)fieldKey)) continue;
            return true;
        }
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        if (status != OperationStatus.ADDNEW) {
            return;
        }
        Long instanceId = (Long)parameter.getCustomParam("instanceid");
        this.getModel().setValue("instanceid", (Object)instanceId);
        Integer indReqSize = null == parameter.getCustomParam("indReqSize") ? Integer.valueOf(0) : (Integer)parameter.getCustomParam("indReqSize");
        this.getModel().setValue("entryseq", (Object)(indReqSize + 1));
        this.getModel().setValue("evaltype", (Object)"10");
        this.getModel().setValue("evalmode", (Object)"10");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTips();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryNormalConfigByPk(confId);
        boolean isAllowEval = conf.getBoolean("reversepoints");
        this.getView().setVisible(Boolean.valueOf(isAllowEval), new String[]{"scoreconfap"});
        if (isAllowEval) {
            if (HRStringUtils.equals((String)conf.getString("adjusttype"), (String)AdjustTypeEnum.NORMAL.getValue())) {
                this.getModel().setValue("minevalscore", (Object)conf.getBigDecimal("lowerscore"));
                this.getModel().setValue("maxevalscore", (Object)conf.getBigDecimal("upperscore"));
                this.getView().setEnable(Boolean.FALSE, new String[]{"minevalscore", "maxevalscore"});
            } else {
                DecimalEdit minevalscore = (DecimalEdit)this.getControl("minevalscore");
                minevalscore.setMustInput(true);
                DecimalEdit maxevalscore = (DecimalEdit)this.getControl("maxevalscore");
                maxevalscore.setMustInput(true);
            }
            this.getView().updateControlMetadata("minevalscore", DrawAreaUtils.getPcScItemMap(formShowParameter));
            this.getView().updateControlMetadata("maxevalscore", DrawAreaUtils.getPcScItemMap(formShowParameter));
        }
        this.getModel().setDataChanged(false);
        this.setTitleText(formShowParameter.getStatus(), conf);
        this.setLableOfCompleteProgersss();
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        HashSet<String> mustInputs = new HashSet<String>(16);
        for (Object fieldInfo : entryEntity) {
            LOG.info("GenAreaIndicatorEdit.afterBindData fieldInfo :{}", fieldInfo);
            DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
            LOG.info("GenAreaIndicatorEdit.afterBindData areaField :{}", (Object)areaField);
            if (!areaField.getBoolean("ismustinput")) continue;
            String fieldKey = fieldInfo.getString("areafield.number");
            LOG.info("GenAreaIndicatorEdit.afterBindData fieldKey :{},ignore: {}", (Object)fieldKey, (Object)AssessTableConfConstants.GEN_IGNORE_FIELD);
            if (this.isInIgnore(AssessTableConfConstants.GEN_IGNORE_FIELD, fieldKey)) continue;
            mustInputs.add(fieldKey);
        }
        StringBuffer mustInputsb = new StringBuffer();
        for (String must : mustInputs) {
            mustInputsb.append(must);
            mustInputsb.append(",");
        }
        String mustInputstr = mustInputsb.substring(0, mustInputsb.length() - 1);
        this.getPageCache().put(MUST_INPUT, mustInputstr);
        LOG.info("GenAreaIndicatorEdit.afterBindData mustInputs : {}", mustInputs);
    }

    private void setLableOfCompleteProgersss() {
        String tips;
        String progress;
        DynamicObjectCollection entryentity = this.getView().getParentView().getModel().getEntryEntity("entryentity");
        String scoreCalcWay = this.getView().getParentView().getPageCache().get("scorecalcway");
        BigDecimal currentSum = BigDecimal.ZERO;
        BigDecimal areaWeight = BigDecimal.ZERO;
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            currentSum = entryentity.stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal("weight")).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentSum = currentSum.subtract((BigDecimal)this.getView().getModel().getValue("weight"));
            areaWeight = (BigDecimal)this.getView().getParentView().getModel().getValue("areaweight");
            progress = currentSum.stripTrailingZeros().toPlainString() + "/" + areaWeight.stripTrailingZeros().toPlainString();
            tips = ResManager.loadKDString((String)"\u3010{0}\u3011\u663e\u793a\u533a\u57df\u7d2f\u8ba1\u6743\u91cd/\u533a\u57df\u603b\u6743\u91cd\uff0c\u4e0d\u542b\u5f53\u524d\u65b0\u589e\u6216\u7f16\u8f91\u7684\u6307\u6807\u3002", (String)"GenAreaIndicatorEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{progress});
        } else {
            currentSum = entryentity.stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal("indctrscore")).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentSum = currentSum.subtract((BigDecimal)this.getView().getModel().getValue("indctrscore"));
            areaWeight = (BigDecimal)this.getView().getParentView().getModel().getValue("areascore");
            progress = currentSum.stripTrailingZeros().toPlainString() + "/" + areaWeight.stripTrailingZeros().toPlainString();
            tips = ResManager.loadKDString((String)"\u3010{0}\u3011\u533a\u57df\u7d2f\u8ba1\u5206\u503c/\u533a\u57df\u603b\u5206\u503c\uff0c\u4e0d\u542b\u5f53\u524d\u65b0\u589e\u6216\u7f16\u8f91\u7684\u6307\u6807\u3002", (String)"GenAreaIndicatorEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{progress});
        }
        Label titleLabel = (Label)this.getControl("completelable");
        titleLabel.setText(tips);
    }

    private void setTitleText(OperationStatus status, DynamicObject conf) {
        String text = "";
        switch (status) {
            case ADDNEW: {
                text = ResManager.loadKDString((String)"\u6dfb\u52a0{0}\u6307\u6807", (String)"GenAreaIndicatorEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{conf.getString("areacustname")});
                break;
            }
            case EDIT: {
                text = ResManager.loadKDString((String)"\u7f16\u8f91{0}\u6307\u6807", (String)"GenAreaIndicatorEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{conf.getString("areacustname")});
                break;
            }
            case VIEW: {
                text = ResManager.loadKDString((String)"\u67e5\u770b{0}\u6307\u6807", (String)"GenAreaIndicatorEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{conf.getString("areacustname")});
                break;
            }
        }
        Label titleLabel = (Label)this.getControl("titlelabel");
        titleLabel.setText(text);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String value;
        String evalType;
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"minevalscore")) {
            this.checkLowerScoreValue();
        } else if (HRStringUtils.equals((String)name, (String)"maxevalscore")) {
            this.checkUpperScoreValue();
        } else if (this.validateNumberFiled.contains(name) && HRStringUtils.equals((String)(evalType = (String)this.getModel().getValue("evaltype")), (String)"20") && !ObjectUtils.isEmpty((Object)(value = (String)this.getModel().getValue(name))) && !DrawAreaUtils.validateNumber(value)) {
            String displayName = this.getModel().getProperty(name).getDisplayName().getLocaleValue();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"[{0}]\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u3002", (String)"GenAreaIndicatorEdit_26", (String)"opmc-epa-formplugin", (Object[])new Object[]{displayName}));
        }
    }

    private DynamicObject getScoreSystem() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long scoreSystemId = (Long)formShowParameter.getCustomParam("scoresystem");
        return this.service.queryScoreSystemById(scoreSystemId);
    }

    private boolean checkUpperScoreValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryNormalConfigByPk(confId);
        if (HRStringUtils.equals((String)conf.getString("adjusttype"), (String)AdjustTypeEnum.CUSTOM.getValue())) {
            BigDecimal maxScore = this.getScoreSystem().getBigDecimal("maxscore");
            BigDecimal minScore = this.getScoreSystem().getBigDecimal("minscore");
            BigDecimal lowerScore = this.getView().getModel().getDataEntity().getBigDecimal("minevalscore");
            BigDecimal upperScore = this.getView().getModel().getDataEntity().getBigDecimal("maxevalscore");
            if (HRObjectUtils.isEmpty((Object)upperScore)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"GenAreaIndicatorEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (HRObjectUtils.isEmpty((Object)lowerScore)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"GenAreaIndicatorEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (upperScore.compareTo(maxScore) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u9700\u2264\u8bc4\u5206\u5206\u5236\u6700\u9ad8\u5206", (String)"GenAreaIndicatorEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (upperScore.compareTo(lowerScore) <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u9700\uff1e\u8c03\u6574\u5206\u4e0b\u9650", (String)"GenAreaIndicatorEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private boolean checkLowerScoreValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryNormalConfigByPk(confId);
        if (HRStringUtils.equals((String)conf.getString("adjusttype"), (String)AdjustTypeEnum.CUSTOM.getValue())) {
            BigDecimal maxScore = this.getScoreSystem().getBigDecimal("maxscore");
            BigDecimal minScore = this.getScoreSystem().getBigDecimal("minscore");
            BigDecimal lowerScore = this.getView().getModel().getDataEntity().getBigDecimal("minevalscore");
            BigDecimal upperScore = this.getView().getModel().getDataEntity().getBigDecimal("maxevalscore");
            if (HRObjectUtils.isEmpty((Object)upperScore)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"GenAreaIndicatorEdit_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (HRObjectUtils.isEmpty((Object)lowerScore)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"GenAreaIndicatorEdit_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (maxScore.compareTo(new BigDecimal(0)) > 0 && lowerScore.compareTo(maxScore.negate()) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u9700\u2265\u8bc4\u5206\u5206\u5236\u6700\u9ad8\u5206\u7684\u76f8\u53cd\u6570\u3002", (String)"GenAreaIndicatorEdit_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (lowerScore.compareTo(upperScore) >= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u9700<\u8c03\u6574\u5206\u4e0a\u9650\u3002", (String)"GenAreaIndicatorEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    protected boolean checkActivityPermission() {
        AreaIndicatorPermissionServiceImpl areaIndicatorPermissionService = new AreaIndicatorPermissionServiceImpl();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)areaIndicatorPermissionService, AreaIndicatorPermissionService.class, (String)"kd.opmc.epa.formplugin.web.activity.extpoint.AreaIndicatorPermissionService#skipAreaIndicatorPermission", (PluginFilter)null);
        List results = proxy.callReplaceIfPresent(validate -> validate.skipAreaIndicatorPermission(this.getView()));
        if (results != null && !results.isEmpty() && results.get(0) != null && ((Boolean)results.get(0)).booleanValue()) {
            return true;
        }
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8003\u6838\u6d3b\u52a8\u7684\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u6743\u9650\u3002", (String)"GenAreaIndicatorEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        long id = this.getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            this.getPageCache().put("addflag", "true");
        } else {
            this.getPageCache().put("addflag", "false");
        }
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            String[] mustInputs;
            if (!this.checkActivityPermission()) {
                args.setCancel(true);
                return;
            }
            Object indicatorGroup = this.getView().getFormShowParameter().getCustomParam("indicatorgroup");
            if (this.indicatorService.isProcessOrDistrActevalObj(indicatorGroup)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u5bf9\u5e94\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u53ef\u7f16\u8f91\u6307\u6807\u3002", (String)"GenAreaIndicatorEdit_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            IFormView objGenInstView = this.getView().getParentView();
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            DynamicObject pDataEntity = objGenInstView.getModel().getDataEntity(true);
            Long cId = dataEntity.getLong("id");
            String mustInputstr = this.getPageCache().get(MUST_INPUT);
            for (String fieldKey : mustInputs = mustInputstr.split(",")) {
                String valueStr;
                Object value = dataEntity.get(fieldKey);
                LOG.info("GenAreaIndicatorEdit.beforeDoOperation: fieldKey: {},value: {}", (Object)fieldKey, value);
                if (value == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"GenAreaIndicatorEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (value instanceof OrmLocaleValue) {
                    OrmLocaleValue ormLocaleValue = (OrmLocaleValue)value;
                    boolean isEmpty = true;
                    Collection values = ormLocaleValue.values();
                    for (String ormLocaleValueStr : values) {
                        if (HRStringUtils.isEmpty((String)ormLocaleValueStr)) continue;
                        isEmpty = false;
                        break;
                    }
                    if (isEmpty) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"GenAreaIndicatorEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                if (!(value instanceof String) || !HRStringUtils.isEmpty((String)(valueStr = (String)value))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"GenAreaIndicatorEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String nameOri = dataEntity.getString("indctrname");
            String name = "";
            if (!HRStringUtils.isEmpty((String)nameOri)) {
                name = nameOri.trim();
            }
            if (!name.equals(nameOri)) {
                this.getModel().setValue("indctrname", (Object)name);
            }
            if (HRStringUtils.isEmpty((String)name)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GenAreaIndicatorEdit_25", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection entryentity = pDataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                if (cId.equals(0L)) {
                    if (!name.equals(dynamicObject.getString("indctrname"))) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u5df2\u6709\u201c{0}\u201d\u76f8\u540c\u7684\u6307\u6807\uff0c\u4e0d\u80fd\u6dfb\u52a0/\u7f16\u8f91\u3002", (String)"GenAreaIndicatorEdit_24", (String)"opmc-epa-formplugin", (Object[])new Object[]{name}));
                    args.setCancel(true);
                    return;
                }
                if (cId.equals((Long)dynamicObject.getPkValue()) || !name.equals(dynamicObject.getString("indctrname"))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u5df2\u6709\u201c{0}\u201d\u76f8\u540c\u7684\u6307\u6807\uff0c\u4e0d\u80fd\u6dfb\u52a0/\u7f16\u8f91\u3002", (String)"GenAreaIndicatorEdit_23", (String)"opmc-epa-formplugin", (Object[])new Object[]{name}));
                args.setCancel(true);
                return;
            }
            long pId = pDataEntity.getLong("id");
            if (this.indicatorService.checkNameIndicatorAreaEntry(AssessRuleConstants.NORM_INDCTR_AREA_PK, Long.valueOf(pId), name)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u4e2d\u5df2\u6709\u5236\u5b9a\u5bf9\u8c61\u76f8\u540c\u540d\u79f0\u7684\u6307\u6807\uff0c\u4e0d\u80fd\u6dfb\u52a0/\u7f16\u8f91\u3002", (String)"GenAreaIndicatorEdit_22", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String scoreCalcWay = this.getView().getParentView().getPageCache().get("scorecalcway");
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                this.validateWeight(args);
            } else {
                this.validateScore(args);
            }
            if (!NumberValidateUtils.opValidate((IFormView)this.getView(), this.validateNumberFiled)) {
                args.setCancel(true);
            }
            if (this.checkUpperScoreValue()) {
                args.setCancel(true);
                return;
            }
            if (this.checkLowerScoreValue()) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        boolean isSuccess = !ObjectUtils.isEmpty((Object)args.getOperationResult()) && args.getOperationResult().isSuccess();
        String addflag = this.getPageCache().get("addflag");
        if (isSuccess && "save".equals(operateKey)) {
            IFormView objGenInstView = this.getView().getParentView();
            if (ObjectUtils.isEmpty((Object)objGenInstView)) {
                return;
            }
            if ("true".equals(addflag)) {
                long pId = objGenInstView.getModel().getDataEntity().getLong("id");
                this.indicatorService.addObjIndicatorAreaEntry(AssessRuleConstants.NORM_INDCTR_AREA_PK, Long.valueOf(pId), this.getModel().getDataEntity());
            } else {
                this.indicatorService.updateObjIndicatorAreaEntry(AssessRuleConstants.NORM_INDCTR_AREA_PK, this.getModel().getDataEntity());
            }
            IFormView indicatorGroupView = objGenInstView.getParentView();
            if (!ObjectUtils.isEmpty((Object)indicatorGroupView)) {
                long indicGroupId = indicatorGroupView.getModel().getDataEntity().getLong("id");
                this.indicatorService.updateEvalObjByIndicGroupId(indicGroupId);
            }
            this.getView().returnDataToParent(this.getModel().getDataEntity().getPkValue());
        }
    }

    private void validateScore(BeforeDoOperationEventArgs args) {
        String maxScoreOfSystemStr = this.getView().getParentView().getPageCache().get("maxScoreOfSystem");
        BigDecimal maxScoreOfSystem = new BigDecimal(maxScoreOfSystemStr);
        BigDecimal areaScore = (BigDecimal)this.getView().getParentView().getModel().getValue("areascore");
        DynamicObjectCollection indicatorEntry = this.getView().getParentView().getModel().getEntryEntity("entryentity");
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        BigDecimal currentSum = indicatorEntry.stream().filter(Objects::nonNull).filter(indicator -> !indicator.getPkValue().equals(pkValue)).map(indicator -> indicator.getBigDecimal("indctrscore")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal indicatorScore = (BigDecimal)this.getModel().getValue("indctrscore");
        if (areaScore == null) {
            this.validateMaxScoreSystem(args, maxScoreOfSystem, currentSum, indicatorScore);
        } else if (currentSum.add(indicatorScore).compareTo(areaScore) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u5206\u503c\u4e4b\u548c\u5df2\u8d85\u8fc7\u533a\u57df\u5206\u503c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"GenAreaIndicatorEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            this.validateMaxScoreSystem(args, maxScoreOfSystem, currentSum, indicatorScore);
        }
        if (indicatorScore.compareTo(new BigDecimal(0)) < 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"GenAreaIndicatorEdit_21", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateWeight(BeforeDoOperationEventArgs args) {
        BigDecimal allWeight = new BigDecimal(100);
        BigDecimal areaWeight = (BigDecimal)this.getView().getParentView().getModel().getValue("areaweight");
        DynamicObjectCollection indicatorEntry = this.getView().getParentView().getModel().getEntryEntity("entryentity");
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        BigDecimal currentSum = indicatorEntry.stream().filter(Objects::nonNull).filter(indicator -> !indicator.getPkValue().equals(pkValue)).map(indicator -> indicator.getBigDecimal("weight")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal indicatorWeight = (BigDecimal)this.getModel().getValue("weight");
        if (areaWeight == null) {
            this.validateMaxWeight(args, allWeight, currentSum, indicatorWeight);
        } else if (currentSum.add(indicatorWeight).compareTo(areaWeight) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u6743\u91cd\u4e4b\u548c\u5df2\u8d85\u8fc7\u533a\u57df\u6743\u91cd\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"GenAreaIndicatorEdit_27", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            this.validateMaxWeight(args, allWeight, currentSum, indicatorWeight);
        }
        if (indicatorWeight.compareTo(new BigDecimal(0)) < 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u91cd\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"GenAreaIndicatorEdit_20", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateMaxScoreSystem(BeforeDoOperationEventArgs args, BigDecimal maxScoreOfSystem, BigDecimal currentSum, BigDecimal indicatorScore) {
        if (currentSum.add(indicatorScore).compareTo(maxScoreOfSystem) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u5206\u503c\u4e4b\u548c\u5df2\u8d85\u8fc7\u5206\u5236\u6700\u9ad8\u57fa\u51c6\u5206{0}", (String)"GenAreaIndicatorEdit_19", (String)"opmc-epa-formplugin", (Object[])new Object[]{maxScoreOfSystem}));
        }
    }

    private void validateMaxWeight(BeforeDoOperationEventArgs args, BigDecimal maxWeight, BigDecimal currentSum, BigDecimal indicatorWeight) {
        String limitMaxRatioStr;
        Object evaSumLimitObj = this.getView().getFormShowParameter().getCustomParam("evasumlimit");
        Object limitMaxRatioObj = this.getView().getFormShowParameter().getCustomParam("limitmaxratio");
        Object numAccuracyObj = this.getView().getFormShowParameter().getCustomParam("numaccuracy");
        String evaSumLimit = "";
        BigDecimal limitMaxRatioBD = new BigDecimal(100);
        Integer numAccuracy = 0;
        if (evaSumLimitObj instanceof String) {
            evaSumLimit = (String)evaSumLimitObj;
        }
        if (limitMaxRatioObj instanceof String && (limitMaxRatioStr = (String)limitMaxRatioObj) != "") {
            limitMaxRatioBD = new BigDecimal(limitMaxRatioStr);
        }
        if (numAccuracyObj instanceof Integer) {
            numAccuracy = (Integer)numAccuracyObj;
        }
        if (EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit) && currentSum.add(indicatorWeight).compareTo(limitMaxRatioBD) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u6743\u91cd\u4e4b\u548c\u5df2\u8d85\u8fc7\u201c\u8bc4\u4f30\u8868\u5355\u5236\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d{0}", (String)"GenAreaIndicatorEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{limitMaxRatioBD.setScale(numAccuracy)}));
        } else if (!EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit) && currentSum.add(indicatorWeight).compareTo(maxWeight) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u6743\u91cd\u4e4b\u548c\u5df2\u8d85\u8fc7100%\u3002", (String)"GenAreaIndicatorEdit_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void initTips() {
        this.setTips("iseditable");
    }

    private void setTips(String key) {
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = this.service.getTips("epa_genareaindicator", key, dy);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipContent));
            props.put("tips", tips);
            this.getView().updateControlMetadata(key, props);
        }
    }
}

