/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.constants.AssessTableConfConstants;
import kd.opmc.epa.common.constants.IndicatorGroupConstants;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.activity.AreaInstanceEdit;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class GenAreaInstanceEdit
extends AreaInstanceEdit {
    private static final Log LOG = LogFactory.getLog(GenAreaInstanceEdit.class);
    private static final String ADD_TYPE_REQ_OP = "addtypereq";
    private static final String IS_SYSTEM_SET_VALUE = "isSystemSetValue";
    private static final String IS_SYSTEM_SET_WEIGHT = "isSystemSetWeight";
    private static final String IS_SYSTEM_SET_SCORESYSTEM = "isSystemSetScoreSystem";
    private static final int ALLWEIGHT = 100;

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryNormalConfigByPk(confId);
        DrawAreaUtils.customDrawArea(args, conf, AssessTableConfConstants.GEN_IGNORE_FIELD, AssessRuleConstants.NORM_INDCTR_AREA_PK);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        String scoreCalcWay = (String)formShowParameter.getCustomParam("scorecalcway");
        DynamicObject conf = this.service.queryNormalConfigByPk(confId);
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"weightflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"scoreflex"});
            this.setAreaWeight(conf);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"scoreflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"weightflex"});
            this.setAreaScore(conf);
        }
        DynamicObject scoreSystem = this.getScoreSystem();
        BigDecimal maxScoreOfSystem = scoreSystem.getBigDecimal("maxscore");
        this.getPageCache().put("maxScoreOfSystem", maxScoreOfSystem.toString());
        this.getPageCache().put("scorecalcway", scoreCalcWay);
        this.buildTips(conf.getString("description"));
        HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(16);
        props.put("text", new LocaleString(conf.getString("areacustname")));
        this.getView().updateControlMetadata("conentpanel", props);
        this.getView().updateControlMetadata("areascore", DrawAreaUtils.getPcScItemMap(formShowParameter));
        Object limitMaxRatioObj = formShowParameter.getCustomParam("limitmaxratio");
        LOG.info("GenAreaInstanceEdit.afterBindData LIMITMAXRATIO :{}", limitMaxRatioObj);
        this.getView().updateControlMetadata("areaweight", DrawAreaUtils.getPcScopeItemMapFromStr(formShowParameter));
        this.getModel().setDataChanged(false);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"blanklap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entrylap", "flexpanelap7"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"blanklap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entrylap", "flexpanelap7"});
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"spaceflex"});
        } else if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"spaceflex"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"spaceflex"});
        }
    }

    private void buildTips(String description) {
        if (StringUtils.isEmpty((String)description)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"vectordesc"});
            return;
        }
        Vector vectorDesc = (Vector)this.getControl("vectordesc");
        Tips tips = new Tips();
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u63cf\u8ff0\uff1a{0}", (String)"GenAreaInstanceEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{description})));
        tips.setType("text");
        tips.setTriggerType("hover");
        tips.setShowIcon(false);
        tips.setIsConfirm(false);
        vectorDesc.addTips(tips);
    }

    private DynamicObject getScoreSystem() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long scoreSystemId = (Long)formShowParameter.getCustomParam("scoresystem");
        return this.service.queryScoreSystemById(scoreSystemId);
    }

    private void setAreaScoreDataScope() {
        this.getModel().setValue("minareascore", (Object)0);
        this.getModel().setValue("maxareascore", this.getModel().getValue("areascore"));
    }

    private void setAreaScore(DynamicObject conf) {
        boolean isForcedControl = conf.getBoolean("isforcedcontrol");
        if (isForcedControl) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"scoreflex"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"scoreflex"});
        }
    }

    private void setAreaWeight(DynamicObject conf) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String consistentWithArea = (String)formShowParameter.getCustomParam("consistentwitharea");
        boolean isForcedControl = conf.getBoolean("isforcedcontrol");
        if (isForcedControl) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"weightflex"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"weightflex"});
        }
        if ("0".equals(consistentWithArea)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"scoresystemflex"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"scoresystem"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"scoresystemflex"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        long areaId = this.getModel().getDataEntity().getLong("id");
        switch (name) {
            case "areascore": {
                if (!this.validateOfIndicatorScore(args, name)) break;
                this.setAreaScoreDataScope();
                this.invokeSaveOp();
                BigDecimal newScore = HRStringUtils.equals((String)name, (String)"areascore") ? (BigDecimal)args.getChangeSet()[0].getNewValue() : (BigDecimal)this.getModel().getValue("areascore");
                this.indicatorService.updateObjIndicatorArea(AssessRuleConstants.NORM_INDCTR_AREA_PK, Long.valueOf(areaId), name, (Object)newScore);
                break;
            }
            case "areaweight": {
                if (!this.validateOfIndicatorWeight(args, name)) break;
                this.invokeSaveOp();
                BigDecimal newWeight = HRStringUtils.equals((String)name, (String)"areaweight") ? (BigDecimal)args.getChangeSet()[0].getNewValue() : (BigDecimal)this.getModel().getValue("areaweight");
                this.indicatorService.updateObjIndicatorArea(AssessRuleConstants.NORM_INDCTR_AREA_PK, Long.valueOf(areaId), name, (Object)newWeight);
                break;
            }
            case "scoresystem": {
                if (!this.validateOfScoreSystem(args)) break;
                this.invokeSaveOp();
                Object newValue = args.getChangeSet()[0].getNewValue();
                this.indicatorService.updateObjIndicatorArea(AssessRuleConstants.NORM_INDCTR_AREA_PK, Long.valueOf(areaId), name, newValue);
                break;
            }
        }
    }

    private boolean validateOfIndicatorScore(PropertyChangedArgs args, String name) {
        BigDecimal oldValue;
        String isSystemSetValue = this.getPageCache().get(IS_SYSTEM_SET_VALUE);
        if (HRStringUtils.equals((String)isSystemSetValue, (String)"true")) {
            this.getPageCache().remove(IS_SYSTEM_SET_VALUE);
            return true;
        }
        BigDecimal newScore = HRStringUtils.equals((String)name, (String)"areascore") ? (BigDecimal)args.getChangeSet()[0].getNewValue() : (BigDecimal)this.getModel().getValue("areascore");
        BigDecimal bigDecimal = oldValue = HRStringUtils.equals((String)name, (String)"areascore") ? (BigDecimal)args.getChangeSet()[0].getOldValue() : (BigDecimal)this.getModel().getValue("areascore");
        if (!OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P")) {
            this.getView().showConfirm(ResManager.loadKDString((String)IndicatorGroupConstants.PERMITEM_MESSAGE, (String)"GenAreaInstanceEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), null);
            this.getPageCache().put(IS_SYSTEM_SET_VALUE, "true");
            this.getModel().setValue("areascore", (Object)oldValue);
            return false;
        }
        Object indicatorGroup = this.getView().getFormShowParameter().getCustomParam("indicatorgroup");
        if (this.indicatorService.isProcessOrDistrActevalObj(indicatorGroup)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u5bf9\u5e94\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u652f\u6301\u7f16\u8f91\u5206\u503c\u3002", (String)"GenAreaInstanceEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(IS_SYSTEM_SET_VALUE, "true");
            this.getModel().setValue("areascore", (Object)oldValue);
            return false;
        }
        BigDecimal maxScoreOfSystem = this.getScoreSystem().getBigDecimal("maxscore");
        String stripZeroVal = maxScoreOfSystem.stripTrailingZeros().toPlainString();
        if (newScore.compareTo(maxScoreOfSystem) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u5206\u503c\u5e94\u4f4e\u4e8e\u8bc4\u5206\u5206\u5236\u7684\u201c\u57fa\u51c6\u6700\u9ad8\u5206\u201d\u3002", (String)"GenAreaInstanceEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(IS_SYSTEM_SET_VALUE, "true");
            this.getModel().setValue("areascore", (Object)oldValue);
            return false;
        }
        BigDecimal sumOfIndicatorScore = this.getSumScore(this.getModel(), "entryentity", "indctrscore");
        if (sumOfIndicatorScore.compareTo(newScore) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u5408\u8ba1\u5206\u503c\u9700\u2264\u533a\u57df\u5206\u503c", (String)"GenAreaInstanceEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(IS_SYSTEM_SET_VALUE, "true");
            this.getModel().setValue("areascore", (Object)oldValue);
            return false;
        }
        DynamicObject[] genInstCollection = this.getOtherGenInst();
        List areaScoreList = Arrays.stream(genInstCollection).map(item -> item.getBigDecimal("areascore")).collect(Collectors.toList());
        BigDecimal sumScore = areaScoreList.stream().reduce(newScore, BigDecimal::add);
        if (sumScore.compareTo(maxScoreOfSystem) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u5408\u8ba1\u5206\u503c\u9700\u2264\u57fa\u51c6\u6700\u9ad8\u5206\uff1a{0}", (String)"GenAreaInstanceEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{stripZeroVal}));
            this.getPageCache().put(IS_SYSTEM_SET_VALUE, "true");
            this.getModel().setValue("areascore", (Object)oldValue);
            return false;
        }
        return true;
    }

    private boolean validateOfIndicatorWeight(PropertyChangedArgs args, String name) {
        String limitMaxRatioStr;
        BigDecimal oldValue;
        String isSystemSetValue = this.getPageCache().get(IS_SYSTEM_SET_WEIGHT);
        if (HRStringUtils.equals((String)isSystemSetValue, (String)"true")) {
            this.getPageCache().remove(IS_SYSTEM_SET_WEIGHT);
            return true;
        }
        BigDecimal newWeight = HRStringUtils.equals((String)name, (String)"areaweight") ? (BigDecimal)args.getChangeSet()[0].getNewValue() : (BigDecimal)this.getModel().getValue("areaweight");
        BigDecimal bigDecimal = oldValue = HRStringUtils.equals((String)name, (String)"areaweight") ? (BigDecimal)args.getChangeSet()[0].getOldValue() : (BigDecimal)this.getModel().getValue("areaweight");
        if (!OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P")) {
            this.getView().showConfirm(ResManager.loadKDString((String)IndicatorGroupConstants.PERMITEM_MESSAGE, (String)"GenAreaInstanceEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), null);
            this.getPageCache().put(IS_SYSTEM_SET_WEIGHT, "true");
            this.getModel().setValue("areaweight", (Object)oldValue);
            return false;
        }
        Object indicatorGroup = this.getView().getFormShowParameter().getCustomParam("indicatorgroup");
        if (this.indicatorService.isProcessOrDistrActevalObj(indicatorGroup)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u5bf9\u5e94\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u53ef\u7f16\u8f91\u6743\u91cd\u3002", (String)"GenAreaInstanceEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(IS_SYSTEM_SET_WEIGHT, "true");
            this.getModel().setValue("areaweight", (Object)oldValue);
            return false;
        }
        Object evaSumLimitObj = this.getView().getFormShowParameter().getCustomParam("evasumlimit");
        Object limitMaxRatioObj = this.getView().getFormShowParameter().getCustomParam("limitmaxratio");
        Object numAccuracyObj = this.getView().getFormShowParameter().getCustomParam("numaccuracy");
        String evaSumLimit = "";
        BigDecimal limitMaxRatioBD = new BigDecimal(100);
        Integer numAccuracy = 0;
        if (evaSumLimitObj instanceof String) {
            evaSumLimit = (String)evaSumLimitObj;
        }
        if (limitMaxRatioObj instanceof String && (limitMaxRatioStr = (String)limitMaxRatioObj) != "") {
            limitMaxRatioBD = new BigDecimal(limitMaxRatioStr);
        }
        if (numAccuracyObj instanceof Integer) {
            numAccuracy = (Integer)numAccuracyObj;
        }
        if (newWeight.compareTo(new BigDecimal(100)) > 0 && !EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u6743\u91cd\u4e0d\u80fd\u8d85\u8fc7100%\uff1a", (String)"GenAreaInstanceEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(IS_SYSTEM_SET_WEIGHT, "true");
            this.getModel().setValue("areaweight", (Object)oldValue);
            return false;
        }
        BigDecimal sumOfIndicatorWeight = this.getSumScore(this.getModel(), "entryentity", "weight");
        if (sumOfIndicatorWeight.compareTo(newWeight) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700\u2264\u533a\u57df\u6743\u91cd", (String)"GenAreaInstanceEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(IS_SYSTEM_SET_WEIGHT, "true");
            this.getModel().setValue("areaweight", (Object)oldValue);
            return false;
        }
        DynamicObject[] genInstCollection = this.getOtherGenInst();
        List areaWeightList = Arrays.stream(genInstCollection).map(item -> item.getBigDecimal("areaweight")).collect(Collectors.toList());
        BigDecimal sumWeight = areaWeightList.stream().reduce(newWeight, BigDecimal::add);
        if (EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit) && sumWeight.compareTo(limitMaxRatioBD) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u533a\u57df\u7d2f\u8ba1\u6743\u91cd\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4f30\u8868\u5355\u6307\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d\uff1a{0}%\u3002", (String)"GenAreaInstanceEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[]{limitMaxRatioBD.setScale(numAccuracy)}));
            this.getPageCache().put(IS_SYSTEM_SET_WEIGHT, "true");
            this.getModel().setValue("areaweight", (Object)oldValue);
            return false;
        }
        if (!EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit) && sumWeight.compareTo(new BigDecimal(100)) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u5408\u8ba1\u6743\u91cd\u9700\u2264100%", (String)"GenAreaInstanceEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(IS_SYSTEM_SET_WEIGHT, "true");
            this.getModel().setValue("areaweight", (Object)oldValue);
            return false;
        }
        return true;
    }

    private boolean validateOfScoreSystem(PropertyChangedArgs args) {
        String isSystemSetValue = this.getPageCache().get(IS_SYSTEM_SET_SCORESYSTEM);
        if (HRStringUtils.equals((String)isSystemSetValue, (String)"true")) {
            this.getPageCache().remove(IS_SYSTEM_SET_SCORESYSTEM);
            return true;
        }
        Object oldValue = args.getChangeSet()[0].getOldValue();
        if (!OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P")) {
            this.getView().showConfirm(ResManager.loadKDString((String)IndicatorGroupConstants.PERMITEM_MESSAGE, (String)"GenAreaInstanceEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), null);
            this.getPageCache().put(IS_SYSTEM_SET_SCORESYSTEM, "true");
            this.getModel().setValue("scoresystem", oldValue);
            return false;
        }
        Object indicatorGroup = this.getView().getFormShowParameter().getCustomParam("indicatorgroup");
        if (this.indicatorService.isProcessOrDistrActevalObj(indicatorGroup)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u5bf9\u5e94\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u53ef\u7f16\u8f91\u8bc4\u5206\u5206\u5236\u3002", (String)"GenAreaInstanceEdit_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(IS_SYSTEM_SET_SCORESYSTEM, "true");
            this.getModel().setValue("scoresystem", oldValue);
            return false;
        }
        return true;
    }

    private DynamicObject[] getOtherGenInst() {
        DynamicObjectCollection indAreaConfEntry = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("indareaconfentry");
        long currentAssInstId = this.getModel().getDataEntity().getLong("id");
        Set areaInstanceIds = indAreaConfEntry.stream().filter(item -> item.getDynamicObject("area").getLong("id") == AssessRuleConstants.NORM_INDCTR_AREA_PK.longValue()).filter(item -> item.getLong("areainstance") != currentAssInstId).map(item -> item.getLong("areainstance")).collect(Collectors.toSet());
        return this.service.queryGenInstance(areaInstanceIds);
    }

    private BigDecimal getSumScore(IDataModel model, String indReqEntity, String score) {
        DynamicObjectCollection indicatorEntry = model.getEntryEntity(indReqEntity);
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        return indicatorEntry.stream().filter(Objects::nonNull).filter(indicator -> !indicator.getPkValue().equals(pkValue)).map(indicator -> indicator.getBigDecimal(score)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        IDataModel entryOperate = this.getModel();
        long id = this.getModel().getDataEntity().getLong("id");
        for (int selectRow : rowIndexs) {
            DynamicObject entryentity = entryOperate.getEntryRowEntity("entryentity", selectRow);
            this.indicatorService.deleteAndUpdateSeqObjIndicatorAreaEntry(AssessRuleConstants.NORM_INDCTR_AREA_PK, Long.valueOf(id), (Long)entryentity.getPkValue());
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "DELETEROW": {
                if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult() || !this.checkGroupActivityPermission()) break;
                IDataModel entryOperate = this.getModel();
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                entryOperate.deleteEntryRows("entryentity", selectRows);
                this.invokeSaveOp();
                IFormView indicatorGroupView = this.getView().getParentView();
                if (!ObjectUtils.isEmpty((Object)indicatorGroupView)) {
                    long indicGroupId = indicatorGroupView.getModel().getDataEntity().getLong("id");
                    this.indicatorService.updateEvalObjByIndicGroupId(indicGroupId);
                }
                this.getView().invokeOperation("donothing_deleteindicator");
                this.getView().invokeOperation("refresh");
                break;
            }
            case "closeView": {
                if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult()) break;
                this.getView().getParentView().getParentView().close();
                this.getView().sendFormAction(this.getView().getParentView().getParentView());
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        if (ObjectUtils.isEmpty((Object)this.getParentViewPageCache())) {
            args.setCancel(true);
            return;
        }
        Object indicatorGroup = this.getView().getFormShowParameter().getCustomParam("indicatorgroup");
        switch (source.getOperateKey()) {
            case "addindicator": {
                if (!this.indicatorService.isProcessOrDistrActevalObj(indicatorGroup)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u5bf9\u5e94\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u53ef\u6dfb\u52a0\u6307\u6807\u3002", (String)"GenAreaInstanceEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "deleteindicator": {
                if (this.indicatorService.isProcessOrDistrActevalObj(indicatorGroup)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u5bf9\u5e94\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u53ef\u5220\u9664\u6307\u6807\u3002", (String)"GenAreaInstanceEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                IDataModel entryOperate = this.getModel();
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                boolean flag = false;
                for (int selectRow : selectRows) {
                    DynamicObject entryentity = entryOperate.getEntryRowEntity("entryentity", selectRow);
                    if (!this.indicatorService.queryObjIndicatorAreaEntry(AssessRuleConstants.NORM_INDCTR_AREA_PK, entryentity)) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u5df2\u7ecf\u6307\u5b9a\u7ed9\u4eba\u5458\uff0c\u5219\u5bf9\u5e94\u4eba\u5458\u7684\u6307\u6807\u4e5f\u88ab\u5220\u9664\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"GenAreaInstanceEdit_14", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("DELETEROW", (IFormPlugin)this));
                    args.setCancel(true);
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u6307\u6807\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c \u786e\u5b9a\u8981\u5220\u9664\u8be5\u6307\u6807\u5417\uff1f", (String)"GenAreaInstanceEdit_15", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("DELETEROW", (IFormPlugin)this));
                args.setCancel(true);
                break;
            }
        }
        super.beforeDoOperation(args);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    @Override
    protected String getIndicatorPageId() {
        return "epa_genareaindicator";
    }

    @Override
    protected Long getTaskId() {
        Object taskId = this.getView().getFormShowParameter().getCustomParam("taskId");
        if (ObjectUtils.isEmpty((Object)taskId)) {
            return null;
        }
        long aLong = taskId instanceof String ? Long.parseLong((String)taskId) : (Long)taskId;
        return aLong;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (HRStringUtils.equals((String)actionId, (String)"addindicator")) {
            if (returnData == null) {
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("systeminvoke", "true");
            this.getView().invokeOperation("addindicator", operateOption);
        }
    }
}

