/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity.bo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class CyclePeriodDateRange {
    private int year;
    private String period;
    private String dateRange;
    private String parentId;
    private List<CyclePeriodDateRange> childCyclePeriodDateRange;
    private static final String YEAR_NUMBER = "Y";
    private static final List<String> HALF_YEAR_NUMBER = Arrays.asList("H1", "H2");
    private static final List<String> QUARTER_YEAR_NUMBER = Arrays.asList("Q1", "Q2", "Q3", "Q4");
    private static final List<String> MONTH_YEAR_NUMBER = Arrays.asList("M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12");

    public CyclePeriodDateRange(String period, int year, String dateRange) {
        this.period = period;
        this.year = year;
        this.dateRange = dateRange;
    }

    public CyclePeriodDateRange(String period, int year) {
        this.period = period;
        this.year = year;
    }

    public void setDateRange(String dateRange) {
        this.dateRange = dateRange;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setChildCyclePeriodDateRange(List<CyclePeriodDateRange> childCyclePeriodDateRange) {
        this.childCyclePeriodDateRange = childCyclePeriodDateRange;
    }

    public List<CyclePeriodDateRange> getChildCyclePeriodDateRange() {
        return this.childCyclePeriodDateRange;
    }

    public void addChildCyclePeriodDateRange(CyclePeriodDateRange child) {
        if (this.getChildCyclePeriodDateRange() == null) {
            this.setChildCyclePeriodDateRange(new ArrayList<CyclePeriodDateRange>());
        }
        if (child != null) {
            this.getChildCyclePeriodDateRange().add(child);
        }
    }

    public String getFormatPeriod() {
        return this.year + this.period;
    }

    public String getPeriod() {
        return this.period;
    }

    public String getDateRange() {
        return String.format(this.dateRange, this.year, this.year);
    }

    public static List<CyclePeriodDateRange> genCyclePeriodDateRange(DynamicObject cycleSchemeDynObj, DynamicObject cycleTypeDynObj, int year) {
        ArrayList<CyclePeriodDateRange> resultList;
        block6: {
            block8: {
                block7: {
                    block5: {
                        resultList = new ArrayList<CyclePeriodDateRange>(10);
                        if (1363179570613844992L != cycleTypeDynObj.getLong("id")) break block5;
                        CyclePeriodDateRange cyclePeriodYearDateRange = new CyclePeriodDateRange(YEAR_NUMBER, year);
                        if (cycleSchemeDynObj == null) {
                            cyclePeriodYearDateRange.setDateRange("");
                        } else {
                            String periodStart = ((DynamicObject)cycleSchemeDynObj.getDynamicObjectCollection("entryentity").get(0)).getString("periodstart");
                            String periodEnd = ((DynamicObject)cycleSchemeDynObj.getDynamicObjectCollection("entryentity").get(0)).getString("periodend");
                            String dataRange = "%s-" + periodStart + "~%s-" + periodEnd;
                            cyclePeriodYearDateRange.setDateRange(dataRange);
                        }
                        resultList.add(cyclePeriodYearDateRange);
                        break block6;
                    }
                    if (1363179723043240960L != cycleTypeDynObj.getLong("id")) break block7;
                    for (int i = 0; i < HALF_YEAR_NUMBER.size(); ++i) {
                        String period = HALF_YEAR_NUMBER.get(i);
                        CyclePeriodDateRange.genCyclePeriodDateRangeByCycleScheme(cycleSchemeDynObj, year, resultList, i, period);
                    }
                    break block6;
                }
                if (1363180109330260992L != cycleTypeDynObj.getLong("id")) break block8;
                for (int i = 0; i < QUARTER_YEAR_NUMBER.size(); ++i) {
                    String period = QUARTER_YEAR_NUMBER.get(i);
                    CyclePeriodDateRange.genCyclePeriodDateRangeByCycleScheme(cycleSchemeDynObj, year, resultList, i, period);
                }
                break block6;
            }
            if (1363180276724933632L != cycleTypeDynObj.getLong("id")) break block6;
            for (int i = 0; i < MONTH_YEAR_NUMBER.size(); ++i) {
                String period = MONTH_YEAR_NUMBER.get(i);
                CyclePeriodDateRange.genCyclePeriodDateRangeByCycleScheme(cycleSchemeDynObj, year, resultList, i, period);
            }
        }
        return resultList;
    }

    private static void genCyclePeriodDateRangeByCycleScheme(DynamicObject cycleTypeDynObj, int year, List<CyclePeriodDateRange> resultList, int i, String period) {
        CyclePeriodDateRange cyclePeriodHalfYearDateRange = new CyclePeriodDateRange(period, year);
        if (cycleTypeDynObj == null) {
            cyclePeriodHalfYearDateRange.setDateRange("");
        } else {
            String periodStart = ((DynamicObject)cycleTypeDynObj.getDynamicObjectCollection("entryentity").get(i)).getString("periodstart");
            String periodEnd = ((DynamicObject)cycleTypeDynObj.getDynamicObjectCollection("entryentity").get(i)).getString("periodend");
            String dataRange = "%s-" + periodStart + "~%s-" + periodEnd;
            cyclePeriodHalfYearDateRange.setDateRange(dataRange);
        }
        resultList.add(cyclePeriodHalfYearDateRange);
    }

    public static List<CyclePeriodDateRange> genAllCyclePeriodDateRange(Map<String, String> periodParentMap, DynamicObjectCollection periodConfColl, Date dateTime) {
        int periodYear = HRDateTimeUtils.getYear((Date)dateTime);
        ArrayList cyclePeriodDateRangeList = new ArrayList(10);
        Map<Long, DynamicObject> cycleTypePeriodConfMap = periodConfColl.stream().collect(Collectors.toMap(periodConf -> periodConf.getLong("pcycletype.id"), periodConf -> periodConf));
        periodParentMap.forEach((key, parentId) -> {
            switch (key) {
                case "Y": {
                    CyclePeriodDateRange.genYCyclePeriodDateRange(cyclePeriodDateRangeList, periodYear, cycleTypePeriodConfMap);
                    break;
                }
                case "H": {
                    CyclePeriodDateRange.genHCyclePeriodDateRange(cyclePeriodDateRangeList, periodYear, parentId, cycleTypePeriodConfMap);
                    break;
                }
                case "Q": {
                    CyclePeriodDateRange.genQCyclePeriodDateRange(cyclePeriodDateRangeList, periodYear, parentId, cycleTypePeriodConfMap);
                    break;
                }
                case "M": {
                    CyclePeriodDateRange.genMCyclePeriodDateRange(cyclePeriodDateRangeList, periodYear, parentId, cycleTypePeriodConfMap);
                    break;
                }
            }
        });
        ArrayList<CyclePeriodDateRange> resultList = new ArrayList<CyclePeriodDateRange>(10);
        Map periodDateRangeMap = cyclePeriodDateRangeList.stream().collect(Collectors.toMap(CyclePeriodDateRange::getPeriod, Function.identity(), (key1, key2) -> key2));
        for (CyclePeriodDateRange cyclePeriodDateRange : cyclePeriodDateRangeList) {
            String parentId2 = cyclePeriodDateRange.getParentId();
            if ("P0".equals(parentId2)) {
                resultList.add(cyclePeriodDateRange);
                continue;
            }
            CyclePeriodDateRange parentCyclePeriodDateRange = (CyclePeriodDateRange)periodDateRangeMap.get(parentId2);
            if (parentCyclePeriodDateRange == null) {
                resultList.add(cyclePeriodDateRange);
                continue;
            }
            parentCyclePeriodDateRange.addChildCyclePeriodDateRange(cyclePeriodDateRange);
        }
        return resultList;
    }

    private static void genYCyclePeriodDateRange(List<CyclePeriodDateRange> cyclePeriodDateRangeList, int periodYear, Map<Long, DynamicObject> cycleTypePeriodConfMap) {
        String dataRange;
        DynamicObject periodConfDynObj = cycleTypePeriodConfMap.get(1363179570613844992L).getDynamicObject("pcyclescheme");
        if (periodConfDynObj == null) {
            dataRange = "";
        } else {
            String periodStart = ((DynamicObject)periodConfDynObj.getDynamicObjectCollection("entryentity").get(0)).getString("periodstart");
            String periodEnd = ((DynamicObject)periodConfDynObj.getDynamicObjectCollection("entryentity").get(0)).getString("periodend");
            dataRange = "%s-" + periodStart + "~%s-" + periodEnd;
        }
        CyclePeriodDateRange yearCyclePeriodDateRange = new CyclePeriodDateRange(YEAR_NUMBER, periodYear, dataRange);
        yearCyclePeriodDateRange.setParentId("P0");
        cyclePeriodDateRangeList.add(yearCyclePeriodDateRange);
    }

    private static void genHCyclePeriodDateRange(List<CyclePeriodDateRange> cyclePeriodDateRangeList, int periodYear, String parentId, Map<Long, DynamicObject> cycleTypePeriodConfMap) {
        int i;
        ArrayList<String> dateRangeList = new ArrayList<String>(10);
        DynamicObject cycleSchemeDynObj = cycleTypePeriodConfMap.get(1363179723043240960L).getDynamicObject("pcyclescheme");
        if (cycleSchemeDynObj == null) {
            for (i = 0; i < HALF_YEAR_NUMBER.size(); ++i) {
                dateRangeList.add("");
            }
        } else {
            CyclePeriodDateRange.genDataRangeByPeriodConfColl(cycleSchemeDynObj, dateRangeList);
        }
        for (i = 0; i < HALF_YEAR_NUMBER.size(); ++i) {
            CyclePeriodDateRange halfYearCyclePeriodDateRange = new CyclePeriodDateRange(HALF_YEAR_NUMBER.get(i), periodYear, (String)dateRangeList.get(i));
            halfYearCyclePeriodDateRange.setParentId(parentId);
            cyclePeriodDateRangeList.add(halfYearCyclePeriodDateRange);
        }
    }

    private static void genQCyclePeriodDateRange(List<CyclePeriodDateRange> cyclePeriodDateRangeList, int periodYear, String parentId, Map<Long, DynamicObject> cycleTypePeriodConfMap) {
        int i;
        DynamicObject cycleSchemeDynObj = cycleTypePeriodConfMap.get(1363180109330260992L).getDynamicObject("pcyclescheme");
        ArrayList<String> dateRangeList = new ArrayList<String>(10);
        if (cycleSchemeDynObj == null) {
            for (i = 0; i < QUARTER_YEAR_NUMBER.size(); ++i) {
                dateRangeList.add("");
            }
        } else {
            CyclePeriodDateRange.genDataRangeByPeriodConfColl(cycleSchemeDynObj, dateRangeList);
        }
        for (i = 0; i < QUARTER_YEAR_NUMBER.size(); ++i) {
            CyclePeriodDateRange halfYearCyclePeriodDateRange = new CyclePeriodDateRange(QUARTER_YEAR_NUMBER.get(i), periodYear, (String)dateRangeList.get(i));
            if (YEAR_NUMBER.equals(parentId)) {
                halfYearCyclePeriodDateRange.setParentId(parentId);
            } else if (i < 2) {
                halfYearCyclePeriodDateRange.setParentId(HALF_YEAR_NUMBER.get(0));
            } else {
                halfYearCyclePeriodDateRange.setParentId(HALF_YEAR_NUMBER.get(1));
            }
            cyclePeriodDateRangeList.add(halfYearCyclePeriodDateRange);
        }
    }

    private static void genMCyclePeriodDateRange(List<CyclePeriodDateRange> cyclePeriodDateRangeList, int periodYear, String parentId, Map<Long, DynamicObject> cycleTypePeriodConfMap) {
        int i;
        DynamicObject cycleSchemeDynObj = cycleTypePeriodConfMap.get(1363180276724933632L).getDynamicObject("pcyclescheme");
        ArrayList<String> dateRangeList = new ArrayList<String>(10);
        if (cycleSchemeDynObj == null) {
            for (i = 0; i < MONTH_YEAR_NUMBER.size(); ++i) {
                dateRangeList.add("");
            }
        } else {
            CyclePeriodDateRange.genDataRangeByPeriodConfColl(cycleSchemeDynObj, dateRangeList);
        }
        for (i = 0; i < MONTH_YEAR_NUMBER.size(); ++i) {
            CyclePeriodDateRange monthPeriod = new CyclePeriodDateRange(MONTH_YEAR_NUMBER.get(i), periodYear, (String)dateRangeList.get(i));
            if (YEAR_NUMBER.equals(parentId)) {
                monthPeriod.setParentId(parentId);
            } else if ("H".equals(parentId)) {
                if (i < 6) {
                    monthPeriod.setParentId(HALF_YEAR_NUMBER.get(0));
                } else {
                    monthPeriod.setParentId(HALF_YEAR_NUMBER.get(1));
                }
            } else if ("Q".equals(parentId)) {
                if (i <= 2) {
                    monthPeriod.setParentId(QUARTER_YEAR_NUMBER.get(0));
                } else if (i <= 5) {
                    monthPeriod.setParentId(QUARTER_YEAR_NUMBER.get(1));
                } else if (i <= 8) {
                    monthPeriod.setParentId(QUARTER_YEAR_NUMBER.get(2));
                } else {
                    monthPeriod.setParentId(QUARTER_YEAR_NUMBER.get(3));
                }
            }
            cyclePeriodDateRangeList.add(monthPeriod);
        }
    }

    private static void genDataRangeByPeriodConfColl(DynamicObject cycleSchemeDynObj, List<String> dateRangeList) {
        DynamicObjectCollection dynObjColl = cycleSchemeDynObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject periodConfDynObj : dynObjColl) {
            String periodStart = periodConfDynObj.getString("periodstart");
            String periodEnd = periodConfDynObj.getString("periodend");
            String dataRange = "%s-" + periodStart + "~%s-" + periodEnd;
            dateRangeList.add(dataRange);
        }
    }
}

