/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.actevalobj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeSetItemValueEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterBindingDataEvent;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BasedataEditListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityAggregationInterfaceService;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.scheme.ExecuteSchemeApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.evalback.entity.EvalBackInfoResult;
import kd.opmc.epa.business.domain.evalback.entity.EvalBackTaskDto;
import kd.opmc.epa.business.domain.evalback.entity.EvalBatchBackDto;
import kd.opmc.epa.business.domain.evalback.entity.EvalBatchBackResult;
import kd.opmc.epa.business.domain.evalback.entity.EvalObjResetAndRollBackReqVO;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowInfoBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;

public class EvalObjBackToNodeEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
BasedataEditListener,
AfterF7SelectListener {
    private static final FlowRunSupDomainService flowRunSupDomainService = FlowRunSupDomainService.getInstance();
    private static final ActivityEvaluationObjectEntityService activityEvaluationObjectEntityService = ActivityEvaluationObjectEntityService.getInstance();
    private static final ExecuteSchemeApplicationService EXECUTE_SCHEME_APPLICATION_SERVICE = ExecuteSchemeApplicationService.getInstance();
    private static final AssessActivityApplicationService service = AssessActivityApplicationService.getInstance();
    private static final FlowRunSupDomainService FLOW_SERVICE = FlowRunSupDomainService.getInstance();
    private static final String ACTEVALOBJ = "actevalobj";
    private static final String PERF_FILE = "perffile";
    private static final String FLOWRUPROC = "flowruproc";
    private static final String NODE = "node";
    private static final String INDECATORS = "indecators";
    private static final String TASK = "task";
    private static final String FLOWRUNODE = "flowrunode";
    private static final String HANDLER = "handler";
    private static final String BACKHANDLER = "backhandler";
    private static final String TIPS = "tips";
    private static final String RESSYNCSTATUS = "ressyncstatus";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ruleEdit = (BasedataEdit)this.getView().getControl(NODE);
        BasedataEdit assessformBasedataEdit = (BasedataEdit)this.getControl(FLOWRUNODE);
        BasedataEdit taskEdit = (BasedataEdit)this.getView().getControl(TASK);
        BasedataEdit indecatorEdit = (BasedataEdit)this.getControl(INDECATORS);
        ruleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        assessformBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taskEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taskEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        taskEdit.addBasedataEditListener((BasedataEditListener)this);
        indecatorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initGrid();
        this.initTips();
    }

    public void afterBindingData(AfterBindingDataEvent evt) {
        BasedataEdit edit = (BasedataEdit)evt.getSource();
        Object v = evt.getDataEntity();
        String displayProp = "";
        if (v == null) {
            return;
        }
        BasedataEntityType dt = ((DynamicObject)v).getDataEntityType() instanceof BasedataEntityType ? (BasedataEntityType)((DynamicObject)v).getDataEntityType() : (BasedataEntityType)((BasedataProp)edit.getProperty()).getComplexType();
        if (TASK.equals(edit.getKey())) {
            String editSearchProp;
            String nameKey = HANDLER;
            IDataEntityProperty p2 = dt.findProperty(nameKey);
            if (p2 != null && (displayProp = ((DynamicObject)p2.getValueFast(v)).getLocaleString("name")) instanceof ILocaleString) {
                displayProp = displayProp.toString();
            }
            if (StringUtils.isNotBlank((Object)(editSearchProp = this.getEditSearchProp(edit.getProperty())))) {
                editSearchProp = editSearchProp.toString().replace("name", displayProp == null ? "" : displayProp.toString());
            }
            evt.setDisplayProp(displayProp == null ? "" : displayProp.toString());
            evt.setEditSearchProp(editSearchProp == null ? "" : editSearchProp.toString());
        } else if (INDECATORS.equals(edit.getKey())) {
            // empty if block
        }
    }

    private String getEditSearchProp(IDataEntityProperty property) {
        BasedataProp basedataProp = null;
        basedataProp = property instanceof BasedataProp ? (BasedataProp)property : (BasedataProp)((MulBasedataProp)property).getRefBaseProp();
        return basedataProp.getEditSearchProp();
    }

    private void initTips() {
        this.setTips(TIPS);
        this.setTipsEntryEntity(FLOWRUNODE);
    }

    private void setTips(String key) {
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = service.getTips("epa_backnode", key, dy);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipContent));
            props.put(TIPS, tips);
            this.getView().updateControlMetadata(key, props);
        }
    }

    private void setTipsEntryEntity(String key) {
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = service.getTips("epa_backnode", key, dy);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        Tips tips = new Tips();
        tips.setTriggerType("hover");
        tips.setType("text");
        tips.setContent(new LocaleString(tipContent));
        tips.setPlace("right");
        entryGrid.setColumnProperty(FLOWRUNODE, TIPS, (Object)tips);
    }

    private void initGrid() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField(ACTEVALOBJ, new Object[0]);
        setter.addField(PERF_FILE, new Object[0]);
        this.dealWithSetter(setter);
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void dealWithSetter(TableValueSetter setter) {
        List evaObjs = (List)this.getView().getFormShowParameter().getCustomParam("selectIds");
        DynamicObject[] dysn = activityEvaluationObjectEntityService.queryActivityEvaluationObjectsByIds(evaObjs.toArray(new Long[0]));
        for (int i = 0; i < dysn.length; ++i) {
            DynamicObject dyn = dysn[i];
            setter.addRow(new Object[]{dyn.getLong("id"), dyn.getDynamicObject(PERF_FILE)});
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{FLOWRUNODE, HANDLER, BACKHANDLER, TASK, INDECATORS, "reason"});
            if (!HRStringUtils.equals((String)dyn.getString("assessstaus"), (String)"10") && !HRStringUtils.equals((String)dyn.getString(RESSYNCSTATUS), (String)"20")) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{NODE});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("confirm".equals(key)) {
            long currUserId = RequestContext.get().getCurrUserId();
            boolean hasPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"37LTQSOQE94P");
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u6838\u6d3b\u52a8\u201d\u7684\u201c\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EvalObjBackToNodeEditPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long activityId = (Long)this.getView().getParentView().getFormShowParameter().getCustomParam("activity");
            DynamicObjectCollection dyns = this.getModel().getEntryEntity("entryentity");
            ArrayList<EvalObjResetAndRollBackReqVO> evalBacthBackVOList = new ArrayList<EvalObjResetAndRollBackReqVO>();
            ArrayList<DynamicObject> validError = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> evalfinishtypeError = new ArrayList<DynamicObject>();
            for (DynamicObject data : dyns) {
                EvalObjResetAndRollBackReqVO vo = new EvalObjResetAndRollBackReqVO();
                EvalBatchBackDto dto = new EvalBatchBackDto();
                dto.setActivityId(activityId);
                dto.setEvalObjId(Long.valueOf(data.getLong("actevalobj.id")));
                if (HRStringUtils.equals((String)data.getDynamicObject(ACTEVALOBJ).getString(RESSYNCSTATUS), (String)"20")) {
                    validError.add(data);
                    continue;
                }
                if (data.getString("reason").length() > 255 || data.getLong("node.id") == 0L) {
                    return;
                }
                dto.setBackReason(data.getString("reason"));
                if (data.get(FLOWRUNODE) != null) {
                    dto.setRuNodeId(Long.valueOf(data.getLong("flowrunode.id")));
                    dto.setRuProcId(Long.valueOf(data.getDynamicObject(FLOWRUNODE).getLong("flowruproc.id")));
                } else {
                    dto.setRuNodeId(Long.valueOf(0L));
                    dto.setRuProcId(Long.valueOf(0L));
                }
                if (HRStringUtils.equals((String)data.getDynamicObject(ACTEVALOBJ).getString("evalfinishtype"), (String)"30") && (data.getLong("node.node.id") == 1L || data.getLong("node.node.id") == 4L)) {
                    evalfinishtypeError.add(data);
                    continue;
                }
                ArrayList<EvalBackTaskDto> taskList = new ArrayList<EvalBackTaskDto>(10);
                dto.setTaskList(taskList);
                DynamicObjectCollection tasks = data.getDynamicObjectCollection(TASK);
                List taskIds = tasks.stream().map(task -> task.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                DynamicObjectCollection indecators = data.getDynamicObjectCollection(INDECATORS);
                Map taskIndeRelaMap = indecators.stream().collect(Collectors.groupingBy(k -> k.getDynamicObject("fbasedataid").getLong("id"), Collectors.toList()));
                for (Long taskId : taskIds) {
                    EvalBackTaskDto evalBackTaskDto = new EvalBackTaskDto();
                    evalBackTaskDto.setTaskId(taskId);
                    List indecatorList = taskIndeRelaMap.get(taskId);
                    if (indecatorList != null) {
                        List indecatorIdList = indecatorList.stream().map(indecator -> indecator.getLong("indicator")).collect(Collectors.toList());
                        evalBackTaskDto.setIndicatorIdList(indecatorIdList);
                    } else {
                        evalBackTaskDto.setIndicatorIdList(new ArrayList());
                    }
                    taskList.add(evalBackTaskDto);
                }
                vo.setBusinessType(Long.valueOf(data.getLong("node.node.id")));
                vo.setEvalBatchBackDto(dto);
                evalBacthBackVOList.add(vo);
            }
            if (dyns.size() > 0) {
                AssessActivityAggregationInterfaceService service = new AssessActivityAggregationInterfaceService();
                EvalBatchBackResult result = service.evalObjResetAndRollBack(evalBacthBackVOList);
                if (result.getFailureBackInfoList().size() == 0 && validError.size() == 0 && evalfinishtypeError.size() == 0) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u56de\u6210\u529f\u3002", (String)"EvalObjBackToNodeEditPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    this.getView().close();
                } else {
                    Map<Long, List<EvalBackInfoResult>> map = result.getFailureBackInfoList().stream().collect(Collectors.groupingBy(EvalBackInfoResult::getEvalObjId));
                    String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u6dfb\u52a0\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"EvalObjBackToNodeEditPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{dyns.size(), dyns.size() - map.size() - validError.size() - evalfinishtypeError.size(), map.size() + validError.size() + evalfinishtypeError.size()});
                    IFormView parentView = this.getView().getParentView();
                    StringBuilder message = new StringBuilder();
                    this.buildErrorMessage(result, message, dyns, validError, evalfinishtypeError);
                    this.getView().getParentView().showMessage(title, message.toString(), MessageTypes.Default);
                    this.getView().close();
                }
            } else {
                this.getView().close();
            }
        }
    }

    private void buildErrorMessage(EvalBatchBackResult result, StringBuilder message, DynamicObjectCollection dyns, List<DynamicObject> validError, List<DynamicObject> evalfinishtypeError) {
        Long actevaobjId;
        Map<Long, DynamicObject> actEvaObjMap = dyns.stream().collect(Collectors.toMap(k -> k.getLong("actevalobj.id"), v -> v.getDynamicObject(ACTEVALOBJ)));
        HashSet<Long> exist = new HashSet<Long>(16);
        List results = result.getFailureBackInfoList();
        String errMessage = ResManager.loadKDString((String)"\u7ed3\u679c\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u9000\u56de\u3002", (String)"EvalObjBackToNodeEditPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        for (DynamicObject data : validError) {
            actevaobjId = data.getLong("actevalobj.id");
            if (!exist.add(actevaobjId)) continue;
            if (StringUtils.isNotBlank((CharSequence)message)) {
                message.append("\n");
            }
            message.append(ResManager.loadKDString((String)"{0}-{1}\uff1a{2}", (String)"EvalObjBackToNodeEditPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{actEvaObjMap.get(actevaobjId).getDynamicObject(PERF_FILE).getString("name"), actEvaObjMap.get(actevaobjId).getDynamicObject("person").getString("number"), errMessage}));
        }
        for (DynamicObject data : evalfinishtypeError) {
            actevaobjId = data.getLong("actevalobj.id");
            if (!exist.add(actevaobjId)) continue;
            if (StringUtils.isNotBlank((CharSequence)message)) {
                message.append("\n");
            }
            String evalfinishtypeStr = EntityMetaDataUtils.getEntityComboFieldItemName((String)"epa_actevalobj", (String)"evalfinishtype", (String)data.getDynamicObject(ACTEVALOBJ).getString("evalfinishtype"));
            String evalfinishMessage = ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u8bc4\u4f30\u5b8c\u6210\u65b9\u5f0f\u4e3a\u201c{0}\u201d\uff0c\u4e0d\u53ef\u9000\u56de\u3002", (String)"EvalObjBackToNodeEditPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{evalfinishtypeStr});
            message.append(ResManager.loadKDString((String)"{0}-{1}\uff1a{2}", (String)"EvalObjBackToNodeEditPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{actEvaObjMap.get(actevaobjId).getDynamicObject(PERF_FILE).getString("name"), actEvaObjMap.get(actevaobjId).getDynamicObject("person").getString("number"), evalfinishMessage}));
        }
        for (EvalBackInfoResult backInfoResult : results) {
            if (!exist.add(backInfoResult.getEvalObjId())) continue;
            if (StringUtils.isNotBlank((CharSequence)message)) {
                message.append("\n");
            }
            message.append(ResManager.loadKDString((String)"{0}-{1}\uff1a{2}", (String)"EvalObjBackToNodeEditPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{actEvaObjMap.get(backInfoResult.getEvalObjId()).getDynamicObject(PERF_FILE).getString("name"), actEvaObjMap.get(backInfoResult.getEvalObjId()).getDynamicObject("person").getString("number"), backInfoResult.getDealReason()}));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter filter;
        DynamicObject entryData;
        int row;
        IDataModel entryOperate;
        String fieldKey = ((Control)beforeF7SelectEvent.getSource()).getKey();
        if (FLOWRUNODE.equals(fieldKey)) {
            entryOperate = this.getView().getModel();
            row = entryOperate.getEntryCurrentRowIndex("entryentity");
            entryData = entryOperate.getEntryRowEntity("entryentity", row);
            filter = null;
            filter = entryData.getLong("node.node.id") == 1L ? (entryData.getDynamicObject(ACTEVALOBJ).getLong("formulateflow.id") != 0L ? new QFilter(FLOWRUPROC, "=", (Object)entryData.getDynamicObject(ACTEVALOBJ).getLong("formulateflowins.id")) : new QFilter(FLOWRUPROC, "=", (Object)0)) : (entryData.getLong("node.node.id") == 4L ? new QFilter(FLOWRUPROC, "=", (Object)entryData.getDynamicObject(ACTEVALOBJ).getLong("evalflowins.id")) : new QFilter(FLOWRUPROC, "=", (Object)0));
            beforeF7SelectEvent.getCustomQFilters().add(filter);
        }
        if (NODE.equals(fieldKey)) {
            entryOperate = this.getView().getModel();
            row = entryOperate.getEntryCurrentRowIndex("entryentity");
            DynamicObject data2 = activityEvaluationObjectEntityService.loadSingle((Object)entryOperate.getEntryRowEntity("entryentity", row).getDynamicObject(ACTEVALOBJ).getLong("id"));
            filter = new QFilter("node.id", "in", (Object)new Long[]{1L, 4L, 5L}).and(new QFilter("defproc", "=", (Object)data2.getDynamicObject("activity").getLong("perfworkflow.id"))).and(new QFilter("isshow", "=", (Object)true));
            if (data2.getLong("assessstaus") == 20L) {
                filter.and(new QFilter("node.id", "<=", (Object)data2.getLong("assessnode.id")));
            }
            beforeF7SelectEvent.getCustomQFilters().add(filter);
        }
        if (TASK.equals(fieldKey)) {
            entryOperate = this.getView().getModel();
            row = entryOperate.getEntryCurrentRowIndex("entryentity");
            entryData = entryOperate.getEntryRowEntity("entryentity", row);
            filter = new QFilter("flowrunode.id", "=", (Object)entryData.getLong("flowrunode.id"));
            ListShowParameter showParameter = new ListShowParameter();
            if (entryData.getLong("node.node.id") == 1L) {
                showParameter.setBillFormId("epa_formulateflowrutask");
                String title = ResManager.loadKDString((String)"\u6307\u6807\u5236\u5b9a\u4efb\u52a1", (String)"EvalObjBackToNodeEditPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                beforeF7SelectEvent.getFormShowParameter().setCaption(title);
            } else if (entryData.getLong("node.node.id") == 4L) {
                showParameter.setBillFormId("epa_evalflowrutask");
            }
            showParameter.setLookUp(true);
            beforeF7SelectEvent.setFormShowParameter((FormShowParameter)showParameter);
            beforeF7SelectEvent.getCustomQFilters().add(filter);
        }
        if (INDECATORS.equals(fieldKey)) {
            entryOperate = this.getView().getModel();
            row = entryOperate.getEntryCurrentRowIndex("entryentity");
            entryData = entryOperate.getEntryRowEntity("entryentity", row);
            DynamicObjectCollection coll = entryData.getDynamicObjectCollection(TASK);
            List taskIds = coll.stream().map(data -> data.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            QFilter filter2 = new QFilter("id", "in", taskIds);
            beforeF7SelectEvent.getCustomQFilters().add(filter2);
        }
    }

    public void beforeSetItemValue(BeforeSetItemValueEventArgs e) {
        BasedataEntityType dataEntityType;
        super.beforeSetItemValue(e);
        Object value = e.getValue();
        String searchKey = null;
        IDataEntityProperty property = e.getProperty();
        if (FLOWRUNODE.equals(property.getName())) {
            dataEntityType = (BasedataEntityType)((BasedataProp)property).getDynamicComplexPropertyType();
            dataEntityType.setNumberProperty("name");
        } else if (NODE.equals(property.getName())) {
            dataEntityType = (BasedataEntityType)((BasedataProp)property).getDynamicComplexPropertyType();
            dataEntityType.setNumberProperty("customname");
        } else if (TASK.equals(property.getName())) {
            dataEntityType = (BasedataEntityType)((BasedataProp)((MulBasedataProp)property).getRefBaseProp()).getDynamicComplexPropertyType();
            dataEntityType.setNumberProperty("handler.name");
        }
        if (TASK.equals(property.getName())) {
            searchKey = "handler.name";
        }
        if (StringUtils.isBlank((CharSequence)searchKey)) {
            searchKey = "name";
        }
        String[] split = value.toString().split(",|;");
        String[] qfliterArr = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            qfliterArr[i] = split[i].split("[( )]")[0];
        }
        e.setSearchKey(searchKey);
        e.setSearchArgs(qfliterArr);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        DynamicObject flowrunnodeDyn;
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        IDataModel entryOperate = this.getView().getModel();
        int row = entryOperate.getEntryCurrentRowIndex("entryentity");
        DynamicObject entryData = entryOperate.getEntryRowEntity("entryentity", row);
        List evaObjs = (List)this.getView().getFormShowParameter().getCustomParam("selectIds");
        WorkflowInfoBo bo = flowRunSupDomainService.getFlowInfoByActObjId(evaObjs);
        ChangeData changeData = args.getChangeSet()[0];
        if (FLOWRUNODE.equals(fieldKey)) {
            this.getModel().setValue(HANDLER, null, row);
            this.getModel().setValue(INDECATORS, null, row);
            this.getModel().setValue("reason", null, row);
            flowrunnodeDyn = (DynamicObject)changeData.getNewValue();
            if (flowrunnodeDyn != null) {
                if (flowrunnodeDyn.getBoolean("iscrossnode")) {
                    this.getView().setEnable(Boolean.valueOf(true), row, new String[]{INDECATORS});
                    this.getModel().setValue(TASK, null, row);
                    this.getView().setEnable(Boolean.valueOf(false), row, new String[]{TASK});
                    return;
                }
                this.getView().setEnable(Boolean.valueOf(false), row, new String[]{INDECATORS});
                this.getView().setEnable(Boolean.valueOf(true), row, new String[]{TASK});
                if (bo != null) {
                    Map taskMap = bo.getKeyNodeIdValTask();
                    this.getView().setEnable(Boolean.valueOf(true), row, new String[]{TASK});
                    if (taskMap.get(flowrunnodeDyn.getLong("id")) != null && ((List)taskMap.get(flowrunnodeDyn.getLong("id"))).size() == 1) {
                        Long[] ids = ((List)taskMap.get(flowrunnodeDyn.getLong("id"))).stream().map(data -> data.getLong("id")).collect(Collectors.toList()).toArray(new Long[0]);
                        this.getModel().setValue(TASK, (Object)ids, row);
                    } else {
                        this.getModel().setValue(TASK, null, row);
                    }
                    DynamicObjectCollection coll = entryData.getDynamicObjectCollection(TASK);
                    StringBuilder sb = new StringBuilder();
                    for (DynamicObject taskDyn : coll) {
                        if (sb.toString().length() > 0) break;
                        Long flowrurole = taskDyn.getDynamicObject("fbasedataid").getLong("id");
                        DynamicObject roles = (DynamicObject)bo.getKeyTaskIdValRole().get(flowrurole);
                        sb.append(roles.getString("name"));
                    }
                    this.getModel().setValue(HANDLER, (Object)sb.toString(), row);
                }
            } else {
                this.getModel().setValue(TASK, null, row);
                this.getView().setEnable(Boolean.valueOf(false), row, new String[]{TASK});
            }
        }
        if (NODE.equals(fieldKey)) {
            this.getModel().setValue(FLOWRUNODE, null, row);
            this.getModel().setValue(HANDLER, null, row);
            this.getModel().setValue(TASK, null, row);
            this.getModel().setValue(INDECATORS, null, row);
            this.getModel().setValue("reason", null, row);
            flowrunnodeDyn = (DynamicObject)changeData.getNewValue();
            this.setEnable(row, entryData, bo, flowrunnodeDyn);
            if (((DynamicObject)changeData.getNewValue()).getDynamicObject(NODE).getLong("id") == 5L) {
                this.getView().setEnable(Boolean.valueOf(true), row, new String[]{"reason"});
            }
        }
        if (TASK.equals(fieldKey)) {
            DynamicObjectCollection coll = entryData.getDynamicObjectCollection(TASK);
            Map<Long, List<DynamicObject>> roleMap = coll.stream().collect(Collectors.groupingBy(data -> data.getDynamicObject("fbasedataid").getLong("flowrurole.id")));
            if (roleMap.size() > 1) {
                String errMessage = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u89d2\u8272\u7684\u4efb\u52a1\u3002", (String)"EvalObjBackToNodeEditPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(errMessage);
                this.getModel().setValue(TASK, changeData.getOldValue());
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (DynamicObject taskDyn : coll) {
                if (sb.toString().length() > 0) break;
                Long flowrurole = taskDyn.getDynamicObject("fbasedataid").getLong("id");
                if (bo == null) continue;
                DynamicObject roles = (DynamicObject)bo.getKeyTaskIdValRole().get(flowrurole);
                sb.append(roles.getString("name"));
            }
            this.getModel().setValue(HANDLER, (Object)sb.toString(), row);
        }
    }

    private void setEnable(int row, DynamicObject entryData, WorkflowInfoBo bo, DynamicObject flowrunnodeDyn) {
        if (bo != null) {
            Map valProcs = bo.getKeyActObjIdValProc();
            Map keyProcIdValNodes = bo.getKeyProcIdValNode();
            boolean isEnable = false;
            if (valProcs.get(entryData.getLong("actevalobj.id")) != null) {
                List procs = (List)valProcs.get(entryData.getLong("actevalobj.id"));
                for (DynamicObject proc : procs) {
                    if (keyProcIdValNodes == null) break;
                    if (keyProcIdValNodes.get(proc.getLong("id")) == null || ((List)keyProcIdValNodes.get(proc.getLong("id"))).size() == 0) continue;
                    List valNodes = (List)keyProcIdValNodes.get(proc.getLong("id"));
                    if (flowrunnodeDyn == null) continue;
                    if (flowrunnodeDyn.getLong("node.id") == 1L && proc.getLong("workflowtype") == 1L) {
                        for (DynamicObject valNode : valNodes) {
                            if (valNode.getInt("index") != 1) continue;
                            this.getModel().setValue(FLOWRUNODE, (Object)valNode.getLong("id"), row);
                        }
                    }
                    if ((proc.getLong("workflowtype") != 2L || flowrunnodeDyn.getLong("node.id") != 4L) && proc.getLong("workflowtype") != flowrunnodeDyn.getLong("node.id")) continue;
                    isEnable = true;
                    break;
                }
            }
            if (isEnable) {
                this.getView().setEnable(Boolean.valueOf(isEnable), row, new String[]{FLOWRUNODE, "reason"});
            } else {
                this.getView().setEnable(Boolean.valueOf(isEnable), row, new String[]{FLOWRUNODE, TASK, INDECATORS, "reason"});
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        String fieldKey = ((Control)afterF7SelectEvent.getSource()).getKey();
        if (TASK.equals(fieldKey)) {
            ListSelectedRowCollection rows = afterF7SelectEvent.getListSelectedRowCollection();
            List tasks = rows.stream().map(data -> (Long)data.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObject[] taskDyns = FLOW_SERVICE.queryTaskByPks(tasks);
            Map<Long, List<DynamicObject>> map = Arrays.stream(taskDyns).collect(Collectors.groupingBy(data -> data.getLong("flowrurole.id")));
        }
    }
}

