/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.actevalobj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessGroupApplicationService;
import kd.opmc.epa.business.domain.perfworkflow.service.PerfWorkFlowDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;

public class EvalObjBaseList
extends HRDataBaseList {
    private static final String PASSESSNODE_CUSTOMNAME = "passessnode.customname";
    private static final String PASSESSNODE_ID = "passessnode.id";
    private static final String PERFFILE_PMDPERSON_NAME = "perffile.pmdperson.name";
    private static final String BUSSINESSFIELD_NUMBER = "105010_S";
    private static final Log LOG = LogFactory.getLog(EvalObjBaseList.class);
    private static final AssessGroupApplicationService ASSESS_GROUP_APPLICATION_SERVICE = AssessGroupApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final PerfWorkFlowDomainService PERF_WORK_FLOW_DOMAIN_SERVICE = PerfWorkFlowDomainService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("assgroup.name".equals(fieldName) || "assgroup.id".equals(fieldName)) {
            List qFilters = args.getQfilters();
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            DynamicObjectCollection assgroupentry = activity.getDynamicObjectCollection("assgroupentry");
            List ids = assgroupentry.stream().map(dy -> dy.getDynamicObject("assgroup").getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", ids));
        } else if (PASSESSNODE_CUSTOMNAME.equals(fieldName) || PASSESSNODE_ID.equals(fieldName)) {
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            List qFilters = args.getQfilters();
            long perfWorkFlowId = activityDynObj.getLong("perfworkflow.id");
            qFilters.add(new QFilter("isshow", "=", (Object)"1"));
            qFilters.add(new QFilter("defproc", "=", (Object)perfWorkFlowId));
        } else if (PERFFILE_PMDPERSON_NAME.equals(fieldName)) {
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("bussinessfield.number", "=", (Object)BUSSINESSFIELD_NUMBER));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List<ComboItem> combos = this.buildComboItems();
        List<ComboItem> nodeCombos = this.buildNodeComboItems();
        List schemeFilterCols = args.getSchemeFilterColumns().stream().map(filterFilterCol -> (SchemeFilterColumn)filterFilterCol).collect(Collectors.toList());
        for (SchemeFilterColumn schemeFilterColumn : schemeFilterCols) {
            String fieldName = schemeFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"assgroup.name")) {
                schemeFilterColumn.setComboItems(combos);
            }
            if (!HRStringUtils.equals((String)fieldName, (String)PASSESSNODE_CUSTOMNAME)) continue;
            schemeFilterColumn.setComboItems(nodeCombos);
        }
        List commonFilterCols = args.getCommonFilterColumns().stream().map(commonFilterCol -> (CommonFilterColumn)commonFilterCol).collect(Collectors.toList());
        for (CommonFilterColumn commonFilterColumn : commonFilterCols) {
            String fieldName = commonFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"assgroup.name")) {
                commonFilterColumn.setComboItems(combos);
            }
            if (!HRStringUtils.equals((String)fieldName, (String)PASSESSNODE_CUSTOMNAME)) continue;
            commonFilterColumn.setComboItems(nodeCombos);
        }
    }

    private List<ComboItem> buildComboItems() {
        DynamicObject[] assessGroup;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        DynamicObjectCollection assgroupentry = activity.getDynamicObjectCollection("assgroupentry");
        for (DynamicObject group : assessGroup = (DynamicObject[])assgroupentry.stream().map(dy -> dy.getDynamicObject("assgroup")).toArray(DynamicObject[]::new)) {
            if (group == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(group.getPkValue()));
            item.setCaption(new LocaleString(group.getString("name")));
            item.setValue(String.valueOf(group.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private List<ComboItem> buildNodeComboItems() {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        long perfWorkFlowId = activityDynObj.getLong("perfworkflow.id");
        DynamicObject workFlowDynObj = PERF_WORK_FLOW_DOMAIN_SERVICE.loadSingleWorkFlow(perfWorkFlowId);
        DynamicObjectCollection workEntryEntity = workFlowDynObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject group : workEntryEntity) {
            if (group == null || !group.getBoolean("isshow")) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(group.getPkValue()));
            item.setCaption(new LocaleString(group.getString("customname")));
            item.setValue(String.valueOf(group.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "refresh": {
                this.refreshCount();
                break;
            }
            case "importindsoi": {
                Object[] selectIds = this.getImportIds();
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_importindsoistart");
                String id = MetadataDao.getIdByNumber((String)"epa_objimportscoreind", (MetaCategory)MetaCategory.Form);
                FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
                showParameter.setCustomParam("ListName", (Object)formMeta.getName().getLocaleValue());
                showParameter.setCustomParam("formId", (Object)"epa_objimportscoreind");
                showParameter.setCustomParam("RealPermissionEntityId", (Object)"epa_objimportscoreind");
                showParameter.setCustomParam("RealPermissionEntityId", (Object)"epa_objimportscoreind");
                showParameter.setCustomParam("activity", this.getView().getFormShowParameter().getCustomParam("activity"));
                showParameter.setCustomParam("ServiceAppId", (Object)"epa");
                showParameter.setCustomParam("selectIds", (Object)selectIds);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setHasRight(true);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    private Object[] getImportIds() {
        String nodeStatus;
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        if (!ObjectUtils.isEmpty((Object[])primaryKeyValues)) {
            return primaryKeyValues;
        }
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        String formId = this.getView().getFormShowParameter().getFormId();
        Long nodeId = NodeTabMapEnum.EVAL_PROCESS.getNodeId();
        boolean isComplete = false;
        if ("epa_tobeevaltemplate".equals(formId)) {
            nodeIndex = nodeIndex - 1;
            nodeId = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getNodeIdByActIdAndIndex(activityId, nodeIndex.intValue());
            nodeStatus = AssessNodeStatusEnum.getLastNodeStatus((Long)nodeId).getStatus();
        } else if ("epa_evallisttemplate".equals(formId)) {
            nodeStatus = AssessNodeStatusEnum.EVALUATING.getStatus();
        } else {
            nodeStatus = AssessNodeStatusEnum.EVALUATED.getStatus();
            isComplete = true;
        }
        DynamicObject[] actObjIds = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getActObjIds(activityId, nodeIndex, nodeId, nodeStatus, isComplete);
        return Arrays.stream(actObjIds).map(DataEntityBase::getPkValue).toArray();
    }

    private void refreshCount() {
        IFormView parentView = this.getView().getParentView();
        if (!ObjectUtils.isEmpty((Object)parentView)) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("fseq", "person.headsculpture", "perffile.name", "perffile.number", "person.name", "person.number", "perffile.billno");
        LOG.info("EvalObjBaseList.beforeCreateListColumns fixedColumnList : {}", fixedColumnList);
        fixedColumnList.forEach(column -> {
            LOG.info("EvalObjBaseList.beforeCreateListColumns  column : {}", column);
            if (args.getListColumn(column) != null) {
                LOG.info("EvalObjBaseList.beforeCreateListColumns  args.getListColumn(column) != null : {}", column);
                args.getListColumn(column).setFixed(true);
            }
        });
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        BosListUtil.setListBgColor(this.getView(), "#ffffff");
        BosListUtil.setGripAndMargin(this.getView());
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        args.setEnableCustomSum(false);
        super.setEnableCustomSum(args);
    }
}

