/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.actevalobj;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessGroupApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.task.ActivityAddNotJoinTask;
import kd.opmc.epa.business.utils.ActivityManageUtils;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.utils.ActivityDispatchUtils;

public class EvalObjNotLoinList
extends EvalObjBaseList {
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final AssessGroupApplicationService ASSESS_GROUP_APPLICATION_SERVICE = AssessGroupApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final AssessObjectApplicationService ASSESS_OBJECT_APPLICATION_SERVICE = AssessObjectApplicationService.getInstance();
    private static final String SUCCESS_LIST = "notjoin_success_list";
    private static final String FAILED_LIST = "notjoin_faild_list";
    private static final String ALL_LIST = "notjoin_all_list";
    private static final String OPERATE_JOIN_ACTIVITY = "joinactivity";
    private static final String NOT_JOIN_ACTOBJ = "notJoinIds";

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List<String> fixedColumnList = Arrays.asList("fseq", "person.headsculpture", "perffile.name", "perffile.number", "person.name", "person.number");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        DynamicObject activity = this.getCurActivity();
        long schemeId = activity.getDynamicObject("scheme").getLong("id");
        List qFilters = evt.getQFilters();
        ActivityManageUtils.generatorFilter((DynamicObject)activity, (long)schemeId, (List)qFilters);
    }

    private Set<Long> getScopeGroupsByAct(DynamicObject activity) {
        DynamicObject executeScheme = activity.getDynamicObject("executescheme");
        Long assessScopeId = executeScheme.getDynamicObject("assessscope").getLong("id");
        DynamicObject[] assessGroups = ASSESS_GROUP_APPLICATION_SERVICE.queryListByScopeId(true, assessScopeId);
        return Arrays.stream(assessGroups).map(group -> group.getLong("id")).collect(Collectors.toSet());
    }

    private DynamicObject getCurActivity() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam("activity");
        return ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(customParam);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if (OPERATE_JOIN_ACTIVITY.equals(source.getOperateKey())) {
            DynamicObject curActivity = this.getCurActivity();
            String activityStatus = curActivity.getString("activitystatus");
            if (ActivityStatusEnum.TO_BE_EXECUTE.getValue().equals(activityStatus)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_activitystartup");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                Long id = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                DynamicObject assessActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)id);
                showParameter.setCustomParam("activity_id", (Object)id);
                if (assessActivity != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    showParameter.setCustomParam("periodstartdate", (Object)sdf.format(assessActivity.getDate("periodstartdate")));
                    showParameter.setCustomParam("periodenddate", (Object)sdf.format(assessActivity.getDate("periodenddate")));
                }
                showParameter.setCustomParam("confirmupdate", (Object)Boolean.TRUE);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_activity"));
                this.getView().showForm(showParameter);
                args.setCancel(true);
                return;
            }
            if (CollectionUtils.isEmpty((Collection)this.getSelectedRows())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvalObjNotLoinList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (ActivityStatusEnum.COMPLETED.getValue().equals(activityStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u8be5\u529f\u80fd\u4e0d\u53ef\u7528", (String)"EvalObjNotLoinList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("activity", Long.toString(activityId));
            operateOption.setVariableValue("batchop_batchsize", "0");
            source.setOption(operateOption);
            this.syncAddActObject(activityId);
        }
    }

    private void syncAddActObject(Long activityId) {
        ArrayList sucessList = new ArrayList();
        ArrayList failedList = new ArrayList();
        StringBuilder errorMessage = new StringBuilder();
        Object[] objIds = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        ActivityManageUtils.valid(sucessList, failedList, (StringBuilder)errorMessage, (Object[])objIds, (Long)activityId);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        HashMap<String, String> result = new HashMap<String, String>(16);
        params.put("activity_id", activityId);
        params.put(NOT_JOIN_ACTOBJ, sucessList);
        result.put(SUCCESS_LIST, String.valueOf(sucessList.size()));
        result.put(FAILED_LIST, String.valueOf(failedList.size()));
        result.put("all", String.valueOf(this.getSelectedRows().size()));
        result.put("errorMessage", errorMessage.toString());
        this.getView().getParentView().getPageCache().put(result);
        ActivityDispatchUtils.dispatch((AbstractFormPlugin)this, params, ActivityAddNotJoinTask.class.getName(), ResManager.loadKDString((String)"\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61", (String)"EvalObjNotLoinList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), true, "auto_add_evaluation_objects");
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if (OPERATE_JOIN_ACTIVITY.equals(source.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (!OPERATE_JOIN_ACTIVITY.equals(callBackId) || event.getResult().equals((Object)MessageBoxResult.Yes)) {
            // empty if block
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("auto_add_evaluation_objects".equals(closedCallBackEvent.getActionId())) {
            IFormView parentView = this.getView().getParentView();
            Long failedCount = Long.parseLong(parentView.getPageCache().get(FAILED_LIST));
            String title = null;
            title = failedCount > 0L ? ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u6dfb\u52a0\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"EvalObjNotLoinList_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{parentView.getPageCache().get("all"), parentView.getPageCache().get(SUCCESS_LIST), parentView.getPageCache().get(FAILED_LIST)}) : ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u6210\u529f\u6dfb\u52a0{1}\u6761\u3002", (String)"EvalObjNotLoinList_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{parentView.getPageCache().get("all"), parentView.getPageCache().get(SUCCESS_LIST)});
            this.getView().showMessage(title, parentView.getPageCache().get("errorMessage"), MessageTypes.Default);
            this.getView().invokeOperation("refresh");
        }
        if ("epa_activity".equals(closedCallBackEvent.getActionId())) {
            Map result = (Map)closedCallBackEvent.getReturnData();
            if (result == null) {
                return;
            }
            BaseShowParameter showParameter = (BaseShowParameter)this.getView().getParentView().getFormShowParameter();
            Object pkId = showParameter.getPkId();
            DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(pkId);
            activityDynObj.set("activitystatus", (Object)ActivityStatusEnum.EXECUTING.getValue());
            activityDynObj.set("startupdate", (Object)new Date());
            ASSESS_ACTIVITY_APPLICATION_SERVICE.updateActivityDynObj(activityDynObj);
            if (HRStringUtils.equals((String)((String)result.get("data")), (String)"1")) {
                String caption = FormMetadataCache.getFormConfig((String)"epa_activity").getCaption().getLocaleValue();
                long currUserId = RequestContext.get().getCurrUserId();
                boolean hasPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"1//K7E3YE3D6");
                if (!hasPermission) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u542f\u52a8\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EvalObjNotLoinList_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]), caption));
                    return;
                }
                this.syncAddActObject((Long)pkId);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u6210\u529f\u3002", (String)"EvalObjNotLoinList_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        ListSelectedRowCollection listSelectedRows = evt.getListSelectedRowCollection();
        if (listSelectedRows.size() == 0) {
            return;
        }
        List selectIds = listSelectedRows.stream().map(data -> (Long)data.getPrimaryKeyValue()).collect(Collectors.toList());
        List sortIds = listSelectedRows.stream().map(data -> data.getPrimaryKeyValue() + "").collect(Collectors.toList());
        DynamicObject[] datas = ASSESS_OBJECT_APPLICATION_SERVICE.loadDynamicObjectArrayByIds(selectIds.toArray());
        Map<Long, String> map = Arrays.stream(datas).collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString("person.name")));
        for (ListSelectedRow row : listSelectedRows) {
            row.setName(map.get(row.getPrimaryKeyValue()));
        }
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection all = list.sortListSelectedRowsByKeys(sortIds);
        for (ListSelectedRow row : all) {
            row.setName(map.get(row.getPrimaryKeyValue()));
        }
    }
}

