/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.actevalobj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.utils.ShowConfigTipsUtils;

public class EvalObjectInHandList
extends EvalObjBaseList {
    private final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATIONSERVICE = AssessActivityApplicationService.getInstance();

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        List qFilters = evt.getQFilters();
        QFilter qFilter = new QFilter("assessstaus", "!=", (Object)AssessStausEnum.Exited.getStatus());
        qFilter.and(new QFilter("activity", "=", (Object)activityId));
        qFilters.add(qFilter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    AssessNodeStatusEnum statusEnum;
                    Long nodeId = row.getLong("assessnode.id");
                    String nodestatus = row.getString("nodestatus");
                    if (HRStringUtils.isEmpty((String)nodestatus) || (statusEnum = AssessNodeStatusEnum.getEnumByIdAndStatus((Long)nodeId, (String)nodestatus)) == null) continue;
                    String statusName = statusEnum.getText();
                    row.set("nodestatus", (Object)statusName);
                }
                return rows;
            }

            public List<QFilter> getQFilters() {
                List qFilterList = super.getQFilters();
                boolean isset = false;
                for (int i = 0; i < qFilterList.size(); ++i) {
                    QFilter qFilter = (QFilter)qFilterList.get(i);
                    String property = qFilter.getProperty();
                    if (property.contains("passessnode")) {
                        qFilterList.remove(i);
                        --i;
                        DynamicObject[] passessNodeDyn = null;
                        if (qFilter.getValue() instanceof Long) {
                            ArrayList<Long> passnodelist = new ArrayList<Long>();
                            passnodelist.add((Long)qFilter.getValue());
                            passessNodeDyn = EvalObjectInHandList.this.ASSESS_ACTIVITY_APPLICATIONSERVICE.queryNode(passnodelist);
                        } else {
                            passessNodeDyn = EvalObjectInHandList.this.ASSESS_ACTIVITY_APPLICATIONSERVICE.queryNode((List)qFilter.getValue());
                        }
                        qFilterList.add(new QFilter("assessnode.id", "in", Arrays.stream(passessNodeDyn).map(data -> data.getLong("node.id")).collect(Collectors.toList())));
                    }
                    List nests = qFilter.getNests(true);
                    if (!property.contains("nodestatus") && nests.isEmpty() || isset) continue;
                    if (qFilter.getValue() != null && property.contains("nodestatus")) {
                        String nodeName = qFilter.getValue().toString().replace("%", "");
                        String regex = "[\\u4E00-\\u9FFF]+";
                        Pattern pattern = Pattern.compile(regex);
                        Matcher matcher = pattern.matcher(nodeName);
                        while (matcher.find()) {
                            qFilterList.remove(i);
                            --i;
                            List nodeIds = AssessNodeStatusEnum.getNodeIdByName((String)nodeName, (QFilter)qFilter);
                            qFilterList.add(new QFilter("nodestatus", "in", (Object)nodeIds));
                            isset = Boolean.TRUE;
                        }
                    }
                    for (int j = 0; j < nests.size(); ++j) {
                        QFilter.QFilterNest nest = (QFilter.QFilterNest)nests.get(j);
                        QFilter filter = nest.getFilter();
                        if (filter.getValue() == null || !filter.getProperty().contains("nodestatus") || isset) continue;
                        String nodeName = filter.getValue().toString().replace("%", "");
                        String regex = "[\\u4E00-\\u9FFF]+";
                        Pattern pattern = Pattern.compile(regex);
                        Matcher matcher = pattern.matcher(nodeName);
                        while (matcher.find()) {
                            List nodeIds = AssessNodeStatusEnum.getNodeIdByName((String)nodeName, (QFilter)filter);
                            filter = new QFilter("nodestatus", "in", (Object)nodeIds);
                            nest.remove();
                            qFilter.and(filter);
                            isset = Boolean.TRUE;
                        }
                    }
                }
                return qFilterList;
            }
        });
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        for (IListColumn listColumn : columns) {
            DynamicObject dy = this.getModel().getDataEntity();
            if (HRStringUtils.equals((String)"assessnode.name", (String)listColumn.getListFieldKey()) && listColumn instanceof ListColumn) {
                ShowConfigTipsUtils.showListColumnTips((ListColumn)listColumn, "assessnode", "epa_actevalobj", dy);
                continue;
            }
            if (!HRStringUtils.equals((String)"nodestatus", (String)listColumn.getListFieldKey()) || !(listColumn instanceof ListColumn)) continue;
            ShowConfigTipsUtils.showListColumnTips((ListColumn)listColumn, "nodestatus", "epa_actevalobj", dy);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("assessexit".equals(operateKey)) {
            this.getView().getParentView().invokeOperation("refreshjoinedtab");
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().invokeOperation("refresh");
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List list = args.getFilterParameter().getQFilters();
        ArrayList<QFilter> newQFlist = new ArrayList<QFilter>();
        for (QFilter qFilter : list) {
            String property = qFilter.getProperty();
            if (property.contains("passessnode")) {
                DynamicObject[] passessNodeDyn = null;
                if (qFilter.getValue() instanceof Long) {
                    ArrayList<Long> passnodelist = new ArrayList<Long>();
                    passnodelist.add((Long)qFilter.getValue());
                    passessNodeDyn = this.ASSESS_ACTIVITY_APPLICATIONSERVICE.queryNode(passnodelist);
                } else {
                    passessNodeDyn = this.ASSESS_ACTIVITY_APPLICATIONSERVICE.queryNode((List)qFilter.getValue());
                }
                newQFlist.add(new QFilter("assessnode.id", "in", Arrays.stream(passessNodeDyn).map(data -> data.getLong("node.id")).collect(Collectors.toList())));
                continue;
            }
            newQFlist.add(qFilter);
        }
        args.getFilterParameter().setQFilters(newQFlist);
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterCols = args.getCommonFilterColumns().stream().map(commonFilterCol -> (CommonFilterColumn)commonFilterCol).collect(Collectors.toList());
        for (CommonFilterColumn commonFilterColumn : commonFilterCols) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!HRStringUtils.equals((String)fieldName, (String)"assessstaus")) continue;
            commonFilterColumn.getComboItems();
            String assessstaus = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("assessstaus");
            commonFilterColumn.setDefaultValue(assessstaus);
        }
    }
}

