/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.activity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.dynpermission.DynPermissionConfigService;
import kd.opmc.epa.business.domain.activity.service.AssessActivityDomainService;
import kd.opmc.epa.business.domain.indicator.imp.helper.DataValidateServiceHelper;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.common.constants.AssessProcessConstants;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.constants.PassNodeConstants;
import kd.opmc.epa.common.constants.PerfWorkFlowConstants;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeWorkFlowTypeEnum;
import kd.opmc.epa.common.enums.assessrule.EvalProcessOperationEnum;
import kd.opmc.epa.common.enums.per.GradeRuleSrcEnum;
import kd.opmc.epa.common.vo.PerfworkflowBO;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.epa.formplugin.web.activitymanage.activity.DynamicPermssionConfigCacheUtils;
import kd.opmc.epa.formplugin.web.activitymanage.activity.NodeToCheckBoxEnum;
import kd.opmc.epa.formplugin.web.activitymanage.utils.ActivityTabsUtils;
import kd.opmc.epa.formplugin.web.utils.NodeCheckBoxMapUtils;
import kd.opmc.epa.formplugin.web.utils.permission.AssActivityPermissionUtils;
import kd.opmc.pbs.business.application.service.assessnode.AssessNodeApplicationService;
import kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.model.CheckFlowBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;
import kd.opmc.pbs.business.tips.ShowConfigTipsUtils;

public class ActivityPerfWorkFlowEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
TabSelectListener,
RowClickEventListener,
AssessRuleConstants,
AssessProcessConstants,
PerfWorkFlowConstants {
    private static final Log LOG = LogFactory.getLog(ActivityPerfWorkFlowEdit.class);
    protected static final WorkFlowApplicationService WORK_FLOW_APPLICATION_SERVICE = WorkFlowApplicationService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final FlowDefProcEntityService FLOW_DEF_PROC_ENTITY_SERVICE = FlowDefProcEntityService.getInstance();
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final IEPAActevalobjService EPA_ACTEVAOBJ_SERVICE = IEPAActevalobjService.getInstance();
    private static final String CUSTOMCONTROLAP = "customcontrolap";
    protected static final String EPA_WORKFLOWTYPE = "epaworkflowtype";
    public static final String EPA_EVAWORKFLOW = "10";
    public static final String ITEM_ENTRY_ENTITY = "itementryentity";
    private static final String CARD_ENTRY_INFO_LAP = "cardentryinfolap";
    private static final String CHILDREN = "children";
    private static final String CURRENTAP = "currentap";
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final AssessActivityDomainService ASSESS_ACTIVITY_DOMAIN_SERVICE = AssessActivityDomainService.getInstance();
    public static final String EPA_INTERVIEWWORKFLOW = "20";
    public static final String DYNAMIC_PERMISSION_CACHE_KEY = "dynamic_permission_cache_key";

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && ("epa_scheme".equals(parentView.getEntityId()) || "epa_activity".equals(parentView.getEntityId()))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbmain"});
        }
        this.getPageCache().put("change_entity_flag", "no");
        this.cacheCustomName();
        String workflowType = (String)this.getModel().getValue(EPA_WORKFLOWTYPE);
        if (EPA_EVAWORKFLOW.equals(workflowType) || HRStringUtils.isEmpty((String)workflowType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"perfinterview", NodeToCheckBoxEnum.PERF_INTERVIEW.getCheckBoxKey()});
        } else if (EPA_INTERVIEWWORKFLOW.equals(workflowType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"perfinterview"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "targetformulate", "evalprocess", "perfsum", "perfcalibration", "resultconfirm"});
        }
        Object option = this.getView().getFormShowParameter().getCustomParams().get("option");
        if (null != option && "insertdata_his".equals(option.toString())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{EPA_WORKFLOWTYPE});
        }
    }

    private void cacheCustomName() {
        this.getPageCache().put("formulateTargetcustomname", String.valueOf(this.getModel().getValue("targetcustomname")));
        this.getPageCache().put("evaluateTargetcustomname", String.valueOf(this.getModel().getValue("evalcustomname")));
        this.getPageCache().put("sumTargetcustomname", String.valueOf(this.getModel().getValue("sumcustomname")));
        this.getPageCache().put("perfTargetcustomname", String.valueOf(this.getModel().getValue("perfcustomname")));
        this.getPageCache().put("interviewTargetcustomname", String.valueOf(this.getModel().getValue("interviewcustomname")));
        this.getPageCache().put("resultTargetcustomname", String.valueOf(this.getModel().getValue("resultcustomname")));
    }

    protected DynamicObject[] copyFlowDefs(DynamicObject[] flowDefProc, long[] defIds) {
        DynamicObject[] newFlowDefs = new DynamicObject[flowDefProc.length];
        int i = 0;
        for (DynamicObject oldFlowDef : flowDefProc) {
            DynamicObjectCollection nodeentry = oldFlowDef.getDynamicObjectCollection("nodeentry");
            for (DynamicObject defNode : nodeentry) {
                defNode.set("sourcenodeid", (Object)defNode.getLong("id"));
            }
            DynamicObject newFlowDef = FLOW_DEF_PROC_ENTITY_SERVICE.generateEmptyDynamicObject();
            HashSet<String> ignoreKeys = new HashSet<String>(Collections.singletonList("id"));
            HRDynamicObjectUtils.copy((DynamicObject)oldFlowDef, (DynamicObject)newFlowDef, ignoreKeys);
            long id = defIds[i];
            newFlowDef.set("id", (Object)id);
            newFlowDefs[i] = newFlowDef;
            ++i;
        }
        return newFlowDefs;
    }

    protected DynamicObject[] copyWorkFlows(DynamicObject[] workflows, long[] flowIds, Map<Long, Long> oldNewDefIdMap) {
        int flowEntrySize = Arrays.stream(workflows).mapToInt(p -> p.getDynamicObjectCollection("entryentity").size()).sum();
        long[] flowEntryIds = DBServiceHelper.genLongIds((String)"t_pbs_workflowentry", (int)flowEntrySize);
        DynamicObject[] newWorkflows = new DynamicObject[workflows.length];
        int i = 0;
        for (DynamicObject oldWorkFlow : workflows) {
            DynamicObject newWorkflow = WORK_FLOW_ENTITY_SERVICE.generateEmptyDynamicObject();
            HashSet<String> ignoreKeys = new HashSet<String>(Arrays.asList("id", "boid", "masterid", "entryboid", "sourcevid", "name"));
            HRDynamicObjectUtils.copy((DynamicObject)oldWorkFlow, (DynamicObject)newWorkflow, ignoreKeys);
            newWorkflows[i] = newWorkflow;
            long id = flowIds[i];
            newWorkflow.set("id", (Object)id);
            newWorkflow.set("boid", (Object)id);
            newWorkflow.set("publishstatus", (Object)EPA_EVAWORKFLOW);
            newWorkflow.set("enable", (Object)1);
            newWorkflow.set("sourceflowid", (Object)oldWorkFlow.getLong("id"));
            for (DynamicObject aFlowEntry : newWorkflow.getDynamicObjectCollection("entryentity")) {
                aFlowEntry.set("id", (Object)flowEntryIds[--flowEntrySize]);
                aFlowEntry.set("entryboid", (Object)flowEntryIds[flowEntrySize]);
                aFlowEntry.set("flowdefproc", (Object)oldNewDefIdMap.get(aFlowEntry.getLong("flowdefproc")));
            }
            ++i;
        }
        return newWorkflows;
    }

    protected void updateWorkFlowEntryCache(DynamicObjectCollection flowEntrys, Map<Long, Long> oldNewFlowIdMap) {
        int i = 0;
        long[] newPerfFlowEntryIds = DBServiceHelper.genLongIds((String)"t_epa_perfworklowentry", (int)flowEntrys.size());
        for (DynamicObject entry : flowEntrys) {
            Long newFlowId = oldNewFlowIdMap.get(entry.getLong("flowid"));
            entry.set("flowid", (Object)newFlowId);
            entry.set("flowvid", (Object)newFlowId);
            long newPerfFlowEntryId = newPerfFlowEntryIds[i++];
            entry.set("entryboidflow", (Object)newPerfFlowEntryId);
            entry.set("id", (Object)newPerfFlowEntryId);
        }
        this.getModel().updateEntryCache(flowEntrys);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"vecsetting", "flowedit", "flowview", "nodesettinglab", "save"});
        ((EntryGrid)this.getControl("evalentryentity")).addRowClickListener((RowClickEventListener)this);
        ((EntryGrid)this.getControl("resultconfirmentry")).addRowClickListener((RowClickEventListener)this);
        ((BasedataEdit)this.getControl("sumperflevel")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("scoresystem")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((Tab)this.getView().getControl("activitycontenttabap")).addTabSelectListener((TabSelectListener)this);
        Container cardEntrySelect = (Container)this.getView().getControl(CARD_ENTRY_INFO_LAP);
        cardEntrySelect.addClickListener((ClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String f7Name = beforeF7SelectEvent.getProperty().getName();
        if ("sumperflevel".equals(f7Name)) {
            this.setF7Filter(beforeF7SelectEvent, "hbss_perflevel");
        }
        if ("scoresystem".equals(f7Name)) {
            this.setF7Filter(beforeF7SelectEvent, "hbss_scoresystem");
        }
    }

    private void setF7Filter(BeforeF7SelectEvent beforeF7SelectEvent, String entityId) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.removeIf(filter -> "ctrlstrategy".equals(filter.getProperty()));
        String appId = DataValidateServiceHelper.getBizAppId((String)"epa_activity");
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"epa_activity", (String)"47150e89000000ac");
        QFilter filter2 = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (List)result.getHasPermOrgs(), (boolean)true);
        beforeF7SelectEvent.getCustomQFilters().add(filter2);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String action = (String)customParams.get("his_action");
        if (HRObjectUtils.isEmpty((Object)dynamicObjectCollection) || dynamicObjectCollection.size() == 0) {
            this.initNewEntry();
        }
        if (HRStringUtils.equals((String)action, (String)"open_insert_data_page") || HRStringUtils.equals((String)action, (String)"open_copy_his_data_page")) {
            this.initTabCustome(dynamicObjectCollection);
        }
        this.initCartConfig(dynamicObjectCollection);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        this.getModel().setValue("useOrg", this.getModel().getValue("createorg"));
        this.initCartConfig(dynamicObjects);
        this.initTabCustome(dynamicObjects);
        this.initDynamicPermissionCache();
    }

    protected void initDynamicPermissionCache() {
        Long dynamicPermissionId = (Long)this.getView().getFormShowParameter().getCustomParam("dynamicpermission.id");
        if (dynamicPermissionId != null) {
            DynPermissionConfigService dynPermissionConfigService = new DynPermissionConfigService();
            DynamicPermissionConfigVO dynamicPermissionConfigVO = dynPermissionConfigService.getDynamicPermissions(dynamicPermissionId, null);
            DistributeSessionlessCache commonRegionCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("commonRegion");
            String dynamicPermissionCacheKey = this.getView().getPageId() + "dynamicPermissionConfigVO" + dynamicPermissionId;
            this.getPageCache().put(DYNAMIC_PERMISSION_CACHE_KEY, dynamicPermissionCacheKey);
            dynamicPermissionConfigVO.setAssessForm(null);
            dynamicPermissionConfigVO.setPerfWorkflow(null);
            dynamicPermissionConfigVO.setExcuteScheme(null);
            commonRegionCache.put(dynamicPermissionCacheKey, (Object)JSON.toJSONString((Object)dynamicPermissionConfigVO), 1, TimeUnit.DAYS);
        }
    }

    protected void initTabCustome(DynamicObjectCollection dynamicObjects) {
        for (DynamicObject dyc : dynamicObjects) {
            Long nodeId = dyc.getLong("node.id");
            if (nodeId.equals(NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId())) {
                this.getModel().setValue("targetcustomname", (Object)dyc.getString("customname"));
                this.getModel().setValue("targetsetmode", dyc.get("settingmode"));
                continue;
            }
            if (nodeId.equals(NodeTabMapEnum.PERF_CALIBRATION.getNodeId())) {
                this.getModel().setValue("perfcustomname", (Object)dyc.getString("customname"));
                continue;
            }
            if (nodeId.equals(NodeTabMapEnum.RESULT_CONFIRM.getNodeId())) {
                this.getModel().setValue("resultcustomname", (Object)dyc.getString("customname"));
                continue;
            }
            if (nodeId.equals(NodeTabMapEnum.EVAL_PROCESS.getNodeId())) {
                this.getModel().setValue("evalcustomname", (Object)dyc.getString("customname"));
                this.getModel().setValue("evalsetmode", dyc.get("settingmode"));
                continue;
            }
            if (nodeId.equals(NodeTabMapEnum.PERF_SUM.getNodeId())) {
                this.getModel().setValue("sumcustomname", (Object)dyc.getString("customname"));
                continue;
            }
            if (!nodeId.equals(NodeTabMapEnum.PERF_INTERVIEW.getNodeId())) continue;
            this.getModel().setValue("interviewcustomname", (Object)dyc.getString("customname"));
            this.getModel().setValue("interviewsetmode", dyc.get("settingmode"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus areaStatus = this.getAreaStatus();
        this.getView().setVisible(Boolean.FALSE, new String[]{CHILDREN});
        String pageId = this.getView().getPageId();
        if (!HRStringUtils.equals((String)"true", (String)this.getView().getPageCache().get("isShowAssForm"))) {
            if (OperationStatus.EDIT == areaStatus) {
                ActivityTabsUtils.addEntryEntityItem(this.getView(), pageId, pageId, ResManager.loadKDString((String)"\u4fee\u6539\u6d41\u7a0b\u4fe1\u606f", (String)"ActivityPerfWorkFlowEdit_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            } else if (OperationStatus.VIEW == areaStatus) {
                ActivityTabsUtils.addEntryEntityItem(this.getView(), pageId, pageId, ResManager.loadKDString((String)"\u6d41\u7a0b\u4fe1\u606f", (String)"ActivityPerfWorkFlowEdit_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            }
        }
        this.showTabButton();
        String option = (String)this.getView().getFormShowParameter().getCustomParam("option");
        if (!HRStringUtils.equals((String)option, (String)"showhisversion")) {
            this.getModel().setValue("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
        }
        if (OperationStatus.EDIT == areaStatus) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"addflow", "addtargetflow", "addinterviewflow"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addflow", "addtargetflow", "addinterviewflow"});
        }
        this.getPageCache().putBigObject("originFlowEntry", SerializationUtils.toJsonString((Object)this.getModel().getEntryEntity("flowentry")));
        this.renderNodeTpl();
        this.getModel().setDataChanged(false);
        this.initTips();
        this.setPageCache();
    }

    private void setPageCache() {
        Object ismpsopexchange = this.getModel().getValue("ismpsopexchange");
        Object ismplevelexchange = this.getModel().getValue("ismplevelexchange");
        Object mplevelset = this.getModel().getValue("mplevelset");
        DynamicObject sumperflevel = (DynamicObject)this.getModel().getValue("sumperflevel");
        DynamicObject scoresystem = (DynamicObject)this.getModel().getValue("scoresystem");
        String startValue = String.valueOf(ismpsopexchange) + ismplevelexchange;
        if (Boolean.TRUE.equals(ismplevelexchange)) {
            startValue = startValue + mplevelset;
        }
        if (sumperflevel != null) {
            startValue = startValue + sumperflevel.getPkValue();
        }
        if (scoresystem != null) {
            startValue = startValue + scoresystem.getPkValue();
        }
        this.getView().getPageCache().put("startValue", startValue);
    }

    protected void initTips() {
        Map tipsMap = ShowConfigTipsUtils.getTipsByFormId((String)"epa_perfworkflow");
        tipsMap.forEach((key, value) -> {
            if (0 == value.size()) {
                return;
            }
            HashMap<String, Tips> textProps = new HashMap<String, Tips>(16);
            Tips textTips = new Tips();
            textTips.setType("text");
            textTips.setContent(new LocaleString(value.toArray(new String[0])[0]));
            textProps.put("tips", textTips);
            this.getView().updateControlMetadata(key, textProps);
        });
    }

    protected void renderNodeTpl() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_activity_nodetpl");
        showParameter.setShowTitle(false);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(CUSTOMCONTROLAP);
        showParameter.setStatus(this.getAreaStatus());
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("elementId", CUSTOMCONTROLAP + this.getView().getPageId());
        showParameter.getOpenStyle().setCustParam(customParams);
        showParameter.setHasRight(true);
        HashMap<Long, Boolean> checkBoxMap = new HashMap<Long, Boolean>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryEntity) {
            checkBoxMap.put(entry.getDynamicObject("node").getLong("id"), entry.getBoolean("isshow"));
        }
        showParameter.setCustomParam(EPA_WORKFLOWTYPE, this.getModel().getValue(EPA_WORKFLOWTYPE));
        showParameter.setCustomParam("checkBoxInitMap", checkBoxMap);
        showParameter.setCustomParam("activity.id", this.getView().getFormShowParameter().getCustomParam("activity.id"));
        this.getView().showForm(showParameter);
    }

    private void showTabButton() {
        String option = (String)this.getView().getFormShowParameter().getCustomParam("option");
        if (HRStringUtils.equals((String)option, (String)"showhisversion")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "bar_enable"});
        }
        this.showTabMenu();
        this.addViewShowSubmit();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_modify", "bar_saveandnew", "bar_revise", "bar_reviserecord", "bar_delete"});
        OperationStatus areaStatus = this.getAreaStatus();
        if (OperationStatus.EDIT == areaStatus) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
        }
    }

    private void addViewShowSubmit() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String action = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        String formId = this.getView().getFormShowParameter().getFormId();
        boolean isShow = HRStringUtils.isEmpty((String)action) && (HRStringUtils.equals((String)"A", (String)dynamicObject.getString("status")) || HRStringUtils.equals((String)"B", (String)dynamicObject.getString("status"))) && HRBaseDataConfigUtil.getAudit((String)formId);
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"bar_submit", "bar_unsubmit"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String opKey = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)"save", (String)opKey) || HRStringUtils.equals((String)"submit", (String)opKey) || HRStringUtils.equals((String)"confirmchange", (String)opKey) || HRStringUtils.equals((String)"confirmchangenoaudit", (String)opKey)) {
            boolean mustConfig;
            if (!AssActivityPermissionUtils.checkActivityPerfWorkflowPermission(this.getView())) {
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            boolean anyConfig = entryEntity.stream().anyMatch(e -> e.getBoolean("isshow"));
            if (!anyConfig) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8003\u6838\u6d3b\u52a8\u3002", (String)"ActivityPerfWorkFlowEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String workflowType = (String)this.getModel().getValue(EPA_WORKFLOWTYPE);
            if (!workflowType.equals(EPA_INTERVIEWWORKFLOW) && !(mustConfig = entryEntity.stream().filter(e -> e.getBoolean("isshow")).anyMatch(e -> Arrays.asList(NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId(), NodeTabMapEnum.EVAL_PROCESS.getNodeId(), NodeTabMapEnum.PERF_SUM.getNodeId()).contains(e.getLong("node_id"))))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ee9\u6548\u6d41\u7a0b\u4e2d\u7f3a\u5c11\u5173\u952e\u6d3b\u52a8\uff0c\u8bf7\u81f3\u5c11\u9009\u4e2d\u201c\u6307\u6807\u5236\u5b9a\u201d\u53ca\u201c\u7ee9\u6548\u8bc4\u4f30\u201d\u6216\u9009\u4e2d\u201c\u7ed3\u679c\u6c47\u603b\u201d", (String)"ActivityPerfWorkFlowEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (this.checkFlowEntry()) {
                evt.setCancel(true);
            }
        }
    }

    public boolean showSelectForm() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity.id");
        DynamicObject activityObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        DynamicObject assessForm = activityObj.getDynamicObject("assessform");
        if (ObjectUtils.isEmpty((Object)assessForm) && HRStringUtils.isEmpty((String)this.getView().getPageCache().get("assessFormId"))) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("epa_selectassfrom");
            showParameter.setCaption(CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.getLocaleString((String)"\u8bc4\u4f30\u8868\u5355", (String)"ActivityPerfWorkFlowEdit_0", (String)"opmc-epa-formplugin").getLocaleValue()));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_selectassfrom"));
            this.getView().showForm(showParameter);
            this.getView().getPageCache().put("isShowAssForm", "true");
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            this.getView().updateView();
            return true;
        }
        return false;
    }

    private boolean checkFlowEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String workflowType = (String)this.getModel().getValue(EPA_WORKFLOWTYPE);
        for (DynamicObject aEntry : entryEntity) {
            DynamicObject node;
            if (!aEntry.getBoolean("isshow") || HRObjectUtils.isEmpty((Object)(node = aEntry.getDynamicObject("node")))) continue;
            Long nodeId = node.getLong("id");
            if (workflowType.equals(EPA_INTERVIEWWORKFLOW) && !nodeId.equals(NodeTabMapEnum.PERF_INTERVIEW.getNodeId())) continue;
            if (nodeId.equals(NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId()) || nodeId.equals(NodeTabMapEnum.EVAL_PROCESS.getNodeId()) || nodeId.equals(NodeTabMapEnum.PERF_INTERVIEW.getNodeId())) {
                DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("flowentry");
                Set defaultFlowIds = dynamicObjects.stream().filter(e -> e.getBoolean("isdefaultflow")).filter(e -> !e.getBoolean("isdelete")).map(e -> e.getString("flowid")).collect(Collectors.toSet());
                String flowType = "2";
                if (NodeTabMapEnum.PERF_INTERVIEW.getNodeId().equals(nodeId)) {
                    flowType = "3";
                } else if (NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId().equals(nodeId)) {
                    flowType = "1";
                }
                DynamicObject[] workflows = this.getAllWorkFlows(dynamicObjects);
                String finalFlowType = flowType;
                boolean hasFlow = Arrays.stream(workflows).anyMatch(p -> p.getString("workflowtype").equals(finalFlowType) && EPA_INTERVIEWWORKFLOW.equals(p.getString("publishstatus")) && defaultFlowIds.contains(this.isAudit() ? p.getString("boid") : p.getString("id")));
                if (hasFlow) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u521b\u5efa\u4e00\u6761\u5df2\u53d1\u5e03\u4e14\u8bbe\u4e3a\u9ed8\u8ba4\u7684{0}\u6d41\u7a0b\u3002", (String)"ActivityPerfWorkFlowEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{node.getString("name")}));
                return true;
            }
            if (!nodeId.equals(NodeTabMapEnum.PERF_SUM.getNodeId())) continue;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String fieldKey;
        block32: {
            block35: {
                ComboEdit mplevelset;
                BasedataEdit sumperlevel;
                block36: {
                    BasedataEdit scoreSystem;
                    block34: {
                        block33: {
                            super.propertyChanged(propertyChangedArgs);
                            fieldKey = propertyChangedArgs.getProperty().getName();
                            ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
                            Set checkBoxs = ((Container)this.getControl("flexpanelap_config")).getItems().stream().map(Control::getKey).collect(Collectors.toSet());
                            if (!checkBoxs.contains(fieldKey)) break block33;
                            HashSet<String> tabIds = new HashSet<String>(2);
                            String tabId = this.getPageCache().get(fieldKey);
                            tabIds.add(tabId);
                            if (!HRStringUtils.isEmpty((String)tabId)) {
                                if (NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId().equals(Long.parseLong(tabId))) {
                                    tabIds.add(NodeTabMapEnum.EVAL_PROCESS.getNodeId().toString());
                                } else if (NodeTabMapEnum.EVAL_PROCESS.getNodeId().equals(Long.parseLong(tabId))) {
                                    tabIds.add(NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId().toString());
                                }
                            }
                            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
                            for (DynamicObject entry : dynamicObjects) {
                                DynamicObject node = entry.getDynamicObject("node");
                                if (!tabIds.contains(node.getString("id"))) continue;
                                entry.set("isshow", changeData.getNewValue());
                                if (!(changeData.getNewValue() instanceof Boolean) || !((Boolean)changeData.getNewValue()).booleanValue()) continue;
                                this.setTabDefaultValue(Long.valueOf(tabId));
                            }
                            this.showTabMenu();
                            this.initCartConfig(dynamicObjects);
                            break block32;
                        }
                        if ("scoresystem".equals(fieldKey)) break block32;
                        if (!"ismpsopexchange".equals(fieldKey)) break block34;
                        if (this.checkOnlyAggregation() && this.perfsumSelected()) {
                            scoreSystem = (BasedataEdit)this.getControl("scoresystem");
                            if (HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismpsopexchange"))) || HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                                this.getView().setVisible(Boolean.TRUE, new String[]{"scoresystem"});
                                scoreSystem.setMustInput(Boolean.TRUE.booleanValue());
                                break block32;
                            } else {
                                this.getView().setVisible(Boolean.FALSE, new String[]{"scoresystem"});
                                if (OperationStatus.ADDNEW.equals((Object)this.getPermOpStatus())) {
                                    this.getModel().setValue("scoresystem", null);
                                }
                            }
                        }
                        break block32;
                    }
                    if (!"ismplevelexchange".equals(fieldKey)) break block35;
                    if (!this.checkOnlyAggregation() || !this.perfsumSelected()) break block36;
                    scoreSystem = (BasedataEdit)this.getControl("scoresystem");
                    if (HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismpsopexchange"))) || HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"scoresystem"});
                        scoreSystem.setMustInput(Boolean.TRUE.booleanValue());
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"scoresystem"});
                        if (OperationStatus.ADDNEW.equals((Object)this.getPermOpStatus())) {
                            this.getModel().setValue("scoresystem", null);
                            this.getView().updateView("scoresystem");
                        }
                    }
                    if (HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                        this.getModel().initValue("mplevelset", (Object)GradeRuleSrcEnum.SETTINGSELF.getValue());
                        this.getView().updateView("mplevelset");
                    } else {
                        this.getModel().initValue("mplevelset", null);
                        this.getView().updateView("mplevelset");
                    }
                    if (HRStringUtils.equals((String)GradeRuleSrcEnum.SETTINGSELF.getValue(), (String)String.valueOf(this.getModel().getValue("mplevelset")))) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"sumperflevel"});
                        sumperlevel = (BasedataEdit)this.getControl("sumperflevel");
                        sumperlevel.setMustInput(Boolean.TRUE.booleanValue());
                        DynamicObject scoreSysDym = (DynamicObject)this.getModel().getValue("scoresystem");
                        if (!HRObjectUtils.isEmpty((Object)scoreSysDym)) {
                            // empty if block
                        }
                        break block32;
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"sumperflevel"});
                        if (OperationStatus.ADDNEW.equals((Object)this.getPermOpStatus())) {
                            this.getModel().setValue("sumperflevel", null);
                            this.getView().updateView("sumperflevel");
                        }
                    }
                    break block32;
                }
                if (HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"mplevelset"});
                    mplevelset = (ComboEdit)this.getControl("mplevelset");
                    mplevelset.setMustInput(true);
                    if (HRStringUtils.equals((String)GradeRuleSrcEnum.SETTINGSELF.getValue(), (String)String.valueOf(this.getModel().getValue("mplevelset")))) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"sumperflevel"});
                        sumperlevel = (BasedataEdit)this.getControl("sumperflevel");
                        sumperlevel.setMustInput(Boolean.TRUE.booleanValue());
                        break block32;
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"sumperflevel"});
                    }
                    break block32;
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"mplevelset"});
                    mplevelset = (ComboEdit)this.getControl("mplevelset");
                    mplevelset.setMustInput(false);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"sumperflevel"});
                }
                break block32;
            }
            if (!(!"mplevelset".equals(fieldKey) || this.checkOnlyAggregation() && this.perfsumSelected())) {
                if (HRStringUtils.equals((String)GradeRuleSrcEnum.SETTINGSELF.getValue(), (String)String.valueOf(this.getModel().getValue("mplevelset")))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"sumperflevel"});
                    BasedataEdit sumperlevel = (BasedataEdit)this.getControl("sumperflevel");
                    sumperlevel.setMustInput(Boolean.TRUE.booleanValue());
                } else if (HRStringUtils.equals((String)GradeRuleSrcEnum.KEEPSAME.getValue(), (String)String.valueOf(this.getModel().getValue("mplevelset")))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"sumperflevel"});
                }
            }
        }
        switch (fieldKey) {
            case "epaworkflowtype": {
                this.dealSwitchEpaWorkflowType();
                return;
            }
        }
    }

    protected void dealSwitchEpaWorkflowType() {
        this.initNewEntry();
        String workflowType = (String)this.getModel().getValue(EPA_WORKFLOWTYPE);
        boolean flowTabIsVisble = EPA_EVAWORKFLOW.equals(workflowType);
        if (EPA_EVAWORKFLOW.equals(workflowType) || HRStringUtils.isEmpty((String)workflowType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"perfinterview", NodeToCheckBoxEnum.PERF_INTERVIEW.getCheckBoxKey()});
        } else if (EPA_INTERVIEWWORKFLOW.equals(workflowType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"perfinterview"});
            this.setCusNameMust("interviewcustomname", Boolean.TRUE);
            this.setCusNameMust("interviewsetmode", Boolean.TRUE);
        }
        this.getView().setVisible(Boolean.valueOf(flowTabIsVisble), new String[]{"flexpanelap1", "targetformulate", "evalprocess", "perfsum", "perfcalibration", "resultconfirm"});
    }

    protected boolean isWorkFlowEntriesEdit(String tabId) {
        if (!Arrays.asList(NodeTabMapEnum.EVAL_PROCESS.getNodeId(), NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId()).contains(Long.parseLong(tabId))) {
            return false;
        }
        List<String> workFlowNames = this.isWorkFlowEntriesEdit();
        if (workFlowNames.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u7f16\u8f91\u6d41\u7a0b\u4e2d\uff0c\u8003\u6838\u6d3b\u52a8\u4e0d\u53ef\u66f4\u6539\u3002", (String)"ActivityPerfWorkFlowEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{workFlowNames});
            this.getView().showMessage(msg, (String)workFlowNames.stream().reduce((k, v) -> k + System.lineSeparator() + v).get(), MessageTypes.Default);
            return true;
        }
        return false;
    }

    protected List<String> isWorkFlowEntriesEdit() {
        List existPage = this.getPageCache().getAll().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("workFlowPageId")).collect(Collectors.toList());
        ArrayList<String> workFlowNames = new ArrayList<String>(existPage.size());
        for (Map.Entry aPage : existPage) {
            BaseShowParameter baseShowParameter;
            IFormView view = this.getView().getView((String)aPage.getValue());
            if (null == view || !OperationStatus.EDIT.equals((Object)(baseShowParameter = (BaseShowParameter)view.getFormShowParameter()).getStatus()) && !OperationStatus.ADDNEW.equals((Object)baseShowParameter.getStatus())) continue;
            String value = view.getModel().getValue("name").toString();
            workFlowNames.add(null == value ? " " : value);
        }
        return workFlowNames;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabName = tabSelectEvent.getTabKey();
        if (HRStringUtils.equals((String)NodeTabMapEnum.EVAL_PROCESS.getTabName(), (String)tabName) || HRStringUtils.equals((String)NodeTabMapEnum.TARGET_FORMU_LATE.getTabName(), (String)tabName) || HRStringUtils.equals((String)NodeTabMapEnum.PERF_INTERVIEW.getTabName(), (String)tabName)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap7"});
            this.buildEvalEntryEntity(this.getWorkflowType(tabName));
        } else if (HRStringUtils.equals((String)NodeTabMapEnum.RESULT_CONFIRM.getTabName(), (String)tabName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap7"});
            this.buildResultConfirmEntity();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap7"});
        }
    }

    private OperationStatus getAreaStatus() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String pageStatus = this.getView().getPageCache().get("pageStatus");
        String status = (String)this.getModel().getValue("status");
        if (OperationStatus.VIEW == operationStatus || OperationStatus.VIEW.toString().equalsIgnoreCase(pageStatus) || !"A".equals(status) && !"C".equals(status)) {
            return OperationStatus.VIEW;
        }
        return OperationStatus.EDIT;
    }

    private void initNewEntry() {
        DynamicObject[] dynamicObjects = AssessNodeApplicationService.getInstance().queryActivityNode();
        IFormView view = this.getView();
        view.getModel().deleteEntryData("entryentity");
        DynamicObjectType dynamicObjectType = view.getModel().getEntryEntity("entryentity").getDynamicObjectType();
        DynamicObjectCollection entryColl = view.getModel().getEntryEntity("entryentity");
        String workflowType = (String)this.getModel().getValue(EPA_WORKFLOWTYPE);
        for (DynamicObject entry : dynamicObjects) {
            DynamicObject entryBbj = new DynamicObject(dynamicObjectType);
            if (EPA_INTERVIEWWORKFLOW.equals(workflowType)) {
                if (!PassNodeConstants.INTERVIEW_PERFORMANCE.equals(entry.getLong("id"))) continue;
                entryBbj.set("node", (Object)entry);
                entryBbj.set("isshow", (Object)Boolean.TRUE);
                entryBbj.set("settingmode", (Object)EPA_EVAWORKFLOW);
                entryColl.add((Object)entryBbj);
                break;
            }
            if (!EPA_EVAWORKFLOW.equals(workflowType) && !HRStringUtils.isEmpty((String)workflowType) || PassNodeConstants.INTERVIEW_PERFORMANCE.equals(entry.getLong("id"))) continue;
            entryBbj.set("node", (Object)entry);
            entryBbj.set("isshow", (Object)Boolean.TRUE);
            if (NodeTabMapEnum.EVAL_PROCESS.getNodeNumber().equals(entry.getString("number")) || NodeTabMapEnum.TARGET_FORMU_LATE.getNodeNumber().equals(entry.getString("number"))) {
                entryBbj.set("settingmode", (Object)EPA_EVAWORKFLOW);
            }
            entryColl.add((Object)entryBbj);
        }
        view.getModel().updateEntryCache(entryColl);
        view.updateView("entryentity");
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        String cardIndex = this.getView().getPageCache().get("cardIndex");
        switch (key) {
            case "vecsetting": {
                String pageStatus = this.getView().getPageCache().get("pageStatus");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_assessprocess");
                if (HRStringUtils.equalsIgnoreCase((String)OperationStatus.ADDNEW.toString(), (String)pageStatus)) {
                    showParameter.setStatus(OperationStatus.ADDNEW);
                } else {
                    showParameter.setStatus(OperationStatus.EDIT);
                }
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_assessprocess"));
                this.getView().showForm(showParameter);
                break;
            }
            case "flowview": {
                if (!HRStringUtils.isNotEmpty((String)cardIndex)) break;
                DynamicObjectCollection evalEntityList = this.getModel().getEntryEntity("evalentryentity");
                long flowId = ((DynamicObject)evalEntityList.get(Integer.parseInt(cardIndex))).getLong("id");
                long vid = this.getVidByFlowId(flowId);
                String childrenPageId = this.showFlowItem(vid, OperationStatus.VIEW, EvalProcessOperationEnum.VIEW);
                ActivityTabsUtils.addEntryEntityItem(this.getView(), this.getView().getPageId(), childrenPageId, ((DynamicObject)evalEntityList.get(Integer.parseInt(cardIndex))).getString("flowname"));
                break;
            }
            case "nodesettinglab": {
                String flag = this.getPageCache().get(CUSTOMCONTROLAP);
                this.nodeTplClickEvent(flag);
                break;
            }
            case "cardentryinfolap": {
                this.getView().getPageCache().put("clickCardEntry", "true");
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ITEM_ENTRY_ENTITY);
                int[] rows = entryGrid.getSelectRows();
                if (rows.length > 0) {
                    ActivityTabsUtils.selectEntryEntityItem(this.getView(), this.getView().getPageId(), rows[0], (IFormPlugin)this, false);
                }
                this.getView().getPageCache().put("clickCardEntry", "false");
                break;
            }
        }
    }

    protected String showFlowItem(long flowId, OperationStatus value, EvalProcessOperationEnum operationType) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_assessworkflow");
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.getOpenStyle().setTargetKey(CHILDREN);
        baseShowParameter.setStatus(value);
        baseShowParameter.setCustomParam("assessruleid", this.getModel().getDataEntity().getPkValue());
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_assessworkflow"));
        if (HRStringUtils.isEmpty((String)this.getView().getPageCache().get("workFlowPageId" + flowId))) {
            String keyName = "workFlowPageId" + flowId;
            if (0L == flowId) {
                keyName = "workFlowPageId" + System.currentTimeMillis() + flowId;
            }
            this.getView().getPageCache().put(keyName, baseShowParameter.getPageId());
            baseShowParameter.setCustomParam("workFlowPageIdcacheKey", (Object)keyName);
        }
        if (OperationStatus.ADDNEW != value) {
            baseShowParameter.setPkId((Object)flowId);
            baseShowParameter.setPageId(this.getView().getPageCache().get("workFlowPageId" + flowId));
            baseShowParameter.setCustomParam("workFlowPageIdcacheKey", (Object)("workFlowPageId" + flowId));
        }
        boolean ref = this.isAudit();
        baseShowParameter.setCustomParam("tipRef", (Object)ref);
        long vid = this.getVidByFlowId(flowId);
        baseShowParameter.setCustomParam("vid", (Object)vid);
        String workflowType = this.getWorkflowType("");
        baseShowParameter.setCustomParam("flowType", (Object)workflowType);
        boolean isDefault = false;
        baseShowParameter.setCustomParam("isdefault", (Object)isDefault);
        baseShowParameter.setCustomParam("isFromActivity", (Object)"true");
        baseShowParameter.setCustomParam(DYNAMIC_PERMISSION_CACHE_KEY, (Object)this.getPageCache().get(DYNAMIC_PERMISSION_CACHE_KEY));
        baseShowParameter.setCustomParam("operateType", (Object)operationType.getOpKey());
        baseShowParameter.setHasRight(true);
        baseShowParameter.setShowTitle(true);
        baseShowParameter.setShowClose(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("94vh");
        baseShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm((FormShowParameter)baseShowParameter);
        this.getView().setVisible(Boolean.FALSE, new String[]{CURRENTAP});
        this.getView().setVisible(Boolean.TRUE, new String[]{CHILDREN});
        return baseShowParameter.getPageId();
    }

    protected String showFlowItem(long flowId, long procId, OperationStatus value, EvalProcessOperationEnum operationType) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_assessworkflow");
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.getOpenStyle().setTargetKey(CHILDREN);
        baseShowParameter.setStatus(value);
        baseShowParameter.setCustomParam("assessruleid", this.getModel().getDataEntity().getPkValue());
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_assessworkflow"));
        if (HRStringUtils.isEmpty((String)this.getView().getPageCache().get("workFlowPageId" + flowId))) {
            String keyName = "workFlowPageId" + flowId;
            if (0L == flowId) {
                keyName = "workFlowPageId" + System.currentTimeMillis() + flowId;
            }
            this.getView().getPageCache().put(keyName, baseShowParameter.getPageId());
            baseShowParameter.setCustomParam("workFlowPageIdcacheKey", (Object)keyName);
        }
        if (OperationStatus.ADDNEW != value) {
            baseShowParameter.setPkId((Object)flowId);
            baseShowParameter.setPageId(this.getView().getPageCache().get("workFlowPageId" + flowId));
            baseShowParameter.setCustomParam("workFlowPageIdcacheKey", (Object)("workFlowPageId" + flowId));
        }
        boolean ref = this.isAudit();
        baseShowParameter.setCustomParam("tipRef", (Object)ref);
        long vid = this.getVidByFlowId(flowId);
        baseShowParameter.setCustomParam("vid", (Object)vid);
        String workflowType = this.getWorkflowType("");
        baseShowParameter.setCustomParam("flowType", (Object)workflowType);
        boolean isDefault = false;
        baseShowParameter.setCustomParam("isdefault", (Object)isDefault);
        baseShowParameter.setCustomParam("isFromActivity", (Object)"true");
        baseShowParameter.setCustomParam(DYNAMIC_PERMISSION_CACHE_KEY, (Object)this.getPageCache().get(DYNAMIC_PERMISSION_CACHE_KEY));
        baseShowParameter.setCustomParam("operateType", (Object)operationType.getOpKey());
        baseShowParameter.setCustomParam("newProcId", (Object)procId);
        baseShowParameter.setHasRight(true);
        baseShowParameter.setShowTitle(true);
        baseShowParameter.setShowClose(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("94vh");
        baseShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm((FormShowParameter)baseShowParameter);
        this.getView().setVisible(Boolean.FALSE, new String[]{CURRENTAP});
        this.getView().setVisible(Boolean.TRUE, new String[]{CHILDREN});
        return baseShowParameter.getPageId();
    }

    private boolean checkDefaultFlow(String workflowType) {
        long passnode = this.changeTypeToPassnode(workflowType);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("flowentry");
        List defaultFlow = dynamicObjects.stream().filter(dy -> dy.getLong("passnode") == passnode).filter(dy -> dy.getBoolean("isdefaultflow")).filter(dy -> !dy.getBoolean("isdelete")).collect(Collectors.toList());
        return defaultFlow.isEmpty();
    }

    private long changeTypeToPassnode(String workflowType) {
        long passnode = 0L;
        switch (workflowType) {
            case "1": {
                passnode = PassNodeConstants.SET_INDICATOR;
                break;
            }
            case "2": {
                passnode = PassNodeConstants.EVALUATE_PERF;
                break;
            }
            case "3": {
                passnode = PassNodeConstants.INTERVIEW_PERFORMANCE;
                break;
            }
        }
        return passnode;
    }

    protected void showHisFlowItem(long flowId) {
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("epa_hischangestyle");
        baseShowParameter.setStatus(OperationStatus.EDIT);
        baseShowParameter.setCustomParam("boid", (Object)flowId);
        baseShowParameter.setCustomParam("entityId", (Object)"pbs_workflow");
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_hischangestyle"));
        baseShowParameter.setCustomParam("flowType", (Object)this.getWorkflowType(""));
        long vid = this.getVidByFlowId(flowId);
        baseShowParameter.setCustomParam("vid", (Object)vid);
        baseShowParameter.setCustomParam("assessruleid", this.getModel().getDataEntity().getPkValue());
        baseShowParameter.setHasRight(true);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm(baseShowParameter);
    }

    private long getVidByFlowId(long flowId) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("flowentry");
        long vid = dynamicObjects.stream().filter(dy -> dy.getLong("flowid") == flowId).map(dy -> dy.getLong("flowvid")).findFirst().orElse(0L);
        vid = vid == 0L ? flowId : vid;
        return vid;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "epa_assessprocess": {
                this.initCartConfig(this.getModel().getEntryEntity("entryentity"));
                this.showTabMenu();
                break;
            }
            case "epa_publishconfirm": {
                if (HRObjectUtils.isEmpty((Object)returnData)) break;
                this.flowPublish(returnData);
                break;
            }
            case "epa_hischangestyle": {
                if (null == returnData) break;
                Long flowBoId = (Long)returnData.get("flowid");
                Long flowId = (Long)returnData.get("tempVersionId");
                String changeStyle = (String)returnData.get("radiogroupfield");
                DynamicObject currentVersion = null;
                if (HRStringUtils.equals((String)"1", (String)changeStyle)) {
                    currentVersion = WORK_FLOW_APPLICATION_SERVICE.getCurrentWorkflow(flowId.longValue());
                    this.getView().getPageCache().put("radiogroupfield" + flowBoId, "1");
                } else {
                    currentVersion = WORK_FLOW_APPLICATION_SERVICE.getCurrentTempWorkflow(flowId.longValue());
                    this.getView().getPageCache().remove("radiogroupfield" + flowBoId);
                }
                String childrenPageId = this.showFlowItem(flowId, OperationStatus.EDIT, EvalProcessOperationEnum.EDIT);
                String flowname = ResManager.loadKDString((String)"\u7f16\u8f91\u6d41\u7a0b\u4fe1\u606f", (String)"ActivityPerfWorkFlowEdit_7", (String)"opmc-pbs-formplugin", (Object[])new Object[0]);
                if (currentVersion != null) {
                    flowname = currentVersion.getString("name");
                }
                ActivityTabsUtils.addEntryEntityItem(this.getView(), this.getView().getPageId(), childrenPageId, flowname);
                break;
            }
            case "epa_act_permissionsetting": {
                String clickCardEntry = this.getView().getPageCache().get("clickCardEntry");
                ActivityTabsUtils.closeActivityPermissPage(this.getView(), this.getView().getPageId(), 0, clickCardEntry);
                this.getView().getPageCache().put("clickCardEntry", "false");
                break;
            }
            case "epa_selectassfrom": {
                this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
                this.getView().updateView();
                this.getView().getPageCache().put("isShowAssForm", "false");
                if (ObjectUtils.isEmpty((Object)returnData)) {
                    return;
                }
                Long assessFormId = (Long)returnData.get("assessFormId");
                Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity.id");
                DynamicObject copyAssessForm = ASSESS_ACTIVITY_DOMAIN_SERVICE.copyAssessForm(assessFormId, activityId);
                this.getView().getPageCache().put("assessFormId", String.valueOf(copyAssessForm.getLong("id")));
                break;
            }
        }
    }

    private void flowPublish(HashMap hashMap) {
        long flowId = Long.parseLong(String.valueOf(hashMap.get("flowid")));
        DynamicObject currentTempWorkflow = WORK_FLOW_APPLICATION_SERVICE.getChangeLastWorkflow(flowId);
        if (null != currentTempWorkflow) {
            this.copyTemp(currentTempWorkflow);
        }
        String flowDescription = String.valueOf(hashMap.get("flowdescription"));
        boolean tipRef = this.isAudit();
        DynamicObject workflow = WORK_FLOW_APPLICATION_SERVICE.getLastWorkflow(flowId);
        String changeStyle = this.getView().getPageCache().get("radiogroupfield" + flowId);
        if (HRStringUtils.equals((String)"1", (String)changeStyle)) {
            workflow.set("datastatus", (Object)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus());
            WORK_FLOW_APPLICATION_SERVICE.save(workflow);
        }
        workflow.set("modifytime", (Object)new Date());
        workflow.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        workflow.set("publishstatus", (Object)EPA_INTERVIEWWORKFLOW);
        workflow.set("changedescription", (Object)flowDescription);
        workflow.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
        HisResponse response = WORK_FLOW_APPLICATION_SERVICE.hisVersionChange(new DynamicObject[]{workflow}, "pbs_workflow", false);
        if (String.valueOf(200).equals(response.getCode())) {
            if (tipRef) {
                this.getView().getPageCache().put("saveOrPublishFlag" + flowId, "1");
            }
            this.saveFlowEntry(flowId, null, null, Boolean.TRUE);
            DynamicObject workflowDyn = WORK_FLOW_APPLICATION_SERVICE.getWorkflowById(flowId);
            long flowdefproc = ((DynamicObject)workflowDyn.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            DynamicPermssionConfigCacheUtils.dynamicPermssionConfigCacheHandle(flowId, flowdefproc, this.getView());
            String msg = ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f", (String)"ActivityPerfWorkFlowEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
            this.buildEvalEntryEntity(workflow.getString("workflowtype"));
        } else {
            String msg = ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25", (String)"ActivityPerfWorkFlowEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
    }

    private void copyTemp(DynamicObject currentTempWorkflow) {
        long flowId = currentTempWorkflow.getLong("id");
        String backupFlag = this.getView().getPageCache().get("copyTempFlowId" + flowId);
        if (HRStringUtils.isEmpty((String)backupFlag)) {
            ArrayList<Long> flowIds = new ArrayList<Long>();
            flowIds.add(flowId);
            DynamicObject copyTempWorkflow = WORK_FLOW_APPLICATION_SERVICE.generateEmptyDynamicObject();
            DynamicObject[] copyTempflows = WORK_FLOW_APPLICATION_SERVICE.getCopyTempWorkflow(flowIds);
            if (copyTempflows.length > 0) {
                copyTempWorkflow = copyTempflows[0];
            }
            HRDynamicObjectUtils.copy((DynamicObject)currentTempWorkflow, (DynamicObject)copyTempWorkflow, (boolean)true);
            copyTempWorkflow.set("hisversion", (Object)"COPYTEMP");
            copyTempWorkflow.set("iscurrentversion", (Object)0);
            long currUserId = RequestContext.get().getCurrUserId();
            copyTempWorkflow.set("boid", (Object)currUserId);
            copyTempWorkflow.set("sourcevid", (Object)currentTempWorkflow.getLong("boid"));
            long[] workflowIds = DBServiceHelper.genLongIds((String)"t_pbs_workflow", (int)1);
            long[] flowEntryIds = DBServiceHelper.genLongIds((String)"t_pbs_workflowentry", (int)1);
            copyTempWorkflow.set("id", (Object)workflowIds[0]);
            for (DynamicObject aFlowEntry : copyTempWorkflow.getDynamicObjectCollection("entryentity")) {
                aFlowEntry.set("id", (Object)flowEntryIds[0]);
                aFlowEntry.set("entryboid", (Object)flowEntryIds[0]);
                aFlowEntry.set("flowdefproc", (Object)aFlowEntry.getLong("flowdefproc"));
            }
            WORK_FLOW_APPLICATION_SERVICE.save(copyTempWorkflow);
            long copyFlowId = copyTempWorkflow.getLong("id");
            this.getView().getPageCache().put("copyTempFlowId" + flowId, String.valueOf(copyFlowId));
        }
    }

    private void showTabMenu() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        if (!HRObjectUtils.isEmpty((Object)dynamicObjectCollection) && dynamicObjectCollection.size() > 0) {
            this.initCartEntry(dynamicObjectCollection);
            List checkBoxs = ((Container)this.getControl("flexpanelap_config")).getItems();
            long count = checkBoxs.stream().filter(e -> (Boolean)this.getModel().getValue(e.getKey())).count();
            if (count == 0L) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap7", "activitycontenttabap"});
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"activitycontenttabap"});
            Tab tab = (Tab)this.getControl("activitycontenttabap");
            String tabName = tab.getCurrentTab();
            tab.activeTab(tabName);
            if (2L == count && (HRStringUtils.equals((String)NodeTabMapEnum.EVAL_PROCESS.getTabName(), (String)tabName) || HRStringUtils.equals((String)NodeTabMapEnum.TARGET_FORMU_LATE.getTabName(), (String)tabName))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap7"});
            }
            this.fieldLinkage();
        }
    }

    private void initCartEntry(DynamicObjectCollection collection) {
        for (DynamicObject entry : collection) {
            DynamicObject node = entry.getDynamicObject("node");
            if (HRObjectUtils.isEmpty((Object)node)) continue;
            Long tabId = node.getLong("id");
            this.setTabCusNameMust(tabId, entry.getBoolean("isshow"));
        }
    }

    protected void initCartConfig(DynamicObjectCollection collection) {
        boolean index = false;
        String workflowType = (String)this.getModel().getValue(EPA_WORKFLOWTYPE);
        List checkBoxs = ((Container)this.getControl("flexpanelap_config")).getItems();
        if (EPA_INTERVIEWWORKFLOW.equals(workflowType)) {
            if (null != collection && collection.size() > 0) {
                DynamicObject interviewDy = collection.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("node").getLong("id") == NodeToCheckBoxEnum.PERF_INTERVIEW.getNodeId().longValue()).findFirst().orElse(null);
                this.getPageCache().put(NodeToCheckBoxEnum.PERF_INTERVIEW.getCheckBoxKey(), NodeToCheckBoxEnum.PERF_INTERVIEW.getNodeId().toString());
                FieldEdit checkbox = (FieldEdit)this.getControl(NodeToCheckBoxEnum.PERF_INTERVIEW.getCheckBoxKey());
                checkbox.setCaption(new LocaleString(interviewDy.getDynamicObject("node").getString("name")));
            }
            this.getModel().setValue(NodeToCheckBoxEnum.PERF_INTERVIEW.getCheckBoxKey(), (Object)Boolean.TRUE);
        } else {
            for (DynamicObject entry : collection) {
                String checkBoxKeyByNodeId;
                DynamicObject node = entry.getDynamicObject("node");
                if (HRObjectUtils.isEmpty((Object)node) || !HRStringUtils.isNotEmpty((String)(checkBoxKeyByNodeId = NodeCheckBoxMapUtils.getCheckBoxKeyByNodeId(node.getLong("id"))))) continue;
                FieldEdit checkbox = (FieldEdit)this.getControl(checkBoxKeyByNodeId);
                this.getPageCache().put(checkbox.getKey(), node.getString("id"));
                checkbox.setCaption(new LocaleString(node.getString("name")));
                if (NodeToCheckBoxEnum.PERF_INTERVIEW.getCheckBoxKey().equals(checkbox.getKey())) {
                    this.getModel().setValue(checkbox.getKey(), (Object)Boolean.FALSE);
                    continue;
                }
                this.getModel().setValue(checkbox.getKey(), (Object)entry.getBoolean("isshow"));
            }
            this.getModel().setValue(NodeToCheckBoxEnum.PERF_INTERVIEW.getCheckBoxKey(), (Object)Boolean.FALSE);
        }
        this.getView().updateView("flexpanelap_config");
    }

    private void setTabDefaultValue(Long tabId) {
        if (tabId.equals(NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId())) {
            this.setTargetFormulateDefault();
        } else if (tabId.equals(NodeTabMapEnum.PERF_CALIBRATION.getNodeId())) {
            this.setPerfCalibrationDefault();
        } else if (tabId.equals(NodeTabMapEnum.RESULT_CONFIRM.getNodeId())) {
            this.setResultConfirmDefault();
        } else if (tabId.equals(NodeTabMapEnum.EVAL_PROCESS.getNodeId())) {
            this.setEvalProcessDefault();
        } else if (tabId.equals(NodeTabMapEnum.PERF_SUM.getNodeId())) {
            this.setPerfSumDefault();
        } else if (tabId.equals(NodeTabMapEnum.PERF_INTERVIEW.getNodeId())) {
            this.setPerfSumDefault();
        }
    }

    private void setTabCusNameMust(Long tabId, Boolean flag) {
        if (tabId.equals(NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId())) {
            this.setCusNameMust("targetcustomname", flag);
            this.setCusNameMust("targetsetmode", flag);
            this.getView().setVisible(flag, new String[]{NodeTabMapEnum.TARGET_FORMU_LATE.getTabName()});
        } else if (tabId.equals(NodeTabMapEnum.PERF_CALIBRATION.getNodeId())) {
            this.setCusNameMust("perfcustomname", flag);
            this.getView().setVisible(flag, new String[]{NodeTabMapEnum.PERF_CALIBRATION.getTabName()});
        } else if (tabId.equals(NodeTabMapEnum.RESULT_CONFIRM.getNodeId())) {
            this.setCusNameMust("resultcustomname", flag);
            this.getView().setVisible(flag, new String[]{NodeTabMapEnum.RESULT_CONFIRM.getTabName()});
        } else if (tabId.equals(NodeTabMapEnum.EVAL_PROCESS.getNodeId())) {
            this.setCusNameMust("evalcustomname", flag);
            this.setCusNameMust("evalsetmode", flag);
            this.getView().setVisible(flag, new String[]{NodeTabMapEnum.EVAL_PROCESS.getTabName()});
        } else if (tabId.equals(NodeTabMapEnum.PERF_SUM.getNodeId())) {
            this.setCusNameMust("sumcustomname", flag);
            this.getView().setVisible(flag, new String[]{NodeTabMapEnum.PERF_SUM.getTabName()});
        } else if (tabId.equals(NodeTabMapEnum.PERF_INTERVIEW.getNodeId())) {
            this.setCusNameMust("interviewcustomname", flag);
            this.setCusNameMust("interviewsetmode", flag);
            this.getView().setVisible(flag, new String[]{NodeTabMapEnum.PERF_INTERVIEW.getTabName()});
        }
    }

    private void setCusNameMust(String key, Boolean flag) {
        FieldEdit cusName = (FieldEdit)this.getControl(key);
        cusName.setMustInput(flag.booleanValue());
        this.getView().updateView(key);
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry entry = (CardEntry)evt.getSource();
        switch (entry.getEntryKey()) {
            case "evalentryentity": {
                this.clickEvalEntryEntity(evt);
                break;
            }
            case "resultconfirmentry": {
                this.clickResultConfirmEntity(evt);
                break;
            }
        }
    }

    private void clickResultConfirmEntity(RowClickEvent evt) {
        int row = evt.getRow();
        this.getView().getPageCache().remove("cardprocindex");
        this.getView().getPageCache().put("cardprocindex", String.valueOf(row));
    }

    private void clickEvalEntryEntity(RowClickEvent evt) {
        int row = evt.getRow();
        this.getView().getPageCache().remove("cardIndex");
        this.getView().getPageCache().put("cardIndex", String.valueOf(row));
    }

    private void buildResultConfirmEntity() {
        List<Map<String, Object>> epaPerfProcDefResult = this.getEnabledProcDefByEntityNumber();
        LinkedList<HashMap<String, Object>> perfResultWf = new LinkedList<HashMap<String, Object>>();
        for (Map<String, Object> proc : epaPerfProcDefResult) {
            String number = (String)proc.get("key");
            Long modelId = (Long)proc.get("modelid");
            JSONObject nameObj = (JSONObject)proc.get("name");
            String procName = nameObj.getString(Lang.get().toString());
            HashMap<String, Object> procInfo = new HashMap<String, Object>();
            procInfo.put("entryboidmodelid", modelId);
            procInfo.put("rcflowname", procName);
            this.getProcessElements(procInfo, number);
            perfResultWf.add(procInfo);
        }
        this.getModel().deleteEntryData("resultconfirmentry");
        if (!perfResultWf.isEmpty()) {
            this.getView().getPageCache().put("existResultConfirmFlow", "1");
            this.getModel().batchCreateNewEntryRow("resultconfirmentry", perfResultWf.size());
            for (int i = 0; i < perfResultWf.size(); ++i) {
                Map procInfo = (Map)perfResultWf.get(i);
                this.getModel().setValue("entryboidmodelid", procInfo.get("entryboidmodelid"), i);
                this.getModel().setValue("rcflowname", procInfo.get("rcflowname"), i);
                this.getModel().setValue("rcprocessinfo", procInfo.get("rcprocessinfo"), i);
                this.getModel().setValue("rcnodes", procInfo.get("rcnodes"), i);
            }
        }
    }

    private List<Map<String, Object>> getEnabledProcDefByEntityNumber() {
        return WorkflowServiceHelper.getEnabledProcDefByEntityNumber((String)"epa_actevalobj_confirm");
    }

    private void getProcessElements(Map<String, Object> procInfo, String number) {
        List elements = WorkflowServiceHelper.getProcessElements((String)number, null);
        LinkedList<String> nodes = new LinkedList<String>();
        StringBuilder buffer = new StringBuilder();
        for (WFFlowElement wfFlowElement : elements) {
            WFFlowNode wfFlowNode;
            String nodeType;
            if (!(wfFlowElement instanceof WFFlowNode) || !HRStringUtils.equals((String)"StartSignalEvent", (String)(nodeType = (wfFlowNode = (WFFlowNode)wfFlowElement).getType()))) continue;
            List nextNodes = wfFlowNode.getNextNodes();
            this.deepGetNodes(nodes, buffer, nextNodes);
            break;
        }
        String nodeLinkStr = buffer.toString();
        nodeLinkStr = nodeLinkStr.replaceFirst("\u2192", "");
        procInfo.put("rcprocessinfo", nodeLinkStr);
        procInfo.put("rcnodes", nodes.size());
    }

    private void deepGetNodes(List<String> nodes, StringBuilder buffer, List<WFFlowNode> nextNodes) {
        int size = nextNodes.size();
        if (size == 1) {
            WFFlowNode node = nextNodes.get(0);
            String nodeType = node.getType();
            if (!HRStringUtils.equals((String)"EndNoneEvent", (String)nodeType)) {
                String nextNodeName = node.getName().getLocaleValue();
                nodes.add(nextNodeName);
                buffer.append("\u2192").append(nextNodeName);
                this.deepGetNodes(nodes, buffer, node.getNextNodes());
            }
        } else if (size > 1) {
            WFFlowNode commonNode = this.checkCommonNode(nextNodes);
            String commonNodeNumber = null != commonNode ? commonNode.getNumber() : "";
            for (int i = 0; i < nextNodes.size(); ++i) {
                WFFlowNode node = nextNodes.get(i);
                String nextNodeName = node.getName().getLocaleValue();
                nodes.add(nextNodeName);
                if (i == 0) {
                    buffer.append("\u2192");
                } else {
                    buffer.append("/");
                }
                buffer.append(nextNodeName);
                this.deepLinkNodes(nodes, buffer, node.getNextNodes(), commonNodeNumber);
            }
            if (null != commonNode && !HRStringUtils.equals((String)"EndNoneEvent", (String)commonNode.getType())) {
                String nodeName = commonNode.getName().getLocaleValue();
                nodes.add(nodeName);
                buffer.append("\u2192").append(nodeName);
                this.deepGetNodes(nodes, buffer, commonNode.getNextNodes());
            }
        }
    }

    private WFFlowNode checkCommonNode(List<WFFlowNode> nodes) {
        WFFlowNode commonNode = null;
        int inComings = nodes.size();
        WFFlowNode node = nodes.get(0);
        Map incomingsMap = node.getIncomings();
        commonNode = incomingsMap.size() == inComings ? node : this.deepCheckLink(inComings, node.getNextNodes());
        return commonNode;
    }

    private WFFlowNode deepCheckLink(int inComings, List<WFFlowNode> nodes) {
        if (nodes.size() == 1) {
            WFFlowNode node = nodes.get(0);
            Map incomingsMap = node.getIncomings();
            if (incomingsMap.size() == inComings) {
                return node;
            }
            this.deepCheckLink(inComings, node.getNextNodes());
        }
        return null;
    }

    private void deepLinkNodes(List<String> nodes, StringBuilder buffer, List<WFFlowNode> nextNodes, String commonNodeNumber) {
        if (!nextNodes.isEmpty()) {
            WFFlowNode node = nextNodes.get(0);
            String nextNodeNumber = node.getNumber();
            if (HRStringUtils.equals((String)commonNodeNumber, (String)nextNodeNumber) || HRStringUtils.equals((String)"EndNoneEvent", (String)node.getType())) {
                return;
            }
            String nextNodeName = node.getName().getLocaleValue();
            nodes.add(nextNodeName);
            buffer.append("\u2192").append(nextNodeName);
            this.deepLinkNodes(nodes, buffer, node.getNextNodes(), commonNodeNumber);
        }
    }

    public void buildEvalEntryEntity(String flowType) {
        PerfworkflowBO bo;
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("flowentry");
        if (dynamicObjects.isEmpty()) {
            this.getModel().deleteEntryData("evalentryentity");
            return;
        }
        DynamicObject[] workflows = this.getAllWorkFlows(dynamicObjects);
        this.getModel().deleteEntryData("evalentryentity");
        List workflowList = Arrays.asList(workflows).stream().filter(p -> p.getString("workflowtype").equals(flowType)).collect(Collectors.toList());
        if (workflowList.isEmpty()) {
            return;
        }
        ArrayList<PerfworkflowBO> bos = new ArrayList<PerfworkflowBO>(workflowList.size());
        for (DynamicObject workflow : workflowList) {
            OperationStatus areaStatus;
            if (HRStringUtils.isEmpty((String)workflow.getString("name"))) continue;
            bo = new PerfworkflowBO();
            String id = this.isAudit() ? workflow.getString("boid") : workflow.getString("id");
            bo.setId(id);
            bo.setFlowName(workflow.getString("name"));
            bo.setProcessInfo(workflow.getString("processinfo"));
            bo.setNodes(workflow.getString("nodenum"));
            bo.setMatrix(workflow.getBoolean("ismatrix"));
            bo.setPublish(EPA_INTERVIEWWORKFLOW.equals(workflow.getString("publishstatus")));
            DynamicObject object = dynamicObjects.stream().filter(obj -> StringUtils.equals((CharSequence)obj.get("flowid").toString(), (CharSequence)id)).findFirst().orElse(null);
            if (object != null) {
                bo.setDefault(object.getBoolean("isdefaultflow"));
                bo.setAvailable(object.getBoolean("isenable"));
                if (object.getBoolean("isdelete")) continue;
            }
            if (OperationStatus.EDIT == (areaStatus = this.getAreaStatus())) {
                bo.setEdit(true);
            } else {
                bo.setEdit(false);
            }
            bos.add(bo);
        }
        bos.sort(Comparator.comparing(PerfworkflowBO::isDefault).thenComparing(PerfworkflowBO::isAvailable).thenComparing(PerfworkflowBO::isPublish).reversed());
        if (bos.size() > 0) {
            this.getModel().batchCreateNewEntryRow("evalentryentity", bos.size());
        }
        HashMap<Integer, List<Map<String, String>>> moreOpApData = new HashMap<Integer, List<Map<String, String>>>(16);
        for (int i = 0; i < bos.size(); ++i) {
            bo = (PerfworkflowBO)bos.get(i);
            ((DynamicObject)this.getModel().getEntryEntity("evalentryentity").get(i)).set("id", (Object)bo.getId());
            this.getModel().setValue("flowname", (Object)bo.getFlowName(), i);
            this.getModel().setValue("processinfo", (Object)bo.getProcessInfo(), i);
            this.getModel().setValue("nodes", (Object)bo.getNodes(), i);
            this.getModel().setValue("ismatrix", (Object)bo.isMatrix(), i);
            this.getModel().setValue("ispublish", (Object)bo.isPublish(), i);
            this.getModel().setValue("isdefault", (Object)bo.isDefault(), i);
            this.getModel().setValue("isavailable", (Object)bo.isAvailable(), i);
            this.getModel().setValue("isedit", (Object)bo.isEdit(), i);
            if (this.isFlowHaveInHandCompleteProc(Long.parseLong(bo.getId()))) {
                bo.setUsed(true);
                this.getModel().setValue("isused", (Object)Boolean.TRUE, i);
            }
            moreOpApData.put(i, this.setMoreOpApData(bo));
        }
        CustomControl objOpAp = (CustomControl)this.getView().getControl("moreopap");
        objOpAp.setData(moreOpApData);
    }

    protected DynamicObject[] getAllWorkFlows(DynamicObjectCollection dynamicObjects) {
        List flowIds = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("flowid")).collect(Collectors.toList());
        List flowVids = dynamicObjects.stream().map(dynamicObject -> {
            long vid = dynamicObject.getLong("flowvid");
            long flowId = dynamicObject.getLong("flowid");
            vid = vid == 0L || this.isSaveOrPublish(flowId) || this.hasTempFlow(flowId) ? flowId : vid;
            return vid;
        }).collect(Collectors.toList());
        return this.isHisActionPage() ? WORK_FLOW_APPLICATION_SERVICE.getWorkflows(flowIds) : WORK_FLOW_APPLICATION_SERVICE.getWorkflowsByVid(flowVids);
    }

    protected boolean isSaveOrPublish(long flowId) {
        String flag = this.getView().getPageCache().get("saveOrPublishFlag" + flowId);
        return HRStringUtils.equals((String)"1", (String)flag);
    }

    private boolean isCopyFlow(long flowId) {
        String copyFlowId = this.getView().getPageCache().get("copyTempFlowId" + flowId);
        return HRStringUtils.isNotEmpty((String)copyFlowId);
    }

    protected boolean isHisVersionTemp(long flowId) {
        OperationStatus areaStatus = this.getAreaStatus();
        boolean isPublihFlow = false;
        if (OperationStatus.EDIT == areaStatus) {
            String isBackup = this.getView().getPageCache().get("hadPublishFlowId" + flowId);
            if (HRStringUtils.isEmpty((String)isBackup)) {
                DynamicObject tempWorkflow = WORK_FLOW_APPLICATION_SERVICE.getSaveOrEffWorkflows(flowId);
                if (!HRObjectUtils.isEmpty((Object)tempWorkflow)) {
                    isPublihFlow = true;
                    this.getView().getPageCache().put("hadPublishFlowId" + flowId, "1");
                }
            } else {
                isPublihFlow = true;
            }
        }
        return isPublihFlow;
    }

    private boolean hasTempFlow(long flowId) {
        OperationStatus areaStatus = this.getAreaStatus();
        boolean hasTempFlow = false;
        if (OperationStatus.EDIT == areaStatus) {
            String isBackup = this.getView().getPageCache().get("hadTempFlowData" + flowId);
            if (HRStringUtils.isEmpty((String)isBackup)) {
                DynamicObject tempWorkflow = WORK_FLOW_APPLICATION_SERVICE.getCurrentTempWorkflow(flowId);
                if (!HRObjectUtils.isEmpty((Object)tempWorkflow)) {
                    hasTempFlow = true;
                    this.getView().getPageCache().put("hadTempFlowData" + flowId, "1");
                }
            } else {
                hasTempFlow = true;
            }
        }
        return hasTempFlow;
    }

    protected boolean isAudit() {
        String ruleStatus = this.getModel().getDataEntity().getString("status");
        String auditStatus = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        return "C".equals(ruleStatus) || "open_data_page".equals(auditStatus) || "open_insert_data_page".equals(auditStatus) || "modify_data_page".equals(auditStatus) || "open_revise_page".equals(auditStatus);
    }

    private boolean isHisActionPage() {
        String datastatus = this.getModel().getDataEntity().getString("datastatus");
        String auditStatus = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        return HRStringUtils.equals((String)"-3", (String)datastatus) && ("open_data_page".equals(auditStatus) || "open_insert_data_page".equals(auditStatus) || "modify_data_page".equals(auditStatus));
    }

    private List<Map<String, String>> setMoreOpApData(PerfworkflowBO bo) {
        ArrayList<EvalProcessOperationEnum> operationList = EvalProcessOperationEnum.getListByBo((PerfworkflowBO)bo);
        OperationStatus areaStatus = this.getAreaStatus();
        if (areaStatus == OperationStatus.VIEW) {
            operationList = new ArrayList<EvalProcessOperationEnum>(10);
            operationList.add(EvalProcessOperationEnum.VIEW);
            if (bo.isPublish() && bo.isAvailable()) {
                operationList.add(EvalProcessOperationEnum.PERM_CONFIG);
            }
        }
        ArrayList<Map<String, String>> opData = new ArrayList<Map<String, String>>(16);
        for (EvalProcessOperationEnum okrOperationEnum : operationList) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("key", okrOperationEnum.getOpName());
            map.put("value", okrOperationEnum.getOpKey());
            opData.add(map);
        }
        return opData;
    }

    protected void nodeTplClickEvent(String flag) {
        if (HRStringUtils.equals((String)flag, (String)"true")) {
            this.closeNodeTpl();
        } else {
            this.openNodeTpl();
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (OperationStatus.EDIT == this.getAreaStatus() && !AssActivityPermissionUtils.checkActivityPerfWorkflowPermission(this.getView())) {
            return;
        }
        if (HRStringUtils.equals((String)e.getKey(), (String)CUSTOMCONTROLAP)) {
            this.getPageCache().put(CUSTOMCONTROLAP, e.getEventArgs());
            this.nodeTplClickEvent(e.getEventArgs());
        } else if (HRStringUtils.equals((String)e.getKey(), (String)"moreopap")) {
            JSONObject jsonObject = JSON.parseObject((String)e.getEventArgs());
            String eventArgs = jsonObject.getString("eventArgs");
            int index = jsonObject.getIntValue("rk");
            this.getView().getPageCache().put("cardIndex", String.valueOf(index));
            EvalProcessOperationEnum operation = EvalProcessOperationEnum.getOperation((String)eventArgs);
            long flowId = ((DynamicObject)((FormView)e.getSource()).getModel().getEntryEntity("evalentryentity").get(index)).getLong("id");
            DynamicObject workflow = WORK_FLOW_APPLICATION_SERVICE.getWorkflow(flowId);
            switch (operation) {
                case EDIT: {
                    this.editFlow(workflow);
                    break;
                }
                case VIEW: {
                    this.viewFlow();
                    break;
                }
                case PUBLISH: {
                    this.publishFlow();
                    break;
                }
                case START: {
                    this.startFlow(workflow);
                    break;
                }
                case BAN: {
                    this.banFlow(workflow);
                    break;
                }
                case DEFAULT: {
                    this.setFlowDefault(workflow);
                    break;
                }
                case COPY: {
                    this.copyFlow(workflow);
                    break;
                }
                case PERM_CONFIG: {
                    this.permConfigFlow(workflow);
                    break;
                }
                case DELETE: {
                    this.deleteFlow(workflow);
                    break;
                }
            }
        }
    }

    private void openNodeTpl() {
        this.getPageCache().put(CUSTOMCONTROLAP, "true");
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOMCONTROLAP);
        map.put("show", "true");
        map.put("date", new Date());
        customcontrol.setData(map);
    }

    private void closeNodeTpl() {
        this.getPageCache().put(CUSTOMCONTROLAP, "false");
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOMCONTROLAP);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("show", "false");
        map.put("date", new Date());
        customcontrol.setData(map);
    }

    private void saveFlowEntry(long flowId, Boolean isDefault, Boolean enable, Boolean isChange) {
        Optional<DynamicObject> first;
        String publishStatus;
        DynamicObjectCollection flowentry = this.getView().getModel().getEntryEntity("flowentry");
        String workflowType = this.getWorkflowType("");
        DynamicObject workflow = WORK_FLOW_APPLICATION_SERVICE.getWorkflow(flowId);
        if (isDefault == null && this.checkDefaultFlow(workflowType) && HRStringUtils.equals((String)(publishStatus = workflow.getString("publishstatus")), (String)EPA_INTERVIEWWORKFLOW)) {
            isDefault = Boolean.TRUE;
        }
        if ((first = flowentry.stream().filter(e -> e.getLong("flowid") == flowId).findFirst()).isPresent()) {
            DynamicObject entry = first.get();
            if (isChange != null && isChange.booleanValue()) {
                entry.set("flowvid", (Object)workflow.getLong("sourcevid"));
            }
            if (null != enable) {
                entry.set("isenable", (Object)enable);
            }
            if (null != isDefault && isDefault.booleanValue()) {
                for (DynamicObject aEntry : flowentry) {
                    if (entry.getLong("passnode") != aEntry.getLong("passnode") || !aEntry.getBoolean("isdefaultflow")) continue;
                    aEntry.set("isdefaultflow", (Object)Boolean.FALSE);
                }
            }
            if (null != isDefault) {
                entry.set("isdefaultflow", (Object)isDefault);
            }
            if (null != isChange) {
                entry.set("ischange", (Object)isChange);
            }
            this.getPageCache().put("change_entity_flag", "yes");
            this.getView().updateView("flowentry");
        }
    }

    private boolean isFlowHaveInHandCompleteProc(Long flowId) {
        Long procdefId;
        DynamicObject workflow = WORK_FLOW_APPLICATION_SERVICE.getWorkflow(flowId.longValue());
        DynamicObjectCollection workflowEntry = workflow.getDynamicObjectCollection("entryentity");
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity.id");
        DynamicObject[] procs = WORK_FLOW_APPLICATION_SERVICE.haveInHandCompleteProcs(activityId, procdefId = Long.valueOf(((DynamicObject)workflowEntry.get(0)).getLong("flowdefproc")));
        DynamicObject[] actevalObjs = EPA_ACTEVAOBJ_SERVICE.getActevalobjArrayById(Arrays.stream(procs).map(proc -> proc.getLong("actevalobj")).collect(Collectors.toList()));
        Set assessStatus = Arrays.stream(actevalObjs).map(act -> act.getString("assessstaus")).collect(Collectors.toSet());
        if (assessStatus.size() == 1 && assessStatus.contains("40") || assessStatus.contains(EPA_EVAWORKFLOW)) {
            return Boolean.FALSE;
        }
        if (assessStatus.size() == 0) {
            return Boolean.FALSE;
        }
        return procs.length > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    protected void editFlow(DynamicObject workflow) {
        DynamicObjectCollection evalEntityList = this.getModel().getEntryEntity("evalentryentity");
        String cardIndex = this.getView().getPageCache().get("cardIndex");
        long flowId = ((DynamicObject)evalEntityList.get(Integer.parseInt(cardIndex))).getLong("id");
        boolean isHisVersionTemp = this.isHisVersionTemp(flowId);
        boolean ref = this.isAudit();
        if (isHisVersionTemp && ref && !this.isSaveOrPublish(flowId)) {
            this.showHisFlowItem(flowId);
        } else {
            Long procDefId = workflow.getDynamicObjectCollection("entryentity").isEmpty() ? 0L : ((DynamicObject)workflow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            String childrenPageId = this.showFlowItem(flowId, procDefId, OperationStatus.EDIT, EvalProcessOperationEnum.EDIT);
            ActivityTabsUtils.addEntryEntityItem(this.getView(), this.getView().getPageId(), childrenPageId, ((DynamicObject)evalEntityList.get(Integer.parseInt(cardIndex))).getString("flowname"));
        }
    }

    protected void editFlow(Long newFlowId, Long newProcId) {
        boolean isHisVersionTemp = this.isHisVersionTemp(newFlowId);
        boolean ref = this.isAudit();
        if (isHisVersionTemp && ref && !this.isSaveOrPublish(newFlowId)) {
            this.showHisFlowItem(newFlowId);
        } else {
            String childrenPageId = this.showFlowItem(newFlowId, newProcId, OperationStatus.EDIT, EvalProcessOperationEnum.COPY);
            ActivityTabsUtils.addEntryEntityItem(this.getView(), this.getView().getPageId(), childrenPageId, ResManager.loadKDString((String)"\u65b0\u589e\u6d41\u7a0b\u4fe1\u606f", (String)"ActivityPerfWorkFlowEdit_10", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
        }
    }

    protected void viewFlow() {
        DynamicObjectCollection evalEntityList = this.getModel().getEntryEntity("evalentryentity");
        String cardIndex = this.getView().getPageCache().get("cardIndex");
        long flowId = ((DynamicObject)evalEntityList.get(Integer.parseInt(cardIndex))).getLong("id");
        long vid = this.getVidByFlowId(flowId);
        String childrenPageId = this.showFlowItem(vid, OperationStatus.VIEW, EvalProcessOperationEnum.VIEW);
        ActivityTabsUtils.addEntryEntityItem(this.getView(), this.getView().getPageId(), childrenPageId, ((DynamicObject)evalEntityList.get(Integer.parseInt(cardIndex))).getString("flowname"));
    }

    protected void publishFlow() {
        ArrayList<CheckFlowBo> checkFlowBos = new ArrayList<CheckFlowBo>();
        String cardIndex = this.getView().getPageCache().get("cardIndex");
        if (HRStringUtils.isNotEmpty((String)cardIndex)) {
            DynamicObjectCollection evalEntityList = this.getModel().getEntryEntity("evalentryentity");
            DynamicObject dynamicObject = (DynamicObject)evalEntityList.get(Integer.parseInt(cardIndex));
            List<String> workFlowNames = this.isWorkFlowEntriesEdit();
            if (workFlowNames.contains(dynamicObject.getString("flowname"))) {
                String opText = ResManager.loadKDString((String)"\u53d1\u5e03", (String)"ActivityPerfWorkFlowEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6b63\u5728\u66f4\u6539\u5b50\u6d41\u7a0b-{0},\u4e0d\u652f\u6301{1}\uff0c\u5982\u9700{2}\u8bf7\u5173\u95ed\u7f16\u8f91\u9875\u9762\u3002", (String)"ActivityPerfWorkFlowEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{dynamicObject.getString("flowname"), opText, opText});
                this.getView().showErrorNotification(msg);
                return;
            }
            DynamicObjectCollection flowEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("flowentry");
            if (!WORK_FLOW_APPLICATION_SERVICE.validatorFlowData(flowEntry, dynamicObject.getLong("id"), checkFlowBos)) {
                String msg = ResManager.loadKDString((String)"\u6d41\u7a0b\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u53d1\u5e03\u5931\u8d25\u3002", (String)"ActivityPerfWorkFlowEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                this.showCheckFlow(checkFlowBos, this.getView(), "epa_checkflow");
                return;
            }
            this.confirmPublish();
        }
    }

    protected void copyFlow(DynamicObject workflow) {
        DynamicObjectCollection flowEntrys = this.getModel().getEntryEntity("flowentry");
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and("boid", "in", (Object)workflow.getLong("id"));
        DynamicObject[] oldWorkflows = WorkFlowEntityService.getInstance().loadDynamicObjectArray(new QFilter[]{qFilter});
        if (oldWorkflows.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6d41\u7a0b\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u590d\u5236", (String)"ActivityPerfWorkFlowEdit_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        List procIds = Arrays.stream(oldWorkflows).map(p -> p.getDynamicObjectCollection("entryentity").stream().map(q -> q.getLong("flowdefproc")).collect(Collectors.toList())).reduce((a, b) -> {
            a.addAll(b);
            return a;
        }).get();
        long[] oldDefIds = ORM.create().genLongIds("pbs_flowdefproc", oldWorkflows.length);
        DynamicObject[] oldFlowDefs = FlowDefProcDomainService.getInstance().getFlowDefProc(procIds);
        FlowDefProcEntityService.getInstance().save(this.copyFlowDefs(oldFlowDefs, oldDefIds));
        HashMap<Long, Long> oldNewDefIdMap = new HashMap<Long, Long>(oldFlowDefs.length);
        int k = 0;
        for (DynamicObject dynamicObject : oldFlowDefs) {
            oldNewDefIdMap.put(dynamicObject.getLong("id"), oldDefIds[k++]);
        }
        long[] newFlowIds = ORM.create().genLongIds("pbs_workflow", oldWorkflows.length);
        WorkFlowEntityService.getInstance().save(this.copyWorkFlows(oldWorkflows, newFlowIds, oldNewDefIdMap));
        HashMap<Long, Long> oldNewFlowIdMap = new HashMap<Long, Long>(oldWorkflows.length);
        int i = 0;
        for (DynamicObject oldWorkFlow : oldWorkflows) {
            oldNewFlowIdMap.put(oldWorkFlow.getLong("id"), newFlowIds[i++]);
        }
        Long l = (Long)oldNewFlowIdMap.get(workflow.getLong("id"));
        Long newProcId = oldDefIds[0];
        this.editFlow(l, newProcId);
    }

    protected void updateNewWorkFlowEntryCache(DynamicObjectCollection flowEntrys, Long oldFlowId, String workflowType, Map<Long, Long> oldNewFlowIdMap) {
        long[] newPerfFlowEntryIds = DBServiceHelper.genLongIds((String)"t_epa_perfworklowentry", (int)1);
        Long newFlowId = oldNewFlowIdMap.get(oldFlowId);
        DynamicObject newEntry = flowEntrys.addNew();
        newEntry.set("flowid", (Object)newFlowId);
        newEntry.set("flowvid", (Object)newFlowId);
        newEntry.set("passnode", (Object)AssessNodeWorkFlowTypeEnum.getNodeIdByWorkFlowType((String)workflowType));
        long newPerfFlowEntryId = newPerfFlowEntryIds[0];
        newEntry.set("entryboidflow", (Object)newPerfFlowEntryId);
        newEntry.set("id", (Object)newPerfFlowEntryId);
        DynamicObject oldFlowEntry = flowEntrys.stream().filter(flowEntry -> flowEntry.getLong("flowid") == oldFlowId.longValue()).findFirst().get();
        newEntry.set("passnode", oldFlowEntry.get("passnode"));
        this.getModel().updateEntryCache(flowEntrys);
    }

    protected void permConfigFlow(DynamicObject workflow) {
        DynamicObjectCollection evalEntityList;
        DynamicObject dynamicObject;
        boolean isUsed;
        Long permissId = (Long)this.getView().getFormShowParameter().getCustomParam("dynamicpermission.id");
        if (null == permissId || permissId == 0L) {
            permissId = this.getView().getParentView().getModel().getDataEntity(true).getLong("dynamicpermission.id");
        }
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity.id");
        DynamicObjectCollection flowentryColls = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("flowentry");
        HashMap<Long, Boolean> flowDeleteMap = new HashMap<Long, Boolean>(16);
        HashMap<Long, Long> flowIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject flowEntry : flowentryColls) {
            flowDeleteMap.put(flowEntry.getLong("flowid"), flowEntry.getBoolean("isdelete"));
            flowDeleteMap.put(flowEntry.getLong("flowvid"), flowEntry.getBoolean("isdelete"));
            flowIdMap.put(flowEntry.getLong("flowvid"), flowEntry.getLong("flowid"));
        }
        DynamicObject flowEntryObj = flowentryColls.stream().filter(flowentryObj -> flowentryObj.getLong("flowid") == workflow.getLong("id")).findFirst().orElse(null);
        Long workflowId = 0L;
        if (flowEntryObj != null) {
            workflowId = flowEntryObj.getLong("flowvid");
        }
        Map<Long, String> flowvidMap = flowentryColls.stream().collect(Collectors.toMap(data -> data.getLong("flowvid"), data -> data.getString("passnode"), (key1, key2) -> key2));
        String selectAct = flowvidMap.get(workflowId);
        Map<Long, String> flowidMap = flowentryColls.stream().collect(Collectors.toMap(data -> data.getLong("flowid"), data -> data.getString("passnode"), (key1, key2) -> key2));
        if (workflowId == 0L) {
            if (flowEntryObj != null) {
                workflowId = flowEntryObj.getLong("flowid");
            }
            selectAct = flowidMap.get(workflowId);
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{CHILDREN});
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("epa_act_permissionsetting");
        baseShowParameter.setCustomParam("BATCH_SETTING", (Object)false);
        baseShowParameter.setCustomParam("processpermsetting", (Object)permissId);
        baseShowParameter.setCustomParam("activityId", (Object)activityId);
        baseShowParameter.setCustomParam("FromWhere", (Object)"WorkFlow");
        baseShowParameter.setCustomParam("operateType", (Object)"cardPage");
        baseShowParameter.setCustomParam("selectAct", (Object)selectAct);
        baseShowParameter.setCustomParam("WorkFlow", (Object)workflowId);
        baseShowParameter.setCustomParam("permissCacheKey", (Object)this.getPageCache().get(DYNAMIC_PERMISSION_CACHE_KEY));
        baseShowParameter.setCustomParam("flowDeleteMap", flowDeleteMap);
        baseShowParameter.setCustomParam("flowIdMap", flowIdMap);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_act_permissionsetting"));
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.getOpenStyle().setTargetKey(CHILDREN);
        baseShowParameter.setHasRight(true);
        baseShowParameter.setShowTitle(false);
        baseShowParameter.setShowClose(true);
        baseShowParameter.setStatus(this.getAreaStatus());
        String cardIndex = this.getView().getPageCache().get("cardIndex");
        if (HRStringUtils.isNotEmpty((String)cardIndex) && (isUsed = (dynamicObject = (DynamicObject)(evalEntityList = this.getModel().getEntryEntity("evalentryentity")).get(Integer.parseInt(cardIndex))).getBoolean("isused"))) {
            baseShowParameter.setStatus(OperationStatus.VIEW);
        }
        this.getView().showForm(baseShowParameter);
        this.getView().setVisible(Boolean.FALSE, new String[]{CURRENTAP});
        ActivityTabsUtils.addEntryEntityItem(this.getView(), this.getView().getPageId(), baseShowParameter.getPageId(), ResManager.loadKDString((String)"{0}\u6743\u9650\u8bbe\u7f6e", (String)"ActivityPerfWorkFlowEdit_15", (String)"opmc-pbs-formplugin", (Object[])new Object[]{workflow.getString("name")}));
    }

    private void saveFlowEntry() {
        DynamicObjectCollection flowentry = this.getView().getModel().getEntryEntity("flowentry");
        ArrayList<Long> flowIds = new ArrayList<Long>(10);
        for (DynamicObject entry : flowentry) {
            flowIds.add(entry.getLong("flowid"));
        }
        DynamicObject[] workflowDyns = WORK_FLOW_APPLICATION_SERVICE.getWorkflows(flowIds);
        for (DynamicObject entry : flowentry) {
            if (!entry.getBoolean("ischange")) continue;
            for (DynamicObject workflow : workflowDyns) {
                if (entry.getLong("flowid") != workflow.getLong("boid")) continue;
                long flowVid = workflow.getLong("sourcevid");
                if (flowVid == 0L) {
                    flowVid = entry.getLong("flowid");
                }
                entry.set("flowvid", (Object)flowVid);
            }
        }
        this.getView().updateView("flowentry");
        this.getView().getPageCache().remove("permconfigchange");
    }

    protected void validate(BeforeDoOperationEventArgs args) {
        DistributeSessionlessCache commonRegionCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("commonRegion");
        String dynamicPermissionCacheKey = this.getPageCache().get(DYNAMIC_PERMISSION_CACHE_KEY);
        try {
            String dynamicPermissionConfigVOJsonString = (String)commonRegionCache.get(dynamicPermissionCacheKey);
            if (HRStringUtils.isEmpty((String)dynamicPermissionCacheKey) || HRStringUtils.isEmpty((String)dynamicPermissionConfigVOJsonString)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u6216\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"ActivityPerfWorkFlowEdit_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u6216\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"ActivityPerfWorkFlowEdit_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    protected void startFlow(DynamicObject workflow) {
        DynamicObjectCollection flowentry = this.getView().getModel().getEntryEntity("flowentry");
        Boolean enable = flowentry.stream().filter(entry -> entry.getLong("flowid") == workflow.getLong("boid")).map(obj -> obj.getBoolean("isenable")).findFirst().orElse(Boolean.FALSE);
        if (enable.booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u8be5\u6d41\u7a0b\u5df2\u662f\u542f\u7528\u72b6\u6001\u3002", (String)"ActivityPerfWorkFlowEdit_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        } else {
            List<String> workFlowNames = this.isWorkFlowEntriesEdit();
            if (workFlowNames.contains(workflow.getString("name"))) {
                String opText = ResManager.loadKDString((String)"\u542f\u7528", (String)"ActivityPerfWorkFlowEdit_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6b63\u5728\u66f4\u6539\u5b50\u6d41\u7a0b-{0},\u4e0d\u652f\u6301{1}\uff0c\u5982\u9700{2}\u8bf7\u5173\u95ed\u7f16\u8f91\u9875\u9762\u3002", (String)"ActivityPerfWorkFlowEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{workflow.getString("name"), opText, opText});
                this.getView().showErrorNotification(msg);
                return;
            }
            workflow.set("enable", (Object)"1");
            WORK_FLOW_APPLICATION_SERVICE.disableOrEnableFlow(workflow);
            String msg = ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f", (String)"ActivityPerfWorkFlowEdit_19", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
            this.saveFlowEntry(workflow.getLong("boid"), null, Boolean.TRUE, null);
            this.buildEvalEntryEntity(workflow.getString("workflowtype"));
        }
    }

    protected void banFlow(DynamicObject workflow) {
        DynamicObjectCollection flowentry = this.getView().getModel().getEntryEntity("flowentry");
        Boolean enable = flowentry.stream().filter(entry -> entry.getLong("flowid") == workflow.getLong("boid")).map(obj -> obj.getBoolean("isenable")).findFirst().orElse(Boolean.FALSE);
        if (!enable.booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u8be5\u6d41\u7a0b\u5df2\u662f\u7981\u7528\u72b6\u6001\u3002", (String)"ActivityPerfWorkFlowEdit_20", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        } else {
            if (HRStringUtils.equals((String)EPA_EVAWORKFLOW, (String)workflow.getString("publishstatus"))) {
                String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u7981\u7528\u201c\u5f85\u53d1\u5e03\u201d\u6570\u636e\u3002", (String)"ActivityPerfWorkFlowEdit_21", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            List<String> workFlowNames = this.isWorkFlowEntriesEdit();
            if (workFlowNames.contains(workflow.getString("name"))) {
                String opText = ResManager.loadKDString((String)"\u7981\u7528", (String)"ActivityPerfWorkFlowEdit_22", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6b63\u5728\u66f4\u6539\u5b50\u6d41\u7a0b-{0},\u4e0d\u652f\u6301{1}\uff0c\u5982\u9700{2}\u8bf7\u5173\u95ed\u7f16\u8f91\u9875\u9762\u3002", (String)"ActivityPerfWorkFlowEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{workflow.getString("name"), opText, opText});
                this.getView().showErrorNotification(msg);
                return;
            }
            workflow.set("enable", (Object)"0");
            WORK_FLOW_APPLICATION_SERVICE.disableOrEnableFlow(workflow);
            String msg = ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f", (String)"ActivityPerfWorkFlowEdit_23", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
            this.saveFlowEntry(workflow.getLong("boid"), Boolean.FALSE, Boolean.FALSE, null);
            this.buildEvalEntryEntity(workflow.getString("workflowtype"));
        }
    }

    protected void setFlowDefault(DynamicObject workflow) {
        DynamicObjectCollection flowentry = this.getView().getModel().getEntryEntity("flowentry");
        Boolean isDefault = flowentry.stream().filter(entry -> entry.getLong("flowid") == workflow.getLong("boid")).map(obj -> obj.getBoolean("isdefaultflow")).findFirst().orElse(Boolean.FALSE);
        Boolean isEnable = flowentry.stream().filter(entry -> entry.getLong("flowid") == workflow.getLong("boid")).map(obj -> obj.getBoolean("isenable")).findFirst().orElse(Boolean.FALSE);
        if (!isEnable.booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u7981\u7528\u7684\u6d41\u7a0b\u8bbe\u4e3a\u9ed8\u8ba4\u6d41\u7a0b\u3002", (String)"ActivityPerfWorkFlowEdit_24", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        if (isDefault.booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u6b64\u6d41\u7a0b\u4e3a\u9ed8\u8ba4\u6d41\u7a0b\uff0c\u65e0\u9700\u66f4\u6539\u3002", (String)"ActivityPerfWorkFlowEdit_25", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        } else {
            this.getView().getPageCache().put("flowid", workflow.getString("id"));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("setFlowDefault", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u8be5\u6d41\u7a0b\u8bbe\u4e3a\u9ed8\u8ba4\uff1f", (String)"ActivityPerfWorkFlowEdit_26", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
        }
    }

    protected void deleteFlow(DynamicObject workflow) {
        DynamicObjectCollection flowentry = this.getView().getModel().getEntryEntity("flowentry");
        Boolean enable = flowentry.stream().filter(entry -> entry.getLong("flowid") == workflow.getLong("boid")).map(obj -> obj.getBoolean("isenable")).findFirst().orElse(Boolean.FALSE);
        if (!enable.booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u201c\u7981\u7528\u201d\u72b6\u6001\u4e0b\u7684\u6570\u636e\u4e0d\u652f\u6301\u5220\u9664\u3002", (String)"ActivityPerfWorkFlowEdit_27", (String)"opmc-epa-formplugin", (Object[])new Object[]{workflow.getString("name")});
            this.getView().showErrorNotification(msg);
        } else {
            this.getView().getPageCache().put("flowid", workflow.getString("id"));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("deleteFlow", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u6b64\u6d41\u7a0b\uff1f", (String)"ActivityPerfWorkFlowEdit_28", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "setFlowDefault": {
                if (MessageBoxResult.Yes != event.getResult()) break;
                DynamicObject workflow = WORK_FLOW_APPLICATION_SERVICE.getWorkflow(Long.parseLong(this.getView().getPageCache().get("flowid")));
                List<String> workFlowNames = this.isWorkFlowEntriesEdit();
                if (workFlowNames.contains(workflow.getString("name"))) {
                    String opText = ResManager.loadKDString((String)"\u8bbe\u4e3a\u9ed8\u8ba4", (String)"ActivityPerfWorkFlowEdit_29", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6b63\u5728\u66f4\u6539\u5b50\u6d41\u7a0b-{0},\u4e0d\u652f\u6301{1}\uff0c\u5982\u9700{2}\u8bf7\u5173\u95ed\u7f16\u8f91\u9875\u9762\u3002", (String)"ActivityPerfWorkFlowEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{workflow.getString("name"), opText, opText});
                    this.getView().showErrorNotification(msg);
                    return;
                }
                this.saveFlowEntry(workflow.getLong("boid"), Boolean.TRUE, null, null);
                String msg = ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u6d41\u7a0b\u6210\u529f\u3002", (String)"ActivityPerfWorkFlowEdit_30", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg);
                this.buildEvalEntryEntity(workflow.getString("workflowtype"));
                break;
            }
            case "deleteFlow": {
                if (MessageBoxResult.Yes != event.getResult()) break;
                DynamicObject workflow = WORK_FLOW_APPLICATION_SERVICE.getWorkflow(Long.parseLong(this.getView().getPageCache().get("flowid")));
                List<String> workFlowNames = this.isWorkFlowEntriesEdit();
                if (workFlowNames.contains(workflow.getString("name"))) {
                    String opText = ResManager.loadKDString((String)"\u5220\u9664", (String)"ActivityPerfWorkFlowEdit_31", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6b63\u5728\u66f4\u6539\u5b50\u6d41\u7a0b-{0},\u4e0d\u652f\u6301{1}\uff0c\u5982\u9700{2}\u8bf7\u5173\u95ed\u7f16\u8f91\u9875\u9762\u3002", (String)"ActivityPerfWorkFlowEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{workflow.getString("name"), opText, opText});
                    this.getView().showErrorNotification(msg);
                    return;
                }
                DynamicObjectCollection flowEntry = this.getModel().getEntryEntity("flowentry");
                if (this.isFlowHaveInHandCompleteProc(workflow.getLong("id"))) {
                    String msg = ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u4f7f\u7528\uff0c\u4e0d\u53ef\u5220\u9664", (String)"ActivityPerfWorkFlowEdit_32", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(msg);
                    return;
                }
                for (DynamicObject flow : flowEntry) {
                    if (flow.getLong("flowid") != workflow.getLong("id")) continue;
                    flow.set("isdelete", (Object)Boolean.TRUE);
                }
                this.getView().getModel().updateEntryCache(flowEntry);
                if (0 == this.getModel().getEntryEntity("flowentry").size()) {
                    this.getModel().deleteEntryData("evalentryentity");
                } else {
                    this.buildEvalEntryEntity(this.getWorkflowType(""));
                }
                DynamicPermssionConfigCacheUtils.dynamicPermssionConfigCacheHandle(workflow.getLong("id"), Collections.EMPTY_LIST, this.getView());
                String msg = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"ActivityPerfWorkFlowEdit_33", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg);
                break;
            }
            case "change_back_confirm": {
                if (MessageBoxResult.Yes == event.getResult()) {
                    this.getPageCache().put("change_back_confirm_result", "yes");
                    this.rollbackFlows();
                } else {
                    this.getPageCache().put("change_back_confirm_result", "no");
                }
                this.getView().close();
                break;
            }
            case "breadclose": {
                if (MessageBoxResult.Yes != event.getResult()) break;
                this.getView().getParentView().getPageCache().put("clickCardEntry", "true");
                ActivityTabsUtils.selectEntryEntityItem(this.getView(), this.getView().getPageId(), 0, (IFormPlugin)this, true);
                this.getView().getParentView().getPageCache().put("clickCardEntry", "false");
                break;
            }
        }
    }

    protected void setPerfSumDefault() {
        IDataModel iDataModel = this.getView().getModel();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        dynamicObjectCollection.stream().filter(dyc -> HRStringUtils.equals((String)dyc.getDynamicObject("node").getString("number"), (String)NodeTabMapEnum.PERF_SUM.getNodeNumber())).findFirst().ifPresent(dynamicObject -> iDataModel.setValue("sumcustomname", (Object)dynamicObject.getDynamicObject("node").getString("name")));
        this.getView().updateView(NodeTabMapEnum.PERF_SUM.getTabName());
    }

    private void setEvalProcessDefault() {
        IDataModel iDataModel = this.getView().getModel();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        dynamicObjectCollection.stream().filter(dyc -> HRStringUtils.equals((String)dyc.getDynamicObject("node").getString("number"), (String)NodeTabMapEnum.EVAL_PROCESS.getNodeNumber())).findFirst().ifPresent(dynamicObject -> {
            iDataModel.setValue("evalcustomname", (Object)dynamicObject.getDynamicObject("node").getString("name"));
            iDataModel.setValue("evalsetmode", dynamicObject.get("settingmode"));
        });
        this.getView().updateView(NodeTabMapEnum.EVAL_PROCESS.getTabName());
    }

    private void setTargetFormulateDefault() {
        IDataModel iDataModel = this.getView().getModel();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        dynamicObjectCollection.stream().filter(dyc -> HRObjectUtils.equals((Object)dyc.getDynamicObject("node").getLong("id"), (Object)NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId())).findFirst().ifPresent(dynamicObject -> {
            iDataModel.setValue("targetcustomname", (Object)dynamicObject.getDynamicObject("node").getString("name"));
            iDataModel.setValue("targetsetmode", dynamicObject.get("settingmode"));
        });
        this.getView().updateView(NodeTabMapEnum.TARGET_FORMU_LATE.getTabName());
    }

    private void setPerfCalibrationDefault() {
        IDataModel iDataModel = this.getView().getModel();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        dynamicObjectCollection.stream().filter(dyc -> HRObjectUtils.equals((Object)dyc.getDynamicObject("node").getLong("id"), (Object)NodeTabMapEnum.PERF_CALIBRATION.getNodeId())).findFirst().ifPresent(dynamicObject -> iDataModel.setValue("perfcustomname", (Object)dynamicObject.getDynamicObject("node").getString("name")));
        this.getView().updateView(NodeTabMapEnum.PERF_CALIBRATION.getTabName());
    }

    private void setResultConfirmDefault() {
        IDataModel iDataModel = this.getView().getModel();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        dynamicObjectCollection.stream().filter(dyc -> HRObjectUtils.equals((Object)dyc.getDynamicObject("node").getLong("id"), (Object)NodeTabMapEnum.RESULT_CONFIRM.getNodeId())).findFirst().ifPresent(dynamicObject -> iDataModel.setValue("resultcustomname", (Object)dynamicObject.getDynamicObject("node").getString("name")));
        this.getView().updateView(NodeTabMapEnum.RESULT_CONFIRM.getTabName());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        OperateOption option = source.getOption();
        option.setVariableValue("operateType", source.getOperateKey());
        option.setVariableValue(DYNAMIC_PERMISSION_CACHE_KEY, this.getPageCache().get(DYNAMIC_PERMISSION_CACHE_KEY));
        String assessFormId = this.getView().getPageCache().get("assessFormId");
        if (HRStringUtils.isNotEmpty((String)assessFormId)) {
            option.setVariableValue("assessFormId", assessFormId);
        }
        switch (source.getOperateKey()) {
            case "save": {
                boolean haveChange = this.checkSumValueChange();
                option.setVariableValue("haveChange", String.valueOf(haveChange));
            }
            case "submit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                this.validate(args);
                this.saveTabCustome();
                this.clearPerfSumTempVal();
                this.saveFlowEntry();
                break;
            }
            case "publish": {
                ArrayList<CheckFlowBo> checkFlowBos = new ArrayList<CheckFlowBo>();
                String cardIndex = this.getView().getPageCache().get("cardIndex");
                if (!HRStringUtils.isNotEmpty((String)cardIndex)) break;
                DynamicObjectCollection evalEntityList = this.getModel().getEntryEntity("evalentryentity");
                DynamicObject dynamicObject = (DynamicObject)evalEntityList.get(Integer.parseInt(cardIndex));
                List<String> workFlowNames = this.isWorkFlowEntriesEdit();
                if (workFlowNames.contains(dynamicObject.getString("flowname"))) {
                    String opText = ResManager.loadKDString((String)"\u53d1\u5e03", (String)"ActivityPerfWorkFlowEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6b63\u5728\u66f4\u6539\u5b50\u6d41\u7a0b-{0},\u4e0d\u652f\u6301{1}\uff0c\u5982\u9700{2}\u8bf7\u5173\u95ed\u7f16\u8f91\u9875\u9762\u3002", (String)"ActivityPerfWorkFlowEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{dynamicObject.getString("flowname"), opText, opText});
                    this.getView().showErrorNotification(msg);
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection flowEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("flowentry");
                if (WORK_FLOW_APPLICATION_SERVICE.validatorFlowData(flowEntry, dynamicObject.getLong("id"), checkFlowBos)) break;
                String msg = ResManager.loadKDString((String)"\u6d41\u7a0b\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u53d1\u5e03\u5931\u8d25\u3002", (String)"ActivityPerfWorkFlowEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                this.showCheckFlow(checkFlowBos, this.getView(), "epa_checkflow");
                args.setCancel(true);
                break;
            }
            case "viewflowchart": {
                String procIndex = this.getView().getPageCache().get("cardprocindex");
                if (!HRStringUtils.isNotEmpty((String)procIndex)) break;
                DynamicObjectCollection evalEntityList = this.getModel().getEntryEntity("resultconfirmentry");
                DynamicObject dynamicObject = (DynamicObject)evalEntityList.get(Integer.parseInt(procIndex));
                this.showResultFlow(dynamicObject.getString("entryboidmodelid"));
                args.setCancel(true);
                break;
            }
            case "insertdata_his": {
                this.getView().setEnable(Boolean.FALSE, new String[]{EPA_WORKFLOWTYPE});
                this.getView().updateView(EPA_WORKFLOWTYPE);
                break;
            }
            case "closenodetpl": {
                this.closeNodeTpl();
                break;
            }
            case "addnewflow": {
                if (AssActivityPermissionUtils.checkActivityPerfWorkflowPermission(this.getView())) {
                    if (this.showSelectForm()) {
                        args.setCancel(true);
                        return;
                    }
                    String childrenPageId = this.showFlowItem(0L, OperationStatus.ADDNEW, EvalProcessOperationEnum.DEFAULT);
                    ActivityTabsUtils.addEntryEntityItem(this.getView(), this.getView().getPageId(), childrenPageId, ResManager.loadKDString((String)"\u65b0\u589e\u6d41\u7a0b\u4fe1\u606f", (String)"ActivityPerfWorkFlowEdit_10", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                break;
            }
            case "refreshcard": {
                this.buildEvalEntryEntity(this.getWorkflowType(""));
                this.getPageCache().put("change_entity_flag", "yes");
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean checkSumValueChange() {
        String startValue = this.getView().getPageCache().get("startValue");
        Object ismpsopexchange = this.getModel().getValue("ismpsopexchange");
        Object ismplevelexchange = this.getModel().getValue("ismplevelexchange");
        Object mplevelset = this.getModel().getValue("mplevelset");
        DynamicObject sumperflevel = (DynamicObject)this.getModel().getValue("sumperflevel");
        DynamicObject scoresystem = (DynamicObject)this.getModel().getValue("scoresystem");
        String nowValue = String.valueOf(ismpsopexchange) + ismplevelexchange;
        if (Boolean.TRUE.equals(ismplevelexchange)) {
            nowValue = nowValue + mplevelset;
        }
        if (sumperflevel != null) {
            nowValue = nowValue + sumperflevel.getPkValue();
        }
        if (scoresystem != null) {
            nowValue = nowValue + scoresystem.getPkValue();
        }
        return !HRStringUtils.equals((String)nowValue, (String)startValue);
    }

    private void clearPerfSumTempVal() {
        if (this.checkOnlyAggregation() && this.perfsumSelected()) {
            if (HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                this.getModel().setValue("mplevelset", (Object)GradeRuleSrcEnum.SETTINGSELF.getValue());
            } else {
                this.getModel().setValue("mplevelset", null);
            }
            if (HRStringUtils.equals((String)"false", (String)String.valueOf(this.getModel().getValue("ismpsopexchange"))) && HRStringUtils.equals((String)"false", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                this.getModel().setValue("scoresystem", null);
            }
            if (HRStringUtils.equals((String)"false", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                this.getModel().setValue("sumperflevel", null);
            }
        } else {
            this.getModel().setValue("scoresystem", null);
            if (HRStringUtils.equals((String)"false", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                this.getModel().setValue("mplevelset", null);
                this.getModel().setValue("sumperflevel", null);
            } else if (!HRStringUtils.equals((String)GradeRuleSrcEnum.SETTINGSELF.getValue(), (String)String.valueOf(this.getModel().getValue("mplevelset")))) {
                this.getModel().setValue("sumperflevel", null);
            }
        }
    }

    public void showCheckFlow(List<CheckFlowBo> checkFlowBos, IFormView view, String entityNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(entityNumber);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entityNumber));
        showParameter.setCustomParam("checkFlowBos", checkFlowBos);
        view.showForm(showParameter);
    }

    public void showResultFlow(String modelId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ide_workflowdesigner");
        formShowParameter.setCustomParam("id", (Object)modelId);
        formShowParameter.setCustomParam("model_type", (Object)"WorkflowModel");
        formShowParameter.setClientParam("modelId", (Object)modelId);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!ObjectUtils.isEmpty((Object)afterDoOperationEventArgs.getOperationResult()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String operateKey = afterDoOperationEventArgs.getOperateKey();
            AbstractOperate source = (AbstractOperate)afterDoOperationEventArgs.getSource();
            String isChangeActNode = source.getOption().getVariableValue("activityNodeHaveChange", "false");
            switch (operateKey) {
                case "save": {
                    this.setPageCache();
                    this.deleteBackupFlows();
                    this.getView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView());
                    this.buildEvalEntryEntity(this.getWorkflowType(""));
                    if (HRStringUtils.equals((String)isChangeActNode, (String)"true")) {
                        this.getView().getParentView().getPageCache().put("lastSelectRow", null);
                    }
                    this.getView().getParentView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView().getParentView());
                    break;
                }
                case "submit": 
                case "unsubmit": 
                case "confirmchange": 
                case "confirmchangenoaudit": 
                case "audit": {
                    this.deleteBackupFlows();
                    this.getView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView());
                    this.buildEvalEntryEntity(this.getWorkflowType(""));
                    this.getView().getParentView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView().getParentView());
                    break;
                }
                case "publish": {
                    this.confirmPublish();
                    break;
                }
            }
            if (!("refreshcard".equals(operateKey) || "publish".equals(operateKey) || "addnewflow".equals(operateKey))) {
                this.showTabButton();
            }
        }
    }

    private void deleteBackupFlows() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("flowentry");
        List flowIds = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("flowid")).collect(Collectors.toList());
        if (!flowIds.isEmpty()) {
            WORK_FLOW_APPLICATION_SERVICE.deleteBackupFlows(flowIds);
            Iterator iterator = flowIds.iterator();
            while (iterator.hasNext()) {
                long flowId = (Long)iterator.next();
                this.getView().getPageCache().remove("copyTempFlowId" + flowId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackFlows() {
        DynamicObject[] copyTempWorkflow;
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("flowentry");
        List flowIds = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("flowid")).collect(Collectors.toList());
        if (!flowIds.isEmpty() && (copyTempWorkflow = WORK_FLOW_APPLICATION_SERVICE.getCopyTempWorkflow(flowIds)).length > 0) {
            DynamicObject[] allWorkFlows = WORK_FLOW_APPLICATION_SERVICE.getWorkflowsByVids(flowIds);
            DynamicObjectCollection collection = new DynamicObjectCollection();
            block5: for (DynamicObject backupFlow : copyTempWorkflow) {
                long backupBoId = backupFlow.getLong("sourcevid");
                for (DynamicObject changeFlow : allWorkFlows) {
                    long changeBoId = changeFlow.getLong("boid");
                    if (backupBoId != changeBoId) continue;
                    Set ignoreFieldsAll = Stream.of("id", "masterid", "sourcevid", "boid", "iscurrentversion", "hisversion").collect(Collectors.toSet());
                    HRDynamicObjectUtils.copy((DynamicObject)backupFlow, (DynamicObject)changeFlow, ignoreFieldsAll, (boolean)true);
                    collection.add((Object)changeFlow);
                    continue block5;
                }
            }
            try (TXHandle required = TX.required();){
                WORK_FLOW_APPLICATION_SERVICE.save(collection);
                this.deleteBackupFlows();
            }
        }
    }

    protected void confirmPublish() {
        String cardIndex = this.getView().getPageCache().get("cardIndex");
        if (HRStringUtils.isNotEmpty((String)cardIndex)) {
            DynamicObjectCollection evalEntityList = this.getModel().getEntryEntity("evalentryentity");
            DynamicObject dynamicObject = (DynamicObject)evalEntityList.get(Integer.parseInt(cardIndex));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("epa_publishconfirm");
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_publishconfirm"));
            showParameter.setCustomParam("flowname", (Object)dynamicObject.getString("flowname"));
            showParameter.setCustomParam("assessruleid", this.getModel().getDataEntity(false).getPkValue());
            showParameter.setCustomParam("flowid", (Object)dynamicObject.getLong("id"));
            String customParam = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
            boolean ref = "open_insert_data_page".equals(customParam);
            showParameter.setCustomParam("tipRef", (Object)ref);
            showParameter.setHasRight(Boolean.TRUE.booleanValue());
            this.getView().showForm(showParameter);
        }
    }

    protected void saveTabCustome() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dyc : dynamicObjects) {
            Long nodeId = dyc.getDynamicObject("node").getLong("id");
            if (nodeId.equals(NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId())) {
                dyc.set("customname", this.getModel().getValue("targetcustomname"));
                dyc.set("settingmode", this.getModel().getValue("targetsetmode"));
                continue;
            }
            if (nodeId.equals(NodeTabMapEnum.PERF_CALIBRATION.getNodeId())) {
                dyc.set("customname", this.getModel().getValue("perfcustomname"));
                continue;
            }
            if (nodeId.equals(NodeTabMapEnum.RESULT_CONFIRM.getNodeId())) {
                dyc.set("customname", this.getModel().getValue("resultcustomname"));
                continue;
            }
            if (nodeId.equals(NodeTabMapEnum.EVAL_PROCESS.getNodeId())) {
                dyc.set("customname", this.getModel().getValue("evalcustomname"));
                dyc.set("settingmode", this.getModel().getValue("evalsetmode"));
                continue;
            }
            if (nodeId.equals(NodeTabMapEnum.PERF_SUM.getNodeId())) {
                dyc.set("customname", this.getModel().getValue("sumcustomname"));
                continue;
            }
            if (nodeId.equals(NodeTabMapEnum.PERF_INTERVIEW.getNodeId())) {
                dyc.set("customname", this.getModel().getValue("interviewcustomname"));
                dyc.set("settingmode", this.getModel().getValue("interviewsetmode"));
                continue;
            }
            dyc.set("customname", (Object)dyc.getDynamicObject("node").getString("name"));
        }
    }

    private String getWorkflowType(String tabName) {
        Tab tab = (Tab)this.getControl("activitycontenttabap");
        if (HRStringUtils.isEmpty((String)tabName)) {
            tabName = tab.getCurrentTab();
        }
        String workflowtype = "1";
        if (HRStringUtils.equals((String)NodeTabMapEnum.EVAL_PROCESS.getTabName(), (String)tabName)) {
            workflowtype = "2";
        } else if (HRStringUtils.equals((String)NodeTabMapEnum.TARGET_FORMU_LATE.getTabName(), (String)tabName)) {
            workflowtype = "1";
        } else if (HRStringUtils.equals((String)NodeTabMapEnum.PERF_INTERVIEW.getTabName(), (String)tabName)) {
            workflowtype = "3";
        }
        return workflowtype;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        List<String> workFlowNames = this.isWorkFlowEntriesEdit();
        if (workFlowNames.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u5173\u95ed\u5b50\u6d41\u7a0b\uff0c\u518d\u8fdb\u884c\u66f4\u6539\u3002", (String)"ActivityPerfWorkFlowEdit_34", (String)"opmc-epa-formplugin", (Object[])new Object[]{workFlowNames});
            this.getView().showMessage(msg, (String)workFlowNames.stream().reduce((k, v) -> k + System.lineSeparator() + v).get(), MessageTypes.Default);
            e.setCancel(true);
            return;
        }
        e.setCheckDataChange(false);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String flag = this.getPageCache().get("change_entity_flag");
        if (HRStringUtils.equals((String)"no", (String)flag)) {
            for (String aEntryKey : Arrays.asList("entryentity", "flowentry", "resultconfirmentry", "evalentryentity", ITEM_ENTRY_ENTITY)) {
                for (DynamicObject dyc : dataEntity.getDynamicObjectCollection(aEntryKey)) {
                    DataEntityState dycState = dyc.getDataEntityState();
                    for (IDataEntityProperty prop : dyc.getDataEntityType().getProperties()) {
                        dycState.setBizChanged(prop.getOrdinal(), false);
                    }
                }
            }
        }
        this.flowChangeConfirm(e, dataEntity);
        if (!e.isCancel()) {
            String dynamicPermissionCacheKey;
            CustomControl customcontrol = (CustomControl)this.getView().getParentView().getControl(CUSTOMCONTROLAP);
            if (customcontrol != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("show", "false");
                map.put("date", new Date());
                customcontrol.setData(map);
            }
            if (HRStringUtils.isNotEmpty((String)(dynamicPermissionCacheKey = this.getPageCache().get(DYNAMIC_PERMISSION_CACHE_KEY)))) {
                DistributeSessionlessCache commonRegionCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("commonRegion");
                commonRegionCache.remove(dynamicPermissionCacheKey);
            }
        }
    }

    protected void flowChangeConfirm(BeforeClosedEvent e, DynamicObject dataEntity) {
        block6: {
            if (null == this.getPageCache().get("change_back_confirm_result")) {
                try {
                    boolean haveChange = this.checkSumValueChange();
                    Map<Long, String> changeMap = this.getChangeMap(dataEntity);
                    if (e.isCheckDataChange() && this.checkDataChanged(e) || !changeMap.isEmpty() || HRStringUtils.equals((String)"true", (String)this.getView().getPageCache().get("permconfigchange")) || haveChange) {
                        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"ActivityPerfWorkFlowEdit_35", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"ActivityPerfWorkFlowEdit_36", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u5982\u679c\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ActivityPerfWorkFlowEdit_38", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("change_back_confirm", (IFormPlugin)this);
                        this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                        e.setCancel(Boolean.TRUE.booleanValue());
                    } else {
                        this.rollbackFlows();
                    }
                }
                catch (KDException error) {
                    if ("bos.pageCacheInvalid".equals(error.getErrorCode().getCode())) break block6;
                    throw error;
                }
            }
        }
        if ("no".equals(this.getPageCache().get("change_back_confirm_result"))) {
            this.getPageCache().put("change_back_confirm_result", null);
            e.setCancel(Boolean.TRUE.booleanValue());
        }
        e.setCheckDataChange(false);
    }

    private boolean checkDataChanged(BeforeClosedEvent e) {
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.VIEW || showParameter.getBillStatus() == BillOperationStatus.VIEW) {
            return false;
        }
        if (showParameter.getStatus() == OperationStatus.EDIT || showParameter.getBillStatus() == BillOperationStatus.SUBMIT || showParameter.getBillStatus() == BillOperationStatus.AUDIT) {
            List auditEnabledFields;
            List submitEnabledFields;
            Map enabledControlsMap = EntityMetadataCache.getEnabledControlsMap((String)showParameter.getFormId());
            if (showParameter.getBillStatus() == BillOperationStatus.SUBMIT ? (submitEnabledFields = (List)enabledControlsMap.get("submit")) == null || submitEnabledFields.isEmpty() : showParameter.getBillStatus() == BillOperationStatus.AUDIT && ((auditEnabledFields = (List)enabledControlsMap.get("audit")) == null || auditEnabledFields.isEmpty())) {
                return false;
            }
        }
        if (e.isSkipNoField()) {
            this.getModel().putContextVariable("bos_datachanged_skipnofield", (Object)true);
        } else {
            this.getModel().removeContextVariable("bos_datachanged_skipnofield");
        }
        return this.getModel().getDataChanged() && StringUtils.isNotBlank((CharSequence)this.getModel().getChangeDesc());
    }

    protected Map<Long, String> getChangeMap(DynamicObject dataEntity) {
        HashMap<Long, String> changeMap = new HashMap<Long, String>();
        DynamicObjectCollection nowFlow = dataEntity.getDynamicObjectCollection("flowentry");
        List originFlow = (List)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject("originFlowEntry"), List.class);
        int i = 0;
        int j = 0;
        while (i < originFlow.size() || j < nowFlow.size()) {
            Map saveEntry;
            String add = ResManager.loadKDString((String)"\u65b0\u589e", (String)"ActivityPerfWorkFlowEdit_39", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            String delete = ResManager.loadKDString((String)"\u5220\u9664", (String)"ActivityPerfWorkFlowEdit_31", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            String change = ResManager.loadKDString((String)"\u4fee\u6539", (String)"ActivityPerfWorkFlowEdit_40", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            if (i == originFlow.size()) {
                DynamicObject newEntry = (DynamicObject)nowFlow.get(j);
                changeMap.put(newEntry.getLong("flowid"), add);
                ++j;
                continue;
            }
            if (j == nowFlow.size()) {
                saveEntry = (Map)originFlow.get(i);
                changeMap.put(Long.parseLong(saveEntry.get("flowid").toString()), delete);
                ++i;
                continue;
            }
            saveEntry = (Map)originFlow.get(i);
            DynamicObject newEntry = (DynamicObject)nowFlow.get(j);
            if (Objects.equals(saveEntry.get("flowid"), newEntry.getLong("flowid"))) {
                for (String aProperKey : Arrays.asList("flowvid", "isdefaultflow", "isenable", "isdelete")) {
                    if (HRObjectUtils.equals((Object)saveEntry.get(aProperKey).toString(), (Object)newEntry.getString(aProperKey))) continue;
                    changeMap.put(newEntry.getLong("flowid"), change);
                }
                if (this.isCopyFlow(newEntry.getLong("flowid"))) {
                    changeMap.put(newEntry.getLong("flowid"), change);
                }
                ++i;
                ++j;
                continue;
            }
            if (Long.parseLong(saveEntry.get("flowid").toString()) > newEntry.getLong("flowid")) {
                changeMap.put(newEntry.getLong("flowid"), add);
                ++j;
                continue;
            }
            changeMap.put(Long.parseLong(saveEntry.get("flowid").toString()), delete);
            ++i;
        }
        if (!HRStringUtils.equals((String)dataEntity.getString("targetcustomname"), (String)this.getPageCache().get("formulateTargetcustomname"))) {
            changeMap.put(dataEntity.getLong("id"), "formulateTargetcustomname");
        }
        if (!HRStringUtils.equals((String)dataEntity.getString("evalcustomname"), (String)this.getPageCache().get("evaluateTargetcustomname"))) {
            changeMap.put(dataEntity.getLong("id"), "evaluateTargetcustomname");
        }
        if (!HRStringUtils.equals((String)dataEntity.getString("sumcustomname"), (String)this.getPageCache().get("sumTargetcustomname"))) {
            changeMap.put(dataEntity.getLong("id"), "sumTargetcustomname");
        }
        if (!HRStringUtils.equals((String)dataEntity.getString("perfcustomname"), (String)this.getPageCache().get("perfTargetcustomname"))) {
            changeMap.put(dataEntity.getLong("id"), "perfTargetcustomname");
        }
        if (!HRStringUtils.equals((String)dataEntity.getString("interviewcustomname"), (String)this.getPageCache().get("interviewTargetcustomname"))) {
            changeMap.put(dataEntity.getLong("id"), "interviewTargetcustomname");
        }
        if (!HRStringUtils.equals((String)dataEntity.getString("resultcustomname"), (String)this.getPageCache().get("resultTargetcustomname"))) {
            changeMap.put(dataEntity.getLong("id"), "resultTargetcustomname");
        }
        return changeMap;
    }

    private boolean checkOnlyAggregation() {
        boolean ret = true;
        List checkBoxs = ((Container)this.getControl("flexpanelap_config")).getItems();
        for (Control box : checkBoxs) {
            FieldEdit checkbox = (FieldEdit)box;
            String tabId = this.getPageCache().get(checkbox.getKey());
            Boolean isCheck = (Boolean)this.getModel().getValue(checkbox.getKey());
            if (!isCheck.booleanValue() || !NodeTabMapEnum.EVAL_PROCESS.getNodeId().toString().equals(tabId) && !NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId().toString().equals(tabId)) continue;
            ret = false;
        }
        return ret;
    }

    private boolean perfsumSelected() {
        boolean ret = false;
        List checkBoxs = ((Container)this.getControl("flexpanelap_config")).getItems();
        for (Control box : checkBoxs) {
            FieldEdit checkbox = (FieldEdit)box;
            String tabId = this.getPageCache().get(checkbox.getKey());
            Boolean isCheck = (Boolean)this.getModel().getValue(checkbox.getKey());
            if (!isCheck.booleanValue() || !NodeTabMapEnum.PERF_SUM.getNodeId().toString().equals(tabId)) continue;
            ret = true;
        }
        return ret;
    }

    private void fieldLinkage() {
        boolean onlyAggregation = this.checkOnlyAggregation();
        boolean perfsumSelected = this.perfsumSelected();
        boolean haveSumRecord = this.checkSumRecord();
        this.setMustFieldAndVisible(onlyAggregation && perfsumSelected);
        if (onlyAggregation && perfsumSelected) {
            this.getModel().setValue("aggregation", (Object)"A");
            this.getView().setEnable(Boolean.valueOf(!haveSumRecord), new String[]{"ismpsopexchange"});
            this.getView().setEnable(Boolean.valueOf(!haveSumRecord), new String[]{"ismplevelexchange"});
            this.getView().setEnable(Boolean.valueOf(!haveSumRecord), new String[]{"mplevelset"});
            this.getView().setEnable(Boolean.valueOf(!haveSumRecord), new String[]{"sumperflevel"});
            this.getView().setEnable(Boolean.valueOf(!haveSumRecord), new String[]{"scoresystem"});
        } else if (!onlyAggregation && perfsumSelected) {
            this.getView().setEnable(Boolean.valueOf(!haveSumRecord), new String[]{"ismpsopexchange"});
            this.getView().setEnable(Boolean.valueOf(!haveSumRecord), new String[]{"ismplevelexchange"});
            this.getView().setEnable(Boolean.valueOf(!haveSumRecord), new String[]{"mplevelset"});
            this.getView().setEnable(Boolean.valueOf(!haveSumRecord), new String[]{"sumperflevel"});
        }
    }

    private boolean checkSumRecord() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity.id");
        return ASSESS_ACTIVITY_APPLICATION_SERVICE.checkSumRecord(activityId);
    }

    protected OperationStatus getPermOpStatus() {
        boolean isaudit = this.isAudit();
        boolean isStash = 0L != (Long)this.getModel().getValue("id");
        return isaudit || isStash ? OperationStatus.EDIT : OperationStatus.ADDNEW;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setMustFieldAndVisible(boolean isOnlyAggregation) {
        if (isOnlyAggregation) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"mpnumaccuracy"});
            ComboEdit sumkeepdeplace = (ComboEdit)this.getControl("mpnumaccuracy");
            sumkeepdeplace.setMustInput(Boolean.TRUE.booleanValue());
            this.getView().setVisible(Boolean.TRUE, new String[]{"mpscaletype"});
            ComboEdit mpscaletype = (ComboEdit)this.getControl("mpscaletype");
            mpscaletype.setMustInput(Boolean.TRUE.booleanValue());
            if (OperationStatus.ADDNEW.equals((Object)this.getPermOpStatus())) {
                this.getModel().setValue("ismpsopexchange", (Object)Boolean.FALSE);
            }
            if (OperationStatus.ADDNEW.equals((Object)this.getPermOpStatus())) {
                this.getModel().setValue("ismplevelexchange", (Object)Boolean.FALSE);
            }
            BasedataEdit scoreSystem = (BasedataEdit)this.getControl("scoresystem");
            if (HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismpsopexchange"))) || HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"scoresystem"});
                scoreSystem.setMustInput(Boolean.TRUE.booleanValue());
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"scoresystem"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"mplevelset"});
            ComboEdit mplevelset = (ComboEdit)this.getControl("mplevelset");
            mplevelset.setMustInput(false);
            if (OperationStatus.ADDNEW.equals((Object)this.getPermOpStatus())) {
                this.getModel().setValue("ismplevelexchange", (Object)Boolean.FALSE);
            }
            if (HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                this.getModel().setValue("mplevelset", (Object)GradeRuleSrcEnum.SETTINGSELF.getValue());
            } else {
                this.getModel().setValue("mplevelset", null);
            }
            if (HRStringUtils.equals((String)GradeRuleSrcEnum.SETTINGSELF.getValue(), (String)String.valueOf(this.getModel().getValue("mplevelset")))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"sumperflevel"});
                BasedataEdit sumperlevel = (BasedataEdit)this.getControl("sumperflevel");
                sumperlevel.setMustInput(Boolean.TRUE.booleanValue());
                DynamicObject scoreSysDym = (DynamicObject)this.getModel().getValue("scoresystem");
                if (!HRObjectUtils.isEmpty((Object)scoreSysDym)) return;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"sumperflevel"});
            return;
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mpnumaccuracy"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"mpscaletype"});
            if (OperationStatus.ADDNEW.equals((Object)this.getPermOpStatus())) {
                this.getModel().setValue("ismpsopexchange", (Object)Boolean.FALSE);
            }
            if (OperationStatus.ADDNEW.equals((Object)this.getPermOpStatus())) {
                this.getModel().setValue("ismplevelexchange", (Object)Boolean.TRUE);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"scoresystem"});
            if (HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"mplevelset"});
                ComboEdit mplevelset = (ComboEdit)this.getControl("mplevelset");
                mplevelset.setMustInput(true);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"mplevelset"});
                ComboEdit mplevelset = (ComboEdit)this.getControl("mplevelset");
                mplevelset.setMustInput(false);
                this.getModel().setValue("mplevelset", (Object)GradeRuleSrcEnum.KEEPSAME.getValue());
            }
            if (OperationStatus.ADDNEW.equals((Object)this.getPermOpStatus())) {
                this.getModel().setValue("mplevelset", (Object)GradeRuleSrcEnum.KEEPSAME.getValue());
            }
            if (HRStringUtils.equals((String)"true", (String)String.valueOf(this.getModel().getValue("ismplevelexchange")))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"sumperflevel"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"sumperflevel"});
            }
            if (HRStringUtils.equals((String)GradeRuleSrcEnum.SETTINGSELF.getValue(), (String)String.valueOf(this.getModel().getValue("mplevelset")))) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"sumperflevel"});
            }
            if (!HRStringUtils.equals((String)GradeRuleSrcEnum.KEEPSAME.getValue(), (String)String.valueOf(this.getModel().getValue("mplevelset")))) return;
            this.getView().setVisible(Boolean.FALSE, new String[]{"sumperflevel"});
        }
    }
}

