/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.activity;

import java.util.ArrayList;
import java.util.Arrays;

public enum NodeToCheckBoxEnum {
    TARGET_FORMU_LATE(1L, "checkbox1"),
    EVAL_PROCESS(4L, "checkbox2"),
    PERF_SUM(5L, "checkbox3"),
    PERF_CALIBRATION(6L, "checkbox4"),
    PERF_INTERVIEW(7L, "checkbox6"),
    RESULT_CONFIRM(8L, "checkbox5");

    private final Long nodeId;
    private final String checkBoxKey;

    private NodeToCheckBoxEnum(Long nodeId, String checkBoxKey) {
        this.nodeId = nodeId;
        this.checkBoxKey = checkBoxKey;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public String getCheckBoxKey() {
        return this.checkBoxKey;
    }

    public static String[] getAllCheckBox() {
        ArrayList<String> allCheckBoxList = new ArrayList<String>(10);
        for (NodeToCheckBoxEnum nodeToCheckBoxEnum : NodeToCheckBoxEnum.values()) {
            allCheckBoxList.add(nodeToCheckBoxEnum.getCheckBoxKey());
        }
        return allCheckBoxList.toArray(new String[0]);
    }

    public static String[] getLessThanCheckBoxByNodeId(long nodeId) {
        ArrayList<String> allCheckBoxList = new ArrayList<String>(10);
        for (NodeToCheckBoxEnum nodeToCheckBoxEnum : NodeToCheckBoxEnum.values()) {
            if (nodeToCheckBoxEnum.getNodeId() > nodeId) continue;
            allCheckBoxList.add(nodeToCheckBoxEnum.getCheckBoxKey());
        }
        return allCheckBoxList.toArray(new String[0]);
    }

    public static String getCheckBoxKeyByNodeId(long nodeId) {
        NodeToCheckBoxEnum checkBoxEnum = Arrays.stream(NodeToCheckBoxEnum.values()).filter(nodeToCheckBoxEnum -> nodeToCheckBoxEnum.getNodeId() == nodeId).findFirst().orElse(null);
        return checkBoxEnum != null ? checkBoxEnum.getCheckBoxKey() : "";
    }

    public static NodeToCheckBoxEnum getNodeToCheckBoxEnumByCheckBoxKey(String checkBoxKey) {
        return Arrays.stream(NodeToCheckBoxEnum.values()).filter(nodeToCheckBoxEnums -> nodeToCheckBoxEnums.checkBoxKey.equals(checkBoxKey)).findFirst().orElse(null);
    }
}

