/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.assignindicator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;

public class AssignIndicatorWorkBenchPlugin
extends HRDynamicFormBasePlugin {
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final Log LOGGER = LogFactory.getLog(AssignIndicatorWorkBenchPlugin.class);
    private static final String ISSUCCESS = "issuccess";
    private static final String FAILUREREASON = "failurereason";
    private static final String IS_LOCKED = "isLocked";
    private static final String BAR_SUBMITBATCH = "bar_submitbatch";
    private static final String BAR_SUBMITONE = "bar_submitone";
    private static final String OPENVIEW = "openview";

    public void pageRelease(EventObject e) {
        String isLocked = this.getView().getPageCache().get(IS_LOCKED);
        if (!HRStringUtils.equals((String)"false", (String)isLocked)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object activityIdStr = formShowParameter.getCustomParam("activityId");
            MutexHelper.release((String)"epa_assindworkbench", (String)OPENVIEW, (String)(String.valueOf(activityIdStr) + RequestContext.get().getCurrUserId()));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMITONE, BAR_SUBMITBATCH});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object activityIdStr = formShowParameter.getCustomParam("activityId");
        MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(activityIdStr) + RequestContext.get().getCurrUserId(), null, null, "epa_assindworkbench", OPENVIEW, true, "default");
        StringBuilder msg = new StringBuilder();
        boolean require = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)msg);
        if (!require) {
            this.getView().getPageCache().put(IS_LOCKED, "false");
            this.getView().getParentView().showErrorNotification(msg.toString());
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
            return;
        }
        if (!ObjectUtils.isEmpty((Object)activityIdStr)) {
            long activityId = Long.parseLong(activityIdStr.toString());
            Object[] evalObjects = APP_SERVICE.queryEvaluationObjectOfAssigner(activityId);
            if (ObjectUtils.isEmpty((Object[])evalObjects)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u6682\u65f6\u6ca1\u6709\u6307\u6807\u5236\u5b9a\u5f85\u529e\u4efb\u52a1", (String)"AssignIndicatorWorkBenchPlugin_0", (String)"opmc-epa-opplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                this.getView().close();
                this.getView().sendFormAction(this.getView());
            } else if (evalObjects.length == 1) {
                this.showSingleIndicatorAssign((DynamicObject)evalObjects[0]);
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SUBMITONE});
            } else {
                this.showBatchIndicatorAssign((DynamicObject[])evalObjects, activityId);
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SUBMITBATCH});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"assindsubmit")) {
            Object memberValidateErrors;
            List<Long> objIdList = this.getEvalObjIdList();
            if (ObjectUtils.isEmpty(objIdList)) {
                return;
            }
            LOGGER.info("indicator submit objIdList:{}", (Object)SerializationUtils.toJsonString(objIdList));
            OperateOption option = OperateOption.create();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"assindsubmit", (String)"epa_actevalobj", (Object[])objIdList.toArray(new Long[0]), (OperateOption)option);
            List successPkIds = operationResult.getSuccessPkIds();
            this.getView().getPageCache().put("submitSuccessList", String.valueOf(SerializationUtils.toJsonString((Object)successPkIds)));
            LOGGER.info("indicator submit result:{}", (Object)operationResult.toString());
            HashMap<Long, StringBuilder> failMsgMap = new HashMap<Long, StringBuilder>(16);
            if (!operationResult.isSuccess() && !ObjectUtils.isEmpty((Object)(memberValidateErrors = operationResult.getValidateResult().getValidateErrors()))) {
                ValidateResult validateResult = (ValidateResult)memberValidateErrors.get(0);
                List allErrorInfo = validateResult.getAllErrorInfo();
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    String message = operateErrorInfo.getMessage();
                    Long pkValue = (Long)operateErrorInfo.getPkValue();
                    StringBuilder failMsg = failMsgMap.get(pkValue) == null ? new StringBuilder() : (StringBuilder)failMsgMap.get(pkValue);
                    failMsg.append(message).append(";").append("\n");
                    failMsgMap.put(pkValue, failMsg);
                }
            }
            for (StringBuilder value : failMsgMap.values()) {
                value.delete(value.length() - 1, value.length());
            }
            IFormView view = this.getSubView();
            if (StringUtils.equals((CharSequence)view.getFormShowParameter().getFormId(), (CharSequence)"epa_actevalobj_single")) {
                if (operationResult.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"AssignIndicatorWorkBenchPlugin_1", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMITONE});
                    view.setStatus(OperationStatus.VIEW);
                    view.updateView();
                    this.getView().sendFormAction(view);
                } else {
                    List memberValidateErrors2 = operationResult.getValidateResult().getValidateErrors();
                    if (!ObjectUtils.isEmpty((Object)memberValidateErrors2)) {
                        ValidateResult validateResult = (ValidateResult)memberValidateErrors2.get(0);
                        List allErrorInfo = validateResult.getAllErrorInfo();
                        for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                            this.getView().showTipNotification(ObjectUtils.isEmpty((Object)allErrorInfo) ? "" : operateErrorInfo.getMessage());
                        }
                    }
                }
                return;
            }
            this.showBatchSubmitOpDialog(objIdList, successPkIds, failMsgMap);
        }
    }

    private IFormView getSubView() {
        String subViewPageId = this.getView().getPageCache().get("subViewPageId");
        return this.getView().getView(subViewPageId);
    }

    private void showBatchSubmitOpDialog(List<Long> objIdList, List<Object> successPkIds, Map<Long, StringBuilder> failMsgMap) {
        List<Map<String, Object>> exportDataList = this.getExportData(objIdList, failMsgMap);
        List<HRExportHeadObject> headDataList = this.getExportHead();
        String allNumLbl = ResManager.loadKDString((String)"\u672c\u6b21\u5171\u4e3a{0}\u4eba\u63d0\u4ea4\u6307\u6807\uff0c\u5176\u4e2d", (String)"AssignIndicatorWorkBenchPlugin_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{objIdList.size()});
        String fitnumlbl = String.valueOf(successPkIds.size());
        String fitlbl = ResManager.loadKDString((String)"\u4eba\u7b26\u5408\u6761\u4ef6\uff0c\u5df2\u6210\u529f\u63d0\u4ea4", (String)"AssignIndicatorWorkBenchPlugin_3", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
        String nofitnumlbl = String.valueOf(objIdList.size() - successPkIds.size());
        String nofitlbl = ResManager.loadKDString((String)"\u4eba\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u63d0\u4ea4\u5931\u8d25", (String)"AssignIndicatorWorkBenchPlugin_4", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
        String finalbl = ResManager.loadKDString((String)"\u6ce8\uff1a\u8bf7\u5728\u5f15\u51fa\u7684excel\u4e2d\u67e5\u770b\u63d0\u4ea4\u7ed3\u679c\u8be6\u60c5", (String)"AssignIndicatorWorkBenchPlugin_5", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
        String excelName = ResManager.loadKDString((String)"\u6279\u91cf\u63d0\u4ea4\u7ed3\u679c", (String)"AssignIndicatorWorkBenchPlugin_6", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pbs_batchoptips");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("lbl_allnum", (Object)allNumLbl);
        formShowParameter.setCustomParam("lbl_fitnum", (Object)fitnumlbl);
        formShowParameter.setCustomParam("lbl_fit", (Object)fitlbl);
        formShowParameter.setCustomParam("lbl_nofitnum", (Object)nofitnumlbl);
        formShowParameter.setCustomParam("lbl_nofit", (Object)nofitlbl);
        formShowParameter.setCustomParam("lbl_final", (Object)finalbl);
        formShowParameter.setCustomParam("excelname", (Object)excelName);
        formShowParameter.setCustomParam("exportdatalist", exportDataList);
        formShowParameter.setCustomParam("headdatalist", headDataList);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6279\u91cf\u63d0\u4ea4\u7ed3\u679c", (String)"AssignIndicatorWorkBenchPlugin_6", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assindsubmit"));
        formShowParameter.setHasRight(true);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"assindsubmit")) {
            String successListStr = this.getView().getPageCache().get("submitSuccessList");
            if (StringUtils.isEmpty((CharSequence)successListStr)) {
                return;
            }
            List successList = (List)SerializationUtils.fromJsonString((String)successListStr, List.class);
            if (successList.size() == 0) {
                return;
            }
            List<Long> evalObjIdList = this.getEvalObjIdList();
            IFormView view = this.getSubView();
            if (successList.size() == evalObjIdList.size()) {
                view.getPageCache().put("isViewStatus", "true");
                view.setStatus(OperationStatus.VIEW);
                view.getFormShowParameter().setCustomParam("evalObjectIdList", evalObjIdList);
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SUBMITBATCH});
            } else {
                evalObjIdList.removeAll(successList);
                view.getFormShowParameter().setCustomParam("evalObjectIdList", evalObjIdList);
            }
            view.updateView();
            this.getView().sendFormAction(view);
        }
    }

    private List<Map<String, Object>> getExportData(List<Long> objIdList, Map<Long, StringBuilder> failMsgMap) {
        DynamicObject[] objects = APP_SERVICE.queryEvaluationObjectById(objIdList);
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(objIdList.size());
        String yes = ResManager.loadKDString((String)"\u662f", (String)"AssignIndicatorWorkBenchPlugin_7", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
        String no = ResManager.loadKDString((String)"\u5426", (String)"AssignIndicatorWorkBenchPlugin_8", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
        for (DynamicObject object : objects) {
            HashMap<String, Object> exportData = new HashMap<String, Object>(16);
            exportData.put("name", object.get("person.name"));
            exportData.put("number", object.get("person.number"));
            exportData.put("assgroup", this.getFiledLocaleValue(object, "assgroup.name"));
            exportData.put("affiliateadminorg", this.getFiledLocaleValue(object, "affiliateadminorg.name"));
            exportData.put("pmdperson", this.getFiledLocaleValue(object, "perffile.pmdperson.name"));
            exportData.put("activity", this.getFiledLocaleValue(object, "activity.name"));
            StringBuilder failMsgSb = failMsgMap.get(object.getLong("id"));
            String failMsg = failMsgSb == null ? "" : failMsgSb.toString();
            exportData.put(ISSUCCESS, HRStringUtils.isEmpty((String)failMsg) ? yes : no);
            exportData.put(FAILUREREASON, HRStringUtils.isEmpty((String)failMsg) ? "" : failMsg);
            exportDataList.add(exportData);
        }
        return exportDataList;
    }

    private List<HRExportHeadObject> getExportHead() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"AssignIndicatorWorkBenchPlugin_9", (String)"opmc-epa-opplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"AssignIndicatorWorkBenchPlugin_10", (String)"opmc-epa-opplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("assgroup", ResManager.loadKDString((String)"\u8003\u6838\u7ec4", (String)"AssignIndicatorWorkBenchPlugin_11", (String)"opmc-epa-opplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("affiliateadminorg", ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"AssignIndicatorWorkBenchPlugin_12", (String)"opmc-epa-opplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("pmdperson", ResManager.loadKDString((String)"\u7ee9\u6548\u4eba\u5458\u7ec4", (String)"AssignIndicatorWorkBenchPlugin_13", (String)"opmc-epa-opplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("activity", ResManager.loadKDString((String)"\u6240\u5c5e\u8003\u6838\u6d3b\u52a8", (String)"AssignIndicatorWorkBenchPlugin_14", (String)"opmc-epa-opplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject(ISSUCCESS, ResManager.loadKDString((String)"\u662f\u5426\u63d0\u4ea4\u6210\u529f", (String)"AssignIndicatorWorkBenchPlugin_15", (String)"opmc-epa-opplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject(FAILUREREASON, ResManager.loadKDString((String)"\u672a\u901a\u8fc7\u6821\u9a8c\u7684\u539f\u56e0", (String)"AssignIndicatorWorkBenchPlugin_16", (String)"opmc-epa-opplugin", (Object[])new Object[0])));
        return headDataList;
    }

    private String getFiledLocaleValue(DynamicObject object, String field) {
        ILocaleString localeString = object.getLocaleString(field);
        if (ObjectUtils.isEmpty((Object)localeString)) {
            return "";
        }
        return localeString.getLocaleValue();
    }

    private List<Long> getEvalObjIdList() {
        IFormView view = this.getSubView();
        List<Long> idList = new ArrayList<Long>(10);
        if (StringUtils.equals((CharSequence)view.getFormShowParameter().getFormId(), (CharSequence)"epa_assignind_batch")) {
            String evalObjectIdListStr = view.getPageCache().get("evalObjectIdList");
            if (!HRStringUtils.isEmpty((String)evalObjectIdListStr)) {
                idList = (List)SerializationUtils.fromJsonString((String)evalObjectIdListStr, List.class);
            }
        } else if (StringUtils.equals((CharSequence)view.getFormShowParameter().getFormId(), (CharSequence)"epa_actevalobj_single")) {
            long evalObjId = view.getModel().getDataEntity().getLong("id");
            idList = Collections.singletonList(evalObjId);
        }
        return idList;
    }

    private void showBatchIndicatorAssign(DynamicObject[] evalObjects, long activityId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setFormId("epa_assignind_batch");
        showParameter.setCustomParam("activityId", (Object)activityId);
        List evalObjectIdList = Arrays.stream(evalObjects).map(evalObject -> evalObject.getLong("id")).collect(Collectors.toList());
        showParameter.setCustomParam("evalObjectIdList", evalObjectIdList);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("assindworkbenchap");
        this.getView().showForm(showParameter);
        this.getView().getPageCache().put("subViewPageId", showParameter.getPageId());
    }

    private void showSingleIndicatorAssign(DynamicObject evalObject) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setFormId("epa_actevalobj_single");
        showParameter.setPkId(evalObject.getPkValue());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("assindworkbenchap");
        this.getView().showForm((FormShowParameter)showParameter);
        this.getView().getPageCache().put("subViewPageId", showParameter.getPageId());
    }
}

