/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.assignindicator;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.formplugin.web.activity.AssessActivityConfEdit;

public class EvaluationObjectAssTableEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(AssessActivityConfEdit.class);
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showAssTableView();
    }

    private boolean getActivityAssTableRequire() {
        DynamicObjectCollection activityAssGroups = this.getModel().getDataEntity().getDynamicObject("activity").getDynamicObjectCollection("assgroupentry");
        DynamicObject activityAssGroup = activityAssGroups.stream().filter(assGroup -> assGroup.getDynamicObject("assgroup").getLong("id") == this.getModel().getDataEntity().getDynamicObject("assgroup").getLong("id")).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)activityAssGroup)) {
            return activityAssGroup.getBoolean("isasstablerequire");
        }
        return false;
    }

    private void showAssTableView() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        long ruleId = billObj.getLong("activity.rule.id");
        DynamicObject ruleDy = APP_SERVICE.queryAssessRule(ruleId);
        DynamicObjectCollection areaEntry = billObj.getDynamicObjectCollection("areaentry");
        FlexPanelAp assTableFlex = new HRFlexPanelAp.Builder("asstableflex").setDirection("column").setAlignItems("stretch").setJustifyContent("flex-start").setWrap(false).setGrow(0).setShrink(1).build();
        for (int i = 0; i < areaEntry.size(); ++i) {
            String assTableItem = "asstableitemflex" + i;
            FlexPanelAp tableItemAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(assTableItem).setMarginBottom("10px")).build();
            if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getFormId(), (String)"epa_actevalobj_asstable")) {
                Style style = tableItemAp.getStyle();
                style = style == null ? new Style() : style;
                Border border = new Border();
                border.setLeft("1px_solid_#D9D9D9");
                border.setTop("1px_solid_#D9D9D9");
                border.setRight("1px_solid_#D9D9D9");
                border.setBottom("1px_solid_#D9D9D9");
                style.setBorder(border);
                tableItemAp.setStyle(style);
            }
            assTableFlex.getItems().add(tableItemAp);
            Long confId = ((DynamicObject)areaEntry.get(i)).getLong("areaconf");
            Long areaInstanceId = ((DynamicObject)areaEntry.get(i)).getLong("areains");
            DynamicObject areaReg = ((DynamicObject)areaEntry.get(i)).getDynamicObject("areareg");
            Long areaRegId = areaReg.getLong("id");
            String pageId = AreaRegEnum.get((Long)areaRegId).getEvalObjAreaPageIdOfAssign();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId(pageId);
            showParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            showParameter.setPkId((Object)areaInstanceId);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(assTableItem);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, pageId));
            showParameter.setCustomParam("confid", (Object)confId);
            showParameter.setCustomParam("isasstablerequire", (Object)this.getActivityAssTableRequire());
            showParameter.setCustomParam("scorecalcway", (Object)ruleDy.getString("scorecalcway"));
            showParameter.setCustomParam("evalway", (Object)ruleDy.getString("evalway"));
            showParameter.setCustomParam("numaccuracy", (Object)ruleDy.getString("numaccuracy"));
            showParameter.setCustomParam("scoresystem", (Object)ruleDy.getDynamicObject("scoresystem").getLong("id"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
        this.getView().updateControlMetadata(assTableFlex.getKey(), assTableFlex.createControl());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Boolean isCommonEvaluationObjectAssignIndicator;
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"save") && !ObjectUtils.isEmpty((Object)(isCommonEvaluationObjectAssignIndicator = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCommonEvaluationObjectAssignIndicator"))) && isCommonEvaluationObjectAssignIndicator.booleanValue()) {
            long currentPkId = this.getModel().getDataEntity().getLong("id");
            List copyObjIdList = null;
            CardEntry assGroupCard = (CardEntry)this.getView().getParentView().getControl("assgroupentry");
            int[] selectRows = assGroupCard.getSelectRows();
            if (selectRows != null && selectRows.length == 1) {
                DynamicObjectCollection assGroupEntry = this.getView().getParentView().getModel().getEntryEntity("assgroupentry");
                DynamicObject assGroupInfo = (DynamicObject)assGroupEntry.get(selectRows[0]);
                DynamicObjectCollection commonObjColl = assGroupInfo.getDynamicObjectCollection("comindevalobj");
                copyObjIdList = commonObjColl.stream().map(commonObj -> commonObj.getDynamicObject("fbasedataid").getLong("id")).filter(objId -> !objId.equals(currentPkId)).collect(Collectors.toList());
            }
            if (!ObjectUtils.isEmpty(copyObjIdList)) {
                APP_SERVICE.copyAssessTableInfoOfCommon(currentPkId, copyObjIdList);
            }
        }
    }
}

