/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.assignindicator.area;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;

public class AssignIndicatorGenAreaIndReqEdit
extends HRDataBaseEdit {
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long instanceId = (Long)parameter.getCustomParam("instanceid");
        this.getModel().setValue("instanceid", (Object)instanceId);
        Integer indReqSize = null == parameter.getCustomParam("indReqSize") ? Integer.valueOf(0) : (Integer)parameter.getCustomParam("indReqSize");
        this.getModel().setValue("entryseq", (Object)indReqSize);
        Boolean isAllowEval = (Boolean)parameter.getCustomParam("isAllowEval");
        this.getView().setVisible(isAllowEval, new String[]{"score"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (!HRStringUtils.equals((String)"save", (String)operateKey)) {
            return;
        }
        DynamicObject indicatorType = this.getModel().getDataEntity().getDynamicObject("indicatortype");
        Long instanceId = (Long)this.getModel().getValue("instanceid");
        String validateMsg = APP_SERVICE.validateAssessTableIndicatorReq(instanceId, indicatorType);
        if (!HRStringUtils.isEmpty((String)validateMsg)) {
            this.getView().showErrorNotification(validateMsg);
            args.setCancel(true);
        }
        this.validateScore(args);
    }

    private void validateScore(BeforeDoOperationEventArgs args) {
        String maxScoreOfSystemStr = this.getView().getParentView().getPageCache().get("maxScoreOfSystem");
        BigDecimal areaScore = null;
        BigDecimal maxScoreOfSystem = new BigDecimal(maxScoreOfSystemStr);
        DynamicObjectCollection indicatorEntry = new DynamicObjectCollection();
        if (!HRStringUtils.isEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("isUnitTest")))) {
            areaScore = new BigDecimal("50");
        } else {
            areaScore = (BigDecimal)this.getView().getParentView().getModel().getValue("areascore");
            indicatorEntry = this.getView().getParentView().getModel().getEntryEntity("indreqentity");
        }
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        BigDecimal currentSum = indicatorEntry.stream().filter(Objects::nonNull).filter(indicator -> !indicator.getPkValue().equals(pkValue)).map(indicator -> indicator.getBigDecimal("score")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal indicatorScore = (BigDecimal)this.getModel().getValue("score");
        if (currentSum.add(indicatorScore).compareTo(areaScore) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u6307\u6807\u7c7b\u578b\u5206\u503c\u4e0d\u80fd\u8d85\u8fc7\u533a\u57df\u5206\u503c", (String)"AssignIndicatorGenAreaIndReqEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            this.validateMaxScoreSystem(args, maxScoreOfSystem, currentSum, indicatorScore);
        }
    }

    private void validateMaxScoreSystem(BeforeDoOperationEventArgs args, BigDecimal maxScoreOfSystem, BigDecimal currentSum, BigDecimal indicatorScore) {
        if (currentSum.add(indicatorScore).compareTo(maxScoreOfSystem) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u6307\u6807\u7c7b\u578b\u5206\u503c\u4e0d\u80fd\u8d85\u8fc7\u5206\u5236\u6700\u9ad8\u57fa\u51c6\u5206{0}", (String)"AssignIndicatorGenAreaIndReqEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{maxScoreOfSystem}));
        }
    }
}

