/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.assignindicator.area;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.utils.NumberValidateUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.constants.AssessTableConfConstants;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.assessrule.AdjustTypeEnum;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;

public class AssignIndicatorGenAreaIndicatorEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(AssignIndicatorGenAreaIndicatorEdit.class);
    private final AssessActivityApplicationService service = AssessActivityApplicationService.getInstance();
    private final ActEvalObjManageDomainService ACTEVALOBJMANAGE_DOMAIN_SERVICE = ActEvalObjManageDomainService.getInstance();
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final ObjGenAreaInsEntityService OBJ_GEN_AREA_INS_ENTITY_SERVICE = ObjGenAreaInsEntityService.getInstance();
    private final Set<String> validateNumberFiled = Sets.newHashSet((Object[])new String[]{"qualitytarget", "qualitydare", "qualitybase", "qualityres"});
    private static final String MUST_INPUT = "mustinput";
    private static final String[] TEXTS = new String[]{"indctrname", "qualitytarget", "unit", "indctrnumber", "indctrsource", "customfiled1", "customfiled2"};
    private static final String[] BIGTEXTS = new String[]{"evaldesc"};
    private static final String[] MULLINE_TEXTS = new String[]{"indctrdesc", "evalcriteria", "remarks", "finishdesc", "customfiled3", "customfiled4", "customfiled5"};

    public AssignIndicatorGenAreaIndicatorEdit() {
        NumberValidateUtils.removeNotValidateField(this.validateNumberFiled);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryNormalConfigByPk(confId);
        List fieldEntryEvaDtos = (List)formShowParameter.getCustomParam("fieldEntryEvaDtoList");
        Object evaSumLimitObj = formShowParameter.getCustomParam("evasumlimit");
        String evaSumLimit = EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue();
        if (evaSumLimitObj instanceof String) {
            evaSumLimit = (String)evaSumLimitObj;
        }
        if (EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
            if (ObjectUtils.isEmpty((Object)fieldEntryEvaDtos)) {
                DrawAreaUtils.drawGenIndicatorField(args, conf, AssessTableConfConstants.GEN_IGNORE_FIELD, true);
            } else {
                DrawAreaUtils.drawGenIndicatorField(args, conf, new String[0], AssessRuleConstants.NORM_INDCTR_AREA_PK, fieldEntryEvaDtos, true);
            }
        } else if (ObjectUtils.isEmpty((Object)fieldEntryEvaDtos)) {
            DrawAreaUtils.drawIndicatorField(args, conf, AssessTableConfConstants.GEN_IGNORE_FIELD);
        } else {
            DrawAreaUtils.drawIndicatorField(args, conf, new String[0], AssessRuleConstants.NORM_INDCTR_AREA_PK, fieldEntryEvaDtos);
        }
    }

    private boolean isInIgnore(String[] ignores, String fieldKey) {
        for (String str : ignores) {
            if (HRStringUtils.isEmpty((String)fieldKey) || !HRStringUtils.equals((String)str, (String)fieldKey)) continue;
            return true;
        }
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        if (status != OperationStatus.ADDNEW) {
            return;
        }
        this.getModel().setValue("instanceid", parameter.getCustomParam("instanceid"));
        Integer indReqSize = null == parameter.getCustomParam("indReqSize") ? Integer.valueOf(0) : (Integer)parameter.getCustomParam("indReqSize");
        this.getModel().setValue("entryseq", (Object)(indReqSize + 1));
        this.getModel().setValue("evaltype", (Object)"10");
    }

    public void afterBindData(EventObject e) {
        List fieldEntryEvaDtos;
        super.afterBindData(e);
        this.initTips();
        this.initMustInputField();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryNormalConfigByPk(confId);
        this.setTitleText(conf);
        this.setLableOfCompleteProgersss();
        boolean isAllowEval = conf.getBoolean("reversepoints");
        this.getView().setVisible(Boolean.valueOf(isAllowEval), new String[]{"scoreconfap"});
        if (isAllowEval) {
            if (HRStringUtils.equals((String)conf.getString("adjusttype"), (String)AdjustTypeEnum.NORMAL.getValue())) {
                this.getModel().setValue("minevalscore", (Object)conf.getBigDecimal("lowerscore"));
                this.getModel().setValue("maxevalscore", (Object)conf.getBigDecimal("upperscore"));
                this.getView().setEnable(Boolean.FALSE, new String[]{"minevalscore", "maxevalscore"});
            } else {
                DecimalEdit minevalscore = (DecimalEdit)this.getControl("minevalscore");
                minevalscore.setMustInput(true);
                DecimalEdit maxevalscore = (DecimalEdit)this.getControl("maxevalscore");
                maxevalscore.setMustInput(true);
            }
        }
        this.getModel().setDataChanged(false);
        String from = (String)this.getView().getFormShowParameter().getCustomParam("from");
        if ("epa_tobetargetformulate".equals(from)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"indctrname"});
        }
        if (!ObjectUtils.isEmpty((Object)(fieldEntryEvaDtos = (List)formShowParameter.getCustomParam("fieldEntryEvaDtoList")))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"iseditable"});
        }
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        HashSet<String> mustInputs = new HashSet<String>(16);
        for (Object fieldInfo : entryEntity) {
            DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
            LOG.info("AssignIndicatorGenAreaIndicatorEdit.afterBindData areaField :{}", (Object)areaField);
            if (!areaField.getBoolean("ismustinput")) continue;
            String fieldKey = fieldInfo.getString("areafield.number");
            LOG.info("AssignIndicatorGenAreaIndicatorEdit.afterBindData fieldKey :{},ignore: {}", (Object)fieldKey, (Object)AssessTableConfConstants.GEN_IGNORE_FIELD);
            if (this.isInIgnore(AssessTableConfConstants.GEN_IGNORE_FIELD, fieldKey)) continue;
            mustInputs.add(fieldKey);
        }
        StringBuffer mustInputsb = new StringBuffer();
        for (String must : mustInputs) {
            mustInputsb.append(must);
            mustInputsb.append(",");
        }
        String mustInputstr = mustInputsb.substring(0, mustInputsb.length() - 1);
        this.getPageCache().put(MUST_INPUT, mustInputstr);
        this.setControlScale();
        LOG.info("AssignIndicatorGenAreaIndicatorEdit.afterBindData mustInputs : {}", mustInputs);
    }

    private void setLableOfCompleteProgersss() {
        String tips;
        String progress;
        DynamicObjectCollection entryentity = this.getView().getParentView().getModel().getEntryEntity("entryentity");
        String scoreCalcWay = this.getView().getParentView().getPageCache().get("scorecalcway");
        BigDecimal currentSum = BigDecimal.ZERO;
        BigDecimal areaWeight = BigDecimal.ZERO;
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            currentSum = entryentity.stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal("weight")).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentSum = currentSum.subtract((BigDecimal)this.getView().getModel().getValue("weight"));
            areaWeight = (BigDecimal)this.getView().getParentView().getModel().getValue("areaweight");
            progress = currentSum.stripTrailingZeros().toPlainString() + "/" + areaWeight.stripTrailingZeros().toPlainString();
            tips = ResManager.loadKDString((String)"\u3010{0}\u3011\u663e\u793a\u533a\u57df\u7d2f\u8ba1\u6743\u91cd/\u533a\u57df\u603b\u6743\u91cd\uff0c\u4e0d\u542b\u5f53\u524d\u65b0\u589e\u6216\u7f16\u8f91\u7684\u6307\u6807", (String)"AssignIndicatorGenAreaIndicatorEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{progress});
        } else {
            currentSum = entryentity.stream().filter(Objects::nonNull).map(indicator -> indicator.getBigDecimal("indctrscore")).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentSum = currentSum.subtract((BigDecimal)this.getView().getModel().getValue("indctrscore"));
            areaWeight = (BigDecimal)this.getView().getParentView().getModel().getValue("areascore");
            progress = currentSum.stripTrailingZeros().toPlainString() + "/" + areaWeight.stripTrailingZeros().toPlainString();
            tips = ResManager.loadKDString((String)"\u3010{0}\u3011\u533a\u57df\u7d2f\u8ba1\u5206\u503c/\u533a\u57df\u603b\u5206\u503c\uff0c\u4e0d\u542b\u5f53\u524d\u65b0\u589e\u6216\u7f16\u8f91\u7684\u6307\u6807", (String)"AssignIndicatorGenAreaIndicatorEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{progress});
        }
        Label titleLabel = (Label)this.getControl("completelable");
        titleLabel.setText(tips);
    }

    private void setControlScale() {
        this.getView().updateControlMetadata("areascore", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
        this.getView().updateControlMetadata("maxevalscore", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
        this.getView().updateControlMetadata("minevalscore", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
        this.getView().updateControlMetadata("weight", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
    }

    private void setTitleText(DynamicObject conf) {
        String cusName = conf.getString("areacustname");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String title = ResManager.loadKDString((String)"\u7f16\u8f91{0}\u6307\u6807", (String)"AssignIndicatorAreaInstanceEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{cusName});
        if (HRObjectUtils.equals((Object)status, (Object)OperationStatus.ADDNEW)) {
            title = ResManager.loadKDString((String)"\u6dfb\u52a0{0}\u6307\u6807", (String)"AssignIndicatorAreaInstanceEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{cusName});
        } else if (HRObjectUtils.equals((Object)status, (Object)OperationStatus.VIEW)) {
            title = ResManager.loadKDString((String)"\u67e5\u770b{0}\u6307\u6807", (String)"AssignIndicatorAreaInstanceEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{cusName});
        }
        String from = (String)this.getView().getFormShowParameter().getCustomParam("from");
        if ("epa_tobetargetformulate".equals(from)) {
            title = ResManager.loadKDString((String)"\u7f16\u8f91{0}\u6307\u6807", (String)"AssignIndicatorAreaInstanceEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{cusName});
        }
        Label titleLabel = (Label)this.getControl("titlelabel");
        titleLabel.setText(title);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String value;
        String evalType;
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"minevalscore")) {
            this.checkLowerScoreValue();
        } else if (HRStringUtils.equals((String)name, (String)"maxevalscore")) {
            this.checkUpperScoreValue();
        } else if (this.validateNumberFiled.contains(name) && HRStringUtils.equals((String)(evalType = (String)this.getModel().getValue("evaltype")), (String)"20") && !ObjectUtils.isEmpty((Object)(value = (String)this.getModel().getValue(name))) && !DrawAreaUtils.validateNumber(value)) {
            String displayName = this.getModel().getProperty(name).getDisplayName().getLocaleValue();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"[{0}]\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u3002", (String)"AssignIndicatorAreaInstanceEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{displayName}));
        }
    }

    private DynamicObject getScoreSystem() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long scoreSystemId = (Long)formShowParameter.getCustomParam("scoresystem");
        return this.service.queryScoreSystemById(scoreSystemId);
    }

    private boolean checkUpperScoreValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryNormalConfigByPk(confId);
        if (HRStringUtils.equals((String)conf.getString("adjusttype"), (String)AdjustTypeEnum.CUSTOM.getValue())) {
            BigDecimal maxScore = this.getScoreSystem().getBigDecimal("maxscore");
            BigDecimal minScore = this.getScoreSystem().getBigDecimal("minscore");
            BigDecimal lowerScore = this.getView().getModel().getDataEntity().getBigDecimal("minevalscore");
            BigDecimal upperScore = this.getView().getModel().getDataEntity().getBigDecimal("maxevalscore");
            if (HRObjectUtils.isEmpty((Object)upperScore)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"AssignIndicatorGenAreaIndicatorEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (HRObjectUtils.isEmpty((Object)lowerScore)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"AssignIndicatorGenAreaIndicatorEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (upperScore.compareTo(maxScore) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u9700\u2264\u8bc4\u5206\u5206\u5236\u6700\u9ad8\u5206", (String)"AssignIndicatorGenAreaIndicatorEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (upperScore.compareTo(lowerScore) <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u9700\uff1e\u8c03\u6574\u5206\u4e0b\u9650", (String)"AssignIndicatorGenAreaIndicatorEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private boolean checkLowerScoreValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryNormalConfigByPk(confId);
        if (HRStringUtils.equals((String)conf.getString("adjusttype"), (String)AdjustTypeEnum.CUSTOM.getValue())) {
            BigDecimal maxScore = this.getScoreSystem().getBigDecimal("maxscore");
            BigDecimal minScore = this.getScoreSystem().getBigDecimal("minscore");
            BigDecimal lowerScore = this.getView().getModel().getDataEntity().getBigDecimal("minevalscore");
            BigDecimal upperScore = this.getView().getModel().getDataEntity().getBigDecimal("maxevalscore");
            if (HRObjectUtils.isEmpty((Object)upperScore)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"AssignIndicatorGenAreaIndicatorEdit_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (HRObjectUtils.isEmpty((Object)lowerScore)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"AssignIndicatorGenAreaIndicatorEdit_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (maxScore.compareTo(new BigDecimal(0)) >= 0) {
                if (lowerScore.compareTo(maxScore.negate()) < 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u9700\u2265\u8bc4\u5206\u5206\u5236\u6700\u9ad8\u5206\u7684\u76f8\u53cd\u6570\u3002", (String)"AssignIndicatorGenAreaIndicatorEdit_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    return true;
                }
            } else {
                if (lowerScore.compareTo(maxScore) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u9700\u2264\u8bc4\u5206\u5206\u5236\u6700\u9ad8\u5206\u3002", (String)"AssignIndicatorGenAreaIndicatorEdit_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    return true;
                }
                if (lowerScore.compareTo(minScore) < 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u9700\u2265\u8bc4\u5206\u5206\u5236\u6700\u4f4e\u5206", (String)"AssignIndicatorGenAreaIndicatorEdit_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    return true;
                }
            }
            if (lowerScore.compareTo(upperScore) >= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u9700<\u8c03\u6574\u5206\u4e0a\u9650", (String)"AssignIndicatorGenAreaIndicatorEdit_19", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void initMustInputField() {
        String scoreCalcWay = this.getView().getParentView().getPageCache().get("scorecalcway");
        TextEdit name = (TextEdit)this.getControl("indctrname");
        name.setMustInput(true);
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            TextEdit weight = (TextEdit)this.getControl("weight");
            weight.setMustInput(true);
        } else {
            TextEdit score = (TextEdit)this.getControl("indctrscore");
            score.setMustInput(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            String[] mustInputs;
            this.checkObjStatus(args);
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            if (this.checkUpperScoreValue()) {
                args.setCancel(true);
                return;
            }
            if (this.checkLowerScoreValue()) {
                args.setCancel(true);
                return;
            }
            String mustInputstr = this.getPageCache().get(MUST_INPUT);
            for (String fieldKey : mustInputs = mustInputstr.split(",")) {
                String valueStr;
                Object value = dataEntity.get(fieldKey);
                LOG.info("AssignIndicatorGenAreaIndicatorEdit.beforeDoOperation: fieldKey: {},value: {}", (Object)fieldKey, value);
                if (value == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"AssignIndicatorAreaInstanceEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (value instanceof OrmLocaleValue) {
                    OrmLocaleValue ormLocaleValue = (OrmLocaleValue)value;
                    boolean isEmpty = true;
                    Collection values = ormLocaleValue.values();
                    for (String ormLocaleValueStr : values) {
                        if (HRStringUtils.isEmpty((String)ormLocaleValueStr)) continue;
                        isEmpty = false;
                        break;
                    }
                    if (isEmpty) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"AssignIndicatorAreaInstanceEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                if (!(value instanceof String) || !HRStringUtils.isEmpty((String)(valueStr = (String)value))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"AssignIndicatorAreaInstanceEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            IFormView objGenInstView = this.getView().getParentView();
            DynamicObject pDataEntity = objGenInstView.getModel().getDataEntity(true);
            Long cId = dataEntity.getLong("id");
            String nameOri = dataEntity.getString("indctrname");
            String name = "";
            if (!HRStringUtils.isEmpty((String)nameOri)) {
                name = nameOri.trim();
            }
            if (!name.equals(nameOri)) {
                this.getModel().setValue("indctrname", (Object)name);
            }
            if (HRStringUtils.isEmpty((String)name)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssignIndicatorAreaInstanceEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dynamicObject1 = APP_SERVICE.getObjGenareaIns(Long.valueOf(pDataEntity.getLong("id")));
            DynamicObjectCollection entryentity = dynamicObject1.getDynamicObjectCollection("entryentity");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String currentNodeStr = (String)formShowParameter.getCustomParam("currentNodeId");
            Long nodeId = 0L;
            Integer index = 0;
            if (!HRStringUtils.isEmpty((String)currentNodeStr)) {
                nodeId = Long.parseLong(currentNodeStr);
                index = this.ACTEVALOBJMANAGE_DOMAIN_SERVICE.getIndexByNodeId(nodeId);
            }
            DynamicObjectCollection entryentityNew = new DynamicObjectCollection();
            for (DynamicObject dynamicObject : entryentity) {
                if (dynamicObject.getInt("addnodeindex") > index) continue;
                entryentityNew.add((Object)dynamicObject);
            }
            for (DynamicObject dynamicObject : entryentityNew) {
                if (cId.equals(0L)) {
                    if (!name.equals(dynamicObject.getString("indctrname"))) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u5df2\u6709\u201c{0}\u201d\u76f8\u540c\u7684\u6307\u6807\uff0c\u4e0d\u80fd\u6dfb\u52a0/\u7f16\u8f91\u3002", (String)"AssignIndicatorAreaInstanceEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{name}));
                    args.setCancel(true);
                    return;
                }
                if (cId.equals((Long)dynamicObject.getPkValue()) || !name.equals(dynamicObject.getString("indctrname"))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u5df2\u6709\u201c{0}\u201d\u76f8\u540c\u7684\u6307\u6807\uff0c\u4e0d\u80fd\u6dfb\u52a0/\u7f16\u8f91\u3002", (String)"AssignIndicatorAreaInstanceEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{name}));
                args.setCancel(true);
                return;
            }
            String scoreCalcWay = this.getView().getParentView().getPageCache().get("scorecalcway");
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                this.validateWeight(args);
            } else {
                this.validateScore(args);
            }
            if (!NumberValidateUtils.opValidate((IFormView)this.getView(), this.validateNumberFiled)) {
                args.setCancel(true);
            }
            if (!args.cancel) {
                IDataModel model = this.getModel();
                model.setValue("flowrutask", formShowParameter.getCustomParam("taskId"));
                model.setValue("flowrunode", formShowParameter.getCustomParam("currentNodeId"));
                if (index != null && index != 0) {
                    model.setValue("addnodeindex", (Object)index);
                }
                model.setValue("realweight", model.getValue("weight"));
            }
        }
    }

    private void checkObjStatus(BeforeDoOperationEventArgs args) {
        DynamicObject dynamicObject;
        String nodeStatus;
        Long objId;
        DynamicObject[] dynamicObjects;
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        if (taskId == null && (dynamicObjects = this.ACTEVALOBJMANAGE_DOMAIN_SERVICE.queryActEvalObjByIds(Collections.singletonList(objId = (Long)this.getView().getFormShowParameter().getCustomParam("obj_id")))) != null && dynamicObjects.length > 0 && HRStringUtils.equals((String)(nodeStatus = (dynamicObject = dynamicObjects[0]).getString("nodestatus")), (String)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus())) {
            args.setCancel(true);
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u53ef\u6dfb\u52a0\u6307\u6807", (String)"AssignIndicatorAreaInstanceEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u53ef\u7f16\u8f91\u6307\u6807", (String)"AssignIndicatorAreaInstanceEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateMaxWeight(BeforeDoOperationEventArgs args, BigDecimal maxWeight, BigDecimal currentSum, BigDecimal indicatorWeight) {
        String limitMaxRatioStr;
        Object evaSumLimitObj = this.getView().getFormShowParameter().getCustomParam("evasumlimit");
        Object limitMaxRatioObj = this.getView().getFormShowParameter().getCustomParam("limitmaxratio");
        Object numAccuracyObj = this.getView().getFormShowParameter().getCustomParam("numaccuracy");
        String evaSumLimit = "";
        BigDecimal limitMaxRatioBD = new BigDecimal(100);
        Integer numAccuracy = 0;
        if (evaSumLimitObj instanceof String) {
            evaSumLimit = (String)evaSumLimitObj;
        }
        if (limitMaxRatioObj instanceof String && (limitMaxRatioStr = (String)limitMaxRatioObj) != "") {
            limitMaxRatioBD = new BigDecimal(limitMaxRatioStr);
        }
        if (numAccuracyObj instanceof Integer) {
            numAccuracy = (Integer)numAccuracyObj;
        }
        if (EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit) && currentSum.add(indicatorWeight).compareTo(limitMaxRatioBD) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u6743\u91cd\u4e4b\u548c\u5df2\u8d85\u8fc7\u201c\u8bc4\u4f30\u8868\u5355\u5236\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d{0}", (String)"AssignIndicatorAreaInstanceEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[]{limitMaxRatioBD.setScale(numAccuracy)}));
        }
        if (!EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit) && currentSum.add(indicatorWeight).compareTo(maxWeight) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u6743\u91cd\u4e4b\u548c\u5df2\u8d85\u8fc7100%\u3002", (String)"AssignIndicatorAreaInstanceEdit_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateWeight(BeforeDoOperationEventArgs args) {
        BigDecimal allWeight = new BigDecimal(100);
        BigDecimal areaWeight = (BigDecimal)this.getView().getParentView().getModel().getValue("areaweight");
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity();
        DynamicObject objGenAreaIns = APP_SERVICE.loadObjGenAreaIns((Object)dataEntity.getLong("id"));
        DynamicObjectCollection indicatorEntry = objGenAreaIns.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection indicatorEntryNew = new DynamicObjectCollection();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long nodeId = 0L;
        if (!HRStringUtils.isEmpty((String)((String)formShowParameter.getCustomParam("currentNodeId")))) {
            nodeId = Long.parseLong((String)formShowParameter.getCustomParam("currentNodeId"));
        }
        int index = this.ACTEVALOBJMANAGE_DOMAIN_SERVICE.getIndexByNodeId(nodeId);
        for (DynamicObject entry : indicatorEntry) {
            if (entry.getInt("addnodeindex") > index) continue;
            indicatorEntryNew.add((Object)entry);
        }
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        BigDecimal currentSum = indicatorEntryNew.stream().filter(Objects::nonNull).filter(indicator -> !indicator.getPkValue().equals(pkValue)).map(indicator -> indicator.getBigDecimal("weight")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal indicatorWeight = (BigDecimal)this.getModel().getValue("weight");
        if (areaWeight == null) {
            this.validateMaxWeight(args, allWeight, currentSum, indicatorWeight);
        } else if (currentSum.add(indicatorWeight).compareTo(areaWeight) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u6743\u91cd\u4e4b\u548c\u5df2\u8d85\u8fc7\u533a\u57df\u6743\u91cd\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AssignIndicatorAreaInstanceEdit_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            this.validateMaxWeight(args, allWeight, currentSum, indicatorWeight);
        }
        if (indicatorWeight.compareTo(new BigDecimal(0)) < 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u91cd\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"AssignIndicatorAreaInstanceEdit_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateScore(BeforeDoOperationEventArgs args) {
        String maxScoreOfSystemStr = this.getView().getParentView().getPageCache().get("maxScoreOfSystem");
        BigDecimal maxScoreOfSystem = new BigDecimal(maxScoreOfSystemStr);
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity();
        BigDecimal areaScore = (BigDecimal)this.getView().getParentView().getModel().getValue("areascore");
        DynamicObject objGenAreaIns = APP_SERVICE.loadObjGenAreaIns((Object)dataEntity.getLong("id"));
        DynamicObjectCollection indicatorEntry = objGenAreaIns.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection indicatorEntryNew = new DynamicObjectCollection();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long nodeId = 0L;
        if (!HRStringUtils.isEmpty((String)((String)formShowParameter.getCustomParam("currentNodeId")))) {
            nodeId = Long.parseLong((String)formShowParameter.getCustomParam("currentNodeId"));
        }
        int index = this.ACTEVALOBJMANAGE_DOMAIN_SERVICE.getIndexByNodeId(nodeId);
        for (DynamicObject entry : indicatorEntry) {
            if (entry.getInt("addnodeindex") > index) continue;
            indicatorEntryNew.add((Object)entry);
        }
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        BigDecimal currentSum = indicatorEntryNew.stream().filter(Objects::nonNull).filter(indicator -> !indicator.getPkValue().equals(pkValue)).map(indicator -> indicator.getBigDecimal("indctrscore")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal indicatorScore = (BigDecimal)this.getModel().getValue("indctrscore");
        if (areaScore == null) {
            this.validateMaxScoreSystem(args, maxScoreOfSystem, currentSum, indicatorScore);
        } else if (currentSum.add(indicatorScore).compareTo(areaScore) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u5206\u503c\u4e4b\u548c\u5df2\u8d85\u8fc7\u533a\u57df\u5206\u503c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AssignIndicatorAreaInstanceEdit_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            this.validateMaxScoreSystem(args, maxScoreOfSystem, currentSum, indicatorScore);
        }
        BigDecimal indctrScore = (BigDecimal)this.getModel().getValue("indctrscore");
        if (indctrScore.compareTo(new BigDecimal(0)) < 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"AssignIndicatorAreaInstanceEdit_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateMaxScoreSystem(BeforeDoOperationEventArgs args, BigDecimal maxScoreOfSystem, BigDecimal currentSum, BigDecimal indicatorScore) {
        if (currentSum.add(indicatorScore).compareTo(maxScoreOfSystem) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u5206\u503c\u4e4b\u548c\u5df2\u8d85\u8fc7\u5206\u5236\u6700\u9ad8\u57fa\u51c6\u5206{0}\u3002", (String)"AssignIndicatorAreaInstanceEdit_19", (String)"opmc-epa-formplugin", (Object[])new Object[]{maxScoreOfSystem}));
        }
    }

    private void initTips() {
        this.setTips("scoretips3");
        this.setTips("iseditable");
    }

    private void setTips(String key) {
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = this.service.getTips("epa_genareaindicator", key, dy);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipContent));
            props.put("tips", tips);
            this.getView().updateControlMetadata(key, props);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"save")) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long objId = (Long)formShowParameter.getCustomParam("obj_id");
            APP_SERVICE.updateWeightAndIndctrScore(objId);
            this.getView().getParentView().getParentView().invokeOperation("save");
            this.getView().returnDataToParent(this.getModel().getDataEntity().getPkValue());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dyc = this.getModel().getDataEntity(true);
        DynamicProperty flowRunProp = dyc.getDynamicObjectType().getProperty("flowrunode");
        dyc.getDataEntityState().setBizChanged(flowRunProp.getOrdinal(), false);
        DynamicProperty flowRunTaskProp = dyc.getDynamicObjectType().getProperty("flowrutask");
        dyc.getDataEntityState().setBizChanged(flowRunTaskProp.getOrdinal(), false);
        DynamicProperty realWeightProp = dyc.getDynamicObjectType().getProperty("realweight");
        dyc.getDataEntityState().setBizChanged(realWeightProp.getOrdinal(), false);
    }
}

