/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.complete;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.process.ProcessExecuteApplicationService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumResultSetBo;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.epa.formplugin.web.activitymanage.performsummary.utils.ListUtil;

public class AssessCompleteList
extends EvalObjBaseList {
    private DynamicObject assessForm;
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActivityEvaluationObjectDomainService ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActivityEvaluationObjectApplicationService ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final ProcessExecuteApplicationService PROCESS_EXECUTE_APPLICATION_SERVICE = ProcessExecuteApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static Log LOGGER = LogFactory.getLog(AssessCompleteList.class);

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListUtils.filterContainerInit(this.getView(), args);
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        List qFilters = evt.getQFilters();
        QFilter qFilter = new QFilter("assessstaus", "=", (Object)AssessStausEnum.COMPLETED.getStatus());
        qFilter.and(new QFilter("activity", "=", (Object)activityId));
        qFilters.add(qFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("complete".equals(operateKey)) {
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            boolean ref = ASSESS_ACTIVITY_APPLICATION_SERVICE.checkEndAssessStatus(activityId);
            if (!ActivityStatusEnum.EXECUTING.getValue().equals(activity.getString("activitystatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u7ed3\u675f\u72b6\u6001\u4e3a\u201c\u6267\u884c\u4e2d\u201d\u7684\u8003\u6838\u6d3b\u52a8", (String)"AssessCompleteList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (ref) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u4e2d\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61\u672a\u5b8c\u6210\u8003\u6838\uff0c\u4e0d\u53ef\u7ed3\u675f\u3002", (String)"AssessCompleteList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (!ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE.isExistsEvalObj((Long)this.getView().getFormShowParameter().getCustomParam("activity"))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u4e2d\u65e0\u53c2\u4e0e\u8003\u6838\u7684\u8bc4\u4f30\u5bf9\u8c61\uff0c\u662f\u5426\u7ee7\u7eed\u7ed3\u675f\uff1f", (String)"AssessCompleteList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("complete", (IFormPlugin)this));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u5c06\u7ed3\u675f\uff0c\u7ee7\u7eed\u7ed3\u675f\u5417\uff1f", (String)"AssessCompleteList_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("complete", (IFormPlugin)this));
            }
        }
        if ("file".equals(operateKey)) {
            this.fileActObj(args);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!hasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u6838\u6d3b\u52a8\u201d\u7684\u201c\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssessCompleteList_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (HRStringUtils.equals((String)actionId, (String)"complete") && MessageBoxResult.Yes.equals((Object)resultValue)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("systeminvoke", "true");
            this.getView().invokeOperation("complete_confirm", operateOption);
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            ASSESS_ACTIVITY_APPLICATION_SERVICE.endActivity(activityId);
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u6210\u529f", (String)"AssessCompleteList_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        PerfSumResultSetBo scale = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getScale(activityId.longValue());
        final String numAccuracy = scale.getNumAccuracy();
        final String scaleType = scale.getScaleType();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    BigDecimal fsop = row.getBigDecimal("fsop");
                    if (StringUtils.isNotBlank((CharSequence)numAccuracy) && StringUtils.isNotBlank((CharSequence)scaleType)) {
                        fsop = fsop.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get((String)scaleType).getType());
                        row.set("fsop", (Object)fsop);
                    }
                    String flop = row.getString("flop");
                    DynamicObject floplevel = row.getDynamicObject("floplevel");
                    if (StringUtils.isNotBlank((CharSequence)flop) && floplevel != null) {
                        DynamicObjectCollection cols = floplevel.getDynamicObjectCollection("entryentity");
                        int seq = Integer.parseInt(flop);
                        if (cols.size() < seq) continue;
                        String levelname = ((DynamicObject)cols.get(seq - 1)).getString("levelname");
                        row.set("flop", (Object)levelname);
                        continue;
                    }
                    row.set("flop", null);
                }
                return rows;
            }
        });
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        ListUtils.cycleTypeHandle(args, this.getView());
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        ListUtil.decimalDisplayeFormatHandle(args, activityId, "fsop");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        IFormView formView = this.getView();
        if (formView instanceof IListView && HRStringUtils.equals((String)args.getFieldName(), (String)"perffile_name")) {
            args.setCancel(true);
            IListView listView = (IListView)formView;
            Object actEvalObjId = listView.getFocusRowPkId();
            boolean isShow = PROCESS_EXECUTE_APPLICATION_SERVICE.checkEvalFinishType(actEvalObjId, false);
            if (!isShow) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u672a\u53c2\u4e0e\u8bc4\u4f30\u6d41\u7a0b\uff0c\u65e0\u8bc4\u4f30\u8be6\u60c5\u8bb0\u5f55", (String)"AssessCompleteList_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("epa_complete_evalinfo");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setPkId(actEvalObjId);
            showParameter.setPageId(listView.getPageId() + "complete" + actEvalObjId);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void fileActObj(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        List<Long> idList = listSelectedData.stream().map(row -> Long.valueOf(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.loadDynamicObjectArray(idList.toArray(new Long[0]));
        StringBuilder errStringList = new StringBuilder();
        int errCount = 0;
        ArrayList<DynamicObject> toFileList = new ArrayList<DynamicObject>();
        for (DynamicObject dynObj : dynamicObjects) {
            String assessStatus = dynObj.getString("assessstaus");
            String ressyncStatus = dynObj.getString("ressyncstatus");
            String personInfo = dynObj.getString("person.name") + " " + dynObj.getString("person.number");
            if (!AssessStausEnum.COMPLETED.getStatus().equals(assessStatus)) {
                this.appendErrorMessage(errStringList, personInfo, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u201c%s\u201d\uff1a\u5df2\u4e0d\u5728\u8003\u6838\u5b8c\u6210\u72b6\u6001", (String)"AssessCompleteList_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                ++errCount;
                continue;
            }
            if ("20".equals(ressyncStatus)) {
                this.appendErrorMessage(errStringList, personInfo, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u201c%s\u201d\uff1a\u7ed3\u679c\u5df2\u5f52\u6863", (String)"AssessCompleteList_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                ++errCount;
                continue;
            }
            toFileList.add(dynObj);
        }
        if (!toFileList.isEmpty()) {
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            ASSESS_ACTIVITY_APPLICATION_SERVICE.fileActivity(toFileList.toArray(new DynamicObject[0]), activityId);
        }
        this.displayResultMessage(listSelectedData.size(), errCount, errStringList);
    }

    private void appendErrorMessage(StringBuilder errStringBuilder, String personInfo, String messageKey) {
        errStringBuilder.append(String.format(ResManager.loadKDString((String)messageKey, (String)"AssessCompleteList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), personInfo)).append("\n");
    }

    private void displayResultMessage(int totalSize, int errCount, StringBuilder errStringList) {
        if (errCount > 0) {
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u5f52\u6863\u6210\u529f\uff0c\u5171{0}\u6761\u6570\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"AssessCompleteList_10", (String)"opmc-epa-business", (Object[])new Object[0]), totalSize, totalSize - errCount, errCount);
            this.getView().showMessage(message, errStringList.toString(), MessageTypes.Default);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f52\u6863\u6210\u529f", (String)"AssessCompleteList_11", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }
}

