/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.complete;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalfinishtypeEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetScoreRecordDomainService;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.utils.EvalResultViewUtils;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;

public class CompleteActEvalRecordEdit
extends HRDataBaseEdit
implements TabSelectListener {
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final ObjsetScoreRecordDomainService OBJSET_SCORERECORD_ENTITY_SERVICE = ObjsetScoreRecordDomainService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final String IS_GENEXTMPSOP = "isgenextmpsop";
    private static final String MPSOPCATEGORY = "mpsopcategory";
    private static final String MPGENWAY = "mpgenway";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"evaldetailview")) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("epa_sumarearecord_dv");
            String assessformId = this.getPageCache().get("assessform.id");
            showParameter.setCustomParam("assessformId", (Object)Long.parseLong(assessformId));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String evalFinishType = (String)this.getModel().getValue("evalfinishtype");
        if (HRStringUtils.equals((String)EvalfinishtypeEnum.HANDWORK_INPUT.getType(), (String)evalFinishType) || HRStringUtils.equals((String)EvalfinishtypeEnum.NOPART_EVAL.getType(), (String)evalFinishType)) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u672a\u53c2\u4e0e\u8bc4\u4f30\u6d41\u7a0b\uff0c\u65e0\u8bc4\u4f30\u8be6\u60c5\u8bb0\u5f55", (String)"CompleteActEvalRecordEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
            return;
        }
        Long assessFormId = this.getModel().getDataEntity().getLong("activity.assessform.id");
        this.getPageCache().put("assessform.id", String.valueOf(assessFormId));
        DynamicObject assessformDy = APP_SERVICE.queryExecuteAssessForm(assessFormId.longValue());
        this.getPageCache().put("numaccuracy", assessformDy.getString("numaccuracy"));
        this.getPageCache().put("scaletype", assessformDy.getString("scaletype"));
        DynamicObject executeScheme = APP_SERVICE.queryExecuteScheme(this.getModel().getDataEntity().getLong("activity.executescheme.id"));
        this.setActivityInfo(executeScheme, assessformDy);
        this.setPersonInfo();
        this.showEvaluationView(assessformDy);
        this.showProcessInfoView();
        this.showAllowexceed(assessformDy);
        this.showUpdateDetail();
        this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"{0}-\u8003\u6838\u5b8c\u6210\u8be6\u60c5\u9875", (String)"CompleteActEvalRecordEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("person.name")})));
    }

    private void showUpdateDetail() {
        Long evalObjId = this.getModel().getDataEntity().getLong("id");
        QFilter qFilter = new QFilter("actevalobj", "=", (Object)evalObjId);
        DynamicObject[] objSetScoreRecords = OBJSET_SCORERECORD_ENTITY_SERVICE.query("id", new QFilter[]{qFilter});
        if (null == objSetScoreRecords || objSetScoreRecords.length <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap1"});
        }
    }

    private void showAllowexceed(DynamicObject assessformDy) {
        boolean allowexceedupper = assessformDy.getBoolean("allowexceedupper");
        boolean allowexceedlower = assessformDy.getBoolean("allowexceedlower");
        if (allowexceedupper == Boolean.TRUE || allowexceedlower == Boolean.TRUE) {
            BigDecimal maxScore = assessformDy.getBigDecimal("limitmaxscore");
            BigDecimal mincore = assessformDy.getBigDecimal("limitminscore");
            this.getView().setVisible(Boolean.TRUE, new String[]{"allowexceedap"});
            Tips tips = new Tips();
            tips.setTitle(null);
            tips.setTriggerType("hover");
            tips.setShowIcon(Boolean.FALSE.booleanValue());
            tips.setType("text");
            LocaleString content = null;
            if (allowexceedupper == Boolean.FALSE) {
                String allowexceedlowerTips = ResManager.loadKDString((String)"\u8bc4\u4f30\u8868\u4e0b\u9650\u5206\uff1a%s", (String)"CompleteActEvalRecordEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{mincore.stripTrailingZeros().toPlainString()});
                content = new LocaleString(allowexceedlowerTips);
            } else {
                String allowexceedupperStr = ResManager.loadKDString((String)"\u8bc4\u4f30\u8868\u4e0a\u9650\u5206\uff1a%1$s%2$s", (String)"CompleteActEvalRecordEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{maxScore.stripTrailingZeros().toPlainString(), "\r\n"});
                String allowexceedlowerStr = ResManager.loadKDString((String)"\u8bc4\u4f30\u8868\u4e0b\u9650\u5206\uff1a%s", (String)"CompleteActEvalRecordEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{mincore.stripTrailingZeros().toPlainString()});
                String allowexceedlowerTips = allowexceedlower == Boolean.TRUE ? allowexceedlowerStr : "";
                content = new LocaleString(allowexceedupperStr + allowexceedlowerTips);
            }
            tips.setContent(content);
            tips.setPlace("right");
            Label allowexceedAP = (Label)this.getControl("allowexceedlab");
            allowexceedAP.addTips(tips);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"allowexceedap"});
        }
    }

    private void showProcessInfoView() {
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("tabpageap");
    }

    private void setPersonInfo() {
        DynamicObject evalObj = this.getView().getModel().getDataEntity();
        Image headSculpture = (Image)this.getView().getControl("headsculpture");
        headSculpture.setUrl(HRImageUrlUtil.getImageFullUrl((String)evalObj.getString("person.headsculpture")));
        this.setLabelText("name", evalObj.getString("person.name"));
        this.setLabelText("number", evalObj.getString("person.number"));
        String adminorgName = evalObj.getString("empposrel.adminorg.name");
        if (adminorgName != null) {
            this.setLabelText("adminorg", adminorgName);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"adminorg", "adminorgline"});
        }
        String positonName = evalObj.getString("empposrel.position.name");
        if (positonName != null) {
            this.setLabelText("position", positonName);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"position", "positionline"});
        }
    }

    private void showEvaluationView(DynamicObject assessformDy) {
        this.showAreaEvaluationView(assessformDy);
        this.showSumAreaView(assessformDy);
    }

    private void setActivityInfo(DynamicObject executeSchemeDy, DynamicObject assessformDy) {
        DynamicObject activityDy = this.getModel().getDataEntity().getDynamicObject("activity");
        this.setLabelText("activitynamelab", activityDy.getString("name"));
        this.setLabelText("periodlab", activityDy.getString("period"));
        this.setLabelText("assessscopelab", executeSchemeDy.getString("assessscope.name"));
        this.setLabelText("scoresystemlab", assessformDy.getString("scoresystem.name"));
        this.setLabelText("scorecalcwaylab", ScoreCalcWayEnum.getScoreCalcWay((String)assessformDy.getString("scorecalcway")).getText());
    }

    private void showAreaEvaluationView(DynamicObject assessformDy) {
        DynamicObjectCollection areaEntry = this.getModel().getEntryEntity("areaentry");
        Map areaInsMap = areaEntry.stream().collect(Collectors.toMap(areaIns -> areaIns.getLong("areaconf"), Function.identity()));
        FlexPanelAp assTableFlex = new HRFlexPanelAp.Builder("asstableap").setDirection("column").setAlignItems("stretch").setJustifyContent("flex-start").setWrap(false).setGrow(0).setShrink(0).build();
        DynamicObjectCollection areaConfEntry = assessformDy.getDynamicObjectCollection("areaconfentry");
        for (int i = 0; i < areaConfEntry.size(); ++i) {
            Long areaInstanceId;
            DynamicObject areaConf = (DynamicObject)areaConfEntry.get(i);
            DynamicObject areaReg = areaConf.getDynamicObject("areareg");
            Long areaRegId = areaReg.getLong("id");
            AreaRegEnum areaRegEnum = AreaRegEnum.get((Long)areaRegId);
            if (areaRegEnum == AreaRegEnum.CUSTOM_AREA) {
                DynamicObject customAreaEval = APP_SERVICE.queryLastCustomAreaRecordByObj((Long)this.getModel().getDataEntity().getPkValue(), Long.valueOf(areaConf.getLong("areaconf")));
                if (ObjectUtils.isEmpty((Object)customAreaEval)) continue;
                areaInstanceId = (Long)customAreaEval.getPkValue();
            } else {
                DynamicObject areaIns2 = (DynamicObject)areaInsMap.get(areaConf.getLong("areaconf"));
                areaInstanceId = areaIns2.getLong("areains");
                DynamicObject[] indicatorDys = APP_SERVICE.queryIndicator(areaInstanceId, areaRegEnum);
                if (indicatorDys == null || indicatorDys.length == 0) continue;
            }
            String assTableItem = "asstableap" + i;
            FlexPanelAp tableItemAp = new HRFlexPanelAp.Builder(assTableItem).setShrink(0).setGrow(0).setBackColor("#ffffff").build();
            assTableFlex.getItems().add(tableItemAp);
            String formId = areaRegEnum.getEvalResultPageId();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setPkId((Object)areaInstanceId);
            showParameter.setFormId(formId);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(assTableItem);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
            showParameter.setCustomParam("confid", (Object)areaConf.getLong("areaconf"));
            this.setAssessFormParamInfo(assessformDy, showParameter);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        this.getView().updateControlMetadata(assTableFlex.getKey(), assTableFlex.createControl());
    }

    private void setLabelText(String label, String text) {
        Label activityNameLab = (Label)this.getControl(label);
        activityNameLab.setText(text);
    }

    private void showSumAreaView(DynamicObject assessformDy) {
        DynamicObject sumConf = APP_SERVICE.querySumConfInfoById(assessformDy.getLong("sumconf"));
        boolean isShowInFlow = sumConf.getBoolean("isshowinflow");
        this.getView().setVisible(Boolean.valueOf(isShowInFlow), new String[]{"sumareaflex", "topsumareaap"});
        if (!isShowInFlow) {
            return;
        }
        DynamicObject[] sumAreaEvalRecords = APP_SERVICE.querySumAreaEvalRecord(this.getModel().getDataEntity().getLong("id"));
        this.showSopLopField(assessformDy);
        this.showSumAreaEvalRecordView(assessformDy, sumAreaEvalRecords, sumConf);
        String desc = sumConf.getString("description");
        if (HRStringUtils.isNotEmpty((String)desc)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setTitle(new LocaleString(sumConf.getString("areacustname")));
            tips.setTriggerType("hover");
            tips.setType("text");
            tips.setContent(new LocaleString(desc));
            tips.setIconClassName("kdfont kdfont-gengduo2");
            tips.setPlace("right");
            props.put("tips", tips);
            this.getView().updateControlMetadata("sumareanamelab", props);
        }
    }

    private void showSopLopField(DynamicObject ruleDy) {
        Long activityId = this.getModel().getDataEntity().getLong("activity.id");
        DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        boolean isgenextmpsop = activity.getBoolean(IS_GENEXTMPSOP);
        String mpsopcategory = activity.getString(MPSOPCATEGORY);
        long flowId = this.getModel().getDataEntity().getLong("activity.perfworkflow.id");
        DynamicObject perfWorkflow = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowById(Long.valueOf(flowId));
        DynamicObjectCollection nodeCols = perfWorkflow.getDynamicObjectCollection("entryentity");
        boolean haveSum = false;
        boolean haveTarget = false;
        boolean haveEval = false;
        for (DynamicObject dy : nodeCols) {
            long node = dy.getDynamicObject("node").getLong("id");
            if (NodeTabMapEnum.PERF_SUM.getNodeId() == node) {
                haveSum = dy.getBoolean("isshow");
                continue;
            }
            if (NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId() == node) {
                haveTarget = dy.getBoolean("isshow");
                continue;
            }
            if (NodeTabMapEnum.EVAL_PROCESS.getNodeId() != node) continue;
            haveEval = dy.getBoolean("isshow");
        }
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule((Long)ruleDy.getPkValue());
        int numAccuracy = ruleDy.getInt("numaccuracy");
        int roundingMode = ScalaTypeEnum.get((String)ruleDy.getString("scaletype")).getType();
        BigDecimal sop = this.getModel().getDataEntity().getBigDecimal(AssessScoreAbbrEnum.SOP.getCode()).setScale(numAccuracy, roundingMode);
        String lop = this.getModel().getDataEntity().getString(AssessScoreAbbrEnum.LOP.getCode());
        ComboItem comboItem = perfLevelItems.stream().filter(item -> HRStringUtils.equals((String)lop, (String)item.getValue())).findAny().orElse(null);
        String lopStr = comboItem == null ? "" : comboItem.getCaption().getLocaleValue();
        BigDecimal fsop = this.getModel().getDataEntity().getBigDecimal(AssessScoreAbbrEnum.FSOP.getCode()).setScale(numAccuracy, roundingMode);
        String flop = this.getModel().getDataEntity().getString(AssessScoreAbbrEnum.FLOP.getCode());
        long flopLevel = this.getModel().getDataEntity().getLong("floplevel.id");
        String flopResult = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getMappingResultByMplop(Long.valueOf(flopLevel), flop);
        if (isgenextmpsop && "Y".equals(mpsopcategory)) {
            if (haveSum && (haveEval || haveTarget)) {
                String mpgenway = activity.getString(MPGENWAY);
                if ("1".equals(mpgenway)) {
                    this.setLabelText("topsoplabel", String.valueOf(sop));
                    this.setLabelText("toploplabel", lopStr);
                    this.getView().setVisible(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)lopStr)), new String[]{"oseline"});
                } else if ("2".equals(mpgenway)) {
                    this.setLabelText("topsoplabel", String.valueOf(fsop));
                    this.setLabelText("toploplabel", flopResult);
                    this.getView().setVisible(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)flopResult)), new String[]{"oseline"});
                }
                this.setLabelText("yearscore", String.valueOf(fsop));
                this.setLabelText("yeargrade", flopResult);
                this.getView().setVisible(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)flopResult)), new String[]{"oselineyear"});
            } else if (!haveSum && haveEval) {
                this.setLabelText("topsoplabel", String.valueOf(fsop));
                this.setLabelText("toploplabel", flopResult);
                this.getView().setVisible(Boolean.FALSE, new String[]{"yearflex"});
            }
        } else {
            this.setLabelText("topsoplabel", String.valueOf(fsop));
            this.setLabelText("toploplabel", flopResult);
            this.getView().setVisible(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)flopResult)), new String[]{"oseline"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"yearflex"});
        }
        this.setLabelText("bottomsoplabel", String.valueOf(sop));
        this.setLabelText("bottomloplabel", lopStr);
    }

    private void showSumAreaEvalRecordView(DynamicObject ruleDy, DynamicObject[] sumAreaEvalRecords, DynamicObject sumConf) {
        List<DynamicObject> recordList = Arrays.stream(sumAreaEvalRecords).filter(record -> StringUtils.equals((CharSequence)record.getString("flowrutask.taskstatus"), (CharSequence)FlowRuTaskStatusEnum.PROCESSED.getCode())).collect(Collectors.toList());
        DynamicObjectCollection sumRecordEntry = EvalResultViewUtils.initRecordEntryData(this.getView(), ruleDy, recordList);
        if (ObjectUtils.isEmpty((Object)sumRecordEntry)) {
            this.getView().setVisible(Boolean.valueOf(!ObjectUtils.isEmpty(recordList)), new String[]{"recordopap", "sumarearecordap"});
            return;
        }
        CardEntry sumRecordCard = (CardEntry)this.getControl("sumrecordentry");
        DynamicObjectCollection filedEntry = sumConf.getDynamicObjectCollection("entryentity");
        Map<Long, Boolean> nodeIdMap = sumRecordEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getLong("flowrunode.id"), filedInfo -> Boolean.TRUE, (v1, v2) -> v1));
        for (int i = 0; i < sumRecordEntry.size(); ++i) {
            Long nodeId = ((DynamicObject)sumRecordEntry.get(i)).getLong("flowrunode.id");
            if (nodeIdMap.get(nodeId).booleanValue()) {
                nodeIdMap.put(nodeId, Boolean.FALSE);
            } else {
                sumRecordCard.setChildVisible(false, i, new String[]{"nodeinfoap"});
            }
            sumRecordCard.setChildVisible(i == 0, i, new String[]{"evaldetaillab"});
            sumRecordCard.setChildVisible(false, i, new String[]{"oseap", "oleap", "evalap", "iscrosslab"});
            EvalResultViewUtils.hideFieldIfNull(sumRecordCard, sumRecordEntry, i, "nodeweight");
        }
        for (DynamicObject filedInfo2 : filedEntry) {
            DynamicObject filed = filedInfo2.getDynamicObject("areafield");
            String filedKey = filed.getString("number");
            boolean isShow = filedInfo2.getBoolean("isshow");
            int size = sumRecordEntry.size();
            for (int i = 0; i < size; ++i) {
                boolean isCross = ((DynamicObject)sumRecordEntry.get(i)).getBoolean("flowrunode.iscrossnode");
                if (isCross) {
                    sumRecordCard.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"evalinfoap"});
                    sumRecordCard.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"cardentryflexpanelap8"});
                    sumRecordCard.setChildVisible(Boolean.TRUE.booleanValue(), i, new String[]{"iscrosslab"});
                    continue;
                }
                sumRecordCard.setChildVisible(isShow && Boolean.TRUE != false, i, new String[]{filedKey + "ap"});
                if (!isShow || !HRStringUtils.equals((String)filedKey, (String)"ole") && !HRStringUtils.equals((String)filedKey, (String)"eval")) continue;
                EvalResultViewUtils.hideFieldIfNull(sumRecordCard, sumRecordEntry, i, filedKey);
            }
            Label filedNameLab = (Label)this.getView().getControl(filedKey + "lab");
            String fieldCustName = filedInfo2.getString("fieldcustname");
            String fieldName = StringUtils.isEmpty((CharSequence)fieldCustName) ? filed.getString("name") : fieldCustName;
            filedNameLab.setText(fieldName + "\uff1a");
        }
    }

    private void setAssessFormParamInfo(DynamicObject assessFormDy, BaseShowParameter showParameter) {
        showParameter.setCustomParam("ruleid", (Object)assessFormDy.getLong("id"));
        showParameter.setCustomParam("scorecalcway", (Object)assessFormDy.getString("scorecalcway"));
        showParameter.setCustomParam("evalway", (Object)assessFormDy.getString("evalway"));
        showParameter.setCustomParam("numaccuracy", (Object)assessFormDy.getString("numaccuracy"));
        showParameter.setCustomParam("scoresystem", (Object)assessFormDy.getDynamicObject("scoresystem").getLong("id"));
        showParameter.setCustomParam("scaletype", (Object)assessFormDy.getString("scaletype"));
        showParameter.setCustomParam("issupcalcsum", (Object)assessFormDy.getBoolean("issupcalcsum"));
        showParameter.setCustomParam("consistentwitharea", (Object)assessFormDy.getBoolean("consistentwitharea"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (HRStringUtils.equals((String)"tabpageap", (String)tabKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("epa_evaluatingprocessnode");
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("tabpageap");
            parameter.setCustomParam("FLOW_RU_ID", this.getModel().getDataEntity().getDynamicObject("evalflowins").getPkValue());
            parameter.setCustomParam("isFromComplete", (Object)Boolean.TRUE);
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
        } else if (HRStringUtils.equals((String)"tabpageap1", (String)tabKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("epa_complete_evalmodinfo");
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("tabpageap1");
            parameter.setCustomParam("epa_actevalobj", (Object)this.getModel().getDataEntity().getLong("id"));
            parameter.setCustomParam("assessform.id", (Object)this.getPageCache().get("assessform.id"));
            parameter.setCustomParam("numaccuracy", (Object)this.getPageCache().get("numaccuracy"));
            parameter.setCustomParam("scaletype", (Object)this.getPageCache().get("scaletype"));
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
        }
    }
}

