/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;

public abstract class ConfirmAreaTplBaseEdit
extends HRDataBaseEdit {
    protected void setLableAp(DynamicObject indicatorDy) {
        String forTitle = ResManager.loadKDString((String)"\u8bc4\u4f30\u8be6\u60c5-{0}", (String)"ConfirmAreaTplBaseEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{indicatorDy.getString("indctrname")});
        this.getView().setFormTitle(new LocaleString(forTitle));
    }

    protected void initEvalRecordInfo(DynamicObject[] evalRecords, DynamicObject conf) {
        IFormView view = this.getView();
        Integer numAccuracy = Integer.parseInt((String)view.getFormShowParameter().getCustomParam("numaccuracy"));
        String scaleType = (String)view.getFormShowParameter().getCustomParam("scaletype");
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("handler", new Object[0]);
        vs.addField("indrecord", new Object[0]);
        vs.addField("flowrunode", new Object[0]);
        vs.addField("flowrurole", new Object[0]);
        for (DynamicObject recordDy : evalRecords) {
            vs.addRow(new Object[]{recordDy.get("flowrutask.handler.id"), recordDy.getPkValue(), recordDy.get("flowrunode.id"), recordDy.get("flowrurole.id")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        DynamicObjectCollection recordEntry = view.getModel().getEntryEntity("entryentity");
        for (DynamicObject record : recordEntry) {
            record.set("nodeweight", record.get("flowrunode.nodeweight"));
            record.set("roleweight", record.get("flowrurole.roleweight"));
            record.set("handlerhead", record.get("handler.picturefield"));
            record.set("ose", (Object)record.getBigDecimal("indrecord.soe").setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()));
            record.set("evaldes", record.get("indrecord.evaldesc"));
            if (!ObjectUtils.isEmpty((Object)record.get("indrecord.evaldesc"))) continue;
            record.set("evaldes", (Object)"-");
        }
        model.endInit();
        view.updateView("entryentity");
        view.getModel().setDataChanged(false);
        String scoreCalcWay = (String)view.getFormShowParameter().getCustomParam("scorecalcway");
        if (!ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
            view.setVisible(Boolean.FALSE, new String[]{"oseap"});
        }
        CardEntry sumRecordCard = (CardEntry)view.getControl("entryentity");
        Map<Long, Boolean> nodeIdMap = recordEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getLong("flowrunode.id"), filedInfo -> Boolean.TRUE, (v1, v2) -> v1));
        for (int i = 0; i < recordEntry.size(); ++i) {
            Long nodeId = ((DynamicObject)recordEntry.get(i)).getLong("flowrunode.id");
            if (nodeIdMap.get(nodeId).booleanValue()) {
                nodeIdMap.put(nodeId, Boolean.FALSE);
                continue;
            }
            sumRecordCard.setChildVisible(false, i, new String[]{"nodeinfoap"});
        }
        Set<String> notShowFieldSet = this.getNotShowFieldSet();
        boolean isConfig = false;
        DynamicObjectCollection confEntryEntity = conf.getDynamicObjectCollection("entryentity");
        for (DynamicObject fieldInfo : confEntryEntity) {
            String fieldKey = fieldInfo.getString("areafield.number");
            if (!"evaldesc".equals(fieldKey)) continue;
            isConfig = true;
        }
        if (this.isEvalapShowLast() || notShowFieldSet.contains("evaldesc") || !isConfig) {
            for (int i = 0; i < recordEntry.size() - 1; ++i) {
                sumRecordCard.setChildVisible(false, i, new String[]{"evalap"});
            }
            if (notShowFieldSet.contains("evaldesc") || !isConfig) {
                sumRecordCard.setChildVisible(false, recordEntry.size() - 1, new String[]{"evalap"});
            }
        }
        boolean isalloweval = true;
        if (conf.getDataEntityType().getProperties().containsKey((Object)"isalloweval")) {
            isalloweval = conf.getBoolean("isalloweval");
        }
        if (this.isOseapShowResult() || notShowFieldSet.contains("evalscore") || !isalloweval) {
            for (int i = 0; i < recordEntry.size(); ++i) {
                sumRecordCard.setChildVisible(false, i, new String[]{"oseap"});
            }
        }
        if (this.isAnonymous()) {
            long currentUserId = UserServiceHelper.getCurrentUserId();
            for (int i = 0; i < recordEntry.size(); ++i) {
                long handlerId = ((DynamicObject)recordEntry.get(i)).getDynamicObject("handler").getLong("id");
                if (handlerId != currentUserId) {
                    sumRecordCard.setChildVisible(false, i, new String[]{"handlerhead"});
                    sumRecordCard.setChildVisible(false, i, new String[]{"handler"});
                    sumRecordCard.setChildVisible(false, i, new String[]{"basedatapropfield2"});
                    continue;
                }
                sumRecordCard.setChildVisible(false, i, new String[]{"handlerhead1"});
                sumRecordCard.setChildVisible(false, i, new String[]{"labelap1"});
                sumRecordCard.setChildVisible(false, i, new String[]{"labelap2111"});
            }
        } else {
            for (int i = 0; i < recordEntry.size(); ++i) {
                sumRecordCard.setChildVisible(false, i, new String[]{"handlerhead1"});
                sumRecordCard.setChildVisible(false, i, new String[]{"labelap1"});
                sumRecordCard.setChildVisible(false, i, new String[]{"labelap2111"});
            }
        }
    }

    protected boolean isEvalapShowLast() {
        Map<String, String> scoreShowMap = ListUtils.getScoreShowMap(this.getView());
        return "show_last".equals(scoreShowMap.get("description"));
    }

    protected boolean isOseapShowResult() {
        Map<String, String> scoreShowMap = ListUtils.getScoreShowMap(this.getView());
        return "show_result".equals(scoreShowMap.get("scope"));
    }

    protected boolean isAnonymous() {
        Map<String, String> scoreShowMap = ListUtils.getScoreShowMap(this.getView());
        return "anonymous".equals(scoreShowMap.get("anonymous"));
    }

    protected void initIndicatorInfo(DynamicObject indicatorDy, DynamicObject conf) {
        DynamicObjectCollection confEntryEntity = conf.getDynamicObjectCollection("entryentity");
        FlexPanelAp indicatorListAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("indicatorpanelap").setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setWrap(false).setPaddingTop("12px")).setPaddingRight("20px")).setPaddingLeft("20px")).setPaddingTop("10px")).setGrow(0).setShrink(0).setBackColor("#ffffff").build();
        int numAccuracy = Integer.parseInt((String)this.getView().getFormShowParameter().getCustomParam("numaccuracy"));
        int roundingMode = ScalaTypeEnum.get((String)((String)this.getView().getFormShowParameter().getCustomParam("scaletype"))).getType();
        int index = 0;
        Set<String> notShowFieldSet = this.getNotShowFieldSet();
        for (DynamicObject fieldInfo : confEntryEntity) {
            String fieldKey = fieldInfo.getString("areafield.number");
            String fieldCategory = fieldInfo.getString("areafield.category");
            if (!this.isShow(fieldCategory, fieldKey, indicatorDy, notShowFieldSet)) continue;
            String fieldName = fieldInfo.getString("fieldcustname");
            String value = this.formatFieldValue(indicatorDy, fieldKey, numAccuracy, roundingMode);
            FlexPanelAp indicatorAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("indicatorap" + index).setDirection("row").setWrap(false).setMarginBottom("4px")).setBackColor("#ffffff").build();
            LabelAp nameLab = new HRLabelAp.Builder("indicatorkey" + index).setWidth(new LocaleString("60px")).setForeColor("#666666").setTextAlign("right").setGrow(0).setShrink(0).setName(fieldName).build();
            indicatorAp.getItems().add(nameLab);
            FlexPanelAp valueAp = new HRFlexPanelAp.Builder("indicatorvalueap" + index).setDirection("row").setWrap(false).setBackColor("#ffffff").build();
            if (HRStringUtils.isBlank((CharSequence)value)) {
                value = "-";
            }
            LabelAp valueLab = new HRLabelAp.Builder("indicatorvalue" + index).setAutoTextWrap(true).setGrow(0).setShrink(1).setName("\uff1a" + value).build();
            valueAp.getItems().add(valueLab);
            indicatorAp.getItems().add(valueAp);
            indicatorListAp.getItems().add(indicatorAp);
        }
        this.getView().updateControlMetadata(indicatorListAp.getKey(), indicatorListAp.createControl());
    }

    protected Set<String> getNotShowFieldSet() {
        HashSet<String> result = new HashSet<String>(16);
        result.addAll(this.setHiddenColFieldSet());
        result.addAll(this.permissionNotShowSet());
        return result;
    }

    protected Set<String> setHiddenColFieldSet() {
        return new HashSet<String>(16);
    }

    protected Set<String> permissionNotShowSet() {
        return ListUtils.getShowAreaNotShowFieldSet(this.getView(), (Long)this.getView().getFormShowParameter().getCustomParam("confid"));
    }

    private boolean isShow(String fieldCategory, String fieldKey, DynamicObject indicatorDy, Set<String> notShowFieldSet) {
        boolean isShow = false;
        if (!ObjectUtils.isEmpty((Object)indicatorDy.getDataEntityType().getProperties().get((Object)fieldKey))) {
            if (HRStringUtils.equals((String)fieldCategory, (String)"10") || HRStringUtils.equals((String)fieldCategory, (String)"20")) {
                isShow = true;
            }
            if (notShowFieldSet.contains(fieldKey)) {
                isShow = false;
            }
        }
        return isShow;
    }

    private String formatFieldValue(DynamicObject indicatorDy, String fieldKey, int numAccuracy, int roundingMode) {
        String value = "-";
        if (ObjectUtils.isEmpty((Object)indicatorDy.get(fieldKey))) {
            return value;
        }
        IDataEntityProperty property = (IDataEntityProperty)indicatorDy.getDataEntityType().getProperties().get((Object)fieldKey);
        value = property instanceof DecimalProp && indicatorDy.get(fieldKey) instanceof BigDecimal ? indicatorDy.getBigDecimal(fieldKey).setScale(numAccuracy, roundingMode).toPlainString() : (property instanceof DateProp && indicatorDy.get(fieldKey) instanceof Date ? (ObjectUtils.isEmpty((Object)indicatorDy.get(fieldKey)) ? "" : HRDateTimeUtils.formatDate((Date)indicatorDy.getDate(fieldKey))) : (property instanceof BooleanProp && indicatorDy.get(fieldKey) instanceof Boolean ? (indicatorDy.getBoolean(fieldKey) ? ResManager.loadKDString((String)"\u662f", (String)"ConfirmAreaTplBaseEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ConfirmAreaTplBaseEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0])) : (property instanceof ComboProp ? EntityMetaDataUtils.getEntityComboFieldItemName((String)indicatorDy.getDataEntityType().getName(), (String)fieldKey, (String)indicatorDy.getString(fieldKey)) : indicatorDy.getString(fieldKey))));
        return value;
    }

    protected void customStyle() {
    }
}

