/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetScoreRecordDomainService;
import kd.opmc.epa.common.constants.PerformSummaryConstants;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.utils.ScoreAndLevelUtils;
import org.apache.commons.lang3.StringUtils;

public class ConfirmEndConfirmMultiPlugin
extends AbstractBasePlugIn
implements ClickListener,
IConfirmCallBack,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ConfirmEndConfirmMultiPlugin.class);
    protected static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    protected static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ObjsetScoreRecordDomainService OBJSET_SCORERECORD_ENTITY_SERVICE = ObjsetScoreRecordDomainService.getInstance();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"labelap3"});
        BasedataEdit flopid = (BasedataEdit)this.getControl("flopid");
        flopid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LocaleString forTitle = ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u7ed3\u675f\u786e\u8ba4\u7ee9\u6548\u7ed3\u679c", (String)"ConfirmEndConfirmMultiPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), (String)"ConfirmEndConfirmMultiPlugin_0", (String)"opmc-epa-formplugin");
        IFormView view = this.getView();
        view.setFormTitle(forTitle);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Map<Long, Map<String, String>> perfLevelIdLevelSeqLevelIdMap = ScoreAndLevelUtils.getPerfLevelIdLevelSeqLevelNameMap(activityId, "seq", "id");
        view.getPageCache().put("perfLevelIdLevelSeqLevelIdMap", JSON.toJSONString(perfLevelIdLevelSeqLevelIdMap));
        ScoreAndLevelUtils.cacheScoreConfig(this.getView(), activityId);
        Integer numAccuracy = Integer.parseInt(view.getPageCache().get("numAccuracy"));
        String scaleType = view.getPageCache().get("scaleType");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("actevalobj", new Object[0]);
        vs.addField("fsop", new Object[0]);
        vs.addField("flop", new Object[0]);
        vs.addField("flopid", new Object[0]);
        vs.addField("sumperflevel", new Object[0]);
        JSONArray actevalObjIds = (JSONArray)view.getFormShowParameter().getCustomParam("actevalobj");
        DynamicObject[] evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjWithScoreById(actevalObjIds.toJavaList(Long.class));
        List evalObjList = Arrays.stream(evalObjs).filter(evalObj -> HRStringUtils.equals((String)AssessNodeStatusEnum.TERMINATE.getStatus(), (String)evalObj.getString("nodestatus"))).collect(Collectors.toList());
        boolean sumperflevelIsNull = true;
        for (DynamicObject evalObj2 : evalObjList) {
            Long flopId = null;
            long actPerfLevelId = evalObj2.getLong("cfloplevel.id");
            if (actPerfLevelId != 0L) {
                sumperflevelIsNull = false;
                Map<String, String> levelSeqIdMap = perfLevelIdLevelSeqLevelIdMap.get(actPerfLevelId);
                if (!HRMapUtils.isEmpty(levelSeqIdMap) && levelSeqIdMap.containsKey(evalObj2.getString("flop"))) {
                    flopId = Long.valueOf(levelSeqIdMap.get(evalObj2.getString("flop")));
                }
            }
            vs.addRow(new Object[]{evalObj2.getLong("id"), evalObj2.getBigDecimal("fsop").setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()), evalObj2.getString("flop"), flopId, actPerfLevelId});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        view.updateView("entryentity");
        this.getModel().setDataChanged(false);
        if (sumperflevelIsNull) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flopid"});
        }
        if (evalObjs.length == evalObjList.size()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        } else {
            Label labelap1 = (Label)this.getControl("labelap1");
            labelap1.setText(String.valueOf(evalObjs.length - evalObjList.size()));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView view = this.getView();
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Integer numAccuracy = Integer.parseInt(view.getPageCache().get("numAccuracy"));
        clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"fsop", "sc", numAccuracy});
        clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"fsop", "pc", numAccuracy + 13});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"labelap3", (String)source.getKey())) {
            this.exportExcel();
        }
    }

    private void exportExcel() {
        String excelName = ResManager.loadKDString((String)"\u5f15\u51fa\u5217\u8868_\u786e\u8ba4\u5931\u8d25\u8be6\u60c5_{0}", (String)"ConfirmEndConfirmMultiPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss")});
        List<HRExportHeadObject> headDataList = this.getExportHead();
        List<Map<String, Object>> exportDataList = this.getExportData();
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, exportDataList, headDataList);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    private List<HRExportHeadObject> getExportHead() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        headDataList.add(new HRExportHeadObject("operateKey", ResManager.loadKDString((String)"\u64cd\u4f5c\u4fe1\u606f", (String)"ConfirmEndConfirmMultiPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("isSuccess", ResManager.loadKDString((String)"\u72b6\u6001", (String)"ConfirmEndConfirmMultiPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("return_str", ResManager.loadKDString((String)"\u5904\u7406\u7ed3\u679c", (String)"ConfirmEndConfirmMultiPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        return headDataList;
    }

    private List<Map<String, Object>> getExportData() {
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(10);
        JSONArray actevalObjIds = (JSONArray)this.getView().getFormShowParameter().getCustomParam("actevalobj");
        DynamicObject[] evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjWithScoreById(actevalObjIds.toJavaList(Long.class));
        List evalObjList = Arrays.stream(evalObjs).filter(evalObj -> !HRStringUtils.equals((String)AssessNodeStatusEnum.TERMINATE.getStatus(), (String)evalObj.getString("nodestatus"))).collect(Collectors.toList());
        for (DynamicObject evalObj2 : evalObjList) {
            HashMap<String, String> row = new HashMap<String, String>(16);
            row.put("operateKey", ResManager.loadKDString((String)"\u7ed3\u675f\u786e\u8ba4", (String)"ConfirmEndConfirmMultiPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            row.put("isSuccess", ResManager.loadKDString((String)"\u5931\u8d25", (String)"ConfirmEndConfirmMultiPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            String name = evalObj2.getString("perffile.name");
            String number = evalObj2.getString("perffile.billno");
            String errorMsg = null;
            if (AssessNodeStatusEnum.CONFIRMED.getStatus().equals(evalObj2.get("nodestatus"))) {
                errorMsg = ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u786e\u8ba4", (String)"ConfirmEndConfirmMultiPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            } else if (!AssessNodeStatusEnum.TERMINATE.getStatus().equals(evalObj2.get("nodestatus"))) {
                errorMsg = ResManager.loadKDString((String)"\u4ec5\u53ef\u7ed3\u675f\u786e\u8ba4\u72b6\u6001\u4e3a\u5df2\u7ec8\u6b62\u7684\u7ee9\u6548\u7ed3\u679c", (String)"ConfirmEndConfirmMultiPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            }
            errorMsg = MessageFormat.format("{0}{1}\uff1a{2}", name, number, errorMsg);
            row.put("return_str", errorMsg);
            exportDataList.add(row);
        }
        return exportDataList;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("fsop".equals(propertyName)) {
            this.scoreFieldChangeHandle(e);
        } else if ("flopid".equals(propertyName)) {
            DynamicObject floplevel = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (floplevel == null) {
                return;
            }
            this.getModel().setValue("flop", (Object)floplevel.getString("levelseq"), e.getChangeSet()[0].getRowIndex());
        }
    }

    private void scoreFieldChangeHandle(PropertyChangedArgs e) {
        BigDecimal newScore = (BigDecimal)e.getChangeSet()[0].getNewValue();
        if (newScore == null) {
            return;
        }
        String maxscore = this.getPageCache().get("maxscore");
        String minscore = this.getPageCache().get("minscore");
        BigDecimal maxscoreBig = StringUtils.isEmpty((CharSequence)maxscore) ? new BigDecimal(9999) : new BigDecimal(maxscore);
        BigDecimal minscoreBig = StringUtils.isEmpty((CharSequence)minscore) ? BigDecimal.ZERO : new BigDecimal(minscore);
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject actEvalObj = (DynamicObject)this.getModel().getValue("actevalobj", rowIndex);
        String cfSopSource = actEvalObj.getString("cfsopsource");
        if (HRStringUtils.equals((String)cfSopSource, (String)AssessScoreAbbrEnum.MPSOP.getCode())) {
            maxscoreBig = PerformSummaryConstants.MAX_SCORE_BIG;
            minscoreBig = PerformSummaryConstants.MIN_SCORE_BIG;
        }
        if (newScore.compareTo(minscoreBig) >= 0 && newScore.compareTo(maxscoreBig) <= 0) {
            long actPerfLevelId = actEvalObj.getLong("cfloplevel.id");
            long actScoreSystemId = actEvalObj.getLong("cfsopscoresystem.id");
            if (actPerfLevelId != 0L && actScoreSystemId != 0L) {
                String levelSeq = ScoreAndLevelUtils.calculateLevel(actScoreSystemId, actPerfLevelId, newScore);
                String perfLevelIdLevelSeqLevelIdMapStr = this.getView().getPageCache().get("perfLevelIdLevelSeqLevelIdMap");
                Map perfLevelIdLevelSeqLevelIdMap = (Map)JSON.parseObject((String)perfLevelIdLevelSeqLevelIdMapStr, Map.class);
                Map levelSeqIdMap = (Map)perfLevelIdLevelSeqLevelIdMap.get(actPerfLevelId);
                if (levelSeqIdMap != null) {
                    String flopId = (String)levelSeqIdMap.get(levelSeq);
                    this.getModel().setValue("flopId", (Object)flopId, rowIndex);
                }
            }
        } else {
            this.getModel().setValue("fsop", null);
            this.getView().showErrorNotification(String.format("%s[%s~%s]", ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u8bc4\u5206\u9650\u5236\u6700\u4f4e/\u6700\u9ad8\u5206\u8303\u56f4", (String)"ConfirmEndConfirmMultiPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]), minscoreBig.stripTrailingZeros().toPlainString(), maxscoreBig.stripTrailingZeros().toPlainString()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String resultMsg = ListUtils.permCheck();
        if (!HRStringUtils.isEmpty((String)resultMsg)) {
            this.getView().showErrorNotification(resultMsg);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("confirm".equals(operateKey)) {
            this.endConfirmHandle();
        }
        this.getModel().setDataChanged(false);
    }

    private void endConfirmHandle() {
        ArrayList<Long> evalObjIdList = new ArrayList<Long>(10);
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            long actevalobjId = entry.getDynamicObject("actevalobj").getLong("id");
            evalObjIdList.add(actevalobjId);
        }
        DynamicObject[] evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjWithScoreById(evalObjIdList);
        HashMap<Long, DynamicObject> evalObjIdMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject evalObj : evalObjs) {
            evalObjIdMap.put(evalObj.getLong("id"), evalObj);
        }
        DynamicObjectCollection evalObjCollection = new DynamicObjectCollection();
        DynamicObjectCollection setScoreRecordCollection = new DynamicObjectCollection();
        StringBuilder errorMsg = new StringBuilder();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject sumperflevel;
            String flop;
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            long actevalobjId = entry.getDynamicObject("actevalobj").getLong("id");
            BigDecimal fsop = entry.getBigDecimal("fsop");
            String entryErrorMsg = this.mustInputValidate(fsop, flop = entry.getString("flop"), sumperflevel = entry.getDynamicObject("sumperflevel"));
            if (!HRStringUtils.isEmpty((String)entryErrorMsg)) {
                errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7b2c{0}\u884c\u7684{1}", (String)"ConfirmEndConfirmMultiPlugin_10", (String)"opmc-epa-formplugin", (Object[])new Object[]{String.valueOf(i + 1), entryErrorMsg}));
                errorMsg.append("\r\n");
                continue;
            }
            Object reason = entry.get("reason");
            DynamicObject evalObj = (DynamicObject)evalObjIdMap.get(actevalobjId);
            ListUtils.updateEvalObj(evalObj, fsop, flop, AssessNodeStatusEnum.END_CONFIRM);
            DynamicObject objsetScoreRecord = OBJSET_SCORERECORD_ENTITY_SERVICE.generateObjsetScoreRecord(evalObj, fsop, flop, reason, AssessNodeStatusEnum.CONFIRMING.getNodeId());
            evalObjCollection.add((Object)evalObj);
            setScoreRecordCollection.add((Object)objsetScoreRecord);
        }
        if (!HRStringUtils.isEmpty((String)errorMsg.toString())) {
            this.getView().showErrorNotification(errorMsg.toString());
            return;
        }
        ListUtils.doEndConfirm(this.getView(), evalObjCollection, setScoreRecordCollection);
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    protected String mustInputValidate(BigDecimal fsop, String flop, DynamicObject sumperflevel) {
        StringBuilder errorMsg = new StringBuilder();
        boolean fsopIsMustInput = ((DecimalProp)this.getModel().getDataEntityType().getAllFields().get("fsop")).isMustInput();
        if (fsop == null && fsopIsMustInput) {
            errorMsg.append(ResManager.loadKDString((String)"\u201c\u7ee9\u6548\u5f97\u5206\u201d", (String)"ConfirmEndConfirmMultiPlugin_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        if (sumperflevel != null && HRStringUtils.isEmpty((String)flop)) {
            if (errorMsg.length() != 0) {
                errorMsg.append("\u3001");
            }
            errorMsg.append(ResManager.loadKDString((String)"\u201c\u7ee9\u6548\u7b49\u7ea7\u201d", (String)"ConfirmEndConfirmMultiPlugin_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return errorMsg.toString();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        ListUtils.beforeClosed(e, this.getView(), this, false);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Control source = (Control)beforeF7SelectEvent.getSource();
        if ("flopid".equals(source.getKey())) {
            IDataModel entryOperate = this.getView().getModel();
            int row = entryOperate.getEntryCurrentRowIndex("entryentity");
            DynamicObject actevalobj = entryOperate.getEntryRowEntity("entryentity", row).getDynamicObject("actevalobj");
            Long cfPerfLevelId = actevalobj.getLong("cfloplevel.id");
            QFilter filter = new QFilter("perflevel", "=", (Object)cfPerfLevelId);
            beforeF7SelectEvent.getCustomQFilters().add(filter);
        }
    }
}

