/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetScoreRecordDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ConfirmUpdateTplBasePlugin;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;

public class ConfirmEndConfirmSinglePlugin
extends ConfirmUpdateTplBasePlugin {
    private static final Log log = LogFactory.getLog(ConfirmEndConfirmSinglePlugin.class);
    private static final ObjsetScoreRecordDomainService OBJSET_SCORERECORD_ENTITY_SERVICE = ObjsetScoreRecordDomainService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    protected static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LocaleString forTitle = ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u7ed3\u675f\u786e\u8ba4\u7ee9\u6548\u7ed3\u679c", (String)"ConfirmEndConfirmSinglePlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), (String)"ConfirmEndConfirmSinglePlugin_0", (String)"opmc-epa-formplugin");
        this.getView().setFormTitle(forTitle);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String levelKey = ResManager.loadKDString((String)"\u201c\u7ee9\u6548\u7b49\u7ea7\u201d", (String)"ConfirmEndConfirmSinglePlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        this.mustInputValidate(args, levelKey);
    }

    @Override
    protected String validate() {
        Long evalObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actevalobj");
        DynamicObject[] evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjWithScoreById(Collections.singletonList(evalObjId));
        DynamicObject evalObj = evalObjs[0];
        if (AssessNodeStatusEnum.CONFIRMED.getStatus().equals(evalObj.get("nodestatus"))) {
            return ResManager.loadKDString((String)"\u7ed3\u679c\u786e\u8ba4\u5df2\u5b8c\u6210\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"ConfirmEndConfirmSinglePlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        }
        if (!AssessNodeStatusEnum.TERMINATE.getStatus().equals(evalObj.get("nodestatus"))) {
            return ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fee\u6539\u72b6\u6001\u4e3a\u201c\u5df2\u7ec8\u6b62\u201d\u7ee9\u6548\u7ed3\u679c\u3002", (String)"ConfirmEndConfirmSinglePlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        boolean success = args.getOperationResult().isSuccess();
        if (success) {
            String operateKey = args.getOperateKey();
            if ("confirm".equals(operateKey)) {
                this.endConfirmHandle();
            }
            this.getModel().setDataChanged(false);
        }
    }

    private void endConfirmHandle() {
        BigDecimal score = (BigDecimal)this.getModel().getValue("scorefield");
        Object reason = this.getModel().getValue("reason");
        String level = (String)this.getModel().getValue("levelfield");
        Long evalObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actevalobj");
        DynamicObject[] evaluationObjects = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjWithScoreById(Collections.singletonList(evalObjId));
        DynamicObject evalObj = evaluationObjects[0];
        ListUtils.updateEvalObj(evalObj, score, level, AssessNodeStatusEnum.END_CONFIRM);
        DynamicObject objsetScoreRecord = OBJSET_SCORERECORD_ENTITY_SERVICE.generateObjsetScoreRecord(evalObj, score, level, reason, AssessNodeStatusEnum.CONFIRMING.getNodeId());
        DynamicObjectCollection evalObjCollection = new DynamicObjectCollection();
        DynamicObjectCollection setScoreRecordCollection = new DynamicObjectCollection();
        evalObjCollection.add((Object)evalObj);
        setScoreRecordCollection.add((Object)objsetScoreRecord);
        ListUtils.doEndConfirm(this.getView(), evalObjCollection, setScoreRecordCollection);
    }
}

