/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.info.mp.MpInfoHelper;

public class ConfirmEvalRecordBaseEdit
extends HRDataBaseEdit {
    protected static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    protected static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final String IS_FROM_CONFIRM = "isFromConfirm";

    protected void setPersonInfo() {
        DynamicObject evalObj = this.getView().getModel().getDataEntity();
        Image headSculpture = (Image)this.getView().getControl("headsculpture");
        headSculpture.setUrl(HRImageUrlUtil.getImageFullUrl((String)evalObj.getString("person.headsculpture")));
        this.setLabelText("name", evalObj.getString("perffile.name"));
        this.setLabelText("number", evalObj.getString("perffile.billno"));
        String adminorgName = evalObj.getString("empposrel.adminorg.name");
        if (adminorgName != null) {
            this.setLabelText("adminorg", adminorgName);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"adminorg", "adminorgline"});
        }
        String positonName = evalObj.getString("empposrel.position.name");
        Set<String> showAreaNotShowFieldSet = ListUtils.getShowAreaNotShowFieldSet(this.getView(), (Long)1L);
        if (positonName != null && !showAreaNotShowFieldSet.contains("position")) {
            this.setLabelText("position", positonName);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"position", "positionline"});
        }
    }

    protected void personAreaTplHiddenWhileNoAssessForm(DynamicObject assessFormDyn) {
        if (assessFormDyn == null) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.setFieldProperty("name", "tips", null);
        }
    }

    protected void setActivityInfo() {
        DynamicObject activityDy = this.getModel().getDataEntity().getDynamicObject("activity");
        this.setLabelText("activitynamelab", activityDy.getString("name"));
        this.setLabelText("periodlab", activityDy.getString("period"));
        this.setLabelText("assgrouplab", this.getModel().getDataEntity().getDynamicObject("assgroup").getLocaleString("name").getLocaleValue());
    }

    protected void setLabelText(String label, String text) {
        Label activityNameLab = (Label)this.getControl(label);
        if (activityNameLab != null) {
            activityNameLab.setText(text);
        }
    }

    protected void showAreaEvaluationView(DynamicObject assessformDy) {
        DynamicObjectCollection areaEntry = this.getModel().getEntryEntity("areaentry");
        if (areaEntry == null || areaEntry.size() == 0) {
            return;
        }
        Map areaInsMap = areaEntry.stream().collect(Collectors.toMap(areaIns -> areaIns.getLong("areaconf"), Function.identity()));
        FlexPanelAp assTableFlex = new HRFlexPanelAp.Builder("asstableap").setDirection("column").setAlignItems("stretch").setJustifyContent("flex-start").setWrap(false).setGrow(0).setShrink(0).build();
        DynamicObjectCollection areaConfEntry = assessformDy.getDynamicObjectCollection("areaconfentry");
        Set<Long> notShowAreaSet = ListUtils.getNotShowAreaSet(this.getView());
        Map areaConfRecordMap = APP_SERVICE.queryLastestCustomAreaRecordByEvalObjId((Long)this.getModel().getDataEntity().getPkValue());
        for (int i = 0; i < areaConfEntry.size(); ++i) {
            Long areaInstanceId;
            DynamicObject areaConf = (DynamicObject)areaConfEntry.get(i);
            DynamicObject areaReg = areaConf.getDynamicObject("areareg");
            Long areaRegId = areaReg.getLong("id");
            AreaRegEnum areaRegEnum = AreaRegEnum.get((Long)areaRegId);
            if (areaRegEnum == AreaRegEnum.CUSTOM_AREA) {
                DynamicObject customAreaEval = (DynamicObject)areaConfRecordMap.get(areaConf.getLong("areaconf"));
                if (!ObjectUtils.isEmpty((Object)customAreaEval)) {
                    areaInstanceId = (Long)customAreaEval.getPkValue();
                } else {
                    customAreaEval = (DynamicObject)areaConfRecordMap.get(0L);
                    if (ObjectUtils.isEmpty((Object)customAreaEval)) continue;
                    areaInstanceId = (Long)customAreaEval.getPkValue();
                }
            } else {
                DynamicObject areaIns2 = (DynamicObject)areaInsMap.get(areaConf.getLong("areaconf"));
                areaInstanceId = areaIns2.getLong("areains");
            }
            String formId = areaRegEnum.getEvalConfirmPageId();
            if (this.isHiddenArea(formId, areaInstanceId) || notShowAreaSet.contains(areaConf.getLong("areaconf"))) continue;
            String assTableItem = "asstableap" + i;
            FlexPanelAp tableItemAp = new HRFlexPanelAp.Builder(assTableItem).setShrink(0).setGrow(0).setBackColor("#ffffff").build();
            assTableFlex.getItems().add(tableItemAp);
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setPkId((Object)areaInstanceId);
            showParameter.setFormId(formId);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(assTableItem);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
            showParameter.setCustomParam("confid", (Object)areaConf.getLong("areaconf"));
            showParameter.setCustomParam(IS_FROM_CONFIRM, (Object)Boolean.TRUE);
            showParameter.setCustomParam("permMap", this.getView().getFormShowParameter().getCustomParam("permMap"));
            this.setAssessFormParamInfo(assessformDy, showParameter);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        this.getView().updateControlMetadata(assTableFlex.getKey(), assTableFlex.createControl());
    }

    private boolean isHiddenArea(String formId, Long areaInstanceId) {
        boolean isHidden = false;
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)formId);
        if (serviceHelper.generateEmptyDynamicObject().containsProperty("entryentity")) {
            DynamicObject tableItemDyn = serviceHelper.queryOne("entryentity", (Object)areaInstanceId);
            if (tableItemDyn == null) {
                isHidden = true;
            } else {
                DynamicObjectCollection entryEntitys = tableItemDyn.getDynamicObjectCollection("entryentity");
                if (ObjectUtils.isEmpty((Object)entryEntitys)) {
                    isHidden = true;
                }
            }
        }
        return isHidden;
    }

    protected void setAssessFormParamInfo(DynamicObject assessFormDy, BaseShowParameter showParameter) {
        showParameter.setCustomParam("ruleid", (Object)assessFormDy.getLong("id"));
        showParameter.setCustomParam("scorecalcway", (Object)assessFormDy.getString("scorecalcway"));
        showParameter.setCustomParam("evalway", (Object)assessFormDy.getString("evalway"));
        showParameter.setCustomParam("numaccuracy", (Object)assessFormDy.getString("numaccuracy"));
        showParameter.setCustomParam("scoresystem", (Object)assessFormDy.getDynamicObject("scoresystem").getLong("id"));
        showParameter.setCustomParam("scaletype", (Object)assessFormDy.getString("scaletype"));
        showParameter.setCustomParam("issupcalcsum", (Object)assessFormDy.getBoolean("issupcalcsum"));
        showParameter.setCustomParam("consistentwitharea", (Object)assessFormDy.getBoolean("consistentwitharea"));
    }

    protected void showSumAreaView(DynamicObject assessformDy) {
        Set<String> showAreaNotShowFieldSet;
        DynamicObject sumperflevel;
        DynamicObject sumConf = APP_SERVICE.querySumConfInfoById(assessformDy.getLong("sumconf"));
        boolean isShowInFlow = sumConf.getBoolean("isshowinflow");
        this.getView().setVisible(Boolean.valueOf(isShowInFlow), new String[]{"sumareaflex", "topsumareaap"});
        if (!isShowInFlow) {
            return;
        }
        String areacustname = sumConf.getString("areacustname");
        Label sumareanamelab = (Label)this.getControl("sumareanamelab");
        sumareanamelab.setText(areacustname);
        DynamicObjectCollection fieldInfos = sumConf.getDynamicObjectCollection("entryentity");
        for (DynamicObject fieldInfo : fieldInfos) {
            String fieldName;
            DynamicObject filed = fieldInfo.getDynamicObject("areafield");
            String filedKey = filed.getString("number");
            String fieldCustName = fieldInfo.getString("fieldcustname");
            String string = fieldName = StringUtils.isEmpty((CharSequence)fieldCustName) ? filed.getString("name") : fieldCustName;
            if (HRStringUtils.equals((String)"ose", (String)filedKey)) {
                Label labelap = (Label)this.getControl("labelap");
                labelap.setText(fieldName);
                continue;
            }
            if (!HRStringUtils.equals((String)"ole", (String)filedKey)) continue;
            Label labelap1 = (Label)this.getControl("labelap1");
            labelap1.setText(fieldName);
            if (fieldInfo.getBoolean("isshow") || this.getView().getParentView().getPageId().contains("confirmlist") || !ListUtils.isCurrentUser(this.getView().getModel().getDataEntity().getLong("person.id"))) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{"bottomlopflex", "oseline", "toploplabel", "mposeline", "topmploplabel"});
        }
        String desc = sumConf.getString("description");
        if (HRStringUtils.isNotEmpty((String)desc)) {
            String content = ResManager.loadKDString((String)"\u63cf\u8ff0\uff1a{0}", (String)"ConfirmEvalRecordBaseEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc});
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setTitle(new LocaleString(areacustname));
            tips.setTriggerType("hover");
            tips.setType("text");
            tips.setContent(new LocaleString(content));
            tips.setIconClassName("kdfont kdfont-gengduo2");
            tips.setPlace("right");
            props.put("tips", tips);
            this.getView().updateControlMetadata("sumareanamelab", props);
        }
        if (Objects.isNull(sumperflevel = assessformDy.getDynamicObject("sumperflevel"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bottomlopflex", "oseline", "toploplabel", "mposeline", "topmploplabel"});
        }
        if ((showAreaNotShowFieldSet = ListUtils.getShowAreaNotShowFieldSet(this.getView(), (Long)5L)) != null && showAreaNotShowFieldSet.contains("ole")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bottomlopflex", "oseline", "toploplabel", "mposeline", "topmploplabel"});
        }
        this.setSopAndOle(assessformDy);
        MpInfoHelper.topMpSumAreaApHandle(this.getView());
    }

    protected void setSopAndOle(DynamicObject ruleDy) {
        int numAccuracy = ruleDy.getInt("numaccuracy");
        int roundingMode = ScalaTypeEnum.get((String)ruleDy.getString("scaletype")).getType();
        BigDecimal cfsop = this.getModel().getDataEntity().getBigDecimal(AssessScoreAbbrEnum.CFSOP.getCode()).setScale(numAccuracy, roundingMode);
        String cflop = this.getModel().getDataEntity().getString(AssessScoreAbbrEnum.CFLOP.getCode());
        long assessNodeId = this.getModel().getDataEntity().getLong("assessnode.id");
        if (assessNodeId == AssessNodeStatusEnum.EVALUATED.getNodeId()) {
            cfsop = this.getModel().getDataEntity().getBigDecimal(AssessScoreAbbrEnum.SOP.getCode()).setScale(numAccuracy, roundingMode);
            cflop = this.getModel().getDataEntity().getString(AssessScoreAbbrEnum.LOP.getCode());
        }
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule((Long)ruleDy.getPkValue());
        String finalCflop = cflop;
        ComboItem comboItem = perfLevelItems.stream().filter(item -> HRStringUtils.equals((String)finalCflop, (String)item.getValue())).findAny().orElse(null);
        String cflopStr = comboItem == null ? "-" : comboItem.getCaption().getLocaleValue();
        this.setLabelText("bottomsoplabel", cfsop.toPlainString());
        this.setLabelText("bottomloplabel", cflopStr);
        BigDecimal fsop = this.getModel().getDataEntity().getBigDecimal(AssessScoreAbbrEnum.FSOP.getCode()).setScale(numAccuracy, roundingMode);
        String flop = this.getModel().getDataEntity().getString(AssessScoreAbbrEnum.FLOP.getCode());
        ComboItem flopComboItem = perfLevelItems.stream().filter(item -> HRStringUtils.equals((String)flop, (String)item.getValue())).findAny().orElse(null);
        String flopStr = flopComboItem == null ? "-" : flopComboItem.getCaption().getLocaleValue();
        this.setLabelText("topsoplabel", fsop.toPlainString());
        this.setLabelText("toploplabel", flopStr);
        this.setLabelText("topmpsoplabel", fsop.toPlainString());
        this.setLabelText("topmploplabel", flopStr);
        if (HRStringUtils.equals((String)"-", (String)cflopStr)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bottomlopflex"});
        }
        if (HRStringUtils.equals((String)"-", (String)flopStr)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"oseline", "toploplabel", "mposeline", "topmploplabel"});
        }
    }

    protected boolean isShowApprovalRecord(DynamicObject evalObj) {
        QFilter entitynumberFilter;
        QFilter businessKeyFilter;
        HRBaseServiceHelper serviceHelper;
        DynamicObject historicalProcessesDyn;
        if (!this.getView().getParentView().getPageId().contains("confirmlist")) {
            return false;
        }
        List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)String.valueOf(evalObj.getLong("id")));
        if (ObjectUtils.isEmpty((Object)allApprovalRecord)) {
            return false;
        }
        String nodeStatus = evalObj.getString("nodestatus");
        if (HRStringUtils.equals((String)AssessNodeStatusEnum.CONFIRMING.getStatus(), (String)nodeStatus) && !WorkflowServiceHelper.inProcess((String)String.valueOf(evalObj.getLong("id")))) {
            return false;
        }
        if (HRStringUtils.equals((String)AssessNodeStatusEnum.TERMINATE.getStatus(), (String)nodeStatus)) {
            return false;
        }
        return !HRStringUtils.equals((String)AssessNodeStatusEnum.CONFIRMED.getStatus(), (String)nodeStatus) && !HRStringUtils.isEmpty((String)nodeStatus) || (historicalProcessesDyn = (serviceHelper = HRBaseServiceHelper.create((String)"wf_historicalprocesses")).queryOriginalOne("endtype", new QFilter[]{businessKeyFilter = new QFilter("businesskey", "=", (Object)String.valueOf(evalObj.getLong("id"))), entitynumberFilter = new QFilter("entitynumber", "=", (Object)"epa_actevalobj_confirm")}, "modifydate desc")) != null && "10".equals(historicalProcessesDyn.getString("endtype"));
    }
}

