/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.cardentry.CardEntry;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.utils.ScoreAndLevelUtils;

public class ConfirmRecordTplPlugin
extends AbstractBasePlugIn {
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    protected static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    protected static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();

    public void afterCreateNewData(EventObject e) {
        DynamicObject node;
        super.afterCreateNewData(e);
        Long actevalObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actevalobj");
        Object[] confirmRecords = ACTIVITY_RECORD_ENTITY.queryRecordsByEvalIdAndNodeId(actevalObjId, AssessNodeStatusEnum.CONFIRMING.getNodeId());
        if (ObjectUtils.isEmpty((Object[])confirmRecords)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("nodestatus", new Object[0]);
        vs.addField("label", new Object[0]);
        vs.addField("ose", new Object[0]);
        vs.addField("ole", new Object[0]);
        vs.addField("confirmdate", new Object[0]);
        DynamicObject[] evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjWithScoreById(Collections.singletonList(actevalObjId));
        DynamicObject evalObj = evalObjs[0];
        long activityId = evalObj.getDynamicObject("activity").getLong("id");
        Long perfLevelId = evalObj.getLong("cfloplevel.id");
        HashMap levelMap = new HashMap(16);
        if (perfLevelId != null && perfLevelId != 0L) {
            Map<Long, Map<String, String>> perfLevelIdLevelSeqLevelNameMap = ScoreAndLevelUtils.getPerfLevelIdLevelSeqLevelNameMap(activityId, "seq", "levelname");
            levelMap = perfLevelIdLevelSeqLevelNameMap.get(perfLevelId) != null ? perfLevelIdLevelSeqLevelNameMap.get(perfLevelId) : levelMap;
        }
        ScoreAndLevelUtils.cacheScoreConfig(this.getView(), activityId);
        Integer numAccuracy = Integer.parseInt(this.getView().getPageCache().get("numAccuracy"));
        String scaleType = this.getView().getPageCache().get("scaleType");
        for (Object recordDy : confirmRecords) {
            AssessNodeStatusEnum assessNodeStatusEnum = AssessNodeStatusEnum.getEnumByIdAndStatus((Long)AssessNodeStatusEnum.CONFIRMING.getNodeId(), (String)recordDy.getString("nodestatus"));
            String labelStr = ResManager.loadKDString((String)"\u786e\u8ba4\u7ed3\u679c\uff1a", (String)"ConfirmRecordTplPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            BigDecimal ose = recordDy.getBigDecimal("ose").setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType());
            String ole = (String)levelMap.get(recordDy.getString("ole"));
            Date confirmDate = recordDy.getDate("endtime");
            vs.addRow(new Object[]{assessNodeStatusEnum.getText(), labelStr, ose, this.getOle(ole), confirmDate});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
        Object startConfirmRecord = confirmRecords[0];
        this.getModel().setValue("startose", (Object)startConfirmRecord.getBigDecimal("ose").setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()));
        this.getModel().setValue("startole", (Object)this.getOle((String)levelMap.get(startConfirmRecord.getString("ole"))));
        this.getModel().setValue("startdate", (Object)startConfirmRecord.getDate("endtime"));
        Object endConfirmRecord = confirmRecords[confirmRecords.length - 1];
        this.getModel().setValue("endose", (Object)endConfirmRecord.getBigDecimal("ose").setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()));
        this.getModel().setValue("endole", (Object)this.getOle((String)levelMap.get(endConfirmRecord.getString("ole"))));
        this.getModel().setValue("enddate", (Object)endConfirmRecord.getDate("endtime"));
        if (perfLevelId == null || perfLevelId == 0L) {
            this.getView().getPageCache().put("isHiddenOle", "true");
        }
        if ((node = evalObj.getDynamicObject("assessnode")) != null && AssessNodeStatusEnum.CONFIRMING.getNodeId().longValue() == node.getLong("id") && (HRStringUtils.equals((String)AssessNodeStatusEnum.CONFIRMING.getStatus(), (String)evalObj.getString("nodestatus")) || HRStringUtils.equals((String)AssessNodeStatusEnum.TO_BE_APPEAL.getStatus(), (String)evalObj.getString("nodestatus")) || HRStringUtils.equals((String)AssessNodeStatusEnum.TERMINATE.getStatus(), (String)evalObj.getString("nodestatus")))) {
            this.getView().getPageCache().put("isHiddenLast", "true");
        }
    }

    private String getOle(String ole) {
        if (ole == null) {
            ole = "-";
        }
        return ole;
    }

    public void afterBindData(EventObject e) {
        int length;
        String isHiddenLast;
        super.afterBindData(e);
        CardEntry recordCard = (CardEntry)this.getView().getControl("entryentity");
        String isHiddenOle = this.getView().getPageCache().get("isHiddenOle");
        if (HRStringUtils.equals((String)"true", (String)isHiddenOle)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap2", "startole", "labelap22", "endole"});
            for (int i = 0; i < recordCard.getEntryData().getEndIndex(); ++i) {
                recordCard.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"labelap21", "ole"});
            }
        }
        if (HRStringUtils.equals((String)"true", (String)(isHiddenLast = this.getView().getPageCache().get("isHiddenLast")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2", "labelap511", "labelap5111"});
        }
        if ((length = recordCard.getEntryData().getEndIndex()) > 5) {
            HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(16);
            map.put("h", new LocaleString("200px"));
            this.getView().updateControlMetadata("flexpanelap1", map);
        }
        String labelHeight = 10 + length * 32 + "px";
        HashMap<String, LocaleString> map1 = new HashMap<String, LocaleString>(16);
        map1.put("h", new LocaleString(labelHeight));
        this.getView().updateControlMetadata("labelap511", map1);
    }
}

