/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import org.apache.commons.collections.MapUtils;

public class ConfirmTplPlugin
extends AbstractBasePlugIn {
    private static final Log LOG = LogFactory.getLog(ConfirmTplPlugin.class);
    private static final String CONFIRM_URGE = "confirm_urge";
    private static final String CONFIRM_STARTUP = "confirm_startup";
    private static final String CONFIRM_RECONFIRM = "confirm_reconfirm";
    private static final String EXPORT_EXCEL = "exportexcel";
    private static final String IS_SUCCESS = "isSuccess";
    private static final String LABELAP1 = "labelap1";
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        JSONObject resultData = (JSONObject)parameter.getCustomParam("resultDate");
        if (Objects.isNull(resultData)) {
            return;
        }
        String operationType = (String)parameter.getCustomParam("operationType");
        if (StringUtils.isEmpty((String)operationType)) {
            return;
        }
        this.setModelContentByStartTask(MapUtils.getMap((Map)resultData, (Object)"data"));
    }

    private void setModelContentByStartTask(Map<String, Object> data) {
        DynamicObject[] evaObjs;
        Integer totalcount = MapUtils.getInteger(data, (Object)"totalcount");
        Integer sucesscount = MapUtils.getInteger(data, (Object)"sucesscount");
        Integer failcount = MapUtils.getInteger(data, (Object)"failcount");
        Label totalnumlap = (Label)this.getControl("totalnumlap");
        totalnumlap.setText(this.setNull2Zero(totalcount));
        Label sucessnumlab = (Label)this.getControl("sucessnumlab");
        sucessnumlab.setText(this.setNull2Zero(sucesscount));
        Label failnumlap = (Label)this.getControl("failnumlap");
        failnumlap.setText(this.setNull2Zero(failcount));
        Long[] evaObjIds = (Long[])((JSONArray)data.get("id")).toArray((Object[])new Long[0]);
        Map validateMap = (Map)data.get("failMessageMap");
        HashMap<Long, DynamicObject> evaObjMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject evaObj : evaObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(Arrays.asList(evaObjIds))) {
            evaObjMap.put(evaObj.getLong("id"), evaObj);
        }
        int i = 1;
        for (Long evaObjId : evaObjIds) {
            String errMsg = (String)validateMap.get(evaObjId);
            if (errMsg != null) {
                DynamicObject evaObj = (DynamicObject)evaObjMap.get(evaObjId);
                String name = evaObj.getString("perffile.name");
                String number = evaObj.getString("perffile.billno");
                Label labelap1 = (Label)this.getControl(LABELAP1 + i);
                labelap1.setText(MessageFormat.format("{0}{1}\uff1a{2}", name, number, errMsg));
                ++i;
            }
            if (i > 5) break;
        }
    }

    private String setNull2Zero(Integer num) {
        return Objects.isNull(num) ? "0" : num.toString();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (EXPORT_EXCEL.equals(operateKey)) {
            this.exportExcel();
        }
    }

    private void exportExcel() {
        String excelName = ResManager.loadKDString((String)"\u5f15\u51fa\u5217\u8868_\u64cd\u4f5c\u7ed3\u679c_{0}", (String)"ConfirmTplPlugin_0", (String)HRDateTimeUtils.format((Date)new Date()), (Object[])new Object[]{"ConfirmTplPlugin_0", "opmc-epa-formplugin"});
        List<HRExportHeadObject> headDataList = this.getExportHead();
        List<Map<String, Object>> exportDataList = this.getExportData();
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, exportDataList, headDataList);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    private List<HRExportHeadObject> getExportHead() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        headDataList.add(new HRExportHeadObject("operateKey", ResManager.loadKDString((String)"\u64cd\u4f5c\u4fe1\u606f", (String)"ConfirmTplPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject(IS_SUCCESS, ResManager.loadKDString((String)"\u72b6\u6001", (String)"ConfirmTplPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("return_str", ResManager.loadKDString((String)"\u5904\u7406\u7ed3\u679c", (String)"ConfirmTplPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        return headDataList;
    }

    private List<Map<String, Object>> getExportData() {
        DynamicObject[] evaObjs;
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(10);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String operationType = (String)parameter.getCustomParam("operationType");
        if (HRStringUtils.equals((String)operationType, (String)CONFIRM_URGE)) {
            operationType = ResManager.loadKDString((String)"\u50ac\u529e", (String)"ConfirmTplPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        } else if (HRStringUtils.equals((String)operationType, (String)CONFIRM_STARTUP)) {
            operationType = ResManager.loadKDString((String)"\u542f\u52a8\u786e\u8ba4", (String)"ConfirmTplPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        } else if (HRStringUtils.equals((String)operationType, (String)CONFIRM_RECONFIRM)) {
            operationType = ResManager.loadKDString((String)"\u518d\u6b21\u53d1\u8d77", (String)"ConfirmTplPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        }
        JSONObject resultDate = (JSONObject)parameter.getCustomParam("resultDate");
        Map data = MapUtils.getMap((Map)resultDate, (Object)"data");
        Long[] evaObjIds = (Long[])((JSONArray)data.get("id")).toArray((Object[])new Long[0]);
        Map validateMap = (Map)data.get("failMessageMap");
        HashMap<Long, DynamicObject> evaObjMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : evaObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(Arrays.asList(evaObjIds))) {
            evaObjMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        for (Long l : evaObjIds) {
            DynamicObject evaObj = (DynamicObject)evaObjMap.get(l);
            String name = evaObj.getString("perffile.name");
            String number = evaObj.getString("perffile.billno");
            HashMap<String, String> row = new HashMap<String, String>(16);
            row.put("operateKey", operationType);
            String isSuccessStr = ResManager.loadKDString((String)"\u6210\u529f", (String)"ConfirmTplPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            String isSuccessMsg = MessageFormat.format("{0}{1}\uff1a{2}", name, number, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ConfirmTplPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            String errMsg = (String)validateMap.get(l);
            if (errMsg != null) {
                isSuccessStr = ResManager.loadKDString((String)"\u5931\u8d25", (String)"ConfirmTplPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                isSuccessMsg = MessageFormat.format("{0}{1}\uff1a{2}", name, number, errMsg);
            }
            row.put(IS_SUCCESS, isSuccessStr);
            row.put("return_str", isSuccessMsg);
            exportDataList.add(row);
        }
        return exportDataList;
    }
}

