/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.common.constants.PerformSummaryConstants;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.utils.ScoreAndLevelUtils;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ConfirmUpdateTplBasePlugin
extends AbstractBasePlugIn
implements IConfirmCallBack {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initScoreAndLevelStyle();
        this.initScoreAndLevel();
    }

    protected void initScoreAndLevelStyle() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        ScoreAndLevelUtils.cacheScoreConfig(this.getView(), activityId);
        String numAccuracy = this.getPageCache().get("numAccuracy");
        if (HRStringUtils.isNotEmpty((String)numAccuracy)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            formShowParameter.setCustomParam("numaccuracy", (Object)numAccuracy);
            this.getView().updateControlMetadata("scorefield", DrawAreaUtils.getPcScItemMap(formShowParameter));
        }
        Map<Long, Map<String, String>> perfLevelIdLevelSeqLevelNameMap = ScoreAndLevelUtils.getPerfLevelIdLevelSeqLevelNameMap(activityId, "seq", "levelname");
        String perfLevelId = (String)this.getView().getFormShowParameter().getCustomParam("cfloplevel.id");
        if (perfLevelId != null && !HRStringUtils.equals((String)perfLevelId, (String)"0")) {
            Map<String, String> levelMap = perfLevelIdLevelSeqLevelNameMap.get(Long.valueOf(perfLevelId));
            if (!HRMapUtils.isEmpty(levelMap)) {
                ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
                for (Map.Entry<String, String> seqLevelNameEntry : levelMap.entrySet()) {
                    ComboItem item = new ComboItem();
                    item.setId(seqLevelNameEntry.getKey());
                    item.setCaption(new LocaleString(seqLevelNameEntry.getValue()));
                    item.setValue(seqLevelNameEntry.getKey());
                    combos.add(item);
                }
                ComboEdit comboEdit = (ComboEdit)this.getControl("levelfield");
                comboEdit.setComboItems(combos);
                comboEdit.setMustInput(true);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"levelfield"});
        }
    }

    protected void initScoreAndLevel() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BigDecimal sscore = (BigDecimal)formShowParameter.getCustomParam("sscore");
        this.getModel().setValue("scorefield", (Object)sscore);
        String levelSeq = (String)formShowParameter.getCustomParam("levelSeq");
        this.getModel().setValue("levelfield", (Object)levelSeq);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("scorefield".equals(propertyName)) {
            this.scoreFieldChangeHandle(e);
            this.getModel().setDataChanged(true);
        }
    }

    private void scoreFieldChangeHandle(PropertyChangedArgs e) {
        BigDecimal newScore = (BigDecimal)e.getChangeSet()[0].getNewValue();
        if (newScore == null) {
            return;
        }
        String maxscore = this.getPageCache().get("maxscore");
        String minscore = this.getPageCache().get("minscore");
        BigDecimal maxscoreBig = StringUtils.isEmpty((CharSequence)maxscore) ? new BigDecimal(9999) : new BigDecimal(maxscore);
        BigDecimal minscoreBig = StringUtils.isEmpty((CharSequence)minscore) ? BigDecimal.ZERO : new BigDecimal(minscore);
        String cfSopSource = (String)this.getView().getFormShowParameter().getCustomParam("cfsopsource");
        if (HRStringUtils.equals((String)cfSopSource, (String)AssessScoreAbbrEnum.MPSOP.getCode())) {
            maxscoreBig = PerformSummaryConstants.MAX_SCORE_BIG;
            minscoreBig = PerformSummaryConstants.MIN_SCORE_BIG;
        }
        if (newScore.compareTo(minscoreBig) >= 0 && newScore.compareTo(maxscoreBig) <= 0) {
            String actPerfLevelId = (String)this.getView().getFormShowParameter().getCustomParam("cfloplevel.id");
            String actScoreSystemId = (String)this.getView().getFormShowParameter().getCustomParam("cfsopscoresystem.id");
            if (actPerfLevelId != null && !HRStringUtils.equals((String)actPerfLevelId, (String)"0") && actScoreSystemId != null && !HRStringUtils.equals((String)actScoreSystemId, (String)"0")) {
                String levelSeq = ScoreAndLevelUtils.calculateLevel(Long.valueOf(actScoreSystemId), Long.valueOf(actPerfLevelId), newScore);
                this.getModel().setValue("levelfield", (Object)levelSeq);
            }
        } else {
            this.getModel().setValue("scorefield", null);
            this.getView().showFieldTip(new FieldTip(FieldTip.FieldTipType.Error, "scorefield", String.format("%s[%s~%s]", ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u8bc4\u5206\u9650\u5236\u6700\u4f4e/\u6700\u9ad8\u5206\u8303\u56f4", (String)"ConfirmUpdateTplBasePlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), minscoreBig.stripTrailingZeros().toPlainString(), maxscoreBig.stripTrailingZeros().toPlainString())));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String resultMsg = ListUtils.permCheck();
        if (!HRStringUtils.isEmpty((String)resultMsg)) {
            this.getView().showErrorNotification(resultMsg);
            args.setCancel(true);
            return;
        }
        String validateMsg = this.validate();
        if (!HRStringUtils.isEmpty((String)validateMsg)) {
            this.getView().showTipNotification(validateMsg);
            args.setCancel(true);
        }
    }

    protected void mustInputValidate(BeforeDoOperationEventArgs args, String levelKey) {
        StringBuilder errorMsg = new StringBuilder();
        String level = (String)this.getModel().getValue("levelfield");
        String perfLevelId = (String)this.getView().getFormShowParameter().getCustomParam("cfloplevel.id");
        if (perfLevelId != null && !HRStringUtils.equals((String)perfLevelId, (String)"0") && HRStringUtils.isEmpty((String)level)) {
            if (errorMsg.length() != 0) {
                errorMsg.append("\u3001");
            }
            errorMsg.append(levelKey);
        }
        if (errorMsg.length() > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199{0}\u3002", (String)"ConfirmUpdateTplBasePlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{errorMsg.toString()}));
        }
    }

    protected abstract String validate();

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        ListUtils.beforeClosed(e, this.getView(), this, true);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }
}

