/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.process.ProcessExecuteApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.utils.DateUtils;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.epa.formplugin.web.utils.ActManageUtils;

public class ConfirmedList
extends EvalObjBaseList {
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final String OPERATION = "operation";
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final ProcessExecuteApplicationService PROCESS_EXECUTE_APPLICATION_SERVICE = ProcessExecuteApplicationService.getInstance();
    private Map<Long, List<DynamicObject>> activityRecordMap = new HashMap<Long, List<DynamicObject>>(16);

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListUtils.filterContainerInit(this.getView(), args);
    }

    public void setFilter(SetFilterEvent filterEvent) {
        ListUtils.specialFilterHandle(this.getView(), filterEvent.getQFilters(), AssessScoreAbbrEnum.CFLOP.getCode());
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Tuple booleanBooleanTuple = PROCESS_EXECUTE_APPLICATION_SERVICE.queryIsLastNodeNActEnd(activityId, AssessNodeStatusEnum.CONFIRMED);
        if (((Boolean)booleanBooleanTuple.item1).booleanValue()) {
            List qFilters = filterEvent.getQFilters();
            QFilter qFilter = new QFilter("assessstaus", "=", (Object)AssessStausEnum.COMPLETED.getStatus());
            qFilter.and(new QFilter("activity", "=", (Object)activityId));
            qFilters.add(qFilter);
            filterEvent.setOrderBy("modifytime desc,perffile.billno  asc");
            return;
        }
        List objIds = ACTIVITY_RECORD_ENTITY.queryEvalObjIdByActivityIdAndNode(activityId, AssessNodeStatusEnum.CONFIRMED);
        QFilter filter = new QFilter("id", "in", (Object)objIds);
        filterEvent.getQFilters().add(filter);
        filterEvent.setOrderBy("modifytime desc,perffile.billno  asc");
    }

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        DynamicObjectCollection pageData = dataEvent.getPageData();
        List actObjIds = pageData.stream().map(actObj -> actObj.getLong("id")).collect(Collectors.toList());
        this.activityRecordMap = EVALUATION_OBJECT_APPLICATION_SERVICE.queryActRecordByActObjIds(actObjIds);
    }

    public void packageData(PackageDataEvent evt) {
        Object source = evt.getSource();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)source;
        switch (columnDesc.getKey()) {
            case "assessendtime": {
                this.setActRecordFormatValue("endtime", evt);
                break;
            }
            case "assessstarttime": {
                this.setActRecordFormatValue("createtime", evt);
                break;
            }
            case "operation": {
                this.setOperationFormatValue(evt);
                break;
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        ListUtils.listGradeFormatHandle(args, this.getView(), AssessScoreAbbrEnum.CFSOP.getCode(), AssessScoreAbbrEnum.CFLOP.getCode(), "cfloplevel.id");
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        ListUtils.decimalDisplayeFormatHandle(args, this.getView(), AssessScoreAbbrEnum.CFSOP.getCode());
        ListUtils.cycleTypeHandle(args, this.getView());
    }

    private void setActRecordFormatValue(String key, PackageDataEvent dataEvent) {
        DynamicObject actEvalObj = dataEvent.getRowData();
        List<DynamicObject> actRecords = this.activityRecordMap.get(actEvalObj.getLong("id"));
        if (CollectionUtils.isEmpty(actRecords)) {
            return;
        }
        actRecords.stream().filter(actRecord -> actRecord.getLong("assessnode") == AssessNodeStatusEnum.CONFIRMED.getNodeId().longValue()).filter(actRecord -> HRStringUtils.equals((String)actRecord.getString("nodestatus"), (String)AssessNodeStatusEnum.CONFIRMED.getStatus()) || HRStringUtils.equals((String)actRecord.getString("nodestatus"), (String)AssessNodeStatusEnum.END_CONFIRM.getStatus())).findFirst().ifPresent(actRecord -> dataEvent.setFormatValue((Object)DateUtils.formatTimeUser((Date)actRecord.getDate(key))));
    }

    private void setOperationFormatValue(PackageDataEvent dataEvent) {
        dataEvent.setFormatValue((Object)ResManager.loadKDString((String)"\u67e5\u770b\u786e\u8ba4\u8bb0\u5f55", (String)"ConfirmedList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListUtils.billListHyperLinkClick(args, this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String resultMsg = ListUtils.permCheck();
        if (!HRStringUtils.isEmpty((String)resultMsg)) {
            this.getView().showErrorNotification(resultMsg);
            args.setCancel(true);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = evt.getOperateKey()) {
            case "refresh": {
                ActManageUtils.refreshConfirmCount(this.getView());
                break;
            }
        }
    }
}

