/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.workflow.api.BizProcessStatus;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetScoreRecordDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.utils.DateUtils;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.epa.formplugin.web.utils.ActManageUtils;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;

public class ConfirmingList
extends EvalObjBaseList {
    private static final Log log = LogFactory.getLog(ConfirmingList.class);
    private static final String CONFIRM_URGE = "confirm_urge";
    private static final String CONFIRM_UPDATERESULT = "confirm_updateresult";
    private static final String CONFIRM_RECONFIRM = "confirm_reconfirm";
    private static final String CONFIRM_ENDCONFIRM = "confirm_endconfirm";
    private static final String EPA_CONFIRMUPTRESTPL = "epa_confirmuptrestpl";
    private static final String EPA_CONFIRMENDSINGLETPL = "epa_confirmendsingletpl";
    private static final String EPA_CONFIRMENDMULTITPL = "epa_confirmendmultitpl";
    private static final String OPERATION = "operation";
    private static final Long EPA_CONFIRM_URGE = 1802962625622061056L;
    private static final ObjsetScoreRecordDomainService OBJSET_SCORERECORD_ENTITY_SERVICE = ObjsetScoreRecordDomainService.getInstance();
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private Map<Long, List<DynamicObject>> activityRecordMap = new HashMap<Long, List<DynamicObject>>(16);
    private Map<String, String> approverMap = new HashMap<String, String>(16);
    private Map<String, Object> reasonCache = new HashMap<String, Object>(16);

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListUtils.filterContainerInit(this.getView(), args);
    }

    public void setFilter(SetFilterEvent filterEvent) {
        List qFilters = filterEvent.getQFilters();
        ListUtils.specialFilterHandle(this.getView(), qFilters, AssessScoreAbbrEnum.CFLOP.getCode());
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("nodestatus", "in", (Object)new Object[]{AssessNodeStatusEnum.CONFIRMING.getStatus(), AssessNodeStatusEnum.TO_BE_APPEAL.getStatus(), AssessNodeStatusEnum.APPEALING.getStatus(), AssessNodeStatusEnum.TERMINATE.getStatus()}).and("assessstaus", "=", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus()).and("nodeindex", "=", (Object)nodeIndex);
        qFilters.add(filter);
        filterEvent.setOrderBy("modifytime desc,perffile.billno  asc");
    }

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        DynamicObjectCollection pageData = dataEvent.getPageData();
        List actObjIds = pageData.stream().map(actObj -> actObj.getLong("id")).collect(Collectors.toList());
        this.activityRecordMap = EVALUATION_OBJECT_APPLICATION_SERVICE.queryActRecordByActObjIds(actObjIds);
        String[] businessKeys = actObjIds.stream().map(String::valueOf).collect(Collectors.toList()).toArray(new String[0]);
        Map businessKeyUserIdsMap = WorkflowServiceHelper.getApproversMapByBusinessKeys((String[])businessKeys);
        Map bizProcessStatusMap = WorkflowServiceHelper.getBizProcessStatus((String[])businessKeys);
        bizProcessStatusMap.forEach((key, value) -> {
            BizProcessStatus bizProcessStatus;
            if (CollectionUtils.isNotEmpty((Collection)value) && "2".equals((bizProcessStatus = (BizProcessStatus)value.get(0)).getProcessStatus())) {
                businessKeyUserIdsMap.remove(key);
            }
        });
        Map<Long, Long> businessKeyPersonIdMap = pageData.stream().filter(actObj -> AssessNodeStatusEnum.CONFIRMING.getStatus().equals(actObj.getString("nodestatus"))).filter(actObj -> !businessKeyUserIdsMap.containsKey(String.valueOf(actObj.getLong("id")))).filter(actObj -> !WorkflowServiceHelper.inProcess((String)String.valueOf(actObj.getLong("id")))).collect(Collectors.toMap(actObj -> actObj.getLong("id"), actObj -> actObj.getLong("person.id")));
        Map<Long, Long> personIdUserIdMap = ListUtils.getBosUserIdsByPersonIds(new ArrayList<Long>(businessKeyPersonIdMap.values()));
        businessKeyPersonIdMap.forEach((businessKey, personId) -> businessKeyUserIdsMap.put(businessKey.toString(), Collections.singletonList(personIdUserIdMap.get(personId))));
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        for (List userIdList : businessKeyUserIdsMap.values()) {
            userIds.addAll(userIdList);
        }
        Map<Long, String> userInfoMap = ListUtils.getUserIdNameNumberMapByID(userIds);
        for (Map.Entry entry : businessKeyUserIdsMap.entrySet()) {
            String businessKey2 = (String)entry.getKey();
            List userIdList = (List)entry.getValue();
            String approverStr = "";
            StringBuilder approver = new StringBuilder();
            for (int i = 0; i < userIdList.size(); ++i) {
                Long userId = (Long)userIdList.get(i);
                String userNameUserNumber = userInfoMap.get(userId);
                if (!HRStringUtils.isNotEmpty((String)userNameUserNumber)) continue;
                approver.append(userNameUserNumber);
                approver.append("\uff0c");
            }
            approverStr = approver.indexOf("\uff0c") != -1 ? approver.substring(0, approver.length() - 1) : approver.toString();
            this.approverMap.put(businessKey2, approverStr);
        }
    }

    public void packageData(PackageDataEvent evt) {
        Object source = evt.getSource();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)source;
        switch (columnDesc.getKey()) {
            case "assessstarttime": {
                this.setActRecordFormatValue(evt);
                break;
            }
            case "currenthandler": {
                this.setApproverFormatValue(evt);
                break;
            }
            case "nodestatus": {
                this.setNodeStatusFormatValue(evt);
                break;
            }
            case "operation": {
                this.setOperationFormatValue(evt);
                break;
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        ListUtils.listGradeFormatHandle(args, this.getView(), AssessScoreAbbrEnum.CFSOP.getCode(), AssessScoreAbbrEnum.CFLOP.getCode(), "cfloplevel.id");
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        ListUtils.decimalDisplayeFormatHandle(args, this.getView(), AssessScoreAbbrEnum.CFSOP.getCode());
        ListUtils.cycleTypeHandle(args, this.getView());
    }

    private void setActRecordFormatValue(PackageDataEvent dataEvent) {
        DynamicObject actEvalObj = dataEvent.getRowData();
        List<DynamicObject> actRecords = this.activityRecordMap.get(actEvalObj.getLong("id"));
        if (CollectionUtils.isEmpty(actRecords)) {
            return;
        }
        DynamicObject recordDyn = actRecords.stream().filter(actRecord -> actRecord.getLong("assessnode") == AssessNodeStatusEnum.CONFIRMING.getNodeId().longValue()).filter(actRecord -> HRStringUtils.equals((String)actRecord.getString("nodestatus"), (String)AssessNodeStatusEnum.CONFIRMING.getStatus())).max(Comparator.comparing(obj -> obj.getDate("createtime"))).orElse(null);
        if (recordDyn != null) {
            dataEvent.setFormatValue((Object)DateUtils.formatTimeUser((Date)recordDyn.getDate("createtime")));
        }
    }

    private void setApproverFormatValue(PackageDataEvent dataEvent) {
        DynamicObject actEvalObj = dataEvent.getRowData();
        String businessKey = String.valueOf(actEvalObj.getLong("id"));
        String approver = this.approverMap.get(businessKey);
        if (AssessNodeStatusEnum.CONFIRMING.getStatus().equals(actEvalObj.getString("nodestatus"))) {
            dataEvent.setFormatValue((Object)approver);
        }
    }

    private void setNodeStatusFormatValue(PackageDataEvent dataEvent) {
        DynamicObject actEvalObj = dataEvent.getRowData();
        AssessNodeStatusEnum assessNodeStatusEnum = AssessNodeStatusEnum.getEnumByIdAndStatus((Long)AssessNodeStatusEnum.CONFIRMING.getNodeId(), (String)actEvalObj.getString("nodestatus"));
        dataEvent.setFormatValue((Object)assessNodeStatusEnum.getText());
    }

    private void setOperationFormatValue(PackageDataEvent dataEvent) {
        dataEvent.setFormatValue((Object)ResManager.loadKDString((String)"\u67e5\u770b\u786e\u8ba4\u8bb0\u5f55", (String)"ConfirmingList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        String resultMsg = ListUtils.permCheck();
        if (!HRStringUtils.isEmpty((String)resultMsg)) {
            this.getView().showErrorNotification(resultMsg);
            args.setCancel(true);
            return;
        }
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "viewflowchart": {
                this.viewFlowChartHandle(args);
                break;
            }
            case "confirm_urge": {
                String flag = this.getPageCache().get(CONFIRM_URGE);
                if (HRStringUtils.equals((String)CONFIRM_URGE, (String)flag)) {
                    this.confirmUrge();
                    this.getPageCache().remove(CONFIRM_URGE);
                    break;
                }
                this.handleUrgingTpl();
                args.setCancel(true);
                break;
            }
            case "confirm_updateresult": {
                String updateFlag = this.getPageCache().get(CONFIRM_UPDATERESULT);
                if (HRStringUtils.equals((String)CONFIRM_UPDATERESULT, (String)updateFlag)) {
                    String returnMapStr = this.getPageCache().get("returnMap");
                    Map returnMap = (Map)JSON.parseObject((String)returnMapStr, HashMap.class);
                    this.confirmUpdateResultBack(returnMap, args);
                    this.getPageCache().remove(CONFIRM_UPDATERESULT);
                    this.getPageCache().remove("returnMap");
                    break;
                }
                this.showConfirmUpdateResultPage();
                args.setCancel(true);
                break;
            }
            case "confirm_reconfirm": {
                this.reconfirmHandler();
                break;
            }
            case "confirm_endconfirm": {
                this.showEndConfirmPage();
                break;
            }
        }
    }

    private void viewFlowChartHandle(BeforeDoOperationEventArgs args) {
        if (this.getSelectedRows().size() > 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u53ef\u67e5\u770b\u5355\u6761\u6570\u636e\u6d41\u7a0b\u56fe\u3002", (String)"ConfirmingList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] evalObjs = ListUtils.getEvalObjsWithScore(this.getSelectedRows());
        DynamicObject evalObj = evalObjs[0];
        if (AssessNodeStatusEnum.CONFIRMING.getStatus().equals(evalObj.getString("nodestatus")) && !WorkflowServiceHelper.inProcess((String)String.valueOf(evalObj.getLong("id")))) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"ConfirmingList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = evt.getOperateKey()) {
            case "refresh": {
                ActManageUtils.refreshConfirmCount(this.getView());
                break;
            }
        }
    }

    private void handleUrgingTpl() {
        int size = this.getSelectedRows().size();
        if (size > 0) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9{0}\u4eba\uff0c\u53d1\u8d77\u50ac\u529e\u540e\uff0c\u5bf9\u5e94\u4eba\u5458\u5c06\u6536\u5230\u901a\u77e5\u3002", (String)"ConfirmingList_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]), size);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_URGE, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)CONFIRM_URGE, (String)callBackId)) {
            this.getPageCache().put(CONFIRM_URGE, CONFIRM_URGE);
            this.getView().invokeOperation(CONFIRM_URGE);
        }
    }

    private void confirmUrge() {
        DynamicObject[] evalObjs = ListUtils.getEvalObjsWithScore(this.getSelectedRows());
        HashMap<Long, String> validateMap = new HashMap<Long, String>(16);
        ListUtils.splitBatchHandle(Arrays.asList(evalObjs), 50, subList -> {
            HashMap<Long, DynamicObject> evalObjMap = new HashMap<Long, DynamicObject>(16);
            HashSet<Long> bussinessKeys = new HashSet<Long>(16);
            for (DynamicObject evalObj : subList) {
                long evaObjId = evalObj.getLong("id");
                if (AssessNodeStatusEnum.CONFIRMED.getStatus().equals(evalObj.get("nodestatus"))) {
                    validateMap.put(evaObjId, ResManager.loadKDString((String)"\u7ed3\u679c\u786e\u8ba4\u5df2\u5b8c\u6210\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"ConfirmingList_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                } else if (!AssessNodeStatusEnum.CONFIRMING.getStatus().equals(evalObj.get("nodestatus"))) {
                    validateMap.put(evaObjId, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u72b6\u6001\u4e3a\u201c\u786e\u8ba4\u4e2d\u201d\u7684\u7ee9\u6548\u7ed3\u679c\u8fdb\u884c\u50ac\u529e\u3002", (String)"ConfirmingList_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                } else {
                    bussinessKeys.add(evaObjId);
                }
                evalObjMap.put(evaObjId, evalObj);
            }
            if (!ObjectUtils.isEmpty(bussinessKeys)) {
                DataSet wfExecutionSet = HRDBUtil.queryDataSet((String)"ConfirmingList", (DBRoute)DBRoute.workflow, (String)this.generateWFLSQL(bussinessKeys), null);
                HashSet processInstanceIdSet = new HashSet(16);
                HashMap<Long, Long> insIdEvaIdMap = new HashMap<Long, Long>(16);
                while (wfExecutionSet.hasNext()) {
                    Row row = wfExecutionSet.next();
                    processInstanceIdSet.add(row.getLong("FPROCINSTID"));
                    if (bussinessKeys.contains(row.getLong("FBUSINESSKEY"))) {
                        bussinessKeys.remove(row.getLong("FBUSINESSKEY"));
                    }
                    insIdEvaIdMap.put(row.getLong("FPROCINSTID"), row.getLong("FBUSINESSKEY"));
                }
                ArrayList processInstanceIdList = new ArrayList(processInstanceIdSet);
                if (!ObjectUtils.isEmpty(processInstanceIdList)) {
                    for (Long processInstanceId : processInstanceIdList) {
                        Long evaObjId = (Long)insIdEvaIdMap.get(processInstanceId);
                        DynamicObject evalObjDyn = (DynamicObject)evalObjMap.get(evaObjId);
                        String reminderMsgStr = ResManager.loadKDString((String)"{0}\u4e2d{1}\uff08\u5de5\u53f7\uff1a{2}\uff09\u7684\u7ed3\u679c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002", (String)"ConfirmingList_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                        String activityName = evalObjDyn.getDynamicObject("activity").getLocaleString("name").getLocaleValue();
                        String personName = evalObjDyn.getLocaleString("perffile.name").getLocaleValue();
                        String personNumber = evalObjDyn.getString("perffile.billno");
                        String reminderMsg = MessageFormat.format(reminderMsgStr, activityName, personName, personNumber);
                        Map result = WorkflowServiceHelper.taskReminders((Long)processInstanceId, (ILocaleString)new LocaleString(reminderMsg));
                        String showMsg = (String)result.get("showMsg");
                        String successMsg = ResManager.loadKDString((String)"\u6210\u529f", (String)"ConfirmingList_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                        if (showMsg == null || showMsg.contains(successMsg)) continue;
                        validateMap.put(evaObjId, showMsg);
                    }
                }
            }
            if (!ObjectUtils.isEmpty(bussinessKeys)) {
                ArrayList<Long> personIds = new ArrayList<Long>(10);
                for (Long bussinessKey : bussinessKeys) {
                    DynamicObject evalObj = (DynamicObject)evalObjMap.get(bussinessKey);
                    long personId = evalObj.getLong("person.id");
                    personIds.add(personId);
                }
                Map<Long, Long> personIdUserIdMap = ListUtils.getBosUserIdsByPersonIds(personIds);
                for (Long bussinessKey : bussinessKeys) {
                    DynamicObject evalObj = (DynamicObject)evalObjMap.get(bussinessKey);
                    long personId = evalObj.getLong("person.id");
                    Long userId = personIdUserIdMap.get(personId);
                    ListUtils.sendMessageWithUrl(EPA_CONFIRM_URGE, evalObj, Collections.singletonList(userId), ResManager.loadKDString((String)"\u7ed3\u679c\u786e\u8ba4-\u50ac\u529e", (String)"ConfirmingList_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
            }
        }, subList -> subList.stream().forEach(evalObj -> validateMap.put(evalObj.getLong("id"), ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ConfirmingList_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]))));
        ListUtils.batchResponseHandle(this.getView(), validateMap, CONFIRM_URGE, ResManager.loadKDString((String)"\u50ac\u529e\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"ConfirmingList_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    private String generateWFLSQL(Set<Long> businessKeys) {
        StringBuilder businessKeysBuffer = new StringBuilder("SELECT FPROCINSTID,FBUSINESSKEY FROM T_WF_EXECUTION WHERE FBUSINESSKEY IN (");
        for (Long businessKey : businessKeys) {
            businessKeysBuffer.append("'");
            businessKeysBuffer.append(String.valueOf(businessKey));
            businessKeysBuffer.append("'");
            businessKeysBuffer.append(",");
        }
        businessKeysBuffer.deleteCharAt(businessKeysBuffer.length() - 1);
        businessKeysBuffer.append(")");
        return businessKeysBuffer.toString();
    }

    private void showConfirmUpdateResultPage() {
        int size = this.getSelectedRows().size();
        if (size > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4fee\u6539\u7ed3\u679c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u6761\u6570\u636e\u3002", (String)"ConfirmingList_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] evalObjs = ListUtils.getEvalObjsWithScore(this.getSelectedRows());
        DynamicObject evalObj = evalObjs[0];
        if (AssessNodeStatusEnum.CONFIRMED.getStatus().equals(evalObj.get("nodestatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u679c\u786e\u8ba4\u5df2\u5b8c\u6210\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"ConfirmingList_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!AssessNodeStatusEnum.TO_BE_APPEAL.getStatus().equals(evalObj.get("nodestatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fee\u6539\u72b6\u6001\u4e3a\u201c\u4e0d\u8ba4\u540c\u201d\u7ee9\u6548\u7ed3\u679c\u3002", (String)"ConfirmingList_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        Long personId = evalObj.getLong("person.id");
        Map<Long, Long> personIdUserIdMap = ListUtils.getBosUserIdsByPersonIds(Collections.singletonList(personId));
        Long userId = personIdUserIdMap.get(personId);
        if (!ListUtils.queryUserIsEnable(userId) && !ListUtils.isWorkFlow()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5458\u5de5\u5df2\u5728\u5e73\u53f0\u7981\u7528\u3002", (String)"ConfirmingList_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(EPA_CONFIRMUPTRESTPL);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("actevalobj", (Object)evalObj.getLong("id"));
        showParameter.setCustomParam("activity", (Object)activityId);
        showParameter.setCustomParam("sscore", evalObj.get("cfsop"));
        showParameter.setCustomParam("levelSeq", evalObj.get("cflop"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CONFIRM_UPDATERESULT));
        showParameter.setCustomParam("cfloplevel.id", (Object)String.valueOf(evalObj.getLong("cfloplevel.id")));
        showParameter.setCustomParam("cfsopscoresystem.id", (Object)String.valueOf(evalObj.getLong("cfsopscoresystem.id")));
        showParameter.setCustomParam("cfsopsource", (Object)evalObj.getString("cfsopsource"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        Map<String, Object> returnMap = this.getReturnMap(returnData);
        if (ObjectUtils.isEmpty(returnMap)) {
            return;
        }
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)CONFIRM_UPDATERESULT)) {
            this.getPageCache().put(CONFIRM_UPDATERESULT, CONFIRM_UPDATERESULT);
            this.getPageCache().put("returnMap", JSON.toJSONString(returnMap));
            this.reasonCache.put(this.getView().getPageId(), returnMap.get("reason"));
            this.getView().invokeOperation(CONFIRM_UPDATERESULT);
        }
    }

    private Map<String, Object> getReturnMap(Object returnData) {
        if (returnData == null) {
            return Collections.emptyMap();
        }
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            return result;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmUpdateResultBack(Map<String, Object> returnMap, BeforeDoOperationEventArgs args) {
        Object[] evaluationObjects = ListUtils.getEvalObjsWithScore(this.getSelectedRows());
        if (ObjectUtils.isEmpty((Object[])evaluationObjects)) {
            return;
        }
        Object evalObj = evaluationObjects[0];
        Long personId = evalObj.getLong("person.id");
        Map<Long, Long> personIdUserIdMap = ListUtils.getBosUserIdsByPersonIds(Collections.singletonList(personId));
        Long userId = personIdUserIdMap.get(personId);
        boolean isWorkFlow = ListUtils.isWorkFlow();
        if (!ListUtils.queryUserIsEnable(userId) && !isWorkFlow) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5458\u5de5\u5df2\u5728\u5e73\u53f0\u7981\u7528\u3002", (String)"ConfirmingList_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        try {
            this.dealPartEvalBackResultData((DynamicObject[])evaluationObjects, returnMap);
            OperationResult operationResult = ListUtils.doStartConfirm((DynamicObject)evalObj, isWorkFlow, userId);
            if (!operationResult.isSuccess()) {
                String operationResultErrorMes = ListUtils.getOperationResultErrorMes(operationResult);
                throw new KDBizException(operationResultErrorMes);
            }
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u786e\u8ba4\u6210\u529f\u3002", (String)"ConfirmingList_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            args.setCancel(true);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u52a8\u786e\u8ba4\u5931\u8d25", (String)"ConfirmingList_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void dealPartEvalBackResultData(DynamicObject[] evaluationObjects, Map<String, Object> returnMap) {
        BigDecimal score = (BigDecimal)returnMap.get("score");
        String level = (String)returnMap.get("level");
        Object reason = this.reasonCache.get(this.getView().getPageId());
        DynamicObject evalObj = evaluationObjects[0];
        ListUtils.updateEvalObj(evalObj, score, level, AssessNodeStatusEnum.CONFIRMING);
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        dyColl.add((Object)evalObj);
        OBJSET_SCORERECORD_ENTITY_SERVICE.saveEntityByEval(dyColl, score, level, reason, AssessNodeStatusEnum.CONFIRMING.getNodeId());
        ListUtils.saveEvaluationObject(new DynamicObject[]{evalObj});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListUtils.billListHyperLinkClick(args, this.getView());
    }

    public void reconfirmHandler() {
        DynamicObject[] evaluationObjects = ListUtils.getEvalObjsWithScore(this.getSelectedRows());
        Map<Long, String> validateMap = ListUtils.doStartConfirm(evaluationObjects, evalObj -> {
            if (evalObj.getLong("assessnode.id") != NodeTabMapEnum.RESULT_CONFIRM.getNodeId().longValue() || !HRStringUtils.equals((String)evalObj.getString("nodestatus"), (String)AssessNodeStatusEnum.TO_BE_APPEAL.getStatus())) {
                return ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u72b6\u6001\u4e3a\u201c\u4e0d\u8ba4\u540c\u201d\u7684\u7ee9\u6548\u7ed3\u679c\uff0c\u518d\u6b21\u53d1\u8d77\u786e\u8ba4\u3002", (String)"ConfirmingList_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            }
            return "";
        }, evalObj -> ListUtils.updateEvalObj(evalObj, evalObj.getBigDecimal(AssessScoreAbbrEnum.CFSOP.getCode()), evalObj.getString(AssessScoreAbbrEnum.CFLOP.getCode()), AssessNodeStatusEnum.CONFIRMING));
        ListUtils.batchResponseHandle(this.getView(), validateMap, CONFIRM_RECONFIRM, ResManager.loadKDString((String)"\u518d\u6b21\u53d1\u8d77\u6210\u529f", (String)"ConfirmingList_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void showEndConfirmPage() {
        int size = this.getSelectedRows().size();
        if (size == 1) {
            DynamicObject[] evalObjs = ListUtils.getEvalObjsWithScore(this.getSelectedRows());
            DynamicObject evalObj = evalObjs[0];
            if (AssessNodeStatusEnum.CONFIRMED.getStatus().equals(evalObj.get("nodestatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u679c\u786e\u8ba4\u5df2\u5b8c\u6210\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"ConfirmingList_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!AssessNodeStatusEnum.TERMINATE.getStatus().equals(evalObj.get("nodestatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u53ef\u7ed3\u675f\u786e\u8ba4\u72b6\u6001\u4e3a\u201c\u5df2\u7ec8\u6b62\u201d\u7684\u7ee9\u6548\u7ed3\u679c\u3002", (String)"ConfirmingList_19", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(EPA_CONFIRMENDSINGLETPL);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("actevalobj", (Object)evalObj.getLong("id"));
            showParameter.setCustomParam("activity", (Object)activityId);
            showParameter.setCustomParam("sscore", evalObj.get("cfsop"));
            showParameter.setCustomParam("levelSeq", evalObj.get("cflop"));
            showParameter.setCustomParam("cfloplevel.id", (Object)String.valueOf(evalObj.getLong("cfloplevel.id")));
            showParameter.setCustomParam("cfsopscoresystem.id", (Object)String.valueOf(evalObj.getLong("cfsopscoresystem.id")));
            showParameter.setCustomParam("cfsopsource", (Object)evalObj.getString("cfsopsource"));
            this.getView().showForm(showParameter);
        } else if (size > 1) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Long[] evalObjectIdList = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(EPA_CONFIRMENDMULTITPL);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("actevalobj", (Object)evalObjectIdList);
            showParameter.setCustomParam("activity", (Object)activityId);
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm(showParameter);
        }
    }
}

