/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.dynpermission.DynPermissionConfigService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetScoreRecordDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.vo.dynpermission.ContentAreaEntry;
import kd.opmc.epa.common.vo.dynpermission.ContentFieldEntry;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.epa.common.vo.dynpermission.ScopeAreaEntry;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.info.mp.MpInfoHelper;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.utils.ScoreAndLevelUtils;
import kd.opmc.pbs.business.domain.msg.service.MsgSendDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerDomainService;

public class ListUtils {
    private static final Log log = LogFactory.getLog(ListUtils.class);
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    protected static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final Long EPA_CONFIRM_START = 1802961363883146240L;
    private static final FlowHandlerDomainService FLOW_HANDLER_DOMAIN_SERVICE = FlowHandlerDomainService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final String EPA_CONFIRMTPL = "epa_confirmtpl";
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final HRBaseServiceHelper perService = new HRBaseServiceHelper("epa_processpermsetting");
    public static final String PERM_MAP = "permMap";
    public static final String NOT_SHOW_AREA_SET = "notShowAreaSet";
    public static final String SHOW_AREA_NOT_SHOW_FIELDS_MAP = "showAreaNotShowFieldsMap";
    public static final String SCORE_SHOW_MAP = "scoreShowMap";
    private static final ObjsetScoreRecordDomainService OBJSET_SCORERECORD_ENTITY_SERVICE = ObjsetScoreRecordDomainService.getInstance();
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"ListUtils#&", (int)3, (int)3);

    private ListUtils() {
    }

    public static void filterContainerInit(IFormView view, FilterContainerInitArgs args) {
        Long activityId = (Long)view.getFormShowParameter().getCustomParam("activity");
        DynamicObject activityDyn = ACTIVITY_ENTITY_SERVICE.queryOne("mpsopcategory,isgenextmpsop,isneedmpgenway", (Object)activityId);
        List schemeFilterCols = args.getSchemeFilterColumns();
        Iterator iterator = schemeFilterCols.iterator();
        while (iterator.hasNext()) {
            SchemeFilterColumn schemeFilterColumn = (SchemeFilterColumn)iterator.next();
            String fieldName = schemeFilterColumn.getFieldName();
            if (!HRStringUtils.equals((String)fieldName, (String)"activity.mpsopcategory") || activityDyn != null && MpInfoHelper.isYearMp(activityDyn)) continue;
            iterator.remove();
        }
    }

    public static void specialFilterHandle(IFormView view, List<QFilter> qFilters, String lopKey) {
        Iterator<QFilter> iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            String cp;
            QFilter qFilter = iterator.next();
            String property = qFilter.getProperty();
            if (StringUtils.equals((CharSequence)"confirmstatus", (CharSequence)property)) {
                qFilter.__setProperty("nodestatus");
            }
            if (!StringUtils.equals((CharSequence)"is not null", (CharSequence)(cp = qFilter.getCP()))) continue;
            iterator.remove();
        }
        for (QFilter qFilter : qFilters) {
            String property = qFilter.getProperty();
            Object originValue = qFilter.getOriginValue();
            if (StringUtils.equals((CharSequence)"nodestatus", (CharSequence)property)) {
                HashMap<String, String> assessNodeStatusMap = new HashMap<String, String>(16);
                assessNodeStatusMap.put(AssessNodeStatusEnum.CONFIRMING.getText(), AssessNodeStatusEnum.CONFIRMING.getStatus());
                assessNodeStatusMap.put(AssessNodeStatusEnum.TO_BE_APPEAL.getText(), AssessNodeStatusEnum.TO_BE_APPEAL.getStatus());
                assessNodeStatusMap.put(AssessNodeStatusEnum.APPEALING.getText(), AssessNodeStatusEnum.APPEALING.getStatus());
                assessNodeStatusMap.put(AssessNodeStatusEnum.TERMINATE.getText(), AssessNodeStatusEnum.TERMINATE.getStatus());
                originValue = ListUtils.getFilterRealValue(assessNodeStatusMap, originValue);
            }
            qFilter.__setValue(originValue);
        }
    }

    private static Object getFilterRealValue(Map<String, String> map, Object originValue) {
        ArrayList<String> result = originValue;
        if (!HRMapUtils.isEmpty(map)) {
            List valueList;
            if (originValue instanceof String) {
                String value = (String)((Object)originValue);
                String realValue = map.get(value);
                if (HRStringUtils.isNotEmpty((String)realValue)) {
                    result = realValue;
                }
            } else if (originValue instanceof List && CollectionUtils.isNotEmpty((Collection)(valueList = (List)originValue))) {
                ArrayList<String> realList = new ArrayList<String>(10);
                for (String value : valueList) {
                    String realValue = map.get(value);
                    if (HRStringUtils.isNotEmpty((String)realValue)) {
                        realList.add(realValue);
                        continue;
                    }
                    realList.add(value);
                }
                result = realList;
            }
        }
        return result;
    }

    public static void listGradeFormatHandle(BeforeCreateListDataProviderArgs args, IFormView view, final String sopKey, final String lopKey, final String lopPerfLevelKey) {
        long activityId = (Long)view.getFormShowParameter().getCustomParam("activity");
        final Map<Long, Map<String, String>> perfLevelIdLevelSeqLevelNameMap = ScoreAndLevelUtils.getPerfLevelIdLevelSeqLevelNameMap(activityId, "seq", "levelname");
        ScoreAndLevelUtils.cacheScoreConfig(view, activityId);
        final String numAccuracy = view.getPageCache().get("numAccuracy");
        final String scaleType = view.getPageCache().get("scaleType");
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (!rows.isEmpty()) {
                    for (DynamicObject row : rows) {
                        String lop = row.getString(lopKey);
                        long perfLevelId = row.getLong(lopPerfLevelKey);
                        if (HRStringUtils.isNotEmpty((String)lop) && perfLevelIdLevelSeqLevelNameMap.containsKey(perfLevelId)) {
                            row.set(lopKey, ((Map)perfLevelIdLevelSeqLevelNameMap.get(perfLevelId)).get(lop));
                        }
                        if (!HRStringUtils.isNotEmpty((String)numAccuracy) || !HRStringUtils.isNotEmpty((String)scaleType)) continue;
                        BigDecimal sop = row.getBigDecimal(sopKey);
                        sop = sop.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get((String)scaleType).getType());
                        row.set(sopKey, (Object)sop);
                    }
                }
                return rows;
            }
        });
    }

    public static void decimalDisplayeFormatHandle(BeforeCreateListColumnsArgs args, IFormView view, String sopKey) {
        String numAccuracy = view.getPageCache().get("numAccuracy");
        if (HRStringUtils.isNotEmpty((String)numAccuracy)) {
            int numAccuracyInt = Integer.parseInt(numAccuracy);
            StringBuilder displayFormatStr = new StringBuilder("#");
            for (int i = 0; i < numAccuracyInt; ++i) {
                if (i == 0) {
                    displayFormatStr.append(".");
                }
                displayFormatStr.append("#");
            }
            DecimalListColumn listColumn = (DecimalListColumn)args.getListColumn(sopKey);
            if (listColumn != null) {
                listColumn.setDisplayFormatString(displayFormatStr.toString());
            }
        }
    }

    public static void cycleTypeHandle(BeforeCreateListColumnsArgs args, IFormView view) {
        IListColumn listColumn;
        Long activityId = (Long)view.getFormShowParameter().getCustomParam("activity");
        DynamicObject activityDyn = ACTIVITY_ENTITY_SERVICE.queryOne("mpsopcategory,isgenextmpsop,isneedmpgenway", (Object)activityId);
        if (!(activityDyn != null && MpInfoHelper.isYearMp(activityDyn) || (listColumn = args.getListColumn("activity.mpsopcategory")) == null)) {
            List listColumns = args.getListColumns();
            Iterator iterator = listColumns.iterator();
            while (iterator.hasNext()) {
                IListColumn next = (IListColumn)iterator.next();
                if (!HRStringUtils.equals((String)next.getListFieldKey(), (String)"activity.mpsopcategory")) continue;
                iterator.remove();
            }
        }
    }

    public static boolean isWorkFlow() {
        List enabledProcDefByEntityNumberList = WorkflowServiceHelper.getEnabledProcDefByEntityNumber((String)"epa_actevalobj_confirm");
        return !ObjectUtils.isEmpty((Object)enabledProcDefByEntityNumberList);
    }

    public static OperationResult doStartConfirm(DynamicObject evalObj, boolean isWorkFlow, Long userId) {
        if (isWorkFlow) {
            log.info("\u5de5\u4f5c\u6d41\u542f\u52a8-----------");
            OperationServiceImpl operationService = new OperationServiceImpl();
            return operationService.localInvokeOperation("submit", "epa_actevalobj_confirm", new Object[]{evalObj.getLong("id")}, OperateOption.create());
        }
        log.info("\u65e0\u5de5\u4f5c\u6d41\uff0c\u53d1\u9001\u6d88\u606f\u542f\u52a8-----------");
        ListUtils.sendMessageWithUrl(EPA_CONFIRM_START, evalObj, Collections.singletonList(userId), ResManager.loadKDString((String)"\u7ed3\u679c\u786e\u8ba4-\u542f\u52a8", (String)"ListUtils_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        return new OperationResult();
    }

    public static Map<Long, String> doStartConfirm(DynamicObject[] evaluationObjects, Function<DynamicObject, String> validateFunction, Consumer<DynamicObject> updateEvalObjConsumer) {
        ConcurrentHashMap<Long, String> errorMap = new ConcurrentHashMap<Long, String>(16);
        if (!ObjectUtils.isEmpty((Object[])evaluationObjects)) {
            boolean isWorkFlow = ListUtils.isWorkFlow();
            Map<Object, Object> personIdUserIdMap = new HashMap(16);
            Map<Object, Object> userEnableMap = new HashMap(16);
            if (!isWorkFlow) {
                ArrayList<Long> personIdList = new ArrayList<Long>(10);
                for (DynamicObject evalObj : evaluationObjects) {
                    personIdList.add(evalObj.getLong("person.id"));
                }
                personIdUserIdMap = ListUtils.getBosUserIdsByPersonIds(personIdList);
                userEnableMap = ListUtils.batchQueryUserIsEnable(new ArrayList<Object>(personIdUserIdMap.values()));
            }
            HashMap finalPersonIdUserIdMap = personIdUserIdMap;
            HashMap finalUserEnableMap = userEnableMap;
            ListUtils.splitBatchHandle(Arrays.asList(evaluationObjects), 200, subList -> {
                DynamicObject[] evalObjs;
                ArrayList<DynamicObject> passValidateEvalObjList = new ArrayList<DynamicObject>(10);
                for (DynamicObject evalObj2 : evalObjs = subList.toArray(new DynamicObject[0])) {
                    Long userId;
                    long evaObjId = evalObj2.getLong("id");
                    String failedMes = (String)validateFunction.apply(evalObj2);
                    if (!isWorkFlow && !Boolean.TRUE.equals(finalUserEnableMap.get(userId = (Long)finalPersonIdUserIdMap.get(evalObj2.getLong("person.id"))))) {
                        String userNotExistMsg = ResManager.loadKDString((String)"\u5458\u5de5\u5df2\u5728\u5e73\u53f0\u7981\u7528\u3002", (String)"ListUtils_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                        failedMes = failedMes + userNotExistMsg;
                    }
                    if (HRStringUtils.isNotEmpty((String)failedMes)) {
                        errorMap.put(evaObjId, failedMes);
                        continue;
                    }
                    updateEvalObjConsumer.accept(evalObj2);
                    passValidateEvalObjList.add(evalObj2);
                }
                DynamicObject[] passValidateEvalObjs = passValidateEvalObjList.toArray(new DynamicObject[0]);
                ListUtils.saveEvaluationObject(passValidateEvalObjs);
                OperationResult operationResult = ListUtils.doStartConfirmBatch(passValidateEvalObjs, isWorkFlow, finalPersonIdUserIdMap);
                if (!operationResult.isSuccess()) {
                    String errMsg = ListUtils.getOperationResultErrorMes(operationResult);
                    Arrays.stream(passValidateEvalObjs).forEach(evalObj -> errorMap.put(evalObj.getLong("id"), errMsg));
                }
            }, subList -> subList.stream().forEach(evalObj -> errorMap.put(evalObj.getLong("id"), ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ListUtils_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]))));
        }
        return errorMap;
    }

    public static OperationResult doStartConfirmBatch(DynamicObject[] evalObjs, boolean isWorkFlow, Map<Long, Long> personIdUserIdMap) {
        if (isWorkFlow) {
            log.info("\u5de5\u4f5c\u6d41\u542f\u52a8-----------");
            OperationServiceImpl operationService = new OperationServiceImpl();
            List<Long> evalObjList = Arrays.stream(evalObjs).map(evalObj -> evalObj.getLong("id")).collect(Collectors.toList());
            return operationService.localInvokeOperation("submit", "epa_actevalobj_confirm", (Object[])evalObjList.toArray(new Long[0]), OperateOption.create());
        }
        log.info("\u65e0\u5de5\u4f5c\u6d41\uff0c\u53d1\u9001\u6d88\u606f\u542f\u52a8-----------");
        for (DynamicObject evalObj2 : evalObjs) {
            Long userId = personIdUserIdMap.get(evalObj2.getLong("person.id"));
            if (userId == null) continue;
            ListUtils.sendMessageWithUrl(EPA_CONFIRM_START, evalObj2, Collections.singletonList(userId), ResManager.loadKDString((String)"\u7ed3\u679c\u786e\u8ba4-\u542f\u52a8", (String)"ListUtils_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return new OperationResult();
    }

    public static boolean queryUserIsEnable(Long userId) {
        return FLOW_HANDLER_DOMAIN_SERVICE.queryUserIsEnable(userId);
    }

    public static Map<Long, Boolean> batchQueryUserIsEnable(List<Long> userIds) {
        return FLOW_HANDLER_DOMAIN_SERVICE.batchQueryUserIsEnable(userIds);
    }

    public static void sendMessageWithUrl(Long templateId, DynamicObject evalObj, List<Long> userIds, String tag) {
        HashMap urlParams = Maps.newHashMapWithExpectedSize((int)16);
        urlParams.put("formId", "epa_actevalobj_confirm");
        urlParams.put("pkId", String.valueOf(evalObj.getLong("id")));
        MsgSendDomainService.getInstance().sendMessageWithUrl(templateId, userIds, evalObj, (Map)urlParams, tag);
    }

    public static Map<Long, Long> getBosUserIdsByPersonIds(List<Long> personIds) {
        HashMap<Long, Long> personIduserIdMap = new HashMap<Long, Long>(16);
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(1);
        idMaps.put("person", personIds);
        Map userIdMaps = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        if (Boolean.FALSE.equals(userIdMaps.get("success"))) {
            return personIduserIdMap;
        }
        Map data = (Map)userIdMaps.get("data");
        if (data == null) {
            return personIduserIdMap;
        }
        for (Map.Entry entry : data.entrySet()) {
            Long personId = (Long)entry.getKey();
            Long userId = (Long)((Map)entry.getValue()).get("user");
            personIduserIdMap.put(personId, userId);
        }
        return personIduserIdMap;
    }

    public static String getOperationResultErrorMes(OperationResult operationResult) {
        String errMsg = "";
        if (!operationResult.isSuccess()) {
            ValidateResultCollection validateResult = operationResult.getValidateResult();
            errMsg = ObjectUtils.isEmpty((Object)validateResult) || ObjectUtils.isEmpty((Object)validateResult.getValidateErrors()) || ObjectUtils.isEmpty((Object)validateResult.getMessage()) ? operationResult.getMessage() : ((OperateErrorInfo)((ValidateResult)validateResult.getValidateErrors().get(0)).getAllErrorInfo().get(0)).toString();
        }
        return errMsg;
    }

    public static void saveEvaluationObject(DynamicObject[] evaluationObjects) {
        if (ObjectUtils.isEmpty((Object[])evaluationObjects)) {
            return;
        }
        ArrayList<DynamicObject> activityRecordList = new ArrayList<DynamicObject>(10);
        for (DynamicObject evaluationObject : evaluationObjects) {
            boolean isLastNode;
            DynamicObject activityRecord = ListUtils.generateActivityRecord(evaluationObject);
            activityRecordList.add(activityRecord);
            String nodeStatus = evaluationObject.getString("nodestatus");
            if (!AssessNodeStatusEnum.CONFIRMED.getStatus().equals(nodeStatus) && !AssessNodeStatusEnum.END_CONFIRM.getStatus().equals(nodeStatus)) continue;
            evaluationObject.set("nodestatus", (Object)AssessNodeStatusEnum.CONFIRMED.getStatus());
            int nodeIndex = evaluationObject.getInt("nodeindex");
            DynamicObjectCollection timeplanEntry = evaluationObject.getDynamicObjectCollection("activity.timeplanentry");
            boolean bl = isLastNode = timeplanEntry.size() == nodeIndex;
            if (!isLastNode) continue;
            evaluationObject.set("nodestatus", null);
            evaluationObject.set("assessstaus", (Object)AssessStausEnum.COMPLETED.getStatus());
            evaluationObject.set("assessnode", null);
            evaluationObject.set("nodeindex", null);
            evaluationObject.set("completetime", evaluationObject.get("modifytime"));
        }
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(evaluationObjects);
        ACTIVITY_RECORD_ENTITY.save(activityRecordList.toArray(new DynamicObject[0]));
    }

    private static DynamicObject generateActivityRecord(DynamicObject evaluationObj) {
        log.info(" ----------\u3010\u6784\u5efa\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", evaluationObj.get("assessnode"));
        activityRecord.set("nodestatus", evaluationObj.get("nodestatus"));
        activityRecord.set("nodeindex", evaluationObj.get("nodeindex"));
        activityRecord.set("endtime", evaluationObj.get("modifytime"));
        activityRecord.set("starttype", (Object)"20");
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        activityRecord.set("activity", (Object)evaluationObj.getLong("activity.id"));
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("ose", evaluationObj.get(AssessScoreAbbrEnum.CFSOP.getCode()));
        activityRecord.set("ole", evaluationObj.get(AssessScoreAbbrEnum.CFLOP.getCode()));
        activityRecord.set("creator", evaluationObj.get("modifier"));
        activityRecord.set("createtime", evaluationObj.get("modifytime"));
        activityRecord.set("modifier", evaluationObj.get("modifier"));
        activityRecord.set("modifytime", evaluationObj.get("modifytime"));
        log.info(" ----------\u3010\u6784\u5efa\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5b8c\u6210----------");
        return activityRecord;
    }

    public static void batchResponseHandle(IFormView view, Map<Long, String> validateMap, String operationType, String successTip) {
        ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
        Long[] evalObjectIds = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        if (validateMap == null || validateMap.isEmpty()) {
            view.showSuccessNotification(successTip);
            view.invokeOperation("refresh");
        } else if (evalObjectIds.length == 1) {
            view.showErrorNotification(validateMap.get(evalObjectIds[0]));
        } else {
            ListUtils.showConfirmTplForm(view, validateMap, evalObjectIds, operationType);
        }
    }

    private static void showConfirmTplForm(IFormView view, Map<Long, String> validateMap, Long[] evalObjectIds, String operationType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(EPA_CONFIRMTPL);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map<String, Object> resultMap = ListUtils.buiderResult(validateMap, evalObjectIds);
        showParameter.setCustomParam("resultDate", resultMap);
        showParameter.setCustomParam("operationType", (Object)operationType);
        view.showForm(showParameter);
    }

    private static Map<String, Object> buiderResult(Map<Long, String> validateMap, Long[] evalObjectIds) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        HashMap message = Maps.newHashMapWithExpectedSize((int)16);
        message.put("totalcount", evalObjectIds.length);
        message.put("sucesscount", evalObjectIds.length - validateMap.size());
        message.put("failcount", validateMap.size());
        message.put("id", evalObjectIds);
        message.put("failMessageMap", validateMap);
        resultMap.put("data", message);
        return resultMap;
    }

    public static DynamicObject[] getEvaluationObjects(ListSelectedRowCollection selectedRows) {
        Long[] evalObjectIdList = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        return EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(Arrays.asList(evalObjectIdList));
    }

    public static DynamicObject[] getEvalObjsWithScore(ListSelectedRowCollection selectedRows) {
        Long[] evalObjectIdList = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        return EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjWithScoreById(Arrays.asList(evalObjectIdList));
    }

    public static Map<String, Object> queryPermSettingByPersonId(Long personId, Long activityId, Long nodeId) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (ListUtils.isCurrentUser(personId)) {
            return ListUtils.queryPermSettingNew(activityId, nodeId);
        }
        return result;
    }

    public static boolean isCurrentUser(Long personId) {
        boolean result = false;
        Map<Long, Long> personIdUserIdMap = ListUtils.getBosUserIdsByPersonIds(Collections.singletonList(personId));
        Long userId = personIdUserIdMap.get(personId);
        if (userId != null && userId == UserServiceHelper.getCurrentUserId()) {
            result = true;
        }
        return result;
    }

    public static Map<String, Object> queryPermSettingNew(Long activityId, Long nodeId) {
        long dynamicPermissionId;
        DynPermissionConfigService dynPermissionConfigService;
        DynamicPermissionConfigVO dynamicPermissionConfigVO;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        HashSet<Long> notShowAreaSet = new HashSet<Long>(16);
        HashMap showAreaNotShowFieldsMap = new HashMap(16);
        HashMap<String, String> scoreShowMap = new HashMap<String, String>(16);
        DynamicObject activityDyn = ACTIVITY_ENTITY_SERVICE.queryOriginalOne("dynamicpermission.id", (Object)activityId);
        if (!ObjectUtils.isEmpty((Object)activityDyn) && !ObjectUtils.isEmpty((Object)(dynamicPermissionConfigVO = (dynPermissionConfigService = new DynPermissionConfigService()).getDynamicPermissions(Long.valueOf(dynamicPermissionId = activityDyn.getLong("dynamicpermission.id")), Collections.singletonList(nodeId))))) {
            Map scopeAreaEntriesMap;
            List scopeAreaEntries;
            Map contentAreaEntriesMap = dynamicPermissionConfigVO.getContentAreaEntriesMap();
            List contentAreaEntries = (List)contentAreaEntriesMap.get(nodeId);
            if (CollectionUtils.isNotEmpty((Collection)contentAreaEntries)) {
                Map<Long, String> areaFieldIdNumberMap = ListUtils.queryIdNumberMap("epa_areafieldreg");
                for (ContentAreaEntry contentAreaEntry : contentAreaEntries) {
                    Long areaPageId = contentAreaEntry.getAreapageId();
                    Long areaPageInsid = contentAreaEntry.getAreapageInsId();
                    boolean areaDisplayItem = contentAreaEntry.getAreaDisplay();
                    if (!areaDisplayItem && areaPageInsid != null) {
                        notShowAreaSet.add(areaPageInsid);
                        continue;
                    }
                    List fieldEntries = contentAreaEntry.getFieldEntries();
                    if (!CollectionUtils.isNotEmpty((Collection)fieldEntries)) continue;
                    HashSet<String> notShowFieldSet = new HashSet<String>(16);
                    for (ContentFieldEntry fieldEntry : fieldEntries) {
                        Boolean fieldDisplay = fieldEntry.getFieldDisplay();
                        if (fieldDisplay == null || fieldDisplay.booleanValue() || areaFieldIdNumberMap.get(fieldEntry.getAreaFieldId()) == null) continue;
                        notShowFieldSet.add(areaFieldIdNumberMap.get(fieldEntry.getAreaFieldId()));
                    }
                    showAreaNotShowFieldsMap.put(areaPageInsid, notShowFieldSet);
                    if (areaPageId == 5L) {
                        showAreaNotShowFieldsMap.put(areaPageId, notShowFieldSet);
                        continue;
                    }
                    if (areaPageId != 1L) continue;
                    showAreaNotShowFieldsMap.put(areaPageId, notShowFieldSet);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(scopeAreaEntries = (List)(scopeAreaEntriesMap = dynamicPermissionConfigVO.getScopeAreaEntriesMap()).get(nodeId)))) {
                Map<Long, String> scoreContentIdNumberMap = ListUtils.queryIdNumberMap("epa_scorecontent");
                Map<Long, String> scoreShowAreaIdNumberMap = ListUtils.queryIdNumberMap("epa_scoreshowarea");
                for (ScopeAreaEntry scopeAreaEntry : scopeAreaEntries) {
                    Long scoreContentId = scopeAreaEntry.getScoreContentId();
                    Long scoreShowAreaId = scopeAreaEntry.getScoreShowAreaId();
                    if (scoreContentIdNumberMap.get(scoreContentId) == null || scoreShowAreaIdNumberMap.get(scoreShowAreaId) == null) continue;
                    scoreShowMap.put(scoreContentIdNumberMap.get(scoreContentId), scoreShowAreaIdNumberMap.get(scoreShowAreaId));
                }
            }
        }
        result.put(NOT_SHOW_AREA_SET, notShowAreaSet);
        result.put(SHOW_AREA_NOT_SHOW_FIELDS_MAP, showAreaNotShowFieldsMap);
        result.put(SCORE_SHOW_MAP, scoreShowMap);
        return result;
    }

    private static Map<Long, String> queryIdNumberMap(String entityNumber) {
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObjectCollection dyCollection = serviceHelper.queryOriginalCollection("id, number", new QFilter[0]);
        for (DynamicObject dy : dyCollection) {
            idNumberMap.put(dy.getLong("id"), dy.getString("number"));
        }
        return idNumberMap;
    }

    public static Map<String, Object> queryPermSetting(Long activityId, Long nodeId) {
        long processPermSettingId;
        QFilter idFilter;
        String selectProps;
        DynamicObject processPermSettingDyn;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        HashSet<Long> notShowAreaSet = new HashSet<Long>(16);
        HashMap showAreaNotShowFieldsMap = new HashMap(16);
        HashMap<String, String> scoreShowMap = new HashMap<String, String>(16);
        DynamicObject activityDyn = ACTIVITY_ENTITY_SERVICE.queryOne("processpermsetting.id", (Object)activityId);
        if (!ObjectUtils.isEmpty((Object)activityDyn) && !ObjectUtils.isEmpty((Object)(processPermSettingDyn = perService.queryOne(selectProps = "contentareaentry.id, contentareaentry.areapage, contentareaentry.areapageinsid, contentareaentry.areadisplayitem, contentareaentry.pflowdefnode,contentareaentry.contentfieldentry,contentfieldentry.areafield, contentfieldentry.fielddisplayitem,scopeareaentry.scorecontent, scopeareaentry.scoreshowarea,scopeareaentry.aflowdefnode", new QFilter[]{idFilter = new QFilter("id", "=", (Object)(processPermSettingId = activityDyn.getLong("processpermsetting.id")))})))) {
            DynamicObjectCollection scopeAreaEntrys;
            DynamicObjectCollection contentAreaEntrys = processPermSettingDyn.getDynamicObjectCollection("contentareaentry");
            if (contentAreaEntrys != null && !contentAreaEntrys.isEmpty()) {
                for (DynamicObject contentAreaEntry : contentAreaEntrys) {
                    if (!nodeId.equals(contentAreaEntry.getLong("pflowdefnode"))) continue;
                    long areaPageId = contentAreaEntry.getDynamicObject("areapage").getLong("id");
                    long areaPageInsid = contentAreaEntry.getLong("areapageinsid");
                    boolean areaDisplayItem = contentAreaEntry.getBoolean("areadisplayitem");
                    if (!areaDisplayItem) {
                        notShowAreaSet.add(areaPageInsid);
                        continue;
                    }
                    DynamicObjectCollection contentFieldEntrys = contentAreaEntry.getDynamicObjectCollection("contentfieldentry");
                    if (contentFieldEntrys == null || contentFieldEntrys.isEmpty()) continue;
                    HashSet<String> notShowFieldSet = new HashSet<String>(16);
                    for (DynamicObject contentFieldEntry : contentFieldEntrys) {
                        boolean fieldDisplayItem = contentFieldEntry.getBoolean("fielddisplayitem");
                        if (fieldDisplayItem) continue;
                        notShowFieldSet.add(contentFieldEntry.getDynamicObject("areafield").getString("number"));
                    }
                    showAreaNotShowFieldsMap.put(areaPageInsid, notShowFieldSet);
                    if (areaPageId == 5L) {
                        showAreaNotShowFieldsMap.put(areaPageId, notShowFieldSet);
                        continue;
                    }
                    if (areaPageId != 1L) continue;
                    showAreaNotShowFieldsMap.put(areaPageId, notShowFieldSet);
                }
            }
            if ((scopeAreaEntrys = processPermSettingDyn.getDynamicObjectCollection("scopeareaentry")) != null && !scopeAreaEntrys.isEmpty()) {
                for (DynamicObject scopeAreaEntry : scopeAreaEntrys) {
                    if (!nodeId.equals(scopeAreaEntry.getLong("aflowdefnode"))) continue;
                    String scoreContent = scopeAreaEntry.getDynamicObject("scorecontent").getString("number");
                    String scoreShowArea = scopeAreaEntry.getDynamicObject("scoreshowarea").getString("number");
                    scoreShowMap.put(scoreContent, scoreShowArea);
                }
            }
        }
        result.put(NOT_SHOW_AREA_SET, notShowAreaSet);
        result.put(SHOW_AREA_NOT_SHOW_FIELDS_MAP, showAreaNotShowFieldsMap);
        result.put(SCORE_SHOW_MAP, scoreShowMap);
        return result;
    }

    public static Set<Long> getNotShowAreaSet(IFormView view) {
        Object notShowAreaSetJsonArray;
        HashSet<Long> notShowAreaSet = new HashSet<Long>(16);
        Object permMap = view.getFormShowParameter().getCustomParam(PERM_MAP);
        if (permMap instanceof JSONObject && (notShowAreaSetJsonArray = ((JSONObject)permMap).get((Object)NOT_SHOW_AREA_SET)) instanceof JSONArray) {
            notShowAreaSet = new HashSet(((JSONArray)notShowAreaSetJsonArray).toJavaList(Long.class));
        }
        return notShowAreaSet;
    }

    public static Set<String> getShowAreaNotShowFieldSet(IFormView view, Long areaPageInsId) {
        Object showAreaNotShowFieldsJsonArray;
        Object showAreaNotShowFieldsMapJsonObject;
        HashSet<String> showAreaNotShowFieldsSet = new HashSet<String>(16);
        if (areaPageInsId == null) {
            return showAreaNotShowFieldsSet;
        }
        Object permMap = view.getFormShowParameter().getCustomParam(PERM_MAP);
        if (permMap instanceof JSONObject && (showAreaNotShowFieldsMapJsonObject = ((JSONObject)permMap).get((Object)SHOW_AREA_NOT_SHOW_FIELDS_MAP)) instanceof JSONObject && (showAreaNotShowFieldsJsonArray = ((JSONObject)showAreaNotShowFieldsMapJsonObject).get((Object)areaPageInsId.toString())) instanceof JSONArray) {
            showAreaNotShowFieldsSet = new HashSet(((JSONArray)showAreaNotShowFieldsJsonArray).toJavaList(String.class));
        }
        return showAreaNotShowFieldsSet;
    }

    public static Map<String, String> getScoreShowMap(IFormView view) {
        Object scoreShowMapJsonObject;
        Map<String, String> scoreShowMap = new HashMap<String, String>(16);
        Object permMap = view.getFormShowParameter().getCustomParam(PERM_MAP);
        if (permMap instanceof JSONObject && (scoreShowMapJsonObject = ((JSONObject)permMap).get((Object)SCORE_SHOW_MAP)) instanceof JSONObject) {
            scoreShowMap = (Map)((JSONObject)scoreShowMapJsonObject).toJavaObject(Map.class);
        }
        return scoreShowMap;
    }

    public static Set<String> getShowAreaNotShowFieldSet(Map<String, Object> permSettingMap, Long areaPageInsid) {
        Map showAreaNotShowFieldsMap = (Map)permSettingMap.get(SHOW_AREA_NOT_SHOW_FIELDS_MAP);
        return (Set)showAreaNotShowFieldsMap.get(areaPageInsid);
    }

    public static Set<Long> getNotShowAreaSet(Map<String, Object> permSettingMap) {
        return (Set)permSettingMap.get(NOT_SHOW_AREA_SET);
    }

    public static Map<String, String> getScoreShowMap(Map<String, Object> permSettingMap) {
        return (Map)permSettingMap.get(SCORE_SHOW_MAP);
    }

    public static String permCheck() {
        String caption = FormMetadataCache.getFormConfig((String)"epa_activity").getCaption().getLocaleValue();
        long currUserId = RequestContext.get().getCurrUserId();
        boolean processManage = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"37LTQSOQE94P");
        boolean view = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"47150e89000000ac");
        if (!processManage || !view) {
            return String.format(ResManager.loadKDString((String)"\u9700\u201c%s\u201d\u7684\u201c\u67e5\u8be2\u201d\u548c\u201c\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ListUtils_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]), caption);
        }
        return "";
    }

    public static void billListHyperLinkClick(HyperLinkClickArgs args, IFormView formView) {
        String resultMsg = ListUtils.permCheck();
        if (!HRStringUtils.isEmpty((String)resultMsg)) {
            formView.showErrorNotification(resultMsg);
            args.setCancel(true);
            return;
        }
        if (formView instanceof IListView && HRStringUtils.equals((String)args.getFieldName(), (String)"perffile_name")) {
            args.setCancel(true);
            IListView listView = (IListView)formView;
            Long actEvalObjId = (Long)listView.getFocusRowPkId();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("epa_actevalobj_confirm");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setPkId((Object)actEvalObjId);
            showParameter.setPageId(listView.getPageId() + "confirmlist" + actEvalObjId);
            formView.showForm((FormShowParameter)showParameter);
        } else if (formView instanceof IListView && HRStringUtils.equals((String)args.getFieldName(), (String)"operation")) {
            args.setCancel(true);
            IListView listView = (IListView)formView;
            Long actEvalObjId = (Long)listView.getFocusRowPkId();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("epa_confirm_record");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("actevalobj", (Object)actEvalObjId);
            showParameter.setPageId(listView.getPageId() + "confirmlistrecord" + actEvalObjId);
            formView.showForm(showParameter);
        }
    }

    public static void updateEvalObj(DynamicObject evalObj, BigDecimal score, String level, AssessNodeStatusEnum assessNodeStatusEnum) {
        log.info(" ----------\u3010\u53d8\u66f4\u8bc4\u4f30\u5bf9\u8c61\u3011CFSOP.getCode():{},CFLOP.getCode():{},NODESTATUS:{}----------", new Object[]{score, level, assessNodeStatusEnum.getStatus()});
        evalObj.set("nodestatus", (Object)assessNodeStatusEnum.getStatus());
        evalObj.set("assessnode", (Object)assessNodeStatusEnum.getNodeId());
        evalObj.set(AssessScoreAbbrEnum.CFSOP.getCode(), (Object)score);
        evalObj.set(AssessScoreAbbrEnum.CFLOP.getCode(), (Object)level);
        evalObj.set(AssessScoreAbbrEnum.FSOP.getCode(), (Object)score);
        evalObj.set(AssessScoreAbbrEnum.FLOP.getCode(), (Object)level);
        evalObj.set("fsopsource", (Object)AssessScoreAbbrEnum.CFSOP.getCode());
        evalObj.set("perffilev", evalObj.get("perffile.sourcevid"));
        long userId = UserServiceHelper.getCurrentUserId();
        evalObj.set("modifier", (Object)userId);
        evalObj.set("modifytime", (Object)new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doEndConfirm(IFormView formView, DynamicObjectCollection evalObjCollection, DynamicObjectCollection setScoreRecordCollection) {
        try (TXHandle txHandle = TX.required();){
            OBJSET_SCORERECORD_ENTITY_SERVICE.save(setScoreRecordCollection);
            ListUtils.saveEvaluationObject((DynamicObject[])evalObjCollection.toArray((Object[])new DynamicObject[0]));
            IFormView parentView = formView.getParentView();
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u786e\u8ba4", (String)"ListUtils_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            parentView.invokeOperation("refresh");
            formView.sendFormAction(parentView);
        }
    }

    public static void beforeClosed(BeforeClosedEvent e, IFormView view, IConfirmCallBack confirmCallBack, boolean isSingle) {
        IDataModel model = view.getModel();
        if (e.isCheckDataChange() && model.getDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", confirmCallBack);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"ListUtils_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"ListUtils_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"ListUtils_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ListUtils_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replace("\\\\r\\\\n", "\r\n") : msg;
            String changeDes = isSingle ? "" : model.getChangeDesc();
            view.showConfirm(msg, changeDes, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            e.setCancel(true);
        }
    }

    private static <T> List<List<T>> splitList(List<T> list, int splitSize) {
        ArrayList<List<T>> lists = new ArrayList<List<T>>();
        if (CollectionUtils.isNotEmpty(list)) {
            int subListSize;
            int listSize = list.size();
            for (int currentPosition = 0; currentPosition < listSize; currentPosition += subListSize) {
                int remaining = listSize - currentPosition;
                subListSize = remaining >= splitSize ? splitSize : remaining;
                List<T> subList = list.subList(currentPosition, currentPosition + subListSize);
                lists.add(new ArrayList<T>(subList));
            }
        }
        return lists;
    }

    public static void splitBatchHandle(List<DynamicObject> list, int splitSize, Consumer<List<DynamicObject>> bizHandler, Consumer<List<DynamicObject>> exceptionHandler) {
        List<List<DynamicObject>> lists = ListUtils.splitList(list, splitSize);
        int batchCount = lists.size();
        if (batchCount == 1) {
            try {
                bizHandler.accept(lists.get(0));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                exceptionHandler.accept(lists.get(0));
            }
        } else if (batchCount > 1) {
            CountDownLatch countDownLatch = new CountDownLatch(batchCount);
            for (List<DynamicObject> subList : lists) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    log.error((Throwable)e);
                }
                THREAD_POOL.execute(() -> {
                    try {
                        bizHandler.accept(subList);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                        exceptionHandler.accept(subList);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }, RequestContext.get());
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                log.error((Throwable)e);
            }
        }
    }

    public static Map<Long, String> getUserIdNameNumberMapByID(List<Long> userIds) {
        DynamicObject[] userInfos;
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        HRBaseServiceHelper userServiceHelper = HRBaseServiceHelper.create((String)"bos_user");
        QFilter idFilter = new QFilter("id", "in", userIds);
        for (DynamicObject userInfo : userInfos = userServiceHelper.query("id,name,number", new QFilter[]{idFilter})) {
            Long userId = userInfo.getLong("id");
            String userName = userInfo.getString("name");
            String userNumber = userInfo.getString("number");
            result.put(userId, userName + userNumber);
        }
        return result;
    }
}

