/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.epa.formplugin.web.utils.ActManageUtils;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;

public class ToBeConfirmedList
extends EvalObjBaseList {
    private static final Log log = LogFactory.getLog(ToBeConfirmedList.class);
    private static final String CONFIRM_STARTUP = "confirm_startup";

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListUtils.filterContainerInit(this.getView(), args);
    }

    public void setFilter(SetFilterEvent filterEvent) {
        ListUtils.specialFilterHandle(this.getView(), filterEvent.getQFilters(), AssessScoreAbbrEnum.FLOP.getCode());
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and("nodestatus", "=", (Object)AssessNodeStatusEnum.EVALUATED.getStatus()).and("assessstaus", "=", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus()).and("nodeindex", "=", (Object)(nodeIndex - 1));
        filterEvent.getQFilters().add(filter);
        filterEvent.setOrderBy("modifytime desc,perffile.billno  asc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        ListUtils.listGradeFormatHandle(args, this.getView(), AssessScoreAbbrEnum.FSOP.getCode(), AssessScoreAbbrEnum.FLOP.getCode(), "floplevel.id");
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        ListUtils.decimalDisplayeFormatHandle(args, this.getView(), AssessScoreAbbrEnum.FSOP.getCode());
        ListUtils.cycleTypeHandle(args, this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String resultMsg = ListUtils.permCheck();
        if (!HRStringUtils.isEmpty((String)resultMsg)) {
            this.getView().showErrorNotification(resultMsg);
            args.setCancel(true);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "confirm_startup": {
                Object[] evaluationObjects = ListUtils.getEvaluationObjects(this.getSelectedRows());
                if (ObjectUtils.isEmpty((Object[])evaluationObjects)) {
                    return;
                }
                this.startUpHandle((DynamicObject[])evaluationObjects);
                break;
            }
            case "refresh": {
                ActManageUtils.refreshConfirmCount(this.getView());
                break;
            }
        }
    }

    private void startUpHandle(DynamicObject[] evaluationObjects) {
        Map<Long, String> validateMap = ListUtils.doStartConfirm(evaluationObjects, evalObj -> {
            if (evalObj.getLong("assessnode.id") == NodeTabMapEnum.EVAL_PROCESS.getNodeId().longValue() && evalObj.getDynamicObjectType().getProperties().containsKey((Object)"isincalc") && evalObj.getBoolean("isincalc")) {
                return ResManager.loadKDString((String)"\u5458\u5de5\u8003\u6838\u8bc4\u4f30\u91cd\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e\u542f\u52a8\u786e\u8ba4\u3002", (String)"ToBeConfirmedList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            }
            return "";
        }, this::updateEvalObj);
        ListUtils.batchResponseHandle(this.getView(), validateMap, CONFIRM_STARTUP, ResManager.loadKDString((String)"\u542f\u52a8\u786e\u8ba4\u6210\u529f\u3002", (String)"ToBeConfirmedList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    private void updateEvalObj(DynamicObject evaluationObj) {
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        log.info(" ----------\u3010\u53d8\u66f4\u8bc4\u4f30\u5bf9\u8c61\u3011ASSESSNODE:{},NODEINDEX:{},NODESTATUS:{}----------", new Object[]{AssessNodeStatusEnum.CONFIRMING.getNodeId(), nodeIndex, AssessNodeStatusEnum.CONFIRMING.getStatus()});
        evaluationObj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        evaluationObj.set("modifytime", (Object)new Date());
        evaluationObj.set("assessnode", (Object)AssessNodeStatusEnum.CONFIRMING.getNodeId());
        evaluationObj.set("nodeindex", (Object)nodeIndex);
        evaluationObj.set("nodestatus", (Object)AssessNodeStatusEnum.CONFIRMING.getStatus());
        evaluationObj.set(AssessScoreAbbrEnum.CFSOP.getCode(), evaluationObj.get(AssessScoreAbbrEnum.FSOP.getCode()));
        evaluationObj.set(AssessScoreAbbrEnum.CFLOP.getCode(), evaluationObj.get(AssessScoreAbbrEnum.FLOP.getCode()));
        evaluationObj.set("cfsopsource", evaluationObj.get("fsopsource"));
        evaluationObj.set("cfloplevel", evaluationObj.get("floplevel"));
        evaluationObj.set("cfsopscoresystem", evaluationObj.get("fsopscoresystem"));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListUtils.billListHyperLinkClick(args, this.getView());
    }
}

