/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm.area;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.mvc.form.ClientViewProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;

public abstract class ConfirmAreaBaseEdit
extends HRDataBaseEdit {
    protected static final AssessActivityApplicationService ACTIVITY_SERVICE = AssessActivityApplicationService.getInstance();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        DynamicObject conf = this.getAreaConfig(confId);
        this.setAreaName(conf);
        this.setAreaTips(conf);
        this.customHandle(conf);
        this.permissionControl();
    }

    protected abstract DynamicObject getAreaConfig(Long var1);

    protected void setAreaName(DynamicObject conf) {
        Label areaNameLab = (Label)this.getControl("lblareaname");
        areaNameLab.setText(this.setCustomAreaName(conf));
    }

    protected String setCustomAreaName(DynamicObject conf) {
        return conf.getString("areacustname");
    }

    protected void setAreaTips(DynamicObject conf) {
        String areaName = conf.getString("areacustname");
        String content = this.setAreaTipContent(conf);
        if (!HRStringUtils.isEmpty((String)content)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setTitle(new LocaleString(areaName));
            tips.setTriggerType("hover");
            tips.setType("text");
            tips.setContent(new LocaleString(content));
            tips.setIconClassName("kdfont kdfont-gengduo2");
            tips.setPlace("right");
            props.put("tips", tips);
            this.getView().updateControlMetadata("lblareaname", props);
        }
    }

    protected String setAreaTipContent(DynamicObject conf) {
        String content = "";
        String description = conf.getString("description");
        if (!HRStringUtils.isEmpty((String)description)) {
            content = ResManager.loadKDString((String)"\u63cf\u8ff0\uff1a{0}", (String)"ConfirmAreaBaseEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{description});
        }
        return content;
    }

    protected void customHandle(DynamicObject conf) {
    }

    protected void entryEntityCommonHandle(DynamicObject conf, String[] numberFields, Set<String> configFields) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("columnResizeMode", "preset");
        this.getView().updateControlMetadata("entryentity", map);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Integer numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        String scaleType = (String)formShowParameter.getCustomParam("scaletype");
        BigDecimal soz = this.getModel().getDataEntity().getBigDecimal(AssessScoreAbbrEnum.SOZ.getCode()).setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType());
        this.getModel().setValue(AssessScoreAbbrEnum.SOZ.getCode(), (Object)soz);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            String[] entry = (String[])entryEntity.get(i);
            String[] stringArray = numberFields;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String numberField = stringArray[j];
                BigDecimal numberFieldValue = entry.getBigDecimal(numberField).setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType());
                entry.set(numberField, (Object)numberFieldValue);
            }
        }
        this.getView().updateControlMetadata(AssessScoreAbbrEnum.SOZ.getCode(), DrawAreaUtils.getPcScItemMap(formShowParameter));
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        for (String numberField : numberFields) {
            clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{numberField, "sc", numAccuracy});
        }
        this.getView().setVisible(Boolean.FALSE, configFields.toArray(new String[0]));
        DynamicObjectCollection fieldEntity = conf.getDynamicObjectCollection("entryentity");
        for (DynamicObject fieldInfo : fieldEntity) {
            String fieldKey = fieldInfo.getString("areafield.number");
            if (!configFields.contains(fieldKey)) continue;
            this.getView().setVisible(Boolean.TRUE, new String[]{fieldKey});
            clientViewProxy.invokeControlMethod("entryentity", "setColProp", new Object[]{fieldKey, "header", fieldInfo.get("fieldcustname")});
        }
    }

    protected void permissionControl() {
        Set<String> permissionNotShowSet = this.permissionNotShowSet();
        if (permissionNotShowSet != null && !permissionNotShowSet.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, permissionNotShowSet.toArray(new String[0]));
        }
    }

    protected Set<String> permissionNotShowSet() {
        return ListUtils.getShowAreaNotShowFieldSet(this.getView(), (Long)this.getView().getFormShowParameter().getCustomParam("confid"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        EntryGrid entryGrid;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"evalview") && (entryGrid = (EntryGrid)this.getControl("entryentity")).getSelectRows().length == 1) {
            DynamicObject indicatorDy = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(entryGrid.getSelectRows()[0]);
            Long indicatorId = (Long)indicatorDy.getPkValue();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId(this.getEvalDialogViewNumber());
            showParameter.setCustomParam("indicatorId", (Object)indicatorId);
            showParameter.setCustomParam("permMap", this.getView().getFormShowParameter().getCustomParam("permMap"));
            this.setAssessFormParamInfo(showParameter);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    protected abstract String getEvalDialogViewNumber();

    protected void setAssessFormParamInfo(BaseShowParameter showParameter) {
        FormShowParameter currParam = this.getView().getFormShowParameter();
        showParameter.setCustomParam("ruleid", currParam.getCustomParam("ruleid"));
        showParameter.setCustomParam("confid", currParam.getCustomParam("confid"));
        showParameter.setCustomParam("scorecalcway", currParam.getCustomParam("scorecalcway"));
        showParameter.setCustomParam("evalway", currParam.getCustomParam("evalway"));
        showParameter.setCustomParam("numaccuracy", currParam.getCustomParam("numaccuracy"));
        showParameter.setCustomParam("scoresystem", currParam.getCustomParam("scoresystem"));
        showParameter.setCustomParam("scaletype", currParam.getCustomParam("scaletype"));
        showParameter.setCustomParam("issupcalcsum", currParam.getCustomParam("issupcalcsum"));
        showParameter.setCustomParam("consistentwitharea", currParam.getCustomParam("consistentwitharea"));
    }
}

