/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm.area;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.area.ConfirmAreaBaseEdit;
import kd.opmc.epa.formplugin.web.utils.IndicatorDetailUtils;

public class ConfirmCustomAreaEdit
extends ConfirmAreaBaseEdit {
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final String[] AREA_INIT_FIELDS = new String[]{"actevalobj", "assessyear", "assessperiod", "activity", "perforg", "flowrunode", "flowrurole", "flowrutask", "flowruproc"};
    private static final String[] CUSTOM_AREA_ALL_FIELDS = new String[]{"customfield1", "customfield2", "customfield3", "customfield5", "customfield6", "customfield7", "customfield8", "customfield4", "customfield9", "customfield10"};
    private static final String[] CUSTOM_AREA_FIELDS = new String[]{"customfield1", "customfield2", "customfield3", "customfield5", "customfield6", "customfield7", "customfield8"};

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        for (String initField : AREA_INIT_FIELDS) {
            Object fieldValue = parameter.getCustomParam(initField);
            if (fieldValue == null) continue;
            this.getModel().setValue(initField, fieldValue);
        }
        this.initIndicatorFormData();
    }

    private void initIndicatorFormData() {
        DynamicObject indicatorDy;
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        Long preRoleTaskId = APP_SERVICE.queryPreRoleLastTask(taskId);
        if (preRoleTaskId != null && !ObjectUtils.isEmpty((Object)(indicatorDy = APP_SERVICE.queryCustomAreaEvalRecord(preRoleTaskId)))) {
            for (int i = 0; i < CUSTOM_AREA_FIELDS.length; ++i) {
                String fieldKey = CUSTOM_AREA_FIELDS[i];
                this.getView().getModel().setValue(fieldKey, (Object)indicatorDy.getLocaleString(fieldKey));
            }
        }
    }

    @Override
    protected DynamicObject getAreaConfig(Long confId) {
        return ACTIVITY_SERVICE.queryCustomConfigByPk(confId);
    }

    @Override
    protected void customHandle(DynamicObject conf) {
        super.customHandle(conf);
        ArrayList<String> confFiledsList = new ArrayList<String>(10);
        if (conf != null) {
            DynamicObjectCollection confFieldCols = conf.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < confFieldCols.size(); ++i) {
                DynamicObject fieldObj = (DynamicObject)confFieldCols.get(i);
                String fieldcustname = fieldObj.getString("fieldcustname");
                String fieldNum = fieldObj.getString("areafield.number");
                String fieldName = fieldObj.getString("areafield.name");
                FieldEdit fieldAp = (FieldEdit)this.getView().getControl(fieldNum);
                if (fieldcustname != null) {
                    fieldAp.setCaption(new LocaleString(fieldcustname));
                } else {
                    fieldAp.setCaption(new LocaleString(fieldName));
                }
                confFiledsList.add(fieldNum);
            }
            List<String> notConfFiledsList = Arrays.asList(CUSTOM_AREA_ALL_FIELDS).stream().filter(element -> !confFiledsList.contains(element)).collect(Collectors.toList());
            if (!notConfFiledsList.isEmpty()) {
                String[] hideFields = notConfFiledsList.toArray(new String[notConfFiledsList.size()]);
                this.getView().setVisible(Boolean.FALSE, hideFields);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"conentpanel"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "conentpanel": {
                IFormView view = this.getView();
                IndicatorDetailUtils.showEmptyap(view, "customAreaTitleCacheKey");
                break;
            }
        }
    }

    @Override
    protected String getEvalDialogViewNumber() {
        return null;
    }
}

