/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm.area;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.dynpermission.DynPermissionConfigService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.EmpInfoConfigEntityService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.vo.dynpermission.ContentAreaEntry;
import kd.opmc.epa.common.vo.dynpermission.ContentFieldEntry;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.pbs.business.external.hrpi.IEmployeeService;

public class ConfirmPersonInfoAreaEdit
extends HRDataBaseEdit {
    private static final Log log = LogFactory.getLog(ConfirmPersonInfoAreaEdit.class);
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final EmpInfoConfigEntityService EMP_INFO_CONFIG_ENTITY_SERVICE = EmpInfoConfigEntityService.getInstance();
    private static final IEmployeeService EMPLOYEE_SERVICE = IEmployeeService.getInstance();
    private static final Integer MAXNUM = 15;
    private static final AssessActivityEntityService ASSESS_ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (e.getFormShowParameter() != null && e.getFormShowParameter().getParentFormId() != null) {
            e.getFormShowParameter().setHasRight(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPersonInfo();
    }

    public void setPersonInfo() {
        IFormView view = this.getView();
        IFormView parentView = this.getView().getParentView();
        DynamicObject evalObj = parentView.getModel().getDataEntity();
        DynamicObject assessformDy = APP_SERVICE.queryExecuteAssessForm(evalObj.getDynamicObject("activity").getLong("assessform.id"));
        Image headSculpture = (Image)view.getControl("headsculpture");
        headSculpture.setUrl(HRImageUrlUtil.getImageFullUrl((String)evalObj.getString("person.headsculpture")));
        this.setLabelText(view, "name", evalObj.getString("perffile.name"));
        this.setLabelText(view, "number", evalObj.getString("perffile.billno"));
        HashMap<String, String> evalFieldConfMap = new HashMap<String, String>(16);
        evalFieldConfMap.put("company", evalObj.getString("perffile.company.name"));
        evalFieldConfMap.put("adminorg", evalObj.getString("perffile.adminorg.name"));
        evalFieldConfMap.put("position", evalObj.getString("perffile.position.name"));
        HashMap requestParam = Maps.newHashMapWithExpectedSize((int)3);
        Long employeeId = evalObj.getLong("employee.id");
        ArrayList<Long> employeeIds = new ArrayList<Long>(10);
        if (employeeId != null) {
            employeeIds.add(employeeId);
        }
        requestParam.put("sign", "employee");
        requestParam.put("signList", employeeIds);
        requestParam.put("dateTime", new Date());
        try {
            Map queryResult = EMPLOYEE_SERVICE.listPersonServiceAgeWithIds((Map)requestParam);
            Boolean success = (Boolean)queryResult.get("success");
            if (success.booleanValue()) {
                Map ageRetMap = (Map)queryResult.get("data");
                Map map = (Map)ageRetMap.get(employeeId);
                if (map != null && map.containsKey("companyWorkAge")) {
                    BigDecimal entservicelen = (BigDecimal)map.get("companyWorkAge");
                    entservicelen = entservicelen == null ? BigDecimal.ZERO : entservicelen;
                    evalFieldConfMap.put("entservicelen", entservicelen.stripTrailingZeros().toPlainString());
                }
                if (map != null && map.containsKey("socialWorkAge")) {
                    BigDecimal servicelen = (BigDecimal)map.get("socialWorkAge");
                    servicelen = servicelen == null ? BigDecimal.ZERO : servicelen;
                    evalFieldConfMap.put("workyear", servicelen.stripTrailingZeros().toPlainString());
                }
            }
        }
        catch (Exception e) {
            log.error("EMPLOYEE_SERVICE.listPersonServiceAgeWithIds   error, requestParam:" + requestParam);
            log.error((Throwable)e);
            evalFieldConfMap.put("entservicelen", "-");
            evalFieldConfMap.put("workyear", "-");
        }
        evalFieldConfMap.put("job", evalObj.getString("perffile.job.name"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date startdate = evalObj.getDate("perffile.employedate");
        if (startdate != null) {
            evalFieldConfMap.put("entrytime", format.format(startdate));
        } else {
            evalFieldConfMap.put("entrytime", "-");
        }
        for (Map.Entry entry : evalFieldConfMap.entrySet()) {
            Object value = entry.getValue();
            if (value != null) continue;
            evalFieldConfMap.put((String)entry.getKey(), "-");
        }
        Map<Long, Boolean> fieldPermMap = this.getFieldPermMap(evalObj);
        DynamicObject dynamicObject = EMP_INFO_CONFIG_ENTITY_SERVICE.queryOne((Object)assessformDy.getLong("empinfoconf"));
        DynamicObjectCollection empInfoConfEntry = dynamicObject.getDynamicObjectCollection("entryentity");
        view.setVisible(Boolean.FALSE, new String[]{"splitline"});
        for (DynamicObject empInfo : empInfoConfEntry) {
            DynamicObject field = empInfo.getDynamicObject("areafield");
            if (field == null) continue;
            String fieldKey = field.getString("number");
            int seq = empInfo.getInt("seq");
            if (evalFieldConfMap.get(fieldKey) != null && empInfo.getBoolean("isshow") && this.hasShowPerm(fieldPermMap, field)) {
                Label keyLabel = (Label)view.getControl("key" + seq);
                keyLabel.setText(field.getString("name") + "\uff1a");
                Label valueLabel = (Label)view.getControl("value" + seq);
                valueLabel.setText(String.valueOf(evalFieldConfMap.get(fieldKey)));
                view.setVisible(Boolean.TRUE, new String[]{keyLabel.getKey(), valueLabel.getKey()});
                if (seq <= 6) continue;
                view.setVisible(Boolean.TRUE, new String[]{"splitline"});
                continue;
            }
            view.setVisible(Boolean.FALSE, new String[]{"ap" + seq});
        }
        for (int i = empInfoConfEntry.size() + 1; i <= MAXNUM; ++i) {
            view.setVisible(Boolean.FALSE, new String[]{"ap" + i});
        }
    }

    private boolean hasShowPerm(Map<Long, Boolean> fieldIdMap, DynamicObject field) {
        long fieldId = field.getLong("id");
        if (ObjectUtils.isEmpty(fieldIdMap) || ObjectUtils.isEmpty((Object)fieldIdMap.get(fieldId))) {
            return true;
        }
        return fieldIdMap.get(fieldId);
    }

    private Map<Long, Boolean> getFieldPermMap(DynamicObject evalObj) {
        HashMap<Long, Boolean> areaFieldPermMap = new HashMap<Long, Boolean>(16);
        long personId = evalObj.getLong("person.id");
        Map<Long, Long> personIdUserIdMap = ListUtils.getBosUserIdsByPersonIds(Collections.singletonList(personId));
        Long userId = personIdUserIdMap.get(personId);
        IFormView parentView = this.getView().getParentView().getParentView();
        if (userId != null && userId == UserServiceHelper.getCurrentUserId() && parentView != null && !parentView.getPageId().contains("confirmlist")) {
            ConfirmPersonInfoAreaEdit.initAreaFieldPermMap(evalObj, areaFieldPermMap);
        }
        return areaFieldPermMap;
    }

    public static void initAreaFieldPermMap(DynamicObject evalObj, Map<Long, Boolean> areaFieldPermMap) {
        Long assessFormId;
        QFilter assessFormFilter;
        DynamicObject assessFormObj;
        long activityId = evalObj.getDynamicObject("activity").getLong("id");
        QFilter activityFilter = new QFilter("id", "=", (Object)activityId);
        DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, dynamicpermission", new QFilter[]{activityFilter});
        if (activityObj != null && (assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("empinfoconf", new QFilter[]{assessFormFilter = new QFilter("id", "=", (Object)(assessFormId = Long.valueOf(activityObj.getLong("assessform.id"))))})) != null) {
            List contentAreaEntries;
            Map contentAreaEntriesMap;
            long empInfoIdId = assessFormObj.getLong("empinfoconf");
            DynPermissionConfigService dynamicObjectCollection = new DynPermissionConfigService();
            Long newProcPermId = activityObj.getLong("dynamicpermission.id");
            DynamicPermissionConfigVO dynamicPermissions = dynamicObjectCollection.getDynamicPermissions(newProcPermId, Collections.singletonList(AssessNodeStatusEnum.CONFIRMING.getNodeId()));
            if (dynamicPermissions != null && (contentAreaEntriesMap = dynamicPermissions.getContentAreaEntriesMap()) != null && (contentAreaEntries = (List)contentAreaEntriesMap.get(AssessNodeStatusEnum.CONFIRMING.getNodeId())) != null) {
                for (ContentAreaEntry contentAreaEntry : contentAreaEntries) {
                    Boolean areaDisplay;
                    Long areaPageInsId;
                    if (contentAreaEntry == null || empInfoIdId != (areaPageInsId = contentAreaEntry.getAreapageInsId() == null ? Long.valueOf("0") : contentAreaEntry.getAreapageInsId())) continue;
                    List fieldEntries = contentAreaEntry.getFieldEntries();
                    Boolean bl = areaDisplay = contentAreaEntry.getAreaDisplay() == null ? Boolean.FALSE : contentAreaEntry.getAreaDisplay();
                    if (areaDisplay != null && !areaDisplay.booleanValue()) break;
                    if (fieldEntries == null) continue;
                    for (ContentFieldEntry fieldEntry : fieldEntries) {
                        if (fieldEntry == null) continue;
                        Long areaFieldId = fieldEntry.getAreaFieldId();
                        Boolean fieldDisplay = fieldEntry.getFieldDisplay() == null ? Boolean.FALSE : fieldEntry.getFieldDisplay();
                        areaFieldPermMap.put(areaFieldId, fieldDisplay);
                    }
                }
            }
        }
    }

    private void setLabelText(IFormView view, String label, String value) {
        Label number = (Label)view.getControl(label);
        if (number != null) {
            number.setText(value);
        }
    }
}

