/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm.info.mp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetScoreRecordDomainService;
import kd.opmc.epa.business.domain.hbss.enums.CycleTypeEnum;
import kd.opmc.epa.business.domain.mp.entityservice.MpCalcItemEntityService;
import kd.opmc.epa.business.domain.mp.enums.MpSopEndWayEnum;
import kd.opmc.epa.business.domain.mp.enums.MpSopGenWayEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.enums.activitymanage.MpModeEnum;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.utils.ScoreAndLevelUtils;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;

public class MpInfoHelper {
    private static final long MP_AREA_INS_ID = 1960097310314606592L;
    protected static final MpCalcItemEntityService MP_CALC_ITEM_ENTITY_SERVICE = MpCalcItemEntityService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    protected static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final ObjsetScoreRecordDomainService OBJSET_SCORERECORD_ENTITY_SERVICE = ObjsetScoreRecordDomainService.getInstance();

    private MpInfoHelper() {
    }

    public static void mpAreaHandle(IFormView view) {
        Set<Long> notShowAreaSet = ListUtils.getNotShowAreaSet(view);
        if (notShowAreaSet.contains(1960097310314606592L)) {
            view.setVisible(Boolean.FALSE, new String[]{"mpcontainer"});
            return;
        }
        String mpSopEndWay = view.getModel().getDataEntity().getString("mpsopendway");
        String mpSopGenWay = view.getModel().getDataEntity().getString("mpsopgenway");
        if (!HRStringUtils.equals((String)MpSopEndWayEnum.END_SUMMARY.getCode(), (String)mpSopEndWay) || !HRStringUtils.equals((String)MpSopGenWayEnum.RULE_CALC.getCode(), (String)mpSopGenWay)) {
            view.setVisible(Boolean.FALSE, new String[]{"mpcontainer"});
        } else {
            DynamicObject mpRule;
            DynamicObject actEvalObj = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryByPkValue(Long.valueOf(view.getModel().getDataEntity().getLong("id")));
            DynamicObject dynamicObject = mpRule = actEvalObj.getDynamicObject("mprealrule") != null ? actEvalObj.getDynamicObject("mprealrule") : actEvalObj.getDynamicObject("activity").getDynamicObject("mprule");
            if (mpRule != null) {
                DynamicObject mpRuleDyn = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryMpRuleByPkValue(mpRule.getPkValue());
                if (mpRuleDyn != null) {
                    MpInfoHelper.setAreaTips(view, mpRuleDyn);
                    long activityId = view.getModel().getDataEntity().getDynamicObject("activity").getLong("id");
                    ScoreAndLevelUtils.cacheScoreConfig(view, activityId);
                    MpInfoHelper.setMpResult(view, activityId);
                    MpInfoHelper.initMpEntryEntity(view, mpRuleDyn);
                }
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"mpcontainer"});
            }
        }
    }

    private static void setAreaTips(IFormView view, DynamicObject mpRuleDyn) {
        String content = mpRuleDyn.getString("mpformula");
        if (!HRStringUtils.isEmpty((String)content)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u6c47\u603b\u89c4\u5219", (String)"MpInfoHelper_0", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
            tips.setTriggerType("hover");
            tips.setType("text");
            tips.setContent(new LocaleString(content));
            tips.setIconClassName("kdfont kdfont-gengduo2");
            tips.setPlace("right");
            props.put("tips", tips);
            view.updateControlMetadata("mpareaname", props);
        }
    }

    private static void setMpResult(IFormView view, long activityId) {
        Map<String, String> levelMap;
        Integer numAccuracy = Integer.parseInt(view.getPageCache().get("numAccuracy"));
        String scaleType = view.getPageCache().get("scaleType");
        StringBuilder mpResult = new StringBuilder();
        BigDecimal mpSop = view.getModel().getDataEntity().getBigDecimal("mpsop");
        if (mpSop != null) {
            mpResult.append(mpSop.setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).toPlainString());
        }
        String mpLop = view.getModel().getDataEntity().getString("mplop");
        DynamicObject mpPerfLevel = ScoreAndLevelUtils.getPerfLevelByNodeIdAndActivityId(NodeTabMapEnum.PERF_SUM.getNodeId(), activityId);
        if (mpPerfLevel != null && (levelMap = ScoreAndLevelUtils.getLevelMapByPerfLevelDyn(mpPerfLevel, "seq", "levelname")) != null && !HRStringUtils.isEmpty((String)(mpLop = levelMap.get(mpLop)))) {
            mpResult.append(" / ").append(mpLop);
        }
        MpInfoHelper.setLabelText("mpresult", mpResult.toString(), view);
    }

    private static void initMpEntryEntity(IFormView view, DynamicObject mpRuleDyn) {
        DynamicObject[] mpRecords = MP_CALC_ITEM_ENTITY_SERVICE.queryMpResultByObjId(Long.valueOf(view.getModel().getDataEntity().getLong("id")));
        if (mpRecords != null && mpRecords.length > 0) {
            Integer numAccuracy = Integer.parseInt(view.getPageCache().get("numAccuracy"));
            String scaleType = view.getPageCache().get("scaleType");
            DynamicObjectCollection mpRuleEntrys = mpRuleDyn.getDynamicObjectCollection("entryentity");
            Map<String, BigDecimal> timeTagWeightMap = mpRuleEntrys.stream().collect(Collectors.toMap(dy -> dy.getString("timetag"), dy -> dy.getBigDecimal("weight")));
            AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
            model.beginInit();
            model.deleteEntryData("mpentryentity");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("period", new Object[0]);
            vs.addField("iscurrent", new Object[0]);
            vs.addField("adminorgname", new Object[0]);
            vs.addField("positiontext", new Object[0]);
            vs.addField("score", new Object[0]);
            vs.addField("weight", new Object[0]);
            Map<Long, Map<String, String>> mpRecordLevelMap = MpInfoHelper.getMpRecordLevelMap(mpRecords);
            for (DynamicObject recordDy : mpRecords) {
                boolean isCurrent = false;
                if (HRStringUtils.equals((String)recordDy.getString("period"), (String)view.getModel().getDataEntity().getString("assessperiod"))) {
                    isCurrent = true;
                }
                StringBuilder score = new StringBuilder();
                BigDecimal sop = recordDy.getBigDecimal("sop");
                if (sop != null) {
                    score.append(sop.setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).toPlainString());
                }
                String lop = recordDy.getString("lop");
                Map<String, String> levelMap = mpRecordLevelMap.get(recordDy.getLong("perfleve.id"));
                if (levelMap != null && !StringUtils.isEmpty((CharSequence)(lop = levelMap.get(lop)))) {
                    score.append("|").append(lop);
                }
                String weightStr = "-";
                BigDecimal weight = timeTagWeightMap.get(recordDy.getString("timetag"));
                if (weight != null) {
                    weightStr = weight.setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).toPlainString() + "%";
                }
                vs.addRow(new Object[]{recordDy.get("period"), isCurrent, recordDy.get("perffile.affiliateadminorg.name"), recordDy.get("perffile.position.name"), score.toString(), weightStr});
            }
            model.batchCreateNewEntryRow("mpentryentity", vs);
            model.endInit();
            view.updateView("mpentryentity");
            view.getModel().setDataChanged(false);
            String mpMode = mpRuleDyn.getString("mpmode");
            if (!HRStringUtils.equals((String)MpModeEnum.CUSTOM_PROPORTION.getCode(), (String)mpMode)) {
                view.setVisible(Boolean.FALSE, new String[]{"weight"});
            }
        }
    }

    private static Map<Long, Map<String, String>> getMpRecordLevelMap(DynamicObject[] mpRecords) {
        HashMap<Long, Map<String, String>> result = new HashMap<Long, Map<String, String>>(16);
        if (mpRecords != null && mpRecords.length > 0) {
            ArrayList<Long> perfLevelIds = new ArrayList<Long>(10);
            for (DynamicObject mpRecord : mpRecords) {
                if (mpRecord.getLong("perfleve.id") == 0L) continue;
                perfLevelIds.add(mpRecord.getLong("perfleve.id"));
            }
            result.putAll(ScoreAndLevelUtils.getPerfLevelEntryMapByPerfLevelIds(perfLevelIds, "seq", "levelname"));
        }
        return result;
    }

    public static void setSopAndOle(IFormView view, DynamicObject assessFormDy) {
        MpInfoHelper.cacheAllScoreAndLevel(view);
        String isContainEval = view.getPageCache().get("isContainEval");
        String bottomSop = view.getPageCache().get("cfSop");
        String bottomLop = view.getPageCache().get("cfLopName");
        String topSop = view.getPageCache().get("fSop");
        String topLop = view.getPageCache().get("fLopName");
        String topMpSop = view.getPageCache().get("fSop");
        String topMpLop = view.getPageCache().get("fLopName");
        DynamicObject activityDyn = view.getModel().getDataEntity().getDynamicObject("activity");
        boolean isYearMp = MpInfoHelper.isYearMp(activityDyn);
        boolean isCurPeriod = view.getModel().getDataEntity().getBoolean("iscurperiod");
        String mpGenWay = view.getModel().getDataEntity().getString("activity.mpgenway");
        long assessNodeId = view.getModel().getDataEntity().getLong("assessnode.id");
        if (assessNodeId < AssessNodeStatusEnum.TO_BE_CONFIRMED.getNodeId()) {
            bottomSop = view.getPageCache().get("fSop");
            bottomLop = view.getPageCache().get("fLopName");
        }
        if (isYearMp && isCurPeriod && HRStringUtils.equals((String)isContainEval, (String)"true")) {
            if (!MpInfoHelper.isUpdateResult(view.getModel().getDataEntity().getLong("id"))) {
                bottomSop = view.getPageCache().get("sop");
                bottomLop = view.getPageCache().get("lopName");
            }
            if ("1".equals(mpGenWay)) {
                topSop = view.getPageCache().get("sop");
                topLop = view.getPageCache().get("lopName");
            }
        }
        MpInfoHelper.setLabelText("bottomsoplabel", bottomSop, view);
        MpInfoHelper.setLabelText("bottomloplabel", bottomLop, view);
        MpInfoHelper.setLabelText("topsoplabel", topSop, view);
        MpInfoHelper.setLabelText("toploplabel", topLop, view);
        MpInfoHelper.setLabelText("topmpsoplabel", topMpSop, view);
        MpInfoHelper.setLabelText("topmploplabel", topMpLop, view);
        if (!isYearMp) {
            view.setVisible(Boolean.FALSE, new String[]{"topmpsumareaap"});
        }
        if (isYearMp && !isCurPeriod) {
            view.setVisible(Boolean.FALSE, new String[]{"topsumareaap"});
        }
        if (HRStringUtils.equals((String)isContainEval, (String)"true")) {
            Set<String> showAreaNotShowFieldSet;
            if (assessFormDy != null) {
                DynamicObject sumConf = APP_SERVICE.querySumConfInfoById(assessFormDy.getLong("sumconf"));
                boolean isShowInFlow = sumConf.getBoolean("isshowinflow");
                if (!isShowInFlow) {
                    view.setVisible(Boolean.valueOf(isShowInFlow), new String[]{"sumareaflex", "topsumareaap", "topmpsumareaap"});
                    return;
                }
                String areacustname = sumConf.getString("areacustname");
                Label sumareanamelab = (Label)view.getControl("sumareanamelab");
                sumareanamelab.setText(areacustname);
                DynamicObjectCollection fieldInfos = sumConf.getDynamicObjectCollection("entryentity");
                for (DynamicObject fieldInfo : fieldInfos) {
                    String fieldName;
                    DynamicObject filed = fieldInfo.getDynamicObject("areafield");
                    String filedKey = filed.getString("number");
                    String fieldCustName = fieldInfo.getString("fieldcustname");
                    String string = fieldName = StringUtils.isEmpty((CharSequence)fieldCustName) ? filed.getString("name") : fieldCustName;
                    if (HRStringUtils.equals((String)"ose", (String)filedKey)) {
                        Label labelap = (Label)view.getControl("labelap");
                        labelap.setText(fieldName);
                        continue;
                    }
                    if (!HRStringUtils.equals((String)"ole", (String)filedKey)) continue;
                    Label labelap1 = (Label)view.getControl("labelap1");
                    labelap1.setText(fieldName);
                    if (fieldInfo.getBoolean("isshow") || view.getParentView().getPageId().contains("confirmlist") || !ListUtils.isCurrentUser(view.getModel().getDataEntity().getLong("person.id"))) continue;
                    view.setVisible(Boolean.FALSE, new String[]{"bottomlopflex", "oseline", "toploplabel", "mposeline", "topmploplabel"});
                }
                String desc = sumConf.getString("description");
                if (HRStringUtils.isNotEmpty((String)desc)) {
                    String content = ResManager.loadKDString((String)"\u63cf\u8ff0\uff1a{0}", (String)"MpInfoHelper_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc});
                    HashMap<String, Tips> props = new HashMap<String, Tips>(16);
                    Tips tips = new Tips();
                    tips.setTitle(new LocaleString(areacustname));
                    tips.setTriggerType("hover");
                    tips.setType("text");
                    tips.setContent(new LocaleString(content));
                    tips.setIconClassName("kdfont kdfont-gengduo2");
                    tips.setPlace("right");
                    props.put("tips", tips);
                    view.updateControlMetadata("sumareanamelab", props);
                }
            }
            if ((showAreaNotShowFieldSet = ListUtils.getShowAreaNotShowFieldSet(view, (Long)5L)) != null && showAreaNotShowFieldSet.contains("ole")) {
                view.setVisible(Boolean.FALSE, new String[]{"bottomlopflex", "oseline", "toploplabel", "mposeline", "topmploplabel"});
            }
        }
        if (HRStringUtils.equals((String)"-", (String)bottomLop)) {
            view.setVisible(Boolean.FALSE, new String[]{"bottomlopflex"});
        }
        if (HRStringUtils.equals((String)"-", (String)topLop)) {
            view.setVisible(Boolean.FALSE, new String[]{"oseline", "toploplabel"});
        }
        if (HRStringUtils.equals((String)"-", (String)topMpLop)) {
            view.setVisible(Boolean.FALSE, new String[]{"mposeline", "topmploplabel"});
        }
    }

    private static void cacheAllScoreAndLevel(IFormView view) {
        long activityId = view.getModel().getDataEntity().getDynamicObject("activity").getLong("id");
        Map<Long, Map<String, String>> perfLevelIdLevelSeqLevelNameMap = ScoreAndLevelUtils.getPerfLevelIdLevelSeqLevelNameMap(activityId, "seq", "levelname");
        ScoreAndLevelUtils.cacheScoreConfig(view, activityId);
        int numAccuracy = Integer.parseInt(view.getPageCache().get("numAccuracy"));
        int roundingMode = ScalaTypeEnum.get((String)view.getPageCache().get("scaleType")).getType();
        String isContainEval = view.getPageCache().get("isContainEval");
        long actObjCFPerfLevelId = view.getModel().getDataEntity().getLong("cfloplevel.id");
        Map<Object, Object> cfLevelSeqNameMap = new HashMap(16);
        if (actObjCFPerfLevelId != 0L && perfLevelIdLevelSeqLevelNameMap.containsKey(actObjCFPerfLevelId)) {
            cfLevelSeqNameMap = perfLevelIdLevelSeqLevelNameMap.get(actObjCFPerfLevelId);
        }
        BigDecimal cfSop = view.getModel().getDataEntity().getBigDecimal(AssessScoreAbbrEnum.CFSOP.getCode()).setScale(numAccuracy, roundingMode);
        String cfLop = view.getModel().getDataEntity().getString(AssessScoreAbbrEnum.CFLOP.getCode());
        String cfLopName = cfLevelSeqNameMap.get(cfLop) == null ? "-" : (String)cfLevelSeqNameMap.get(cfLop);
        view.getPageCache().put("cfSop", cfSop.toPlainString());
        view.getPageCache().put("cfLopName", cfLopName);
        long actObjPerfLevelId = view.getModel().getDataEntity().getLong("floplevel.id");
        Map<Object, Object> levelSeqNameMap = new HashMap(16);
        if (actObjPerfLevelId != 0L && perfLevelIdLevelSeqLevelNameMap.containsKey(actObjPerfLevelId)) {
            levelSeqNameMap = perfLevelIdLevelSeqLevelNameMap.get(actObjPerfLevelId);
        }
        BigDecimal fSop = view.getModel().getDataEntity().getBigDecimal(AssessScoreAbbrEnum.FSOP.getCode()).setScale(numAccuracy, roundingMode);
        String fLop = view.getModel().getDataEntity().getString(AssessScoreAbbrEnum.FLOP.getCode());
        String fLopName = levelSeqNameMap.get(fLop) == null ? "-" : (String)levelSeqNameMap.get(fLop);
        view.getPageCache().put("fSop", fSop.toPlainString());
        view.getPageCache().put("fLopName", fLopName);
        if (HRStringUtils.equals((String)isContainEval, (String)"true")) {
            DynamicObject assessFormPerfLevelDyn = ScoreAndLevelUtils.getPerfLevelByNodeIdAndActivityId(NodeTabMapEnum.EVAL_PROCESS.getNodeId(), activityId);
            Map<String, String> sopLevelSeqNameMap = ScoreAndLevelUtils.getLevelMapByPerfLevelDyn(assessFormPerfLevelDyn, "seq", "levelname");
            BigDecimal sop = view.getModel().getDataEntity().getBigDecimal(AssessScoreAbbrEnum.SOP.getCode()).setScale(numAccuracy, roundingMode);
            String lop = view.getModel().getDataEntity().getString(AssessScoreAbbrEnum.LOP.getCode());
            String lopName = sopLevelSeqNameMap.get(lop) == null ? "-" : sopLevelSeqNameMap.get(lop);
            view.getPageCache().put("sop", sop.toPlainString());
            view.getPageCache().put("lopName", lopName);
            if (assessFormPerfLevelDyn != null) {
                view.getPageCache().put("evalSumperflevelIsNull", "false");
            }
        }
    }

    public static boolean isYearMp(DynamicObject activityDyn) {
        boolean isYearMp = false;
        boolean isGeNextMpSop = activityDyn.getBoolean("isgenextmpsop");
        String mpSopCategory = activityDyn.getString("mpsopcategory");
        boolean isNeedMpGenWay = activityDyn.getBoolean("isneedmpgenway");
        if (isGeNextMpSop && isNeedMpGenWay && HRStringUtils.equals((String)mpSopCategory, (String)CycleTypeEnum.YEAR.getRef())) {
            isYearMp = true;
        }
        return isYearMp;
    }

    private static void setLabelText(String label, String text, IFormView view) {
        Label activityNameLab = (Label)view.getControl(label);
        if (activityNameLab != null) {
            activityNameLab.setText(text);
        }
    }

    private static String getPerfLevelIsNullStr(IFormView view, String perfLevelKey, Long nodeId) {
        String perfLevelIsNullStr = view.getPageCache().get(perfLevelKey);
        if (HRStringUtils.isEmpty((String)perfLevelIsNullStr)) {
            long activityId = view.getModel().getDataEntity().getDynamicObject("activity").getLong("id");
            DynamicObject perfLevelDyn = ScoreAndLevelUtils.getPerfLevelByNodeIdAndActivityId(nodeId, activityId);
            perfLevelIsNullStr = perfLevelDyn == null ? "true" : "false";
            view.getPageCache().put(perfLevelKey, perfLevelIsNullStr);
        }
        return perfLevelIsNullStr;
    }

    public static void topMpSumAreaApHandle(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{"topmpsumareaap"});
        DynamicObject activityDyn = view.getModel().getDataEntity().getDynamicObject("activity");
        boolean isYearMp = MpInfoHelper.isYearMp(activityDyn);
        if (isYearMp) {
            view.setVisible(Boolean.TRUE, new String[]{"topmpsumareaap"});
        }
    }

    private static boolean isUpdateResult(Long actEvalObjId) {
        QFilter actEvalFilter = new QFilter("actevalobj", "=", (Object)actEvalObjId);
        QFilter assessNodeFilter = new QFilter("assessnode", "=", (Object)AssessNodeStatusEnum.CONFIRMING.getNodeId());
        return OBJSET_SCORERECORD_ENTITY_SERVICE.isExists(new QFilter[]{actEvalFilter, assessNodeFilter});
    }
}

