/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.confirm.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.mp.enums.MpLevelSetEnum;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;

public class ScoreAndLevelUtils {
    private static final Log log = LogFactory.getLog(ScoreAndLevelUtils.class);
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();
    private static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    public static final String ACT_OBJ_F_PERF_LEVEL_ID = "floplevel.id";
    public static final String ACT_OBJ_F_SCORE_SYSTEM_ID = "fsopscoresystem.id";
    public static final String ACT_OBJ_CF_PERF_LEVEL_ID = "cfloplevel.id";
    public static final String ACT_OBJ_CF_SCORE_SYSTEM_ID = "cfsopscoresystem.id";

    private ScoreAndLevelUtils() {
    }

    public static Map<Long, Map<String, String>> getPerfLevelIdLevelSeqLevelNameMap(long activityId, String keyStr, String valueStr) {
        List<DynamicObject> allPerfLevelByActivityId = ScoreAndLevelUtils.getAllPerfLevelByActivityId(activityId);
        List<Long> perfLevelIds = allPerfLevelByActivityId.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        return ScoreAndLevelUtils.getPerfLevelEntryMapByPerfLevelIds(perfLevelIds, keyStr, valueStr);
    }

    private static List<DynamicObject> getAllPerfLevelByActivityId(long activityId) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(10);
        DynamicObject activityDy = ACTIVITY_ENTITY_SERVICE.queryScoreAndLevelConfigByActivity(Long.valueOf(activityId));
        if (activityDy != null) {
            DynamicObject perfWorkflow = PERF_WORK_FLOW_ENTITY_SERVICE.queryOne("ismplevelexchange,mplevelset,mpnumaccuracy,mpscaletype,sumperflevel,scoresystem", (Object)activityDy.getLong("perfworkflow.id"));
            activityDy.set("perfworkflow", (Object)perfWorkflow);
            DynamicObjectCollection timeplanentry = activityDy.getDynamicObjectCollection("timeplanentry");
            for (int i = timeplanentry.size() - 1; i >= 0; --i) {
                DynamicObject perfLevelDyn;
                DynamicObject entry = (DynamicObject)timeplanentry.get(i);
                if (entry.getDynamicObject("activity").getLong("id") == NodeTabMapEnum.EVAL_PROCESS.getNodeId().longValue()) {
                    perfLevelDyn = ScoreAndLevelUtils.getPerfLevelByNodeIdAndActivityDyn(NodeTabMapEnum.EVAL_PROCESS.getNodeId(), activityDy);
                    if (perfLevelDyn == null) continue;
                    resultList.add(perfLevelDyn);
                    continue;
                }
                if (entry.getDynamicObject("activity").getLong("id") != NodeTabMapEnum.PERF_SUM.getNodeId().longValue() || (perfLevelDyn = ScoreAndLevelUtils.getPerfLevelByNodeIdAndActivityDyn(NodeTabMapEnum.PERF_SUM.getNodeId(), activityDy)) == null) continue;
                resultList.add(perfLevelDyn);
            }
        }
        return resultList;
    }

    private static DynamicObject getPerfLevelByNodeIdAndActivityDyn(long assessNodeId, DynamicObject activityDy) {
        DynamicObject result = null;
        if (activityDy != null) {
            boolean isMpLevelExchange;
            DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(Long.valueOf(activityDy.getLong("assessform.id")));
            if (assessNodeId == NodeTabMapEnum.EVAL_PROCESS.getNodeId()) {
                result = assessForm.getDynamicObject("sumperflevel");
            } else if (assessNodeId == NodeTabMapEnum.PERF_SUM.getNodeId() && (isMpLevelExchange = activityDy.getBoolean("perfworkflow.ismplevelexchange"))) {
                String mpLevelSet = activityDy.getString("perfworkflow.mplevelset");
                result = HRStringUtils.equals((String)MpLevelSetEnum.SAME_AS_ASSESSFORM.getCode(), (String)mpLevelSet) && assessForm != null ? assessForm.getDynamicObject("sumperflevel") : activityDy.getDynamicObject("perfworkflow.sumperflevel");
            }
        }
        return result;
    }

    public static Map<Long, Map<String, String>> getPerfLevelEntryMapByPerfLevelIds(List<Long> perfLevelIds, String keyStr, String valueStr) {
        HashMap<Long, Map<String, String>> resultMap = new HashMap<Long, Map<String, String>>(16);
        DynamicObject[] perfLevelDyns = PERF_LEVEL_ENTITY.loadDynamicObjectArray(perfLevelIds.toArray(new Object[0]));
        if (perfLevelDyns != null && perfLevelDyns.length > 0) {
            for (DynamicObject perfLevelDyn : perfLevelDyns) {
                DynamicObjectCollection perfLevelEntry = perfLevelDyn.getDynamicObjectCollection("entryentity");
                LinkedHashMap levelEntryMap = new LinkedHashMap(perfLevelEntry.size());
                perfLevelEntry.forEach(dy -> levelEntryMap.put(String.valueOf(dy.get(keyStr)), String.valueOf(dy.get(valueStr))));
                resultMap.put(perfLevelDyn.getLong("id"), levelEntryMap);
            }
        }
        return resultMap;
    }

    public static Map<String, String> getLevelMapByNodeIdAndActivityId(long assessNodeId, long activityId, String keyStr, String valueStr) {
        DynamicObject perfLevelDyn = ScoreAndLevelUtils.getPerfLevelByNodeIdAndActivityId(assessNodeId, activityId);
        return ScoreAndLevelUtils.getLevelMapByPerfLevelDyn(perfLevelDyn, keyStr, valueStr);
    }

    public static DynamicObject getPerfLevelByNodeIdAndActivityId(long assessNodeId, long activityId) {
        DynamicObject result = null;
        DynamicObject activityDy = ACTIVITY_ENTITY_SERVICE.queryScoreAndLevelConfigByActivity(Long.valueOf(activityId));
        if (activityDy != null) {
            DynamicObject perfWorkflow = PERF_WORK_FLOW_ENTITY_SERVICE.queryOne("ismplevelexchange,mplevelset,mpnumaccuracy,mpscaletype,sumperflevel,scoresystem", (Object)activityDy.getLong("perfworkflow.id"));
            activityDy.set("perfworkflow", (Object)perfWorkflow);
            result = ScoreAndLevelUtils.getPerfLevelByNodeIdAndActivityDyn(assessNodeId, activityDy);
        }
        return result;
    }

    public static Map<String, String> getLevelMapByPerfLevelDyn(DynamicObject perfLevelDyn, String keyStr, String valueStr) {
        long perfLevelId;
        Map<Long, Map<String, String>> perfLevelEntryMapByPerfLevelIds;
        Map<String, String> resultMap = new HashMap<String, String>(16);
        if (perfLevelDyn != null && (perfLevelEntryMapByPerfLevelIds = ScoreAndLevelUtils.getPerfLevelEntryMapByPerfLevelIds(Collections.singletonList(perfLevelId = perfLevelDyn.getLong("id")), keyStr, valueStr)).containsKey(perfLevelId)) {
            resultMap = perfLevelEntryMapByPerfLevelIds.get(perfLevelId);
        }
        return resultMap;
    }

    public static void cacheScoreConfig(IFormView view, long activityId) {
        view.getPageCache().put("numAccuracy", "2");
        view.getPageCache().put("scaleType", ScalaTypeEnum.ROUND_HALF_UP.getValue());
        DynamicObject activityDy = ACTIVITY_ENTITY_SERVICE.queryScoreAndLevelConfigByActivity(Long.valueOf(activityId));
        if (activityDy != null) {
            DynamicObject perfWorkflow = PERF_WORK_FLOW_ENTITY_SERVICE.queryOne("ismplevelexchange,mplevelset,mpnumaccuracy,mpscaletype,sumperflevel,scoresystem", (Object)activityDy.getLong("perfworkflow.id"));
            activityDy.set("perfworkflow", (Object)perfWorkflow);
            DynamicObjectCollection timeplanentry = activityDy.getDynamicObjectCollection("timeplanentry");
            boolean isContainEval = false;
            boolean isContainMp = false;
            for (int i = timeplanentry.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)timeplanentry.get(i);
                if (entry.getDynamicObject("activity").getLong("id") == NodeTabMapEnum.EVAL_PROCESS.getNodeId().longValue()) {
                    isContainEval = true;
                    continue;
                }
                if (entry.getDynamicObject("activity").getLong("id") != NodeTabMapEnum.PERF_SUM.getNodeId().longValue()) continue;
                isContainMp = true;
            }
            view.getPageCache().put("isContainEval", String.valueOf(isContainEval));
            view.getPageCache().put("isContainMp", String.valueOf(isContainMp));
            DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(Long.valueOf(activityDy.getLong("assessform.id")));
            ScoreAndLevelUtils.cacheScoreConfigByAssessForm(view, assessForm);
            if (isContainMp && !isContainEval) {
                String mpNumAccuracy = activityDy.getString("perfworkflow.mpnumaccuracy");
                String mpScaleType = activityDy.getString("perfworkflow.mpscaletype");
                if (HRStringUtils.isNotEmpty((String)mpNumAccuracy)) {
                    view.getPageCache().put("numAccuracy", mpNumAccuracy);
                    view.getPageCache().put("mpNumAccuracy", mpNumAccuracy);
                }
                if (HRStringUtils.isNotEmpty((String)mpScaleType)) {
                    view.getPageCache().put("scaleType", mpScaleType);
                    view.getPageCache().put("mpScaleType", mpScaleType);
                }
            }
        }
    }

    private static void cacheScoreConfigByAssessForm(IFormView view, DynamicObject assessForm) {
        if (assessForm != null) {
            BigDecimal limitMaxRatio;
            view.getPageCache().put("assessFormId", String.valueOf(assessForm.getLong("id")));
            String numAccuracy = assessForm.getString("numaccuracy");
            String scaleType = assessForm.getString("scaletype");
            view.getPageCache().put("numAccuracy", numAccuracy);
            view.getPageCache().put("scaleType", scaleType);
            view.getPageCache().put("sopNumAccuracy", numAccuracy);
            view.getPageCache().put("sopScaleType", scaleType);
            DynamicObject scoresystem = assessForm.getDynamicObject("scoresystem");
            String limitmaxscore = assessForm.getString("limitmaxscore");
            String limitminscore = assessForm.getString("limitminscore");
            String maxscore = scoresystem.getString("maxscore");
            String minscore = scoresystem.getString("minscore");
            String evaSumLimit = assessForm.getString("evasumlimit");
            if (HRStringUtils.isEmpty((String)evaSumLimit) || HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.SUM_LIMIT.getValue())) {
                maxscore = scoresystem.getString("maxscore");
                minscore = scoresystem.getString("minscore");
            } else if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.APPOINT_SUM_LIMIT.getValue())) {
                maxscore = limitmaxscore;
                minscore = limitminscore;
            } else if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.NOT_LIMIT.getValue())) {
                DynamicObjectCollection areaEntry = assessForm.getDynamicObjectCollection("areaconfentry");
                List plusMinusList = areaEntry.stream().filter(entry -> AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(entry.getDynamicObject("areareg").getPkValue())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(plusMinusList)) {
                    Long areaConf = ((DynamicObject)plusMinusList.get(0)).getLong("areaconf");
                    DynamicObject plusMinusConfigDy = ASSESS_RULE_APP_SERVICE.queryPlusMinusConfigByPk(areaConf);
                    BigDecimal maxScore = scoresystem.getBigDecimal("maxscore").add(plusMinusConfigDy.getBigDecimal("pluslimit"));
                    BigDecimal minScore = scoresystem.getBigDecimal("minscore").add(plusMinusConfigDy.getBigDecimal("minuslimit"));
                    maxscore = maxScore.toString();
                    minscore = minScore.toString();
                }
            } else if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue()) && (limitMaxRatio = assessForm.getBigDecimal("limitmaxratio")) != null) {
                BigDecimal maxScore = scoresystem.getBigDecimal("maxscore").multiply(limitMaxRatio).divide(new BigDecimal(100)).setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get((String)scaleType).getType());
                maxscore = maxScore.toString();
            }
            view.getPageCache().put("maxscore", maxscore);
            view.getPageCache().put("minscore", minscore);
            view.getPageCache().put("sopmaxscore", maxscore);
            view.getPageCache().put("sopminscore", minscore);
            ObjEvaluationUtils.ExtPointSetScope(assessForm, view);
        }
    }

    public static String calculateLevel(Long scoreSystemId, Long sumPerfLevelId, BigDecimal score) {
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelId);
        DynamicObjectCollection scoreMapEntry = sumPerfLevel.getDynamicObjectCollection("scoremapentryentity");
        DynamicObject scoreMapDy = scoreMapEntry.stream().filter(scoreMap -> scoreMap.getLong("scoresystem.id") == scoreSystemId.longValue()).findFirst().orElse(null);
        if (scoreMapDy == null) {
            log.error("Unable to find score system mapping for performance level, scoreSystemId[{}], sumPerfLevelId[{}]", (Object)scoreSystemId, (Object)sumPerfLevelId);
            return "";
        }
        String levelScoreMap = scoreMapDy.getString("levelscoremap");
        if (HRStringUtils.equals((String)levelScoreMap, (String)"20")) {
            log.error("Mapping by default is not supported");
            return "";
        }
        DynamicObjectCollection scoreLevelMapEntry = scoreMapDy.getDynamicObjectCollection("scoresubentryentity");
        for (DynamicObject scoreLevelMap : scoreLevelMapEntry) {
            BigDecimal maxScore = scoreLevelMap.getBigDecimal("maxscore");
            String scoreMaxOperation = scoreLevelMap.getString("scoremaxoperation");
            String scoreMinOperation = scoreLevelMap.getString("scoreminoperation");
            BigDecimal minScore = scoreLevelMap.getBigDecimal("minscore");
            boolean maxCompare = true;
            if (maxScore != null && maxScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMaxOperation, (String)"10")) {
                    maxCompare = maxScore.compareTo(score) > 0;
                } else if (HRStringUtils.equals((String)scoreMaxOperation, (String)"20")) {
                    maxCompare = maxScore.compareTo(score) >= 0;
                }
            }
            boolean minCompare = true;
            if (minScore != null && minScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMinOperation, (String)"10")) {
                    minCompare = score.compareTo(minScore) > 0;
                } else if (HRStringUtils.equals((String)scoreMinOperation, (String)"20")) {
                    boolean bl = minCompare = score.compareTo(minScore) >= 0;
                }
            }
            if (!maxCompare || !minCompare) continue;
            return scoreLevelMap.getString("seq");
        }
        return "";
    }
}

