/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaladjustment;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.evaladjustment.ActEvalObjAdjApplicationService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationIsNeedCheckOseService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationUpdateOseService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.impl.SumAreaEvaluationIsNeedCheckServiceImpl;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.impl.SumAreaEvaluationUpdateOseServiceImpl;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;

public class EvalAdjDetailEdit
extends HRDataBaseEdit {
    private static final int SCALE_2 = 2;
    private static final String TITLE = "title";
    private static final ActEvalObjAdjApplicationService APP_SERVICE = ActEvalObjAdjApplicationService.getInstance();
    private static final String ATCSCONTAINER = "atcscontainer";
    private static final String[] INIT_FIELDS = new String[]{"actevalobj", "assessyear", "assessperiod", "activity", "perforg", "flowrunode", "flowrurole", "flowrutask", "flowruproc"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        for (String initField : INIT_FIELDS) {
            Object fieldValue = parameter.getCustomParam(initField);
            if (fieldValue == null) continue;
            this.getModel().setValue(initField, fieldValue);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("flowrutask");
        DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
        if (taskId != null) {
            Long actEvalObjId = (Long)parameter.getCustomParam("actevalobj");
            String taskStatus = taskObj.getString("taskstatus");
            Long id = this.getModel().getDataEntity().getLong("id");
            if (FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus) || id.equals(0L) && FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) {
                DynamicObject actEvalObj = APP_SERVICE.queryActEvalObjById(actEvalObjId);
                BigDecimal batcs = actEvalObj.getBigDecimal("atcs");
                this.getModel().beginInit();
                this.getModel().setValue("batcs", (Object)batcs);
                this.getView().updateView("batcs");
                BigDecimal atv = this.getModel().getDataEntity().getBigDecimal("atv");
                BigDecimal atcs = batcs.add(atv);
                this.getModel().setValue("atcs", (Object)atcs);
                this.getView().updateView("atcs");
                String atcl = actEvalObj.getString("atcl");
                this.getModel().setValue("atcl", (Object)atcl);
                this.getView().updateView("atcl");
                this.getModel().setValue("batcl", (Object)atcl);
                this.getView().updateView("batcl");
                DynamicObject lastSubmitSumRecord = APP_SERVICE.querySumAreaEvalRecordOfPreRoleLastTask(taskId);
                boolean isrollbacked = taskObj.getBoolean("isrollbacked");
                if (lastSubmitSumRecord != null) {
                    if (isrollbacked) {
                        this.getModel().setValue("ins", (Object)lastSubmitSumRecord.getString("ins"));
                    } else {
                        this.getModel().setValue("ins", (Object)lastSubmitSumRecord.getString("eval"));
                    }
                    this.getView().updateView("ins");
                }
                this.getModel().endInit();
                this.getPageCache().put("noNeedSave", "true");
            }
            this.setTitle();
            this.setFieldInfo(taskId);
            this.setAtclComboItems(taskId);
            this.setAtcsColor();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String noNeedSave;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
        if (taskObj == null) {
            IFormView parentView = this.getView().getParentView();
            parentView.getPageCache().remove("subPageOp");
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            parentView.invokeOperation("refresh_entry", option);
            this.getView().sendFormAction(parentView);
            return;
        }
        String taskStatus = taskObj.getString("taskstatus");
        if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(taskStatus)) {
            IFormView parentView = this.getView().getParentView();
            parentView.getPageCache().remove("subPageOp");
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            parentView.invokeOperation("refresh_entry", option);
            this.getView().sendFormAction(parentView);
            return;
        }
        if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u9000\u56de\u3002", (String)"EvalAdjDetailEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (FlowRuTaskStatusEnum.PROCESSED.getCode().equals(taskStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u8bc4\u4f30\u3002", (String)"EvalAdjDetailEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        Long actEvalObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actevalobj");
        DynamicObject evalAdjObj = this.getModel().getDataEntity();
        HashMap<String, String> bgStyle = new HashMap<String, String>(16);
        HashMap<String, String> fcStyle = new HashMap<String, String>(16);
        switch (name) {
            case "batcs": 
            case "atv": {
                boolean isNotOverMark;
                BigDecimal atvNewValue = (BigDecimal)changeData.getNewValue();
                BigDecimal atvOldValue = (BigDecimal)changeData.getOldValue();
                boolean bl = isNotOverMark = HRStringUtils.equals((String)name, (String)"atv") ? this.calAtcsAndAtcl(taskId, actEvalObjId, atvNewValue, atvOldValue, evalAdjObj) : this.calAtcsAndAtcl(taskId, actEvalObjId, evalAdjObj.getBigDecimal("atv"), BigDecimal.ZERO, evalAdjObj);
                if (!isNotOverMark) {
                    return;
                }
                if (BigDecimal.ZERO.compareTo(atvNewValue) < 0) {
                    bgStyle.put("bc", "#e4fde6");
                    fcStyle.put("fc", "#19994d");
                } else if (BigDecimal.ZERO.compareTo(atvNewValue) > 0) {
                    bgStyle.put("bc", "#ffedee");
                    fcStyle.put("fc", "#d80c1e");
                } else {
                    bgStyle.put("bc", "#f5f5f5");
                    fcStyle.put("fc", "#666666");
                }
                this.getView().updateControlMetadata(ATCSCONTAINER, bgStyle);
                this.getView().updateControlMetadata("atcs", fcStyle);
                break;
            }
            case "atcl": {
                APP_SERVICE.saveEvalAdjObj(evalAdjObj);
                break;
            }
            case "ins": {
                LocaleDynamicObjectCollection inscols = (LocaleDynamicObjectCollection)changeData.getNewValue();
                DynamicObjectType newDt = inscols.getDynamicObjectType();
                boolean invalidFlag = Boolean.FALSE;
                for (int i = 0; i < inscols.size(); ++i) {
                    DynamicObject newObj = (DynamicObject)inscols.get(i);
                    String newVal = (String)newDt.getProperty(e.getProperty().getName()).getValue((Object)newObj);
                    if (newVal.length() <= 1000) continue;
                    invalidFlag = Boolean.TRUE;
                    break;
                }
                if (invalidFlag) {
                    this.getView().getModel().setValue("ins", (Object)new LocaleString(""));
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u8c03\u6574\u8bf4\u660e\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,2000]\u3002", (String)"EvalAdjDetailEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    return;
                }
                APP_SERVICE.saveEvalAdjObj(evalAdjObj);
                break;
            }
        }
        APP_SERVICE.processTask(Collections.singletonList(taskId));
        if (HRStringUtils.equals((String)"atv", (String)name) || HRStringUtils.equals((String)"atcl", (String)name)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("flowrutask", taskId.toString());
            option.setVariableValue("atcs", evalAdjObj.getString("atcs"));
            option.setVariableValue("atcl", evalAdjObj.getString("atcl"));
            option.setVariableValue("ishasright", "true");
            IFormView parentView = this.getView().getParentView();
            parentView.getPageCache().put("subPageOp", "true");
            parentView.invokeOperation("refresh", option);
            this.getView().sendFormAction(parentView);
        }
        if (HRStringUtils.isNotEmpty((String)(noNeedSave = this.getPageCache().get("noNeedSave")))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"EvalAdjDetailEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().remove("noNeedSave");
        }
    }

    private void setTitle() {
        Long actEvalObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actevalobj");
        DynamicObject actEvalObj = APP_SERVICE.queryActEvalObjById(actEvalObjId);
        String name = actEvalObj.getString("person.name");
        String title = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u60a8\u5bf9{0}\u7684\u7ee9\u6548\u603b\u8bc4\u4f30\u3002", (String)"EvalAdjDetailEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{name});
        Label titleAp = (Label)this.getControl(TITLE);
        titleAp.setText(title);
        this.getView().updateView(TITLE);
    }

    private void setFieldInfo(Long taskId) {
        Boolean evalModifyItem;
        DynamicObject assessForm;
        int numaccuracy;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        if (status.equals((Object)OperationStatus.VIEW)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"atv"});
        }
        if (HRObjectUtils.isEmpty((Object)(numaccuracy = (assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId)).getInt("numaccuracy")))) {
            numaccuracy = 2;
        }
        HashMap fieldMap = new HashMap();
        HashMap<String, Integer> itemMap = new HashMap<String, Integer>();
        itemMap.put("sc", numaccuracy);
        fieldMap.put("item", itemMap);
        Map permissionMap = APP_SERVICE.queryAdjPermMap(taskId);
        Map atvMap = (Map)permissionMap.get("adjustscore");
        Map atclMap = (Map)permissionMap.get("adjustrank");
        Map insMap = (Map)permissionMap.get("adjustdesc");
        if (atvMap != null && !atvMap.isEmpty()) {
            FieldEdit atvField = (FieldEdit)this.getControl("atv");
            Boolean oseMustInput = (Boolean)atvMap.get("fieldmustinputitem");
            atvField.setMustInput(oseMustInput.booleanValue());
            if (status.equals((Object)OperationStatus.VIEW)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"atv"});
            }
            this.getView().updateControlMetadata("atv", fieldMap);
            this.getView().updateControlMetadata("batcs", fieldMap);
            this.getView().updateControlMetadata("atcs", fieldMap);
        }
        if (atclMap != null && !atclMap.isEmpty()) {
            Boolean atclDisplayItem = (Boolean)atclMap.get("fielddisplayitem");
            Boolean atclMustInput = (Boolean)atclMap.get("fieldmustinputitem");
            evalModifyItem = (Boolean)atclMap.get("fieldmodifyitem");
            if (atclDisplayItem.booleanValue()) {
                FieldEdit atclField = (FieldEdit)this.getControl("atcl");
                atclField.setMustInput(atclMustInput.booleanValue());
                if (status.equals((Object)OperationStatus.VIEW)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"atcl"});
                } else {
                    this.getView().setEnable(evalModifyItem, new String[]{"atcl"});
                }
                this.getView().setVisible(atclDisplayItem, new String[]{"atcl"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"atcl"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"atcl"});
        }
        if (insMap != null && !insMap.isEmpty()) {
            Boolean evalDisplayItem = (Boolean)insMap.get("fielddisplayitem");
            Boolean evalMustInput = (Boolean)insMap.get("fieldmustinputitem");
            evalModifyItem = (Boolean)insMap.get("fieldmodifyitem");
            if (evalDisplayItem.booleanValue()) {
                FieldEdit evalField = (FieldEdit)this.getControl("ins");
                if (evalMustInput != null) {
                    evalField.setMustInput(evalMustInput.booleanValue());
                }
                if (status.equals((Object)OperationStatus.VIEW)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"ins"});
                } else {
                    this.getView().setEnable(evalModifyItem, new String[]{"ins"});
                }
                this.getView().setVisible(evalDisplayItem, new String[]{"ins"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"ins"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ins"});
        }
    }

    private void setAtclComboItems(Long taskId) {
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
        int numaccuracy = assessForm.getInt("numaccuracy");
        if (HRObjectUtils.isEmpty((Object)numaccuracy)) {
            numaccuracy = 2;
        }
        HashMap fieldMap = new HashMap();
        HashMap<String, Integer> itemMap = new HashMap<String, Integer>();
        itemMap.put("sc", numaccuracy);
        fieldMap.put("item", itemMap);
        this.getView().updateControlMetadata("atv", fieldMap);
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(Long.valueOf(assessForm.getLong("sumperflevel.id")));
        ComboEdit comboEdit = (ComboEdit)this.getControl("atcl");
        comboEdit.setComboItems(perfLevelItems);
    }

    private boolean calAtcsAndAtcl(Long taskId, Long actEvalObjId, BigDecimal atvNewValue, BigDecimal atvOldValue, DynamicObject evalAdjObj) {
        BigDecimal finalTotalScoreVal;
        SumAreaEvaluationUpdateOseServiceImpl iService;
        HRPluginProxy hrPluginProxy;
        List ret;
        BigDecimal minScore;
        BigDecimal maxScore;
        DynamicObject viewModel = this.getModel().getDataEntity();
        BigDecimal batcsValue = viewModel.getBigDecimal("batcs");
        BigDecimal atcsOldValue = viewModel.getBigDecimal("atcs");
        if (HRObjectUtils.isEmpty((Object)atvNewValue)) {
            return true;
        }
        DynamicObject defnodeObj = APP_SERVICE.queryAdjustScoreByTaskId(taskId);
        BigDecimal adjusetscorelowerlimit = defnodeObj.getBigDecimal("adjusetscorelowerlimit");
        BigDecimal adjustscoreuplimit = defnodeObj.getBigDecimal("adjustscoreuplimit");
        if (atvNewValue.compareTo(adjusetscorelowerlimit) < 0 || atvNewValue.compareTo(adjustscoreuplimit) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u503c\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff1a{0}~{1}\u3002", (String)"EvalAdjDetailEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{adjusetscorelowerlimit, adjustscoreuplimit}));
            evalAdjObj.set("atv", (Object)BigDecimal.ZERO);
            return false;
        }
        BigDecimal atcs = batcsValue.add(atvNewValue);
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
        Long assessFormId = assessForm.getLong("id");
        String minScoreStr = this.getPageCache().get(assessFormId + "_min");
        String maxScoreStr = this.getPageCache().get(assessFormId + "_max");
        if (HRStringUtils.isEmpty((String)maxScoreStr)) {
            Map scoreRangeMap = APP_SERVICE.getScoreRangeMap(actEvalObjId);
            maxScore = (BigDecimal)scoreRangeMap.get("maxscore");
            minScore = (BigDecimal)scoreRangeMap.get("minscore");
            if (maxScore != null && minScore != null) {
                this.getPageCache().put(assessFormId + "_max", String.valueOf(maxScore));
                this.getPageCache().put(assessFormId + "_min", String.valueOf(minScore));
            }
        } else {
            minScore = new BigDecimal(minScoreStr);
            maxScore = new BigDecimal(maxScoreStr);
        }
        Boolean isNeedCheckOse = true;
        SumAreaEvaluationIsNeedCheckServiceImpl iCheckService = new SumAreaEvaluationIsNeedCheckServiceImpl();
        HRPluginProxy hrCheckPluginProxy = HRPlugInProxyFactory.create((Object)iCheckService, ISumAreaEvaluationIsNeedCheckOseService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationIsNeedCheckOseService#isNeedCheckOse", null);
        List result = hrCheckPluginProxy.callReplaceIfPresent(p -> p.isNeedCheckOse(this.getView()));
        if (result != null && result.size() > 0) {
            isNeedCheckOse = (Boolean)result.get(0);
        }
        if (isNeedCheckOse.booleanValue() && maxScore != null && minScore != null) {
            if (atcs.compareTo(minScore) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\uff0c\u53d6{2}\u3002", (String)"EvalAdjDetailEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore, minScore}));
                evalAdjObj.set("atcs", (Object)minScore);
                atcs = minScore;
                this.getView().updateView("atcs");
            }
            if (atcs.compareTo(maxScore) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\uff0c\u53d6{2}\u3002", (String)"EvalAdjDetailEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore, maxScore}));
                evalAdjObj.set("atcs", (Object)maxScore);
                atcs = maxScore;
                this.getView().updateView("atcs");
            }
        }
        if ((ret = (hrPluginProxy = HRPlugInProxyFactory.create((Object)(iService = new SumAreaEvaluationUpdateOseServiceImpl()), ISumAreaEvaluationUpdateOseService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationUpdateOseService#updateOse", null)).callReplaceIfPresent(arg_0 -> this.lambda$calAtcsAndAtcl$1(finalTotalScoreVal = atcs, arg_0))) != null && ret.size() > 0) {
            atcs = (BigDecimal)ret.get(0);
        }
        evalAdjObj.set("atcs", (Object)atcs);
        this.getView().updateView("atcs");
        String actl = APP_SERVICE.calculateLevel(assessFormId, atcs);
        if (actl != null) {
            evalAdjObj.set("atcl", (Object)actl);
            this.getView().updateView("atcl");
        }
        APP_SERVICE.saveEvalAdjObj(evalAdjObj);
        return true;
    }

    private void setAtcsColor() {
        BigDecimal atv = this.getModel().getDataEntity().getBigDecimal("atv");
        HashMap<String, String> bgStyle = new HashMap<String, String>();
        HashMap<String, String> fcStyle = new HashMap<String, String>();
        if (BigDecimal.ZERO.compareTo(atv) < 0) {
            bgStyle.put("bc", "#e4fde6");
            fcStyle.put("fc", "#19994d");
        } else if (BigDecimal.ZERO.compareTo(atv) > 0) {
            bgStyle.put("bc", "#ffedee");
            fcStyle.put("fc", "#d80c1e");
        } else {
            bgStyle.put("bc", "#f5f5f5");
            fcStyle.put("fc", "#666666");
        }
        this.getView().updateControlMetadata(ATCSCONTAINER, bgStyle);
        this.getView().updateControlMetadata("atcs", fcStyle);
    }

    private /* synthetic */ BigDecimal lambda$calAtcsAndAtcl$1(BigDecimal finalTotalScoreVal, ISumAreaEvaluationUpdateOseService p) {
        return p.updateOse(this.getView(), finalTotalScoreVal);
    }
}

