/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaladjustment;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.Pair;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.evaladjustment.ActEvalObjAdjApplicationService;
import kd.opmc.epa.formplugin.web.activitymanage.evaladjustment.utils.EvalAdjDrawEntryUtil;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationIsNeedCheckOseService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationUpdateOseService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.impl.SumAreaEvaluationIsNeedCheckServiceImpl;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.impl.SumAreaEvaluationUpdateOseServiceImpl;
import kd.opmc.epa.formplugin.web.utils.LevelStatUtils;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;

public class EvaluateAdjustmentEdit
extends HRDataBaseEdit
implements EntryGridBindDataListener {
    private static final String TOOLBAR = "toolbarap";
    private static final String SUBMIT = "submit";
    private static final String REJECT = "reject";
    private static final String SAVE = "save";
    private static final String BATCHADJ = "batchadj";
    private static final String VIEWWF = "viewwf";
    private static final String REFRESH = "refresh";
    private static final String CLOSE = "close";
    private static final String JUMP_RECORD = "jumprecord";
    private static final String ACAP = "acap";
    private static final String PERIODAP = "periodap";
    private static final String SCHEMEAP = "schemeap";
    private static final String EPA_EVALADJ_REJECT = "epa_evaladj_reject";
    private static final String EPA_EVALADJ_EVAL = "epa_evaladj_eval";
    private static final String DETAIL = "detail";
    private static final String APP_ID = "epa";
    private static final String SUBMIT_TASK_CLOSE_BACK = "submit_task_close_back";
    private static final String FAIL_PROCESSED_KEY = "processed";
    private static final String FAIL_RETURNED_KEY = "returned";
    private static final String FAIL_EXPIRED_KEY = "expired";
    private static final String FAIL_MUSTINPUT_KEY = "mustinput";
    private static final Log LOG = LogFactory.getLog(EvaluateAdjustmentEdit.class);
    private static final ActEvalObjAdjApplicationService APP_SERVICE = ActEvalObjAdjApplicationService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter parameter = e.getFormShowParameter();
        List<Map<String, Object>> taskList = this.getTaskList(parameter);
        if (ObjectUtils.isEmpty(taskList)) {
            List<Map<String, Object>> expiredTaskList = this.getExpiredTaskList(parameter);
            if (ObjectUtils.isEmpty(expiredTaskList)) {
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\uff0c\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5904\u7406\u4eba\u3002", (String)"EvaluateAdjustmentEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else {
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvaluateAdjustmentEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
            e.setCancel(true);
            return;
        }
        List taskIdList = taskList.stream().map(task -> (Long)task.get("taskId")).collect(Collectors.toList());
        ArrayList<Object> validateAllList = new ArrayList<Object>(10);
        for (Long tid : taskIdList) {
            Pair checkResult = APP_SERVICE.checkTaskInfo(tid);
            validateAllList.add(checkResult.getKey());
        }
        if (!validateAllList.contains(Boolean.TRUE)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvaluateAdjustmentEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBAR});
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        List<Map<String, Object>> taskList = this.getTaskList(parameter);
        if (!taskList.isEmpty()) {
            Long taskId = (Long)taskList.get(0).get("taskId");
            List personInfoFields = APP_SERVICE.queryAdjPersonInfoFields(taskId);
            List sumAdjFields = APP_SERVICE.querySumAdjConf(taskId);
            boolean isShowLevel = false;
            for (Map sumConfField : sumAdjFields) {
                if (!"atcl".equals(sumConfField.get("id"))) continue;
                isShowLevel = true;
                break;
            }
            parameter.getCustomParams().put("isShowLevel", isShowLevel);
            EvalAdjDrawEntryUtil.drawDynamicEntry(e, personInfoFields, sumAdjFields);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        this.initCellFontColorAndEditable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Long sumperflevel;
        boolean isShowLevel;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List<Map<String, Object>> taskList = this.getTaskList(parameter);
        ChangeData changeData = e.getChangeSet()[0];
        if (HRStringUtils.equals((String)"atv", (String)name)) {
            BigDecimal atvNewValue = (BigDecimal)changeData.getNewValue();
            BigDecimal atvOldValue = (BigDecimal)changeData.getOldValue();
            this.calAtcsAndAtcl(atvNewValue, atvOldValue);
        }
        if (HRStringUtils.equals((String)"ins", (String)name)) {
            LocaleDynamicObjectCollection inscols = (LocaleDynamicObjectCollection)changeData.getNewValue();
            DynamicObjectType newDt = inscols.getDynamicObjectType();
            Boolean invalidFlag = Boolean.FALSE;
            for (int i = 0; i < inscols.size(); ++i) {
                DynamicObject newObj = (DynamicObject)inscols.get(i);
                String newVal = (String)newDt.getProperty(e.getProperty().getName()).getValue((Object)newObj);
                if (newVal.length() <= 1000) continue;
                invalidFlag = Boolean.TRUE;
                break;
            }
            if (invalidFlag.booleanValue()) {
                this.getView().getModel().setValue("ins", (Object)new LocaleString(""));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u8c03\u6574\u8bf4\u660e\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,2000]\u3002", (String)"EvaluateAdjustmentEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (HRStringUtils.equals((String)"atcl", (String)name) && (isShowLevel = ((Boolean)this.getView().getFormShowParameter().getCustomParam("isShowLevel")).booleanValue()) && (sumperflevel = Long.valueOf(this.getPageCache().get("sumperflevel"))) != 0L) {
            String newValue = (String)changeData.getNewValue();
            String oldValue = (String)changeData.getOldValue();
            LevelStatUtils.refreshLevelStat(this.getView(), newValue, oldValue);
        }
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection dynamicObjects = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        this.changeTaskStatus(dynamicObjects, currentIndex);
        DynamicObjectCollection dyObjs = new DynamicObjectCollection();
        dyObjs.add(dynamicObjects.get(currentIndex));
        APP_SERVICE.saveEvalAdjRecord(dyObjs);
        this.initCellFontColorAndEditable();
    }

    private void changeTaskStatus(DynamicObjectCollection dynamicObjects, int currentIndex) {
        Object taskstatus;
        DynamicObject rowObj;
        if (dynamicObjects != null && dynamicObjects.size() > 0 && (rowObj = (DynamicObject)dynamicObjects.get(currentIndex)) != null && !HRObjectUtils.isEmpty((Object)(taskstatus = rowObj.get("taskstatus"))) && HRStringUtils.equals((String)taskstatus.toString(), (String)FlowRuTaskStatusEnum.WAITING.getCode())) {
            Long taskId = rowObj.getLong("flowrutask.id");
            APP_SERVICE.processTask(Collections.singletonList(taskId));
            this.getModel().setValue("taskstatus", (Object)FlowRuTaskStatusEnum.PROCESSING.getCode(), currentIndex);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.freezeEntryCol();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List<Map<String, Object>> taskList = this.getTaskList(parameter);
        if (!taskList.isEmpty()) {
            LevelStatUtils.initLevelStatFlex(this.getView(), (Long)taskList.get(0).get("taskId"));
            this.initActivityInfo(taskList);
            this.initEvalOverlEntry(taskList, Boolean.TRUE);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        switch (key = evt.getItemKey()) {
            case "submit": {
                this.submitTask();
                break;
            }
            case "reject": {
                this.rejectTask();
                break;
            }
            case "save": {
                this.saveEvalAdjRecord();
                break;
            }
            case "batchadj": {
                break;
            }
            case "viewwf": {
                this.viewWF();
                break;
            }
            case "refresh": {
                List<Map<String, Object>> taskList = this.getTaskList(parameter);
                this.initEvalOverlEntry(taskList, Boolean.FALSE);
                break;
            }
            case "close": {
                this.getView().close();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (JUMP_RECORD.equals(operateKey)) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = grid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvaluateAdjustmentEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (selectRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EvaluateAdjustmentEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                DynamicObject[] dataEntitys = grid.getEntryData().getDataEntitys();
                int index = selectRows[0];
                long actObjId = dataEntitys[index].getLong("actevalobj.id");
                this.showEvalRecord(actObjId);
            }
        }
    }

    private void showEvalRecord(long actObjId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_actevalobj_evalres");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId((Object)actObjId);
        baseShowParameter.setPageId(this.getView().getPageId() + actObjId);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String key;
        super.afterDoOperation(eventArgs);
        List<Map<String, Object>> taskList = this.getTaskList(this.getView().getFormShowParameter());
        List taskIdList = taskList.stream().map(taskinfo -> (Long)taskinfo.get("taskId")).collect(Collectors.toList());
        Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(taskIdList);
        switch (key = eventArgs.getOperateKey()) {
            case "detail": {
                int selectedRow = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject dyObj = this.getModel().getEntryRowEntity("entryentity", selectedRow);
                Long actEvalObjId = dyObj.getLong("actevalobj.id");
                Long taskId = dyObj.getLong("flowrutask.id");
                String taskStatusStr = (String)taskStatusMap.get(taskId);
                FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
                if (FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus) || taskStatus == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvaluateAdjustmentEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    this.initEvalOverlEntry(taskList, Boolean.FALSE);
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("epa_evalmulti_adjdetail");
                formShowParameter.setStatus(OperationStatus.VIEW);
                formShowParameter.setHasRight(true);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam("taskId", (Object)taskId);
                formShowParameter.setCustomParam("actevalobj", (Object)actEvalObjId);
                formShowParameter.setCustomParam("batchTaskId", this.getView().getFormShowParameter().getCustomParam("batchTaskId"));
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u4ed6\u4eba\u8bc4\u4f30\u8be6\u60c5", (String)"EvaluateAdjustmentEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "refresh": {
                this.initEvalOverlEntry(taskList, Boolean.FALSE);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String cacheKey = this.getPageCache().get("cacheKey");
        if (HRStringUtils.isNotEmpty((String)cacheKey)) {
            IHRAppCache cache = HRAppCache.get((String)APP_ID);
            cache.remove(cacheKey);
            cache.remove(cacheKey + "pageId");
            this.getPageCache().remove(cacheKey);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        switch (actionId) {
            case "epa_evaladj_eval": {
                if (HRObjectUtils.isEmpty((Object)returnData)) break;
                Map data = (Map)returnData;
                BigDecimal ose = (BigDecimal)data.get("ose");
                String ole = (String)data.get("ole");
                if (HRStringUtils.isEmpty((String)ole)) {
                    ole = "";
                }
                String eval = (String)data.get("eval");
                EntryGrid grid = (EntryGrid)this.getControl("entryentity");
                DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
                int[] selectRows = grid.getSelectRows();
                DynamicObjectCollection dyObjs = new DynamicObjectCollection();
                ArrayList<String> processedList = new ArrayList<String>(10);
                ArrayList<String> returnedList = new ArrayList<String>(10);
                ArrayList<String> expiredList = new ArrayList<String>(10);
                ArrayList<Long> selectedTaskIdList = new ArrayList<Long>(10);
                for (int selectRow : selectRows) {
                    DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                    DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                    selectedTaskIdList.add(flowrutask.getLong("id"));
                }
                Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(selectedTaskIdList);
                for (int row : selectRows) {
                    DynamicObject evalSumObj = (DynamicObject)entity.get(row);
                    String name = evalSumObj.getString("name");
                    String number = evalSumObj.getString("number");
                    Long tId = evalSumObj.getLong("flowrutask.id");
                    String taskStatusStr = (String)taskStatusMap.get(tId);
                    FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
                    if (FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus)) {
                        processedList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\u4efb\u52a1\u5df2\u5b8c\u6210\u8bc4\u4f30\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u8bc4\u4f30\u3002", (String)"EvaluateAdjustmentEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus)) {
                        returnedList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\u4efb\u52a1\u5df2\u9000\u56de\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u8bc4\u4f30\u3002", (String)"EvaluateAdjustmentEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus)) {
                        expiredList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\u4efb\u52a1\u5df2\u5931\u6548\uff0c\u4e0d\u652f\u6301\u8bc4\u4f30\u64cd\u4f5c\u3002", (String)"EvaluateAdjustmentEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (!FlowRuTaskStatusEnum.WAITING.equals((Object)taskStatus) && !FlowRuTaskStatusEnum.PROCESSING.equals((Object)taskStatus)) continue;
                    this.getModel().setValue("ose", (Object)ose, row);
                    this.getModel().setValue("ole", (Object)ole, row);
                    this.getModel().setValue("eval", (Object)eval, row);
                    evalSumObj.set("ose", (Object)ose);
                    evalSumObj.set("ole", (Object)ole);
                    evalSumObj.set("eval", (Object)eval);
                    dyObjs.add((Object)evalSumObj);
                }
                if (returnedList.isEmpty() && processedList.isEmpty() && expiredList.isEmpty()) {
                    APP_SERVICE.saveEvalAdjRecord(dyObjs);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"EvaluateAdjustmentEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    break;
                }
                HashMap<String, Object> failMap = new HashMap<String, Object>(16);
                failMap.put(FAIL_PROCESSED_KEY, processedList);
                failMap.put(FAIL_RETURNED_KEY, returnedList);
                failMap.put(FAIL_EXPIRED_KEY, expiredList);
                int success = selectRows.length - processedList.size() - returnedList.size() - expiredList.size();
                this.showBatchForm(selectRows.length, success, failMap, ResManager.loadKDString((String)"\u6279\u91cf\u8bc4\u4f30", (String)"EvaluateAdjustmentEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                if (success != 0) {
                    APP_SERVICE.saveEvalAdjRecord(dyObjs);
                }
                List<Map<String, Object>> entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
                this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
                break;
            }
            case "epa_evaladj_reject": {
                if (HRObjectUtils.isEmpty((Object)returnData)) break;
                Map data = (Map)returnData;
                ArrayList<Long> taskIdList = new ArrayList<Long>(10);
                String reason = (String)data.get("reason");
                EntryGrid grid = (EntryGrid)this.getControl("entryentity");
                DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
                int[] selectRows = grid.getSelectRows();
                ArrayList<String> processedList = new ArrayList<String>(10);
                ArrayList<String> returnedList = new ArrayList<String>(10);
                ArrayList<String> expiredList = new ArrayList<String>(10);
                ArrayList<Long> selectedTaskIdList = new ArrayList<Long>(10);
                for (int selectRow : selectRows) {
                    DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                    DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                    selectedTaskIdList.add(flowrutask.getLong("id"));
                }
                Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(selectedTaskIdList);
                for (int row : selectRows) {
                    DynamicObject dynamicObject = (DynamicObject)entity.get(row);
                    Long tId = dynamicObject.getLong("flowrutask.id");
                    String taskStatusStr = (String)taskStatusMap.get(tId);
                    String name = dynamicObject.getString("name");
                    String number = dynamicObject.getString("number");
                    FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
                    if (FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus)) {
                        processedList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\u4efb\u52a1\u5df2\u5b8c\u6210\u8bc4\u4f30\uff0c\u65e0\u6cd5\u9000\u56de\u3002", (String)"EvaluateAdjustmentEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus)) {
                        returnedList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\u4efb\u52a1\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u9000\u56de\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"EvaluateAdjustmentEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus)) {
                        expiredList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\u4efb\u52a1\u5df2\u5931\u6548\uff0c\u4e0d\u652f\u6301\u9000\u56de\u64cd\u4f5c\u3002", (String)"EvaluateAdjustmentEdit_14", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    taskIdList.add(dynamicObject.getLong("flowrutask.id"));
                }
                if (returnedList.isEmpty() && processedList.isEmpty() && expiredList.isEmpty()) {
                    List<RollbackParamBo> rollbackParamBoList = this.assembleRollbackParam(taskIdList, reason);
                    APP_SERVICE.rollbackToLastNodeOrRole(rollbackParamBoList);
                    List<Map<String, Object>> entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
                    this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u56de\u6210\u529f\u3002", (String)"EvaluateAdjustmentEdit_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    break;
                }
                HashMap<String, Object> failMap = new HashMap<String, Object>(16);
                failMap.put(FAIL_PROCESSED_KEY, processedList);
                failMap.put(FAIL_RETURNED_KEY, expiredList);
                failMap.put(FAIL_EXPIRED_KEY, returnedList);
                int success = selectRows.length - processedList.size() - returnedList.size();
                this.showBatchForm(selectRows.length, success, failMap, ResManager.loadKDString((String)"\u6279\u91cf\u9000\u56de", (String)"EvaluateAdjustmentEdit_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                if (success != 0) {
                    List<RollbackParamBo> rollbackParamBoList = this.assembleRollbackParam(taskIdList, reason);
                    APP_SERVICE.rollbackToLastNodeOrRole(rollbackParamBoList);
                }
                List<Map<String, Object>> entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
                this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
                break;
            }
            case "submit_task_close_back": {
                break;
            }
        }
    }

    private List<RollbackParamBo> assembleRollbackParam(List<Long> taskIdList, String reason) {
        ArrayList<RollbackParamBo> rollbackParamBoList = new ArrayList<RollbackParamBo>(10);
        DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(taskIdList);
        Map taskMap = Arrays.stream(taskObjs).collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
        for (int i = 0; i < taskIdList.size(); ++i) {
            Long taskId = taskIdList.get(i);
            DynamicObject taskObj = (DynamicObject)taskMap.get(taskId);
            RollbackParamBo rollbackParamBo = new RollbackParamBo();
            rollbackParamBo.setRuProcId(Long.valueOf(taskObj.getLong("flowruproc.id")));
            rollbackParamBo.setRuNodeId(Long.valueOf(taskObj.getLong("flowrunode.id")));
            rollbackParamBo.setRollbackType("2");
            rollbackParamBo.setMergeTask(Boolean.valueOf(false));
            rollbackParamBo.setRuTaskId(taskId);
            rollbackParamBo.setReason(reason);
            rollbackParamBoList.add(rollbackParamBo);
        }
        return rollbackParamBoList;
    }

    private void freezeEntryCol() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.setColumnProperty("name", "isFixed", (Object)true);
            entryGrid.setColumnProperty("number", "isFixed", (Object)true);
        }
    }

    private boolean checkOpenLock(List<Map<String, Object>> maps) {
        if (maps != null && maps.size() > 0) {
            List taskIds = maps.stream().map(value -> (Long)value.get("taskId")).collect(Collectors.toList());
            Map<String, Object> map = maps.get(0);
            String activity = String.valueOf(map.get("activity"));
            String flowRuNode = String.valueOf(map.get("flowrunode"));
            String flowRuRole = String.valueOf(map.get("flowrurole"));
            String handler = String.valueOf(map.get("handler"));
            String cacheKey = activity + flowRuNode + flowRuRole + handler;
            IHRAppCache cache = HRAppCache.get((String)APP_ID);
            String pageId = (String)cache.get(cacheKey + "pageId", String.class);
            if (pageId != null) {
                IFormView view = this.getView().getView(pageId);
                if (view == null) {
                    cache.remove(cacheKey);
                }
            } else {
                cache.remove(cacheKey);
                cache.put(cacheKey + "pageId", (Object)this.getView().getPageId());
            }
            List lockTaskIds = (List)cache.get(cacheKey, List.class);
            if (lockTaskIds == null) {
                cache.put(cacheKey, taskIds);
                cache.put(cacheKey + "pageId", (Object)this.getView().getPageId());
            } else if (lockTaskIds.stream().anyMatch(taskIds::contains)) {
                IFormView view = this.getView().getParentView() != null ? this.getView().getParentView() : this.getView();
                view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5728\u5176\u4ed6\u9875\u7b7e\u6253\u5f00", (String)"EvaluateAdjustmentEdit_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(view);
                cache.remove(cacheKey);
                this.getView().close();
                return false;
            }
            this.getPageCache().put("cacheKey", cacheKey);
        }
        return true;
    }

    private void saveEvalAdjRecord() {
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        int[] selectRows = grid.getSelectRows();
        List<Map<String, Object>> taskList = this.getTaskList(this.getView().getFormShowParameter());
        List taskIdList = taskList.stream().map(taskinfo -> (Long)taskinfo.get("taskId")).collect(Collectors.toList());
        Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(taskIdList);
        DynamicObjectCollection dyObjs = new DynamicObjectCollection();
        Boolean invalidFlag = Boolean.FALSE;
        for (int selectRow : selectRows) {
            DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
            DynamicObject taskObj = rowObj.getDynamicObject("flowrutask");
            Long tId = taskObj.getLong("id");
            String taskStatusStr = (String)taskStatusMap.get(tId);
            FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
            if (FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus) || FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus) || FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u201c\u5f85\u8bc4\u4f30\u201d\u53ca\u201c\u8bc4\u4f30\u4e2d\u201d\u7684\u4efb\u52a1\u652f\u6301\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"EvaluateAdjustmentEdit_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                invalidFlag = Boolean.TRUE;
                break;
            }
            dyObjs.add((Object)rowObj);
        }
        if (!invalidFlag.booleanValue()) {
            if (dyObjs.size() > 0) {
                APP_SERVICE.saveEvalAdjRecord(dyObjs);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"EvaluateAdjustmentEdit_19", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvaluateAdjustmentEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
        this.initEvalOverlEntry(taskList, Boolean.FALSE);
    }

    private void viewWF() {
        List<Map<String, Object>> taskList = this.getTaskList(this.getView().getFormShowParameter());
        List taskIdList = taskList.stream().map(taskinfo -> (Long)taskinfo.get("taskId")).collect(Collectors.toList());
        Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(taskIdList);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvaluateAdjustmentEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else if (selectRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EvaluateAdjustmentEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObjectCollection entries = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
            Long taskId = ((DynamicObject)entries.get(selectRows[0])).getLong("flowrutask.id");
            String taskStatusStr = (String)taskStatusMap.get(taskId);
            FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
            if (FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus) || taskStatus == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvaluateAdjustmentEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.initEvalOverlEntry(taskList, Boolean.FALSE);
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            DynamicObject evalflowinsObj = APP_SERVICE.queryFlowRuProcByTaskId(taskId);
            formShowParameter.setCustomParam("evalflowinsId", (Object)evalflowinsObj.getLong("id"));
            formShowParameter.setCustomParam("taskId", (Object)taskId);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("epa_workflow_proc");
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("600");
            styleCss.setHeight("600");
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            this.getView().showForm(formShowParameter);
        }
    }

    private Boolean checkValidate() {
        boolean checkFlag = true;
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            checkFlag = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvaluateAdjustmentEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return checkFlag;
    }

    private void submitTask() {
        boolean checkFlag = this.checkValidate();
        if (checkFlag) {
            List<Map<String, Object>> entryTaskIdList;
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = grid.getSelectRows();
            ArrayList<Long> selectedTaskIdList = new ArrayList<Long>(10);
            for (int selectRow : selectRows) {
                DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                selectedTaskIdList.add(flowrutask.getLong("id"));
            }
            Long firstTaskId = ((DynamicObject)entity.get(0)).getLong("flowrutask.id");
            Map mustInputMap = APP_SERVICE.querySumMustInputMap(firstTaskId);
            Boolean atvMustInput = (Boolean)mustInputMap.get("atv");
            Boolean atclMustInput = (Boolean)mustInputMap.get("atcl");
            Boolean insMustInput = (Boolean)mustInputMap.get("ins");
            Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(selectedTaskIdList);
            DynamicObjectCollection dyObjs = new DynamicObjectCollection();
            ArrayList<Long> taskIdList = new ArrayList<Long>(10);
            HashMap<String, Object> failMap = new HashMap<String, Object>(16);
            ArrayList<String> processedList = new ArrayList<String>(10);
            ArrayList<String> returnedList = new ArrayList<String>(10);
            ArrayList<String> expiredList = new ArrayList<String>(10);
            ArrayList<String> mustInputInvalidList = new ArrayList<String>(10);
            for (int selectRow : selectRows) {
                String ins;
                String atcl;
                DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                Long tId = flowrutask.getLong("id");
                String taskStatusStr = (String)taskStatusMap.get(tId);
                String name = rowObj.getString("name");
                String number = rowObj.getString("number");
                FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
                if (FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus)) {
                    processedList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\u4efb\u52a1\u5df2\u5b8c\u6210\u8bc4\u4f30\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u63d0\u4ea4\u3002", (String)"EvaluateAdjustmentEdit_20", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                    continue;
                }
                if (FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus)) {
                    returnedList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\u4efb\u52a1\u5df2\u9000\u56de\uff0c\u4e0d\u652f\u6301\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"EvaluateAdjustmentEdit_21", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                    continue;
                }
                if (FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus)) {
                    expiredList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\u4efb\u52a1\u5df2\u5931\u6548\uff0c\u4e0d\u652f\u6301\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"EvaluateAdjustmentEdit_22", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                    continue;
                }
                ArrayList<String> mustInputErrorList = new ArrayList<String>(10);
                BigDecimal atv = rowObj.getBigDecimal("atv");
                if (HRObjectUtils.isEmpty((Object)atv) && atvMustInput.booleanValue()) {
                    mustInputErrorList.add(ResManager.loadKDString((String)"\u8c03\u6574\u5206", (String)"EvaluateAdjustmentEdit_23", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
                if (HRObjectUtils.isEmpty((Object)(atcl = rowObj.getString("atcl"))) && atclMustInput.booleanValue()) {
                    mustInputErrorList.add(ResManager.loadKDString((String)"\u603b\u7b49\u7ea7", (String)"EvaluateAdjustmentEdit_24", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
                if (HRObjectUtils.isEmpty((Object)(ins = rowObj.getString("ins"))) && insMustInput.booleanValue()) {
                    mustInputErrorList.add(ResManager.loadKDString((String)"\u8c03\u6574\u8bf4\u660e", (String)"EvaluateAdjustmentEdit_25", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
                if (mustInputErrorList.size() == 1) {
                    mustInputInvalidList.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199{0}\u3001{1} \u3001{2}\u3002", (String)"EvaluateAdjustmentEdit_26", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number, mustInputErrorList.get(0)}));
                    continue;
                }
                if (mustInputErrorList.size() == 2) {
                    mustInputInvalidList.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199{0}\u3001{1}\u3001{2}\u3001{3}\u3002", (String)"EvaluateAdjustmentEdit_27", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number, mustInputErrorList.get(0), mustInputErrorList.get(1)}));
                    continue;
                }
                if (mustInputErrorList.size() == 3) {
                    mustInputInvalidList.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199{0}\u3001{1}\u3001{2}\u3001{3}\u3001{4}\u3002", (String)"EvaluateAdjustmentEdit_28", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number, mustInputErrorList.get(0), mustInputErrorList.get(1), mustInputErrorList.get(2)}));
                    continue;
                }
                dyObjs.add((Object)rowObj);
                Long taskId = flowrutask.getLong("id");
                taskIdList.add(taskId);
            }
            if (!(processedList.isEmpty() && returnedList.isEmpty() && expiredList.isEmpty())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u201c\u5f85\u8bc4\u4f30\u201d\u53ca\u201c\u8bc4\u4f30\u4e2d\u201d\u7684\u4efb\u52a1\u652f\u6301\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"EvaluateAdjustmentEdit_29", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
                this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
                return;
            }
            APP_SERVICE.saveEvalAdjRecord(dyObjs);
            if (!taskIdList.isEmpty()) {
                APP_SERVICE.submitTask(taskIdList);
                APP_SERVICE.updateActEvalObjInfo(taskIdList);
            }
            failMap.put(FAIL_PROCESSED_KEY, processedList);
            failMap.put(FAIL_RETURNED_KEY, returnedList);
            failMap.put(FAIL_EXPIRED_KEY, expiredList);
            failMap.put(FAIL_MUSTINPUT_KEY, mustInputInvalidList);
            if (selectRows.length == taskIdList.size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"EvaluateAdjustmentEdit_30", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else {
                this.showBatchForm(selectRows.length, taskIdList.size(), failMap, ResManager.loadKDString((String)"\u6279\u91cf\u63d0\u4ea4", (String)"EvaluateAdjustmentEdit_31", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
            entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
            this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
        }
    }

    private void rejectTask() {
        boolean checkFlag = this.checkValidate();
        if (checkFlag) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            int[] selectRows = grid.getSelectRows();
            ArrayList<Long> taskIdList = new ArrayList<Long>(10);
            for (int selectRow : selectRows) {
                DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                Long tId = flowrutask.getLong("id");
                taskIdList.add(tId);
            }
            Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(taskIdList);
            Boolean invalidFlag = Boolean.FALSE;
            for (int selectRow : selectRows) {
                DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                Long tId = flowrutask.getLong("id");
                String taskStatusStr = (String)taskStatusMap.get(tId);
                FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
                if (!FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus) && !FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus) && !FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u201c\u5f85\u8bc4\u4f30\u201d\u53ca\u201c\u8bc4\u4f30\u4e2d\u201d\u7684\u4efb\u52a1\u652f\u6301\u9000\u56de\u64cd\u4f5c\u3002", (String)"EvaluateAdjustmentEdit_32", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                invalidFlag = Boolean.TRUE;
                break;
            }
            if (invalidFlag.booleanValue()) {
                List<Map<String, Object>> entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
                this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
            } else {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_batchreject");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("taskIdList", (Object)JSON.toJSONString(taskIdList));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EPA_EVALADJ_REJECT));
                showParameter.setHasRight(true);
                this.getView().showForm(showParameter);
            }
        }
    }

    private void showBatchForm(int total, int success, Map<String, Object> failMap, String caption) {
        List processedList = (List)failMap.get(FAIL_PROCESSED_KEY);
        List expiredList = (List)failMap.get(FAIL_EXPIRED_KEY);
        List returnedList = (List)failMap.get(FAIL_RETURNED_KEY);
        List mustInputInvalidList = (List)failMap.get(FAIL_MUSTINPUT_KEY);
        List failList = Stream.concat(processedList.stream(), returnedList.stream()).collect(Collectors.toList());
        if (total == returnedList.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u9000\u56de\u3002", (String)"EvaluateAdjustmentEdit_33", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (total == processedList.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u8bc4\u4f30\u3002", (String)"EvaluateAdjustmentEdit_34", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (mustInputInvalidList != null && !mustInputInvalidList.isEmpty()) {
            if (total == mustInputInvalidList.size()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"EvaluateAdjustmentEdit_35", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            failList.addAll(mustInputInvalidList);
        }
        if (total == expiredList.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvaluateAdjustmentEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("total", (Object)total);
        formShowParameter.setCustomParam("success", (Object)success);
        formShowParameter.setCustomParam("fail", (Object)JSON.toJSONString(failList));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("epa_evaloverall_batchmsg");
        formShowParameter.setCaption(caption);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("460px");
        styleCss.setHeight("294px");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm(formShowParameter);
    }

    private void initActivityInfo(List<Map<String, Object>> taskList) {
        Long taskId = (Long)taskList.get(0).get("taskId");
        DynamicObject activityObj = APP_SERVICE.queryActivityByTaskId(taskId);
        String activityName = activityObj.getString("name");
        Label acap = (Label)this.getView().getControl(ACAP);
        acap.setText(activityName);
        String activityPeriod = activityObj.getString("period");
        Label periodap = (Label)this.getView().getControl(PERIODAP);
        periodap.setText(activityPeriod);
        DynamicObject assessscopeObj = activityObj.getDynamicObject("executescheme.assessscope");
        Label schemeap = (Label)this.getView().getControl(SCHEMEAP);
        schemeap.setText(assessscopeObj.getString("name"));
    }

    private void initEvalOverlEntry(List<Map<String, Object>> taskList, Boolean isInit) {
        DynamicObject[] actEvalObjAdjRecord;
        Map<Long, DynamicObject> taskActEvalObjMap;
        if (taskList == null || taskList.size() == 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
            return;
        }
        List actEvalObjIdList = taskList.stream().map(taskinfo -> (Long)taskinfo.get("actEvaObjId")).collect(Collectors.toList());
        DynamicObject[] actEvalObjs = APP_SERVICE.queryEvalObjById(actEvalObjIdList);
        Map actEvalObjMap = Arrays.asList(actEvalObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
        List perffilesIdList = Arrays.asList(actEvalObjs).stream().map(actEvalObj -> actEvalObj.getLong("perffile.id")).collect(Collectors.toList());
        DynamicObject[] perffiles = APP_SERVICE.queryPerffileById(perffilesIdList);
        Map<Long, DynamicObject> perffilesMap = Arrays.asList(perffiles).stream().collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
        List<Long> taskIdList = taskList.stream().map(taskinfo -> (Long)taskinfo.get("taskId")).collect(Collectors.toList());
        List<LinkedHashMap<String, Object>> recordList = this.assembleData(taskIdList, taskActEvalObjMap = taskList.stream().collect(Collectors.toMap(x -> (Long)x.get("taskId"), y -> (DynamicObject)actEvalObjMap.get((Long)y.get("actEvaObjId")))), perffilesMap, actEvalObjAdjRecord = APP_SERVICE.queryEvalObjAdjRecordByTaskId(taskIdList));
        if (recordList.isEmpty()) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
            return;
        }
        recordList = recordList.stream().sorted(Comparator.comparing(obj -> ((LinkedHashMap)obj).get("taskstatus").toString()).thenComparing(obj -> ((LinkedHashMap)obj).get("number").toString())).collect(Collectors.toList());
        if (!isInit.booleanValue() && recordList.isEmpty()) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
            return;
        }
        this.addEntryRowAndSetInitData(recordList);
        this.initCellFontColorAndEditable();
    }

    private List<LinkedHashMap<String, Object>> assembleData(List<Long> taskIdList, Map<Long, DynamicObject> taskActEvalObjMap, Map<Long, DynamicObject> perffilesMap, DynamicObject[] actEvalObjAdjRecord) {
        DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(taskIdList);
        Map<Long, String> taskStatusMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("taskstatus"), (v1, v2) -> v2));
        List actEvalAdjTaskIdList = Arrays.asList(actEvalObjAdjRecord).stream().map(record -> record.getLong("flowrutask.id")).collect(Collectors.toList());
        ArrayList<LinkedHashMap<String, Object>> recordList = new ArrayList<LinkedHashMap<String, Object>>(10);
        Collection<DynamicObject> actEvalObjs = taskActEvalObjMap.values();
        List actEvalObjIds = actEvalObjs.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        DynamicObject[] evalSumRecord = APP_SERVICE.querySumRecordByActEvalObjIds(actEvalObjIds);
        Map evalSumMap = Arrays.stream(evalSumRecord).collect(Collectors.toMap(x -> x.getLong("flowrutask.id"), Function.identity(), (v1, v2) -> v2));
        HashMap<String, Integer> levelStatMap = new HashMap<String, Integer>(8);
        if (taskIdList != null && !taskIdList.isEmpty()) {
            DynamicObject actEvalObject = taskActEvalObjMap.get(taskIdList.get(0));
            Map scoreRangeMap = APP_SERVICE.getScoreRangeMap(Long.valueOf(actEvalObject.getLong("id")));
            BigDecimal maxScore = (BigDecimal)scoreRangeMap.get("maxscore");
            BigDecimal minScore = (BigDecimal)scoreRangeMap.get("minscore");
            for (int i = 0; i < taskIdList.size(); ++i) {
                Long taskId = taskIdList.get(i);
                LinkedHashMap<String, Object> record2 = new LinkedHashMap<String, Object>(16);
                DynamicObject actEvalObj = taskActEvalObjMap.get(taskId);
                String taskStatus = taskStatusMap.get(taskId);
                record2.put("actevalobj", actEvalObj.getLong("id"));
                record2.put("perffile", actEvalObj.getLong("perffile.id"));
                record2.put("flowrutask", taskId);
                record2.put("name", actEvalObj.getString("perffile.name"));
                record2.put("number", actEvalObj.getString("perffile.billno"));
                record2.put("adminorg", actEvalObj.getString("perffile.adminOrg.name"));
                record2.put("position", actEvalObj.getString("perffile.position.name"));
                record2.put("job", actEvalObj.getString("perffile.job.name"));
                record2.put("adminorgbd", actEvalObj.getLong("perffile.adminOrg.id"));
                record2.put("positionbd", actEvalObj.getLong("perffile.position.id"));
                record2.put("jobbd", actEvalObj.getLong("perffile.job.id"));
                DynamicObject perffile = perffilesMap.get(actEvalObj.getLong("perffile.id"));
                record2.put("adminorgst", perffile.getString("adminOrg.sortcode"));
                record2.put("positionindex", perffile.getString("position.index"));
                record2.put("person", perffile.getLong("depemp.person.id"));
                if (!actEvalAdjTaskIdList.contains(taskId)) {
                    record2.put("adjrecord", 0L);
                    record2.put("batcs", actEvalObj.getBigDecimal("atcs"));
                    record2.put("atv", BigDecimal.ZERO);
                    record2.put("atcs", actEvalObj.getBigDecimal("atcs"));
                    DynamicObject lastSubmitSumRecord = APP_SERVICE.querySumAreaEvalRecordOfPreRoleLastTask(taskId);
                    if (FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                        if (lastSubmitSumRecord != null) {
                            record2.put("ins", lastSubmitSumRecord.getString("eval"));
                        } else {
                            record2.put("ins", "");
                        }
                    } else {
                        record2.put("ins", "");
                    }
                    record2.put("batcl", actEvalObj.getString("atcl"));
                    record2.put("atcl", actEvalObj.getString("atcl"));
                } else {
                    DynamicObject adjRecObj = Arrays.asList(actEvalObjAdjRecord).stream().filter(obj -> taskId.equals(obj.getLong("flowrutask.id"))).findFirst().orElse(null);
                    if (!HRObjectUtils.isEmpty((Object)adjRecObj)) {
                        record2.put("adjrecord", adjRecObj.getLong("id"));
                        BigDecimal atv = adjRecObj.getBigDecimal("atv");
                        BigDecimal atcs = adjRecObj.getBigDecimal("atcs");
                        if (FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                            BigDecimal batcs = actEvalObj.getBigDecimal("atcs");
                            record2.put("batcs", batcs);
                            record2.put("atv", atv);
                            atcs = batcs.add(atv);
                            if (maxScore != null && minScore != null) {
                                atcs = atcs.compareTo(minScore) < 0 ? minScore : atcs;
                                atcs = atcs.compareTo(maxScore) > 0 ? maxScore : atcs;
                                record2.put("atcs", atcs);
                            } else {
                                record2.put("atcs", atcs);
                            }
                        } else {
                            record2.put("batcs", adjRecObj.getBigDecimal("batcs"));
                            record2.put("atv", atv);
                            record2.put("atcs", atcs);
                        }
                        DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
                        boolean isrollbacked = taskObj.getBoolean("isrollbacked");
                        Long preEvalTaskId = APP_SERVICE.queryPreRoleLastTaskOfNextEval(taskId);
                        if (preEvalTaskId != null && preEvalTaskId != 0L) {
                            DynamicObject lastSubmitSumRecord = APP_SERVICE.querySumAreaEvalRecord(preEvalTaskId);
                            if (FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                                if (lastSubmitSumRecord != null) {
                                    if (isrollbacked) {
                                        record2.put("ins", adjRecObj.getString("ins"));
                                    } else {
                                        record2.put("ins", lastSubmitSumRecord.getString("eval"));
                                    }
                                } else {
                                    record2.put("ins", adjRecObj.getString("ins"));
                                }
                            } else {
                                record2.put("ins", adjRecObj.getString("ins"));
                            }
                        } else {
                            record2.put("ins", adjRecObj.getString("ins"));
                        }
                        if (FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                            String batcl = actEvalObj.getString("atcl");
                            record2.put("batcl", batcl);
                            record2.put("atcl", batcl);
                        } else {
                            record2.put("batcl", adjRecObj.getString("batcl"));
                            record2.put("atcl", adjRecObj.getString("atcl"));
                        }
                    }
                }
                String oleStr = (String)record2.get("atcl");
                Integer levelStat = (Integer)levelStatMap.get(oleStr);
                if (levelStat == null) {
                    levelStat = 0;
                }
                Integer n = levelStat;
                Integer n2 = levelStat = Integer.valueOf(levelStat + 1);
                levelStatMap.put(oleStr, levelStat);
                record2.put("taskstatus", taskStatus);
                recordList.add(record2);
            }
        }
        levelStatMap.put("total", recordList.size());
        LevelStatUtils.initLevelStat(this.getView(), null, levelStatMap);
        return recordList;
    }

    private void addEntryRowAndSetInitData(List<LinkedHashMap<String, Object>> recordList) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (Map.Entry<String, Object> entry : recordList.get(0).entrySet()) {
            vs.addField(entry.getKey(), new Object[0]);
        }
        for (LinkedHashMap linkedHashMap : recordList) {
            vs.addRow(linkedHashMap.values().toArray());
        }
        int count = vs.getCount();
        if (count > 0) {
            AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
            abstractFormDataModel.deleteEntryData("entryentity");
            abstractFormDataModel.beginInit();
            abstractFormDataModel.batchCreateNewEntryRow("entryentity", vs);
            abstractFormDataModel.endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void initToolBar(List<Map<String, Object>> taskList) {
        Long taskId = (Long)taskList.get(0).get("taskId");
        boolean isCrossOver = (Boolean)taskList.get(0).get("iscrossevaluate");
        if (isCrossOver) {
            this.getView().setVisible(Boolean.FALSE, new String[]{REJECT, "ose", "ole", "eval"});
        } else {
            Boolean firstNodeAndRole = APP_SERVICE.isFirstNodeAndRole(taskId);
            if (firstNodeAndRole.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{REJECT});
            } else {
                Boolean crossNodeOfPreRule = APP_SERVICE.isCrossNodeOfPreRole(taskId);
                if (crossNodeOfPreRule.booleanValue()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{REJECT});
                }
            }
        }
    }

    private FormShowParameter getFilterCustomParam() {
        String taskStatusValue;
        String personIdStr;
        String positionIdStr;
        IPageCache pageCache = this.getPageCache();
        FormShowParameter showParameter = new FormShowParameter();
        String adminOrgIdStr = pageCache.get("adminorgId");
        if (!StringUtils.isEmpty((String)adminOrgIdStr)) {
            List orgIds = JSONObject.parseArray((String)adminOrgIdStr, Long.class);
            showParameter.setCustomParam("adminorgId", (Object)orgIds);
        }
        if (!StringUtils.isEmpty((String)(positionIdStr = pageCache.get("positionId")))) {
            List positionIds = JSONObject.parseArray((String)positionIdStr, Long.class);
            showParameter.setCustomParam("positionId", (Object)positionIds);
        }
        if (!StringUtils.isEmpty((String)(personIdStr = pageCache.get("personId")))) {
            List Ids = JSONObject.parseArray((String)personIdStr, Long.class);
            showParameter.setCustomParam("personId", (Object)Ids);
        }
        if (!StringUtils.isEmpty((String)(taskStatusValue = pageCache.get("taskstatusValue")))) {
            showParameter.setCustomParam("taskstatusValue", (Object)taskStatusValue);
        }
        return showParameter;
    }

    private void showCustomCtrlView(String ctrlap, String isShow) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomControl customcontrol = (CustomControl)this.getView().getControl(ctrlap);
        map.put("show", isShow);
        map.put("timestamp", System.currentTimeMillis());
        customcontrol.setData(map);
    }

    private void initCellFontColorAndEditable() {
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entity.size(); ++i) {
            CellStyle cellStyle;
            CellStyle cellStyle2;
            BigDecimal atcs;
            DynamicObject rowObj = (DynamicObject)entity.get(i);
            BigDecimal batcs = rowObj.getBigDecimal("batcs");
            if (batcs.compareTo(atcs = rowObj.getBigDecimal("atcs")) < 0) {
                cellStyle2 = new CellStyle();
                cellStyle2.setFieldKey("atcs");
                cellStyle2.setRow(i);
                cellStyle2.setForeColor("#19994D");
                cellStyles.add(cellStyle2);
            } else if (batcs.compareTo(atcs) > 0) {
                cellStyle2 = new CellStyle();
                cellStyle2.setFieldKey("atcs");
                cellStyle2.setRow(i);
                cellStyle2.setForeColor("#D80C1E");
                cellStyles.add(cellStyle2);
            } else {
                cellStyle2 = new CellStyle();
                cellStyle2.setFieldKey("atcs");
                cellStyle2.setRow(i);
                cellStyle2.setForeColor("#333333");
                cellStyles.add(cellStyle2);
            }
            FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)rowObj.getString("taskstatus"));
            if (FlowRuTaskStatusEnum.WAITING.equals((Object)taskStatus) || FlowRuTaskStatusEnum.PROCESSING.equals((Object)taskStatus)) {
                cellStyle = new CellStyle();
                cellStyle.setFieldKey("taskstatus");
                cellStyle.setRow(i);
                cellStyle.setForeColor("#FF5F1F");
                cellStyles.add(cellStyle);
            }
            if (FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus)) {
                cellStyle = new CellStyle();
                cellStyle.setFieldKey("taskstatus");
                cellStyle.setRow(i);
                cellStyle.setForeColor("#1BA854");
                cellStyles.add(cellStyle);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"atv", "ins", "atcl"});
            }
            if (!FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus)) continue;
            cellStyle = new CellStyle();
            cellStyle.setFieldKey("taskstatus");
            cellStyle.setRow(i);
            cellStyle.setForeColor("#FB2323");
            cellStyles.add(cellStyle);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"atv", "ins", "atcl"});
        }
        grid.setCellStyle(cellStyles);
    }

    private List<Map<String, Object>> getTaskList(FormShowParameter parameter) {
        Object batchTaskIdObj = parameter.getCustomParam("batchTaskId");
        if (batchTaskIdObj != null) {
            Long batchTaskId = Long.parseLong((String)batchTaskIdObj);
            QFilter taskStatusFilter = new QFilter("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
            taskStatusFilter.and("handler", "=", (Object)RequestContext.get().getCurrUserId());
            return FLOW_RU_SECOND_DOMAIN_SERVICE.getBatchTaskDetails(batchTaskId, taskStatusFilter);
        }
        return new ArrayList<Map<String, Object>>(10);
    }

    private List<String> getTaskStatusList(String taskStatus) {
        List<String> taskStatusList = new ArrayList<String>(10);
        if (!HRStringUtils.isEmpty((String)taskStatus)) {
            taskStatusList = Arrays.asList(taskStatus.split(",")).stream().filter(taskStatusStr -> !taskStatusStr.isEmpty()).collect(Collectors.toList());
        }
        return taskStatusList;
    }

    private List<Long> getBaseDataList(DynamicObjectCollection basedatas) {
        List<Long> idList = new ArrayList<Long>(10);
        if (!basedatas.isEmpty()) {
            idList = basedatas.stream().map(bd -> bd.getLong("fbasedataid.id")).collect(Collectors.toList());
        }
        return idList;
    }

    private void calAtcsAndAtcl(BigDecimal atvNewValue, BigDecimal atvOldValue) {
        BigDecimal finalTotalScoreVal;
        SumAreaEvaluationUpdateOseServiceImpl iService;
        HRPluginProxy hrPluginProxy;
        List ret;
        BigDecimal minScore;
        BigDecimal maxScore;
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        int currentRow = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject rowObj = (DynamicObject)entries.get(currentRow);
        Long taskId = rowObj.getLong("flowrutask.id");
        Long actEvalObjId = rowObj.getLong("actevalobj.id");
        BigDecimal batcsValue = rowObj.getBigDecimal("batcs");
        BigDecimal atcsOldValue = rowObj.getBigDecimal("atcs");
        if (HRObjectUtils.isEmpty((Object)atvNewValue)) {
            return;
        }
        DynamicObject defnodeObj = APP_SERVICE.queryAdjustScoreByTaskId(taskId);
        BigDecimal adjusetscorelowerlimit = defnodeObj.getBigDecimal("adjusetscorelowerlimit");
        BigDecimal adjustscoreuplimit = defnodeObj.getBigDecimal("adjustscoreuplimit");
        if (atvNewValue.compareTo(adjusetscorelowerlimit) < 0 || atvNewValue.compareTo(adjustscoreuplimit) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u503c\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4[{0}~{1}]", (String)"EvaluateAdjustmentEdit_36", (String)"opmc-epa-formplugin", (Object[])new Object[]{adjusetscorelowerlimit, adjustscoreuplimit}));
            this.getModel().setValue("atv", (Object)BigDecimal.ZERO, currentRow);
            return;
        }
        BigDecimal atcs = batcsValue.add(atvNewValue);
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
        Long assessFormId = assessForm.getLong("id");
        String minScoreStr = this.getPageCache().get(assessFormId + "_min");
        String maxScoreStr = this.getPageCache().get(assessFormId + "_max");
        if (HRStringUtils.isEmpty((String)maxScoreStr)) {
            Map scoreRangeMap = APP_SERVICE.getScoreRangeMap(actEvalObjId);
            maxScore = (BigDecimal)scoreRangeMap.get("maxscore");
            minScore = (BigDecimal)scoreRangeMap.get("minscore");
            if (maxScore != null && minScore != null) {
                this.getPageCache().put(assessFormId + "_max", String.valueOf(maxScore));
                this.getPageCache().put(assessFormId + "_min", String.valueOf(minScore));
            }
        } else {
            minScore = new BigDecimal(minScoreStr);
            maxScore = new BigDecimal(maxScoreStr);
        }
        Boolean isNeedCheckOse = true;
        SumAreaEvaluationIsNeedCheckServiceImpl iCheckService = new SumAreaEvaluationIsNeedCheckServiceImpl();
        HRPluginProxy hrCheckPluginProxy = HRPlugInProxyFactory.create((Object)iCheckService, ISumAreaEvaluationIsNeedCheckOseService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationIsNeedCheckOseService#isNeedCheckOse", null);
        List result = hrCheckPluginProxy.callReplaceIfPresent(p -> p.isNeedCheckOse(this.getView()));
        if (result != null && result.size() > 0) {
            isNeedCheckOse = (Boolean)result.get(0);
        }
        if (isNeedCheckOse.booleanValue() && maxScore != null && minScore != null) {
            if (atcs.compareTo(minScore) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\uff0c\u53d6{2}\u3002", (String)"EvaluateAdjustmentEdit_37", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore, minScore}));
                this.getModel().setValue("atcs", (Object)minScore, currentRow);
                atcs = minScore;
            }
            if (atcs.compareTo(maxScore) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\uff0c\u53d6{2}\u3002", (String)"EvaluateAdjustmentEdit_37", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore, maxScore}));
                this.getModel().setValue("atcs", (Object)maxScore, currentRow);
                atcs = maxScore;
            }
        }
        if ((ret = (hrPluginProxy = HRPlugInProxyFactory.create((Object)(iService = new SumAreaEvaluationUpdateOseServiceImpl()), ISumAreaEvaluationUpdateOseService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationUpdateOseService#updateOse", null)).callReplaceIfPresent(arg_0 -> this.lambda$calAtcsAndAtcl$26(finalTotalScoreVal = atcs, arg_0))) != null && ret.size() > 0) {
            atcs = (BigDecimal)ret.get(0);
        }
        this.getModel().setValue("atcs", (Object)atcs, currentRow);
        String actl = APP_SERVICE.calculateLevel(assessFormId, atcs);
        if (actl != null) {
            this.getModel().setValue("atcl", (Object)actl, currentRow);
        }
    }

    private List<Map<String, Object>> getExpiredTaskList(FormShowParameter parameter) {
        Object batchTaskIdObj = parameter.getCustomParam("batchTaskId");
        if (batchTaskIdObj != null) {
            Long batchTaskId = Long.parseLong((String)batchTaskIdObj);
            QFilter taskStatusFilter = new QFilter("taskstatus", "in", Collections.singletonList(FlowRuTaskStatusEnum.EXPIRED.getCode()));
            return APP_SERVICE.getBatchTaskList(batchTaskId, taskStatusFilter);
        }
        return new ArrayList<Map<String, Object>>(10);
    }

    private /* synthetic */ BigDecimal lambda$calAtcsAndAtcl$26(BigDecimal finalTotalScoreVal, ISumAreaEvaluationUpdateOseService p) {
        return p.updateOse(this.getView(), finalTotalScoreVal);
    }
}

