/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaloverall;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.evaloverall.ActEvalObjOverallApplicationService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.model.NodeRoleConfigBo;

public class EvalOverallDetailEdit
extends HRDataBaseEdit {
    private static final int SCALE_2 = 2;
    private static final String TITLE = "title";
    private static final ActEvalObjOverallApplicationService APP_SERVICE = ActEvalObjOverallApplicationService.getInstance();
    private static final String[] INIT_FIELDS = new String[]{"actevalobj", "assessyear", "assessperiod", "activity", "perforg", "flowrunode", "flowrurole", "flowrutask", "flowruproc"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        for (String initField : INIT_FIELDS) {
            Object fieldValue = parameter.getCustomParam(initField);
            if (fieldValue == null) continue;
            this.getModel().setValue(initField, fieldValue);
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject sumAreaObjOfLevel;
        super.afterBindData(e);
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
        String taskStatus = taskObj.getString("taskstatus");
        Long id = this.getModel().getDataEntity().getLong("id");
        if ((FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus) || id.equals(0L) && FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) && (sumAreaObjOfLevel = APP_SERVICE.querySumAreaEvalRecordOfPreRoleLastTask(taskId)) != null) {
            this.getModel().beginInit();
            this.getModel().setValue("ole", sumAreaObjOfLevel.get("ole"));
            this.getView().updateView("ole");
            this.getModel().setValue("eval", (Object)sumAreaObjOfLevel.getString("eval"));
            this.getView().updateView("eval");
            this.getModel().endInit();
        }
        if (taskId != null) {
            this.setTitle();
            this.setFieldInfo(taskId);
            this.setOleComboItems(taskId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
        if (taskObj == null) {
            IFormView parentView = this.getView().getParentView();
            parentView.getPageCache().remove("subPageOp");
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            parentView.invokeOperation("refresh_entry", option);
            this.getView().sendFormAction(parentView);
            return;
        }
        String taskStatus = taskObj.getString("taskstatus");
        if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(taskStatus)) {
            IFormView parentView = this.getView().getParentView();
            parentView.getPageCache().remove("subPageOp");
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            parentView.invokeOperation("refresh_entry", option);
            this.getView().sendFormAction(parentView);
            return;
        }
        if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u9000\u56de\u3002", (String)"EvalOverallDetailEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (FlowRuTaskStatusEnum.PROCESSED.getCode().equals(taskStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u8bc4\u4f30\u3002", (String)"EvalOverallDetailEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        Long actEvalObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actevalobj");
        DynamicObject evalSumObj = this.getModel().getDataEntity();
        switch (name) {
            case "ose": {
                BigDecimal newValue = (BigDecimal)changeData.getNewValue();
                BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
                boolean isNotOverMark = this.calOle(taskId, actEvalObjId, newValue, oldValue, evalSumObj);
                if (isNotOverMark) break;
                return;
            }
            case "ole": 
            case "eval": {
                APP_SERVICE.saveSumObj(evalSumObj);
                break;
            }
        }
        APP_SERVICE.processTask(Collections.singletonList(taskId));
        String option = OperateOption.create();
        option.setVariableValue("flowrutask", taskId.toString());
        option.setVariableValue("ose", evalSumObj.getString("ose"));
        option.setVariableValue("ole", evalSumObj.getString("ole"));
        option.setVariableValue("ishasright", "true");
        IFormView parentView = this.getView().getParentView();
        parentView.getPageCache().put("subPageOp", "true");
        parentView.invokeOperation("refresh", (OperateOption)option);
        this.getView().sendFormAction(parentView);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"EvalOverallDetailEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    private void setTitle() {
        Long actEvalObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actevalobj");
        DynamicObject actEvalObj = APP_SERVICE.queryActEvalObjById(actEvalObjId);
        String name = actEvalObj.getString("person.name");
        String title = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u60a8\u5bf9{0}\u7684\u7ee9\u6548\u603b\u8bc4\u4f30\u3002", (String)"EvalOverallDetailEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{name});
        Label titleAp = (Label)this.getControl(TITLE);
        titleAp.setText(title);
        this.getView().updateView(TITLE);
    }

    private void setFieldInfo(Long taskId) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        Map permissionMap = APP_SERVICE.querySumPermMap(taskId);
        Map oseMap = (Map)permissionMap.get("ose");
        Map oleMap = (Map)permissionMap.get("ole");
        Map evalMap = (Map)permissionMap.get("eval");
        Map sumConfigMap = APP_SERVICE.querySumConfigByTaskId(taskId);
        FieldEdit oseField = (FieldEdit)this.getControl("ose");
        String oseCustName = ((DynamicObject)sumConfigMap.get("ose")).getString("fieldcustname");
        oseField.setCaption(new LocaleString(oseCustName));
        Boolean oseMustInput = (Boolean)oseMap.get("fieldmustinputitem");
        oseField.setMustInput(oseMustInput.booleanValue());
        if (status.equals((Object)OperationStatus.VIEW)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"ose"});
        }
        if (oleMap != null && !oleMap.isEmpty()) {
            Boolean oleDisplayItem = (Boolean)oleMap.get("fielddisplayitem");
            Boolean oleMustInput = (Boolean)oleMap.get("fieldmustinputitem");
            Boolean oleModifyItem = (Boolean)oleMap.get("fieldmodifyitem");
            if (oleDisplayItem.booleanValue()) {
                FieldEdit oleField = (FieldEdit)this.getControl("ole");
                DynamicObject oleObj = (DynamicObject)sumConfigMap.get("ole");
                String oleCustName = oleObj.getString("fieldcustname");
                oleField.setCaption(new LocaleString(oleCustName));
                oleField.setMustInput(oleMustInput.booleanValue());
                if (status.equals((Object)OperationStatus.VIEW)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"ole"});
                } else {
                    this.getView().setEnable(oleModifyItem, new String[]{"ole"});
                }
                this.getView().setVisible(oleDisplayItem, new String[]{"ole"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"ole"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ole"});
        }
        if (evalMap != null && !evalMap.isEmpty()) {
            Boolean evalDisplayItem = (Boolean)evalMap.get("fielddisplayitem");
            Boolean evalMustInput = (Boolean)evalMap.get("fieldmustinputitem");
            Boolean evalModifyItem = (Boolean)evalMap.get("fieldmodifyitem");
            if (evalDisplayItem.booleanValue()) {
                FieldEdit evalField = (FieldEdit)this.getControl("eval");
                DynamicObject evalObj = (DynamicObject)sumConfigMap.get("eval");
                String evalCustName = evalObj.getString("fieldcustname");
                evalField.setCaption(new LocaleString(evalCustName));
                evalField.setMustInput(evalMustInput.booleanValue());
                if (status.equals((Object)OperationStatus.VIEW)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"eval"});
                } else {
                    this.getView().setEnable(evalModifyItem, new String[]{"eval"});
                }
                this.getView().setVisible(evalDisplayItem, new String[]{"eval"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"eval"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"eval"});
        }
    }

    private void setOleComboItems(Long taskId) {
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
        int numaccuracy = assessForm.getInt("numaccuracy");
        if (HRObjectUtils.isEmpty((Object)numaccuracy)) {
            numaccuracy = 2;
        }
        HashMap fieldMap = new HashMap();
        HashMap<String, Integer> itemMap = new HashMap<String, Integer>();
        itemMap.put("sc", numaccuracy);
        fieldMap.put("item", itemMap);
        this.getView().updateControlMetadata("ose", fieldMap);
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(Long.valueOf(assessForm.getLong("sumperflevel.id")));
        ComboEdit comboEdit = (ComboEdit)this.getControl("ole");
        comboEdit.setComboItems(perfLevelItems);
    }

    private boolean calOle(Long taskId, Long actEvalObjId, BigDecimal newValue, BigDecimal oldValue, DynamicObject evalSumObj) {
        Long assessFormId;
        String ole;
        NodeRoleConfigBo roleConfig;
        Boolean isgradecompute;
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
        Map scoreRangeMap = APP_SERVICE.getScoreRangeMap(actEvalObjId);
        BigDecimal maxScore = (BigDecimal)scoreRangeMap.get("maxscore");
        BigDecimal minScore = (BigDecimal)scoreRangeMap.get("minscore");
        if (newValue != null && newValue.compareTo(minScore) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\uff0c\u53d6{2}\u3002", (String)"EvalOverallDetailEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore, minScore}));
            evalSumObj.set("ose", (Object)minScore);
            return false;
        }
        if (newValue != null && newValue.compareTo(maxScore) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\uff0c\u53d6{2}\u3002", (String)"EvalOverallDetailEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore, maxScore}));
            evalSumObj.set("ose", (Object)maxScore);
            return false;
        }
        if (newValue != null && (isgradecompute = (roleConfig = APP_SERVICE.queryNodeRoleConfigByTask(taskId)).getIsgradecompute()).equals(Boolean.TRUE) && (ole = APP_SERVICE.calculateLevel(assessFormId = Long.valueOf(assessForm.getLong("id")), this.getModel().getDataEntity().getBigDecimal("ose"))) != null) {
            evalSumObj.set("ole", (Object)ole);
            this.getView().updateView("ole");
        }
        APP_SERVICE.saveSumObj(evalSumObj);
        return true;
    }
}

