/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaloverall;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.application.service.evaloverall.ActEvalObjOverallApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.evaloverall.ProcPermAnonymityEnum;
import kd.opmc.epa.common.enums.evaloverall.SortFieldEnum;
import kd.opmc.epa.common.enums.evaloverall.SortOrderEnum;
import kd.opmc.epa.formplugin.web.utils.IndicatorDetailUtils;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuRoleBo;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowRuProcBo;

public class EvalOverallMultiDetailEdit
extends HRDynamicFormBasePlugin
implements RowClickEventListener {
    private static final String IS_SHOW_OSE = "isshowose";
    private static final String IS_SHOW_OLE = "isshowole";
    private static final String SORTAP = "sortap";
    private static final String PAGECACHE_SORT_ID = "pagecache_sort_id";
    private static final String FILTERAP = "filterap";
    private static final String PAGECACHE_FILTER_ID = "pagecache_filter_id";
    private static final String HAVE_FILTER_AP = "havefilterap";
    private static final String FILTER_RESET = "filter_reset";
    private static final String FILTER_CANCEL = "filter_cancel";
    private static final String FILTER_CONFIRM = "filter_confirm";
    private static final String NODATA = "nodata";
    private static final String SORT_RESET = "sort_reset";
    private static final String SORT_CANCEL = "sort_cancel";
    private static final String SORT_CONFIRM = "sort_confirm";
    private static final String CLOSE_LEFT = "closeleft";
    private static final String SHOW_LEFT = "showleft";
    private static final String CLOSE_LEFT_VECTOR = "closeleftvector";
    private static final String SHOW_LEFT_VECTOR = "showleftvector";
    private static final String TASK_STATUS_AP = "taskstatusap";
    private static final String OSEAP = "oseap";
    private static final String OLEAP = "oleap";
    private static final String SIDERAP = "siderap";
    private static final int MAX_ROLE_COUNT = Integer.MAX_VALUE;
    private static final String DETAIL_TARGET_KEY = "personal";
    private static final String IND_TARGET_KEY = "indap";
    private static final String EVAL_TARGET_KEY = "evalap";
    private static final String ANONYMOUS_STR = "***";
    private static final String PREV = "prev";
    private static final String NEXT = "next";
    private static final String SELECTED_TASK_ID = "selectedTaskId";
    private static final ActEvalObjOverallApplicationService APP_SERVICE = ActEvalObjOverallApplicationService.getInstance();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{PREV, NEXT});
        this.addClickListeners(new String[]{CLOSE_LEFT, SHOW_LEFT, CLOSE_LEFT_VECTOR, SHOW_LEFT_VECTOR, TASK_STATUS_AP, OSEAP, OLEAP, PREV, NEXT});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("taskId");
        Map permissionMap = APP_SERVICE.querySumPermMap(taskId);
        IPageCache pageCache = this.getView().getPageCache();
        Map oseMap = (Map)permissionMap.get("ose");
        if (oseMap != null && !oseMap.isEmpty()) {
            Boolean oseDisplayItem = (Boolean)oseMap.get("fielddisplayitem");
            if (oseDisplayItem.booleanValue()) {
                pageCache.put(IS_SHOW_OSE, "1");
            } else {
                pageCache.put(IS_SHOW_OSE, "0");
            }
        } else {
            pageCache.put(IS_SHOW_OSE, "0");
        }
        Map oleMap = (Map)permissionMap.get("ole");
        if (oleMap != null && !oleMap.isEmpty()) {
            Boolean oleDisplayItem = (Boolean)oleMap.get("fielddisplayitem");
            if (oleDisplayItem.booleanValue()) {
                pageCache.put(IS_SHOW_OLE, "1");
            } else {
                pageCache.put(IS_SHOW_OLE, "0");
            }
        } else {
            pageCache.put(IS_SHOW_OLE, "0");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{SHOW_LEFT});
        this.getView().setVisible(Boolean.FALSE, new String[]{HAVE_FILTER_AP});
        String subPageOp = this.getView().getPageCache().get("subPageOp");
        if (HRStringUtils.isEmpty((String)subPageOp)) {
            this.initFilters();
            this.initSort();
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Long taskId = (Long)parameter.getCustomParam("taskId");
            this.initPersonListCardEntry(taskId, Boolean.TRUE);
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventKey = e.getKey();
        String isShow = e.getEventArgs();
        if (HRStringUtils.equals((String)eventKey, (String)FILTERAP)) {
            if (HRStringUtils.equals((String)isShow, (String)"false")) {
                this.showCustomCtrl(FILTERAP, "true");
                this.showCustomCtrl(SORTAP, "false");
            } else {
                this.showCustomCtrl(FILTERAP, "false");
            }
        }
        if (HRStringUtils.equals((String)eventKey, (String)SORTAP)) {
            if (HRStringUtils.equals((String)isShow, (String)"false")) {
                this.showCustomCtrl(SORTAP, "true");
                this.showCustomCtrl(FILTERAP, "false");
            } else {
                this.showCustomCtrl(SORTAP, "false");
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getParentView();
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        parentView.invokeOperation("refresh", option);
        this.getView().sendFormAction(parentView);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        Long selectedTaskId = Long.parseLong(this.getPageCache().get(SELECTED_TASK_ID));
        DynamicObject taskObj = APP_SERVICE.queryTaskInfo(selectedTaskId);
        String taskStatus = taskObj.getString("taskstatus");
        if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(taskStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvalOverallMultiDetailEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Optional<Integer> rowIndexList = entrys.stream().filter(obj -> selectedTaskId.equals(obj.getLong("flowrutask"))).map(arg_0 -> entrys.indexOf(arg_0)).findFirst();
        switch (key) {
            case "closeleft": 
            case "closeleftvector": {
                this.getView().setVisible(Boolean.FALSE, new String[]{SIDERAP, CLOSE_LEFT});
                this.getView().setVisible(Boolean.TRUE, new String[]{SHOW_LEFT});
                break;
            }
            case "showleft": 
            case "showleftvector": {
                this.getView().setVisible(Boolean.TRUE, new String[]{SIDERAP, CLOSE_LEFT});
                this.getView().setVisible(Boolean.FALSE, new String[]{SHOW_LEFT});
                break;
            }
            case "prev": {
                int rowIndex;
                int prevRowIndex;
                if (!rowIndexList.isPresent() || (prevRowIndex = (rowIndex = rowIndexList.get().intValue()) - 1) < 0) break;
                DynamicObject prevObj = (DynamicObject)entrys.get(prevRowIndex);
                Long prevTaskId = prevObj.getLong("flowrutask");
                this.initPersonListCardEntry(prevTaskId, Boolean.FALSE);
                this.setPrevAndNextEnable();
                break;
            }
            case "next": {
                int rowIndex;
                int nextRowIndex;
                if (!rowIndexList.isPresent() || (nextRowIndex = (rowIndex = rowIndexList.get().intValue()) + 1) >= entrys.size()) break;
                DynamicObject prevObj = (DynamicObject)entrys.get(nextRowIndex);
                Long nextTaskId = prevObj.getLong("flowrutask");
                this.initPersonListCardEntry(nextTaskId, Boolean.FALSE);
                this.setPrevAndNextEnable();
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        IFormView filterView;
        super.entryRowClick(evt);
        IPageCache pageCache = this.getPageCache();
        int selectRow = evt.getRow();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
        DynamicObject entryObj = (DynamicObject)entryColl.get(selectRow);
        Long selectedTaskId = entryObj.getLong("flowrutask");
        List taskIdList = entryColl.stream().map(obj -> obj.getLong("flowrutask")).collect(Collectors.toList());
        DynamicObject[] taskObjList = APP_SERVICE.queryTaskById(taskIdList);
        Map<Long, String> taskStatusMap = Arrays.stream(taskObjList).collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("taskstatus"), (v1, v2) -> v2));
        String taskStatus = taskStatusMap.get(selectedTaskId);
        String preSelectedTaskIdStr = this.getPageCache().get(SELECTED_TASK_ID);
        String filterPage = pageCache.get(PAGECACHE_FILTER_ID);
        List<Object> taskStatusList = new ArrayList(10);
        if (filterPage != null && (filterView = this.getView().getView(filterPage)) != null) {
            DynamicObject dataEntity = filterView.getModel().getDataEntity();
            taskStatusList = this.getTaskStatusList(dataEntity.getString("taskstatus"));
        }
        if (!HRStringUtils.isEmpty((String)preSelectedTaskIdStr)) {
            Long preSelectedTaskId = Long.parseLong(preSelectedTaskIdStr);
            String preTaskStatus = taskStatusMap.get(preSelectedTaskId);
            if (!taskStatusList.isEmpty()) {
                if (!taskStatusList.contains(taskStatus)) {
                    this.initPersonListCardEntry(null, Boolean.FALSE);
                    return;
                }
                if (!taskStatusList.contains(preTaskStatus)) {
                    this.initPersonListCardEntry(selectedTaskId, Boolean.FALSE);
                    return;
                }
            }
            if (!FlowRuTaskStatusEnum.EXPIRED.getCode().equals(preTaskStatus)) {
                this.updateRow(preSelectedTaskId);
            }
        }
        if (taskObjList != null && taskObjList.length > 0) {
            List expiredTaskList = Arrays.stream(taskObjList).filter(obj -> FlowRuTaskStatusEnum.EXPIRED.getCode().equals(obj.getString("taskstatus"))).collect(Collectors.toList());
            if (expiredTaskList.isEmpty()) {
                this.selectRowWithoutQuery(selectedTaskId);
            } else {
                if (entryColl.size() == expiredTaskList.size()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvalOverallMultiDetailEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    this.getView().close();
                    return;
                }
                List expiredTaskIdList = expiredTaskList.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
                int[] expiredRows = new int[expiredTaskIdList.size()];
                int index = 0;
                for (int i = 0; i < entryColl.size(); ++i) {
                    Long taskId = ((DynamicObject)entryColl.get(i)).getLong("flowrutask");
                    if (!expiredTaskIdList.contains(taskId)) continue;
                    expiredRows[index++] = i;
                }
                this.getModel().deleteEntryRows("entryentity", expiredRows);
                if (expiredTaskIdList.contains(selectedTaskId)) {
                    selectedTaskId = ((DynamicObject)entryColl.get(0)).getLong("flowrutask");
                    this.selectRowWithoutQuery(selectedTaskId);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvalOverallMultiDetailEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                } else {
                    this.selectRowWithoutQuery(selectedTaskId);
                }
            }
        }
    }

    private void updateRow(Long selectedTaskId) {
        IDataModel model = this.getModel();
        DynamicObject taskObj = APP_SERVICE.queryTaskInfoById(selectedTaskId);
        String taskStatus = taskObj.getString("taskstatus");
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(selectedTaskId);
        int numaccuracy = assessForm.getInt("numaccuracy");
        String scaleType = assessForm.getString("scaletype");
        DynamicObject sumperfLevel = assessForm.getDynamicObject("sumperflevel");
        Map<Object, Object> perfLevelMap = new HashMap(16);
        if (sumperfLevel != null) {
            Long sumperfLevelId = sumperfLevel.getLong("id");
            List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(sumperfLevelId);
            perfLevelMap = perfLevelItems.stream().collect(Collectors.toMap(x -> x.getValue(), y -> y.getCaption().toString(), (v1, v2) -> v2));
        }
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
        int selectedRow = 0;
        DynamicObject selectedRowObj = (DynamicObject)entryColl.get(0);
        if (selectedTaskId != null) {
            Long finalSelectedTaskId = selectedTaskId;
            selectedRowObj = entryColl.stream().filter(obj -> finalSelectedTaskId.equals(obj.getLong("flowrutask"))).findFirst().orElse(null);
            if (selectedRowObj != null) {
                selectedRow = entryColl.indexOf((Object)selectedRowObj);
            }
        } else {
            selectedTaskId = selectedRowObj.getLong("flowrutask");
        }
        DynamicObject sumAreaRecord = APP_SERVICE.querySumAreaEvalRecord(selectedTaskId);
        if (sumAreaRecord != null) {
            IPageCache pageCache = this.getView().getPageCache();
            String isShowOse = pageCache.get(IS_SHOW_OSE);
            String isShowOle = pageCache.get(IS_SHOW_OLE);
            BigDecimal ose = sumAreaRecord.getBigDecimal("ose");
            String ole = sumAreaRecord.getString("ole");
            model.setValue("ose", ose == null ? null : ose.setScale(numaccuracy, ScalaTypeEnum.get((String)scaleType).getType()), selectedRow);
            model.setValue(IS_SHOW_OSE, (Object)(!HRObjectUtils.isEmpty((Object)ose) && HRStringUtils.equals((String)isShowOse, (String)"1") ? "1" : "0"), selectedRow);
            model.setValue("ole", HRStringUtils.isNotEmpty((String)ole) ? perfLevelMap.get(ole) : "", selectedRow);
            model.setValue("olevalue", (Object)(HRStringUtils.isNotEmpty((String)ole) ? ole : ""), selectedRow);
            model.setValue(IS_SHOW_OLE, (Object)(HRStringUtils.isNotEmpty((String)ole) && HRStringUtils.equals((String)isShowOle, (String)"1") ? "1" : "0"), selectedRow);
            if (ose == null && HRStringUtils.isEmpty((String)ole) || FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus) || FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                model.setValue("isshowtaskstatus", (Object)"1", selectedRow);
            } else {
                model.setValue("isshowtaskstatus", (Object)"0", selectedRow);
            }
            model.setValue("taskstatus", (Object)taskStatus, selectedRow);
        } else {
            if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus) || FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                model.setValue("isshowtaskstatus", (Object)"1", selectedRow);
            } else {
                model.setValue("isshowtaskstatus", (Object)"0", selectedRow);
            }
            model.setValue("taskstatus", (Object)taskStatus, selectedRow);
        }
        this.getView().updateView("entryentity");
    }

    private void selectRowWithoutQuery(Long selectedTaskId) {
        IDataModel model = this.getModel();
        DynamicObject taskObj = APP_SERVICE.queryTaskInfoById(selectedTaskId);
        String taskStatus = taskObj.getString("taskstatus");
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(selectedTaskId);
        int numaccuracy = assessForm.getInt("numaccuracy");
        String scaleType = assessForm.getString("scaletype");
        DynamicObject sumperfLevel = assessForm.getDynamicObject("sumperflevel");
        Map<Object, Object> perfLevelMap = new HashMap(16);
        if (sumperfLevel != null) {
            Long sumperfLevelId = sumperfLevel.getLong("id");
            List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(sumperfLevelId);
            perfLevelMap = perfLevelItems.stream().collect(Collectors.toMap(x -> x.getValue(), y -> y.getCaption().toString(), (v1, v2) -> v2));
        }
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryColl.size(); ++i) {
            model.setValue("selected", (Object)"0", i);
        }
        int selectedRow = 0;
        DynamicObject selectedRowObj = (DynamicObject)entryColl.get(0);
        if (selectedTaskId != null) {
            Long finalSelectedTaskId = selectedTaskId;
            selectedRowObj = entryColl.stream().filter(obj -> finalSelectedTaskId.equals(obj.getLong("flowrutask"))).findFirst().orElse(null);
            if (selectedRowObj != null) {
                selectedRow = entryColl.indexOf((Object)selectedRowObj);
            }
        } else {
            selectedTaskId = selectedRowObj.getLong("flowrutask");
        }
        model.setValue("selected", (Object)"1", selectedRow);
        DynamicObject sumAreaRecord = APP_SERVICE.querySumAreaEvalRecord(selectedTaskId);
        if (sumAreaRecord != null) {
            IPageCache pageCache = this.getView().getPageCache();
            String isShowOse = pageCache.get(IS_SHOW_OSE);
            String isShowOle = pageCache.get(IS_SHOW_OLE);
            BigDecimal ose = sumAreaRecord.getBigDecimal("ose");
            String ole = sumAreaRecord.getString("ole");
            model.setValue("ose", ose == null ? null : ose.setScale(numaccuracy, ScalaTypeEnum.get((String)scaleType).getType()), selectedRow);
            model.setValue(IS_SHOW_OSE, (Object)(!HRObjectUtils.isEmpty((Object)ose) && HRStringUtils.equals((String)isShowOse, (String)"1") ? "1" : "0"), selectedRow);
            model.setValue("ole", HRStringUtils.isNotEmpty((String)ole) ? perfLevelMap.get(ole) : "", selectedRow);
            model.setValue("olevalue", (Object)(HRStringUtils.isNotEmpty((String)ole) ? ole : ""), selectedRow);
            model.setValue(IS_SHOW_OLE, (Object)(HRStringUtils.isNotEmpty((String)ole) && HRStringUtils.equals((String)isShowOle, (String)"1") ? "1" : "0"), selectedRow);
            if (ose == null && HRStringUtils.isEmpty((String)ole) || FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus) || FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                model.setValue("isshowtaskstatus", (Object)"1", selectedRow);
            } else {
                model.setValue("isshowtaskstatus", (Object)"0", selectedRow);
            }
            model.setValue("taskstatus", (Object)taskStatus, selectedRow);
        } else {
            if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus) || FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                model.setValue("isshowtaskstatus", (Object)"1", selectedRow);
            } else {
                model.setValue("isshowtaskstatus", (Object)"0", selectedRow);
            }
            model.setValue("taskstatus", (Object)taskStatus, selectedRow);
        }
        this.getView().updateView("entryentity");
        if (selectedRowObj != null) {
            Long actEvalObjId = selectedRowObj.getLong("actevalobj.id");
            this.getView().getPageCache().remove("subPageOp");
            this.showPersonalView(actEvalObjId, selectedTaskId);
        }
        this.getPageCache().put(SELECTED_TASK_ID, selectedTaskId.toString());
        this.setPrevAndNextEnable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        IPageCache pageCache = this.getPageCache();
        switch (operateKey) {
            case "filter_reset": {
                this.getView().setVisible(Boolean.FALSE, new String[]{HAVE_FILTER_AP});
                pageCache.put("selected_adminorgId", null);
                pageCache.put("selected_positionId", null);
                pageCache.put("selected_personId", null);
                pageCache.put("selected_taskstatus", null);
                break;
            }
            case "filter_cancel": {
                this.showCustomCtrl(FILTERAP, "false");
                break;
            }
            case "filter_confirm": {
                this.getView().getPageCache().remove("subPageOp");
                this.initPersonListCardEntry(null, Boolean.FALSE);
                break;
            }
            case "sort_reset": {
                pageCache.put("sortfield", null);
                pageCache.put("sortorder", null);
                break;
            }
            case "sort_cancel": {
                this.showCustomCtrl(SORTAP, "false");
                break;
            }
            case "sort_confirm": {
                this.getView().getPageCache().remove("subPageOp");
                this.initPersonListCardEntry(null, Boolean.FALSE);
                break;
            }
            case "refresh_entry": {
                this.initPersonListCardEntry(null, Boolean.FALSE);
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String key = eventArgs.getOperateKey();
        FormOperate source = (FormOperate)eventArgs.getSource();
        if (HRStringUtils.equals((String)key, (String)"refresh")) {
            String selectedTaskIdStr = source.getOption().getVariableValue("flowrutask", "");
            Long selectedTaskId = Long.parseLong(selectedTaskIdStr);
            this.initPersonListCardEntry(selectedTaskId, Boolean.FALSE);
        }
    }

    private void setPrevAndNextEnable() {
        Long selectedTaskId = Long.parseLong(this.getPageCache().get(SELECTED_TASK_ID));
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Optional<Integer> rowIndexList = entrys.stream().filter(obj -> selectedTaskId.equals(obj.getLong("flowrutask"))).map(arg_0 -> entrys.indexOf(arg_0)).findFirst();
        if (rowIndexList.isPresent()) {
            int rowIndex = rowIndexList.get();
            if (entrys.size() > 1) {
                if (rowIndex == 0) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{PREV});
                    this.getView().setEnable(Boolean.TRUE, new String[]{NEXT});
                } else if (rowIndex == entrys.size() - 1) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{PREV});
                    this.getView().setEnable(Boolean.FALSE, new String[]{NEXT});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{PREV});
                    this.getView().setEnable(Boolean.TRUE, new String[]{NEXT});
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{PREV});
                this.getView().setEnable(Boolean.FALSE, new String[]{NEXT});
            }
        }
    }

    private void initPersonListCardEntry(Long selectedTaskId, Boolean isInit) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List<Map<String, Object>> taskList = this.getTaskList(parameter);
        if (!taskList.isEmpty()) {
            String cacheTaskCode;
            List<Long> taskIdList = taskList.stream().map(obj -> (Long)obj.get("taskId")).collect(Collectors.toList());
            DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(taskIdList);
            Map<Long, String> taskStatusMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("taskstatus")));
            List actEvaObjIdList = taskList.stream().map(obj -> (Long)obj.get("actEvaObjId")).collect(Collectors.toList());
            DynamicObject[] actEvalObjs = APP_SERVICE.queryEvalObjById(actEvaObjIdList);
            Map actEvalObjMap = Arrays.asList(actEvalObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
            Map<Long, DynamicObject> taskActEvalObjMap = taskList.stream().collect(Collectors.toMap(x -> (Long)x.get("taskId"), y -> (DynamicObject)actEvalObjMap.get((Long)y.get("actEvaObjId"))));
            List perffilesIdList = Arrays.asList(actEvalObjs).stream().map(actEvalObj -> actEvalObj.getLong("perffile.id")).collect(Collectors.toList());
            DynamicObject[] perffiles = APP_SERVICE.queryPerffileById(perffilesIdList);
            Map<Long, DynamicObject> perffilesMap = Arrays.asList(perffiles).stream().collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
            List<LinkedHashMap<String, Object>> recordList = this.assembleEntryData(taskIdList, taskActEvalObjMap, taskStatusMap, perffilesMap);
            IPageCache pageCache = this.getPageCache();
            List filterAdminOrgIdList = recordList.stream().map(record -> (Long)record.get("adminorg")).collect(Collectors.toList());
            pageCache.put("adminorgId", SerializationUtils.toJsonString(filterAdminOrgIdList));
            List filterPositionIdList = recordList.stream().map(record -> (Long)record.get("position")).collect(Collectors.toList());
            pageCache.put("positionId", SerializationUtils.toJsonString(filterPositionIdList));
            List filterPersonIdList = recordList.stream().map(record -> (Long)record.get("person")).collect(Collectors.toList());
            pageCache.put("personId", SerializationUtils.toJsonString(filterPersonIdList));
            String subPageOp = this.getView().getPageCache().get("subPageOp");
            if (isInit.booleanValue()) {
                recordList = recordList.stream().sorted(Comparator.comparing(obj -> ((LinkedHashMap)obj).get("taskstatus").toString()).thenComparing(obj -> ((LinkedHashMap)obj).get("num").toString())).collect(Collectors.toList());
            } else if (!(recordList = this.getDataByFilter(recordList)).isEmpty()) {
                recordList = this.getDataBySort(recordList);
            }
            if (!HRStringUtils.isEmpty((String)subPageOp) && HRStringUtils.isNotEmpty((String)(cacheTaskCode = this.getView().getPageCache().get("cacheTaskCode")))) {
                byte[] taskIdsBytes = Base64.getDecoder().decode(cacheTaskCode.getBytes());
                String taskIdsCode = new String(taskIdsBytes);
                ArrayList<String> taskIds = new ArrayList<String>(Arrays.asList(taskIdsCode.split(",")));
                recordList = this.sortAsOriginal(recordList, taskIds);
            }
            List taskIds = recordList.stream().map(obj -> obj.get("flowrutask").toString()).collect(Collectors.toList());
            String taskIdsCode = taskIds.stream().collect(Collectors.joining(","));
            byte[] taskIdsBytes = Base64.getEncoder().encode(taskIdsCode.getBytes());
            String cacheTaskCode2 = new String(taskIdsBytes);
            this.getView().getPageCache().put("cacheTaskCode", cacheTaskCode2);
            if (!recordList.isEmpty()) {
                this.updateEntryData(recordList);
                DynamicObject taskObj = APP_SERVICE.queryTaskInfo(selectedTaskId);
                if (HRObjectUtils.isEmpty((Object)selectedTaskId) || taskObj == null) {
                    selectedTaskId = (Long)recordList.get(0).get("flowrutask");
                }
                if (taskObj != null) {
                    String taskStatus = taskObj.getString("taskstatus");
                    if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(taskStatus)) {
                        IFormView parentView = this.getView().getParentView();
                        parentView.showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvalOverallMultiDetailEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        selectedTaskId = (Long)recordList.get(0).get("flowrutask");
                    }
                }
                this.selectRow(selectedTaskId, recordList);
            }
        } else {
            IFormView parentView = this.getView().getParentView();
            parentView.updateView();
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    private List<LinkedHashMap<String, Object>> sortAsOriginal(List<LinkedHashMap<String, Object>> recordList, List<String> taskIds) {
        ArrayList<LinkedHashMap<String, Object>> newRecordList = new ArrayList<LinkedHashMap<String, Object>>();
        for (String taskId : taskIds) {
            LinkedHashMap record = recordList.stream().filter(obj -> HRStringUtils.equals((String)taskId, (String)obj.get("flowrutask").toString())).findFirst().orElse(null);
            if (HRObjectUtils.isEmpty((Object)record)) continue;
            newRecordList.add(record);
        }
        return newRecordList;
    }

    private List<LinkedHashMap<String, Object>> getDataBySort(List<LinkedHashMap<String, Object>> recordList) {
        IPageCache pageCache = this.getPageCache();
        String sortPage = pageCache.get(PAGECACHE_SORT_ID);
        IFormView sortView = this.getView().getView(sortPage);
        DynamicObject sortEntity = sortView.getModel().getDataEntity();
        String sortFieldStr = sortEntity.getString("sortfield");
        if (HRStringUtils.isNotEmpty((String)sortFieldStr)) {
            String sortField = SortFieldEnum.get((String)sortFieldStr).getField();
            String sortCode = sortEntity.getString("sortorder");
            recordList = HRStringUtils.equals((String)sortField, (String)"ose") || HRStringUtils.equals((String)sortField, (String)"olevalue") ? recordList.stream().sorted(Comparator.comparing(obj -> {
                Object o = ((LinkedHashMap)obj).get(sortField);
                if (HRObjectUtils.isEmpty(o)) {
                    o = SortOrderEnum.DESC.getCode().equals(sortCode) ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                }
                return new BigDecimal(o.toString());
            }).thenComparing(obj -> ((LinkedHashMap)obj).get("num").toString())).collect(Collectors.toList()) : recordList.stream().sorted(Comparator.comparing(obj -> {
                Object o = ((LinkedHashMap)obj).get(sortField);
                if (HRObjectUtils.isEmpty(o)) {
                    o = SortOrderEnum.DESC.getCode().equals(sortCode) ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                }
                return o.toString();
            }).thenComparing(obj -> ((LinkedHashMap)obj).get("num").toString())).collect(Collectors.toList());
            if (SortOrderEnum.DESC.getCode().equals(sortCode)) {
                Collections.reverse(recordList);
            }
            this.showCustomCtrlView(SORTAP, "false");
        }
        return recordList;
    }

    private List<LinkedHashMap<String, Object>> getDataByFilter(List<LinkedHashMap<String, Object>> recordList) {
        List<Long> personIdList;
        List<Long> positionIdList;
        List<Long> adminOrgIdList;
        IPageCache pageCache = this.getPageCache();
        List filterAdminOrgIdList = recordList.stream().map(record -> (Long)record.get("adminorg")).collect(Collectors.toList());
        pageCache.put("adminorgId", SerializationUtils.toJsonString(filterAdminOrgIdList));
        List filterPositionIdList = recordList.stream().map(record -> (Long)record.get("position")).collect(Collectors.toList());
        pageCache.put("positionId", SerializationUtils.toJsonString(filterPositionIdList));
        List filterPersonIdList = recordList.stream().map(record -> (Long)record.get("person")).collect(Collectors.toList());
        pageCache.put("personId", SerializationUtils.toJsonString(filterPersonIdList));
        Boolean haveFilter = Boolean.FALSE;
        String filterPage = pageCache.get(PAGECACHE_FILTER_ID);
        IFormView filterView = this.getView().getView(filterPage);
        DynamicObject dataEntity = filterView.getModel().getDataEntity();
        List<String> taskStatusList = this.getTaskStatusList(dataEntity.getString("taskstatus"));
        if (!taskStatusList.isEmpty()) {
            haveFilter = Boolean.TRUE;
            if ((recordList = recordList.stream().filter(record -> taskStatusList.contains((String)record.get("taskstatus"))).collect(Collectors.toList())).isEmpty()) {
                this.emptyEntryData();
                return recordList;
            }
        }
        if (!(adminOrgIdList = this.getBaseDataList(dataEntity.getDynamicObjectCollection("adminorg"))).isEmpty()) {
            haveFilter = Boolean.TRUE;
            if ((recordList = recordList.stream().filter(record -> adminOrgIdList.contains((Long)record.get("adminorg"))).collect(Collectors.toList())).isEmpty()) {
                this.emptyEntryData();
                return recordList;
            }
        }
        if (!(positionIdList = this.getBaseDataList(dataEntity.getDynamicObjectCollection("position"))).isEmpty()) {
            haveFilter = Boolean.TRUE;
            if ((recordList = recordList.stream().filter(record -> positionIdList.contains((Long)record.get("position"))).collect(Collectors.toList())).isEmpty()) {
                this.emptyEntryData();
                return recordList;
            }
        }
        if (!(personIdList = this.getBaseDataList(dataEntity.getDynamicObjectCollection("person"))).isEmpty()) {
            haveFilter = Boolean.TRUE;
            if ((recordList = recordList.stream().filter(record -> personIdList.contains((Long)record.get("person"))).collect(Collectors.toList())).isEmpty()) {
                this.emptyEntryData();
                return recordList;
            }
        }
        this.showCustomCtrlView(FILTERAP, "false");
        this.getView().setVisible(haveFilter, new String[]{HAVE_FILTER_AP});
        return recordList;
    }

    private void emptyEntryData() {
        IPageCache pageCache = this.getPageCache();
        String filterPage = pageCache.get(PAGECACHE_FILTER_ID);
        IFormView filterView = this.getView().getView(filterPage);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        filterView.invokeOperation(NODATA, option);
        this.getView().sendFormAction(filterView);
    }

    private List<Long> getBaseDataList(DynamicObjectCollection basedatas) {
        List<Long> idList = new ArrayList<Long>(10);
        if (!basedatas.isEmpty()) {
            idList = basedatas.stream().map(bd -> bd.getLong("fbasedataid.id")).collect(Collectors.toList());
        }
        return idList;
    }

    private void showCustomCtrlView(String ctrlap, String isShow) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomControl customcontrol = (CustomControl)this.getView().getControl(ctrlap);
        map.put("show", isShow);
        map.put("timestamp", System.currentTimeMillis());
        customcontrol.setData(map);
    }

    private List<String> getTaskStatusList(String taskStatus) {
        List<String> taskStatusList = new ArrayList<String>(10);
        if (!HRStringUtils.isEmpty((String)taskStatus)) {
            taskStatusList = Arrays.asList(taskStatus.split(",")).stream().filter(taskStatusStr -> !taskStatusStr.isEmpty()).collect(Collectors.toList());
        }
        return taskStatusList;
    }

    private void selectRow(Long selectedTaskId, List<LinkedHashMap<String, Object>> recordList) {
        LinkedHashMap rowObj = recordList.stream().filter(obj -> selectedTaskId.equals(obj.get("flowrutask"))).findFirst().orElse(null);
        int selectedRow = recordList.indexOf(rowObj);
        IDataModel model = this.getModel();
        model.setValue("selected", (Object)"1", selectedRow);
        this.getView().updateView("entryentity");
        if (rowObj != null) {
            Long actEvalObjId = (Long)rowObj.get("actevalobj");
            this.showPersonalView(actEvalObjId, selectedTaskId);
        }
        this.getPageCache().put(SELECTED_TASK_ID, selectedTaskId.toString());
        this.setPrevAndNextEnable();
    }

    private void showPersonalView(Long actEvalObjId, Long selectedTaskId) {
        String subPageOp = this.getView().getPageCache().get("subPageOp");
        if (HRStringUtils.isEmpty((String)subPageOp)) {
            this.showEvalInfo(actEvalObjId, selectedTaskId);
            this.showProcInfo(actEvalObjId, selectedTaskId);
            this.showIndInfo(actEvalObjId, selectedTaskId);
            this.showActEvalObjInfo(actEvalObjId, selectedTaskId);
        }
        this.getView().getPageCache().remove("subPageOp");
    }

    private void showEvalInfo(Long actEvalObjId, Long selectedTaskId) {
        FlowRuTaskStatusEnum taskStatusEnum;
        String taskstatus;
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        DynamicObject sumAreaEvalObj = APP_SERVICE.querySumAreaEvalRecord(selectedTaskId);
        DynamicObject flowrutaskObj = APP_SERVICE.queryTaskInfo(selectedTaskId);
        DynamicObject actEvalObj = APP_SERVICE.queryActEvalObjById(actEvalObjId);
        OperationStatus status = OperationStatus.ADDNEW;
        if (!HRObjectUtils.isEmpty((Object)sumAreaEvalObj)) {
            baseShowParameter.setPkId((Object)sumAreaEvalObj.getLong("id"));
            status = OperationStatus.EDIT;
        }
        if (HRStringUtils.isNotEmpty((String)(taskstatus = flowrutaskObj.getString("taskstatus"))) && !FlowRuTaskStatusEnum.WAITING.equals((Object)(taskStatusEnum = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskstatus))) && !FlowRuTaskStatusEnum.PROCESSING.equals((Object)taskStatusEnum)) {
            status = OperationStatus.VIEW;
        }
        baseShowParameter.setStatus(status);
        baseShowParameter.setCustomParam("flowrutask", (Object)selectedTaskId);
        baseShowParameter.setCustomParam("actevalobj", (Object)actEvalObjId);
        baseShowParameter.setCustomParam("assessyear", (Object)actEvalObj.getString("assessyear"));
        baseShowParameter.setCustomParam("assessperiod", (Object)actEvalObj.getString("assessperiod"));
        baseShowParameter.setCustomParam("activity", (Object)actEvalObj.getLong("activity.id"));
        baseShowParameter.setCustomParam("perforg", (Object)actEvalObj.getLong("perforg.id"));
        baseShowParameter.setCustomParam("flowrunode", (Object)flowrutaskObj.getLong("flowrunode.id"));
        baseShowParameter.setCustomParam("flowrurole", (Object)flowrutaskObj.getLong("flowrurole.id"));
        baseShowParameter.setCustomParam("flowruproc", (Object)flowrutaskObj.getLong("flowruproc.id"));
        baseShowParameter.setFormId("epa_evaloverall_detail");
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.getOpenStyle().setTargetKey(DETAIL_TARGET_KEY);
        baseShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void showProcInfo(Long actEvalObjId, Long taskId) {
        DynamicObject[] actEvalObjSumRecord = APP_SERVICE.querySumRecordByActEvalObjId(actEvalObjId);
        DynamicObject[] actEvalObjAdjRecord = APP_SERVICE.queryAdjRecordByActEvalObjId(actEvalObjId);
        DynamicObject[] genAreaRecord = APP_SERVICE.queryGenRecordByActEvalObjId(actEvalObjId);
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
        int numAccuracy = assessForm.getInt("numaccuracy");
        String scaleType = assessForm.getString("scaletype");
        List genTaskIdList = Arrays.asList(genAreaRecord).stream().map(obj -> obj.getLong("flowrutask")).collect(Collectors.toList());
        DynamicObject[] ndrRecord = APP_SERVICE.queryNdrRecordByActEvalObjId(actEvalObjId);
        Map<Long, String> ndrMap = Arrays.asList(ndrRecord).stream().collect(Collectors.toMap(x -> x.getLong("flowrunode"), y -> y.getBigDecimal("sont").setScale(numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).stripTrailingZeros().toPlainString()));
        List sumTaskIdList = Arrays.asList(actEvalObjSumRecord).stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        List mergedList = Stream.concat(sumTaskIdList.stream(), genTaskIdList.stream()).distinct().collect(Collectors.toList());
        DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(mergedList);
        Map taskMap = Arrays.asList(taskObjs).stream().filter(obj -> FlowRuTaskStatusEnum.PROCESSED.getCode().equals(obj.getString("taskstatus"))).collect(Collectors.toMap(x -> x.getLong("flowrunode.id"), Function.identity(), (v1, v2) -> v2));
        LinkedHashMap<String, Object> nodeMap = this.assembleSumEvalData(taskId, taskObjs, actEvalObjAdjRecord, actEvalObjSumRecord, assessForm);
        Map permissionConfig = APP_SERVICE.queryPermissionConfig(taskId);
        int currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
        for (Long flowrunodeKey : ndrMap.keySet()) {
            int nodeIndex;
            DynamicObject taskObj = (DynamicObject)taskMap.get(flowrunodeKey);
            if (HRObjectUtils.isEmpty((Object)taskObj) || currentNodeIndex >= (nodeIndex = taskObj.getInt("flowrunode.index"))) continue;
            ndrMap.put(flowrunodeKey, null);
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epa_actevalind_flownode");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(EVAL_TARGET_KEY);
        formShowParameter.setCustomParam("flowNodeMap", (Object)JSON.toJSONString(nodeMap));
        formShowParameter.setCustomParam("ndrMap", (Object)JSON.toJSONString(ndrMap));
        formShowParameter.setCustomParam("maxRoleCount", (Object)Integer.MAX_VALUE);
        formShowParameter.setHasRight(true);
        this.getView().showForm(formShowParameter);
    }

    private LinkedHashMap<String, Object> assembleSumEvalData(Long currTaskId, DynamicObject[] tasks, DynamicObject[] actEvalObjAdjRecord, DynamicObject[] actEvalObjSumRecord, DynamicObject assessForm) {
        String oleShowText;
        String ole;
        String evaldesc;
        BigDecimal soe;
        Collection values;
        LinkedHashMap<String, Object> evalRecordMap = new LinkedHashMap<String, Object>(16);
        Long sumperflevelId = assessForm.getLong("sumperflevel.id");
        int numAccuracy = assessForm.getInt("numaccuracy");
        String scaleType = assessForm.getString("scaletype");
        List adjTaskIdList = Arrays.asList(actEvalObjAdjRecord).stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        List sumTaskIdList = Arrays.asList(actEvalObjSumRecord).stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        List containCrossTaskIdList = Arrays.asList(tasks).stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        List taskIdList = Stream.of(adjTaskIdList, sumTaskIdList).flatMap(Collection::stream).collect(Collectors.toList());
        List mergedList = Stream.concat(taskIdList.stream(), containCrossTaskIdList.stream()).distinct().collect(Collectors.toList());
        DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(mergedList);
        List processedTasks = Arrays.stream(taskObjs).filter(obj -> FlowRuTaskStatusEnum.PROCESSED.getCode().equals(obj.getString("taskstatus")) && !adjTaskIdList.contains(obj.getLong("id"))).sorted(Comparator.comparingInt(x -> x.getInt("flowrunode.index"))).collect(Collectors.toList());
        Collections.reverse(processedTasks);
        Map taskMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
        Map permCfgMap = APP_SERVICE.queryBatchProcessPermSettingScope(mergedList);
        DynamicObject currTaskInfo = APP_SERVICE.queryTaskInfo(currTaskId);
        Long currNodeDefId = currTaskInfo.getLong("flowrunode.flownodedef.id");
        Map permissionConfig = (Map)permCfgMap.get(currNodeDefId);
        Long flowruprocId = currTaskInfo.getLong("flowruproc.id");
        DynamicObject actEvalObj = APP_SERVICE.queryActEvalObjByFlowInsId(flowruprocId);
        Long personId = actEvalObj.getLong("person.id");
        Map userIdsByPersonIds = APP_SERVICE.getUserIdsByPersonIds(Collections.singletonList(personId));
        Long userId = 0L;
        if (userIdsByPersonIds != null && (values = userIdsByPersonIds.values()).size() > 0) {
            userId = (Long)values.toArray()[0];
        }
        if (permissionConfig != null) {
            permissionConfig.put("currActEvalUserId", userId);
            permissionConfig.put("evalflowinsId", flowruprocId);
            permissionConfig.put("flowrunodeId", currTaskInfo.getLong("flowrunode.id"));
            permissionConfig.put("flowrunodeIndex", currTaskInfo.getInt("flowrunode.index"));
            permissionConfig.put("flowruroleId", currTaskInfo.getLong("flowrurole.id"));
            permissionConfig.put("turnoversort", currTaskInfo.getInt("flowrurole.turnoversort"));
        }
        Long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject evalRecord : actEvalObjAdjRecord) {
            Long taskId = evalRecord.getLong("flowrutask.id");
            DynamicObject taskInfo = (DynamicObject)taskMap.get(taskId);
            if (HRObjectUtils.isEmpty((Object)taskInfo)) continue;
            Boolean iscrossnode = taskInfo.getBoolean("flowrunode.iscrossnode");
            String flowrunodeName = taskInfo.getString("flowrunode.name");
            int flowrunodeIndex = taskInfo.getInt("flowrunode.index");
            Long modifierId = taskInfo.getLong("handler.id");
            Long flowDefNodeId = taskInfo.getLong("flowrunode.flownodedef.id");
            BigDecimal flowrunodeWeight = taskInfo.getBigDecimal("flowrunode.nodeweight");
            String flowruroleName = taskInfo.getString("flowrurole.name");
            String flowrunodeId = taskInfo.getString("flowrunode.id");
            Long flowruroleId = taskInfo.getLong("flowrurole.id");
            int turnoversort = taskInfo.getInt("flowrurole.turnoversort");
            Map anonymousCfg = (Map)permCfgMap.get(flowDefNodeId);
            String scoreContent = "";
            if (anonymousCfg != null) {
                scoreContent = (String)anonymousCfg.get(ProcPermAnonymityEnum.ANONYMOUS.getCode());
                permissionConfig.put("histurnoversort", turnoversort);
                permissionConfig.put("hisflowrurole", flowruroleId);
            }
            String modifierPicturefield = taskInfo.getString("handler.picturefield");
            String modifierName = taskInfo.getString("handler.name");
            int currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
            if (HRStringUtils.equals((String)scoreContent, (String)ProcPermAnonymityEnum.ANONYMOUS.getCode()) && this.isBeforeRole(flowrunodeIndex, currentNodeIndex, permissionConfig, flowruroleId) && !modifierId.equals(currUserId)) {
                flowruroleName = ANONYMOUS_STR;
                modifierName = ANONYMOUS_STR;
                modifierPicturefield = "";
            }
            soe = evalRecord.getBigDecimal("atcs");
            evaldesc = evalRecord.getString("ins");
            ole = evalRecord.getString("atcl");
            oleShowText = this.getOleShowText(sumperflevelId, ole);
            ArrayList hisItemList = (ArrayList)evalRecordMap.get(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__");
            if (hisItemList == null) {
                hisItemList = new ArrayList(10);
            }
            if (!iscrossnode.booleanValue()) {
                boolean isShowEvaldesc;
                boolean isShowOle;
                HashMap<String, String> flowrunodeMap = new HashMap<String, String>(16);
                flowrunodeMap.put("flowruroleName", flowruroleName);
                flowrunodeMap.put("modifierPicturefield", modifierPicturefield);
                flowrunodeMap.put("modifierName", modifierName);
                boolean isShowSoe = EvalOverallMultiDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "sum");
                if (isShowSoe) {
                    flowrunodeMap.put("soe", soe.setScale(numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).stripTrailingZeros().toPlainString());
                }
                if (isShowOle = EvalOverallMultiDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "level")) {
                    flowrunodeMap.put("ole", oleShowText);
                }
                if (isShowEvaldesc = EvalOverallMultiDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "comment")) {
                    flowrunodeMap.put("evaldesc", evaldesc);
                }
                hisItemList.add(flowrunodeMap);
            }
            evalRecordMap.put(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__", hisItemList);
        }
        for (DynamicObject task : processedTasks) {
            DynamicObject evalRecord;
            Long taskId = task.getLong("id");
            DynamicObject taskInfo = (DynamicObject)taskMap.get(taskId);
            if (HRObjectUtils.isEmpty((Object)taskInfo)) continue;
            Boolean iscrossnode = taskInfo.getBoolean("flowrunode.iscrossnode");
            String flowrunodeName = taskInfo.getString("flowrunode.name");
            int flowrunodeIndex = taskInfo.getInt("flowrunode.index");
            Long modifierId = taskInfo.getLong("handler.id");
            Long flowDefNodeId = taskInfo.getLong("flowrunode.flownodedef.id");
            BigDecimal flowrunodeWeight = taskInfo.getBigDecimal("flowrunode.nodeweight");
            String flowruroleName = taskInfo.getString("flowrurole.name");
            Long flowrunodeId = taskInfo.getLong("flowrunode.id");
            Long flowruroleId = taskInfo.getLong("flowrurole.id");
            int turnoversort = taskInfo.getInt("flowrurole.turnoversort");
            Map anonymousCfg = (Map)permCfgMap.get(flowDefNodeId);
            String scoreContent = "";
            if (anonymousCfg != null) {
                scoreContent = (String)anonymousCfg.get(ProcPermAnonymityEnum.ANONYMOUS.getCode());
                permissionConfig.put("histurnoversort", turnoversort);
                permissionConfig.put("hisflowrurole", flowruroleId);
            }
            String modifierPicturefield = taskInfo.getString("handler.picturefield");
            String modifierName = taskInfo.getString("handler.name");
            int currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
            if (HRStringUtils.equals((String)scoreContent, (String)ProcPermAnonymityEnum.ANONYMOUS.getCode()) && this.isBeforeRole(flowrunodeIndex, currentNodeIndex, permissionConfig, flowruroleId) && !modifierId.equals(currUserId)) {
                flowruroleName = ANONYMOUS_STR;
                modifierName = ANONYMOUS_STR;
                modifierPicturefield = "";
            }
            List hisItemList = new ArrayList(10);
            if (!iscrossnode.booleanValue() && permissionConfig != null && (evalRecord = (DynamicObject)Arrays.stream(actEvalObjSumRecord).filter(obj -> taskId.equals(obj.getLong("flowrutask.id"))).findFirst().orElse(null)) != null) {
                boolean isShowEvaldesc;
                boolean isShowOle;
                soe = evalRecord.getBigDecimal("ose");
                evaldesc = evalRecord.getString("eval");
                ole = evalRecord.getString("ole");
                oleShowText = this.getOleShowText(sumperflevelId, ole);
                hisItemList = (List)evalRecordMap.get(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString());
                if (hisItemList == null) {
                    hisItemList = new ArrayList(10);
                }
                HashMap<String, String> flowrunodeMap = new HashMap<String, String>(16);
                flowrunodeMap.put("flowruroleName", flowruroleName);
                flowrunodeMap.put("modifierPicturefield", modifierPicturefield);
                flowrunodeMap.put("modifierName", modifierName);
                boolean isShowSoe = EvalOverallMultiDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "sum");
                if (isShowSoe) {
                    flowrunodeMap.put("soe", soe.setScale(numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).stripTrailingZeros().toPlainString());
                }
                if (isShowOle = EvalOverallMultiDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "level")) {
                    flowrunodeMap.put("ole", oleShowText);
                }
                if (isShowEvaldesc = EvalOverallMultiDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "comment")) {
                    flowrunodeMap.put("evaldesc", evaldesc);
                }
                hisItemList.add(flowrunodeMap);
            }
            evalRecordMap.put(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString(), hisItemList);
        }
        return evalRecordMap;
    }

    private boolean isBeforeRole(int flowrunodeIndex, int currentNodeIndex, Map<String, Object> permissionConfig, Long flowruroleId) {
        FlowRuNodeBo flowRuNodeBo;
        Long evalflowinsId;
        WorkflowRuProcBo flowRuProcBo;
        List flowRuNodeBoList;
        Long actEvalObjUserId = (Long)permissionConfig.get("currActEvalUserId");
        Long currUserId = RequestContext.get().getCurrUserId();
        if (HRStringUtils.equals((String)String.valueOf(currUserId), (String)String.valueOf(actEvalObjUserId))) {
            return true;
        }
        if (flowrunodeIndex > currentNodeIndex) {
            return true;
        }
        if (flowrunodeIndex == currentNodeIndex && currentNodeIndex > 0 && (flowRuNodeBoList = (flowRuProcBo = APP_SERVICE.getRuProcInstance(evalflowinsId = (Long)permissionConfig.get("evalflowinsId"))).getFlowRuNodeBoList()) != null && flowRuNodeBoList.size() >= currentNodeIndex && (flowRuNodeBo = (FlowRuNodeBo)flowRuNodeBoList.get(currentNodeIndex - 1)) != null) {
            List flowRuRoleBoList = flowRuNodeBo.getFlowRuRoleBoList();
            Long currentFlowruroleId = (Long)permissionConfig.get("flowruroleId");
            if (flowRuRoleBoList != null) {
                int turnoversort = 0;
                int currentTurnoversort = 1;
                for (FlowRuRoleBo flowRuRoleBo : flowRuRoleBoList) {
                    Long pkValue = (Long)flowRuRoleBo.getFlowRuRole().getPkValue();
                    if (HRObjectUtils.equals((Object)pkValue, (Object)flowruroleId)) {
                        turnoversort = (Integer)flowRuRoleBo.getFlowRuRole().get("turnoversort");
                    }
                    if (!HRObjectUtils.equals((Object)pkValue, (Object)currentFlowruroleId)) continue;
                    currentTurnoversort = (Integer)flowRuRoleBo.getFlowRuRole().get("turnoversort");
                }
                if (turnoversort >= currentTurnoversort) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isShowFieldByPermission(Map<String, Object> permissionConfig, int flowrunodeIndex, long modifierId, String field) {
        boolean isShow = false;
        String scope = (String)permissionConfig.get(field);
        if (scope != null) {
            int currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
            long currUserId = RequestContext.get().getCurrUserId();
            switch (scope) {
                case "show_self": {
                    isShow = modifierId == currUserId;
                    break;
                }
                case "show_selfnode": {
                    isShow = flowrunodeIndex == currentNodeIndex;
                    break;
                }
                case "show_pre": {
                    isShow = flowrunodeIndex <= currentNodeIndex;
                    break;
                }
                case "show_all": {
                    isShow = true;
                    break;
                }
                case "show_selfandpre": {
                    if (modifierId == currUserId) {
                        return true;
                    }
                    if (flowrunodeIndex < currentNodeIndex) {
                        isShow = true;
                        break;
                    }
                    if (flowrunodeIndex == currentNodeIndex) {
                        isShow = IndicatorDetailUtils.isShowBySelfAndPre(permissionConfig, modifierId, currUserId);
                        break;
                    }
                    isShow = false;
                    break;
                }
            }
        }
        return isShow;
    }

    private String getOleShowText(Long sumperflevelId, String ole) {
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(sumperflevelId);
        if (perfLevelItems != null) {
            for (ComboItem perfLevelItem : perfLevelItems) {
                LocaleString caption;
                if (perfLevelItem == null) continue;
                String perfLevelItemValue = perfLevelItem.getValue();
                if (ole == null || !ole.equals(perfLevelItemValue) || (caption = perfLevelItem.getCaption()) == null) continue;
                return caption.getLocaleValue();
            }
        }
        return null;
    }

    private void showIndInfo(Long actEvalObjId, Long taskId) {
        DynamicObject actEvalObj = APP_SERVICE.queryActEvalObjById(actEvalObjId);
        DynamicObjectCollection areaEntry = actEvalObj.getDynamicObjectCollection("areaEntry");
        Map areaConfMap = areaEntry.stream().filter(obj -> AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(obj.getLong("areareg.id")) || AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(obj.getLong("areareg.id"))).collect(Collectors.toMap(x -> x.getLong("areaconf"), Function.identity()));
        Long activityId = actEvalObj.getLong("activity.id");
        DynamicObject activityObj = APP_SERVICE.queryExecuteSchemeByActivityID(activityId);
        Long assessFormId = activityObj.getLong("assessform.id");
        DynamicObject assessformObj = APP_SERVICE.queryAssessForm(assessFormId);
        String numAccuracy = assessformObj.getString("numaccuracy");
        String scaleType = assessformObj.getString("scaletype");
        String scoreCalcWay = assessformObj.getString("scorecalcway");
        List areaList = assessformObj.getDynamicObjectCollection("areaconfentry").stream().filter(obj -> AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(obj.getLong("areareg.id")) || AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(obj.getLong("areareg.id"))).sorted(Comparator.comparing(obj -> obj.getInt("seq"))).collect(Collectors.toList());
        FlexPanelAp indPanelAp = new HRFlexPanelAp.Builder(IND_TARGET_KEY).setDirection("column").setAlignItems("stretch").setJustifyContent("flex-start").setWrap(false).setGrow(0).setShrink(0).build();
        for (int i = 0; i < areaList.size(); ++i) {
            Boolean isShow;
            DynamicObject areaConf;
            String formId;
            DynamicObject areaConfObj = (DynamicObject)areaList.get(i);
            Long areaConfId = areaConfObj.getLong("areaconf");
            DynamicObject areaInsObj = (DynamicObject)areaConfMap.get(areaConfId);
            Long areaInsId = areaInsObj.getLong("areains");
            Long areaRegId = areaConfObj.getLong("areareg.id");
            String string = formId = AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId) ? "epa_gen_areains" : "epa_addsub_areains";
            if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId)) {
                areaConf = APP_SERVICE.queryGenAreaConf(areaConfId);
                Boolean ispartIn = areaConf.getBoolean("ispartin");
                Boolean isAllowEval = areaConf.getBoolean("isalloweval");
                isShow = ispartIn != false && isAllowEval != false;
            } else {
                areaConf = APP_SERVICE.queryAddSubAreaConf(areaConfId);
                isShow = areaConf.getBoolean("ispartin");
            }
            if (!isShow.booleanValue()) continue;
            String areaPanelKey = "areaap" + i;
            FlexPanelAp areaPanelAp = new HRFlexPanelAp.Builder(areaPanelKey).setShrink(0).setGrow(0).setBackColor("#ffffff").build();
            indPanelAp.getItems().add(areaPanelAp);
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setPkId((Object)areaInsId);
            showParameter.setFormId(formId);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(areaPanelKey);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
            showParameter.setCustomParam("actevalobj", (Object)actEvalObjId);
            showParameter.setCustomParam("confid", (Object)areaConfId);
            showParameter.setCustomParam("taskId", (Object)taskId);
            showParameter.setCustomParam("numaccuracy", (Object)numAccuracy);
            showParameter.setCustomParam("scaletype", (Object)scaleType);
            showParameter.setCustomParam("scorecalcway", (Object)scoreCalcWay);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        this.getView().updateControlMetadata(indPanelAp.getKey(), indPanelAp.createControl());
    }

    private List<LinkedHashMap<String, Object>> assembleEntryData(List<Long> taskIdList, Map<Long, DynamicObject> taskActEvalObjMap, Map<Long, String> taskStatusMap, Map<Long, DynamicObject> perffilesMap) {
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskIdList.get(0));
        int numaccuracy = assessForm.getInt("numaccuracy");
        String scaleType = assessForm.getString("scaletype");
        DynamicObject sumperfLevel = assessForm.getDynamicObject("sumperflevel");
        Map<Object, Object> perfLevelMap = new HashMap(16);
        if (sumperfLevel != null) {
            Long sumperfLevelId = sumperfLevel.getLong("id");
            List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(sumperfLevelId);
            perfLevelMap = perfLevelItems.stream().collect(Collectors.toMap(x -> x.getValue(), y -> y.getCaption().toString(), (v1, v2) -> v2));
        }
        DynamicObject[] actEvalObjSumRecord = APP_SERVICE.queryEvalObjSumRecordByTaskId(taskIdList);
        List sumAreaTaskIdList = Arrays.asList(actEvalObjSumRecord).stream().map(record -> record.getLong("flowrutask.id")).collect(Collectors.toList());
        ArrayList<LinkedHashMap<String, Object>> recordList = new ArrayList<LinkedHashMap<String, Object>>(10);
        if (taskIdList != null && !taskIdList.isEmpty()) {
            IPageCache pageCache = this.getView().getPageCache();
            String isShowOse = pageCache.get(IS_SHOW_OSE);
            String isShowOle = pageCache.get(IS_SHOW_OLE);
            for (int i = 0; i < taskIdList.size(); ++i) {
                Long taskId = taskIdList.get(i);
                DynamicObject actEvalObj = taskActEvalObjMap.get(taskId);
                LinkedHashMap<String, Object> record2 = new LinkedHashMap<String, Object>(16);
                record2.put("actevalobj", actEvalObj.getLong("id"));
                record2.put("flowrutask", taskId);
                record2.put("person", actEvalObj.getLong("person.id"));
                record2.put("num", actEvalObj.getString("person.number"));
                record2.put("adminorg", actEvalObj.getLong("affiliateadminorg.id"));
                record2.put("position", actEvalObj.getLong("empposrel.position.id"));
                DynamicObject perffile = perffilesMap.get(actEvalObj.getLong("perffile.id"));
                record2.put("adminorgst", perffile.getString("adminOrg.sortcode"));
                record2.put("positionindex", perffile.getString("position.index"));
                record2.put("selected", "");
                record2.put("headsculpture", HRImageUrlUtil.getImageFullUrl((String)String.valueOf(actEvalObj.getString("person.headsculpture"))));
                String taskStatus = taskStatusMap.get(taskId);
                if (sumAreaTaskIdList.contains(taskId)) {
                    DynamicObject sumRecordObj = Arrays.stream(actEvalObjSumRecord).filter(obj -> taskId.equals(obj.getLong("flowrutask.id"))).findFirst().orElse(null);
                    BigDecimal ose = sumRecordObj.getBigDecimal("ose");
                    String ole = sumRecordObj.getString("ole");
                    record2.put("ose", !HRObjectUtils.isEmpty((Object)ose) ? ose.setScale(numaccuracy, ScalaTypeEnum.get((String)scaleType).getType()) : null);
                    record2.put(IS_SHOW_OSE, !HRObjectUtils.isEmpty((Object)ose) && HRStringUtils.equals((String)isShowOse, (String)"1") ? "1" : "0");
                    record2.put("ole", HRStringUtils.isNotEmpty((String)ole) ? perfLevelMap.get(ole) : "");
                    record2.put("olevalue", HRStringUtils.isNotEmpty((String)ole) ? ole : "");
                    record2.put(IS_SHOW_OLE, HRStringUtils.isNotEmpty((String)ole) && HRStringUtils.equals((String)isShowOle, (String)"1") ? "1" : "0");
                    if (ose == null && HRStringUtils.isEmpty((String)ole) || FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus) || FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                        record2.put("isshowtaskstatus", "1");
                    } else {
                        record2.put("isshowtaskstatus", "0");
                    }
                } else {
                    record2.put("ose", null);
                    record2.put(IS_SHOW_OSE, "0");
                    record2.put("ole", "");
                    record2.put("olevalue", "");
                    record2.put(IS_SHOW_OLE, "0");
                    record2.put("isshowtaskstatus", "1");
                }
                record2.put("taskstatus", taskStatus);
                recordList.add(record2);
            }
        }
        return recordList;
    }

    private void updateEntryData(List<LinkedHashMap<String, Object>> recordList) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (Map.Entry<String, Object> entry : recordList.get(0).entrySet()) {
            vs.addField(entry.getKey(), new Object[0]);
        }
        for (LinkedHashMap linkedHashMap : recordList) {
            vs.addRow(linkedHashMap.values().toArray());
        }
        int count = vs.getCount();
        if (count > 0) {
            AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
            abstractFormDataModel.deleteEntryData("entryentity");
            abstractFormDataModel.beginInit();
            abstractFormDataModel.batchCreateNewEntryRow("entryentity", vs);
            abstractFormDataModel.endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void showActEvalObjInfo(Long actEvalObjId, Long selectedTaskId) {
        DynamicObject actEvalObj = APP_SERVICE.queryActEvalObjById(actEvalObjId);
        String personName = actEvalObj.getString("person.name");
        Label personAp = (Label)this.getControl("personname");
        personAp.setText(personName);
        String number = actEvalObj.getString("person.number");
        Label numberAp = (Label)this.getControl("personnum");
        numberAp.setText(number);
        String headsculpture = actEvalObj.getString("person.headsculpture");
        Image headimg = (Image)this.getControl("headimg");
        headimg.setUrl(HRImageUrlUtil.getImageFullUrl((String)headsculpture));
        String org = actEvalObj.getString("affiliateadminorg.name");
        Label orgAp = (Label)this.getControl("org");
        orgAp.setText(org);
        String pta = actEvalObj.getString("empposrel.position.name");
        Label ptaAp = (Label)this.getControl("pta");
        ptaAp.setText(pta);
        String activity = actEvalObj.getString("activity.name");
        Label activityAp = (Label)this.getControl("activity");
        activityAp.setText(activity);
        String period = actEvalObj.getString("activity.period");
        Label periodAp = (Label)this.getControl("period");
        periodAp.setText(period);
        String executescheme = actEvalObj.getString("activity.executescheme.name");
        Label executeschemeAp = (Label)this.getControl("executescheme");
        executeschemeAp.setText(executescheme);
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(selectedTaskId);
        String scoresystem = assessForm.getString("scoresystem.name");
        Label scoresystemAp = (Label)this.getControl("scoresystem");
        scoresystemAp.setText(scoresystem);
    }

    private void initSort() {
        FormShowParameter showParameter = this.getFilterCustomParam();
        showParameter.setFormId("epa_evaloverall_sort");
        showParameter.setShowTitle(false);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(SORTAP);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("elementId", SORTAP + this.getView().getPageId());
        showParameter.getOpenStyle().setCustParam(customParams);
        IPageCache pageCache = this.getView().getPageCache();
        String isShowOse = pageCache.get(IS_SHOW_OSE);
        String isShowOle = pageCache.get(IS_SHOW_OLE);
        showParameter.setCustomParam(IS_SHOW_OSE, (Object)isShowOse);
        showParameter.setCustomParam(IS_SHOW_OLE, (Object)isShowOle);
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
        this.getView().getPageCache().put(PAGECACHE_SORT_ID, showParameter.getPageId());
    }

    private void initFilters() {
        FormShowParameter showParameter = this.getFilterCustomParam();
        showParameter.setFormId("epa_evaloverall_filter");
        showParameter.setShowTitle(false);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(FILTERAP);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("elementId", FILTERAP + this.getView().getPageId());
        showParameter.getOpenStyle().setCustParam(customParams);
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
        this.getView().getPageCache().put(PAGECACHE_FILTER_ID, showParameter.getPageId());
    }

    private FormShowParameter getFilterCustomParam() {
        String taskStatusValue;
        String personIdStr;
        String positionIdStr;
        IPageCache pageCache = this.getPageCache();
        FormShowParameter showParameter = new FormShowParameter();
        String adminOrgIdStr = pageCache.get("adminorgId");
        if (!StringUtils.isEmpty((String)adminOrgIdStr)) {
            List orgIds = JSONObject.parseArray((String)adminOrgIdStr, Long.class);
            showParameter.setCustomParam("adminorgId", (Object)orgIds);
        }
        if (!StringUtils.isEmpty((String)(positionIdStr = pageCache.get("positionId")))) {
            List positionIds = JSONObject.parseArray((String)positionIdStr, Long.class);
            showParameter.setCustomParam("positionId", (Object)positionIds);
        }
        if (!StringUtils.isEmpty((String)(personIdStr = pageCache.get("personId")))) {
            List Ids = JSONObject.parseArray((String)personIdStr, Long.class);
            showParameter.setCustomParam("personId", (Object)Ids);
        }
        if (!StringUtils.isEmpty((String)(taskStatusValue = pageCache.get("taskstatusValue")))) {
            showParameter.setCustomParam("taskstatusValue", (Object)taskStatusValue);
        }
        return showParameter;
    }

    private void showCustomCtrl(String ctrlap, String isShow) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomControl customcontrol = (CustomControl)this.getView().getControl(ctrlap);
        map.put("show", isShow);
        map.put("timestamp", System.currentTimeMillis());
        customcontrol.setData(map);
    }

    private List<Map<String, Object>> getTaskList(FormShowParameter parameter) {
        Object batchTaskIdObj = parameter.getCustomParam("batchTaskId");
        if (batchTaskIdObj != null) {
            Long batchTaskId = Long.parseLong((String)batchTaskIdObj);
            return APP_SERVICE.getBatchTaskDetails(batchTaskId);
        }
        return new ArrayList<Map<String, Object>>(10);
    }
}

