/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaloverall;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.application.service.evaloverall.ActEvalObjOverallApplicationService;
import kd.opmc.epa.common.enums.evaloverall.ProcPermAnonymityEnum;
import kd.opmc.epa.formplugin.web.utils.IndicatorDetailUtils;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;

public class EvalOverallViewRecordEdit
extends HRDynamicFormBasePlugin {
    private static final int MAX_ROLE_COUNT = Integer.MAX_VALUE;
    private static final String TARGET_KEY = "viewdetailap";
    private static final String ANONYMOUS_STR = "***";
    private static final ActEvalObjOverallApplicationService APP_SERVICE = ActEvalObjOverallApplicationService.getInstance();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long actEvalObjId = (Long)parameter.getCustomParam("actevalobj");
        Long taskId = (Long)parameter.getCustomParam("taskId");
        DynamicObject[] actEvalObjSumRecord = APP_SERVICE.querySumRecordByActEvalObjId(actEvalObjId);
        DynamicObject[] actEvalObjAdjRecord = APP_SERVICE.queryAdjRecordByActEvalObjId(actEvalObjId);
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
        DynamicObject[] ndrRecord = APP_SERVICE.queryNdrRecordByActEvalObjId(actEvalObjId);
        Map<Long, BigDecimal> ndrMap = Arrays.asList(ndrRecord).stream().collect(Collectors.toMap(x -> x.getLong("flowrunode"), y -> y.getBigDecimal("sont")));
        List sumTaskIdList = Arrays.asList(actEvalObjSumRecord).stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(sumTaskIdList);
        Map taskMap = Arrays.asList(taskObjs).stream().filter(obj -> FlowRuTaskStatusEnum.PROCESSED.getCode().equals(obj.getString("taskstatus"))).collect(Collectors.toMap(x -> x.getLong("flowrunode.id"), Function.identity(), (v1, v2) -> v2));
        LinkedHashMap<String, Object> nodeMap = this.assembleSumEvalData(actEvalObjAdjRecord, actEvalObjSumRecord, assessForm.getLong("sumperflevel.id"));
        Map permissionConfig = APP_SERVICE.queryPermissionConfig(taskId);
        int currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
        for (Long flowrunodeKey : ndrMap.keySet()) {
            int nodeIndex;
            DynamicObject taskObj = (DynamicObject)taskMap.get(flowrunodeKey);
            if (HRObjectUtils.isEmpty((Object)taskObj) || currentNodeIndex > (nodeIndex = taskObj.getInt("flowrunode.index"))) continue;
            ndrMap.put(flowrunodeKey, null);
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epa_actevalind_flownode");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        formShowParameter.setCustomParam("flowNodeMap", (Object)JSON.toJSONString(nodeMap));
        formShowParameter.setCustomParam("ndrMap", (Object)JSON.toJSONString(ndrMap));
        formShowParameter.setCustomParam("maxRoleCount", (Object)Integer.MAX_VALUE);
        this.getView().showForm(formShowParameter);
    }

    private LinkedHashMap<String, Object> assembleSumEvalData(DynamicObject[] actEvalObjAdjRecord, DynamicObject[] actEvalObjSumRecord, Long sumperflevelId) {
        boolean isShowEvaldesc;
        boolean isShowOle;
        boolean isShowSoe;
        HashMap<String, String> flowrunodeMap;
        List hisItemList;
        String oleShowText;
        String ole;
        String evaldesc;
        BigDecimal soe;
        String modifierName;
        String modifierPicturefield;
        String flowrunodeId;
        String flowruroleName;
        BigDecimal flowrunodeWeight;
        String scoreContent;
        Long flowDefNodeId;
        Long modifierId;
        int flowrunodeIndex;
        String flowrunodeName;
        Boolean iscrossnode;
        DynamicObject taskInfo;
        Long taskId;
        LinkedHashMap<String, Object> evalRecordMap = new LinkedHashMap<String, Object>(16);
        List adjTaskIdList = Arrays.asList(actEvalObjAdjRecord).stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        List sumTaskIdList = Arrays.asList(actEvalObjSumRecord).stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        List taskIdList = Stream.of(adjTaskIdList, sumTaskIdList).flatMap(Collection::stream).collect(Collectors.toList());
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long currTaskId = (Long)parameter.getCustomParam("taskId");
        DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(taskIdList);
        Map taskMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
        HashMap anonymityMap = new HashMap(16);
        Map<String, Object> permissionConfig = new HashMap(16);
        DynamicObject taskObj = APP_SERVICE.queryTaskInfo(currTaskId);
        DynamicObject activityObj = APP_SERVICE.queryActivityById(taskObj.getLong("activity"));
        Long procPermId = activityObj.getLong("processpermsetting.id");
        permissionConfig = APP_SERVICE.queryPermissionConfig(currTaskId);
        Long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject evalRecord : actEvalObjAdjRecord) {
            taskId = evalRecord.getLong("flowrutask.id");
            taskInfo = (DynamicObject)taskMap.get(taskId);
            if (HRObjectUtils.isEmpty((Object)taskInfo)) continue;
            iscrossnode = taskInfo.getBoolean("flowrunode.iscrossnode");
            flowrunodeName = taskInfo.getString("flowrunode.name");
            flowrunodeIndex = taskInfo.getInt("flowrunode.index");
            modifierId = taskInfo.getLong("handler.id");
            flowDefNodeId = taskInfo.getLong("flowrunode.flownodedef.id");
            scoreContent = "";
            if (!anonymityMap.isEmpty()) {
                scoreContent = (String)anonymityMap.get(flowDefNodeId);
            }
            flowrunodeWeight = taskInfo.getBigDecimal("flowrunode.nodeweight");
            flowruroleName = taskInfo.getString("flowrurole.name");
            if (HRStringUtils.equals((String)scoreContent, (String)ProcPermAnonymityEnum.ANONYMOUS.getCode())) {
                flowruroleName = ANONYMOUS_STR;
            }
            flowrunodeId = taskInfo.getString("flowrunode.id");
            modifierPicturefield = taskInfo.getString("handler.picturefield");
            modifierName = taskInfo.getString("handler.name");
            if (HRStringUtils.equals((String)scoreContent, (String)ProcPermAnonymityEnum.ANONYMOUS.getCode()) && !modifierId.equals(currUserId)) {
                modifierName = ANONYMOUS_STR;
                modifierPicturefield = "";
            }
            soe = evalRecord.getBigDecimal("atcs");
            evaldesc = evalRecord.getString("ins");
            ole = evalRecord.getString("atcl");
            oleShowText = this.getOleShowText(sumperflevelId, ole);
            hisItemList = (ArrayList)evalRecordMap.get(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString());
            if (hisItemList == null) {
                hisItemList = new ArrayList(10);
            }
            permissionConfig.put("histurnoversort", taskInfo.getInt("flowrurole.turnoversort"));
            permissionConfig.put("hisflowrurole", taskInfo.getLong("flowrurole.id"));
            if (!iscrossnode.booleanValue()) {
                flowrunodeMap = new HashMap<String, String>(16);
                flowrunodeMap.put("flowruroleName", flowruroleName);
                flowrunodeMap.put("modifierPicturefield", modifierPicturefield);
                flowrunodeMap.put("modifierName", modifierName);
                isShowSoe = EvalOverallViewRecordEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "sum");
                if (isShowSoe) {
                    flowrunodeMap.put("soe", soe.stripTrailingZeros().toPlainString());
                }
                if (isShowOle = EvalOverallViewRecordEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "level")) {
                    flowrunodeMap.put("ole", oleShowText);
                }
                if (isShowEvaldesc = EvalOverallViewRecordEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "comment")) {
                    flowrunodeMap.put("evaldesc", evaldesc);
                }
                hisItemList.add(flowrunodeMap);
            }
            evalRecordMap.put(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString(), hisItemList);
        }
        for (DynamicObject evalRecord : actEvalObjSumRecord) {
            taskId = evalRecord.getLong("flowrutask.id");
            taskInfo = (DynamicObject)taskMap.get(taskId);
            if (HRObjectUtils.isEmpty((Object)taskInfo)) continue;
            iscrossnode = taskInfo.getBoolean("flowrunode.iscrossnode");
            flowrunodeName = taskInfo.getString("flowrunode.name");
            flowrunodeIndex = taskInfo.getInt("flowrunode.index");
            modifierId = taskInfo.getLong("handler.id");
            flowDefNodeId = taskInfo.getLong("flowrunode.flownodedef.id");
            scoreContent = "";
            if (!anonymityMap.isEmpty()) {
                scoreContent = (String)anonymityMap.get(flowDefNodeId);
            }
            flowrunodeWeight = taskInfo.getBigDecimal("flowrunode.nodeweight");
            flowruroleName = taskInfo.getString("flowrurole.name");
            if (HRStringUtils.equals((String)scoreContent, (String)ProcPermAnonymityEnum.ANONYMOUS.getCode())) {
                flowruroleName = ANONYMOUS_STR;
            }
            flowrunodeId = taskInfo.getString("flowrunode.id");
            modifierPicturefield = taskInfo.getString("handler.picturefield");
            modifierName = taskInfo.getString("handler.name");
            if (HRStringUtils.equals((String)scoreContent, (String)ProcPermAnonymityEnum.ANONYMOUS.getCode()) && !modifierId.equals(currUserId)) {
                modifierName = ANONYMOUS_STR;
                modifierPicturefield = "";
            }
            soe = evalRecord.getBigDecimal("ose");
            evaldesc = evalRecord.getString("eval");
            ole = evalRecord.getString("ole");
            oleShowText = this.getOleShowText(sumperflevelId, ole);
            hisItemList = (List)evalRecordMap.get(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString());
            if (hisItemList == null) {
                hisItemList = new ArrayList(10);
            }
            permissionConfig.put("histurnoversort", taskInfo.getInt("flowrurole.turnoversort"));
            permissionConfig.put("hisflowrurole", taskInfo.getLong("flowrurole.id"));
            if (!iscrossnode.booleanValue()) {
                flowrunodeMap = new HashMap(16);
                flowrunodeMap.put("flowruroleName", flowruroleName);
                flowrunodeMap.put("modifierPicturefield", modifierPicturefield);
                flowrunodeMap.put("modifierName", modifierName);
                isShowSoe = EvalOverallViewRecordEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "sum");
                if (isShowSoe) {
                    flowrunodeMap.put("soe", soe.stripTrailingZeros().toPlainString());
                }
                if (isShowOle = EvalOverallViewRecordEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "level")) {
                    flowrunodeMap.put("ole", oleShowText);
                }
                if (isShowEvaldesc = EvalOverallViewRecordEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "comment")) {
                    flowrunodeMap.put("evaldesc", evaldesc);
                }
                hisItemList.add(flowrunodeMap);
            }
            evalRecordMap.put(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString(), hisItemList);
        }
        return evalRecordMap;
    }

    private static boolean isShowFieldByPermission(Map<String, Object> permissionConfig, int flowrunodeIndex, long modifierId, String field) {
        boolean isShow = true;
        String scope = (String)permissionConfig.get(field);
        if (scope != null) {
            int currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
            switch (scope) {
                case "show_self": {
                    long currUserId = RequestContext.get().getCurrUserId();
                    isShow = modifierId == currUserId;
                    break;
                }
                case "show_selfnode": {
                    isShow = flowrunodeIndex == currentNodeIndex;
                    break;
                }
                case "show_pre": {
                    isShow = flowrunodeIndex <= currentNodeIndex;
                    break;
                }
                case "show_all": {
                    isShow = true;
                    break;
                }
                case "show_selfandpre": {
                    long currUserId = RequestContext.get().getCurrUserId();
                    isShow = flowrunodeIndex < currentNodeIndex ? true : (flowrunodeIndex == currentNodeIndex ? IndicatorDetailUtils.isShowBySelfAndPre(permissionConfig, modifierId, currUserId) : false);
                }
            }
        }
        return isShow;
    }

    private String getOleShowText(Long sumperflevelId, String ole) {
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(sumperflevelId);
        if (perfLevelItems != null) {
            for (ComboItem perfLevelItem : perfLevelItems) {
                LocaleString caption;
                if (perfLevelItem == null) continue;
                String perfLevelItemValue = perfLevelItem.getValue();
                if (ole == null || !ole.equals(perfLevelItemValue) || (caption = perfLevelItem.getCaption()) == null) continue;
                return caption.getLocaleValue();
            }
        }
        return null;
    }
}

