/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaloverall;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.evaloverall.ActEvalObjOverallApplicationService;
import kd.opmc.epa.common.enums.assessrule.EvalWayEnum;
import kd.opmc.pbs.business.model.NodeRoleConfigBo;

public class EvaluateOverallBatchEvalEdit
extends HRDataBaseEdit {
    private static final String CONFIRM = "confirm";
    private static final int SCALE_2 = 2;
    private static final String OSEAP = "oseap";
    private static final String OLEAP = "oleap";
    private static final String EVALAP = "evalap";
    private static final ActEvalObjOverallApplicationService APP_SERVICE = ActEvalObjOverallApplicationService.getInstance();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String taskIdListStr = (String)this.getView().getFormShowParameter().getCustomParam("taskIdList");
        List taskIdList = (List)JSON.parseObject((String)taskIdListStr, List.class);
        if (!taskIdList.isEmpty()) {
            Long taskId = (Long)taskIdList.get(0);
            this.setFieldInfo(taskId);
            this.setOleComboItems(taskId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (HRStringUtils.equals((String)"ose", (String)name)) {
            BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
            BigDecimal oldValue = (BigDecimal)e.getChangeSet()[0].getOldValue();
            String taskIdListStr = (String)this.getView().getFormShowParameter().getCustomParam("taskIdList");
            String actEvalObjIdListStr = (String)this.getView().getFormShowParameter().getCustomParam("actEvalObjIdList");
            List taskIdList = (List)JSON.parseObject((String)taskIdListStr, List.class);
            List actEvalObjIdList = (List)JSON.parseObject((String)actEvalObjIdListStr, List.class);
            if (!taskIdList.isEmpty() && !actEvalObjIdList.isEmpty()) {
                Long taskId = (Long)taskIdList.get(0);
                Long actEvalObjId = (Long)actEvalObjIdList.get(0);
                this.calOle(taskId, actEvalObjId, newValue, oldValue);
            }
        }
    }

    private void setFieldInfo(Long taskId) {
        Map permissionMap = APP_SERVICE.querySumPermMap(taskId);
        Map oseMap = (Map)permissionMap.get("ose");
        Map oleMap = (Map)permissionMap.get("ole");
        Map evalMap = (Map)permissionMap.get("eval");
        Map sumConfigMap = APP_SERVICE.querySumConfigByTaskId(taskId);
        FieldEdit oseField = (FieldEdit)this.getControl("ose");
        String oseCustName = ((DynamicObject)sumConfigMap.get("ose")).getString("fieldcustname");
        oseField.setCaption(new LocaleString(oseCustName));
        Boolean oseModifyitem = (Boolean)oseMap.get("fieldmodifyitem");
        this.getView().setEnable(oseModifyitem, new String[]{"ose"});
        Boolean oseMustInput = (Boolean)oseMap.get("fieldmustinputitem");
        oseField.setMustInput(oseMustInput.booleanValue());
        if (oleMap != null && !oleMap.isEmpty()) {
            Boolean oleDisplayItem = (Boolean)oleMap.get("fielddisplayitem");
            Boolean oleMustInput = (Boolean)oleMap.get("fieldmustinputitem");
            Boolean oleModifyitem = (Boolean)oleMap.get("fieldmodifyitem");
            if (oleDisplayItem.booleanValue()) {
                FieldEdit oleField = (FieldEdit)this.getControl("ole");
                DynamicObject oleObj = (DynamicObject)sumConfigMap.get("ole");
                String oleCustName = oleObj.getString("fieldcustname");
                oleField.setCaption(new LocaleString(oleCustName));
                this.getView().setEnable(oleModifyitem, new String[]{"ole"});
                oleField.setMustInput(oleMustInput.booleanValue());
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{OLEAP});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{OLEAP});
        }
        if (evalMap != null && !evalMap.isEmpty()) {
            Boolean evalDisplayItem = (Boolean)evalMap.get("fielddisplayitem");
            Boolean evalMustInput = (Boolean)evalMap.get("fieldmustinputitem");
            Boolean evalModifyitem = (Boolean)evalMap.get("fieldmodifyitem");
            if (evalDisplayItem.booleanValue()) {
                FieldEdit evalField = (FieldEdit)this.getControl("eval");
                DynamicObject evalObj = (DynamicObject)sumConfigMap.get("eval");
                String evalCustName = evalObj.getString("fieldcustname");
                evalField.setCaption(new LocaleString(evalCustName));
                this.getView().setEnable(evalModifyitem, new String[]{"eval"});
                if (evalMustInput != null) {
                    evalField.setMustInput(evalMustInput.booleanValue());
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{EVALAP});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{EVALAP});
        }
    }

    private void calOle(Long taskId, Long actEvalObjId, BigDecimal newValue, BigDecimal oldValue) {
        Long assessFormId;
        String ole;
        NodeRoleConfigBo roleConfig;
        Boolean isgradecompute;
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
        Map scoreRangeMap = APP_SERVICE.getScoreRangeMap(actEvalObjId);
        BigDecimal maxScore = (BigDecimal)scoreRangeMap.get("maxscore");
        BigDecimal minScore = (BigDecimal)scoreRangeMap.get("minscore");
        if (newValue != null && newValue.compareTo(minScore) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\uff0c\u53d6{2}\u3002", (String)"EvaluateOverallBatchEvalEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore, minScore}));
            this.getModel().setValue("ose", (Object)minScore);
        }
        if (newValue != null && newValue.compareTo(maxScore) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\uff0c\u53d6{2}\u3002", (String)"EvaluateOverallBatchEvalEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore, maxScore}));
            this.getModel().setValue("ose", (Object)maxScore);
        }
        if (newValue != null && (isgradecompute = (roleConfig = APP_SERVICE.queryNodeRoleConfigByTask(taskId)).getIsgradecompute()).equals(Boolean.TRUE) && (ole = APP_SERVICE.calculateLevel(assessFormId = Long.valueOf(assessForm.getLong("id")), this.getModel().getDataEntity().getBigDecimal("ose"))) != null) {
            this.getModel().setValue("ole", (Object)ole);
        }
    }

    private void setOleComboItems(Long taskId) {
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
        int numaccuracy = assessForm.getInt("numaccuracy");
        if (HRObjectUtils.isEmpty((Object)numaccuracy)) {
            numaccuracy = 2;
        }
        HashMap fieldMap = new HashMap();
        HashMap<String, Integer> itemMap = new HashMap<String, Integer>();
        itemMap.put("sc", numaccuracy);
        fieldMap.put("item", itemMap);
        this.getView().updateControlMetadata("ose", fieldMap);
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(Long.valueOf(assessForm.getLong("sumperflevel.id")));
        ComboEdit comboEdit = (ComboEdit)this.getControl("ole");
        comboEdit.setComboItems(perfLevelItems);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        String taskIdListStr = (String)this.getView().getFormShowParameter().getCustomParam("taskIdList");
        List taskIdList = (List)JSON.parseObject((String)taskIdListStr, List.class);
        if (StringUtils.equals((CharSequence)key, (CharSequence)CONFIRM)) {
            BigDecimal ose = (BigDecimal)this.getModel().getValue("ose");
            String ole = (String)this.getModel().getValue("ole");
            String eval = ((OrmLocaleValue)this.getModel().getValue("eval")).getLocaleValue();
            if (!taskIdList.isEmpty()) {
                Long taskId = (Long)taskIdList.get(0);
                Map sumConfigMap = APP_SERVICE.querySumConfigByTaskId(taskId);
                Map mustInputMap = APP_SERVICE.querySumMustInputMap(taskId);
                String oseCustName = ((DynamicObject)sumConfigMap.get("ose")).getString("fieldcustname");
                Boolean oseMustInput = (Boolean)mustInputMap.get("ose");
                ArrayList<String> mustInputErrorList = new ArrayList<String>(10);
                DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
                EvalWayEnum evalWay = EvalWayEnum.getEvalWay((String)assessForm.getString("evalway"));
                if ((evalWay == EvalWayEnum.SCORE || oseMustInput.booleanValue()) && HRObjectUtils.isEmpty((Object)ose)) {
                    mustInputErrorList.add(oseCustName);
                }
                DynamicObject oleObj = (DynamicObject)sumConfigMap.get("ole");
                String oleCustName = "";
                Boolean oleMustInput = Boolean.FALSE;
                if (oleObj != null) {
                    oleCustName = ((DynamicObject)sumConfigMap.get("ole")).getString("fieldcustname");
                    oleMustInput = (Boolean)mustInputMap.get("ole");
                    if (oleMustInput != null && oleMustInput.booleanValue() && HRStringUtils.isEmpty((String)ole)) {
                        mustInputErrorList.add(oleCustName);
                    }
                }
                String evalCustName = ((DynamicObject)sumConfigMap.get("eval")).getString("fieldcustname");
                Boolean evalMustInput = (Boolean)mustInputMap.get("eval");
                if (evalMustInput != null && evalMustInput.booleanValue() && HRStringUtils.isEmpty((String)eval)) {
                    mustInputErrorList.add(evalCustName);
                }
                if (mustInputErrorList.size() == 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199{0}\u3002", (String)"EvaluateOverallBatchEvalEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{mustInputErrorList.get(0)}));
                    return;
                }
                if (mustInputErrorList.size() == 2) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199{0}\u3001{1}\u3002", (String)"EvaluateOverallBatchEvalEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{mustInputErrorList.get(0), mustInputErrorList.get(1)}));
                    return;
                }
                if (mustInputErrorList.size() == 3) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"{0} {1} {2} \u4e3a\u5fc5\u586b\u9879\u3002", (String)"EvaluateOverallBatchEvalEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{mustInputErrorList.get(0), mustInputErrorList.get(1), mustInputErrorList.get(2)}));
                    return;
                }
            } else {
                return;
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            returnData.put("ose", ose);
            returnData.put("ole", ole);
            returnData.put("eval", eval);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

