/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaloverall;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.Pair;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.evaloverall.ActEvalObjOverallApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.formplugin.web.activitymanage.evaloverall.extpoint.IEvaluateOverallPreOpenService;
import kd.opmc.epa.formplugin.web.activitymanage.evaloverall.extpoint.impl.EvaluateOverallPreOpenService;
import kd.opmc.epa.formplugin.web.activitymanage.evaloverall.utils.EvaluteOverallDrawEntryUtil;
import kd.opmc.epa.formplugin.web.utils.LevelStatUtils;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.model.NodeRoleConfigBo;

public class EvaluateOverallEdit
extends HRDataBaseEdit
implements PagerClickListener,
EntryGridBindDataListener {
    private static final String TOOLBAR = "toolbarap";
    private static final String SUBMIT = "submit";
    private static final String REJECT = "reject";
    private static final String SAVE = "save";
    private static final String BATCHEVAL = "batcheval";
    private static final String VIEWWF = "viewwf";
    private static final String REFRESH = "refresh";
    private static final String CLOSE = "close";
    private static final String ACAP = "acap";
    private static final String PERIODAP = "periodap";
    private static final String SCHEMEAP = "schemeap";
    private static final String EPA_EVALOVERALL_REJECT = "epa_evaloverall_reject";
    private static final String EPA_EVALOVERALL_EVAL = "epa_evaloverall_eval";
    private static final String DETAIL = "detail";
    private static final String SUBMIT_TASK_CLOSE_BACK = "submit_task_close_back";
    private static final String FAIL_PROCESSED_KEY = "processed";
    private static final String FAIL_RETURNED_KEY = "returned";
    private static final String FAIL_EXPIRED_KEY = "expired";
    private static final String FAIL_MUSTINPUT_KEY = "mustinput";
    private static final Log LOG = LogFactory.getLog(EvaluateOverallEdit.class);
    private static final ActEvalObjOverallApplicationService APP_SERVICE = ActEvalObjOverallApplicationService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final ActEvalObjDetailApplicationService ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE = ActEvalObjDetailApplicationService.getInstance();

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter parameter = e.getFormShowParameter();
        EvaluateOverallPreOpenService iService = new EvaluateOverallPreOpenService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iService, IEvaluateOverallPreOpenService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.evaloverall.extpoint.IEvaluateOverallPreOpenService#verifyPreOpenForm", null);
        List result = hrPluginProxy.callReplaceIfPresent(p -> p.verifyPreOpenForm(parameter));
        boolean verifyResult = false;
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            verifyResult = result.stream().allMatch(obj -> obj);
        }
        if (!verifyResult) {
            List<Map<String, Object>> taskList = this.getTaskList(parameter);
            parameter.setHasRight(true);
            if (ObjectUtils.isEmpty(taskList)) {
                List<Map<String, Object>> expiredTaskList = this.getExpiredTaskList(parameter);
                if (ObjectUtils.isEmpty(expiredTaskList)) {
                    e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5904\u7406\u4eba\u3002", (String)"EvaluateOverallEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                } else {
                    e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvaluateOverallEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
                e.setCancel(true);
                return;
            }
            List taskIdList = taskList.stream().map(task -> (Long)task.get("taskId")).collect(Collectors.toList());
            ArrayList<Object> validateAllList = new ArrayList<Object>(10);
            for (Long tid : taskIdList) {
                Pair checkResult = APP_SERVICE.checkTaskInfo(tid);
                validateAllList.add(checkResult.getKey());
            }
            if (!validateAllList.contains(Boolean.TRUE)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvaluateOverallEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBAR});
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        this.initCellFontColorAndEditable();
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        this.initCellFontColorAndEditable();
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        List<Map<String, Object>> taskList = this.getTaskList(parameter);
        if (!taskList.isEmpty()) {
            Long taskId = (Long)taskList.get(0).get("taskId");
            List personInfoFields = APP_SERVICE.queryOverallPersonInfoFields(taskId);
            List evalObjNodeFields = APP_SERVICE.queryEvalObjNodes(taskList);
            List sumConfFields = APP_SERVICE.querySumConf(taskId);
            boolean isShowLevel = false;
            for (Map sumConfField : sumConfFields) {
                if (!"ole".equals(sumConfField.get("id"))) continue;
                isShowLevel = true;
                break;
            }
            parameter.getCustomParams().put("isShowLevel", isShowLevel);
            List<Map<String, Object>> entryFields = EvaluteOverallDrawEntryUtil.assembleToListFields(evalObjNodeFields, sumConfFields);
            EvaluteOverallDrawEntryUtil.drawDynamicEntry(e, personInfoFields, entryFields);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Long sumperflevel;
        boolean isShowLevel;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List<Map<String, Object>> taskList = this.getTaskList(parameter);
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        int currentRow = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject rowObj = (DynamicObject)entries.get(currentRow);
        if (HRStringUtils.equals((String)"ose", (String)name)) {
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
            Long taskId = rowObj.getLong("flowrutask.id");
            if (!HRObjectUtils.isEmpty((Object)newValue)) {
                Long actEvalObjId = rowObj.getLong("actevalObj.id");
                this.calOle(taskId, actEvalObjId, newValue, oldValue, currentRow);
            }
        } else if (HRStringUtils.equals((String)"ole", (String)name) && (isShowLevel = ((Boolean)this.getView().getFormShowParameter().getCustomParam("isShowLevel")).booleanValue()) && (sumperflevel = Long.valueOf(this.getPageCache().get("sumperflevel"))) != 0L) {
            String newValue = (String)changeData.getNewValue();
            String oldValue = (String)changeData.getOldValue();
            LevelStatUtils.refreshLevelStat(this.getView(), newValue, oldValue);
        }
        this.changeTaskStatus(rowObj, currentRow);
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection dynamicObjects = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        DynamicObjectCollection dyObjs = new DynamicObjectCollection();
        dyObjs.add(dynamicObjects.get(currentIndex));
        APP_SERVICE.saveSumRecord(dyObjs);
    }

    private void changeTaskStatus(DynamicObject rowObj, int currentRow) {
        Object taskstatus;
        if (rowObj != null && !HRObjectUtils.isEmpty((Object)(taskstatus = rowObj.get("taskstatus"))) && HRStringUtils.equals((String)taskstatus.toString(), (String)FlowRuTaskStatusEnum.WAITING.getCode())) {
            Long taskId = rowObj.getLong("flowrutask.id");
            APP_SERVICE.processTask(Collections.singletonList(taskId));
            this.getModel().setValue("taskstatus", (Object)FlowRuTaskStatusEnum.PROCESSING.getCode(), currentRow);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        switch (key = evt.getItemKey()) {
            case "submit": {
                this.submitTask();
                break;
            }
            case "reject": {
                this.rejectTask();
                break;
            }
            case "save": {
                this.saveSumAreaRecord();
                break;
            }
            case "batcheval": {
                this.batchEval();
                break;
            }
            case "viewwf": {
                this.viewWF();
                break;
            }
            case "close": {
                this.getView().close();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.freezeEntryCol();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List<Map<String, Object>> taskList = this.getTaskList(parameter);
        if (!taskList.isEmpty()) {
            LevelStatUtils.initLevelStatFlex(this.getView(), (Long)taskList.get(0).get("taskId"));
            this.initActivityInfo(taskList);
            this.initEvalOverlEntry(taskList, Boolean.TRUE);
            this.initToolBar(taskList);
        }
    }

    private void freezeEntryCol() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.setColumnProperty("name", "isFixed", (Object)true);
            entryGrid.setColumnProperty("number", "isFixed", (Object)true);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String cacheKey = this.getPageCache().get("cacheKey");
        if (HRStringUtils.isNotEmpty((String)cacheKey)) {
            IHRAppCache cache = HRAppCache.get((String)"epa");
            cache.remove(cacheKey);
            cache.remove(cacheKey + "pageId");
            this.getPageCache().remove(cacheKey);
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        switch (actionId) {
            case "epa_evaloverall_eval": {
                if (HRObjectUtils.isEmpty((Object)returnData)) break;
                Map data = (Map)returnData;
                BigDecimal ose = (BigDecimal)data.get("ose");
                String ole = (String)data.get("ole");
                if (HRStringUtils.isEmpty((String)ole)) {
                    ole = "";
                }
                String eval = (String)data.get("eval");
                EntryGrid grid = (EntryGrid)this.getControl("entryentity");
                DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
                int[] selectRows = grid.getSelectRows();
                DynamicObjectCollection dyObjs = new DynamicObjectCollection();
                ArrayList<String> processedList = new ArrayList<String>(10);
                ArrayList<String> returnedList = new ArrayList<String>(10);
                ArrayList<String> expiredList = new ArrayList<String>(10);
                ArrayList<Long> selectedTaskIdList = new ArrayList<Long>(10);
                for (int selectRow : selectRows) {
                    DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                    DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                    selectedTaskIdList.add(flowrutask.getLong("id"));
                }
                Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(selectedTaskIdList);
                for (int row : selectRows) {
                    DynamicObject evalSumObj = (DynamicObject)entity.get(row);
                    String name = evalSumObj.getString("name");
                    String number = evalSumObj.getString("number");
                    Long tId = evalSumObj.getLong("flowrutask.id");
                    String taskStatusStr = (String)taskStatusMap.get(tId);
                    FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
                    if (FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus)) {
                        processedList.add(ResManager.loadKDString((String)"{0} {1} \u5df2\u8bc4\u4f30\u4efb\u52a1\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u8bc4\u4f30\u3002", (String)"EvaluateOverallEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus)) {
                        returnedList.add(ResManager.loadKDString((String)"{0} {1} \u5df2\u9000\u56de\u4efb\u52a1\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u8bc4\u4f30\u3002", (String)"EvaluateOverallEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus)) {
                        expiredList.add(ResManager.loadKDString((String)"{0} {1} \u5df2\u5931\u6548\u4efb\u52a1\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u8bc4\u4f30\u3002", (String)"EvaluateOverallEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (!FlowRuTaskStatusEnum.WAITING.equals((Object)taskStatus) && !FlowRuTaskStatusEnum.PROCESSING.equals((Object)taskStatus)) continue;
                    evalSumObj.set("ose", (Object)ose);
                    evalSumObj.set("ole", (Object)ole);
                    evalSumObj.set("eval", (Object)eval);
                    dyObjs.add((Object)evalSumObj);
                }
                if (returnedList.isEmpty() && processedList.isEmpty() && expiredList.isEmpty()) {
                    APP_SERVICE.saveSumRecord(dyObjs);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"EvaluateOverallEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                } else {
                    HashMap<String, Object> failMap = new HashMap<String, Object>(16);
                    failMap.put(FAIL_PROCESSED_KEY, processedList);
                    failMap.put(FAIL_RETURNED_KEY, returnedList);
                    failMap.put(FAIL_EXPIRED_KEY, expiredList);
                    int success = selectRows.length - processedList.size() - returnedList.size() - expiredList.size();
                    this.showBatchForm(selectRows.length, success, failMap, ResManager.loadKDString((String)"\u6279\u91cf\u8bc4\u4f30", (String)"EvaluateOverallEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    if (success != 0) {
                        APP_SERVICE.saveSumRecord(dyObjs);
                    }
                }
                List taskIdList = dyObjs.stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
                APP_SERVICE.processTask(taskIdList);
                List<Map<String, Object>> entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
                this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
                break;
            }
            case "epa_evaloverall_reject": {
                if (HRObjectUtils.isEmpty((Object)returnData)) break;
                Map data = (Map)returnData;
                ArrayList<Long> taskIdList = new ArrayList<Long>(10);
                String reason = (String)data.get("reason");
                EntryGrid grid = (EntryGrid)this.getControl("entryentity");
                DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
                int[] selectRows = grid.getSelectRows();
                ArrayList<String> processedList = new ArrayList<String>(10);
                ArrayList<String> returnedList = new ArrayList<String>(10);
                ArrayList<String> expiredList = new ArrayList<String>(10);
                ArrayList<Long> selectedTaskIdList = new ArrayList<Long>(10);
                for (int selectRow : selectRows) {
                    DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                    DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                    selectedTaskIdList.add(flowrutask.getLong("id"));
                }
                Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(selectedTaskIdList);
                for (int row : selectRows) {
                    DynamicObject dynamicObject = (DynamicObject)entity.get(row);
                    Long tId = dynamicObject.getLong("flowrutask.id");
                    String taskStatusStr = (String)taskStatusMap.get(tId);
                    String name = dynamicObject.getString("name");
                    String number = dynamicObject.getString("number");
                    FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
                    if (FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus)) {
                        processedList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a {1}\uff09 \u5df2\u8bc4\u4f30\u4efb\u52a1\uff0c\u4e0d\u652f\u6301\u9000\u56de\u3002", (String)"EvaluateOverallEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus)) {
                        returnedList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a {1}\uff09 \u4efb\u52a1\u5df2\u88ab\u4ed6\u4eba\u64cd\u4f5c\u9000\u56de\u3002", (String)"EvaluateOverallEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus)) {
                        expiredList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a {1}\uff09 \u5df2\u5931\u6548\u4efb\u52a1\uff0c\u4e0d\u652f\u6301\u9000\u56de\u3002", (String)"EvaluateOverallEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    taskIdList.add(dynamicObject.getLong("flowrutask.id"));
                }
                String successMsg = ResManager.loadKDString((String)"\u9000\u56de\u6210\u529f\u3002", (String)"EvaluateOverallEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                if (returnedList.isEmpty() && processedList.isEmpty() && expiredList.isEmpty()) {
                    List<RollbackParamBo> rollbackParamBoList = this.assembleRollbackParam(taskIdList, reason);
                    APP_SERVICE.rollbackToLastNodeOrRole(rollbackParamBoList);
                    List<Map<String, Object>> entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
                    this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
                    this.getView().showSuccessNotification(successMsg);
                    break;
                }
                HashMap<String, Object> failMap = new HashMap<String, Object>(16);
                failMap.put(FAIL_PROCESSED_KEY, processedList);
                failMap.put(FAIL_RETURNED_KEY, returnedList);
                failMap.put(FAIL_EXPIRED_KEY, expiredList);
                int success = selectRows.length - processedList.size() - returnedList.size() - expiredList.size();
                this.showBatchForm(selectRows.length, success, failMap, ResManager.loadKDString((String)"\u6279\u91cf\u9000\u56de", (String)"EvaluateOverallEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                if (success != 0) {
                    List<RollbackParamBo> rollbackParamBoList = this.assembleRollbackParam(taskIdList, reason);
                    APP_SERVICE.rollbackToLastNodeOrRole(rollbackParamBoList);
                }
                List<Map<String, Object>> entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
                this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
                break;
            }
            case "submit_task_close_back": {
                break;
            }
        }
    }

    private List<RollbackParamBo> assembleRollbackParam(List<Long> taskIdList, String reason) {
        ArrayList<RollbackParamBo> rollbackParamBoList = new ArrayList<RollbackParamBo>(10);
        DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(taskIdList);
        Map taskMap = Arrays.stream(taskObjs).collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
        for (int i = 0; i < taskIdList.size(); ++i) {
            Long taskId = taskIdList.get(i);
            DynamicObject taskObj = (DynamicObject)taskMap.get(taskId);
            RollbackParamBo rollbackParamBo = new RollbackParamBo();
            rollbackParamBo.setRuProcId(Long.valueOf(taskObj.getLong("flowruproc.id")));
            rollbackParamBo.setRuNodeId(Long.valueOf(taskObj.getLong("flowrunode.id")));
            rollbackParamBo.setRollbackType("2");
            rollbackParamBo.setMergeTask(Boolean.valueOf(false));
            rollbackParamBo.setRuTaskId(taskId);
            rollbackParamBo.setReason(reason);
            rollbackParamBoList.add(rollbackParamBo);
        }
        return rollbackParamBoList;
    }

    private void batchEval() {
        boolean checkFlag = this.checkValidate();
        if (checkFlag) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            int[] selectRows = grid.getSelectRows();
            ArrayList<Long> taskIdList = new ArrayList<Long>(10);
            ArrayList<Long> actEvalObjIdList = new ArrayList<Long>(10);
            for (int selectRow : selectRows) {
                DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                Long taskId = flowrutask.getLong("id");
                taskIdList.add(taskId);
                DynamicObject actevalobj = rowObj.getDynamicObject("actevalobj");
                Long actEvalObjId = actevalobj.getLong("id");
                actEvalObjIdList.add(actEvalObjId);
            }
            Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(taskIdList);
            Boolean invalidFlag = Boolean.FALSE;
            for (int selectRow : selectRows) {
                DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                Long tId = flowrutask.getLong("id");
                String taskStatusStr = (String)taskStatusMap.get(tId);
                FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
                if (!FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus) && !FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus) && !FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u201c\u5f85\u8bc4\u4f30\u201d\u53ca\u201c\u8bc4\u4f30\u4e2d\u201d\u7684\u4efb\u52a1\u652f\u6301\u6279\u91cf\u8bc4\u4f30\u64cd\u4f5c\u3002", (String)"EvaluateOverallEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                invalidFlag = Boolean.TRUE;
                break;
            }
            if (invalidFlag.booleanValue()) {
                List<Map<String, Object>> taskList = this.getTaskList(this.getView().getFormShowParameter());
                this.initEvalOverlEntry(taskList, Boolean.FALSE);
            } else {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_batcheval");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("taskIdList", (Object)JSON.toJSONString(taskIdList));
                showParameter.setCustomParam("actEvalObjIdList", (Object)JSON.toJSONString(actEvalObjIdList));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EPA_EVALOVERALL_EVAL));
                StyleCss styleCss = new StyleCss();
                styleCss.setWidth("580px");
                styleCss.setHeight("354px");
                showParameter.getOpenStyle().setInlineStyleCss(styleCss);
                showParameter.setHasRight(true);
                this.getView().showForm(showParameter);
            }
        }
    }

    private void rejectTask() {
        boolean checkFlag = this.checkValidate();
        if (checkFlag) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            int[] selectRows = grid.getSelectRows();
            ArrayList<Long> taskIdList = new ArrayList<Long>(10);
            for (int selectRow : selectRows) {
                DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                Long taskId = flowrutask.getLong("id");
                taskIdList.add(taskId);
            }
            Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(taskIdList);
            Boolean invalidFlag = Boolean.FALSE;
            for (int selectRow : selectRows) {
                DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                Long tId = flowrutask.getLong("id");
                String taskStatusStr = (String)taskStatusMap.get(tId);
                FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
                if (!FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus) && !FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus) && !FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f85\u8bc4\u4f30\u6216\u8005\u8bc4\u4f30\u4e2d\u4efb\u52a1\u624d\u53ef\u9000\u56de\u3002", (String)"EvaluateOverallEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                invalidFlag = Boolean.TRUE;
                break;
            }
            if (invalidFlag.booleanValue()) {
                List<Map<String, Object>> entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
                this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
            } else {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_batchreject");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("taskIdList", (Object)JSON.toJSONString(taskIdList));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EPA_EVALOVERALL_REJECT));
                showParameter.setHasRight(true);
                this.getView().showForm(showParameter);
            }
        }
    }

    private void saveSumAreaRecord() {
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        int[] selectRows = grid.getSelectRows();
        List<Map<String, Object>> taskList = this.getTaskList(this.getView().getFormShowParameter());
        List taskIdList = taskList.stream().map(taskinfo -> (Long)taskinfo.get("taskId")).collect(Collectors.toList());
        Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(taskIdList);
        DynamicObjectCollection dyObjs = new DynamicObjectCollection();
        Boolean invalidFlag = Boolean.FALSE;
        for (int selectRow : selectRows) {
            DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
            DynamicObject taskObj = rowObj.getDynamicObject("flowrutask");
            Long tId = taskObj.getLong("id");
            String taskStatusStr = (String)taskStatusMap.get(tId);
            FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
            if (taskStatus == null || FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus) || FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus) || FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f85\u8bc4\u4f30\u6216\u8005\u8bc4\u4f30\u4e2d\u4efb\u52a1\u624d\u53ef\u4fdd\u5b58\u3002", (String)"EvaluateOverallEdit_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                invalidFlag = Boolean.TRUE;
                break;
            }
            dyObjs.add((Object)rowObj);
        }
        if (!invalidFlag.booleanValue()) {
            if (dyObjs.size() > 0) {
                APP_SERVICE.saveSumRecord(dyObjs);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"EvaluateOverallEdit_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvaluateOverallEdit_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
        this.initEvalOverlEntry(taskList, Boolean.FALSE);
    }

    private Boolean checkValidate() {
        boolean checkFlag = true;
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            checkFlag = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvaluateOverallEdit_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return checkFlag;
    }

    private void submitTask() {
        boolean checkFlag = this.checkValidate();
        if (checkFlag) {
            List<Map<String, Object>> entryTaskIdList;
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            Long firstTaskId = ((DynamicObject)entity.get(0)).getLong("flowrutask.id");
            Map mustInputMap = APP_SERVICE.querySumMustInputMap(firstTaskId);
            Map sumCustNameMap = APP_SERVICE.querySumCustNameMap(firstTaskId);
            Boolean oseMustInput = (Boolean)mustInputMap.get("ose");
            Boolean oleMustInput = (Boolean)mustInputMap.get("ole");
            Boolean evalMustInput = (Boolean)mustInputMap.get("eval");
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = grid.getSelectRows();
            ArrayList<Long> selectedTaskIdList = new ArrayList<Long>(10);
            for (int selectRow : selectRows) {
                DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                selectedTaskIdList.add(flowrutask.getLong("id"));
            }
            Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(selectedTaskIdList);
            DynamicObjectCollection dyObjs = new DynamicObjectCollection();
            ArrayList<Long> taskIdList = new ArrayList<Long>(10);
            HashMap<String, Object> failMap = new HashMap<String, Object>(16);
            ArrayList<String> processedList = new ArrayList<String>(10);
            ArrayList<String> returnedList = new ArrayList<String>(10);
            ArrayList<String> expiredList = new ArrayList<String>(10);
            ArrayList<String> mustInputInvalidList = new ArrayList<String>(10);
            for (int selectRow : selectRows) {
                DynamicObject rowObj = (DynamicObject)entity.get(selectRow);
                DynamicObject flowrutask = rowObj.getDynamicObject("flowrutask");
                Long tId = flowrutask.getLong("id");
                String taskStatusStr = (String)taskStatusMap.get(tId);
                String name = rowObj.getString("name");
                String number = rowObj.getString("number");
                FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
                if (FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus)) {
                    processedList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a {1}\uff09 \u5df2\u8bc4\u4f30\u4efb\u52a1\uff0c\u4e0d\u652f\u6301\u63d0\u4ea4\u3002", (String)"EvaluateOverallEdit_17", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                    continue;
                }
                if (FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus)) {
                    returnedList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a {1}\uff09 \u5df2\u9000\u56de\u4efb\u52a1\uff0c\u4e0d\u652f\u6301\u63d0\u4ea4\u3002", (String)"EvaluateOverallEdit_18", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                    continue;
                }
                if (FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus)) {
                    expiredList.add(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a {1}\uff09 \u5df2\u5931\u6548\u4efb\u52a1\uff0c\u4e0d\u652f\u6301\u9000\u56de\u3002", (String)"EvaluateOverallEdit_19", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                    continue;
                }
                ArrayList<String> mustInputErrorList = new ArrayList<String>(10);
                BigDecimal ose = rowObj.getBigDecimal("ose");
                String oseFiledName = (String)sumCustNameMap.get("ose");
                if (HRObjectUtils.isEmpty((Object)ose) && oseMustInput.booleanValue() && !HRStringUtils.isEmpty((String)oseFiledName)) {
                    mustInputErrorList.add(oseFiledName);
                }
                String ole = rowObj.getString("ole");
                String oleFieldName = (String)sumCustNameMap.get("ole");
                if (HRObjectUtils.isEmpty((Object)ole) && oleMustInput != null && oleMustInput.booleanValue() && !HRStringUtils.isEmpty((String)oleFieldName)) {
                    mustInputErrorList.add(oleFieldName);
                }
                String eval = rowObj.getString("eval");
                String evalFieldName = (String)sumCustNameMap.get("eval");
                if (HRObjectUtils.isEmpty((Object)eval) && evalMustInput != null && evalMustInput.booleanValue() && !HRStringUtils.isEmpty((String)evalFieldName)) {
                    mustInputErrorList.add(evalFieldName);
                }
                if (mustInputErrorList.size() == 1) {
                    mustInputInvalidList.add(ResManager.loadKDString((String)"{0} {1} {2}\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002", (String)"EvaluateOverallEdit_20", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number, mustInputErrorList.get(0)}));
                    continue;
                }
                if (mustInputErrorList.size() == 2) {
                    mustInputInvalidList.add(ResManager.loadKDString((String)"{0} {1} {2}\u3001{3}\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002", (String)"EvaluateOverallEdit_21", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number, mustInputErrorList.get(0), mustInputErrorList.get(1)}));
                    continue;
                }
                if (mustInputErrorList.size() == 3) {
                    mustInputInvalidList.add(ResManager.loadKDString((String)"{0} {1} {2}\u3001{3}\u3001{4}\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002", (String)"EvaluateOverallEdit_22", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number, mustInputErrorList.get(0), mustInputErrorList.get(1), mustInputErrorList.get(2)}));
                    continue;
                }
                dyObjs.add((Object)rowObj);
                Long taskId = flowrutask.getLong("id");
                taskIdList.add(taskId);
            }
            if (!(processedList.isEmpty() && returnedList.isEmpty() && expiredList.isEmpty())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f85\u8bc4\u4f30\u6216\u8005\u8bc4\u4f30\u4e2d\u4efb\u52a1\u624d\u53ef\u63d0\u4ea4\u3002", (String)"EvaluateOverallEdit_23", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
                this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
                return;
            }
            APP_SERVICE.saveSumRecord(dyObjs);
            if (!taskIdList.isEmpty()) {
                APP_SERVICE.submitTask(taskIdList);
            }
            failMap.put(FAIL_PROCESSED_KEY, processedList);
            failMap.put(FAIL_RETURNED_KEY, returnedList);
            failMap.put(FAIL_EXPIRED_KEY, expiredList);
            failMap.put(FAIL_MUSTINPUT_KEY, mustInputInvalidList);
            if (selectRows.length == taskIdList.size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"EvaluateOverallEdit_24", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else {
                this.showBatchForm(selectRows.length, taskIdList.size(), failMap, ResManager.loadKDString((String)"\u6279\u91cf\u63d0\u4ea4", (String)"EvaluateOverallEdit_25", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
            entryTaskIdList = this.getTaskList(this.getView().getFormShowParameter());
            this.initEvalOverlEntry(entryTaskIdList, Boolean.FALSE);
        }
    }

    private void showBatchForm(int total, int success, Map<String, Object> failMap, String caption) {
        List processedList = (List)failMap.get(FAIL_PROCESSED_KEY);
        List expiredList = (List)failMap.get(FAIL_EXPIRED_KEY);
        List returnedList = (List)failMap.get(FAIL_RETURNED_KEY);
        List mustInputInvalidList = (List)failMap.get(FAIL_MUSTINPUT_KEY);
        List failList = Stream.of(processedList, expiredList, returnedList).flatMap(Collection::stream).collect(Collectors.toList());
        if (total == returnedList.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u9000\u56de\u3002", (String)"EvaluateOverallEdit_26", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (total == processedList.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u8bc4\u4f30\u3002", (String)"EvaluateOverallEdit_27", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (mustInputInvalidList != null && !mustInputInvalidList.isEmpty()) {
            if (total == mustInputInvalidList.size()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"EvaluateOverallEdit_28", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            failList.addAll(mustInputInvalidList);
        }
        if (total == expiredList.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvaluateOverallEdit_29", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("total", (Object)total);
        formShowParameter.setCustomParam("success", (Object)success);
        formShowParameter.setCustomParam("fail", (Object)JSON.toJSONString(failList));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("epa_evaloverall_batchmsg");
        formShowParameter.setCaption(caption);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("460px");
        styleCss.setHeight("294px");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm(formShowParameter);
    }

    private void viewWF() {
        List<Map<String, Object>> taskList = this.getTaskList(this.getView().getFormShowParameter());
        List taskIdList = taskList.stream().map(taskinfo -> (Long)taskinfo.get("taskId")).collect(Collectors.toList());
        Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(taskIdList);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvaluateOverallEdit_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else if (selectRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EvaluateOverallEdit_30", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObjectCollection entries = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
            Long taskId = ((DynamicObject)entries.get(selectRows[0])).getLong("flowrutask.id");
            String taskStatusStr = (String)taskStatusMap.get(taskId);
            FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
            if (FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus) || taskStatus == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvaluateOverallEdit_29", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.initEvalOverlEntry(taskList, Boolean.FALSE);
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            DynamicObject evalflowinsObj = APP_SERVICE.queryFlowRuProcByTaskId((Object)taskId);
            formShowParameter.setCustomParam("evalflowinsId", (Object)evalflowinsObj.getLong("id"));
            formShowParameter.setCustomParam("taskId", (Object)taskId);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("epa_workflow_proc");
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("600");
            styleCss.setHeight("600");
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            this.getView().showForm(formShowParameter);
        }
    }

    private List<Map<String, Object>> getTaskList(FormShowParameter parameter) {
        Object batchTaskIdObj = parameter.getCustomParam("batchTaskId");
        if (batchTaskIdObj != null) {
            Long batchTaskId = Long.parseLong((String)batchTaskIdObj);
            QFilter taskStatusFilter = new QFilter("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
            taskStatusFilter.and("handler", "=", (Object)RequestContext.get().getCurrUserId());
            return FLOW_RU_SECOND_DOMAIN_SERVICE.getBatchTaskDetails(batchTaskId, taskStatusFilter);
        }
        return new ArrayList<Map<String, Object>>(10);
    }

    private List<Map<String, Object>> getExpiredTaskList(FormShowParameter parameter) {
        Object batchTaskIdObj = parameter.getCustomParam("batchTaskId");
        if (batchTaskIdObj != null) {
            Long batchTaskId = Long.parseLong((String)batchTaskIdObj);
            QFilter taskStatusFilter = new QFilter("taskstatus", "in", Collections.singletonList(FlowRuTaskStatusEnum.EXPIRED.getCode()));
            return APP_SERVICE.getBatchTaskList(batchTaskId, taskStatusFilter);
        }
        return new ArrayList<Map<String, Object>>(10);
    }

    private void initActivityInfo(List<Map<String, Object>> taskList) {
        Long taskId = (Long)taskList.get(0).get("taskId");
        DynamicObject activityObj = APP_SERVICE.queryActivityByTaskId(taskId);
        String activityName = activityObj.getString("name");
        Label acap = (Label)this.getView().getControl(ACAP);
        acap.setText(activityName);
        String activityPeriod = activityObj.getString("period");
        Label periodap = (Label)this.getView().getControl(PERIODAP);
        periodap.setText(activityPeriod);
        DynamicObject assessscopeObj = activityObj.getDynamicObject("executescheme.assessscope");
        Label schemeap = (Label)this.getView().getControl(SCHEMEAP);
        schemeap.setText(assessscopeObj.getString("name"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String key;
        super.afterDoOperation(eventArgs);
        List<Map<String, Object>> taskList = this.getTaskList(this.getView().getFormShowParameter());
        List taskIdList = taskList.stream().map(taskinfo -> (Long)taskinfo.get("taskId")).collect(Collectors.toList());
        Map taskStatusMap = APP_SERVICE.queryTaskStatusMap(taskIdList);
        switch (key = eventArgs.getOperateKey()) {
            case "detail": {
                int selectedRow = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject dyObj = this.getModel().getEntryRowEntity("entryentity", selectedRow);
                Long actEvalObjId = dyObj.getLong("actevalobj.id");
                Long taskId = dyObj.getLong("flowrutask.id");
                String taskStatusStr = (String)taskStatusMap.get(taskId);
                FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusStr);
                if (FlowRuTaskStatusEnum.EXPIRED.equals((Object)taskStatus) || taskStatus == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvaluateOverallEdit_29", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    this.initEvalOverlEntry(taskList, Boolean.FALSE);
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("epa_evalmulti_detail");
                formShowParameter.setStatus(OperationStatus.VIEW);
                formShowParameter.setHasRight(true);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam("taskId", (Object)taskId);
                formShowParameter.setCustomParam("actevalobj", (Object)actEvalObjId);
                formShowParameter.setCustomParam("batchTaskId", this.getView().getFormShowParameter().getCustomParam("batchTaskId"));
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u4ed6\u4eba\u8bc4\u4f30\u8be6\u60c5", (String)"EvaluateOverallEdit_31", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "refresh": {
                this.initEvalOverlEntry(taskList, Boolean.FALSE);
                break;
            }
        }
    }

    private void initEvalOverlEntry(List<Map<String, Object>> taskList, Boolean isInit) {
        if (taskList == null || taskList.size() == 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
            return;
        }
        List actEvalObjIdList = taskList.stream().map(taskinfo -> (Long)taskinfo.get("actEvaObjId")).collect(Collectors.toList());
        DynamicObject[] actEvalObjs = APP_SERVICE.queryEvalObjById(actEvalObjIdList);
        Map actEvalObjMap = Arrays.asList(actEvalObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
        List perffilesIdList = Arrays.asList(actEvalObjs).stream().map(actEvalObj -> actEvalObj.getLong("perffile.id")).collect(Collectors.toList());
        DynamicObject[] perffiles = APP_SERVICE.queryPerffileById(perffilesIdList);
        Map<Long, DynamicObject> perffilesMap = Arrays.asList(perffiles).stream().collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
        List<Long> taskIdList = taskList.stream().map(taskinfo -> (Long)taskinfo.get("taskId")).collect(Collectors.toList());
        Map<Long, DynamicObject> taskActEvalObjMap = taskList.stream().collect(Collectors.toMap(x -> (Long)x.get("taskId"), y -> (DynamicObject)actEvalObjMap.get((Long)y.get("actEvaObjId"))));
        DynamicObject[] actEvalObjSumRecord = APP_SERVICE.queryEvalObjSumRecordByTaskId(taskIdList);
        Map ndrMap = APP_SERVICE.queryObjNodeResRecordByTaskIdList(taskIdList);
        List<LinkedHashMap<String, Object>> recordList = this.assembleData(taskIdList, taskActEvalObjMap, perffilesMap, actEvalObjSumRecord, ndrMap);
        recordList = recordList.stream().sorted(Comparator.comparing(obj -> ((LinkedHashMap)obj).get("taskstatus").toString()).thenComparing(obj -> ((LinkedHashMap)obj).get("number").toString())).collect(Collectors.toList());
        if (!isInit.booleanValue() && recordList.isEmpty()) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
            return;
        }
        this.addEntryRowAndSetInitData(recordList);
        this.initCellFontColorAndEditable();
    }

    private List<LinkedHashMap<String, Object>> assembleData(List<Long> taskIdList, Map<Long, DynamicObject> taskActEvalObjMap, Map<Long, DynamicObject> perffilesMap, DynamicObject[] actEvalObjSumRecord, Map<Long, List<BigDecimal>> ndrMap) {
        Integer n;
        int i;
        DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(taskIdList);
        Map<Long, Boolean> isRollBackedMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getBoolean("isrollbacked"), (v1, v2) -> v2));
        Map<Long, String> taskStatusMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("taskstatus"), (v1, v2) -> v2));
        Map<Long, Long> taskProcMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getLong("flowruproc.id"), (v1, v2) -> v2));
        Map<Long, Long> taskNodeMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getLong("flowrunode.id"), (v1, v2) -> v2));
        List sumAreaTaskIdList = Arrays.asList(actEvalObjSumRecord).stream().map(record -> record.getLong("flowrutask.id")).collect(Collectors.toList());
        ArrayList<LinkedHashMap<String, Object>> recordList = new ArrayList<LinkedHashMap<String, Object>>(10);
        HashMap<String, Integer> levelStatMap = new HashMap<String, Integer>(8);
        for (i = 0; i < taskIdList.size(); ++i) {
            DynamicObject sumAreaEvalRecord;
            Long preEvalTaskId;
            DynamicObject sumAreaEvalRecord2;
            Long taskId = taskIdList.get(i);
            Long flowruprocId = taskProcMap.get(taskId);
            if (sumAreaTaskIdList.contains(taskId)) continue;
            LinkedHashMap<String, Object> record2 = new LinkedHashMap<String, Object>(16);
            DynamicObject actEvalObj = taskActEvalObjMap.get(taskId);
            record2.put("actevalobj", actEvalObj.getLong("id"));
            record2.put("perffile", actEvalObj.getLong("perffile.id"));
            record2.put("flowrutask", taskId);
            record2.put("name", actEvalObj.getString("person.name"));
            record2.put("number", actEvalObj.getString("person.number"));
            record2.put("adminorg", actEvalObj.getString("perffile.adminOrg.name"));
            record2.put("position", actEvalObj.getString("perffile.position.name"));
            record2.put("job", actEvalObj.getString("perffile.job.name"));
            record2.put("adminorgbd", actEvalObj.getLong("perffile.adminOrg.id"));
            record2.put("positionbd", actEvalObj.getLong("perffile.position.id"));
            record2.put("jobbd", actEvalObj.getLong("perffile.job.id"));
            DynamicObject perffile = perffilesMap.get(actEvalObj.getLong("perffile.id"));
            record2.put("adminorgst", perffile.getString("adminOrg.sortcode"));
            record2.put("positionindex", perffile.getString("position.index"));
            record2.put("person", perffile.getLong("depemp.person.id"));
            List<BigDecimal> ndrList = ndrMap.get(flowruprocId);
            if (!HRObjectUtils.isEmpty(ndrList)) {
                for (int j = 0; j < ndrList.size(); ++j) {
                    BigDecimal sont = ndrList.get(j);
                    String nodeKey = "node" + (j + 1);
                    record2.put(nodeKey, sont);
                }
            }
            record2.put("sumareains", 0L);
            Object initOse = null;
            record2.put("ose", initOse);
            record2.put("ole", "");
            record2.put("eval", "");
            Long preOleTaskId = APP_SERVICE.queryPreRoleLastTaskOfNextGrade(taskId);
            if (preOleTaskId != null && preOleTaskId != 0L && (sumAreaEvalRecord2 = APP_SERVICE.querySumAreaEvalRecord(preOleTaskId)) != null && !HRStringUtils.equals((String)"$$NOTNEEDCARRY$$", (String)sumAreaEvalRecord2.getString("ole"))) {
                record2.put("ole", sumAreaEvalRecord2.getString("ole"));
            }
            if ((preEvalTaskId = APP_SERVICE.queryPreRoleLastTaskOfNextEval(taskId)) != null && preEvalTaskId != 0L && (sumAreaEvalRecord = APP_SERVICE.querySumAreaEvalRecord(preEvalTaskId)) != null && !HRStringUtils.equals((String)"$$NOTNEEDCARRY$$", (String)sumAreaEvalRecord.getString("eval"))) {
                record2.put("eval", sumAreaEvalRecord.getString("eval"));
            }
            record2.put("taskstatus", taskStatusMap.get(taskId));
            String oleStr = (String)record2.get("ole");
            Integer levelStat = (Integer)levelStatMap.get(oleStr);
            if (levelStat == null) {
                levelStat = 0;
            }
            Integer n2 = levelStat;
            n = levelStat = Integer.valueOf(levelStat + 1);
            levelStatMap.put(oleStr, levelStat);
            recordList.add(record2);
        }
        for (i = 0; i < actEvalObjSumRecord.length; ++i) {
            LinkedHashMap<String, Object> record3 = new LinkedHashMap<String, Object>(16);
            DynamicObject sumRecordObj = actEvalObjSumRecord[i];
            Long taskId = sumRecordObj.getLong("flowrutask.id");
            Long flowruprocId = taskProcMap.get(taskId);
            Long actEvalObjId = sumRecordObj.getLong("actevalobj");
            DynamicObject actEvalObj = taskActEvalObjMap.get(taskId);
            record3.put("actevalobj", actEvalObjId);
            record3.put("perffile", actEvalObj.get("perffile.id"));
            record3.put("flowrutask", taskId);
            record3.put("name", actEvalObj.getString("perffile.name"));
            record3.put("number", actEvalObj.getString("perffile.billno"));
            record3.put("adminorg", actEvalObj.getString("perffile.adminOrg.name"));
            record3.put("position", actEvalObj.getString("perffile.position.name"));
            record3.put("job", actEvalObj.getString("perffile.job.name"));
            record3.put("adminorgbd", actEvalObj.getLong("perffile.adminOrg.id"));
            record3.put("positionbd", actEvalObj.getLong("perffile.position.id"));
            record3.put("jobbd", actEvalObj.getLong("perffile.job.id"));
            DynamicObject perffile = perffilesMap.get(actEvalObj.getLong("perffile.id"));
            record3.put("adminorgst", perffile.getString("adminOrg.sortcode"));
            record3.put("positionindex", perffile.getString("position.index"));
            record3.put("person", perffile.getLong("depemp.person.id"));
            List<BigDecimal> ndrList = ndrMap.get(flowruprocId);
            if (!HRObjectUtils.isEmpty(ndrList)) {
                for (int j = 0; j < ndrList.size(); ++j) {
                    BigDecimal sont = ndrList.get(j);
                    String nodeKey = "node" + (j + 1);
                    record3.put(nodeKey, sont);
                }
            }
            record3.put("sumareains", sumRecordObj.getLong("id"));
            record3.put("ose", sumRecordObj.getBigDecimal("ose"));
            record3.put("ole", sumRecordObj.get("ole"));
            record3.put("eval", sumRecordObj.getString("eval"));
            record3.put("taskstatus", taskStatusMap.get(taskId));
            boolean isrollbacked = isRollBackedMap.get(taskId);
            String taskStatus = taskStatusMap.get(taskId);
            if (FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus)) {
                Long preEvalTaskId;
                Date curModifytime = sumRecordObj.getDate("modifytime");
                Long preOleTaskId = APP_SERVICE.queryPreRoleLastTaskOfNextGrade(taskId);
                if (preOleTaskId != null && preOleTaskId != 0L) {
                    DynamicObject sumAreaEvalRecord = APP_SERVICE.querySumAreaEvalRecord(preOleTaskId);
                    if (!isrollbacked && sumAreaEvalRecord != null && !HRStringUtils.equals((String)"$$NOTNEEDCARRY$$", (String)sumAreaEvalRecord.getString("ole"))) {
                        record3.put("ole", sumAreaEvalRecord.getString("ole"));
                    }
                }
                if ((preEvalTaskId = APP_SERVICE.queryPreRoleLastTaskOfNextEval(taskId)) != null && preEvalTaskId != 0L) {
                    DynamicObject sumAreaEvalRecord = APP_SERVICE.querySumAreaEvalRecord(preEvalTaskId);
                    if (!isrollbacked && sumAreaEvalRecord != null && !HRStringUtils.equals((String)"$$NOTNEEDCARRY$$", (String)sumAreaEvalRecord.getString("eval"))) {
                        record3.put("eval", sumAreaEvalRecord.getString("eval"));
                    }
                }
            }
            recordList.add(record3);
            String oleStr = (String)record3.get("ole");
            Integer levelStat = (Integer)levelStatMap.get(oleStr);
            if (levelStat == null) {
                levelStat = 0;
            }
            n = levelStat;
            Integer n3 = levelStat = Integer.valueOf(levelStat + 1);
            levelStatMap.put(oleStr, levelStat);
        }
        levelStatMap.put("total", recordList.size());
        LevelStatUtils.initLevelStat(this.getView(), null, levelStatMap);
        return recordList;
    }

    private void addEntryRowAndSetInitData(List<LinkedHashMap<String, Object>> recordList) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (Map.Entry<String, Object> entry : recordList.get(0).entrySet()) {
            vs.addField(entry.getKey(), new Object[0]);
        }
        for (LinkedHashMap linkedHashMap : recordList) {
            vs.addRow(linkedHashMap.values().toArray());
        }
        int count = vs.getCount();
        if (count > 0) {
            AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
            abstractFormDataModel.deleteEntryData("entryentity");
            abstractFormDataModel.beginInit();
            abstractFormDataModel.batchCreateNewEntryRow("entryentity", vs);
            abstractFormDataModel.endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void initToolBar(List<Map<String, Object>> taskList) {
        Long taskId = (Long)taskList.get(0).get("taskId");
        boolean isCrossOver = (Boolean)taskList.get(0).get("iscrossevaluate");
        if (isCrossOver) {
            this.getView().setVisible(Boolean.FALSE, new String[]{REJECT, "ose", "ole", "eval"});
        } else {
            Boolean firstNodeAndRole = APP_SERVICE.isFirstNodeAndRole(taskId);
            if (firstNodeAndRole.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{REJECT});
            }
        }
    }

    private void initCellFontColorAndEditable() {
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entity.size(); ++i) {
            CellStyle cellStyle;
            DynamicObject rowObj = (DynamicObject)entity.get(i);
            FlowRuTaskStatusEnum taskStatus = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)rowObj.getString("taskstatus"));
            if (FlowRuTaskStatusEnum.WAITING.equals((Object)taskStatus) || FlowRuTaskStatusEnum.PROCESSING.equals((Object)taskStatus)) {
                cellStyle = new CellStyle();
                cellStyle.setFieldKey("taskstatus");
                cellStyle.setRow(i);
                cellStyle.setForeColor("#FF5F1F");
                cellStyles.add(cellStyle);
            }
            if (FlowRuTaskStatusEnum.PROCESSED.equals((Object)taskStatus)) {
                cellStyle = new CellStyle();
                cellStyle.setFieldKey("taskstatus");
                cellStyle.setRow(i);
                cellStyle.setForeColor("#1BA854");
                cellStyles.add(cellStyle);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"ose", "ole", "eval"});
            }
            if (!FlowRuTaskStatusEnum.RETURNED.equals((Object)taskStatus)) continue;
            cellStyle = new CellStyle();
            cellStyle.setFieldKey("taskstatus");
            cellStyle.setRow(i);
            cellStyle.setForeColor("#FB2323");
            cellStyles.add(cellStyle);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"ose", "ole", "eval"});
        }
        grid.setCellStyle(cellStyles);
    }

    private void calOle(Long taskId, Long actEvalObjId, BigDecimal newValue, BigDecimal oldValue, int currentRow) {
        String ole;
        BigDecimal minScore;
        BigDecimal maxScore;
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
        Long assessFormId = assessForm.getLong("id");
        String minScoreStr = this.getPageCache().get(assessFormId + "_min");
        String maxScoreStr = this.getPageCache().get(assessFormId + "_max");
        if (HRStringUtils.isEmpty((String)maxScoreStr)) {
            Map scoreRangeMap = APP_SERVICE.getScoreRangeMap(actEvalObjId);
            maxScore = (BigDecimal)scoreRangeMap.get("maxscore");
            minScore = (BigDecimal)scoreRangeMap.get("minscore");
            this.getPageCache().put(assessFormId + "_max", String.valueOf(maxScore));
            this.getPageCache().put(assessFormId + "_min", String.valueOf(minScore));
        } else {
            minScore = new BigDecimal(minScoreStr);
            maxScore = new BigDecimal(maxScoreStr);
        }
        BigDecimal ose = newValue;
        if (newValue.compareTo(minScore) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\uff0c\u53d6{2}\u3002", (String)"EvaluateOverallEdit_32", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore, minScore}));
            this.getModel().setValue("ose", (Object)minScore, currentRow);
            return;
        }
        if (newValue.compareTo(maxScore) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\uff0c\u53d6{2}\u3002", (String)"EvaluateOverallEdit_32", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore, maxScore}));
            this.getModel().setValue("ose", (Object)maxScore, currentRow);
            return;
        }
        String isgradecomputeStr = this.getPageCache().get("isgradecompute");
        if (HRStringUtils.isEmpty((String)isgradecomputeStr)) {
            NodeRoleConfigBo roleConfig = APP_SERVICE.queryNodeRoleConfigByTask(taskId);
            Boolean isgradecompute = roleConfig.getIsgradecompute();
            if (isgradecompute.booleanValue()) {
                this.getPageCache().put("isgradecompute", "true");
                String ole2 = APP_SERVICE.calculateLevel(assessFormId, ose);
                if (HRStringUtils.isNotEmpty((String)ole2)) {
                    this.getModel().setValue("ole", (Object)ole2, currentRow);
                }
            } else {
                this.getPageCache().put("isgradecompute", "false");
            }
        } else if (HRStringUtils.equals((String)isgradecomputeStr, (String)"true") && (ole = APP_SERVICE.calculateLevel(assessFormId, ose)) != null) {
            this.getModel().setValue("ole", (Object)ole, currentRow);
        }
    }
}

