/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaloverall;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class EvaluateOverallFilterEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String ADMINORG = "adminorg";
    private static final String POSITION = "position";
    private static final String PERSON = "person";
    private static final String TASKSTATUS = "taskstatus";
    private static final String NODATALABELAP = "nodatalabelap";
    private static final String FILTER_RESET = "filter_reset";
    private static final String FILTER_CANCEL = "filter_cancel";
    private static final String FILTER_CONFIRM = "filter_confirm";
    private static final String CANCEL = "cancel";
    private static final String CONFIRM = "confirm";
    private static final String RESET = "reset";
    private static final String NODATA = "nodata";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit adminOrgCtrl = (BasedataEdit)this.getControl(ADMINORG);
        adminOrgCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit positionCtrl = (BasedataEdit)this.getControl(POSITION);
        positionCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit perosnCtrl = (BasedataEdit)this.getControl(PERSON);
        perosnCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        String f7 = ((Control)beforeF7SelectEvent.getSource()).getKey();
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        switch (f7) {
            case "adminorg": {
                List adminOrgIdList;
                String adminOrgIdStr = pageCache.get("adminorgId");
                if (StringUtils.isEmpty((String)adminOrgIdStr) || HRObjectUtils.isEmpty((Object)(adminOrgIdList = JSONObject.parseArray((String)adminOrgIdStr, Long.class)))) break;
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)adminOrgIdList.toArray()));
                break;
            }
            case "position": {
                List positionIdList;
                String positionIdStr = pageCache.get("positionId");
                if (StringUtils.isEmpty((String)positionIdStr) || HRObjectUtils.isEmpty((Object)(positionIdList = JSONObject.parseArray((String)positionIdStr, Long.class)))) break;
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)positionIdList.toArray()));
                break;
            }
            case "person": {
                List personIdList;
                String personIdStr = pageCache.get("personId");
                if (StringUtils.isEmpty((String)personIdStr) || HRObjectUtils.isEmpty((Object)(personIdList = JSONObject.parseArray((String)personIdStr, Long.class)))) break;
                listShowParameter.setMultiSelect(Boolean.TRUE.booleanValue());
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)personIdList.toArray()));
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        String selectedTaskStatus;
        List selectedpersonIds;
        List selectedPositionIdList;
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List selectedAdminOrgIdList = (List)formShowParameter.getCustomParam("selected_adminorgId");
        if (!HRObjectUtils.isEmpty((Object)selectedAdminOrgIdList)) {
            this.getModel().setValue(ADMINORG, (Object)selectedAdminOrgIdList.toArray());
            this.getView().updateView(ADMINORG);
        }
        if (!HRObjectUtils.isEmpty((Object)(selectedPositionIdList = (List)formShowParameter.getCustomParam("selected_positionId")))) {
            this.getModel().setValue(POSITION, (Object)selectedPositionIdList.toArray());
            this.getView().updateView(POSITION);
        }
        if (!HRObjectUtils.isEmpty((Object)(selectedpersonIds = (List)formShowParameter.getCustomParam("selected_personId")))) {
            this.getModel().setValue(PERSON, (Object)selectedpersonIds.toArray());
            this.getView().updateView(PERSON);
        }
        if (HRStringUtils.isEmpty((String)(selectedTaskStatus = (String)formShowParameter.getCustomParam("selected_taskstatus")))) {
            this.getModel().setValue(TASKSTATUS, (Object)selectedTaskStatus);
            this.getView().updateView(TASKSTATUS);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{NODATALABELAP});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{NODATALABELAP});
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection selectedAdminOrgs = dataEntity.getDynamicObjectCollection(ADMINORG);
        List selectedAdminOrgIds = selectedAdminOrgs.stream().map(obj -> obj.getLong("fbasedataid.id")).collect(Collectors.toList());
        DynamicObjectCollection selectedPositions = dataEntity.getDynamicObjectCollection(POSITION);
        List selectedPositionIds = selectedPositions.stream().map(obj -> obj.getLong("fbasedataid.id")).collect(Collectors.toList());
        DynamicObjectCollection selectedPersons = dataEntity.getDynamicObjectCollection(PERSON);
        List selectedPersonIds = selectedPersons.stream().map(obj -> obj.getLong("fbasedataid.id")).collect(Collectors.toList());
        String selectedTaskStatus = dataEntity.getString(TASKSTATUS);
        switch (operateKey) {
            case "cancel": {
                List personIds;
                String selectedPersonIdStr;
                List positionIds;
                String selectedPositionIdStr;
                List adminOrgIds;
                String selectedAdminOrgIdStr = this.getPageCache().get("selected_adminorgId");
                if (!HRStringUtils.isEmpty((String)selectedAdminOrgIdStr) && (adminOrgIds = (List)JSON.parseObject((String)selectedAdminOrgIdStr, List.class)) != null && !adminOrgIds.isEmpty()) {
                    this.getModel().setValue(ADMINORG, (Object)adminOrgIds.toArray());
                }
                if (!HRStringUtils.isEmpty((String)(selectedPositionIdStr = this.getPageCache().get("selected_positionId"))) && (positionIds = (List)JSON.parseObject((String)selectedPositionIdStr, List.class)) != null && !positionIds.isEmpty()) {
                    this.getModel().setValue(POSITION, (Object)positionIds.toArray());
                }
                if (!HRStringUtils.isEmpty((String)(selectedPersonIdStr = this.getPageCache().get("selected_personId"))) && (personIds = (List)JSON.parseObject((String)selectedPersonIdStr, List.class)) != null && !personIds.isEmpty()) {
                    this.getModel().setValue(PERSON, (Object)personIds.toArray());
                }
                String selectedTaskStatusStr = this.getPageCache().get("selected_taskstatus");
                if (!HRStringUtils.isEmpty((String)selectedTaskStatus)) {
                    this.getModel().setValue(TASKSTATUS, (Object)selectedTaskStatusStr);
                }
                this.getView().getParentView().invokeOperation(FILTER_CANCEL);
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
            case "reset": {
                String[] ids = new String[]{};
                this.getModel().setValue(ADMINORG, (Object)ids);
                this.getModel().setValue(POSITION, (Object)ids);
                this.getModel().setValue(PERSON, (Object)ids);
                this.getModel().setValue(TASKSTATUS, (Object)"");
                this.getPageCache().put("selected_adminorgId", "");
                this.getPageCache().put("selected_positionId", "");
                this.getPageCache().put("selected_personId", "");
                this.getPageCache().put("selected_taskstatus", "");
                this.getView().returnDataToParent(null);
                this.getView().getParentView().invokeOperation(FILTER_RESET);
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
            case "confirm": {
                this.getView().getParentView().invokeOperation(FILTER_CONFIRM);
                this.getView().sendFormAction(this.getView().getParentView());
                this.getPageCache().put("selected_adminorgId", JSON.toJSONString(selectedAdminOrgIds));
                this.getPageCache().put("selected_positionId", JSON.toJSONString(selectedPositionIds));
                this.getPageCache().put("selected_personId", JSON.toJSONString(selectedPersonIds));
                this.getPageCache().put("selected_taskstatus", selectedTaskStatus);
                break;
            }
        }
        if (HRStringUtils.equals((String)NODATA, (String)operateKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{NODATALABELAP});
        }
    }
}

