/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaloverall;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.evaloverall.ActEvalObjOverallApplicationService;

public class EvaluateOverallIndDetailEdit
extends HRDataBaseEdit {
    private static final ActEvalObjOverallApplicationService APP_SERVICE = ActEvalObjOverallApplicationService.getInstance();
    private static final String CLOSE = "close";
    private static final int MAX_COLUMN = 41;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CLOSE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showIndicatorDetail();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)CLOSE, (String)key)) {
            this.getView().close();
        }
    }

    private void showIndicatorDetail() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long indId = (Long)parameter.getCustomParam("indId");
        String formId = (String)parameter.getCustomParam("formId");
        Long confId = (Long)parameter.getCustomParam("confid");
        String numAccuracy = (String)parameter.getCustomParam("numaccuracy");
        String scaleType = (String)parameter.getCustomParam("scaletype");
        String scoreCalcWay = (String)parameter.getCustomParam("scorecalcway");
        DynamicObject indObj = null;
        DynamicObject confObj = null;
        if (HRStringUtils.equals((String)formId, (String)"epa_gen_areains")) {
            indObj = APP_SERVICE.queryGenIndObj(indId);
            confObj = APP_SERVICE.queryGenAreaConf(confId);
        } else if (HRStringUtils.equals((String)formId, (String)"epa_addsub_areains")) {
            indObj = APP_SERVICE.queryAddSubIndObj(indId);
            confObj = APP_SERVICE.queryAddSubAreaConf(confId);
        }
        int maxSeq = 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (indObj != null && confObj != null) {
            DynamicObjectCollection entryEntity = confObj.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
                if (entryObj == null) continue;
                String fieldNumber = entryObj.getString("areafield.number");
                String fieldKey = entryObj.getString("areafield.number");
                String custName = entryObj.getString("fieldcustname");
                String fieldCategory = entryObj.getString("areafield.category");
                if (!fieldCategory.equals("10") && !fieldCategory.equals("20")) continue;
                Label keyLabel = (Label)this.getView().getControl("indkey" + maxSeq);
                keyLabel.setText(custName);
                Label valLabel = (Label)this.getView().getControl("indval" + maxSeq);
                if (fieldNumber.equals("evaltype") || fieldNumber.equals("evalmode")) {
                    String valueStr = indObj.getString(fieldKey);
                    DataEntityPropertyCollection properties = indObj.getDataEntityType().getProperties();
                    ComboProp comboUnitProp = (ComboProp)properties.get((Object)fieldKey);
                    String value = comboUnitProp.getItemByName(valueStr);
                    valLabel.setText(value);
                } else {
                    Object value = indObj.get(fieldNumber);
                    if (value instanceof Date) {
                        String dateFormate = dateFormat.format(value);
                        valLabel.setText(dateFormate);
                        if (dateFormate == null || HRStringUtils.equals((String)dateFormate, (String)"")) {
                            valLabel.setText("-");
                        }
                    } else if (value instanceof BigDecimal) {
                        if (numAccuracy != null) {
                            int numaccuracy = Integer.parseInt(numAccuracy);
                            BigDecimal bigDecimalVal = indObj.getBigDecimal(fieldNumber) == null ? BigDecimal.ZERO : indObj.getBigDecimal(fieldNumber);
                            valLabel.setText(bigDecimalVal.setScale(numaccuracy).toPlainString());
                        } else {
                            valLabel.setText("-");
                        }
                    } else {
                        String fieldValue = indObj.getString(fieldKey);
                        if (HRStringUtils.isNotEmpty((String)fieldValue)) {
                            valLabel.setText(fieldValue);
                        } else {
                            valLabel.setText("-");
                        }
                    }
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"indap" + maxSeq});
                ++maxSeq;
            }
        }
        for (int i = maxSeq; i < 41; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"indap" + i});
        }
    }
}

