/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaloverall.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.OperationColumnAp;
import kd.bos.orm.query.QFilter;
import kd.bos.userconfig.GridConfigDAO;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.evaloverall.ActEvalObjOverallApplicationService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.common.enums.FieldTypeEnum;

public class EvaluteOverallDrawEntryUtil {
    private static final List<Map<String, Object>> ENTRY_FIXED_PREFIX_FIELDS_LIST = new ArrayList<Map<String, Object>>(10);
    private static final Map<String, Object> NAME_FIELD = new HashMap<String, Object>(16);
    private static final Map<String, Object> NUMBER_FIELD = new HashMap<String, Object>(16);
    private static final Map<String, Object> ADMINORG_FIELD = new HashMap<String, Object>(16);
    private static final Map<String, Object> POSITION_FIELD = new HashMap<String, Object>(16);
    private static final Map<String, Object> ADMINORG_SORT_FIELD = new HashMap<String, Object>(16);
    private static final Map<String, Object> POSITION_INDEX_FIELD = new HashMap<String, Object>(16);
    private static final Map<String, Object> OPERATE_FIELD = new HashMap<String, Object>(16);
    private static final List<Map<String, Object>> ENTRY_FIXED_SUFFIX_FIELDS_LIST = new ArrayList<Map<String, Object>>(10);
    private static final Map<String, Object> TASKSTATUS_FIELD = new HashMap<String, Object>(16);
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String OPERATION = "operationcolumnap";
    private static final String NODE = "node";
    private static final String ALL_LOCK_STR = "new,edit,view,submit,audit";
    private static final String NORMAL_LOCK_STR = "view,submit,audit";
    private static final String VISIBLE_TRUE_STR = "init,new,edit,view,submit,audit";
    private static final String VISIBLE_FALSE_STR = "";
    private static final int MAX_MULTI_LAN_TEXT_LENGTH = 1000;
    private static final ActEvalObjOverallApplicationService APP_SERVICE = ActEvalObjOverallApplicationService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();

    public static void drawDynamicEntry(LoadCustomControlMetasArgs args, List<Map<String, Object>> empPersonInfoFields, List<Map<String, Object>> entryFields) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        List<Map<String, Object>> taskList = EvaluteOverallDrawEntryUtil.getTaskList(formShowParameter);
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        gridConfigDAO.deleteGridConfig("epa_evaloverall", "entryentity");
        List<Map<String, Object>> mergedEntryFields = Stream.of(empPersonInfoFields, entryFields).flatMap(Collection::stream).collect(Collectors.toList());
        EntryAp entryAp = EvaluteOverallDrawEntryUtil.createEntryAp(args, mergedEntryFields);
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        mapEntry.put("selchexkbox", (String)entryAp.createControl().get("selchexkbox"));
        args.getItems().add(mapEntry);
    }

    private static EntryAp createEntryAp(LoadCustomControlMetasArgs args, List<Map<String, Object>> entryFields) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryentity");
        entryAp.setShowSeq(true);
        entryAp.setShowSelChexkbox(true);
        entryAp.setMulti(true);
        entryAp.setToolbarLocation("1");
        entryAp.setSplitPage(true);
        entryAp.setPageType("1");
        entryAp.setPageRow(20);
        EvaluteOverallDrawEntryUtil.createEntryFieldAp(args, entryAp, entryFields);
        return entryAp;
    }

    private static void createEntryFieldAp(LoadCustomControlMetasArgs args, EntryAp entryAp, List<Map<String, Object>> entryFields) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        List<Map<String, Object>> taskList = EvaluteOverallDrawEntryUtil.getTaskList(formShowParameter);
        List taskIdList = taskList.stream().map(taskinfo -> (Long)taskinfo.get("taskId")).collect(Collectors.toList());
        Long taskId = (Long)taskIdList.get(0);
        for (int i = 0; i < entryFields.size(); ++i) {
            Map<String, Object> fieldInfo = entryFields.get(i);
            String id = (String)fieldInfo.get("id");
            String key = (String)fieldInfo.get("key");
            String name = (String)fieldInfo.get(NAME);
            String operation = (String)fieldInfo.get("operation");
            Boolean visible = (Boolean)fieldInfo.get("visible");
            if (!HRStringUtils.isEmpty((String)operation) && operation.equals(OPERATION)) {
                OperationColumnAp operationColumnAp = new OperationColumnAp();
                operationColumnAp.setId(id);
                operationColumnAp.setKey(key);
                operationColumnAp.setName(new LocaleString(name));
                OperationColItem operationColItem = new OperationColItem();
                operationColItem.setId("detail");
                operationColItem.setOperationKey("detail");
                operationColItem.setOperationName(new LocaleString(VISIBLE_FALSE_STR));
                operationColItem.setShowStyle(1);
                operationColItem.setIcon("kdfont kdfont-chakanxiangqing");
                operationColumnAp.setOperationColItems(Collections.singletonList(operationColItem));
                entryAp.getItems().add(operationColumnAp);
                continue;
            }
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setVisible(visible != false ? VISIBLE_TRUE_STR : VISIBLE_FALSE_STR);
            Boolean editable = (Boolean)fieldInfo.get("lock");
            if (editable.booleanValue()) {
                entryFieldAp.setLock(ALL_LOCK_STR);
            } else {
                entryFieldAp.setLock(NORMAL_LOCK_STR);
            }
            entryFieldAp.setId(id);
            entryFieldAp.setKey(key);
            entryFieldAp.setNoDisplayScaleZero(false);
            entryFieldAp.setName(new LocaleString(name));
            entryFieldAp.setField(EvaluteOverallDrawEntryUtil.createField(fieldInfo));
            entryFieldAp.isFireUpdEvt();
            entryAp.getItems().add(entryFieldAp);
        }
    }

    private static List<Map<String, Object>> getTaskList(FormShowParameter parameter) {
        Object batchTaskIdObj = parameter.getCustomParam("batchTaskId");
        if (batchTaskIdObj != null) {
            Long batchTaskId = Long.parseLong((String)batchTaskIdObj);
            QFilter taskStatusFilter = new QFilter("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
            return FLOW_RU_SECOND_DOMAIN_SERVICE.getBatchTaskDetails(batchTaskId, taskStatusFilter);
        }
        return new ArrayList<Map<String, Object>>(10);
    }

    private static Field createField(Map<String, Object> fieldInfo) {
        String id = (String)fieldInfo.get("id");
        String key = (String)fieldInfo.get("key");
        String name = (String)fieldInfo.get(NAME);
        Boolean mustInput = (Boolean)fieldInfo.get("mustinput");
        Field field = EvaluteOverallDrawEntryUtil.createFieldByPropType(fieldInfo);
        field.setId(id);
        field.setKey(key);
        field.setName(new LocaleString(name));
        field.setMustInput(mustInput.booleanValue());
        return field;
    }

    private static Field createFieldByPropType(Map<String, Object> fieldInfo) {
        String id = (String)fieldInfo.get("id");
        String key = (String)fieldInfo.get("key");
        String name = (String)fieldInfo.get(NAME);
        FieldTypeEnum fieldTypeEnum = (FieldTypeEnum)fieldInfo.get("proptype");
        Boolean mustInput = (Boolean)fieldInfo.get("mustinput");
        boolean max = false;
        boolean min = false;
        switch (fieldTypeEnum) {
            case MuliLangText: {
                MuliLangTextField muliLangTextField = new MuliLangTextField();
                muliLangTextField.setMutiLine(mustInput.booleanValue());
                muliLangTextField.setMaxLength(1000);
                muliLangTextField.setMinLength(0);
                return muliLangTextField;
            }
            case Integer: {
                IntegerField integerField = new IntegerField();
                return integerField;
            }
            case Text: {
                TextField textField = new TextField();
                textField.setMaxLength(1000);
                textField.setMinLength(0);
                return textField;
            }
            case Combo: {
                List<ComboItem> comboItems;
                ComboField comboField = new ComboField();
                if (HRStringUtils.equals((String)key, (String)"ole")) {
                    comboItems = (List<ComboItem>)fieldInfo.get("comboitem");
                    comboField.getItems().addAll(comboItems);
                }
                if (HRStringUtils.equals((String)key, (String)"taskstatus")) {
                    comboItems = EvaluteOverallDrawEntryUtil.getTaskStatusComboList();
                    comboField.getItems().addAll(comboItems);
                }
                return comboField;
            }
            case Date: {
                return new DateField();
            }
            case Boolean: {
                return new CheckBoxField();
            }
            case Decimal: {
                DecimalField decimalField = new DecimalField();
                int numAccuracy = (Integer)fieldInfo.get("scale");
                decimalField.setPrecision(numAccuracy + 13);
                decimalField.setScale(numAccuracy);
                decimalField.setZeroShow(true);
                return decimalField;
            }
            case TextAreaProp: {
                TextAreaField textAreaField = new TextAreaField();
                textAreaField.setMaxLength(1000);
                textAreaField.setMinLength(0);
                return textAreaField;
            }
            case MuliLangGlTextProp: {
                MuliLangTextField mumuliLangTextField = new MuliLangTextField();
                mumuliLangTextField.setMutiLine(true);
                mumuliLangTextField.setMaxLength(1000);
                mumuliLangTextField.setMinLength(0);
                return mumuliLangTextField;
            }
            case LargeTextProp: {
                MuliLangTextField lamuliLangTextField = new MuliLangTextField();
                lamuliLangTextField.setMutiLine(true);
                lamuliLangTextField.setMaxLength(1000);
                lamuliLangTextField.setMinLength(0);
                return lamuliLangTextField;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u5b57\u6bb5\u7c7b\u578b!", (String)"EvaluteOverallDrawEntryUtil_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    public static List<Map<String, Object>> assembleToListFields(List<Map<String, Object>> evalObjNodeFieldsList, List<Map<String, Object>> sumConfFieldsList) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>(10);
        fields.addAll(ENTRY_FIXED_PREFIX_FIELDS_LIST);
        fields.addAll(evalObjNodeFieldsList);
        fields.add(OPERATE_FIELD);
        fields.addAll(sumConfFieldsList);
        fields.addAll(ENTRY_FIXED_SUFFIX_FIELDS_LIST);
        return fields;
    }

    private static List<ComboItem> getTaskStatusComboList() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        ComboItem comboItem0 = new ComboItem();
        comboItem0.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f85\u8bc4\u4f30", (String)"EvaluteOverallDrawEntryUtil_3", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        comboItem0.setValue(FlowRuTaskStatusEnum.WAITING.getCode());
        comboItems.add(comboItem0);
        ComboItem comboItem1 = new ComboItem();
        comboItem1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8bc4\u4f30\u4e2d", (String)"EvaluteOverallDrawEntryUtil_4", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        comboItem1.setValue(FlowRuTaskStatusEnum.PROCESSING.getCode());
        comboItems.add(comboItem1);
        ComboItem comboItem2 = new ComboItem();
        comboItem2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5df2\u8bc4\u4f30", (String)"EvaluteOverallDrawEntryUtil_5", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        comboItem2.setValue(FlowRuTaskStatusEnum.PROCESSED.getCode());
        comboItems.add(comboItem2);
        ComboItem comboItem3 = new ComboItem();
        comboItem3.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5df2\u9000\u56de", (String)"EvaluteOverallDrawEntryUtil_6", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        comboItem3.setValue(FlowRuTaskStatusEnum.RETURNED.getCode());
        comboItems.add(comboItem3);
        return comboItems;
    }

    static {
        OPERATE_FIELD.put("id", OPERATION);
        OPERATE_FIELD.put(NAME, ResManager.loadKDString((String)"\u8be6\u60c5\u6a21\u5f0f", (String)"EvaluteOverallDrawEntryUtil_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        OPERATE_FIELD.put("key", OPERATION);
        OPERATE_FIELD.put("operation", OPERATION);
        TASKSTATUS_FIELD.put("id", "taskstatus");
        TASKSTATUS_FIELD.put(NAME, ResManager.loadKDString((String)"\u72b6\u6001", (String)"EvaluteOverallDrawEntryUtil_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        TASKSTATUS_FIELD.put("key", "taskstatus");
        TASKSTATUS_FIELD.put("proptype", FieldTypeEnum.Combo);
        TASKSTATUS_FIELD.put("mustinput", Boolean.FALSE);
        TASKSTATUS_FIELD.put("visible", Boolean.TRUE);
        TASKSTATUS_FIELD.put("lock", Boolean.TRUE);
        ENTRY_FIXED_SUFFIX_FIELDS_LIST.add(TASKSTATUS_FIELD);
    }
}

