/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.assessrule.entityservice.EmpInfoConfigEntityService;
import kd.opmc.epa.business.domain.evaluating.entity.ContentAreaEntryEvaDto;
import kd.opmc.epa.business.domain.evaluating.entity.EvalSubmitShowInfoDto;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessStatusEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.common.enums.evaloverall.ProcPermAnonymityEnum;
import kd.opmc.epa.formplugin.web.utils.IndicatorDetailUtils;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuRoleBo;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;

public class ActEvalObjDetailEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(ActEvalObjDetailEdit.class);
    public static final long MAX_WAIT_MILLIS = 120000L;
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private final AssessActivityApplicationService ACTIVITY_SERVICE = AssessActivityApplicationService.getInstance();
    private static final EmpInfoConfigEntityService EMP_INFO_CONFIG_ENTITY_SERVICE = EmpInfoConfigEntityService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUN_SUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    protected static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();
    private static final String[] OPEN_LAB = new String[]{"openvector", "openlab"};
    private static final String[] CLOSE_LAB = new String[]{"closevector", "closelab"};
    private static final String ATTACHMENT_AP = "attachmentap";
    private static final String PROCESS_AP = "processap";
    public static final String NOT_REFRESH_FROM_SUBMIT = "NOT_REFRESH_FROM_SUBMIT";
    private static final long MAX_WAIT_SENCONDS = 10000L;
    private static final int EVERY_WAIT_SENCONDS = 200;
    private static final int MAX_ROLE_COUNT = Integer.MAX_VALUE;
    private static final String SUM_AREA_CLICKED = "1";
    private static final String COMMON_AREA_CLICKED = "2";
    private static final String ANONYMOUS_STR = "***";
    private static final String ISFORBIDDEN = "isforbidden";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(OPEN_LAB);
        this.addClickListeners(CLOSE_LAB);
        this.addClickListeners(new String[]{"validateinfoap", "validateinfovector"});
        this.addClickListeners(new String[]{ATTACHMENT_AP});
        this.addClickListeners(new String[]{PROCESS_AP});
        this.addClickListeners(new String[]{"openrightvectorap", "openrightvector", "closerightvectorap", "closerightvector"});
        this.addClickListeners(new String[]{"sumarearecordaction"});
        this.addClickListeners(new String[]{"viewdetail"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "openvector": 
            case "openlab": {
                this.openSumAreaRecord();
                break;
            }
            case "closevector": 
            case "closelab": {
                this.closeSumAreaRecord();
                break;
            }
            case "validateinfoap": 
            case "validateinfovector": {
                this.showValidateView();
                break;
            }
            case "attachmentap": {
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setFormId("epa_attachment_add");
                billShowParameter.setPkId(this.getModel().getValue("id"));
                billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                billShowParameter.setStatus(status);
                StyleCss inlineStyleCss = new StyleCss();
                inlineStyleCss.setHeight("600");
                inlineStyleCss.setWidth("800");
                billShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
                billShowParameter.setHasRight(true);
                this.getView().showForm((FormShowParameter)billShowParameter);
                break;
            }
            case "processap": {
                FormShowParameter formShowParameter = new FormShowParameter();
                Long evalflowinsId = this.getModel().getDataEntity().getLong("evalflowins.id");
                Long taskId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("taskId"));
                DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
                if (taskObj == null) {
                    IFormView parentView = this.getView().getParentView();
                    parentView.showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ActEvalObjDetailEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    parentView.updateView();
                    this.getView().sendFormAction(parentView);
                    return;
                }
                String taskStatus = taskObj.getString("taskstatus");
                if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(taskStatus)) {
                    IFormView parentView = this.getView().getParentView();
                    parentView.showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ActEvalObjDetailEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    parentView.updateView();
                    this.getView().sendFormAction(parentView);
                    return;
                }
                formShowParameter.setCustomParam("taskId", (Object)taskId);
                formShowParameter.setCustomParam("evalflowinsId", (Object)evalflowinsId);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setFormId("epa_workflow_proc");
                StyleCss styleCss = new StyleCss();
                styleCss.setWidth("600");
                styleCss.setHeight("600");
                formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
                formShowParameter.setHasRight(true);
                this.getView().showForm(formShowParameter);
                break;
            }
            case "openrightvectorap": 
            case "openrightvector": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"actevaldetial"});
                this.showCloseVector();
                this.getPageCache().put("isCloseRight", "false");
                break;
            }
            case "closerightvectorap": 
            case "closerightvector": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"actevaldetial"});
                this.showOpentVector();
                this.getPageCache().put("isCloseRight", "true");
                break;
            }
            case "sumarearecordaction": {
                if (this.isCrossEval()) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{"otherevalap"});
                String isCloseRight = this.getPageCache().get("isCloseRight");
                if (!HRStringUtils.equals((String)isCloseRight, (String)"true")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"actevaldetial"});
                    this.showCloseVector();
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"indicatorpanelap"});
                this.setDetailField(SUM_AREA_CLICKED);
                break;
            }
            case "viewdetail": {
                this.showViewdetail();
                break;
            }
        }
    }

    private void showViewdetail() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epa_actevalobj_viewdetail");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("areaMarker", (Object)COMMON_AREA_CLICKED);
        formShowParameter.setHasRight(true);
        this.getView().showForm(formShowParameter);
    }

    private void openSumAreaRecord() {
        this.getView().setVisible(Boolean.FALSE, OPEN_LAB);
        this.getView().setVisible(Boolean.TRUE, CLOSE_LAB);
        this.getView().setVisible(Boolean.TRUE, new String[]{"sumarearecordap"});
    }

    private void closeSumAreaRecord() {
        this.getView().setVisible(Boolean.FALSE, CLOSE_LAB);
        this.getView().setVisible(Boolean.TRUE, OPEN_LAB);
        this.getView().setVisible(Boolean.FALSE, new String[]{"sumarearecordap"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter parameter = e.getFormShowParameter();
        Long taskId = Long.valueOf((String)parameter.getCustomParam("taskId"));
        parameter.setHasRight(true);
        parameter.setStatus(APP_SERVICE.getViewStatusOfTask(taskId));
        APP_SERVICE.processTask(taskId);
    }

    public void afterBindData(EventObject e) {
        IFormView parentView;
        super.afterBindData(e);
        Long activityId = this.getModel().getDataEntity().getLong("activity.id");
        DynamicObject activityObj = APP_SERVICE.queryActivityById(activityId);
        Long assessFormId = activityObj.getLong("assessform.id");
        DynamicObject assessform = APP_SERVICE.queryExecuteAssessForm(assessFormId.longValue());
        this.setActivityInfo(assessform);
        this.setAttchmentCount();
        this.setPersonInfo();
        this.setAssessStatus();
        this.showEvaluationView(assessform);
        this.closeSumAreaRecord();
        this.getView().setVisible(Boolean.FALSE, new String[]{"validateinfoap", "emptyap"});
        this.hidePanelap();
        this.showOpentVector();
        this.getView().setVisible(Boolean.FALSE, new String[]{"openrightvectorap"});
        if (this.isCrossEval()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"oselabelap", "sumareainfoap"});
        }
        if ((parentView = this.getView().getParentView()) != null) {
            String entityId = parentView.getEntityId();
            if ("epa_actevalobj_evalmsg".equals(entityId)) {
                parentView.getPageCache().put("epa_actevalobj_eval_page_id", this.getView().getPageId());
            } else {
                IFormView grandView = parentView.getParentView();
                if (grandView != null && "epa_actevalobj_evalmsg".equals(grandView.getEntityId())) {
                    grandView.getPageCache().put("epa_actevalobj_eval_page_id", this.getView().getPageId());
                }
            }
        }
        this.setActEvalObjUserIdCache();
        this.cacheCurrentPageCrossInds();
    }

    private void setActEvalObjUserIdCache() {
        Object userId;
        Collection<Long> values;
        Long actEvalObjId = this.getModel().getDataEntity().getLong("person.id");
        Map<Long, Long> userIdsByPersonIds = this.getUserIdsByPersonIds(Collections.singletonList(actEvalObjId));
        if (userIdsByPersonIds != null && (values = userIdsByPersonIds.values()).size() > 0 && (userId = userIdsByPersonIds.values().toArray()[0]) != null) {
            this.getView().getPageCache().put("actEvalObjUserId", userId.toString());
        }
    }

    private Map<Long, Long> getUserIdsByPersonIds(List<Long> personIds) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(16);
        HashMap<String, List<Long>> personIdMap = new HashMap<String, List<Long>>(16);
        personIdMap.put("person", personIds);
        Map userIdByPersonInfo = new HashMap(16);
        try {
            userIdByPersonInfo = PERSON_SERVICE.getUserIdByPersonInfo(personIdMap);
        }
        catch (Exception e) {
            LOG.error("\u3010OPMC\u3011-getUserIdsByPersonIds error,personIds:{}", personIds);
            LOG.error((Throwable)e);
        }
        if (userIdByPersonInfo.isEmpty()) {
            return retMap;
        }
        Boolean success = (Boolean)userIdByPersonInfo.get("success");
        if (success.booleanValue()) {
            Map userInfo = (Map)userIdByPersonInfo.get("data");
            ArrayList<Long> userIds = new ArrayList<Long>(personIds.size());
            for (Long personId : personIds) {
                Map user = (Map)userInfo.get(personId);
                if (user == null) continue;
                Long userId = (Long)user.get("user");
                userIds.add(userId);
            }
            Map<Long, Boolean> userIsEnableMap = this.batchQueryUserIsEnable(userIds);
            for (Long personId : personIds) {
                Long userId;
                Map user = (Map)userInfo.get(personId);
                if (user == null || !userIsEnableMap.getOrDefault(userId = (Long)user.get("user"), false).booleanValue()) continue;
                retMap.put(personId, userId);
            }
        }
        return retMap;
    }

    public Map<Long, Boolean> batchQueryUserIsEnable(List<Long> userIds) {
        List userInfo = UserServiceHelper.get(userIds, (String[])new String[]{"id", ISFORBIDDEN, "enable"}, null);
        HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>(16);
        if (CollectionUtils.isEmpty((Collection)userInfo)) {
            return ret;
        }
        for (Map user : userInfo) {
            ret.put((Long)user.get("id"), (Boolean)user.get(ISFORBIDDEN) == false && SUM_AREA_CLICKED.equals(user.get("enable")));
        }
        return ret;
    }

    private void setAttchmentCount() {
        Long actEvalObjId = (Long)this.getModel().getDataEntity().getPkValue();
        int attchmentCount = APP_SERVICE.queryAttachmentCount(actEvalObjId);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(ATTACHMENT_AP, "text", (Object)ResManager.loadKDString((String)"\u9644\u4ef6 ({0})", (String)"ActEvalObjDetailEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{attchmentCount}));
    }

    private void hidePanelap() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"actevaldetial"});
    }

    private void showOpentVector() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"openrightvectorap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"closerightvectorap"});
    }

    private void showCloseVector() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"openrightvectorap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"closerightvectorap"});
    }

    private void setPersonInfo() {
        DynamicObject evalObj = this.getView().getModel().getDataEntity();
        Image headSculpture = (Image)this.getView().getControl("headsculpture");
        headSculpture.setUrl(HRImageUrlUtil.getImageFullUrl((String)evalObj.getString("person.headsculpture")));
        this.setLabelText("name", evalObj.getString("perffile.name"));
        this.setLabelText("number", evalObj.getString("perffile.billno"));
        String adminorgName = evalObj.getString("perffile.adminorg.name");
        if (adminorgName != null) {
            this.setLabelText("adminorg", adminorgName);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"adminorg", "adminorgline"});
        }
        String positonName = evalObj.getString("perffile.position.name");
        if (positonName != null) {
            this.setLabelText("position", positonName);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"position", "positionline"});
        }
    }

    private void setAssessStatus() {
        String taskstatus;
        Long taskId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("taskId"));
        DynamicObject taskInfo = APP_SERVICE.queryTaskInfo(taskId);
        switch (taskstatus = taskInfo.getString("taskstatus")) {
            case "20": {
                this.setLabelText("assessstatus", ResManager.loadKDString((String)"\u5f85\u8bc4\u4f30", (String)"ActEvalObjDetailEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.setAssessStatusStyles(AssessStatusEnum.ASSESS_WAITING.getForeColor(), AssessStatusEnum.ASSESS_WAITING.getBgColor(), AssessStatusEnum.ASSESS_WAITING.getBorderColor());
                break;
            }
            case "30": {
                this.setLabelText("assessstatus", ResManager.loadKDString((String)"\u8bc4\u4f30\u4e2d", (String)"ActEvalObjDetailEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.setAssessStatusStyles(AssessStatusEnum.ASSESSING.getForeColor(), AssessStatusEnum.ASSESSING.getBgColor(), AssessStatusEnum.ASSESSING.getBorderColor());
                break;
            }
            case "40": {
                this.setLabelText("assessstatus", ResManager.loadKDString((String)"\u5df2\u8bc4\u4f30", (String)"ActEvalObjDetailEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.setAssessStatusStyles(AssessStatusEnum.ASSESSED.getForeColor(), AssessStatusEnum.ASSESSED.getBgColor(), AssessStatusEnum.ASSESSED.getBorderColor());
                break;
            }
            case "60": {
                this.setLabelText("assessstatus", ResManager.loadKDString((String)"\u5df2\u5931\u6548", (String)"ActEvalObjDetailEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.setAssessStatusStyles(AssessStatusEnum.EXPIRED.getForeColor(), AssessStatusEnum.EXPIRED.getBgColor(), AssessStatusEnum.EXPIRED.getBorderColor());
                break;
            }
            case "80": {
                this.setLabelText("assessstatus", ResManager.loadKDString((String)"\u5df2\u9000\u56de", (String)"ActEvalObjDetailEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.setAssessStatusStyles(AssessStatusEnum.RETURNED.getForeColor(), AssessStatusEnum.RETURNED.getBgColor(), AssessStatusEnum.RETURNED.getBorderColor());
                break;
            }
            case "90": {
                this.setLabelText("assessstatus", ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ActEvalObjDetailEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.setAssessStatusStyles(AssessStatusEnum.PENDING.getForeColor(), AssessStatusEnum.PENDING.getBgColor(), AssessStatusEnum.PENDING.getBorderColor());
                break;
            }
        }
    }

    private void setAssessStatusStyles(String foreColor, String bgColor, String borderColor) {
        HashMap<String, String> foreColorMap = new HashMap<String, String>(16);
        foreColorMap.put("fc", foreColor);
        this.getView().updateControlMetadata("assessstatus", foreColorMap);
        HashMap<String, String> bgColorMap = new HashMap<String, String>(16);
        bgColorMap.put("bc", bgColor);
        this.getView().updateControlMetadata("assessstatusap", bgColorMap);
        HashMap<String, String> borderMap = new HashMap<String, String>(16);
        borderMap.put("r", "1px_solid_" + borderColor);
        borderMap.put("l", "1px_solid_" + borderColor);
        borderMap.put("t", "1px_solid_" + borderColor);
        borderMap.put("b", "1px_solid_" + borderColor);
        HashMap<String, HashMap<String, String>> statusapMap = new HashMap<String, HashMap<String, String>>(16);
        statusapMap.put("b", borderMap);
        HashMap<String, HashMap<String, HashMap<String, String>>> styleMap = new HashMap<String, HashMap<String, HashMap<String, String>>>(16);
        styleMap.put("s", statusapMap);
        this.getView().updateControlMetadata("assessstatusap", styleMap);
    }

    private void showEvaluationView(DynamicObject assessform) {
        Long taskId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("taskId"));
        DynamicObject taskInfo = APP_SERVICE.queryTaskInfo(taskId);
        this.showSumAreaView(taskInfo, assessform, null);
        this.showAreaEvaluationView(assessform, taskId, taskInfo);
        this.setSumperflevelCache(assessform);
        this.setAllowexceedCache(assessform);
        this.showPersonInfoTips(assessform);
        this.hideAllowexceed();
    }

    private void setAllowexceedCache(DynamicObject assessformDy) {
        boolean allowexceedupper = assessformDy.getBoolean("allowexceedupper");
        this.getPageCache().put("allowexceedupper", String.valueOf(allowexceedupper));
        BigDecimal limitmaxscore = assessformDy.getBigDecimal("limitmaxscore");
        this.getPageCache().put("limitmaxscore", limitmaxscore.toPlainString());
        boolean allowexceedlower = assessformDy.getBoolean("allowexceedlower");
        this.getPageCache().put("allowexceedlower", String.valueOf(allowexceedlower));
        BigDecimal limitminscore = assessformDy.getBigDecimal("limitminscore");
        this.getPageCache().put("limitminscore", limitminscore.toPlainString());
    }

    private void setSumperflevelCache(DynamicObject assessformDy) {
        if (assessformDy.getString("sumperflevel.id") == null) {
            this.getPageCache().put("sumperflevel", "false");
        } else {
            this.getPageCache().put("sumperflevel", "true");
        }
    }

    private void showPersonInfoTips(DynamicObject assessformDy) {
        DynamicObject empInfoConfDy = EMP_INFO_CONFIG_ENTITY_SERVICE.queryOne((Object)assessformDy.getLong("empinfoconf"));
        DynamicObjectCollection empInfoConfEntry = empInfoConfDy.getDynamicObjectCollection("entryentity");
        List<String> blackList = Arrays.asList("headsculpture", "name", "number");
        Boolean isShowPersonInfoTips = false;
        for (DynamicObject empInfo : empInfoConfEntry) {
            String fieldKey;
            DynamicObject field = empInfo.getDynamicObject("areafield");
            if (field == null || blackList.contains(fieldKey = field.getString("number")) || !empInfo.getBoolean("isshow")) continue;
            isShowPersonInfoTips = true;
            break;
        }
        if (isShowPersonInfoTips.booleanValue()) {
            Tips tips = new Tips();
            tips.setTitle(null);
            tips.setTriggerType("hover");
            tips.setShowIcon(Boolean.FALSE.booleanValue());
            tips.setPlace("bottom");
            tips.setBillno("epa_personinfo");
            tips.setType("bill");
            Label nameLab = (Label)this.getControl("name");
            nameLab.addTips(tips);
        }
    }

    private void hideAllowexceed() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"allowexceedap"});
    }

    private void showEvaluationView() {
        DynamicObject executeScheme = APP_SERVICE.queryExecuteScheme(this.getModel().getDataEntity().getLong("activity.executescheme.id"));
        this.showEvaluationView(executeScheme);
    }

    private void setActivityInfo(DynamicObject assessform) {
        DynamicObject activityDy = this.getModel().getDataEntity().getDynamicObject("activity");
        this.setLabelText("activitynamelab", activityDy.getString("name"));
        this.setLabelText("periodlab", activityDy.getString("period"));
        Long activityId = this.getModel().getDataEntity().getLong("activity.id");
        Long executeSchemeId = APP_SERVICE.queryExecuteSchemeByActivityID(activityId);
        DynamicObject executeScheme = APP_SERVICE.queryExecuteScheme(executeSchemeId.longValue());
        this.setLabelText("assessscopelab", executeScheme.getString("assessscope.name"));
        this.setLabelText("scoresystemlab", assessform.getString("scoresystem.name"));
    }

    public Map<Long, List<Long>> getTaskIndsOfMerge(List<Long> taskIds) {
        Map<Long, List<Long>> map = new HashMap<Long, List<Long>>(16);
        if (taskIds != null && !taskIds.isEmpty()) {
            map = APP_SERVICE.queryTaskIndicators(taskIds);
        }
        return map;
    }

    public Set<Long> getAllTaskIdIncludeMerge() {
        List mergeTaskIds;
        String mergeTaskIdsStr;
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        HashSet<Long> taskIds = new HashSet<Long>(16);
        if (!HRStringUtils.isBlank((CharSequence)taskId)) {
            taskIds.add(Long.parseLong(taskId));
        }
        if (HRStringUtils.isNotEmpty((String)(mergeTaskIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskIds"))) && (mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class)) != null) {
            taskIds.addAll(mergeTaskIds);
        }
        return taskIds;
    }

    public void cacheCurrentPageCrossInds() {
        if (this.isCrossEval()) {
            Map<String, Integer> taskIndCountMap;
            Set<Long> taskIds = this.getAllTaskIdIncludeMerge();
            ArrayList<Long> taskIdList = new ArrayList<Long>(10);
            taskIdList.addAll(taskIds);
            Map<Long, List<Long>> indsMap = this.getTaskIndsOfMerge(taskIdList);
            if (indsMap != null && !(taskIndCountMap = this.change2TaskIndCountMap(indsMap)).isEmpty()) {
                this.getPageCache().put("CURRENT_PAGE_MERGE_INDS", JSON.toJSONString(taskIndCountMap));
                this.getView().getParentView().getPageCache().put("CURRENT_PAGE_MERGE_INDS", JSON.toJSONString(taskIndCountMap));
            }
        }
    }

    public Map<String, Integer> change2TaskIndCountMap(Map<Long, List<Long>> indsMap) {
        HashMap<String, Integer> taskIndCountMap = new HashMap<String, Integer>(16);
        if (indsMap != null) {
            for (Map.Entry<Long, List<Long>> entry : indsMap.entrySet()) {
                if (entry == null) continue;
                Long taskIdTmp = entry.getKey();
                List<Long> indList = entry.getValue();
                if (taskIdTmp == null || indList == null || indList.isEmpty()) continue;
                for (Long indicatorId : indList) {
                    Integer count;
                    if (indicatorId == null) continue;
                    String key = taskIdTmp + "#" + indicatorId;
                    Integer n = count = taskIndCountMap.get(key) == null ? Integer.valueOf(0) : (Integer)taskIndCountMap.get(key);
                    Integer n2 = count = Integer.valueOf(count + 1);
                    taskIndCountMap.put(key, count);
                }
            }
        }
        return taskIndCountMap;
    }

    public boolean isCrossEval() {
        Boolean isCrossEvaluate = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCrossEvaluate");
        return isCrossEvaluate != null && isCrossEvaluate != false;
    }

    private void showAreaEvaluationView(DynamicObject assessformDy, Long taskId, DynamicObject taskInfo) {
        List areaList = assessformDy.getDynamicObjectCollection("areaconfentry").stream().sorted(Comparator.comparing(obj -> obj.getInt("seq"))).collect(Collectors.toList());
        DynamicObjectCollection areaEntry = this.getModel().getEntryEntity("areaentry");
        HashMap<Long, DynamicObject> areaEntryMap = new HashMap<Long, DynamicObject>(16);
        if (areaEntry != null) {
            for (DynamicObject entry : areaEntry) {
                if (entry == null) continue;
                long areaConfId = entry.getLong("areaconf");
                areaEntryMap.put(areaConfId, entry);
            }
        }
        Map evalRecordMap = APP_SERVICE.queryAreaEvalRecord(taskId);
        FlexPanelAp assTableFlex = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("asstableap").setDirection("column").setAlignItems("stretch").setJustifyContent("flex-start").setMarginLeft("10px")).setMarginLeft("10px")).setWrap(false).setGrow(1).setShrink(0).build();
        ArrayList<String> subEvalRecordPageList = new ArrayList<String>(10);
        ArrayList<String> subEvalGenAndSubPageList = new ArrayList<String>(10);
        DynamicObject ruNodeDy = APP_SERVICE.queryFlowDefNodeIdByruNodeId(Long.valueOf(taskInfo.getLong("flowrunode.id")));
        long flowNodeDefId = 0L;
        if (ruNodeDy != null) {
            flowNodeDefId = ruNodeDy.getLong("flownodedef.id");
        }
        List<ContentAreaEntryEvaDto> processPermSetting = this.getProcessPermSetting(flowNodeDefId);
        Long processPermSettingId = this.getProcessPermSettingId();
        Map permScopeMap = APP_SERVICE.queryProcessPermSettingScopeNew(processPermSettingId, Long.valueOf(flowNodeDefId));
        Map<Long, ContentAreaEntryEvaDto> areaEntryEvaDtoMap = this.convert2MapByAreaConf(processPermSetting);
        if (permScopeMap != null) {
            String display = (String)permScopeMap.get("weight");
            this.getView().getPageCache().put("areaWeigthDisplay", display);
        }
        for (int i = 0; i < areaList.size(); ++i) {
            String assTableItem = "asstableap" + i;
            DynamicObject areaDy = (DynamicObject)areaList.get(i);
            Long arearegId = areaDy.getLong("areareg.id");
            long areaConfIdForm = areaDy.getLong("areaconf");
            if (!AssessRuleConstants.CUSTOM_AREA_PK.equals(arearegId)) {
                DynamicObject confObj;
                boolean iscrossscore;
                DynamicObject areaInsDy = (DynamicObject)areaEntryMap.get(areaConfIdForm);
                Long insId = areaInsDy.getLong("areains");
                Long areaConfId = areaInsDy.getLong("areaconf");
                Boolean isCrossEvaluate = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCrossEvaluate");
                Map areaRegIndicaMap = new HashMap();
                String mergeTaskIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskIds");
                String mergeTaskIndsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskInds");
                if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && HRStringUtils.isNotEmpty((String)mergeTaskIndsStr)) {
                    List mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
                    Map mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class);
                    if (mergeTaskInds.size() > 1) {
                        ArrayList areaIndList = new ArrayList(10);
                        for (int j = 0; j < mergeTaskIds.size(); ++j) {
                            Long taskItemId = (Long)mergeTaskIds.get(j);
                            Map areaRegIndicaItemMap = (Map)mergeTaskInds.get(taskItemId);
                            if (!areaRegIndicaItemMap.containsKey(insId)) continue;
                            List areaIndItemList = (List)areaRegIndicaItemMap.get(insId);
                            areaIndList.addAll(areaIndItemList);
                        }
                        areaRegIndicaMap.put(insId, areaIndList);
                    } else {
                        areaRegIndicaMap = (Map)mergeTaskInds.get(taskId);
                    }
                }
                if (AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(arearegId) && this.isCrossEval() && !(iscrossscore = (confObj = this.ACTIVITY_SERVICE.queryPlusMinusConfigByPk(areaConfId)).getBoolean("iscrossscore"))) continue;
                boolean existIndicatorEntry = APP_SERVICE.queryObjIndicatorAreaEntry(arearegId, insId, isCrossEvaluate, areaRegIndicaMap);
                boolean showArea = this.isShowArea(areaEntryEvaDtoMap, areaConfId);
                if (!existIndicatorEntry || !showArea) continue;
                ContentAreaEntryEvaDto areaEntryEvaDto = areaEntryEvaDtoMap.get(areaConfId);
                this.showCommonAreaView(assTableItem, areaInsDy, assessformDy, assTableFlex, taskInfo, evalRecordMap, subEvalRecordPageList, areaEntryEvaDto, subEvalGenAndSubPageList, permScopeMap);
                continue;
            }
            boolean showArea = this.isShowArea(areaEntryEvaDtoMap, areaConfIdForm);
            if (!showArea || this.isCrossEval()) continue;
            this.showCustomAreaView(assTableItem, assessformDy, areaConfIdForm, assTableFlex, taskInfo, subEvalRecordPageList);
        }
        this.getView().getPageCache().put("subEvalRecordPageList", SerializationUtils.toJsonString(subEvalRecordPageList));
        this.getView().getPageCache().put("subEvalGenAndSubPageList", SerializationUtils.toJsonString(subEvalGenAndSubPageList));
        this.getView().updateControlMetadata(assTableFlex.getKey(), assTableFlex.createControl());
    }

    private boolean isShowArea(Map<Long, ContentAreaEntryEvaDto> areaEntryEvaDtoMap, Long areaConfId) {
        Boolean areaDisplayItem;
        boolean isShowArea = false;
        ContentAreaEntryEvaDto areaEntryEvaDto = areaEntryEvaDtoMap.get(areaConfId);
        if (areaEntryEvaDto != null && (areaDisplayItem = areaEntryEvaDto.getAreaDisplayItem()) != null) {
            isShowArea = areaDisplayItem;
        }
        return isShowArea;
    }

    private Map<Long, ContentAreaEntryEvaDto> convert2MapByAreaConf(List<ContentAreaEntryEvaDto> contentAreaEntryEvaDtos) {
        HashMap<Long, ContentAreaEntryEvaDto> returnMap = new HashMap<Long, ContentAreaEntryEvaDto>(16);
        if (contentAreaEntryEvaDtos != null) {
            for (ContentAreaEntryEvaDto areaEntryEvaDto : contentAreaEntryEvaDtos) {
                if (areaEntryEvaDto == null) continue;
                Long areaPageInsId = areaEntryEvaDto.getAreaPageInsId();
                returnMap.put(areaPageInsId, areaEntryEvaDto);
            }
        }
        return returnMap;
    }

    private List<ContentAreaEntryEvaDto> getProcessPermSetting(long flowNodeDefId) {
        Long processPermSetting = this.getProcessPermSettingId();
        List contentAreaEntryEvaDtoList = APP_SERVICE.queryProcessPermSettingByKeyFieldNew(processPermSetting, Long.valueOf(flowNodeDefId));
        return contentAreaEntryEvaDtoList;
    }

    private Long getProcessPermSettingId() {
        DynamicObject activityDy = this.getModel().getDataEntity().getDynamicObject("activity");
        Long processpermsetting = 0L;
        if (activityDy != null) {
            processpermsetting = (Long)activityDy.get("dynamicpermission.id");
        }
        return processpermsetting;
    }

    private void showCommonAreaView(String assTableItem, DynamicObject areaInsDy, DynamicObject assessformDy, FlexPanelAp assTableFlex, DynamicObject taskInfo, Map<String, Object> evalRecordMap, List<String> subEvalRecordPageList, ContentAreaEntryEvaDto areaEntryEvaDto, List<String> subEvalGenAndSubPageList, Map<String, Object> permScopeMap) {
        FlexPanelAp tableItemAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(assTableItem).setMarginBottom("10px")).setGrow(0).setShrink(0).setBackColor("#ffffff").build();
        assTableFlex.getItems().add(tableItemAp);
        Long confId = areaInsDy.getLong("areaconf");
        long areaInstanceId = areaInsDy.getLong("areains");
        DynamicObject areaReg = areaInsDy.getDynamicObject("areareg");
        Long areaRegId = areaReg.getLong("id");
        Long taskId = (Long)taskInfo.getPkValue();
        Object areaRecordId = evalRecordMap.get(taskId + "" + areaInstanceId);
        AreaRegEnum areaRegEnum = AreaRegEnum.get((Long)areaRegId);
        String formId = areaRegEnum.getEvalObjAreaPageIdOfEval();
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (areaRecordId == null) {
            status = status == OperationStatus.EDIT || status == OperationStatus.ADDNEW ? OperationStatus.ADDNEW : OperationStatus.VIEW;
        } else {
            showParameter.setPkId(areaRecordId);
        }
        Boolean isCrossEvaluate = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCrossEvaluate");
        String mergeTaskIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskIds");
        String mergeTaskIndsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskInds");
        if (areaEntryEvaDto != null) {
            showParameter.setCustomParam("fieldPermSettingJsonStr", (Object)JSON.toJSONString((Object)areaEntryEvaDto.getContentfieldentry()));
        }
        String weightDisplay = "";
        if (permScopeMap != null) {
            weightDisplay = (String)permScopeMap.get("weight");
        }
        showParameter.setCustomParam("weightDisplay", (Object)weightDisplay);
        showParameter.setCustomParam("isCrossEvaluate", (Object)isCrossEvaluate);
        showParameter.setCustomParam("mergeTaskIds", (Object)mergeTaskIdsStr);
        showParameter.setCustomParam("mergeTaskInds", (Object)mergeTaskIndsStr);
        showParameter.setCustomParam("preRoleIsCrossNode", (Object)this.getView().getPageCache().get("preRoleIsCrossNode"));
        showParameter.setStatus(status);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(assTableItem);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        showParameter.setCustomParam("confid", (Object)confId);
        this.setAssessFormParamInfo(assessformDy, showParameter);
        showParameter.setCustomParam("area", (Object)areaInstanceId);
        this.setAreaEvalRecordInitField(taskInfo, showParameter);
        subEvalRecordPageList.add(showParameter.getPageId());
        if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId) || AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaRegId)) {
            subEvalGenAndSubPageList.add(showParameter.getPageId());
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showCustomAreaView(String assTableItem, DynamicObject assessformDy, Long confId, FlexPanelAp assTableFlex, DynamicObject taskInfo, List<String> subEvalRecordPageList) {
        List customAreaList = assessformDy.getDynamicObjectCollection("areaconfentry").stream().filter(obj -> obj.getLong("areaconf") == confId.longValue()).collect(Collectors.toList());
        if (!customAreaList.isEmpty()) {
            DynamicObject customArea = (DynamicObject)customAreaList.get(0);
            FlexPanelAp tableItemAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(assTableItem).setMarginBottom("10px")).setShrink(0).setBackColor("#ffffff").build();
            assTableFlex.getItems().add(tableItemAp);
            DynamicObject areaReg = customArea.getDynamicObject("areareg");
            Long areaRegId = areaReg.getLong("id");
            Long taskId = (Long)taskInfo.getPkValue();
            DynamicObject customAreaIns = APP_SERVICE.queryCustomAreaEvalRecordByConfId(taskId, confId);
            Long areaRecordId = null;
            boolean isCanEdit = true;
            if (customAreaIns != null) {
                areaRecordId = (Long)customAreaIns.getPkValue();
                isCanEdit = customAreaIns.getBoolean("iscanedit");
            }
            AreaRegEnum areaRegEnum = AreaRegEnum.get((Long)areaRegId);
            String formId = areaRegEnum.getEvalObjAreaPageIdOfEval();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId(formId);
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (areaRecordId == null) {
                status = status == OperationStatus.EDIT || status == OperationStatus.ADDNEW ? OperationStatus.ADDNEW : OperationStatus.VIEW;
            } else {
                showParameter.setPkId((Object)areaRecordId);
            }
            showParameter.setStatus(status);
            if (!isCanEdit) {
                showParameter.setStatus(OperationStatus.VIEW);
            }
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(assTableItem);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
            showParameter.setCustomParam("areaconf", (Object)confId);
            showParameter.setCustomParam("confid", (Object)confId);
            showParameter.setCustomParam("taskId", (Object)taskId);
            this.setAssessFormParamInfo(assessformDy, showParameter);
            showParameter.setCustomParam("area", (Object)areaRecordId);
            this.setAreaEvalRecordInitField(taskInfo, showParameter);
            subEvalRecordPageList.add(showParameter.getPageId());
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void setLabelText(String label, String text) {
        Label activityNameLab = (Label)this.getControl(label);
        activityNameLab.setText(text);
    }

    private void showSumAreaView(DynamicObject taskInfo, DynamicObject assessformDy, BigDecimal ose) {
        String evalCacheVal;
        if (ose == null) {
            this.getView().getPageCache().remove("param_ose");
        } else {
            this.getView().getPageCache().put("param_ose", ose.toString());
        }
        DynamicObject sumConf = APP_SERVICE.querySumConfInfoById(assessformDy.getLong("sumconf"));
        boolean isShowInFlow = sumConf.getBoolean("isshowinflow");
        this.getView().setVisible(Boolean.valueOf(isShowInFlow), new String[]{"sumareainfoap"});
        if (!isShowInFlow) {
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObject[] sumAreaEvalRecords = APP_SERVICE.querySumAreaEvalRecordDesc(this.getModel().getDataEntity().getLong("id"));
        DynamicObject sumAreaEvalRecordOfCurr = Arrays.stream(sumAreaEvalRecords).filter(sumAreaEvalRecord -> sumAreaEvalRecord.getLong("flowrutask.id") == taskInfo.getLong("id")).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)sumAreaEvalRecordOfCurr)) {
            status = status == OperationStatus.EDIT ? OperationStatus.ADDNEW : OperationStatus.VIEW;
        } else {
            showParameter.setPkId((Object)sumAreaEvalRecordOfCurr.getLong("id"));
        }
        showParameter.setStatus(status);
        showParameter.setFormId("epa_evalsumareains");
        showParameter.setCustomParam("param_config_id", sumConf.getPkValue());
        showParameter.setCustomParam("param_assess_form_id", assessformDy.getPkValue());
        this.getView().getPageCache().put("ruleId", assessformDy.getPkValue().toString());
        BigDecimal scoreSysMaxScore = BigDecimal.ZERO;
        BigDecimal scoreSysMinScore = BigDecimal.ZERO;
        Long scoreSystemId = assessformDy.getDynamicObject("scoresystem").getLong("id");
        DynamicObject scoreSystemDy = APP_SERVICE.queryScoreSystemById(scoreSystemId);
        if (scoreSystemDy != null) {
            scoreSysMaxScore = scoreSystemDy.getBigDecimal("maxscore") == null ? BigDecimal.ZERO : scoreSystemDy.getBigDecimal("maxscore");
            scoreSysMinScore = scoreSystemDy.getBigDecimal("minscore") == null ? BigDecimal.ZERO : scoreSystemDy.getBigDecimal("minscore");
        }
        showParameter.setCustomParam("scoreSysMaxScoreString", (Object)scoreSysMaxScore.toPlainString());
        showParameter.setCustomParam("scoreSysMinScoreString", (Object)scoreSysMinScore.toPlainString());
        this.setAssessFormParamInfo(assessformDy, showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("sumareaap");
        this.setAreaEvalRecordInitField(taskInfo, showParameter);
        List<ContentAreaEntryEvaDto> sumProcessPermSetting = this.getSumProcessPermSetting(taskInfo, assessformDy.getLong("sumconf"));
        Map<Long, ContentAreaEntryEvaDto> sumEntryEvaDtoMap = this.convert2MapByAreaConf(sumProcessPermSetting);
        ContentAreaEntryEvaDto sumEntryEvaDto = sumEntryEvaDtoMap.get(assessformDy.getLong("sumconf"));
        if (sumEntryEvaDto != null) {
            showParameter.setCustomParam("sumPermSettingJsonStr", (Object)JSON.toJSONString((Object)sumEntryEvaDto.getContentfieldentry()));
        }
        if ((evalCacheVal = this.getView().getPageCache().get("evalValue")) != null) {
            showParameter.setCustomParam("evalValue", (Object)evalCacheVal);
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
        this.getView().getPageCache().put("sumAreaPageId", showParameter.getPageId());
        if (status != OperationStatus.VIEW) {
            this.getView().getModel().setValue("sumareapageid", (Object)showParameter.getPageId());
        }
        this.showSumAreaEvalRecordView(assessformDy, sumAreaEvalRecords, sumConf);
    }

    private List<ContentAreaEntryEvaDto> getSumProcessPermSetting(DynamicObject taskInfo, Long areaConfigId) {
        Long processpermsetting = this.getProcessPermSettingId();
        DynamicObject ruNodeDy = APP_SERVICE.queryFlowDefNodeIdByruNodeId(Long.valueOf(taskInfo.getLong("flowrunode.id")));
        List contentAreaEntryEvaDtoList = APP_SERVICE.queryProcessPermSettingByKeyFieldNew(processpermsetting, Long.valueOf(ruNodeDy.getLong("flownodedef.id")));
        return contentAreaEntryEvaDtoList;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"oselabel", "olelabel", "oseline"});
        Long taskId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("taskId"));
        this.showBackBtn(taskId);
    }

    private void showBackBtn(Long taskId) {
        boolean firstNodeAndRole = APP_SERVICE.isFirstNodeAndRole(taskId);
        if (firstNodeAndRole) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_back"});
            this.isShowBatchReject(false);
        } else {
            boolean crossNodeOfPreRule = APP_SERVICE.isCrossNodeOfPreRole(taskId);
            this.getView().getPageCache().put("preRoleIsCrossNode", "false");
            if (crossNodeOfPreRule) {
                this.getView().getPageCache().put("preRoleIsCrossNode", "true");
            }
        }
    }

    private void isShowBatchReject(boolean isShow) {
        String parentViewEntityId;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "epa_actevalobj_eval_multi".equals(parentViewEntityId = parentView.getEntityId())) {
            parentView.setVisible(Boolean.valueOf(isShow), new String[]{"reject"});
            this.getView().sendFormAction(parentView);
        }
    }

    private void showSumAreaEvalRecordView(DynamicObject ruleDy, DynamicObject[] sumAreaEvalRecords, DynamicObject sumConf) {
        List recordList = Arrays.stream(sumAreaEvalRecords).filter(record -> StringUtils.equals((CharSequence)record.getString("flowrutask.taskstatus"), (CharSequence)FlowRuTaskStatusEnum.PROCESSED.getCode())).collect(Collectors.toList());
        this.getView().setVisible(Boolean.valueOf(!ObjectUtils.isEmpty(recordList)), new String[]{"recordopap", "sumarearecordap"});
        if (ObjectUtils.isEmpty(recordList)) {
            return;
        }
        this.closeSumAreaRecord();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("sumrecordentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("handler", new Object[0]);
        vs.addField("sumrecord", new Object[0]);
        vs.addField("flowrunode", new Object[0]);
        vs.addField("flowrurole", new Object[0]);
        for (DynamicObject recordDy : recordList) {
            vs.addRow(new Object[]{recordDy.get("flowrutask.handler.id"), recordDy.getPkValue(), recordDy.get("flowrunode"), recordDy.get("flowrurole")});
        }
        model.batchCreateNewEntryRow("sumrecordentry", vs);
        DynamicObjectCollection sumRecordEntry = this.getModel().getEntryEntity("sumrecordentry");
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(Long.valueOf(ruleDy.getLong("id")));
        for (DynamicObject sumRecord : sumRecordEntry) {
            sumRecord.set("nodeweight", sumRecord.get("flowrunode.nodeweight"));
            sumRecord.set("roleweight", sumRecord.get("flowrurole.roleweight"));
            sumRecord.set("handlerhead", sumRecord.get("handler.picturefield"));
            sumRecord.set("ose", sumRecord.get("sumrecord.ose"));
            perfLevelItems.stream().filter(perfLevelItem -> HRStringUtils.equals((String)perfLevelItem.getValue(), (String)sumRecord.getString("sumrecord.ole"))).findFirst().ifPresent(comboItem -> sumRecord.set("ole", (Object)comboItem.getCaption().getLocaleValue()));
        }
        model.endInit();
        this.getView().updateView("sumrecordentry");
        this.getModel().setDataChanged(false);
        CardEntry sumRecordCard = (CardEntry)this.getControl("sumrecordentry");
        this.getView().setVisible(Boolean.FALSE, new String[]{"oseap", "oleap", "evalap"});
        DynamicObjectCollection filedEntry = sumConf.getDynamicObjectCollection("entryentity");
        for (DynamicObject filedInfo : filedEntry) {
            DynamicObject filed = filedInfo.getDynamicObject("areafield");
            String filedKey = filed.getString("number");
            boolean isShow = true;
            int size = sumRecordEntry.size();
            for (int i = 0; i < size; ++i) {
                sumRecordCard.setChildVisible(isShow, i, new String[]{filedKey + "ap"});
            }
            Label filedNameLab = (Label)this.getView().getControl(filedKey + "lab");
            if (filedNameLab == null) continue;
            String fieldCustName = filedInfo.getString("fieldcustname");
            String fieldName = StringUtils.isEmpty((CharSequence)fieldCustName) ? filed.getString("name") : fieldCustName;
            filedNameLab.setText(fieldName + "\uff1a");
        }
    }

    private void setDetailField(String SUM_AREA_CLICKED) {
        Long taskId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("taskId"));
        DynamicObject assessForm = APP_SERVICE.queryAssessFormByTaskId(taskId);
        int numAccuracy = assessForm.getInt("numaccuracy");
        String scaleType = assessForm.getString("scaletype");
        String clickedId = this.getPageCache().get("clickedId");
        if (HRStringUtils.equals((String)"sumrecordentry", (String)clickedId)) {
            return;
        }
        this.getPageCache().put("isHideSoePanel", "false");
        this.setLabelText("indicatorlabel", ResManager.loadKDString((String)"\u603b\u8bc4", (String)"ActEvalObjDetailEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        this.getView().setVisible(Boolean.FALSE, new String[]{"viewdetail", "emptyap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"otherevaltitle", "evaluationlist"});
        this.setGrow(1, this.getView());
        Long actEvalObjId = (Long)this.getModel().getValue("id");
        DynamicObject[] sumRecord = APP_SERVICE.querySumRecordByActEvalObjId(actEvalObjId);
        DynamicObject[] adjRecord = APP_SERVICE.queryAdjRecordByActEvalObjId(actEvalObjId);
        DynamicObject[] ndrRecord = APP_SERVICE.queryNdrRecordByActEvalObjId(actEvalObjId);
        DynamicObject[] genAreaRecord = APP_SERVICE.queryGenRecordByActEvalObjId(actEvalObjId);
        List genTaskIdList = Arrays.asList(genAreaRecord).stream().map(obj -> obj.getLong("flowrutask")).collect(Collectors.toList());
        Map<Long, String> ndrMap = Arrays.asList(ndrRecord).stream().collect(Collectors.toMap(x -> x.getLong("flowrunode"), y -> y.getBigDecimal("sont").setScale(numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).stripTrailingZeros().toPlainString()));
        List sumTaskIdList = Arrays.asList(sumRecord).stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        List mergedList = Stream.concat(sumTaskIdList.stream(), genTaskIdList.stream()).distinct().collect(Collectors.toList());
        DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(mergedList);
        Map taskNodeMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("flowrunode.id"), Function.identity(), (v1, v2) -> v2));
        LinkedHashMap<String, Object> nodeMap = this.assembleSumEvalData(taskObjs, adjRecord, sumRecord, assessForm);
        Map permissionConfig = APP_SERVICE.queryPermissionConfig(taskId);
        int currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
        for (Long flowrunodeKey : ndrMap.keySet()) {
            int nodeIndex;
            DynamicObject taskObj = (DynamicObject)taskNodeMap.get(flowrunodeKey);
            if (HRObjectUtils.isEmpty((Object)taskObj) || currentNodeIndex >= (nodeIndex = taskObj.getInt("flowrunode.index"))) continue;
            ndrMap.put(flowrunodeKey, null);
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epa_actevalind_flownode");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("evaluationlist");
        formShowParameter.setCustomParam("flowNodeMap", (Object)JSON.toJSONString(nodeMap));
        formShowParameter.setCustomParam("ndrMap", (Object)JSON.toJSONString(ndrMap));
        formShowParameter.setCustomParam("maxRoleCount", (Object)Integer.MAX_VALUE);
        formShowParameter.setHasRight(Boolean.TRUE.booleanValue());
        this.getView().showForm(formShowParameter);
        this.getPageCache().put("clickedId", "sumrecordentry");
    }

    private void setGrow(int growVal, IFormView view) {
        HashMap<String, Integer> propsMap = new HashMap<String, Integer>(16);
        propsMap.put("gr", growVal);
        view.updateControlMetadata("otherevalap", propsMap);
    }

    private LinkedHashMap<String, Object> assembleSumEvalData(DynamicObject[] tasks, DynamicObject[] actEvalObjAdjRecord, DynamicObject[] actEvalObjSumRecord, DynamicObject assessForm) {
        LinkedHashMap<String, Object> evalRecordMap = new LinkedHashMap<String, Object>(16);
        Long sumperflevelId = assessForm.getLong("sumperflevel.id");
        int numAccuracy = assessForm.getInt("numaccuracy");
        String scaleType = assessForm.getString("scaletype");
        List adjTaskIdList = Arrays.asList(actEvalObjAdjRecord).stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        List sumTaskIdList = Arrays.asList(actEvalObjSumRecord).stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
        List containCrossTaskIdList = Arrays.asList(tasks).stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        List taskIdList = Stream.of(adjTaskIdList, sumTaskIdList).flatMap(Collection::stream).collect(Collectors.toList());
        List mergedList = Stream.concat(taskIdList.stream(), containCrossTaskIdList.stream()).distinct().collect(Collectors.toList());
        DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(mergedList);
        List processedTasks = Arrays.stream(taskObjs).filter(obj -> FlowRuTaskStatusEnum.PROCESSED.getCode().equals(obj.getString("taskstatus")) && !adjTaskIdList.contains(obj.getLong("id"))).sorted(Comparator.comparingInt(x -> x.getInt("flowrunode.index"))).collect(Collectors.toList());
        Collections.reverse(processedTasks);
        Map<Long, DynamicObject> taskMap = Arrays.asList(taskObjs).stream().filter(obj -> FlowRuTaskStatusEnum.PROCESSED.getCode().equals(obj.getString("taskstatus"))).collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
        Map permCfgMap = APP_SERVICE.queryBatchProcessPermSettingScope(mergedList);
        Long currentTaskId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("taskId"));
        Map permissionConfig = APP_SERVICE.queryPermissionConfig(currentTaskId);
        Long currUserId = RequestContext.get().getCurrUserId();
        int currentTurnoversort = (Integer)permissionConfig.get("turnoversort");
        if (actEvalObjAdjRecord != null && actEvalObjAdjRecord.length > 0) {
            this.assembleAdjEvalData(taskMap, permCfgMap, actEvalObjAdjRecord, evalRecordMap, currentTurnoversort, sumperflevelId, permissionConfig, numAccuracy, scaleType);
        }
        for (DynamicObject task : processedTasks) {
            DynamicObject evalRecord;
            Long taskId = task.getLong("id");
            DynamicObject taskInfo = taskMap.get(taskId);
            if (HRObjectUtils.isEmpty((Object)taskInfo)) continue;
            Boolean iscrossnode = taskInfo.getBoolean("flowrunode.iscrossnode");
            String flowrunodeName = taskInfo.getString("flowrunode.name");
            int flowrunodeIndex = taskInfo.getInt("flowrunode.index");
            Long modifierId = taskInfo.getLong("handler.id");
            BigDecimal flowrunodeWeight = taskInfo.getBigDecimal("flowrunode.nodeweight");
            String flowruroleName = taskInfo.getString("flowrurole.name");
            Long flowruroleId = taskInfo.getLong("flowrurole.id");
            String flowrunodeId = taskInfo.getString("flowrunode.id");
            String modifierPicturefield = taskInfo.getString("handler.picturefield");
            String modifierName = taskInfo.getString("handler.name");
            Long flowDefNodeId = taskInfo.getLong("flowrunode.flownodedef.id");
            Map anonymousConfig = (Map)permCfgMap.get(flowDefNodeId);
            String anonymous = "not_anonymous";
            if (anonymousConfig != null && anonymousConfig.get("anonymous") != null) {
                anonymous = anonymousConfig.get("anonymous").toString();
            }
            int currentNodeIndex = 0;
            if (anonymousConfig != null && anonymousConfig.get("flowrunodeIndex") != null) {
                currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
            }
            permissionConfig.put("histurnoversort", taskInfo.getInt("flowrurole.turnoversort"));
            permissionConfig.put("hisflowrurole", taskInfo.getLong("flowrurole.id"));
            if (HRStringUtils.equals((String)anonymous, (String)ProcPermAnonymityEnum.ANONYMOUS.getCode()) && this.isBeforeRole(flowrunodeIndex, currentNodeIndex, flowruroleId, currentTurnoversort) && !modifierId.equals(currUserId)) {
                flowruroleName = ANONYMOUS_STR;
                modifierName = ANONYMOUS_STR;
                modifierPicturefield = "";
            }
            List hisItemList = new ArrayList(10);
            if (!iscrossnode.booleanValue() && (evalRecord = (DynamicObject)Arrays.stream(actEvalObjSumRecord).filter(obj -> taskId.equals(obj.getLong("flowrutask.id"))).findFirst().orElse(null)) != null) {
                boolean isShowEvaldesc;
                boolean isShowOle;
                BigDecimal soe = evalRecord.getBigDecimal("ose");
                String evaldesc = evalRecord.getString("eval");
                String ole = evalRecord.getString("ole");
                String oleShowText = this.getOleShowText(sumperflevelId, ole);
                hisItemList = (List)evalRecordMap.get(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString());
                if (hisItemList == null) {
                    hisItemList = new ArrayList(10);
                }
                HashMap<String, String> flowrunodeMap = new HashMap<String, String>(16);
                flowrunodeMap.put("flowruroleName", flowruroleName);
                flowrunodeMap.put("modifierPicturefield", modifierPicturefield);
                flowrunodeMap.put("modifierName", modifierName);
                boolean isShowSoe = ActEvalObjDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "sum");
                if (isShowSoe) {
                    flowrunodeMap.put("soe", soe.setScale(numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).stripTrailingZeros().toPlainString());
                }
                if (isShowOle = ActEvalObjDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "level")) {
                    flowrunodeMap.put("ole", oleShowText);
                }
                if (isShowEvaldesc = ActEvalObjDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "comment")) {
                    flowrunodeMap.put("evaldesc", evaldesc);
                }
                hisItemList.add(flowrunodeMap);
            }
            evalRecordMap.put(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString(), hisItemList);
        }
        return evalRecordMap;
    }

    private void assembleAdjEvalData(Map<Long, DynamicObject> taskMap, Map<Long, Object> permCfgMap, DynamicObject[] actEvalObjAdjRecord, LinkedHashMap<String, Object> evalRecordMap, int currentTurnoversort, Long sumperflevelId, Map<String, Object> permissionConfig, int numAccuracy, String scaleType) {
        Long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject evalRecord : actEvalObjAdjRecord) {
            Long taskId = evalRecord.getLong("flowrutask.id");
            DynamicObject taskInfo = taskMap.get(taskId);
            if (HRObjectUtils.isEmpty((Object)taskInfo)) continue;
            Boolean iscrossnode = taskInfo.getBoolean("flowrunode.iscrossnode");
            String flowrunodeName = taskInfo.getString("flowrunode.name");
            int flowrunodeIndex = taskInfo.getInt("flowrunode.index");
            Long modifierId = taskInfo.getLong("handler.id");
            BigDecimal flowrunodeWeight = taskInfo.getBigDecimal("flowrunode.nodeweight");
            String flowruroleName = taskInfo.getString("flowrurole.name");
            String flowrunodeId = taskInfo.getString("flowrunode.id");
            Long flowruroleId = taskInfo.getLong("flowrurole.id");
            String modifierPicturefield = taskInfo.getString("handler.picturefield");
            String modifierName = taskInfo.getString("handler.name");
            Long flowDefNodeId = taskInfo.getLong("flowrunode.flownodedef.id");
            Map anonymousConfig = (Map)permCfgMap.get(flowDefNodeId);
            String anonymous = "not_anonymous";
            if (anonymousConfig != null && anonymousConfig.get("anonymous") != null) {
                anonymous = anonymousConfig.get("anonymous").toString();
            }
            int currentNodeIndex = 0;
            if (anonymousConfig != null && anonymousConfig.get("flowrunodeIndex") != null) {
                currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
            }
            if (HRStringUtils.equals((String)anonymous, (String)ProcPermAnonymityEnum.ANONYMOUS.getCode()) && this.isBeforeRole(flowrunodeIndex, currentNodeIndex, flowruroleId, currentTurnoversort) && !modifierId.equals(currUserId)) {
                flowruroleName = ANONYMOUS_STR;
                modifierName = ANONYMOUS_STR;
                modifierPicturefield = "";
            }
            BigDecimal soe = evalRecord.getBigDecimal("atcs");
            String evaldesc = evalRecord.getString("ins");
            String ole = evalRecord.getString("atcl");
            String oleShowText = this.getOleShowText(sumperflevelId, ole);
            permissionConfig.put("histurnoversort", taskInfo.getInt("flowrurole.turnoversort"));
            permissionConfig.put("hisflowrurole", taskInfo.getLong("flowrurole.id"));
            ArrayList hisItemList = (ArrayList)evalRecordMap.get(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__");
            if (hisItemList == null) {
                hisItemList = new ArrayList(10);
            }
            if (!iscrossnode.booleanValue()) {
                boolean isShowEvaldesc;
                boolean isShowOle;
                HashMap<String, String> flowrunodeMap = new HashMap<String, String>(16);
                flowrunodeMap.put("flowruroleName", flowruroleName);
                flowrunodeMap.put("modifierPicturefield", modifierPicturefield);
                flowrunodeMap.put("modifierName", modifierName);
                boolean isShowSoe = ActEvalObjDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "sum");
                if (isShowSoe) {
                    flowrunodeMap.put("soe", soe.setScale(numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).stripTrailingZeros().toPlainString());
                }
                if (isShowOle = ActEvalObjDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "level")) {
                    flowrunodeMap.put("ole", oleShowText);
                }
                if (isShowEvaldesc = ActEvalObjDetailEdit.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "comment")) {
                    flowrunodeMap.put("evaldesc", evaldesc);
                }
                hisItemList.add(flowrunodeMap);
            }
            evalRecordMap.put(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__", hisItemList);
        }
    }

    private boolean isBeforeRole(int flowrunodeIndex, int currentNodeIndex, Long flowruroleId, int currentTurnoversort) {
        List flowRuRoleBoList;
        FlowRuNodeBo flowRuNodeBo;
        Long evalflowinsId;
        WorkflowRuProcBo flowRuProcBo;
        List flowRuNodeBoList;
        String actEvalObjUserId = this.getView().getPageCache().get("actEvalObjUserId");
        long currUserId = RequestContext.get().getCurrUserId();
        if (HRStringUtils.equals((String)String.valueOf(currUserId), (String)actEvalObjUserId)) {
            return true;
        }
        if (flowrunodeIndex > currentNodeIndex) {
            return true;
        }
        if (flowrunodeIndex == currentNodeIndex && currentNodeIndex > 0 && (flowRuNodeBoList = (flowRuProcBo = FLOW_RUN_SUP_DOMAIN_SERVICE.getRuProcInstance(evalflowinsId = Long.valueOf(this.getModel().getDataEntity().getLong("evalflowins.id")))).getFlowRuNodeBoList()) != null && flowRuNodeBoList.size() >= currentNodeIndex && (flowRuNodeBo = (FlowRuNodeBo)flowRuNodeBoList.get(currentNodeIndex - 1)) != null && (flowRuRoleBoList = flowRuNodeBo.getFlowRuRoleBoList()) != null) {
            int turnoversort = 0;
            for (FlowRuRoleBo flowRuRoleBo : flowRuRoleBoList) {
                Long pkValue = (Long)flowRuRoleBo.getFlowRuRole().getPkValue();
                if (!HRObjectUtils.equals((Object)pkValue, (Object)flowruroleId)) continue;
                turnoversort = (Integer)flowRuRoleBo.getFlowRuRole().get("turnoversort");
            }
            if (turnoversort >= currentTurnoversort) {
                return true;
            }
        }
        return false;
    }

    private String getOleShowText(Long sumperflevelId, String ole) {
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByLevel(sumperflevelId);
        if (perfLevelItems != null) {
            for (ComboItem perfLevelItem : perfLevelItems) {
                LocaleString caption;
                if (perfLevelItem == null) continue;
                String perfLevelItemValue = perfLevelItem.getValue();
                if (ole == null || !ole.equals(perfLevelItemValue) || (caption = perfLevelItem.getCaption()) == null) continue;
                return caption.getLocaleValue();
            }
        }
        return null;
    }

    private static boolean isShowFieldByPermission(Map<String, Object> permissionConfig, int flowrunodeIndex, long modifierId, String field) {
        boolean isShow = false;
        String scope = (String)permissionConfig.get(field);
        if (scope != null) {
            int currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
            switch (scope) {
                case "show_self": {
                    long currUserId = RequestContext.get().getCurrUserId();
                    isShow = modifierId == currUserId;
                    break;
                }
                case "show_selfnode": {
                    isShow = flowrunodeIndex == currentNodeIndex;
                    break;
                }
                case "show_pre": {
                    isShow = flowrunodeIndex <= currentNodeIndex;
                    break;
                }
                case "show_all": {
                    isShow = true;
                    break;
                }
                case "show_selfandpre": {
                    long currUserId = RequestContext.get().getCurrUserId();
                    if (modifierId == currUserId) {
                        return true;
                    }
                    isShow = flowrunodeIndex < currentNodeIndex ? true : (flowrunodeIndex == currentNodeIndex ? IndicatorDetailUtils.isShowBySelfAndPre(permissionConfig, modifierId, currUserId) : false);
                }
            }
        }
        return isShow;
    }

    private void setAssessFormParamInfo(DynamicObject assessFormDy, BaseShowParameter showParameter) {
        showParameter.setCustomParam("consistentwitharea", (Object)assessFormDy.getString("consistentwitharea"));
        showParameter.setCustomParam("scorecalcway", (Object)assessFormDy.getString("scorecalcway"));
        showParameter.setCustomParam("evalway", (Object)assessFormDy.getString("evalway"));
        showParameter.setCustomParam("evasumlimit", (Object)assessFormDy.getString("evasumlimit"));
        showParameter.setCustomParam("numaccuracy", (Object)assessFormDy.getString("numaccuracy"));
        showParameter.setCustomParam("scoresystem", (Object)assessFormDy.getDynamicObject("scoresystem").getLong("id"));
        showParameter.setCustomParam("scaletype", (Object)assessFormDy.getString("scaletype"));
        showParameter.setCustomParam("issupcalcsum", (Object)assessFormDy.getBoolean("issupcalcsum"));
        showParameter.setCustomParam("allowexceedupper", (Object)assessFormDy.getBoolean("allowexceedupper"));
        showParameter.setCustomParam("limitmaxscore", (Object)assessFormDy.getBigDecimal("limitmaxscore"));
        BigDecimal limitMaxScore = assessFormDy.getBigDecimal("limitmaxscore") == null ? BigDecimal.ZERO : assessFormDy.getBigDecimal("limitmaxscore");
        showParameter.setCustomParam("limitmaxscoreString", (Object)limitMaxScore.toPlainString());
        showParameter.setCustomParam("allowexceedlower", (Object)assessFormDy.getBoolean("allowexceedlower"));
        showParameter.setCustomParam("limitminscore", (Object)assessFormDy.getBigDecimal("limitminscore"));
        BigDecimal limitMinScore = assessFormDy.getBigDecimal("limitminscore") == null ? BigDecimal.ZERO : assessFormDy.getBigDecimal("limitminscore");
        showParameter.setCustomParam("limitminscoreString", (Object)limitMinScore.toPlainString());
        showParameter.setCustomParam("areaMarker", (Object)COMMON_AREA_CLICKED);
        showParameter.setCustomParam("evasumlimit", (Object)assessFormDy.getString("evasumlimit"));
    }

    private void setAreaEvalRecordInitField(DynamicObject taskInfo, BaseShowParameter showParameter) {
        DynamicObject evalObjDy = this.getModel().getDataEntity();
        showParameter.setCustomParam("actevalobj", (Object)evalObjDy.getLong("id"));
        showParameter.setCustomParam("assessyear", (Object)evalObjDy.getInt("assessyear"));
        showParameter.setCustomParam("assessperiod", (Object)evalObjDy.getString("assessperiod"));
        showParameter.setCustomParam("activity", (Object)evalObjDy.getLong("activity.id"));
        showParameter.setCustomParam("perforg", (Object)evalObjDy.getLong("perforg.id"));
        showParameter.setCustomParam("flowrunode", (Object)taskInfo.getLong("flowrunode.id"));
        showParameter.setCustomParam("flowrurole", (Object)taskInfo.getLong("flowrurole.id"));
        showParameter.setCustomParam("flowrutask", (Object)taskInfo.getLong("id"));
        showParameter.setCustomParam("flowruproc", (Object)taskInfo.getLong("flowruproc.id"));
    }

    public void doSave(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        String subEvalRecordPageListStr = this.getView().getPageCache().get("subEvalRecordPageList");
        if (subEvalRecordPageListStr == null) {
            return;
        }
        List subEvalRecordPageList = (List)SerializationUtils.fromJsonString((String)subEvalRecordPageListStr, List.class);
        long startMillis = System.currentTimeMillis();
        long endMillis = System.currentTimeMillis();
        for (String subEvalRecordPage : subEvalRecordPageList) {
            String page_load;
            IFormView subAreaPage;
            startMillis = System.currentTimeMillis();
            if (HRStringUtils.isBlank((CharSequence)subEvalRecordPage) || (subAreaPage = this.getView().getView(subEvalRecordPage)) == null || OperationStatus.VIEW == subAreaPage.getFormShowParameter().getStatus()) continue;
            IDataModel model = subAreaPage.getModel();
            boolean dataLoaded = model.isDataLoaded();
            LOG.info("***save Operation dataLoaded:{}", (Object)dataLoaded);
            long startWaitMillis = System.currentTimeMillis();
            long maxWaitMillis = 2000L;
            while (!model.isDataLoaded()) {
                try {
                    Thread.sleep(80L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                long endWaitMillis = System.currentTimeMillis();
                if (endWaitMillis - startWaitMillis <= maxWaitMillis) continue;
                break;
            }
            if ((page_load = subAreaPage.getPageCache().get("page_load_finished_key")) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"ActEvalObjDetailEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            String backenSave = source.getOption().getVariableValue("BACKEN_SAVE", "false");
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("BACKEN_SAVE", backenSave);
            subAreaPage.invokeOperation(operateKey, option);
            endMillis = System.currentTimeMillis();
            LOG.info("ActEvalObjDetailEdit save usetime:{}", (Object)(endMillis - startMillis));
        }
        startMillis = System.currentTimeMillis();
        this.saveSumAreaPage(System.currentTimeMillis());
        endMillis = System.currentTimeMillis();
        LOG.info("ActEvalObjDetailEdit saveSumAreaPage usetime:{}", (Object)(endMillis - startMillis));
    }

    public boolean isTaskStatusValid() {
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        FlowRuTaskStatusEnum taskStatus = APP_SERVICE.getTaskStatus(taskId);
        if (taskStatus != null) {
            String statusCode = taskStatus.getCode();
            if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(statusCode) || FlowRuTaskStatusEnum.EXPIRED.getCode().equals(statusCode) || FlowRuTaskStatusEnum.PROCESSED.getCode().equals(statusCode)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        block36: {
            String calculateKey;
            long endTime;
            long startTime;
            String calculating;
            IHRAppCache epaCache;
            block39: {
                block37: {
                    String currentViewPageId;
                    block38: {
                        block34: {
                            boolean indicatorChangeOfCross;
                            FlowRuTaskStatusEnum taskStatus;
                            boolean isValid;
                            AbstractOperate source;
                            block35: {
                                super.beforeDoOperation(args);
                                source = (AbstractOperate)args.getSource();
                                operateKey = source.getOperateKey();
                                if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) break block34;
                                isValid = true;
                                String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
                                List<Long> taskIdList = this.getTaskIdList(taskId);
                                taskStatus = APP_SERVICE.getTaskStatusForCheck(taskIdList);
                                if (taskStatus != null) {
                                    String statusCode = taskStatus.getCode();
                                    if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(statusCode) || FlowRuTaskStatusEnum.EXPIRED.getCode().equals(statusCode) || FlowRuTaskStatusEnum.PROCESSED.getCode().equals(statusCode)) {
                                        isValid = false;
                                    }
                                }
                                indicatorChangeOfCross = this.isChangeOfCross();
                                if (!isValid || indicatorChangeOfCross) break block35;
                                APP_SERVICE.resetRollBackedMark(taskIdList);
                                this.doSave(args);
                                break block36;
                            }
                            args.setCancel(true);
                            if (!isValid) {
                                this.doShowSaveTips(source, taskStatus);
                                break block36;
                            } else if (indicatorChangeOfCross) {
                                this.showNotSaveTips(source);
                            }
                            break block36;
                        }
                        if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"submiteval")) break block37;
                        long startMillis = System.currentTimeMillis();
                        this.invokeSaveOp();
                        long endMillis = System.currentTimeMillis();
                        LOG.info("ActEvalObjDetailEdit OP_SUBMIT_EVAL usetime:{}", (Object)(endMillis - startMillis));
                        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
                        try {
                            List<Long> taskIdList = this.getTaskIdList(taskId);
                            APP_SERVICE.checkEvalTaskAndProcStatus(taskIdList);
                        }
                        catch (KDException bizException) {
                            String message = bizException.getMessage();
                            IFormView parentView = this.getView().getParentView();
                            if (parentView != null) {
                                String parentViewEntityId = parentView.getEntityId();
                                if (!"epa_actevalobj_eval_multi".equals(parentViewEntityId)) {
                                    this.getView().showConfirm(message, MessageBoxOptions.OK);
                                    this.getView().getPageCache().put("propChanged", "false");
                                    this.getView().getPageCache().put("needSubmit", "false");
                                    args.setCancel(true);
                                    return;
                                }
                                parentView.showTipNotification(message);
                                parentView.getPageCache().put("isEmptyPage", "true");
                                OperateOption option = OperateOption.create();
                                option.setVariableValue("ishasright", "true");
                                parentView.invokeOperation("refresh", option);
                                parentView.getPageCache().put("isEmptyPage", "false");
                                this.getView().sendFormAction(parentView);
                            } else {
                                this.getView().showTipNotification(message);
                            }
                            OperateOption option = OperateOption.create();
                            option.setVariableValue("ishasright", "true");
                            this.getView().invokeOperation("refresh", option);
                            this.getView().getPageCache().put("propChanged", "false");
                            this.getView().getPageCache().put("needSubmit", "false");
                            args.setCancel(true);
                            return;
                        }
                        try {
                            Thread.sleep(600L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        epaCache = HRAppCache.get((String)"epa");
                        currentViewPageId = this.getView().getPageId();
                        calculating = (String)epaCache.get(ObjEvaluationUtils.getCalculateKey(currentViewPageId), String.class);
                        if ("true".equals(calculating)) break block38;
                        if (this.isCrossEval()) {
                            this.showCrossConfirm(args);
                        } else {
                            this.executeSubmitTask(args);
                        }
                        epaCache.remove(ObjEvaluationUtils.getCalculateKey(currentViewPageId));
                        break block36;
                    }
                    startTime = System.currentTimeMillis();
                    endTime = System.currentTimeMillis();
                    calculateKey = ObjEvaluationUtils.getCalculateKey(currentViewPageId);
                    break block39;
                }
                if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"calculateose")) {
                    IHRAppCache epaCache2;
                    String currentViewPageId;
                    try {
                        currentViewPageId = this.getView().getPageId();
                        epaCache2 = HRAppCache.get((String)"epa");
                        epaCache2.put(ObjEvaluationUtils.getCalculateKey(currentViewPageId), (Object)"true");
                        this.calculateOse();
                        epaCache2.put(ObjEvaluationUtils.getCalculateKey(currentViewPageId), (Object)"false");
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        currentViewPageId = this.getView().getPageId();
                        epaCache2 = HRAppCache.get((String)"epa");
                        epaCache2.put(ObjEvaluationUtils.getCalculateKey(currentViewPageId), (Object)"false");
                    }
                } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"rollbacktask")) {
                    long startMillis = System.currentTimeMillis();
                    this.invokeSaveOp();
                    long endMillis = System.currentTimeMillis();
                    LOG.info("ActEvalObjDetailEdit OP_ROLLBACK_TASK SAVE usetime:{}", (Object)(endMillis - startMillis));
                    String subEvalRecordPageListStr = this.getView().getPageCache().get("subEvalRecordPageList");
                    List subEvalRecordPageList = (List)SerializationUtils.fromJsonString((String)subEvalRecordPageListStr, List.class);
                    for (String subEvalRecordPage : subEvalRecordPageList) {
                        IFormView subAreaPage = this.getView().getView(subEvalRecordPage);
                        String page_load = subAreaPage.getPageCache().get("page_load_finished_key");
                        if (page_load != null) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"ActEvalObjDetailEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        args.setCancel(Boolean.TRUE.booleanValue());
                        return;
                    }
                    this.showRollBackConfirm();
                }
                break block36;
            }
            while (endTime - startTime < 10000L && "true".equals(calculating = (String)epaCache.get(calculateKey, String.class))) {
                try {
                    Thread.sleep(200L);
                    endTime = System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.isCrossEval()) {
                this.showCrossConfirm(args);
            } else {
                this.executeSubmitTask(args);
            }
            epaCache.remove(calculateKey);
        }
        switch (operateKey) {
            case "caltotalscorefirst": {
                this.calTotalScoreFirst();
                return;
            }
        }
    }

    private List<Long> getTaskIdList(String taskId) {
        List mergeTaskIds;
        ArrayList<Long> taskIdList = new ArrayList<Long>(10);
        HashSet<Long> taskIdSet = new HashSet<Long>(16);
        taskIdSet.add(Long.parseLong(taskId));
        String mergeTaskIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskIds");
        if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && (mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class)) != null) {
            taskIdSet.addAll(mergeTaskIds);
        }
        taskIdList.addAll(taskIdSet);
        return taskIdList;
    }

    private boolean isChangeOfCross() {
        boolean indicatorChangeOfCross = false;
        if (this.isCrossEval()) {
            String taskIndCountMapStr = this.getView().getPageCache().get("CURRENT_PAGE_MERGE_INDS");
            Set<Long> allTaskIdOfCross = this.getAllTaskIdIncludeMerge();
            ArrayList<Long> taskIdList = new ArrayList<Long>(10);
            taskIdList.addAll(allTaskIdOfCross);
            indicatorChangeOfCross = ObjEvaluationUtils.isIndicatorChangeOfCross(taskIndCountMapStr, taskIdList);
        }
        return indicatorChangeOfCross;
    }

    private void showNotSaveTips(AbstractOperate source) {
        String isShowTips;
        Map variables = source.getOption().getVariables();
        if (variables != null && !"true".equals(isShowTips = (String)variables.get("IS_NOT_SHOW_TASK_VALIDATE_TIPS"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6307\u6807\u6570\u636e\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"ActEvalObjDetailEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void doShowSaveTips(AbstractOperate source, FlowRuTaskStatusEnum taskStatus) {
        String isShowTips;
        Map variables = source.getOption().getVariables();
        if (variables != null && !"true".equals(isShowTips = (String)variables.get("IS_NOT_SHOW_TASK_VALIDATE_TIPS")) && taskStatus != null) {
            String statusCode = taskStatus.getCode();
            if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(statusCode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u4efb\u52a1\u5df2\u9000\u56de\u3002", (String)"ActEvalObjDetailEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else if (FlowRuTaskStatusEnum.PROCESSED.getCode().equals(statusCode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u4efb\u52a1\u5df2\u8bc4\u4f30\u3002", (String)"ActEvalObjDetailEdit_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(statusCode)) {
                String message = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ActEvalObjDetailEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    String parentViewEntityId = parentView.getEntityId();
                    if ("epa_actevalobj_eval_multi".equals(parentViewEntityId)) {
                        parentView.showTipNotification(message);
                        parentView.getPageCache().put("isEmptyPage", "true");
                        OperateOption option = OperateOption.create();
                        option.setVariableValue("ishasright", "true");
                        parentView.invokeOperation("refresh", option);
                        parentView.getPageCache().put("isEmptyPage", "false");
                        this.getView().sendFormAction(parentView);
                    } else {
                        this.getView().showConfirm(message, MessageBoxOptions.OK);
                    }
                } else {
                    this.getView().showConfirm(message, MessageBoxOptions.OK);
                }
            }
        }
    }

    private void calTotalScoreFirst() {
        String subEvalRecordPageListStr = this.getView().getPageCache().get("subEvalGenAndSubPageList");
        List subEvalGenAndSubPageList = (List)SerializationUtils.fromJsonString((String)subEvalRecordPageListStr, List.class);
        String sumAreaPageId = this.getView().getModel().getDataEntity(true).getString("sumareapageid");
        if (HRStringUtils.isBlank((CharSequence)sumAreaPageId)) {
            return;
        }
        if (subEvalGenAndSubPageList == null || subEvalGenAndSubPageList.isEmpty()) {
            return;
        }
        boolean isSubPageLoaded = this.isSubPageLoadedForCal(subEvalGenAndSubPageList);
        if (isSubPageLoaded) {
            IFormView sumAreaView;
            BigDecimal totalScore = BigDecimal.ZERO;
            boolean update = true;
            for (String subEvalRecordPage : subEvalGenAndSubPageList) {
                IFormView subAreaPage = this.getView().getView(subEvalRecordPage);
                if (subAreaPage == null) {
                    update = false;
                    break;
                }
                String isPartInStr = subAreaPage.getPageCache().get("isPartInStr");
                if (!"true".equals(isPartInStr)) continue;
                String ssr = subAreaPage.getPageCache().get("SSR_SCORE_AFTERBING");
                if (HRStringUtils.isBlank((CharSequence)ssr)) {
                    ssr = "0";
                }
                BigDecimal ssrVal = new BigDecimal(ssr);
                totalScore = totalScore.add(ssrVal);
            }
            if (update && !HRStringUtils.isBlank((CharSequence)(sumAreaPageId = this.getView().getModel().getDataEntity().getString("sumareapageid"))) && (sumAreaView = this.getView().getView(sumAreaPageId)) != null) {
                IDataModel model = sumAreaView.getModel();
                long startMillis = System.currentTimeMillis();
                long maxWaitMillis = 30000L;
                while (!model.isDataLoaded()) {
                    try {
                        Thread.sleep(80L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    long endMillis = System.currentTimeMillis();
                    if (endMillis - startMillis <= maxWaitMillis) continue;
                    break;
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("totalScore", totalScore.toPlainString());
                option.setVariableValue("firstInit", "true");
                sumAreaView.invokeOperation("updatetotalscore", option);
                this.getView().sendFormAction(sumAreaView);
                this.getView().updateView("sumareaap");
            }
        }
    }

    private boolean isSubPageLoadedForCal(List<String> subEvalRecordPageList) {
        String pageLoaded;
        boolean isSubPageLoaded = false;
        int loadedCount = 0;
        for (String subEvalRecordPage : subEvalRecordPageList) {
            IFormView subAreaPage = this.getView().getView(subEvalRecordPage);
            if (subAreaPage == null || !"true".equals(pageLoaded = subAreaPage.getPageCache().get("page_load_finished_key"))) continue;
            ++loadedCount;
        }
        if (loadedCount == subEvalRecordPageList.size()) {
            isSubPageLoaded = true;
        }
        if (subEvalRecordPageList == null || subEvalRecordPageList.size() == 0) {
            isSubPageLoaded = false;
        }
        boolean sumAreaPageLoad = false;
        String sumAreaPageId = (String)this.getView().getModel().getValue("sumareapageid");
        if (!HRStringUtils.isBlank((CharSequence)sumAreaPageId)) {
            IFormView view = this.getView().getView(sumAreaPageId);
            if (view != null && "true".equals(pageLoaded = view.getPageCache().get("page_load_finished_key"))) {
                sumAreaPageLoad = true;
            }
        } else {
            sumAreaPageLoad = false;
        }
        return isSubPageLoaded && sumAreaPageLoad;
    }

    public void showRollBackConfirm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_evalback_confirm");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        showParameter.setCustomParam("taskId", (Object)taskId);
        String mergeTaskIdJson = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskId");
        showParameter.setCustomParam("BACK_MERGE_TASK_ID", (Object)mergeTaskIdJson);
        String taskIndCountMapStr = this.getView().getPageCache().get("CURRENT_PAGE_MERGE_INDS");
        String mergeTaskIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskIds");
        List taskList = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
        List<List> batchTaskList = Collections.singletonList(taskList);
        DynamicObject taskInfo = APP_SERVICE.queryTaskInfo(Long.valueOf(Long.parseLong(taskId)));
        showParameter.setCustomParam("taskIndCountMapStr", (Object)taskIndCountMapStr);
        showParameter.setCustomParam("mergeTaskIdsStr", (Object)JSON.toJSONString(batchTaskList));
        showParameter.setCustomParam("ruProcId", (Object)taskInfo.getLong("flowruproc.id"));
        showParameter.setCustomParam("ruNodeId", (Object)taskInfo.getLong("flowrunode.id"));
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
    }

    public void showCrossConfirm(BeforeDoOperationEventArgs args) {
        boolean fail;
        String subEvalRecordPageListStr = this.getView().getPageCache().get("subEvalRecordPageList");
        List subEvalRecordPageList = (List)SerializationUtils.fromJsonString((String)subEvalRecordPageListStr, List.class);
        ArrayList<Map<String, Object>> validateList = new ArrayList<Map<String, Object>>(10);
        LOG.info("executeSubmitTask start");
        for (String subEvalRecordPage : subEvalRecordPageList) {
            IFormView subAreaPage = this.getView().getView(subEvalRecordPage);
            this.invokeValidateOp(validateList, subAreaPage);
        }
        LOG.info("executeSubmitTask end");
        if (!this.isCrossEval()) {
            long startMillis = System.currentTimeMillis();
            this.invokeSumAreaValidateOp(validateList, System.currentTimeMillis());
            long endMillis = System.currentTimeMillis();
            LOG.info("executeSubmitTask invokeSumAreaValidateOp use time:{}", (Object)(endMillis - startMillis));
        }
        if (fail = validateList.stream().anyMatch(validate -> (Boolean)validate.get("success") == false)) {
            this.getView().getPageCache().put("validateList", SerializationUtils.toJsonString(validateList));
            this.showValidateView();
            args.setCancel(true);
        } else {
            this.removeValidView();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("epa_crosssubmit");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
            showParameter.setCustomParam("taskId", (Object)taskId);
            showParameter.setCustomParam("subEvalRecordPageList", (Object)subEvalRecordPageListStr);
            showParameter.setCustomParam("mergeTaskId", this.getView().getFormShowParameter().getCustomParam("mergeTaskId"));
            String taskIndCountMapStr = this.getView().getPageCache().get("CURRENT_PAGE_MERGE_INDS");
            String mergeTaskIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskIds");
            showParameter.setCustomParam("taskIndCountMapStr", (Object)taskIndCountMapStr);
            showParameter.setCustomParam("mergeTaskIdsStr", (Object)mergeTaskIdsStr);
            showParameter.setHasRight(true);
            this.getView().showForm(showParameter);
        }
    }

    private void executeSubmitTask(BeforeDoOperationEventArgs args) {
        boolean fail;
        String subEvalRecordPageListStr = this.getView().getPageCache().get("subEvalRecordPageList");
        List subEvalRecordPageList = (List)SerializationUtils.fromJsonString((String)subEvalRecordPageListStr, List.class);
        ArrayList<Map<String, Object>> validateList = new ArrayList<Map<String, Object>>(10);
        LOG.info("executeSubmitTask start");
        for (String subEvalRecordPage : subEvalRecordPageList) {
            IFormView subAreaPage = this.getView().getView(subEvalRecordPage);
            this.invokeValidateOp(validateList, subAreaPage);
        }
        LOG.info("executeSubmitTask end");
        if (!this.isCrossEval()) {
            long startMillis = System.currentTimeMillis();
            this.invokeSumAreaValidateOp(validateList, System.currentTimeMillis());
            long endMillis = System.currentTimeMillis();
            LOG.info("executeSubmitTask invokeSumAreaValidateOp use time:{}", (Object)(endMillis - startMillis));
        }
        if (fail = validateList.stream().anyMatch(validate -> (Boolean)validate.get("success") == false)) {
            this.getView().getPageCache().put("validateList", SerializationUtils.toJsonString(validateList));
            this.showValidateView();
            args.setCancel(true);
        } else {
            this.removeValidView();
            Long activityId = this.getModel().getDataEntity().getLong("activity.id");
            DynamicObject activityObj = APP_SERVICE.queryActivityById(activityId);
            Long assessFormId = activityObj.getLong("assessform.id");
            DynamicObject assessFormDy = APP_SERVICE.queryExecuteAssessForm(assessFormId.longValue());
            this.getView().getPageCache().put(NOT_REFRESH_FROM_SUBMIT, "true");
            this.showAreaSubTotalAndTotal(assessFormDy);
        }
    }

    private boolean checkTaskProcStatus(BeforeDoOperationEventArgs args, Long taskId) {
        boolean deprecated;
        boolean isStatusPending = APP_SERVICE.isEvalTaskProcStatusPending(taskId);
        boolean isStatusStop = APP_SERVICE.isEvalTaskProcStatusStop(taskId);
        if (isStatusPending || isStatusStop) {
            if (isStatusPending) {
                String tips = ResManager.loadKDString((String)"\u8bc4\u4f30\u6d41\u7a0b\u5df2\u6302\u8d77\uff0c\u8bf7\u8054\u7cfb\u7ee9\u6548\u7ba1\u7406\u5458\u3002", (String)"ActEvalObjDetailEdit_14", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                args.setCancel(true);
                return true;
            }
            if (isStatusStop) {
                String tips = ResManager.loadKDString((String)"\u8bc4\u4f30\u6d41\u7a0b\u5df2\u6682\u505c\uff0c\u8bf7\u8054\u7cfb\u7ee9\u6548\u7ba1\u7406\u5458\u3002", (String)"ActEvalObjDetailEdit_15", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                args.setCancel(true);
                return true;
            }
        }
        if (deprecated = APP_SERVICE.isEvalTaskProcStatusDeprecated(taskId)) {
            String tips = ResManager.loadKDString((String)"\u8bc4\u4f30\u6d41\u7a0b\u5df2\u5e9f\u5f03\uff0c\u4e0d\u652f\u6301\u63d0\u4ea4\u3002", (String)"ActEvalObjDetailEdit_16", (String)"opmc-epa-business", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            args.setCancel(true);
            return true;
        }
        return false;
    }

    public void showAreaSubTotalAndTotal(DynamicObject assessFormDy) {
        LOG.info("showAreaSubTotalAndTotal start");
        String subEvalRecordPageListStr = this.getView().getPageCache().get("subEvalRecordPageList");
        List subEvalRecordPageList = (List)SerializationUtils.fromJsonString((String)subEvalRecordPageListStr, List.class);
        String scoreCalWay = assessFormDy.getString("scorecalcway");
        ArrayList<EvalSubmitShowInfoDto> submitShowInfoDtoList = new ArrayList<EvalSubmitShowInfoDto>(10);
        String areaWeigthDisplay = this.getView().getPageCache().get("areaWeigthDisplay");
        if (HRStringUtils.isBlank((CharSequence)areaWeigthDisplay)) {
            Long processPermSettingId;
            Map permScopeMap;
            Long taskId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("taskId"));
            DynamicObject taskInfo = APP_SERVICE.queryTaskInfo(taskId);
            DynamicObject ruNodeDy = APP_SERVICE.queryFlowDefNodeIdByruNodeId(Long.valueOf(taskInfo.getLong("flowrunode.id")));
            long flowNodeDefId = 0L;
            if (ruNodeDy != null) {
                flowNodeDefId = ruNodeDy.getLong("flownodedef.id");
            }
            if ((permScopeMap = APP_SERVICE.queryProcessPermSettingScopeNew(processPermSettingId = this.getProcessPermSettingId(), Long.valueOf(flowNodeDefId))) != null) {
                String weightDisplay;
                areaWeigthDisplay = weightDisplay = (String)permScopeMap.get("weight");
                this.getView().getPageCache().put("areaWeigthDisplay", areaWeigthDisplay);
            }
        }
        for (String subEvalRecordPage : subEvalRecordPageList) {
            String numAccuracy = assessFormDy.getString("numaccuracy") == null ? COMMON_AREA_CLICKED : assessFormDy.getString("numaccuracy");
            String scaleTypeStr = assessFormDy.getString("scaletype");
            int scaleType = ScalaTypeEnum.get((String)scaleTypeStr).getType();
            IFormView subAreaPage = this.getView().getView(subEvalRecordPage);
            String formId = subAreaPage.getFormShowParameter().getFormId();
            if (StringUtils.equals((CharSequence)formId, (CharSequence)AreaRegEnum.ATTACH_AREA.getEvalObjAreaPageIdOfEval())) continue;
            String isPartInStr = subAreaPage.getPageCache().get("isPartInStr");
            String isAllowEval = subAreaPage.getPageCache().get("IS_ALLOW_EVAL_AREA");
            if (!"true".equals(isAllowEval) || !"true".equals(isPartInStr)) continue;
            IDataModel model = subAreaPage.getModel();
            BigDecimal ssr = model.getDataEntity().getBigDecimal("ssr");
            if (ssr == null) {
                ssr = BigDecimal.ZERO;
            }
            EvalSubmitShowInfoDto infoDto = new EvalSubmitShowInfoDto();
            String ssrCacheValue = subAreaPage.getPageCache().get("ssrCacheValue");
            if (!HRStringUtils.isBlank((CharSequence)ssrCacheValue)) {
                ssr = new BigDecimal(ssrCacheValue);
            }
            ssr = ssr.setScale(Integer.parseInt(numAccuracy), scaleType);
            infoDto.setScore(ssr);
            String weight = subAreaPage.getPageCache().get("areaWeightCache");
            boolean hasWeight = false;
            if (weight != null) {
                hasWeight = true;
            }
            boolean hasScore = false;
            String areaScore = subAreaPage.getPageCache().get("areaScoreCache");
            if (areaScore != null) {
                hasScore = true;
            }
            String areaName = subAreaPage.getPageCache().get("areaCustomerName");
            if (!this.isCrossEval()) {
                if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalWay) && hasWeight && "display".equals(areaWeigthDisplay)) {
                    BigDecimal weightDecimal = BigDecimal.ZERO;
                    if (!HRStringUtils.isBlank((CharSequence)weight)) {
                        weightDecimal = new BigDecimal(weight);
                    }
                    StringBuilder builder = new StringBuilder();
                    String plainString = weightDecimal.setScale(Integer.parseInt(numAccuracy), scaleType).stripTrailingZeros().toPlainString();
                    builder.append(areaName).append('(').append(plainString).append("%)");
                    areaName = builder.toString();
                } else if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalWay) && hasScore) {
                    BigDecimal areaScoreDecimal = BigDecimal.ZERO;
                    if (!HRStringUtils.isBlank((CharSequence)areaScore)) {
                        areaScoreDecimal = new BigDecimal(areaScore);
                    }
                    String plainString = areaScoreDecimal.setScale(Integer.parseInt(numAccuracy), scaleType).stripTrailingZeros().toPlainString();
                    StringBuilder builder = new StringBuilder();
                    builder.append(areaName).append('(').append(plainString).append(")");
                    areaName = builder.toString();
                }
            }
            infoDto.setName(areaName);
            submitShowInfoDtoList.add(infoDto);
        }
        this.openSubmitConfirmForm(assessFormDy, submitShowInfoDtoList);
    }

    private void openSubmitConfirmForm(DynamicObject assessFormDy, List<EvalSubmitShowInfoDto> submitShowInfoDtoList) {
        String numAccuracy;
        String string = numAccuracy = assessFormDy.getString("numaccuracy") == null ? COMMON_AREA_CLICKED : assessFormDy.getString("numaccuracy");
        if (HRStringUtils.isBlank((CharSequence)numAccuracy)) {
            numAccuracy = COMMON_AREA_CLICKED;
        }
        String scaleTypeStr = assessFormDy.getString("scaletype");
        int scaleType = ScalaTypeEnum.get((String)scaleTypeStr).getType();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_evalsubittips");
        String jsonString = kd.bos.dataentity.serialization.SerializationUtils.toJsonString(submitShowInfoDtoList);
        showParameter.setCustomParam("areaSubTotalList", (Object)jsonString);
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        showParameter.setCustomParam("taskId", (Object)taskId);
        DynamicObject sumConf = APP_SERVICE.querySumConfInfoById(assessFormDy.getLong("sumconf"));
        boolean isShowInFlow = sumConf.getBoolean("isshowinflow");
        showParameter.setCustomParam("isShowInFlow", (Object)isShowInFlow);
        showParameter.setCustomParam("isCrossEvaluate", (Object)this.isCrossEval());
        String sumAreaPageId = (String)this.getView().getModel().getValue("sumareapageid");
        IFormView sumAreaPage = this.getView().getView(sumAreaPageId);
        if (sumAreaPage != null) {
            DynamicObject dataEntity;
            BigDecimal ose;
            IDataModel model = sumAreaPage.getModel();
            long startMillis = System.currentTimeMillis();
            long maxWaitMillis = 60000L;
            while (!model.isDataLoaded()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                long endMillis = System.currentTimeMillis();
                if (endMillis - startMillis <= maxWaitMillis) continue;
                break;
            }
            BigDecimal bigDecimal = ose = (dataEntity = model.getDataEntity()).getBigDecimal("ose") == null ? BigDecimal.ZERO : dataEntity.getBigDecimal("ose");
            if (ose != null) {
                ose = ose.setScale(Integer.parseInt(numAccuracy), scaleType);
            }
            String level = dataEntity.getString("ole");
            long id = assessFormDy.getLong("id");
            List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(Long.valueOf(id));
            if (perfLevelItems != null) {
                for (ComboItem perfLevelItem : perfLevelItems) {
                    String value;
                    if (perfLevelItem == null || HRStringUtils.isBlank((CharSequence)(value = perfLevelItem.getValue())) || !value.equals(level)) continue;
                    level = perfLevelItem.getCaption().toString();
                }
            }
            showParameter.setCustomParam("totalScore", (Object)ose);
            showParameter.setCustomParam("totalLevel", (Object)level);
        }
        String subEvalRecordPageListStr = this.getView().getPageCache().get("subEvalRecordPageList");
        showParameter.setCustomParam("subEvalRecordPageList", (Object)subEvalRecordPageListStr);
        showParameter.setCustomParam("numAccuracy", (Object)Integer.parseInt(numAccuracy));
        showParameter.setCustomParam("scaleType", (Object)scaleType);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
    }

    private void invokeSumAreaValidateOp(List<Map<String, Object>> validateList, Long startMillis) {
        block10: {
            long endMillis;
            if (startMillis == null) {
                startMillis = System.currentTimeMillis();
            }
            if ((endMillis = System.currentTimeMillis()) - startMillis > 120000L) {
                return;
            }
            try {
                String sumAreaPageId = (String)this.getView().getModel().getValue("sumareapageid");
                IFormView sumAreaPage = this.getView().getView(sumAreaPageId);
                if (sumAreaPage == null) {
                    return;
                }
                IDataModel model = sumAreaPage.getModel();
                long s = System.currentTimeMillis();
                long maxWaitMillis = 60000L;
                while (!model.isDataLoaded()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    long e = System.currentTimeMillis();
                    if (e - s <= maxWaitMillis) continue;
                    break;
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                OperationResult operationResult = sumAreaPage.invokeOperation("submitvalid", option);
                boolean success = operationResult.isSuccess();
                String message = operationResult.getMessage();
                List allErrorInfo = operationResult.getAllErrorInfo();
                HashMap<String, Object> validateMap = new HashMap<String, Object>(16);
                validateMap.put("success", success);
                validateMap.put("areaname", message);
                validateMap.put("errorInfo", allErrorInfo);
                validateList.add(validateMap);
            }
            catch (KDException exception) {
                LOG.error((Throwable)exception);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
                LOG.info("Waiting for sumArea page to  load...");
                if (this.isCrossEval()) break block10;
                this.invokeSumAreaValidateOp(validateList, startMillis);
            }
        }
    }

    private void showValidateView() {
        this.removeValidView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId("epa_actevalvalidview");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.getOpenStyle().setFloatingDirection(FloatingDirection.BottomRight);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_actevalvalidview"));
        this.getView().getPageCache().put("validViewPageId", showParameter.getPageId());
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
    }

    private void removeValidView() {
        String validViewId = this.getView().getPageCache().get("validViewPageId");
        IFormView view = this.getView().getView(validViewId);
        if (view != null) {
            view.close();
            this.getView().sendFormAction(view);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"validateinfoap"});
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"epa_actevalvalidview")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"validateinfoap"});
        }
    }

    private void invokeValidateOp(List<Map<String, Object>> validateList, IFormView areaPage) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationResult operationResult = areaPage.invokeOperation("submitvalid", option);
        boolean success = operationResult.isSuccess();
        String message = operationResult.getMessage();
        List allErrorInfo = operationResult.getAllErrorInfo();
        HashMap<String, Object> validateMap = new HashMap<String, Object>(16);
        validateMap.put("success", success);
        validateMap.put("areaname", message);
        validateMap.put("errorInfo", allErrorInfo);
        validateList.add(validateMap);
    }

    private OperationResult saveSumAreaPage(Long startMillis) {
        long endMillis;
        if (startMillis == null) {
            startMillis = System.currentTimeMillis();
        }
        if ((endMillis = System.currentTimeMillis()) - startMillis > 120000L) {
            return null;
        }
        try {
            String sumAreaPageId = (String)this.getView().getModel().getValue("sumareapageid");
            if (HRStringUtils.isBlank((CharSequence)sumAreaPageId)) {
                return null;
            }
            IFormView sumAreaPage = this.getView().getView(sumAreaPageId);
            if (sumAreaPage == null || OperationStatus.VIEW == sumAreaPage.getFormShowParameter().getStatus()) {
                return null;
            }
            IDataModel model = sumAreaPage.getModel();
            long s = System.currentTimeMillis();
            long maxWaitMillis = 60000L;
            while (!model.isDataLoaded()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                long e = System.currentTimeMillis();
                if (e - s <= maxWaitMillis) continue;
                break;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult operationResult = sumAreaPage.invokeOperation("save", option);
            this.getView().getPageCache().remove("evalValue");
            return operationResult;
        }
        catch (KDException exception) {
            LOG.error((Throwable)exception);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            LOG.info("Waiting for page to load...");
            return this.saveSumAreaPage(startMillis);
        }
    }

    private void calculateOse() {
        IFormView sumAreaView;
        String subEvalRecordPageListStr = this.getView().getPageCache().get("subEvalRecordPageList");
        List subEvalRecordPageList = (List)SerializationUtils.fromJsonString((String)subEvalRecordPageListStr, List.class);
        BigDecimal ose = BigDecimal.ZERO;
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage());
        }
        for (String subEvalRecordPage : subEvalRecordPageList) {
            String isPartInStr;
            IFormView subAreaPage = this.getView().getView(subEvalRecordPage);
            String formId = subAreaPage.getFormShowParameter().getFormId();
            if (StringUtils.equals((CharSequence)formId, (CharSequence)AreaRegEnum.ATTACH_AREA.getEvalObjAreaPageIdOfEval()) || !HRStringUtils.equals((String)(isPartInStr = subAreaPage.getPageCache().get("isPartInStr")), (String)"true")) continue;
            String ssrCacheValue = subAreaPage.getPageCache().get("ssrCacheValue");
            BigDecimal ssr = BigDecimal.ZERO;
            if (!HRStringUtils.isBlank((CharSequence)ssrCacheValue)) {
                ssr = new BigDecimal(ssrCacheValue);
            }
            ose = ose.add(ssr);
        }
        String sumAreaPageId = this.getView().getModel().getDataEntity().getString("sumareapageid");
        LOG.info("sumAreaPageId:{}", (Object)sumAreaPageId);
        if (!HRStringUtils.isBlank((CharSequence)sumAreaPageId) && (sumAreaView = this.getView().getView(sumAreaPageId)) != null) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("totalScore", ose.toPlainString());
            option.setVariableValue("firstInit", "false");
            sumAreaView.invokeOperation("updatetotalscore", option);
            this.getView().sendFormAction(sumAreaView);
            this.getView().updateView("sumareaap");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        String isInvokeOperation = this.getView().getPageCache().get("isInvokeOperation");
        if (HRStringUtils.equals((String)"true", (String)isInvokeOperation)) {
            OperationResult operationResult = args.getOperationResult();
            if (operationResult != null) {
                operationResult.setShowMessage(false);
            }
            this.getView().getPageCache().remove("isInvokeOperation");
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            String isNotRefresh = this.getView().getPageCache().get(NOT_REFRESH_FROM_SUBMIT);
            if (!"true".equals(isNotRefresh)) {
                // empty if block
            }
            this.getView().getPageCache().put(NOT_REFRESH_FROM_SUBMIT, "");
        }
    }

    protected void invokeSaveOp() {
        this.getView().getPageCache().put("isInvokeOperation", "true");
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("IS_NOT_SHOW_TASK_VALIDATE_TIPS", "true");
        this.getView().invokeOperation("save", option);
    }
}

