/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.Pair;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.ActEvalObjDetailEdit;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.extpoint.IEvaluateObjDetailPreOpenService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.extpoint.impl.EvaluateObjDetailPreOpenService;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;

public class ActEvalObjDetailMsgPlugin
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(ActEvalObjDetailEdit.class);
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter parameter = e.getFormShowParameter();
        EvaluateObjDetailPreOpenService iService = new EvaluateObjDetailPreOpenService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iService, IEvaluateObjDetailPreOpenService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.evaluate.extpoint.IEvaluateObjDetailPreOpenService#verifyPreOpenForm", null);
        List result = hrPluginProxy.callReplaceIfPresent(p -> p.verifyPreOpenForm(parameter));
        boolean verifyResult = false;
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            verifyResult = result.stream().allMatch(obj -> obj);
        }
        if (!verifyResult) {
            Object batchTaskIdObj = parameter.getCustomParam("batchTaskId");
            parameter.setHasRight(true);
            if (!ObjectUtils.isEmpty((Object)batchTaskIdObj)) {
                Long batchTaskId = Long.parseLong((String)batchTaskIdObj);
                List<Map<String, Object>> taskList = this.getTaskList(batchTaskId);
                if (ObjectUtils.isEmpty(taskList)) {
                    List<Map<String, Object>> expiredTaskList = this.getExpiredTaskList(parameter);
                    if (ObjectUtils.isEmpty(expiredTaskList)) {
                        e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5904\u7406\u4eba\u3002", (String)"ActEvalObjDetailMsgPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    } else {
                        e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ActEvalObjDetailMsgPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    }
                    e.setCancel(true);
                    return;
                }
                List taskIdList = taskList.stream().map(task -> (Long)task.get("taskId")).collect(Collectors.toList());
                ArrayList<Object> validateAllList = new ArrayList<Object>(10);
                for (Long tid : taskIdList) {
                    Pair checkResult = APP_SERVICE.checkTaskInfo(tid);
                    validateAllList.add(checkResult.getKey());
                }
                if (!validateAllList.contains(Boolean.TRUE)) {
                    e.setCancel(true);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ActEvalObjDetailMsgPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private List<Map<String, Object>> getExpiredTaskList(FormShowParameter parameter) {
        Object batchTaskIdObj = parameter.getCustomParam("batchTaskId");
        if (batchTaskIdObj != null) {
            Long batchTaskId = Long.parseLong((String)batchTaskIdObj);
            QFilter taskStatusFilter = new QFilter("taskstatus", "in", Collections.singletonList(FlowRuTaskStatusEnum.EXPIRED.getCode()));
            return APP_SERVICE.getBatchTaskList(batchTaskId, taskStatusFilter);
        }
        return new ArrayList<Map<String, Object>>(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        try (TXHandle tx = TX.required();){
            IFormView evalView;
            String evalPageId = this.getView().getPageCache().get("epa_actevalobj_eval_page_id");
            if (!HRStringUtils.isBlank((CharSequence)evalPageId) && (evalView = this.getView().getView(evalPageId)) != null) {
                OperationStatus status = evalView.getFormShowParameter().getStatus();
                if (evalView.getModel().isDataLoaded() && OperationStatus.VIEW != status) {
                    evalView.getPageCache().put("isInvokeOperation", "true");
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", "true");
                    option.setVariableValue("IS_NOT_SHOW_TASK_VALIDATE_TIPS", "true");
                    option.setVariableValue("BACKEN_SAVE", "true");
                    evalView.invokeOperation("save", option);
                }
            }
        }
    }

    private List<Map<String, Object>> getTaskList(Long batchTaskId) {
        QFilter taskStatusFilter = new QFilter("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
        taskStatusFilter.and("handler", "=", (Object)RequestContext.get().getCurrUserId());
        LOG.info("ActEvalObjDetailMsgPlugin getTaskList current user id\uff1a{}", (Object)RequestContext.get().getCurrUserId());
        List batchTaskList = FLOW_RU_SECOND_DOMAIN_SERVICE.getBatchTaskDetails(batchTaskId, taskStatusFilter);
        LOG.info("ActEvalObjDetailMsgPlugin getTaskList taskStatusFilter\uff1a{}", (Object)taskStatusFilter.toString());
        Map<String, List<Map>> taskUnicodeMap = batchTaskList.stream().collect(Collectors.groupingBy(obj -> (String)obj.get("taskUnicode")));
        ArrayList<Map<String, Object>> mergeTaskList = new ArrayList<Map<String, Object>>(10);
        for (Map.Entry<String, List<Map>> entry : taskUnicodeMap.entrySet()) {
            List<Map> taskUnicodeList = entry.getValue();
            Map<String, List> taskStatusMap = taskUnicodeList.stream().collect(Collectors.groupingBy(obj -> {
                String taskStatus = (String)obj.get("taskStatus");
                FlowRuTaskStatusEnum flowRuTaskStatusEnum = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatus);
                switch (flowRuTaskStatusEnum) {
                    case WAITING: 
                    case PROCESSING: {
                        return FlowRuTaskStatusEnum.PROCESSING.getCode();
                    }
                    case PROCESSED: {
                        return FlowRuTaskStatusEnum.PROCESSED.getCode();
                    }
                    case RETURNED: {
                        return FlowRuTaskStatusEnum.RETURNED.getCode();
                    }
                }
                return taskStatus;
            }, Collectors.mapping(Function.identity(), Collectors.collectingAndThen(Collectors.toList(), list -> {
                list.sort(Comparator.comparing(obj -> (String)obj.get("taskStatus")));
                return list;
            }))));
            for (Map.Entry<String, List> taskStatusEntry : taskStatusMap.entrySet()) {
                Map<String, Object> mergeMap = new HashMap<String, Object>(16);
                List<Map> taskStatusList = entry.getValue();
                for (Map tMap : taskStatusList) {
                    mergeMap = this.mergeMaps(mergeMap, tMap);
                }
                mergeTaskList.add(mergeMap);
            }
        }
        return mergeTaskList;
    }

    private Map<String, Object> mergeMaps(Map<String, Object> map1, Map<String, Object> map2) {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>(map1);
        Long taskId = (Long)map2.get("taskId");
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (HRStringUtils.equals((String)key, (String)"taskId")) {
                ArrayList<Long> mTaskIdList = (ArrayList<Long>)mergedMap.get("mergeTaskIds");
                if (mTaskIdList == null) {
                    mTaskIdList = new ArrayList<Long>(10);
                }
                mTaskIdList.add(taskId);
                mergedMap.put("mergeTaskIds", mTaskIdList);
            }
            if (HRStringUtils.equals((String)key, (String)"indicatorColl")) {
                Map<Long, List<Long>> areaRegIndicaMap;
                HashMap<Long, Map<Long, List<Long>>> mergeTaskInds = (HashMap<Long, Map<Long, List<Long>>>)mergedMap.get("mergeTaskInds");
                if (mergeTaskInds == null) {
                    mergeTaskInds = new HashMap<Long, Map<Long, List<Long>>>(16);
                }
                if ((areaRegIndicaMap = this.getAreaIndMap(map2)) != null) {
                    mergeTaskInds.put(taskId, areaRegIndicaMap);
                    mergedMap.put("mergeTaskInds", mergeTaskInds);
                }
            }
            mergedMap.put(key, value);
        }
        return mergedMap;
    }

    private Map<Long, List<Long>> getAreaIndMap(Map<String, Object> taskMap) {
        HashMap<Long, ArrayList<Long>> areaRegIndicaMap = null;
        DynamicObjectCollection indicatorColl = (DynamicObjectCollection)taskMap.get("indicatorColl");
        if (indicatorColl != null) {
            areaRegIndicaMap = new HashMap<Long, ArrayList<Long>>(16);
            for (DynamicObject indicatorObj : indicatorColl) {
                Long indicatorId = indicatorObj.getLong("indicatorid");
                Long arearegId = indicatorObj.getLong("arearegid");
                ArrayList<Long> indIdList = (ArrayList<Long>)areaRegIndicaMap.get(arearegId);
                if (indIdList == null) {
                    indIdList = new ArrayList<Long>(10);
                }
                indIdList.add(indicatorId);
                areaRegIndicaMap.put(arearegId, indIdList);
            }
        }
        return areaRegIndicaMap;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)"refresh", (String)operateKey)) {
            this.getView().updateView();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object batchTaskId = formShowParameter.getCustomParam("batchTaskId");
        if (!ObjectUtils.isEmpty((Object)batchTaskId)) {
            Long aLong = Long.valueOf((String)batchTaskId);
            List<Long> ids = Collections.singletonList(aLong);
            List<Map<String, Object>> batchTaskDetaiList = this.getTaskList(aLong);
            if (ObjectUtils.isEmpty(batchTaskDetaiList)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548", (String)"ActEvalObjDetailMsgPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.getView().close();
                return;
            }
            if (batchTaskDetaiList.size() == 1) {
                Long taskId = batchTaskDetaiList.get(0).get("taskId") == null ? Long.valueOf(0L) : (Long)batchTaskDetaiList.get(0).get("taskId");
                Map selectedTaskMap = batchTaskDetaiList.stream().filter(obj -> taskId.equals((Long)obj.get("taskId"))).findFirst().orElse(null);
                if (selectedTaskMap != null) {
                    List mergeTaskIds = (List)selectedTaskMap.get("mergeTaskIds");
                    Map mergeTaskInds = (Map)selectedTaskMap.get("mergeTaskInds");
                    BaseShowParameter show = new BaseShowParameter();
                    show.setFormId("epa_actevalobj_eval");
                    show.setPkId(batchTaskDetaiList.get(0).get("actEvaObjId"));
                    show.setCustomParam("taskId", (Object)taskId.toString());
                    show.setCustomParam("isCrossEvaluate", batchTaskDetaiList.get(0).get("iscrossevaluate"));
                    show.setCustomParam("mergeTaskIds", (Object)JSON.toJSONString((Object)mergeTaskIds));
                    show.setCustomParam("mergeTaskInds", (Object)JSON.toJSONString((Object)mergeTaskInds));
                    show.getOpenStyle().setShowType(ShowType.InContainer);
                    show.getOpenStyle().setTargetKey("actevalobj_evalap");
                    show.setHasRight(true);
                    this.getView().showForm((FormShowParameter)show);
                }
            } else {
                FormShowParameter show = new FormShowParameter();
                show.setFormId("epa_actevalobj_eval_multi");
                Object mask = formShowParameter.getCustomParam("mask");
                if (!ObjectUtils.isEmpty((Object)mask)) {
                    Long maskId = Long.valueOf((String)mask);
                    show.setCustomParam("maskId", (Object)maskId);
                }
                show.setCustomParam("batchTaskId", batchTaskId);
                show.getOpenStyle().setShowType(ShowType.InContainer);
                show.getOpenStyle().setTargetKey("actevalobj_evalap");
                show.setHasRight(true);
                this.getView().showForm(show);
            }
        }
    }
}

