/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.evaloverall.ActEvalObjOverallApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.evaluating.entity.ContentFieldEntryEvaDto;
import kd.opmc.epa.formplugin.web.activitymanage.process.ActivityJobForm;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileEntityService;

public class ActEvalObjMultiPlugin
extends HRDataBaseEdit
implements RowClickEventListener {
    private static final String CHILDREN_PAGE = "children_page";
    private static final String CHILDREN_OBJ_ID = "children_objid";
    private static final String HAVE_FILTER_AP = "havefilterap";
    private static final String BTN_CANCEL = "btncancel";
    private static final String SELECT_CHECK_AP = "selectcheckap";
    private static final String BATCH_AP = "batchap";
    private static final String BATCH = "batch";
    private static final String BTN_BATCH = "btnbatch";
    private static final String CANCE = "cance";
    private static final String CUSTOMCONTROLAP = "customcontrolap";
    private static final String ORDERCONTROLAP = "ordercontrolap";
    private static final String ADMINORG = "adminorg";
    private static final String POSITION = "position";
    private static final String PERSON = "person";
    private static final String PERSONId = "personId";
    private static final String EVALSTATUS = "evalstatus";
    private static final String ORDERWAY = "orderway";
    private static final String ORDERSORT = "ordersort";
    private static final String REFRESH_ENTRY = "refresh_entry";
    private static final String REFRESH = "refresh";
    private static final String APP_ID = "epa";
    private static final String SUBMIT_TASK_CLOSE_BACK = "submit_task_close_back";
    private static final String SUBMIT_TASK_CLAZZ = "kd.opmc.epa.business.task.SubmitBatchEvalObjTask";
    private static final String EPA_BATCHREJECT = "epa_batchreject";
    private static final String TASK_ID_LIST = "taskIdList";
    private static final String EPA_EVALOBJ_REJECT = "epa_evalobj_reject";
    private static final String ISEMPTYPAGE = "isEmptyPage";
    private static final String SINGLEPERSONAP = "singlepersonap";
    private static final String PREVORDERWAY = "prevOrderway";
    private static final String PREVORDERSORT = "prevOrdersort";
    private static final String PREVADMINORG = "prevAdminorg";
    private static final String PREVPOSITION = "prevPosition";
    private static final String PREVPERSON = "prevPerson";
    private static final String PREVEVALSTATUS = "prevEvalstatus";
    private static final String BUTTONAP = "buttonap";
    private static final String FAIL_PROCESSED_KEY = "processed";
    private static final String FAIL_RETURNED_KEY = "returned";
    private static final String FAIL_EXPIRED_KEY = "expired";
    private static final String OSE = "ose";
    private static final String OLE = "ole";
    private static final String IS_SHOW_ASSESSSTATUS = "isshowassessstatus";
    private static final String IS_SHOW_OSE = "isshowose";
    private static final String IS_SHOW_OLE = "isshowole";
    private static final String ASSESSSTATUSLAP = "assessstatuslap";
    private static final String OSEAP = "oseap";
    private static final String OLEAP = "oleap";
    private static final String IS_DISPLAYOSE_BYPERM = "isDisplayOseByPerm";
    private static final String IS_DISPLAYOLE_BYPERM = "isDisplayOleByPerm";
    private static final String IS_CROSSEVALUATE = "iscrossevaluate";
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final ActivityEvaluationObjectApplicationService APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final PerffileEntityService PERFFILE_ENTITY_SERVICE = PerffileEntityService.getInstance();
    private static final ActEvalObjOverallApplicationService APPEVALOBJOVER_SERVICE = ActEvalObjOverallApplicationService.getInstance();
    private static final ActEvalObjOverallApplicationService ACT_EVAL_OBJ_OVERALL_APPLICATION_SERVICE = ActEvalObjOverallApplicationService.getInstance();
    private static final Log LOG = LogFactory.getLog(ActEvalObjMultiPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"showleft"});
        this.initPersonCart(true);
        this.showFilterFrom();
        this.showOrderForm();
    }

    private void initPersonCart(boolean isInit) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String batchTaskId = (String)formShowParameter.getCustomParam("batchTaskId");
        Long aLong = Long.valueOf(batchTaskId);
        List<Map<String, Object>> allbatchTaskDetaiList = this.getTaskList(aLong);
        if (ObjectUtils.isEmpty(allbatchTaskDetaiList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548", (String)"ActEvalObjMultiPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        List taskIds = allbatchTaskDetaiList.stream().map(allbatchTask -> (Long)allbatchTask.get("taskId")).collect(Collectors.toList());
        DynamicObject[] sumAreaEvalRecordObjs = APP_SERVICE.querySumAreaEvalRecordByTaskIds(taskIds);
        if (allbatchTaskDetaiList.size() > 0) {
            this.setAssessformCache(allbatchTaskDetaiList);
            this.setOseAndOleDisplayCache(allbatchTaskDetaiList);
        }
        if (isInit) {
            this.setInitCache(allbatchTaskDetaiList);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCEL, SELECT_CHECK_AP, BATCH_AP});
        List actEvaObjId = allbatchTaskDetaiList.stream().map(map -> (Long)map.get("actEvaObjId")).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id,perffile,perffile.adminorg,perffile.position,affiliateadminorg,person,empposrel,empposrel.position,empposrel.job", new QFilter[]{new QFilter("id", "in", actEvaObjId)});
        for (int i = 0; i < allbatchTaskDetaiList.size(); ++i) {
            Long id = (Long)allbatchTaskDetaiList.get(i).get("actEvaObjId");
            String personNum = "";
            for (int j = 0; j < dynamicObjects.length; ++j) {
                if (dynamicObjects[j].getLong("id") != id.longValue() || dynamicObjects[j].get("person.number") == null) continue;
                personNum = dynamicObjects[j].get("person.number").toString();
            }
            allbatchTaskDetaiList.get(i).put("personNum", personNum);
        }
        List<String> processingCode = Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode());
        List<Map<String, Object>> batchTaskDetaiList = allbatchTaskDetaiList.stream().sorted(Comparator.comparing(o -> Integer.parseInt(o.get("taskStatus").toString())).thenComparing(o -> o.get("personNum").toString())).filter(s -> processingCode.contains(s.get("taskStatus").toString())).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(batchTaskDetaiList)) {
            batchTaskDetaiList = allbatchTaskDetaiList.stream().sorted(Comparator.comparing(o -> Integer.parseInt(o.get("taskStatus").toString())).thenComparing(o -> o.get("personNum").toString())).collect(Collectors.toList());
            this.getPageCache().put("isShowAll", "true");
            this.getPageCache().put(PREVEVALSTATUS, null);
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BATCH, HAVE_FILTER_AP});
        } else {
            this.getPageCache().put("isShowAll", "false");
            this.getPageCache().put(PREVEVALSTATUS, "20,30");
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_BATCH});
        }
        HashMap actEvalObjMaps = new HashMap();
        Arrays.asList(dynamicObjects).stream().forEach(obj -> actEvalObjMaps.put(obj.getLong("id"), obj));
        this.getView().setVisible(Boolean.TRUE, new String[]{"personcartentity"});
        IDataModel model = this.getModel();
        model.deleteEntryData("personcartentity");
        batchTaskDetaiList = this.getMovedBatchTaskList(batchTaskDetaiList);
        model.batchCreateNewEntryRow("personcartentity", batchTaskDetaiList.size());
        int curIndex = 0;
        for (int index = 0; index < batchTaskDetaiList.size(); ++index) {
            Map<String, Object> batchMap = batchTaskDetaiList.get(index);
            if (batchMap == null) continue;
            Object iscrossevaluate = batchMap.get(IS_CROSSEVALUATE);
            if (iscrossevaluate != null) {
                this.getPageCache().put(IS_CROSSEVALUATE, iscrossevaluate.toString());
            }
            Long taskId = (Long)batchMap.get("taskId");
            DynamicObject actEvaLObj = (DynamicObject)actEvalObjMaps.get(batchTaskDetaiList.get(index).get("actEvaObjId"));
            if (actEvaLObj == null) {
                LOG.info("actEvalObjMaps:{} ,batchTaskDetaiList:{}", actEvalObjMaps, batchTaskDetaiList);
                continue;
            }
            List mergeTaskIdList = (List)batchTaskDetaiList.get(index).get("mergeTaskIds");
            String mergeTaskIds = mergeTaskIdList.stream().map(obj -> obj.toString()).collect(Collectors.joining(","));
            model.setValue(PERSON, (Object)actEvaLObj.getLong("person.id"), curIndex);
            model.setValue("personnamelab", (Object)actEvaLObj.getString("person.name"), curIndex);
            long objId = actEvaLObj.getLong("id");
            model.setValue("evalobj", (Object)objId, curIndex);
            model.setValue("taskid", (Object)taskId, curIndex);
            String taskStatusStr = (String)batchMap.get("taskStatus");
            String taskStatus = this.getAssessStatus(taskStatusStr);
            model.setValue("status", (Object)taskStatusStr, curIndex);
            model.setValue("mergetaskids", (Object)mergeTaskIds, curIndex);
            model.setValue("headsculpture", (Object)HRImageUrlUtil.getImageFullUrl((String)String.valueOf(actEvaLObj.getString("person.headsculpture"))), curIndex);
            boolean isRollBacked = (Boolean)batchTaskDetaiList.get(index).get("isrollbacked");
            if (isRollBacked) {
                this.setOseAndOle(sumAreaEvalRecordObjs, taskId, model, curIndex);
            } else {
                model.setValue(IS_SHOW_ASSESSSTATUS, (Object)"1", curIndex);
            }
            model.setValue("assessstatuslab", (Object)taskStatus, curIndex);
            ++curIndex;
        }
        this.getView().updateView("personcartentity");
        this.setBatch("0");
        this.selectPerson(0);
    }

    private List<Map<String, Object>> getMovedBatchTaskList(List<Map<String, Object>> batchTaskDetaiList) {
        int movedRow = 0;
        Long maskId = 0L;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object mask = formShowParameter.getCustomParam("maskId");
        if (!HRObjectUtils.isEmpty((Object)mask)) {
            maskId = (Long)mask;
            Map<String, Object> moveToFirstTask = null;
            for (int index = 0; index < batchTaskDetaiList.size(); ++index) {
                Map<String, Object> batchTaskMap = batchTaskDetaiList.get(index);
                Long actEvaObjId = (Long)batchTaskMap.get("actEvaObjId");
                if (!maskId.equals(actEvaObjId)) continue;
                moveToFirstTask = batchTaskMap;
                movedRow = index;
            }
            if (movedRow != 0) {
                batchTaskDetaiList.remove(movedRow);
                batchTaskDetaiList.add(0, moveToFirstTask);
            }
        }
        return batchTaskDetaiList;
    }

    private void setOseAndOle(DynamicObject[] sumAreaEvalRecordObjs, Long taskId, IDataModel model, int index) {
        model.setValue(IS_SHOW_ASSESSSTATUS, (Object)"1", index);
        model.setValue(IS_SHOW_OSE, (Object)"0", index);
        model.setValue(IS_SHOW_OLE, (Object)"0", index);
        if (!HRObjectUtils.isEmpty((Object)sumAreaEvalRecordObjs) && sumAreaEvalRecordObjs.length > 0) {
            IPageCache pageCache = this.getPageCache();
            if (pageCache.get("ruleid") == null) {
                return;
            }
            String perfLevelItemsStr = pageCache.get("perfLevelItems");
            List perfLevelItems = null;
            if (perfLevelItemsStr != null) {
                perfLevelItems = JSON.parseArray((String)perfLevelItemsStr, ComboItem.class);
            }
            String numAccuracy = pageCache.get("numaccuracy");
            String scaleType = pageCache.get("scaletype");
            String iscrossevaluate = pageCache.get(IS_CROSSEVALUATE);
            for (int i = 0; i < sumAreaEvalRecordObjs.length; ++i) {
                DynamicObject sumAreaEvalRecordObj = sumAreaEvalRecordObjs[i];
                long sumAreaEvalRecordTaskId = sumAreaEvalRecordObj.getLong("flowrutask.id");
                if (taskId != sumAreaEvalRecordTaskId) continue;
                String taskstatus = sumAreaEvalRecordObj.getString("flowrutask.taskstatus");
                String taskStatusStr = this.getAssessStatus(taskstatus);
                model.setValue("status", (Object)taskstatus, index);
                model.setValue("assessstatuslab", (Object)taskStatusStr, index);
                if (HRStringUtils.equals((String)taskstatus, (String)FlowRuTaskStatusEnum.WAITING.getCode()) || HRStringUtils.equals((String)taskstatus, (String)FlowRuTaskStatusEnum.PROCESSING.getCode()) || HRStringUtils.equals((String)taskstatus, (String)FlowRuTaskStatusEnum.PROCESSED.getCode())) {
                    String ole;
                    String oleShowText;
                    BigDecimal ose = sumAreaEvalRecordObj.getBigDecimal(OSE);
                    if (ose == null) continue;
                    model.setValue(OSE, (Object)ose.setScale(Integer.parseInt(numAccuracy), Integer.parseInt(scaleType)), index);
                    String isDisplayOseByPrem = pageCache.get(IS_DISPLAYOSE_BYPERM);
                    if (!HRObjectUtils.isEmpty((Object)ose) && HRStringUtils.equals((String)isDisplayOseByPrem, (String)"true") && HRStringUtils.equals((String)iscrossevaluate, (String)"false")) {
                        model.setValue(IS_SHOW_OSE, (Object)"1", index);
                        model.setValue(IS_SHOW_ASSESSSTATUS, (Object)"0", index);
                    }
                    if ((oleShowText = this.getOleShowText(perfLevelItems, ole = sumAreaEvalRecordObj.getString(OLE))) != null) {
                        model.setValue(OLE, (Object)("/ " + oleShowText), index);
                    }
                    String isDisplayOleByPrem = pageCache.get(IS_DISPLAYOLE_BYPERM);
                    if (HRStringUtils.isEmpty((String)ole) || !HRStringUtils.equals((String)isDisplayOleByPrem, (String)"true") || !HRStringUtils.equals((String)iscrossevaluate, (String)"false")) continue;
                    model.setValue(IS_SHOW_OLE, (Object)"1", index);
                    model.setValue(IS_SHOW_ASSESSSTATUS, (Object)"0", index);
                    continue;
                }
                model.setValue(IS_SHOW_OSE, (Object)"0", index);
                model.setValue(IS_SHOW_OLE, (Object)"0", index);
                model.setValue(IS_SHOW_ASSESSSTATUS, (Object)"1", index);
            }
        }
    }

    private Map<Long, ContentFieldEntryEvaDto> change2PermMap(List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        HashMap<Long, ContentFieldEntryEvaDto> filePermMap = new HashMap<Long, ContentFieldEntryEvaDto>(16);
        if (fieldEntryEvaDtos != null) {
            for (ContentFieldEntryEvaDto fieldEntryEvaDto : fieldEntryEvaDtos) {
                if (fieldEntryEvaDto == null) continue;
                filePermMap.put(fieldEntryEvaDto.getAreaFieldId(), fieldEntryEvaDto);
            }
        }
        return filePermMap;
    }

    private DynamicObject getAssessformDy(List<Map<String, Object>> allbatchTaskDetaiList) {
        Long activityId = (Long)allbatchTaskDetaiList.get(0).get("activity");
        DynamicObject activityObj = APP_SERVICE.queryActivityById(activityId);
        Long assessFormId = activityObj.getLong("assessform.id");
        DynamicObject assessformDy = APP_SERVICE.queryExecuteAssessForm(assessFormId.longValue());
        return assessformDy;
    }

    private void setAssessformCache(List<Map<String, Object>> allbatchTaskDetaiList) {
        DynamicObject assessFormDy = this.getAssessformDy(allbatchTaskDetaiList);
        Object rule = assessFormDy.getPkValue();
        if (rule != null) {
            Long ruleId = (Long)rule;
            this.getPageCache().put("ruleid", ruleId.toString());
            this.setPerfLevelItemsCache(ruleId);
        }
        String numAccuracy = assessFormDy.getString("numaccuracy") == null ? "2" : assessFormDy.getString("numaccuracy");
        this.getPageCache().put("numaccuracy", numAccuracy);
        String scaleTypeStr = assessFormDy.getString("scaletype");
        int scaleType = ScalaTypeEnum.get((String)scaleTypeStr).getType();
        this.getPageCache().put("scaletype", String.valueOf(scaleType));
        this.getPageCache().put("sumconf", assessFormDy.getString("sumconf"));
        this.getPageCache().put("sumperflevel", assessFormDy.getString("sumperflevel.id"));
    }

    private void setPerfLevelItemsCache(Long ruleId) {
        if (ruleId != null) {
            List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(ruleId);
            this.getPageCache().put("perfLevelItems", JSON.toJSONString((Object)perfLevelItems));
        }
    }

    private void setOseAndOleDisplayCache(List<Map<String, Object>> allbatchTaskDetaiList) {
        Long taskId = (Long)allbatchTaskDetaiList.get(0).get("taskId");
        Map permissionMap = ACT_EVAL_OBJ_OVERALL_APPLICATION_SERVICE.querySumPermMap(taskId);
        IPageCache pageCache = this.getView().getPageCache();
        Map oseMap = (Map)permissionMap.get(OSE);
        if (oseMap != null && !oseMap.isEmpty()) {
            Boolean oleDisplayItem = (Boolean)oseMap.get("fielddisplayitem");
            if (oleDisplayItem.booleanValue()) {
                pageCache.put(IS_DISPLAYOSE_BYPERM, "true");
            } else {
                pageCache.put(IS_DISPLAYOSE_BYPERM, "false");
            }
        } else {
            pageCache.put(IS_DISPLAYOSE_BYPERM, "false");
        }
        Map oleMap = (Map)permissionMap.get(OLE);
        if (oleMap != null && !oleMap.isEmpty()) {
            Boolean oleDisplayItem = (Boolean)oleMap.get("fielddisplayitem");
            if (oleDisplayItem.booleanValue()) {
                pageCache.put(IS_DISPLAYOLE_BYPERM, "true");
            } else {
                pageCache.put(IS_DISPLAYOLE_BYPERM, "false");
            }
        } else {
            pageCache.put(IS_DISPLAYOLE_BYPERM, "false");
        }
    }

    private String getOleShowText(List<ComboItem> perfLevelItems, String ole) {
        if (perfLevelItems != null) {
            for (ComboItem perfLevelItem : perfLevelItems) {
                LocaleString caption;
                if (perfLevelItem == null) continue;
                String perfLevelItemValue = perfLevelItem.getValue();
                if (ole == null || !ole.equals(perfLevelItemValue) || (caption = perfLevelItem.getCaption()) == null) continue;
                return caption.getLocaleValue();
            }
        }
        return null;
    }

    private List<Map<String, Object>> getTaskList(Long batchTaskId) {
        QFilter taskStatusFilter = new QFilter("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
        taskStatusFilter.and("handler", "=", (Object)RequestContext.get().getCurrUserId());
        List batchTaskList = FLOW_RU_SECOND_DOMAIN_SERVICE.getBatchTaskDetails(batchTaskId, taskStatusFilter);
        Map<String, List<Map>> taskUnicodeMap = batchTaskList.stream().collect(Collectors.groupingBy(obj -> (String)obj.get("taskUnicode")));
        ArrayList<Map<String, Object>> mergeTaskList = new ArrayList<Map<String, Object>>(10);
        for (Map.Entry<String, List<Map>> entry : taskUnicodeMap.entrySet()) {
            List<Map> taskUnicodeList = entry.getValue();
            Map<String, List> taskStatusMap = taskUnicodeList.stream().collect(Collectors.groupingBy(obj -> {
                String taskStatus = (String)obj.get("taskStatus");
                FlowRuTaskStatusEnum flowRuTaskStatusEnum = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatus);
                switch (flowRuTaskStatusEnum) {
                    case WAITING: 
                    case PROCESSING: {
                        return FlowRuTaskStatusEnum.PROCESSING.getCode();
                    }
                    case PROCESSED: {
                        return FlowRuTaskStatusEnum.PROCESSED.getCode();
                    }
                    case RETURNED: {
                        return FlowRuTaskStatusEnum.RETURNED.getCode();
                    }
                }
                return taskStatus;
            }, Collectors.mapping(Function.identity(), Collectors.collectingAndThen(Collectors.toList(), list -> {
                list.sort(Comparator.comparing(obj -> (String)obj.get("taskStatus")));
                return list;
            }))));
            for (Map.Entry<String, List> taskStatusEntry : taskStatusMap.entrySet()) {
                Map<String, Object> mergeMap = new HashMap<String, Object>(16);
                List taskStatusList = taskStatusEntry.getValue();
                for (Map tMap : taskStatusList) {
                    mergeMap = this.mergeMaps(mergeMap, tMap);
                }
                mergeTaskList.add(mergeMap);
            }
        }
        return mergeTaskList;
    }

    private Map<String, Object> mergeMaps(Map<String, Object> map1, Map<String, Object> map2) {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>(map1);
        Long taskId = (Long)map2.get("taskId");
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (HRStringUtils.equals((String)key, (String)"taskId")) {
                ArrayList<Long> mTaskIdList = (ArrayList<Long>)mergedMap.get("mergeTaskIds");
                if (mTaskIdList == null) {
                    mTaskIdList = new ArrayList<Long>(10);
                }
                mTaskIdList.add(taskId);
                mergedMap.put("mergeTaskIds", mTaskIdList);
            }
            if (HRStringUtils.equals((String)key, (String)"indicatorColl")) {
                Map<Long, List<Long>> areaRegIndicaMap;
                HashMap<Long, Map<Long, List<Long>>> mergeTaskInds = (HashMap<Long, Map<Long, List<Long>>>)mergedMap.get("mergeTaskInds");
                if (mergeTaskInds == null) {
                    mergeTaskInds = new HashMap<Long, Map<Long, List<Long>>>(16);
                }
                if ((areaRegIndicaMap = this.getAreaIndMap(map2)) != null) {
                    mergeTaskInds.put(taskId, areaRegIndicaMap);
                    mergedMap.put("mergeTaskInds", mergeTaskInds);
                }
            }
            mergedMap.put(key, value);
        }
        return mergedMap;
    }

    private Map<Long, List<Long>> getAreaIndMap(Map<String, Object> taskMap) {
        HashMap<Long, ArrayList<Long>> areaRegIndicaMap = null;
        DynamicObjectCollection indicatorColl = (DynamicObjectCollection)taskMap.get("indicatorColl");
        if (indicatorColl != null) {
            areaRegIndicaMap = new HashMap<Long, ArrayList<Long>>(16);
            for (DynamicObject indicatorObj : indicatorColl) {
                Long indicatorId = indicatorObj.getLong("indicatorid");
                Long arearegId = indicatorObj.getLong("arearegid");
                ArrayList<Long> indIdList = (ArrayList<Long>)areaRegIndicaMap.get(arearegId);
                if (indIdList == null) {
                    indIdList = new ArrayList<Long>(10);
                }
                indIdList.add(indicatorId);
                areaRegIndicaMap.put(arearegId, indIdList);
            }
        }
        return areaRegIndicaMap;
    }

    private void setInitCache(List<Map<String, Object>> allbatchTaskDetaiList) {
        IPageCache pageCache = this.getPageCache();
        this.setFilterCache(allbatchTaskDetaiList, pageCache);
        pageCache.put(PREVORDERWAY, "40");
        pageCache.put(PREVORDERSORT, "10");
        pageCache.put(PREVADMINORG, null);
        pageCache.put(PREVPOSITION, null);
        pageCache.put(PREVPERSON, null);
        pageCache.put(PREVEVALSTATUS, "20,30");
    }

    private void setFilterCache(List<Map<String, Object>> allbatchTaskDetaiList, IPageCache pageCache) {
        ArrayList<Long> orgId = new ArrayList<Long>(16);
        ArrayList<Long> positionId = new ArrayList<Long>(16);
        ArrayList<Long> personId = new ArrayList<Long>(16);
        List actEvaObjIds = allbatchTaskDetaiList.stream().map(map -> (Long)map.get("actEvaObjId")).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id,perffile,perffile.adminorg,perffile.position,affiliateadminorg,person,empposrel,empposrel.position,empposrel.job", new QFilter[]{new QFilter("id", "in", actEvaObjIds)});
        for (int index = 0; index < allbatchTaskDetaiList.size(); ++index) {
            Map<String, Object> batchMap = allbatchTaskDetaiList.get(index);
            if (batchMap == null) continue;
            Long actEvaObjId = (Long)batchMap.get("actEvaObjId");
            DynamicObject actEvaLObj = Arrays.stream(dynamicObjects).filter(dynamicObject -> dynamicObject.getLong("id") == actEvaObjId.longValue()).findFirst().orElse(null);
            if (actEvaLObj == null) continue;
            if (actEvaLObj.get("perffile.adminorg") != null) {
                orgId.add(actEvaLObj.getLong("perffile.adminorg.id"));
            }
            if (actEvaLObj.get("perffile.position") != null) {
                positionId.add(actEvaLObj.getLong("perffile.position.id"));
            }
            if (actEvaLObj.get("person.id") == null) continue;
            personId.add(actEvaLObj.getLong("person.id"));
        }
        pageCache.put("orgId", SerializationUtils.toJsonString(orgId));
        pageCache.put("positionId", SerializationUtils.toJsonString(positionId));
        pageCache.put(PERSONId, SerializationUtils.toJsonString(personId));
    }

    private void showFilterFrom() {
        String affIdsStr;
        String personIdStr;
        String positionIdStr;
        IPageCache pageCache = this.getPageCache();
        FormShowParameter showParameter = new FormShowParameter();
        String orgIdStr = pageCache.get("orgId");
        if (!StringUtils.isEmpty((String)orgIdStr)) {
            List orgIds = JSONObject.parseArray((String)orgIdStr, Long.class);
            showParameter.setCustomParam("orgId", (Object)orgIds);
        }
        if (!StringUtils.isEmpty((String)(positionIdStr = pageCache.get("positionId")))) {
            List positionIds = JSONObject.parseArray((String)positionIdStr, Long.class);
            showParameter.setCustomParam("positionId", (Object)positionIds);
        }
        if (!StringUtils.isEmpty((String)(personIdStr = pageCache.get(PERSONId)))) {
            List personIds = JSONObject.parseArray((String)personIdStr, Long.class);
            showParameter.setCustomParam(PERSONId, (Object)personIds);
        }
        if (!StringUtils.isEmpty((String)(affIdsStr = pageCache.get("affiliateadminorg")))) {
            List Ids = JSONObject.parseArray((String)affIdsStr, Long.class);
            showParameter.setCustomParam("affiliateadminorg", (Object)Ids);
        }
        this.showCustomForm(showParameter, "epa_evalobj_batchfilter", CUSTOMCONTROLAP, "filter_page");
    }

    private void showOrderForm() {
        FormShowParameter showParameter = new FormShowParameter();
        this.showCustomForm(showParameter, "epa_evalobj_order", ORDERCONTROLAP, "order_page");
    }

    private void showCustomForm(FormShowParameter showParameter, String formId, String customcontrolKey, String pageCacheKey) {
        showParameter.setFormId(formId);
        showParameter.setShowTitle(false);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(customcontrolKey);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("elementId", customcontrolKey + this.getView().getPageId());
        showParameter.getOpenStyle().setCustParam(customParams);
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
        this.getView().getPageCache().put(pageCacheKey, showParameter.getPageId());
    }

    private String getAssessStatus(String taskStatus) {
        if (HRStringUtils.isNotEmpty((String)taskStatus)) {
            FlowRuTaskStatusEnum flowRuTaskStatusEnum = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatus);
            switch (flowRuTaskStatusEnum) {
                case WAITING: {
                    return ResManager.loadKDString((String)"\u5f85\u8bc4\u4f30", (String)"ActEvalObjMultiPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                }
                case PROCESSING: {
                    return ResManager.loadKDString((String)"\u8bc4\u4f30\u4e2d", (String)"ActEvalObjMultiPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                }
                case PROCESSED: {
                    return ResManager.loadKDString((String)"\u5df2\u8bc4\u4f30", (String)"ActEvalObjMultiPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                }
                case EXPIRED: {
                    return ResManager.loadKDString((String)"\u5df2\u5931\u6548", (String)"ActEvalObjMultiPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                }
                case RETURNED: {
                    return ResManager.loadKDString((String)"\u5df2\u9000\u56de", (String)"ActEvalObjMultiPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                }
            }
        }
        return "";
    }

    private void setBatch(String value) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("personcartentity");
        for (int index = 0; index < entryEntity.size(); ++index) {
            model.setValue("batchselect", (Object)value, index);
        }
        this.getView().updateView("personcartentity");
    }

    private void selectPerson(int row) {
        this.getPageCache().put("selectedRowNum", String.valueOf(row));
        this.removeCacheArea();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("personcartentity");
        long taskId = ((DynamicObject)entryEntity.get(row)).getLong("taskid");
        DynamicObject taskInfo = APP_SERVICE.queryTaskInfo(Long.valueOf(taskId));
        String taskstatusStr = taskInfo.getString("taskstatus");
        if (HRStringUtils.equals((String)taskstatusStr, (String)"60")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u8bc4\u4f30\u4efb\u52a1\u5df2\u5931\u6548", (String)"ActEvalObjMultiPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{((DynamicObject)entryEntity.get(row)).getString("person.name")}));
            this.refreshBatchPersonCart();
        } else {
            if (HRStringUtils.equals((String)taskstatusStr, (String)FlowRuTaskStatusEnum.WAITING.getCode())) {
                taskstatusStr = "30";
            }
            for (int index = 0; index < entryEntity.size(); ++index) {
                model.setValue("select", (Object)"0", index);
            }
            model.setValue("select", (Object)"1", row);
            String taskstatus = this.getAssessStatus(taskstatusStr);
            model.setValue("status", (Object)taskstatusStr, row);
            model.setValue("assessstatuslab", (Object)taskstatus, row);
            this.showSingPerson(((DynamicObject)entryEntity.get(row)).getLong("evalobj.id"), ((DynamicObject)entryEntity.get(row)).getString("taskid"));
            this.getView().updateView("personcartentity");
        }
    }

    private void removeCacheArea() {
        List<String> cacheAreaKeys = this.getCacheAreaKeys();
        Map allPageCache = this.getPageCache().getAll();
        if (!HRObjectUtils.isEmpty((Object)allPageCache)) {
            for (Map.Entry pageCacheEntry : allPageCache.entrySet()) {
                String normAreaKey = (String)pageCacheEntry.getKey();
                if (!HRStringUtils.isNotEmpty((String)normAreaKey) || !cacheAreaKeys.contains(normAreaKey) && !normAreaKey.startsWith("NORMAREAMUST_") && !normAreaKey.startsWith("CUSTAREAMUST_") && !normAreaKey.startsWith("isAllImportIndicators_")) continue;
                allPageCache.put(normAreaKey, null);
            }
        }
    }

    private void showSingPerson(Long id, String taskId) {
        List<Map<String, Object>> batchTaskDetaiList;
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setPkId((Object)id);
        baseShowParameter.setCustomParam("taskId", (Object)taskId);
        String isBatch = this.getView().getParentView().getPageCache().get("is_batch");
        baseShowParameter.setCustomParam("is_batch", (Object)isBatch);
        baseShowParameter.setFormId("epa_actevalobj_eval");
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.getOpenStyle().setTargetKey(SINGLEPERSONAP);
        baseShowParameter.setHasRight(true);
        String batchTaskId = (String)this.getView().getFormShowParameter().getCustomParam("batchTaskId");
        Long aLong = 0L;
        if (!HRStringUtils.isBlank((CharSequence)batchTaskId)) {
            aLong = Long.valueOf(batchTaskId);
        }
        if ((batchTaskDetaiList = this.getTaskList(aLong)) != null) {
            Long taskIdLong = !HRStringUtils.isBlank((CharSequence)taskId) ? Long.valueOf(taskId) : Long.valueOf(0L);
            Map selectedTaskMap = batchTaskDetaiList.stream().filter(obj -> taskIdLong.equals((Long)obj.get("taskId"))).findFirst().orElse(null);
            if (selectedTaskMap != null) {
                List mergeTaskIds = (List)selectedTaskMap.get("mergeTaskIds");
                Map mergeTaskInds = (Map)selectedTaskMap.get("mergeTaskInds");
                baseShowParameter.setCustomParam("taskId", (Object)taskId);
                for (Map<String, Object> batchTaskDetail : batchTaskDetaiList) {
                    Long detailTaskId = batchTaskDetail.get("taskId") == null ? Long.valueOf(0L) : (Long)batchTaskDetail.get("taskId");
                    if (!detailTaskId.toString().equals(taskId)) continue;
                    baseShowParameter.setCustomParam("isCrossEvaluate", batchTaskDetail.get(IS_CROSSEVALUATE));
                    baseShowParameter.setCustomParam("mergeTaskIds", (Object)JSON.toJSONString((Object)mergeTaskIds));
                    baseShowParameter.setCustomParam("mergeTaskInds", (Object)JSON.toJSONString((Object)mergeTaskInds));
                }
            }
        }
        this.getView().showForm((FormShowParameter)baseShowParameter);
        this.getPageCache().put(CHILDREN_PAGE, baseShowParameter.getPageId());
        this.getPageCache().put(CHILDREN_OBJ_ID, String.valueOf(id));
        this.getPageCache().put("taskId", taskId);
        this.isHideChildrenSubmit();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container cardEntrySelect = (Container)this.getView().getControl("cardentryinfolap");
        cardEntrySelect.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"closeleft", "showleft", "closeleftvector", "showleftvector", "selectallap", SELECT_CHECK_AP, ASSESSSTATUSLAP, OSEAP, OLEAP});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        IPageCache pageCache = this.getPageCache();
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "cardentryinfolap": 
            case "assessstatuslap": 
            case "oseap": 
            case "oleap": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("personcartentity");
                int[] rows = entryGrid.getSelectRows();
                if (rows.length <= 0) break;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("personcartentity");
                Long taskId = ((DynamicObject)entryEntity.get(rows[0])).getLong("taskid");
                DynamicObject currTaskObj = APP_SERVICE.queryTaskInfo(taskId);
                if (currTaskObj == null) {
                    LOG.info("clickedTaskId:{}", (Object)taskId);
                    return;
                }
                String currTaskStatus = currTaskObj.getString("taskstatus");
                String preTaskIdStr = this.getPageCache().get("taskId");
                DynamicObject preTaskObj = APP_SERVICE.queryTaskInfo(Long.valueOf(preTaskIdStr));
                String prevTaskStatus = preTaskObj.getString("taskstatus");
                String currTaskIdStr = String.valueOf(taskId);
                if (currTaskIdStr.equals(preTaskIdStr)) break;
                this.canCelSplitPage();
                this.invokeSaveOp();
                String filterPage = pageCache.get("filter_page");
                Object evalStatusObj = null;
                if (HRStringUtils.isNotEmpty((String)filterPage)) {
                    IFormView filterView = this.getView().getView(filterPage);
                    evalStatusObj = filterView.getModel().getValue(EVALSTATUS);
                }
                String evalStatusStr = "";
                String[] evalStatusArr = new String[]{};
                if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(currTaskStatus)) {
                    this.refreshBatchPersonCart();
                    return;
                }
                if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(prevTaskStatus)) {
                    this.refreshBatchPersonCart();
                    entryEntity = this.getModel().getEntryEntity("personcartentity");
                    Optional<DynamicObject> selectOptional = entryEntity.stream().filter(obj -> taskId.equals(obj.getLong("taskid"))).findFirst();
                    int newIndex = selectOptional.map(arg_0 -> entryEntity.indexOf(arg_0)).orElse(-1);
                    if (newIndex != -1) {
                        this.selectPerson(newIndex);
                    }
                    return;
                }
                if (evalStatusObj != null) {
                    evalStatusStr = evalStatusObj.toString();
                    evalStatusArr = evalStatusStr.split(",");
                    if (!Arrays.asList(evalStatusArr).contains(currTaskStatus)) {
                        this.refreshBatchPersonCart();
                        return;
                    }
                    if (!Arrays.asList(evalStatusArr).contains(prevTaskStatus)) {
                        this.refreshBatchPersonCart();
                        entryEntity = this.getModel().getEntryEntity("personcartentity");
                        Optional<DynamicObject> selectOptional = entryEntity.stream().filter(obj -> taskId.equals(obj.getLong("taskid"))).findFirst();
                        int newIndex = selectOptional.map(arg_0 -> entryEntity.indexOf(arg_0)).orElse(-1);
                        if (newIndex != -1) {
                            this.selectPerson(newIndex);
                        }
                        return;
                    }
                }
                this.updateOseAndOle();
                this.selectPerson(rows[0]);
                this.updateOseAndOle();
                this.getView().updateView("personcartentity");
                break;
            }
            case "closeleft": 
            case "closeleftvector": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"leftap", "closeleft"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"showleft"});
                break;
            }
            case "showleft": 
            case "showleftvector": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"leftap", "closeleft"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"showleft"});
                break;
            }
            case "selectallap": {
                this.canCelSplitPage();
                this.selectAll();
                break;
            }
            case "selectcheckap": {
                this.canCelSplitPage();
                this.isSelectAll();
                break;
            }
        }
    }

    private void updateOseAndOle() {
        DynamicObject[] sumAreaEvalRecordObjs;
        IDataModel model = this.getModel();
        String selectedRowNumStr = this.getPageCache().get("selectedRowNum");
        int selectedRowNum = selectedRowNumStr == null ? 0 : Integer.parseInt(selectedRowNumStr);
        String taskId = this.getPageCache().get("taskId");
        if (taskId != null && !HRObjectUtils.isEmpty((Object)(sumAreaEvalRecordObjs = APP_SERVICE.querySumAreaEvalRecordByTaskIds(Collections.singletonList(Long.valueOf(taskId))))) && sumAreaEvalRecordObjs.length == 1) {
            this.setOseAndOle(sumAreaEvalRecordObjs, Long.valueOf(taskId), model, selectedRowNum);
        }
    }

    private void selectAll() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("personcartentity");
        for (int index = 0; index < entryEntity.size(); ++index) {
            model.setValue("selectcheck", model.getValue("selectall"), index);
        }
        this.getView().updateView("personcartentity");
    }

    private void selectAllFalse() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("personcartentity");
        for (int index = 0; index < entryEntity.size(); ++index) {
            model.setValue("selectcheck", (Object)Boolean.FALSE, index);
        }
        model.setValue("selectall", (Object)Boolean.FALSE);
        this.getView().updateView("personcartentity");
    }

    private void isSelectAll() {
        int checkNum = 0;
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("personcartentity");
        for (DynamicObject dynamicObject : entryEntity) {
            if (!dynamicObject.getBoolean("selectcheck")) continue;
            ++checkNum;
        }
        model.setValue("selectall", (Object)(checkNum == entryEntity.size() ? 1 : 0));
        this.getView().updateView("personcartentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        String currentShowTaskId = this.getView().getPageCache().get("taskId");
        String taskStatus = "";
        if (HRStringUtils.isNotEmpty((String)currentShowTaskId)) {
            Long taskId = Long.parseLong(currentShowTaskId);
            DynamicObjectCollection entryCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("personcartentity");
            Optional<DynamicObject> taskObjOptional = entryCollection.stream().filter(obj -> taskId.equals(obj.getLong("taskid"))).findFirst();
            if (taskObjOptional.isPresent()) {
                DynamicObject taskObj = taskObjOptional.get();
                taskStatus = taskObj.getString("status");
            }
        }
        if (HRStringUtils.equals((String)operateKey, (String)"filter_cancel")) {
            this.closeFilterView(CUSTOMCONTROLAP);
            this.closeFilterView(ORDERCONTROLAP);
            this.rollBackPrev();
        } else if (HRStringUtils.equals((String)operateKey, (String)"filter_confirm")) {
            if (!FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) {
                this.invokeSaveOp();
            }
            this.confirmFilter();
        } else if (HRStringUtils.equals((String)operateKey, (String)"order_confirm")) {
            if (!FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) {
                this.invokeSaveOp();
            }
            IPageCache pageCache = this.getPageCache();
            pageCache.put(ISEMPTYPAGE, "true");
            this.confirmOrder();
            pageCache.put(ISEMPTYPAGE, "false");
        } else if (HRStringUtils.equals((String)operateKey, (String)"assindsubmit")) {
            this.submitTask(args);
        } else if (HRStringUtils.equals((String)operateKey, (String)"reject")) {
            this.rejectTask();
        }
    }

    private void rollBackPrev() {
        IPageCache pageCache = this.getPageCache();
        String orderPage = pageCache.get("order_page");
        IFormView orderView = this.getView().getView(orderPage);
        orderView.getModel().setValue(ORDERWAY, (Object)pageCache.get(PREVORDERWAY));
        orderView.getModel().setValue(ORDERSORT, (Object)pageCache.get(PREVORDERSORT));
        String filterPage = pageCache.get("filter_page");
        IFormView filterView = this.getView().getView(filterPage);
        Object[] prevAdminOrgIds = this.getPrevIds(pageCache.get(PREVADMINORG));
        filterView.getModel().setValue(ADMINORG, (Object)prevAdminOrgIds);
        Object[] prevPositionIds = this.getPrevIds(pageCache.get(PREVPOSITION));
        filterView.getModel().setValue(POSITION, (Object)prevPositionIds);
        Object[] prevPersonIds = this.getPrevIds(pageCache.get(PREVPERSON));
        filterView.getModel().setValue(PERSON, (Object)prevPersonIds);
        filterView.getModel().setValue(EVALSTATUS, (Object)pageCache.get(PREVEVALSTATUS));
    }

    private Object[] getPrevIds(String prevVal) {
        if (prevVal == null) {
            return null;
        }
        List ids = (List)SerializationUtils.fromJsonString((String)prevVal, List.class);
        Object[] prevIds = new Object[ids.size()];
        for (int i = 0; i < prevIds.length; ++i) {
            prevIds[i] = ids.get(i);
        }
        return prevIds;
    }

    private void rejectTask() {
        this.invokeSaveOp();
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = billObj.getDynamicObjectCollection("personcartentity");
        boolean checkFlag = this.rejectValidate(dynamicObjectCollection);
        if (checkFlag) {
            List taskIdList = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.getBoolean("selectcheck")).map(dyc -> {
                String mergeTaskIds = dyc.getString("mergetaskids");
                ArrayList<Long> taskIds = new ArrayList<Long>(10);
                String[] mergeTaskIdArr = mergeTaskIds.split(",");
                for (int i = 0; i < mergeTaskIdArr.length; ++i) {
                    Long taskId = Long.parseLong(mergeTaskIdArr[i]);
                    taskIds.add(taskId);
                }
                return taskIds;
            }).collect(Collectors.toList());
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(EPA_BATCHREJECT);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(TASK_ID_LIST, (Object)JSON.toJSONString(taskIdList));
            showParameter.setHasRight(true);
            IPageCache pageCache = this.getPageCache();
            pageCache.put(ISEMPTYPAGE, "true");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EPA_EVALOBJ_REJECT));
            this.getView().showForm(showParameter);
        }
    }

    private Boolean rejectValidate(DynamicObjectCollection dynamicObjectCollection) {
        boolean checkFlag = true;
        List dynamicObjects = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.getBoolean("selectcheck")).collect(Collectors.toList());
        if (dynamicObjects.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"ActEvalObjMultiPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return false;
        }
        int notRejectNum = 0;
        for (DynamicObject dynamicObject2 : dynamicObjects) {
            if (HRStringUtils.equals((String)dynamicObject2.getString("status"), (String)FlowRuTaskStatusEnum.PROCESSING.getCode()) || HRStringUtils.equals((String)dynamicObject2.getString("status"), (String)FlowRuTaskStatusEnum.WAITING.getCode())) continue;
            ++notRejectNum;
        }
        if (notRejectNum == dynamicObjects.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9000\u56de\u5f85\u8bc4\u4f30\u548c\u8bc4\u4f30\u4e2d\u6570\u636e", (String)"ActEvalObjMultiPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            checkFlag = false;
        }
        return checkFlag;
    }

    private void submitTask(BeforeDoOperationEventArgs args) {
        Long taskId;
        DynamicObject taskObj;
        String taskStatus;
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = billObj.getDynamicObjectCollection("personcartentity");
        List<Long> objIds = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.getBoolean("selectcheck")).map(dyc -> dyc.getLong("evalobj.id")).collect(Collectors.toList());
        HashMap<Long, Long> taskMap = new HashMap<Long, Long>(16);
        HashMap<Long, String> mergeTaskMap = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject2 : dynamicObjectCollection) {
            if (!dynamicObject2.getBoolean("selectcheck")) continue;
            String mergeTaskIdStr = dynamicObject2.getString("mergetaskids");
            long taskId2 = dynamicObject2.getLong("taskid");
            taskMap.put(taskId2, dynamicObject2.getLong("evalobj.id"));
            mergeTaskMap.put(taskId2, dynamicObject2.getString("mergetaskids"));
        }
        if (ObjectUtils.isEmpty(taskMap.keySet())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"ActEvalObjMultiPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        List dynamicObjects = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.getBoolean("selectcheck")).collect(Collectors.toList());
        int notSubmitNum = 0;
        for (DynamicObject dynamicObject3 : dynamicObjects) {
            if (HRStringUtils.equals((String)dynamicObject3.getString("status"), (String)FlowRuTaskStatusEnum.PROCESSING.getCode()) || HRStringUtils.equals((String)dynamicObject3.getString("status"), (String)FlowRuTaskStatusEnum.WAITING.getCode())) continue;
            ++notSubmitNum;
        }
        if (notSubmitNum == dynamicObjects.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5f85\u8bc4\u4f30\u548c\u8bc4\u4f30\u4e2d\u6570\u636e", (String)"ActEvalObjMultiPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String taskIdStr = this.getPageCache().get("taskId");
        if (HRStringUtils.isNotEmpty((String)taskIdStr) && (HRStringUtils.equals((String)(taskStatus = (taskObj = APP_SERVICE.queryTaskInfo(taskId = Long.valueOf(taskIdStr))).getString("taskstatus")), (String)FlowRuTaskStatusEnum.WAITING.getCode()) || HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.PROCESSING.getCode()))) {
            this.invokeSaveOp();
        }
        this.batchSubmitTask(objIds, taskMap, mergeTaskMap);
    }

    private void invokeSaveOp() {
        Long taskId;
        DynamicObject taskObj;
        String taskIdStr = this.getPageCache().get("taskId");
        if (HRStringUtils.isNotEmpty((String)taskIdStr) && !HRObjectUtils.isEmpty((Object)(taskObj = APP_SERVICE.queryTaskInfo(taskId = Long.valueOf(taskIdStr))))) {
            String taskStatus = taskObj.getString("taskstatus");
            if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)taskStatus) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSING.getCode(), (String)taskStatus)) {
                String pageId = this.getPageCache().get(CHILDREN_PAGE);
                IFormView view = this.getView().getView(pageId);
                if (!ObjectUtils.isEmpty((Object)view)) {
                    view.getPageCache().put("isInvokeOperation", "true");
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", "true");
                    option.setVariableValue("IS_NOT_SHOW_TASK_VALIDATE_TIPS", "true");
                    option.setVariableValue("BACKEN_SAVE", "true");
                    view.invokeOperation("save", option);
                }
            }
        }
    }

    private void batchSubmitTask(List<Long> objIds, Map<Long, Long> taskMap, Map<Long, String> mergeTaskMap) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(APP_ID);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(SUBMIT_TASK_CLAZZ);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("evaluationObjectIds", SerializationUtils.serializeToBase64(objIds));
        params.put("taskMap", SerializationUtils.serializeToBase64(taskMap));
        HashMap<Object, Object> mustInputFieldsMap = this.getMustInputFieldsMap();
        params.put("mustInputFields", SerializationUtils.serializeToBase64(mustInputFieldsMap));
        String currentShowTaskId = this.getView().getPageCache().get("taskId");
        params.put("currentShowTaskId", SerializationUtils.serializeToBase64((Object)currentShowTaskId));
        HashMap<String, Object> isAllImportIndicatorsMap = this.getIsAllImportIndicatorsMap();
        params.put("isAllImportIndicators", SerializationUtils.serializeToBase64(isAllImportIndicatorsMap));
        params.put("mergeTaskMap", SerializationUtils.serializeToBase64(mergeTaskMap));
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SUBMIT_TASK_CLOSE_BACK);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u7ee9\u6548\u8bc4\u4f30", (String)"ActEvalObjMultiPlugin_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(false);
        jobFormInfo.setCanStop(false);
        ActivityJobForm.dispatch(jobFormInfo, this.getView());
    }

    private HashMap<Object, Object> getMustInputFieldsMap() {
        HashMap<Object, Object> mustInputFieldsMap = new HashMap<Object, Object>(16);
        List<String> cacheAreaKeys = this.getCacheAreaKeys();
        for (String cacheAreaKey : cacheAreaKeys) {
            String mustInputFieldsStr = this.getPageCache().get(cacheAreaKey);
            if (mustInputFieldsStr == null) continue;
            List mustInputFields = (List)JSON.parseObject((String)mustInputFieldsStr, List.class);
            mustInputFieldsMap.put(cacheAreaKey, mustInputFields);
        }
        Map allPageCache = this.getPageCache().getAll();
        if (!HRObjectUtils.isEmpty((Object)allPageCache)) {
            for (Map.Entry pageCacheEntry : allPageCache.entrySet()) {
                String normAreaValue;
                String normAreaKey = (String)pageCacheEntry.getKey();
                if (!HRStringUtils.isNotEmpty((String)normAreaKey) || !normAreaKey.startsWith("NORMAREAMUST_") && !normAreaKey.startsWith("CUSTAREAMUST_") || !HRStringUtils.isNotEmpty((String)(normAreaValue = (String)pageCacheEntry.getValue()))) continue;
                List normAreaMustInputFields = (List)JSON.parseObject((String)normAreaValue, List.class);
                mustInputFieldsMap.put(normAreaKey, normAreaMustInputFields);
            }
        }
        return mustInputFieldsMap;
    }

    private HashMap<String, Object> getIsAllImportIndicatorsMap() {
        HashMap<String, Object> isAllImportIndicatorsMap = new HashMap<String, Object>(16);
        Map allPageCache = this.getPageCache().getAll();
        if (!HRObjectUtils.isEmpty((Object)allPageCache)) {
            for (Map.Entry pageCacheEntry : allPageCache.entrySet()) {
                String cacheKey = (String)pageCacheEntry.getKey();
                if (!HRStringUtils.isNotEmpty((String)cacheKey) || !cacheKey.startsWith("isAllImportIndicators_")) continue;
                String value = (String)pageCacheEntry.getValue();
                isAllImportIndicatorsMap.put(cacheKey, value);
            }
        }
        return isAllImportIndicatorsMap;
    }

    private List<String> getCacheAreaKeys() {
        List<String> cacheAreaKeys = Arrays.asList("PLUS_MINUS_AREA_mustInputFields", "ATTACH_AREA_mustInputFields", "SUM_AREA_mustInputFields");
        return cacheAreaKeys;
    }

    private void confirmOrder() {
        this.refreshBatchPersonCart();
    }

    private void confirmFilter() {
        this.refreshBatchPersonCart();
    }

    private void refreshBatchPersonCart() {
        this.canCelSplitPage();
        IPageCache pageCache = this.getPageCache();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String batchTaskId = (String)formShowParameter.getCustomParam("batchTaskId");
        Long aLong = Long.valueOf(batchTaskId);
        List<Map<String, Object>> maps = this.getTaskList(aLong);
        if (ObjectUtils.isEmpty(maps)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u5931\u6548", (String)"ActEvalObjMultiPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        List taskIds = maps.stream().map(map -> (Long)map.get("taskId")).collect(Collectors.toList());
        pageCache.put("taskIds", SerializationUtils.toJsonString(taskIds));
        List<String> statusList = Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode());
        maps = maps.stream().filter(map -> statusList.contains(map.get("taskStatus"))).collect(Collectors.toList());
        String filterPage = pageCache.get("filter_page");
        IFormView filterView = this.getView().getView(filterPage);
        this.refreshFilter(maps, pageCache, filterView);
        DynamicObject filterDataEntity = filterView.getModel().getDataEntity();
        List actEvaObjId = maps.stream().map(map -> (Long)map.get("actEvaObjId")).collect(Collectors.toList());
        String evalStatus = filterDataEntity.getString(EVALSTATUS);
        if (HRStringUtils.isNotEmpty((String)evalStatus)) {
            String[] strings = evalStatus.split(",");
            ArrayList list = new ArrayList(strings.length);
            Collections.addAll(list, strings);
            List<String> inds = list.stream().filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(inds)) {
                ArrayList<String> status = new ArrayList<String>(16);
                this.setTaskStatus(inds, status);
                if (!ObjectUtils.isEmpty(status)) {
                    actEvaObjId = maps.stream().filter(obj -> status.contains((String)obj.get("taskStatus"))).map(map -> (Long)map.get("actEvaObjId")).collect(Collectors.toList());
                    maps = maps.stream().filter(obj -> status.contains((String)obj.get("taskStatus"))).collect(Collectors.toList());
                }
            }
        }
        DynamicObject[] dynamicObjects = APPLICATION_SERVICE.queryById("id,perffile,perffile.adminorg,perffile.position,affiliateadminorg,affiliateadminorg.index,person,empposrel,empposrel.position,empposrel.job", actEvaObjId);
        LinkedList<DynamicObject> actEvaObjs = new LinkedList<DynamicObject>();
        for (int i = 0; i < maps.size(); ++i) {
            Long id = (Long)maps.get(i).get("actEvaObjId");
            String personNum = "";
            Long perffileId = 0L;
            Long affiliateadminorgId = 0L;
            Long positionId = 0L;
            Long personId = 0L;
            for (int j = 0; j < dynamicObjects.length; ++j) {
                if (dynamicObjects[j].getLong("id") != id.longValue()) continue;
                perffileId = dynamicObjects[j].getLong("perffile.id");
                affiliateadminorgId = dynamicObjects[j].getLong("perffile.adminorg.id");
                positionId = dynamicObjects[j].getLong("perffile.position.id");
                personId = dynamicObjects[j].getLong("person.id");
                if (dynamicObjects[j].get("person.number") != null) {
                    personNum = dynamicObjects[j].get("person.number").toString();
                }
                actEvaObjs.add(dynamicObjects[j]);
            }
            maps.get(i).put("perffileId", perffileId);
            maps.get(i).put("affiliateadminorgId", affiliateadminorgId);
            maps.get(i).put("positionId", positionId);
            maps.get(i).put(PERSONId, personId);
            maps.get(i).put("personNum", personNum);
        }
        dynamicObjects = actEvaObjs.toArray(new DynamicObject[actEvaObjs.size()]);
        List<Map<String, Object>> evaObjMapsOrder = this.getEvaObjMapsOrder(dynamicObjects, maps);
        if (!ObjectUtils.isEmpty(evaObjMapsOrder)) {
            this.setCartEntryAndCache(dynamicObjects, evaObjMapsOrder);
        } else {
            String isEmptyPage = pageCache.get(ISEMPTYPAGE);
            if (HRStringUtils.equals((String)isEmptyPage, (String)"true")) {
                filterView.getModel().setValue(EVALSTATUS, null);
                this.getView().sendFormAction(filterView);
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BATCH, BTN_CANCEL, BATCH_AP, HAVE_FILTER_AP});
                this.getView().getParentView().getPageCache().put("is_batch", "");
                this.refreshBatchPersonCart();
                this.setBatch("0");
            } else if (!ObjectUtils.isEmpty((Object)filterView)) {
                filterView.invokeOperation("nodata");
                this.getView().sendFormAction(filterView);
            }
        }
    }

    private void refreshFilter(List<Map<String, Object>> maps, IPageCache pageCache, IFormView filterView) {
        String personIdStr;
        String positionIdStr;
        this.setFilterCache(maps, pageCache);
        String orgIdStr = pageCache.get("orgId");
        if (!StringUtils.isEmpty((String)orgIdStr)) {
            List orgIds = JSONObject.parseArray((String)orgIdStr, Long.class);
            BasedataEdit adminOrgEdit = (BasedataEdit)filterView.getControl(ADMINORG);
            adminOrgEdit.setQFilter(new QFilter("id", "in", (Object)orgIds));
        }
        if (!StringUtils.isEmpty((String)(positionIdStr = pageCache.get("positionId")))) {
            List positionIds = JSONObject.parseArray((String)positionIdStr, Long.class);
            BasedataEdit positionEdit = (BasedataEdit)filterView.getControl(POSITION);
            positionEdit.setQFilter(new QFilter("id", "in", (Object)positionIds));
        }
        if (!StringUtils.isEmpty((String)(personIdStr = pageCache.get(PERSONId)))) {
            List personIds = JSONObject.parseArray((String)personIdStr, Long.class);
            BasedataEdit personEdit = (BasedataEdit)filterView.getControl(PERSON);
            personEdit.setQFilter(new QFilter("id", "in", (Object)personIds));
        }
    }

    private List<Map<String, Object>> getEvaObjMapsOrder(DynamicObject[] dynamicObjects, List<Map<String, Object>> maps) {
        IPageCache pageCache = this.getPageCache();
        String orderPage = pageCache.get("order_page");
        IFormView orderView = this.getView().getView(orderPage);
        DynamicObject orderDataEntity = orderView.getModel().getDataEntity();
        String orderway = orderDataEntity.getString(ORDERWAY);
        String ordersort = orderDataEntity.getString(ORDERSORT);
        if (HRStringUtils.isNotEmpty((String)orderway)) {
            List perffileId = Arrays.stream(dynamicObjects).map(map -> (Long)map.get("perffile.id")).collect(Collectors.toList());
            switch (orderway) {
                case "20": {
                    DynamicObject[] perffileOrderbyPosition = PERFFILE_ENTITY_SERVICE.query("position,position.index", new QFilter[]{new QFilter("id", "in", perffileId)}, "position.index asc");
                    for (int i = 0; i < maps.size(); ++i) {
                        Long id = (Long)maps.get(i).get("perffileId");
                        maps.get(i).put("positionIndex", "-1");
                        for (int j = 0; j < perffileOrderbyPosition.length; ++j) {
                            if (perffileOrderbyPosition[j].getLong("id") != id.longValue()) continue;
                            String positionIndex = "-1";
                            if (perffileOrderbyPosition[j].get("position.index") != null) {
                                positionIndex = perffileOrderbyPosition[j].get("position.index").toString();
                            }
                            maps.get(i).put("positionIndex", positionIndex);
                        }
                    }
                    maps = maps.stream().sorted(Comparator.comparing(o -> o.get("positionIndex").toString()).thenComparing(o -> o.get("personNum").toString())).collect(Collectors.toList());
                    break;
                }
                case "30": {
                    DynamicObject[] perffileOrderbyAdminorg = PERFFILE_ENTITY_SERVICE.query("adminorg,adminorg.sortcode", new QFilter[]{new QFilter("id", "in", perffileId)}, "adminorg.sortcode asc");
                    for (int i = 0; i < maps.size(); ++i) {
                        Long id = (Long)maps.get(i).get("perffileId");
                        maps.get(i).put("adminorgSortcode", "-1");
                        for (int j = 0; j < perffileOrderbyAdminorg.length; ++j) {
                            if (perffileOrderbyAdminorg[j].getLong("id") != id.longValue()) continue;
                            String adminorgSortcode = "-1";
                            if (perffileOrderbyAdminorg[j].get("adminorg.sortcode") != null) {
                                adminorgSortcode = perffileOrderbyAdminorg[j].get("adminorg.sortcode").toString();
                            }
                            maps.get(i).put("adminorgSortcode", adminorgSortcode);
                        }
                    }
                    maps = maps.stream().sorted(Comparator.comparing(o -> o.get("adminorgSortcode").toString()).thenComparing(o -> o.get("personNum").toString())).collect(Collectors.toList());
                    break;
                }
                case "40": {
                    maps = maps.stream().sorted(Comparator.comparing(o -> Integer.parseInt(o.get("taskStatus").toString())).thenComparing(o -> o.get("personNum").toString())).collect(Collectors.toList());
                    break;
                }
                case "50": {
                    maps = this.getOseOrderMaps(maps, ordersort);
                    maps = maps.stream().sorted(Comparator.comparing(o -> new BigDecimal(o.get(OSE) == null ? "0" : o.get(OSE).toString())).thenComparing(o -> o.get("personNum").toString())).collect(Collectors.toList());
                    break;
                }
                case "60": {
                    maps = this.getOleOrderMaps(maps, ordersort);
                    maps = maps.stream().sorted(Comparator.comparing(o -> Integer.parseInt(o.get(OLE) == null ? "0" : o.get(OLE).toString())).thenComparing(o -> o.get("personNum").toString())).collect(Collectors.toList());
                    break;
                }
            }
        }
        if (ordersort.equals("20")) {
            Collections.reverse(maps);
        }
        return maps;
    }

    private List<Map<String, Object>> getOseOrderMaps(List<Map<String, Object>> maps, String ordersort) {
        List taskIds = maps.stream().map(o -> Long.valueOf(o.get("taskId").toString())).collect(Collectors.toList());
        DynamicObject[] sumAreaEvalRecordObjs = APP_SERVICE.querySumAreaEvalRecordByTaskIds(taskIds);
        for (int i = 0; i < maps.size(); ++i) {
            String taskId = maps.get(i).get("taskId").toString();
            if (HRObjectUtils.isEmpty((Object)sumAreaEvalRecordObjs) || sumAreaEvalRecordObjs.length <= 0) continue;
            if (ordersort.equals("10")) {
                Optional<DynamicObject> max;
                maps.get(i).put(OSE, new BigDecimal((max = Arrays.stream(sumAreaEvalRecordObjs).max(Comparator.comparing(o -> new BigDecimal(o.get(OSE) == null ? "0" : o.get(OSE).toString())))).get().get(OSE) == null ? 0 : max.get().getInt(OSE) + 1));
            } else {
                Optional<DynamicObject> min;
                maps.get(i).put(OSE, new BigDecimal((min = Arrays.stream(sumAreaEvalRecordObjs).min(Comparator.comparing(o -> new BigDecimal(o.get(OSE) == null ? "0" : o.get(OSE).toString())))).get().get(OSE) == null ? 0 : min.get().getInt(OSE) - 1));
            }
            for (int j = 0; j < sumAreaEvalRecordObjs.length; ++j) {
                BigDecimal ose;
                DynamicObject sumAreaEvalRecordObj = sumAreaEvalRecordObjs[j];
                String sumAreaEvalRecordTaskId = sumAreaEvalRecordObj.getString("flowrutask.id");
                if (!HRStringUtils.equals((String)taskId, (String)sumAreaEvalRecordTaskId) || (ose = sumAreaEvalRecordObj.getBigDecimal(OSE)) == null) continue;
                maps.get(i).put(OSE, ose);
            }
        }
        return maps;
    }

    private List<Map<String, Object>> getOleOrderMaps(List<Map<String, Object>> maps, String ordersort) {
        List taskIds = maps.stream().map(o -> Long.valueOf(o.get("taskId").toString())).collect(Collectors.toList());
        DynamicObject[] sumAreaEvalRecordObjs = APP_SERVICE.querySumAreaEvalRecordByTaskIds(taskIds);
        String sumperflevel = this.getPageCache().get("sumperflevel");
        List perfLevelItems = null;
        if (!HRStringUtils.isEmpty((String)sumperflevel)) {
            perfLevelItems = APP_SERVICE.queryPerfLevelItemByLevel(Long.valueOf(sumperflevel));
        }
        for (int i = 0; i < maps.size(); ++i) {
            String taskId = maps.get(i).get("taskId").toString();
            maps.get(i).put(OLE, -1);
            if (HRObjectUtils.isEmpty((Object)sumAreaEvalRecordObjs) || sumAreaEvalRecordObjs.length <= 0) continue;
            if (ordersort.equals("10")) {
                Optional<DynamicObject> max;
                maps.get(i).put(OLE, (max = Arrays.stream(sumAreaEvalRecordObjs).max(Comparator.comparing(o -> o.get(OLE) == null ? 0 : o.getInt(OLE)))).get().get(OLE) == null ? 0 : max.get().getInt(OLE) + 1);
            } else {
                Optional<DynamicObject> min;
                maps.get(i).put(OLE, (min = Arrays.stream(sumAreaEvalRecordObjs).min(Comparator.comparing(o -> o.get(OLE) == null ? 0 : o.getInt(OLE)))).get().get(OLE) == null ? 0 : min.get().getInt(OLE) - 1);
            }
            for (int j = 0; j < sumAreaEvalRecordObjs.length; ++j) {
                DynamicObject sumAreaEvalRecordObj = sumAreaEvalRecordObjs[j];
                String sumAreaEvalRecordTaskId = sumAreaEvalRecordObj.getString("flowrutask.id");
                if (!HRStringUtils.equals((String)taskId, (String)sumAreaEvalRecordTaskId)) continue;
                String ole = sumAreaEvalRecordObj.getString(OLE);
                if (perfLevelItems == null || perfLevelItems.size() <= 0) continue;
                for (int m = 0; m < perfLevelItems.size(); ++m) {
                    ComboItem perfLevelItem = (ComboItem)perfLevelItems.get(m);
                    if (!HRStringUtils.equals((String)ole, (String)perfLevelItem.getValue())) continue;
                    maps.get(i).put(OLE, m);
                }
            }
        }
        return maps;
    }

    private void setTaskStatus(List<String> inds, List<String> status) {
        if (inds.contains("20")) {
            status.add(FlowRuTaskStatusEnum.WAITING.getCode());
        }
        if (inds.contains("30")) {
            status.add(FlowRuTaskStatusEnum.PROCESSING.getCode());
        }
        if (inds.contains("40")) {
            status.add(FlowRuTaskStatusEnum.PROCESSED.getCode());
        }
        if (inds.contains("80")) {
            status.add(FlowRuTaskStatusEnum.RETURNED.getCode());
        }
    }

    private void setCartEntryAndCache(DynamicObject[] dynamicObjects, List<Map<String, Object>> maps) {
        DynamicObjectCollection persons;
        DynamicObjectCollection positons;
        DynamicObjectCollection orGs;
        IPageCache pageCache = this.getPageCache();
        IDataModel model = this.getModel();
        String filterPage = pageCache.get("filter_page");
        IFormView filterView = this.getView().getView(filterPage);
        DynamicObject dataEntity = filterView.getModel().getDataEntity();
        List<DynamicObject> collect = Arrays.stream(dynamicObjects).collect(Collectors.toList());
        List<Object> inds = new ArrayList(16);
        String evalStatus = dataEntity.getString(EVALSTATUS);
        if (HRStringUtils.isNotEmpty((String)evalStatus)) {
            String[] strings = evalStatus.split(",");
            ArrayList list = new ArrayList(strings.length);
            Collections.addAll(list, strings);
            inds = list.stream().filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty((Object)(orGs = dataEntity.getDynamicObjectCollection(ADMINORG)))) {
            List orgId = orGs.stream().map(org -> org.getLong("fbasedataid.id")).collect(Collectors.toList());
            collect = collect.stream().filter(dynamicObject -> orgId.contains(dynamicObject.getLong("perffile.adminorg.id"))).collect(Collectors.toList());
            maps = maps.stream().filter(map -> orgId.contains(map.get("affiliateadminorgId"))).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty((Object)(positons = dataEntity.getDynamicObjectCollection(POSITION)))) {
            List positionId = positons.stream().map(position -> position.getLong("fbasedataid.id")).collect(Collectors.toList());
            collect = collect.stream().filter(dynamicObject -> positionId.contains(dynamicObject.getLong("perffile.position.id"))).collect(Collectors.toList());
            maps = maps.stream().filter(map -> positionId.contains(map.get("positionId"))).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty((Object)(persons = dataEntity.getDynamicObjectCollection(PERSON)))) {
            List personId = persons.stream().map(person -> person.getLong("fbasedataid.id")).collect(Collectors.toList());
            collect = collect.stream().filter(dynamicObject -> personId.contains(dynamicObject.getLong("person.id"))).collect(Collectors.toList());
            maps = maps.stream().filter(map -> personId.contains(map.get(PERSONId))).collect(Collectors.toList());
        }
        if (collect.size() > 0) {
            Boolean haveFilter = Boolean.FALSE;
            if (!(ObjectUtils.isEmpty((Object)orGs) && ObjectUtils.isEmpty((Object)positons) && ObjectUtils.isEmpty((Object)persons) && ObjectUtils.isEmpty(inds))) {
                haveFilter = Boolean.TRUE;
            }
            this.setPrevCache();
            this.setPersonEntry(maps, model, collect);
            this.selectPerson(0);
            this.closeFilterView(CUSTOMCONTROLAP);
            this.closeFilterView(ORDERCONTROLAP);
            this.getView().setVisible(haveFilter, new String[]{HAVE_FILTER_AP});
        } else {
            String isEmptyPage = pageCache.get(ISEMPTYPAGE);
            if (HRStringUtils.equals((String)isEmptyPage, (String)"true") && this.isHasProcessingTask()) {
                filterView.getModel().setValue(ADMINORG, null);
                filterView.getModel().setValue(POSITION, null);
                filterView.getModel().setValue(PERSON, null);
                filterView.getModel().setValue(EVALSTATUS, (Object)"20,30");
                this.getView().sendFormAction(filterView);
                this.getView().getParentView().getPageCache().put("is_batch", "");
                this.refreshBatchPersonCart();
            } else if (!ObjectUtils.isEmpty((Object)filterView)) {
                filterView.invokeOperation("nodata");
                this.getView().sendFormAction(filterView);
            }
        }
        this.initBatchPersonCart();
        this.isSelectAll();
    }

    private boolean isHasProcessingTask() {
        boolean flag = false;
        String taskIds = this.getPageCache().get("taskIds");
        if (taskIds != null) {
            List taskIdList = (List)SerializationUtils.fromJsonString((String)taskIds, List.class);
            Map taskStatusMap = APPEVALOBJOVER_SERVICE.queryTaskStatusMap(taskIdList);
            List<String> processingCode = Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode());
            for (Map.Entry taskEntry : taskStatusMap.entrySet()) {
                String taskStatus = (String)taskEntry.getValue();
                if (!processingCode.contains(taskStatus)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private void setPrevCache() {
        IPageCache pageCache = this.getPageCache();
        String filterPage = pageCache.get("filter_page");
        IFormView filterView = this.getView().getView(filterPage);
        DynamicObject filterDataEntity = filterView.getModel().getDataEntity();
        String adminOrgIdStr = null;
        DynamicObjectCollection adminOrgIds = filterDataEntity.getDynamicObjectCollection(ADMINORG);
        if (!ObjectUtils.isEmpty((Object)adminOrgIds)) {
            List adminOrgId = adminOrgIds.stream().map(adminOrg -> adminOrg.getLong("fbasedataid.id")).collect(Collectors.toList());
            adminOrgIdStr = SerializationUtils.toJsonString(adminOrgId);
        }
        pageCache.put(PREVADMINORG, adminOrgIdStr);
        String positionIdStr = null;
        DynamicObjectCollection positions = filterDataEntity.getDynamicObjectCollection(POSITION);
        if (!ObjectUtils.isEmpty((Object)positions)) {
            List positionId = positions.stream().map(position -> position.getLong("fbasedataid.id")).collect(Collectors.toList());
            positionIdStr = SerializationUtils.toJsonString(positionId);
        }
        pageCache.put(PREVPOSITION, positionIdStr);
        String personIdStr = null;
        DynamicObjectCollection persons = filterDataEntity.getDynamicObjectCollection(PERSON);
        if (!ObjectUtils.isEmpty((Object)persons)) {
            List personId = persons.stream().map(person -> person.getLong("fbasedataid.id")).collect(Collectors.toList());
            personIdStr = SerializationUtils.toJsonString(personId);
        }
        pageCache.put(PREVPERSON, personIdStr);
        String evalStatus = filterView.getModel().getValue(EVALSTATUS) == null ? null : filterView.getModel().getValue(EVALSTATUS).toString();
        pageCache.put(PREVEVALSTATUS, evalStatus);
        String orderPage = pageCache.get("order_page");
        IFormView orderView = this.getView().getView(orderPage);
        pageCache.put(PREVORDERWAY, orderView.getModel().getValue(ORDERWAY).toString());
        pageCache.put(PREVORDERSORT, orderView.getModel().getValue(ORDERSORT).toString());
    }

    private void setPersonEntry(List<Map<String, Object>> maps, IDataModel model, List<DynamicObject> collect) {
        List taskIds = maps.stream().map(map -> (Long)map.get("taskId")).collect(Collectors.toList());
        DynamicObject[] sumAreaEvalRecordObjs = APP_SERVICE.querySumAreaEvalRecordByTaskIds(taskIds);
        model.deleteEntryData("personcartentity");
        model.batchCreateNewEntryRow("personcartentity", maps.size());
        boolean isHideBtnBatch = true;
        int curIndex = 0;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String batchTaskIdStr = (String)formShowParameter.getCustomParam("batchTaskId");
        Long batchTaskId = Long.valueOf(batchTaskIdStr);
        List<Map<String, Object>> batchTaskDetaiList = this.getTaskList(batchTaskId);
        for (int index = 0; index < maps.size(); ++index) {
            DynamicObject actEvaObj;
            Map<String, Object> dynamicObjMap = maps.get(index);
            Long taskId = (Long)dynamicObjMap.get("taskId");
            Long actEvaObjId = (Long)dynamicObjMap.get("actEvaObjId");
            String taskStatusStr = (String)dynamicObjMap.get("taskStatus");
            if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSING.getCode(), (String)taskStatusStr) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)taskStatusStr)) {
                isHideBtnBatch = false;
            }
            if ((actEvaObj = (DynamicObject)collect.stream().filter(s -> s.getLong("id") == actEvaObjId.longValue()).findFirst().orElse(null)) == null) continue;
            model.setValue(PERSON, (Object)actEvaObj.getLong("person.id"), curIndex);
            model.setValue("personnamelab", (Object)actEvaObj.getString("person.name"), curIndex);
            model.setValue("evalobj", (Object)actEvaObjId, curIndex);
            model.setValue("taskid", (Object)taskId, curIndex);
            String taskStatus = this.getAssessStatus(taskStatusStr);
            model.setValue("status", (Object)taskStatusStr, curIndex);
            boolean isRollBacked = (Boolean)maps.get(index).get("isrollbacked");
            if (isRollBacked) {
                this.setOseAndOle(sumAreaEvalRecordObjs, taskId, model, curIndex);
            } else {
                model.setValue(IS_SHOW_ASSESSSTATUS, (Object)"1", curIndex);
            }
            model.setValue("assessstatuslab", (Object)taskStatus, curIndex);
            Map taskDetail = batchTaskDetaiList.stream().filter(obj -> taskId.equals((Long)obj.get("taskId"))).findFirst().orElse(null);
            if (taskDetail != null) {
                List mergeTaskIdList = (List)taskDetail.get("mergeTaskIds");
                String mergeTaskIds = mergeTaskIdList.stream().map(obj -> obj.toString()).collect(Collectors.joining(","));
                model.setValue("mergetaskids", (Object)mergeTaskIds, curIndex);
            }
            model.setValue("headsculpture", (Object)HRImageUrlUtil.getImageFullUrl((String)String.valueOf(actEvaObj.getString("person.headsculpture"))), curIndex);
            ++curIndex;
        }
        if (isHideBtnBatch) {
            this.getPageCache().put("isHideBtnBatch", "true");
        } else {
            this.getPageCache().put("isHideBtnBatch", "false");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        IPageCache pageCache = this.getPageCache();
        if (SUBMIT_TASK_CLOSE_BACK.equals(actionId)) {
            if (!ObjectUtils.isEmpty((Object)returnData) && returnData instanceof Map) {
                Map resultMap = (Map)returnData;
                if (!resultMap.containsKey("taskinfo")) {
                    return;
                }
                JSONObject taskInfo = JSONObject.parseObject((String)String.valueOf(resultMap.get("taskinfo")));
                JSONObject resultData = JSONObject.parseObject((String)((String)taskInfo.get((Object)"data")));
                Map failMap = (Map)resultData.get((Object)"failMap");
                Integer success = (Integer)resultData.get((Object)"success");
                Integer total = (Integer)resultData.get((Object)"total");
                IFormView view = this.getView();
                this.showBatchForm(total, success, failMap);
                pageCache.put(ISEMPTYPAGE, "true");
                view.invokeOperation(REFRESH_ENTRY);
                pageCache.put(ISEMPTYPAGE, "false");
                view.sendFormAction(view);
            }
        } else if (EPA_EVALOBJ_REJECT.equals(actionId)) {
            IFormView view = this.getView();
            view.setStatus(OperationStatus.EDIT);
            pageCache.put(ISEMPTYPAGE, "false");
            if (!HRObjectUtils.isEmpty((Object)returnData)) {
                List<RollbackParamBo> rollbackParamBoList;
                Map data = (Map)returnData;
                ArrayList<Long> taskIdList = new ArrayList<Long>(10);
                String reason = (String)data.get("reason");
                DynamicObject billObj = this.getModel().getDataEntity(true);
                DynamicObjectCollection dynamicObjectCollection = billObj.getDynamicObjectCollection("personcartentity");
                List dynamicObjects = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.getBoolean("selectcheck")).collect(Collectors.toList());
                ArrayList<String> processedList = new ArrayList<String>(10);
                ArrayList<String> returnedList = new ArrayList<String>(10);
                ArrayList<String> expiredList = new ArrayList<String>(10);
                List selectedTaskIdList = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("taskid")).collect(Collectors.toList());
                Map taskStatusMap = APPEVALOBJOVER_SERVICE.queryTaskStatusMap(selectedTaskIdList);
                ArrayList<List<Long>> mergeTaskIdList = new ArrayList<List<Long>>(10);
                for (DynamicObject dynamicObject2 : dynamicObjects) {
                    String name = dynamicObject2.getString("person.name");
                    String number = dynamicObject2.getString("person.number");
                    long taskId = dynamicObject2.getLong("taskid");
                    String taskStatus = (String)taskStatusMap.get(taskId);
                    if (HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.PROCESSED.getCode())) {
                        processedList.add(ResManager.loadKDString((String)"{0} {1} \u4efb\u52a1\u5df2\u8bc4\u4f30", (String)"ActEvalObjMultiPlugin_11", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.RETURNED.getCode())) {
                        returnedList.add(ResManager.loadKDString((String)"{0} {1} \u4efb\u52a1\u5df2\u88ab\u64cd\u4f5c\u8fc7\u9000\u56de", (String)"ActEvalObjMultiPlugin_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    if (HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.EXPIRED.getCode())) {
                        expiredList.add(ResManager.loadKDString((String)"{0} {1} \u4efb\u52a1\u5df2\u5931\u6548", (String)"ActEvalObjMultiPlugin_13", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, number}));
                        continue;
                    }
                    taskIdList.add(taskId);
                    String mergeTaskIdStr = dynamicObject2.getString("mergetaskids");
                    List<String> taskIdStrList = Arrays.asList(mergeTaskIdStr.split(","));
                    List taskIds = taskIdStrList.stream().map(obj -> Long.parseLong(obj)).collect(Collectors.toList());
                    mergeTaskIdList.add(taskIds);
                }
                if (returnedList.isEmpty() && processedList.isEmpty() && expiredList.isEmpty()) {
                    rollbackParamBoList = this.assembleRollbackParam(mergeTaskIdList, reason);
                    APP_SERVICE.rollbackToLastNodeOrRole(rollbackParamBoList);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u56de\u6210\u529f", (String)"ActEvalObjMultiPlugin_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                } else {
                    if (!taskIdList.isEmpty()) {
                        rollbackParamBoList = this.assembleRollbackParam(mergeTaskIdList, reason);
                        APP_SERVICE.rollbackToLastNodeOrRole(rollbackParamBoList);
                    }
                    HashMap<String, Object> failMap = new HashMap<String, Object>(16);
                    failMap.put(FAIL_PROCESSED_KEY, processedList);
                    failMap.put(FAIL_RETURNED_KEY, returnedList);
                    failMap.put(FAIL_EXPIRED_KEY, expiredList);
                    int success = dynamicObjects.size() - processedList.size() - returnedList.size() - expiredList.size();
                    this.showBatchForm(dynamicObjects.size(), success, failMap);
                }
                pageCache.put(ISEMPTYPAGE, "true");
                view.invokeOperation(REFRESH_ENTRY);
                pageCache.put(ISEMPTYPAGE, "false");
            }
        }
    }

    private List<RollbackParamBo> assembleRollbackParam(List<List<Long>> taskIdList, String reason) {
        ArrayList<RollbackParamBo> rollbackParamBoList = new ArrayList<RollbackParamBo>(10);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List<Long> firstTaskList = taskIdList.get(0);
        ArrayList<Long> taskList = new ArrayList<Long>(10);
        for (List<Long> taskItemList : taskIdList) {
            taskList.addAll(taskItemList);
        }
        DynamicObject[] taskInfo = APP_SERVICE.queryTaskInfos(taskList);
        Map taskMap = Arrays.stream(taskInfo).collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
        for (int i = 0; i < taskIdList.size(); ++i) {
            List<Long> mergeTaskIds = taskIdList.get(i);
            Long fTaskId = mergeTaskIds.get(0);
            DynamicObject fTaskObj = (DynamicObject)taskMap.get(fTaskId);
            Long ruProcId = fTaskObj.getLong("flowruproc.id");
            Long ruNodeId = fTaskObj.getLong("flowrunode.id");
            RollbackParamBo rollbackParamBo = new RollbackParamBo();
            rollbackParamBo.setRuProcId(ruProcId);
            rollbackParamBo.setRuNodeId(ruNodeId);
            rollbackParamBo.setRollbackType("2");
            if (firstTaskList.size() > 1) {
                rollbackParamBo.setMergeTask(Boolean.valueOf(true));
                rollbackParamBo.setMergeTaskIds(mergeTaskIds);
            } else {
                rollbackParamBo.setMergeTask(Boolean.valueOf(false));
                rollbackParamBo.setRuTaskId(mergeTaskIds.get(0));
            }
            rollbackParamBo.setReason(reason);
            rollbackParamBoList.add(rollbackParamBo);
        }
        return rollbackParamBoList;
    }

    private void showBatchForm(int total, int success, Map<String, Object> failMap) {
        if (total == success) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"ActEvalObjMultiPlugin_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            List processedList = (List)failMap.get(FAIL_PROCESSED_KEY);
            List returnedList = (List)failMap.get(FAIL_RETURNED_KEY);
            List expiredList = (List)failMap.get(FAIL_EXPIRED_KEY);
            List failList = Stream.concat(processedList.stream(), returnedList.stream()).collect(Collectors.toList());
            failList.addAll(expiredList);
            if (failMap.get("errorList") != null) {
                List errorList = (List)failMap.get("errorList");
                failList.addAll(errorList);
            }
            if (failMap.get("validateMustList") != null) {
                List validateMustList = (List)failMap.get("validateMustList");
                failList.addAll(validateMustList);
            }
            if (failMap.get("notEvalList") != null) {
                List notEvalList = (List)failMap.get("notEvalList");
                failList.addAll(notEvalList);
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setCustomParam("total", (Object)total);
            formShowParameter.setCustomParam("success", (Object)success);
            formShowParameter.setCustomParam("fail", (Object)JSON.toJSONString(failList));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("epa_evaloverall_batchmsg");
            formShowParameter.setHasRight(true);
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("460px");
            styleCss.setHeight("294px");
            formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            this.getView().showForm(formShowParameter);
        }
    }

    private void initBatchPersonCart() {
        if (HRStringUtils.isEmpty((String)this.getView().getParentView().getPageCache().get("is_batch"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCEL, SELECT_CHECK_AP, BATCH_AP});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_BATCH});
            this.getView().updateView("personcartentity");
            this.setBatch("0");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CANCEL, SELECT_CHECK_AP, BATCH_AP});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BATCH});
            this.setBatch("1");
            this.getView().getParentView().getPageCache().put("is_batch", Boolean.TRUE.toString());
        }
        String isHideBtnBatch = this.getPageCache().get("isHideBtnBatch");
        if (HRStringUtils.equals((String)isHideBtnBatch, (String)"true")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BATCH, BTN_CANCEL, BATCH_AP});
            this.setBatch("0");
        }
    }

    private void closeFilterView(String customcontrolKey) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(customcontrolKey);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("show", "false");
        map.put("date", new Date());
        customcontrol.setData(map);
    }

    public void customEvent(CustomEventArgs e) {
        if (HRStringUtils.equals((String)e.getKey(), (String)CUSTOMCONTROLAP)) {
            if (HRStringUtils.equals((String)e.getEventArgs(), (String)"false")) {
                this.openFilterView(CUSTOMCONTROLAP);
                this.closeFilterView(ORDERCONTROLAP);
                this.reloadFilterView();
            } else {
                this.closeFilterView(CUSTOMCONTROLAP);
            }
        } else if (HRStringUtils.equals((String)e.getKey(), (String)ORDERCONTROLAP)) {
            if (HRStringUtils.equals((String)e.getEventArgs(), (String)"false")) {
                this.openFilterView(ORDERCONTROLAP);
                this.closeFilterView(CUSTOMCONTROLAP);
            } else {
                this.closeFilterView(ORDERCONTROLAP);
            }
        }
    }

    private void reloadFilterView() {
        IPageCache pageCache = this.getPageCache();
        String filterPage = pageCache.get("filter_page");
        IFormView filterView = this.getView().getView(filterPage);
        filterView.invokeOperation("loaddata");
        this.getView().sendFormAction(filterView);
    }

    private void openFilterView(String customcontrolKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomControl customcontrol = (CustomControl)this.getView().getControl(customcontrolKey);
        map.put("show", "true");
        map.put("date", new Date());
        customcontrol.setData(map);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.canCelSplitPage();
        String key = args.getOperateKey();
        if (BATCH.equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CANCEL, SELECT_CHECK_AP, BATCH_AP});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BATCH});
            this.setBatch("1");
            this.getView().getParentView().getPageCache().put("is_batch", Boolean.TRUE.toString());
            this.isHideChildrenSubmit();
        } else if (CANCE.equals(key)) {
            this.selectAllFalse();
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCEL, SELECT_CHECK_AP, BATCH_AP});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_BATCH});
            this.getView().updateView("personcartentity");
            this.setBatch("0");
            this.getView().getParentView().getPageCache().put("is_batch", "");
            this.isHideChildrenSubmit();
        } else if (REFRESH_ENTRY.equals(key)) {
            this.refreshBatchPersonCart();
        } else if (REFRESH.equals(key)) {
            this.refreshBatchPersonCart();
        }
    }

    private void canCelSplitPage() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("personcartentity");
        entryGrid.setSplitPage(Boolean.FALSE.booleanValue());
    }

    private void isHideChildrenSubmit() {
        String pageId = this.getPageCache().get(CHILDREN_PAGE);
        String isBatch = this.getView().getParentView().getPageCache().get("is_batch");
        IFormView view = this.getView().getView(pageId);
        if (!ObjectUtils.isEmpty((Object)view)) {
            if (HRStringUtils.isNotEmpty((String)isBatch)) {
                view.setVisible(Boolean.FALSE, new String[]{BUTTONAP});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{BUTTONAP});
            }
            this.getView().sendFormAction(view);
        }
    }
}

