/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.dynpermission.DynPermissionConfigService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.EmpInfoConfigEntityService;
import kd.opmc.epa.business.domain.evaluating.entity.ContentAreaEntryEvaDto;
import kd.opmc.epa.business.domain.evaluating.entity.ContentFieldEntryEvaDto;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.per.AreaEnum;
import kd.opmc.epa.common.vo.dynpermission.ContentAreaEntry;
import kd.opmc.epa.common.vo.dynpermission.ContentFieldEntry;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.external.hrpi.IEmployeeService;

public class ActEvalObjPersonInfoPlugin
extends HRDataBaseEdit {
    private static final Log log = LogFactory.getLog(ActEvalObjPersonInfoPlugin.class);
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final EmpInfoConfigEntityService EMP_INFO_CONFIG_ENTITY_SERVICE = EmpInfoConfigEntityService.getInstance();
    private static final IEmployeeService EMPLOYEE_SERVICE = IEmployeeService.getInstance();
    private static final Integer MAXNUM = 15;
    private static final ActEvalObjDetailApplicationService ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final AssessActivityEntityService ASSESS_ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final String HRPI_EMPJOBREL = "hrpi_empjobrel";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (e.getFormShowParameter() != null && e.getFormShowParameter().getParentFormId() != null) {
            e.getFormShowParameter().setHasRight(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPersonInfo();
    }

    public void setPersonInfo() {
        IFormView view = this.getView();
        IFormView parentView = this.getView().getParentView();
        DynamicObject evalObj = parentView.getModel().getDataEntity();
        Long activityId = parentView.getModel().getDataEntity().getLong("activity.id");
        DynamicObject activityObj = APP_SERVICE.queryActivityById(activityId);
        Long assessFormId = activityObj.getLong("assessform.id");
        DynamicObject assessformDy = APP_SERVICE.queryExecuteAssessForm(assessFormId.longValue());
        Image headSculpture = (Image)view.getControl("headsculpture");
        headSculpture.setUrl(HRImageUrlUtil.getImageFullUrl((String)evalObj.getString("person.headsculpture")));
        this.setLabelText(view, "name", evalObj.getString("perffile.name"));
        this.setLabelText(view, "number", evalObj.getString("perffile.billno"));
        HashMap<String, String> evalFieldConfMap = new HashMap<String, String>(16);
        evalFieldConfMap.put("company", evalObj.getString("perffile.company.name"));
        evalFieldConfMap.put("adminorg", evalObj.getString("perffile.adminorg.name"));
        evalFieldConfMap.put("position", evalObj.getString("perffile.position.name"));
        HashMap requestParam = Maps.newHashMapWithExpectedSize((int)3);
        Long employeeId = evalObj.getLong("employee.id");
        ArrayList<Long> employeeIds = new ArrayList<Long>(10);
        if (employeeId != null) {
            employeeIds.add(employeeId);
        }
        requestParam.put("sign", "employee");
        requestParam.put("signList", employeeIds);
        requestParam.put("dateTime", new Date());
        try {
            Map queryResult = EMPLOYEE_SERVICE.listPersonServiceAgeWithIds((Map)requestParam);
            Boolean success = (Boolean)queryResult.get("success");
            if (success.booleanValue()) {
                Map ageRetMap = (Map)queryResult.get("data");
                Map map = (Map)ageRetMap.get(employeeId);
                if (map != null && map.containsKey("companyWorkAge")) {
                    BigDecimal entservicelen = (BigDecimal)map.get("companyWorkAge");
                    entservicelen = entservicelen == null ? BigDecimal.ZERO : entservicelen;
                    evalFieldConfMap.put("entservicelen", entservicelen.stripTrailingZeros().toPlainString());
                }
                if (map != null && map.containsKey("socialWorkAge")) {
                    BigDecimal servicelen = (BigDecimal)map.get("socialWorkAge");
                    servicelen = servicelen == null ? BigDecimal.ZERO : servicelen;
                    evalFieldConfMap.put("workyear", servicelen.stripTrailingZeros().toPlainString());
                }
            }
        }
        catch (Exception e) {
            log.error("EMPLOYEE_SERVICE.listPersonServiceAgeWithIds   error, requestParam:" + requestParam);
            log.error((Throwable)e);
            evalFieldConfMap.put("entservicelen", "-");
            evalFieldConfMap.put("workyear", "-");
        }
        evalFieldConfMap.put("job", evalObj.getString("perffile.job.name"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date startdate = evalObj.getDate("perffile.employedate");
        if (startdate != null) {
            evalFieldConfMap.put("entrytime", format.format(startdate));
        } else {
            evalFieldConfMap.put("entrytime", "-");
        }
        String jobLevel = "";
        QFilter empJobRelFilter = new QFilter("businessstatus", "=", (Object)"1");
        empJobRelFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        empJobRelFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        empJobRelFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        try {
            Object empItemList;
            Map data;
            boolean success;
            Map empObj = EMPLOYEE_SERVICE.listEmpJobRel(employeeIds, empJobRelFilter);
            if (empObj != null && (success = ((Boolean)empObj.get("success")).booleanValue()) && (data = (Map)empObj.get("data")) != null && !data.isEmpty() && (empItemList = (List)data.get(String.valueOf(employeeId))) != null && !empItemList.isEmpty()) {
                int size = empItemList.size();
                Map empItem = (Map)empItemList.get(size - 1);
                jobLevel = (String)empItem.get("joblevel");
            }
            if (HRStringUtils.isNotEmpty((String)jobLevel)) {
                evalFieldConfMap.put("joblevel", jobLevel);
            } else {
                evalFieldConfMap.put("joblevel", "-");
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        for (Map.Entry entry : evalFieldConfMap.entrySet()) {
            Object value = entry.getValue();
            if (value != null) continue;
            evalFieldConfMap.put((String)entry.getKey(), "-");
        }
        Map<Long, Boolean> fieldPermMap = this.getFieldPermMap(parentView);
        DynamicObject empInfoConfDy = EMP_INFO_CONFIG_ENTITY_SERVICE.queryOne((Object)assessformDy.getLong("empinfoconf"));
        DynamicObjectCollection empInfoConfEntry = empInfoConfDy.getDynamicObjectCollection("entryentity");
        view.setVisible(Boolean.FALSE, new String[]{"splitline"});
        for (DynamicObject empInfo : empInfoConfEntry) {
            DynamicObject field = empInfo.getDynamicObject("areafield");
            if (field == null) continue;
            String fieldKey = field.getString("number");
            int seq = empInfo.getInt("seq");
            if (evalFieldConfMap.get(fieldKey) != null && empInfo.getBoolean("isshow") && this.hasShowPerm(fieldPermMap, field)) {
                Label keyLabel = (Label)view.getControl("key" + seq);
                keyLabel.setText(field.getString("name") + "\uff1a");
                Label valueLabel = (Label)view.getControl("value" + seq);
                valueLabel.setText(String.valueOf(evalFieldConfMap.get(fieldKey)));
                view.setVisible(Boolean.TRUE, new String[]{keyLabel.getKey(), valueLabel.getKey()});
                if (seq <= 6) continue;
                view.setVisible(Boolean.TRUE, new String[]{"splitline"});
                continue;
            }
            view.setVisible(Boolean.FALSE, new String[]{"ap" + seq});
        }
        for (int i = empInfoConfEntry.size() + 1; i <= MAXNUM; ++i) {
            view.setVisible(Boolean.FALSE, new String[]{"ap" + i});
        }
    }

    private Map<Long, Boolean> getFieldShowMap(IFormView parentView, DynamicObject evalObj) {
        Long personId;
        Map<Long, Long> personIdUserIdMap;
        Long userId;
        Long permissionId = evalObj.getDynamicObject("activity").getLong("processpermsetting.id");
        long currentNode = this.getCurrentNode(parentView, evalObj);
        if (currentNode == AssessNodeStatusEnum.CONFIRMING.getNodeId() && ((userId = (personIdUserIdMap = ListUtils.getBosUserIdsByPersonIds(Collections.singletonList(personId = Long.valueOf(evalObj.getLong("person.id"))))).get(personId)) == null || userId != UserServiceHelper.getCurrentUserId())) {
            return Collections.emptyMap();
        }
        List<ContentAreaEntryEvaDto> processPermSetting = this.getProcessPermSetting(currentNode, permissionId);
        List fieldEntryEvaDtos = processPermSetting.stream().filter(permission -> HRObjectUtils.equals((Object)permission.getAreaPageId(), (Object)AreaEnum.EMPINFO.getValue())).flatMap(permission -> permission.getContentfieldentry().stream()).collect(Collectors.toList());
        return fieldEntryEvaDtos.stream().collect(Collectors.toMap(ContentFieldEntryEvaDto::getAreaFieldId, ContentFieldEntryEvaDto::getFieldDisplayItem));
    }

    private boolean hasShowPerm(Map<Long, Boolean> fieldIdMap, DynamicObject field) {
        long fieldId = field.getLong("id");
        if (ObjectUtils.isEmpty(fieldIdMap) || ObjectUtils.isEmpty((Object)fieldIdMap.get(fieldId))) {
            return true;
        }
        return fieldIdMap.get(fieldId);
    }

    private long getCurrentNode(IFormView parentView, DynamicObject evalObj) {
        if (AssessNodeStatusEnum.CONFIRMING.getNodeId().longValue() == evalObj.getLong("assessnode.id")) {
            return evalObj.getLong("assessnode.id");
        }
        FormShowParameter formShowParameter = parentView.getFormShowParameter();
        Object taskIdObj = formShowParameter.getCustomParam("taskId");
        if (ObjectUtils.isEmpty((Object)taskIdObj)) {
            return 0L;
        }
        long taskId = formShowParameter.getCustomParam("taskId") instanceof String ? Long.parseLong((String)formShowParameter.getCustomParam("taskId")) : (Long)formShowParameter.getCustomParam("taskId");
        DynamicObject taskInfo = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryTaskInfo(Long.valueOf(taskId));
        return taskInfo.getLong("flowrunode.id");
    }

    private Map<Long, Boolean> getFieldPermMap(IFormView parentView) {
        FormShowParameter formShowParameter = parentView.getFormShowParameter();
        Object taskIdObj = formShowParameter.getCustomParam("taskId");
        HashMap<Long, Boolean> areaFieldPermMap = new HashMap<Long, Boolean>(16);
        if (!ObjectUtils.isEmpty((Object)taskIdObj)) {
            List contentAreaEntries;
            Map contentAreaEntriesMap;
            long taskId = formShowParameter.getCustomParam("taskId") instanceof String ? Long.parseLong((String)formShowParameter.getCustomParam("taskId")) : (Long)formShowParameter.getCustomParam("taskId");
            QFilter taskFilter = new QFilter("id", "=", (Object)taskId);
            DynamicObject flowruTaskObj = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("activity, flowruproc, flowrunode", new QFilter[]{taskFilter});
            QFilter activityFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("activity"));
            DynamicObject activityObj = ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("assessform, dynamicpermission", new QFilter[]{activityFilter});
            Long assessFormId = activityObj.getLong("assessform.id");
            QFilter assessFormFilter = new QFilter("id", "=", (Object)assessFormId);
            DynamicObject assessFormObj = ASSESS_FORM_ENTITY_SERVICE.queryOne("empinfoconf", new QFilter[]{assessFormFilter});
            long empInfoIdId = assessFormObj.getLong("empinfoconf");
            QFilter nodeFilter = new QFilter("id", "=", (Object)flowruTaskObj.getLong("flowrunode.id"));
            DynamicObject nodeObj = FLOW_RU_NODE_ENTITY_SERVICE.queryOne("name, flownodedef, index", new QFilter[]{nodeFilter});
            Long newProcPermId = activityObj.getLong("dynamicpermission.id");
            DynPermissionConfigService dynamicObjectCollection = new DynPermissionConfigService();
            long flowNodeDefId = nodeObj.getLong("flownodedef.id");
            ArrayList<Long> flowNodeIdList = new ArrayList<Long>(10);
            flowNodeIdList.add(flowNodeDefId);
            DynamicPermissionConfigVO dynamicPermissions = dynamicObjectCollection.getDynamicPermissions(newProcPermId, flowNodeIdList);
            if (dynamicPermissions != null && (contentAreaEntriesMap = dynamicPermissions.getContentAreaEntriesMap()) != null && (contentAreaEntries = (List)contentAreaEntriesMap.get(flowNodeDefId)) != null) {
                for (ContentAreaEntry contentAreaEntry : contentAreaEntries) {
                    Boolean areaDisplay;
                    Long areaPageInsId;
                    if (contentAreaEntry == null || empInfoIdId != (areaPageInsId = contentAreaEntry.getAreapageInsId() == null ? Long.valueOf("0") : contentAreaEntry.getAreapageInsId())) continue;
                    List fieldEntries = contentAreaEntry.getFieldEntries();
                    Boolean bl = areaDisplay = contentAreaEntry.getAreaDisplay() == null ? Boolean.FALSE : contentAreaEntry.getAreaDisplay();
                    if (areaDisplay != null && !areaDisplay.booleanValue()) break;
                    if (fieldEntries == null) continue;
                    for (ContentFieldEntry fieldEntry : fieldEntries) {
                        if (fieldEntry == null) continue;
                        Long areaFieldId = fieldEntry.getAreaFieldId();
                        Boolean fieldDisplay = fieldEntry.getFieldDisplay() == null ? Boolean.FALSE : fieldEntry.getFieldDisplay();
                        areaFieldPermMap.put(areaFieldId, fieldDisplay);
                    }
                }
            }
        }
        return areaFieldPermMap;
    }

    private void setLabelText(IFormView view, String label, String value) {
        Label number = (Label)view.getControl(label);
        if (number != null) {
            number.setText(value);
        }
    }

    private List<ContentAreaEntryEvaDto> getProcessPermSetting(long currentNodeId, Long permissionId) {
        if (currentNodeId == 0L) {
            return new ArrayList<ContentAreaEntryEvaDto>(10);
        }
        if (currentNodeId == AssessNodeStatusEnum.CONFIRMING.getNodeId()) {
            return ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryProcessPermSettingByKeyField(permissionId, Long.valueOf(currentNodeId));
        }
        DynamicObject ruNodeDy = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryFlowDefNodeIdByruNodeId(Long.valueOf(currentNodeId));
        return ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryProcessPermSettingByKeyField(permissionId, Long.valueOf(ruNodeDy.getLong("flownodedef.id")));
    }
}

