/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.common.enums.activitymanage.EvalProcStepEnum;
import kd.opmc.epa.common.enums.evaloverall.ProcPermAnonymityEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuRoleBo;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.common.constants.NodeTypeConstants;
import kd.opmc.pbs.common.utils.OpmcDateUtils;

public class ActEvalObjProcInfoEdit
extends HRDataBaseEdit {
    private final FlowRunSupDomainService flowRunSupDomainService = FlowRunSupDomainService.getInstance();
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUN_SUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    private static final String REFRESH_AP = "refreshap";
    private static final String ANONYMOUS_STR = "***";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{REFRESH_AP});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(REFRESH_AP)) {
            String flowType = (String)this.getView().getFormShowParameter().getCustomParam("flowType");
            if ("interviewflow".equals(flowType)) {
                this.setProcInfoCtrlDataNotContainDynPerm();
            } else {
                this.setProcInfoCtrlData();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long evalflowinsId = (Long)this.getView().getFormShowParameter().getCustomParam("evalflowinsId");
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        String flowType = (String)this.getView().getFormShowParameter().getCustomParam("flowType");
        String opSource = (String)this.getView().getFormShowParameter().getCustomParam("OP_SOURCE");
        this.getPageCache().put("evalflowinsId", String.valueOf(evalflowinsId));
        this.getPageCache().put("OP_SOURCE", opSource);
        if (taskId != null) {
            this.getPageCache().put("taskId", String.valueOf(taskId));
        }
        if ("interviewflow".equals(flowType)) {
            this.setProcInfoCtrlDataNotContainDynPerm();
        } else {
            this.setProcInfoCtrlData();
        }
    }

    public void setProcInfoCtrlData() {
        CustomControl ctrl = (CustomControl)this.getView().getControl("procinfo");
        Long evalflowinsId = Long.valueOf(this.getPageCache().get("evalflowinsId"));
        String taskIdStr = this.getPageCache().get("taskId");
        Long taskId = null;
        if (!HRStringUtils.isEmpty((String)taskIdStr)) {
            taskId = Long.valueOf(taskIdStr);
        }
        String userId = "";
        int currentNodeIndex = 0;
        HashMap<String, Object> permissionConfig = new HashMap(16);
        Long procPermId = null;
        if (taskId != null) {
            Collection values;
            permissionConfig = APP_SERVICE.queryPermissionConfig(taskId);
            DynamicObject actEvalObj = APP_SERVICE.queryActEvalObjByFlowInsId(evalflowinsId);
            Long personId = actEvalObj.getLong("person.id");
            Map userIdsByPersonIds = APP_SERVICE.getUserIdsByPersonIds(Collections.singletonList(personId));
            if (userIdsByPersonIds != null && (values = userIdsByPersonIds.values()).size() > 0) {
                userId = userIdsByPersonIds.values().toArray()[0].toString();
            }
            DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
            currentNodeIndex = taskObj.getInt("flowrunode.index");
            DynamicObject activityObj = APP_SERVICE.queryActivityById(Long.valueOf(taskObj.getLong("activity")));
            procPermId = activityObj.getLong("dynamicpermission.id");
        }
        String opSource = this.getPageCache().get("OP_SOURCE");
        WorkflowRuProcBo flowRuProcBo = this.flowRunSupDomainService.getRuProcInstance(evalflowinsId);
        HashMap<String, Object> procInfoMap = new HashMap<String, Object>(16);
        ArrayList procInfoList = new ArrayList(10);
        try {
            List flowRuNodeBoList = flowRuProcBo.getFlowRuNodeBoList();
            List flowDefNodeList = flowRuNodeBoList.stream().map(obj -> obj.getFlowDefNode().getLong("id")).collect(Collectors.toList());
            if (!flowDefNodeList.isEmpty()) {
                Map permCfgMap = APP_SERVICE.queryNodeAnonymity(procPermId, flowDefNodeList);
                for (FlowRuNodeBo flowRuNodeBo : flowRuNodeBoList) {
                    HashMap<String, Object> flowRuNodeMap = new HashMap<String, Object>(16);
                    DynamicObject flowDefNode = flowRuNodeBo.getFlowDefNode();
                    DynamicObject flowRuNode = flowRuNodeBo.getFlowRuNode();
                    Long flowrunodeId = flowRuNode.getLong("id");
                    Long nodetypeId = flowDefNode.getLong("nodetype.id");
                    int flowrunodeIndex = flowRuNode.getInt("index");
                    flowRuNodeMap.put("name", flowDefNode.getString("nodename"));
                    Long flowDefNodeId = flowDefNode.getLong("id");
                    Map itemPermCfgMap = (Map)permCfgMap.get(flowDefNodeId);
                    String scoreContent = "";
                    if (permissionConfig != null && !ObjectUtils.isEmpty((Object)itemPermCfgMap)) {
                        scoreContent = (String)itemPermCfgMap.get(ProcPermAnonymityEnum.ANONYMOUS.getCode());
                    }
                    if (!HRStringUtils.equals((String)"formulate", (String)opSource)) {
                        BigDecimal nodeweight = flowDefNode.getBigDecimal("nodeweight");
                        flowRuNodeMap.put("weight", nodeweight.stripTrailingZeros().toPlainString());
                    }
                    String nodestatus = flowRuNode.getString("nodestatus");
                    flowRuNodeMap.put("status", nodestatus);
                    Boolean iscrossnode = flowRuNode.getBoolean("iscrossnode");
                    flowRuNodeMap.put("iscrossnode", iscrossnode);
                    ArrayList flowRuNodeChildrenList = new ArrayList(10);
                    if (!iscrossnode.booleanValue()) {
                        List flowRuRoleBoList = flowRuNodeBo.getFlowRuRoleBoList();
                        for (FlowRuRoleBo flowRuRoleBo : flowRuRoleBoList) {
                            String originalRoleName;
                            HashMap<String, Object> flowRuRoleMap = new HashMap<String, Object>(16);
                            DynamicObject flowDefRuRole = flowRuRoleBo.getFlowDefRole();
                            String roleName = originalRoleName = flowDefRuRole.getString("rolename");
                            if (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(nodetypeId)) {
                                flowRuNodeMap.put("weight", "");
                            } else {
                                BigDecimal nodeweight = flowDefNode.getBigDecimal("nodeweight");
                                flowRuNodeMap.put("weight", nodeweight.stripTrailingZeros().toPlainString());
                            }
                            ArrayList flowRuRoleChildrenList = new ArrayList(10);
                            List flowRuTaskList = flowRuRoleBo.getFlowRuTaskList();
                            DynamicObject flowRuRole = flowRuRoleBo.getFlowRuRole();
                            Long flowruroleId = flowRuRole.getLong("id");
                            if (!ObjectUtils.isEmpty((Object)flowRuTaskList)) {
                                Boolean existCurrUser = false;
                                Boolean isAnonymous = false;
                                for (DynamicObject flowRuTaskObj : flowRuTaskList) {
                                    HashMap<String, String> flowRuTaskMap = new HashMap<String, String>(16);
                                    String photo = HRImageUrlUtil.getImageFullUrl((String)flowRuTaskObj.getString("handler.picturefield"));
                                    String handler = flowRuTaskObj.getString("handler.name");
                                    Long handlerId = flowRuTaskObj.getLong("handler.id");
                                    Long currUserId = RequestContext.get().getCurrUserId();
                                    Long flowrutaskId = flowRuTaskObj.getLong("id");
                                    if (HRStringUtils.equals((String)scoreContent, (String)ProcPermAnonymityEnum.ANONYMOUS.getCode()) && this.isBeforeRole(userId, flowrunodeIndex, currentNodeIndex, permissionConfig, flowruroleId)) {
                                        isAnonymous = true;
                                        if (!handlerId.equals(currUserId)) {
                                            handler = ANONYMOUS_STR;
                                            photo = "";
                                        } else {
                                            existCurrUser = true;
                                        }
                                    }
                                    flowRuTaskMap.put("name", handler);
                                    flowRuTaskMap.put("photo", photo);
                                    String taskStatus = flowRuTaskObj.getString("taskstatus");
                                    flowRuTaskMap.put("status", taskStatus);
                                    flowRuTaskMap.put("statusText", FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatus).getText());
                                    Date date = flowRuTaskObj.getDate("updatestatustime");
                                    flowRuTaskMap.put("date", date != null ? OpmcDateUtils.formatTimeUser((Date)date) : "");
                                    flowRuRoleChildrenList.add(flowRuTaskMap);
                                }
                                if (isAnonymous.booleanValue()) {
                                    roleName = existCurrUser != false ? originalRoleName : ANONYMOUS_STR;
                                }
                            }
                            flowRuRoleMap.put("name", roleName);
                            flowRuRoleMap.put("children", flowRuRoleChildrenList);
                            flowRuNodeChildrenList.add(flowRuRoleMap);
                        }
                    }
                    flowRuNodeMap.put("children", flowRuNodeChildrenList);
                    procInfoList.add(flowRuNodeMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            procInfoList = new ArrayList(10);
        }
        if (HRStringUtils.equals((String)"formulate", (String)opSource)) {
            procInfoMap.put("evalProcStep", EvalProcStepEnum.IND_ASSIGN.getCode());
        } else {
            procInfoMap.put("evalProcStep", EvalProcStepEnum.ACT_EVAL.getCode());
        }
        procInfoMap.put("procInfoList", procInfoList);
        procInfoMap.put("timestamp", System.currentTimeMillis());
        ctrl.setData(procInfoMap);
    }

    private boolean isBeforeRole(String userId, int flowrunodeIndex, int currentNodeIndex, Map<String, Object> permissionConfig, Long flowruroleId) {
        FlowRuNodeBo flowRuNodeBo;
        Long evalflowinsId;
        WorkflowRuProcBo flowRuProcBo;
        List flowRuNodeBoList;
        long currUserId = RequestContext.get().getCurrUserId();
        if (HRStringUtils.equals((String)String.valueOf(currUserId), (String)userId)) {
            return true;
        }
        if (flowrunodeIndex > currentNodeIndex) {
            return true;
        }
        if (flowrunodeIndex == currentNodeIndex && currentNodeIndex > 0 && (flowRuNodeBoList = (flowRuProcBo = FLOW_RUN_SUP_DOMAIN_SERVICE.getRuProcInstance(evalflowinsId = (Long)this.getView().getFormShowParameter().getCustomParam("evalflowinsId"))).getFlowRuNodeBoList()) != null && flowRuNodeBoList.size() >= currentNodeIndex && (flowRuNodeBo = (FlowRuNodeBo)flowRuNodeBoList.get(currentNodeIndex - 1)) != null) {
            List flowRuRoleBoList = flowRuNodeBo.getFlowRuRoleBoList();
            Long currentFlowruroleId = (Long)permissionConfig.get("flowruroleId");
            if (flowRuRoleBoList != null) {
                int turnoversort = 0;
                int currentTurnoversort = 1;
                for (FlowRuRoleBo flowRuRoleBo : flowRuRoleBoList) {
                    Long pkValue = (Long)flowRuRoleBo.getFlowRuRole().getPkValue();
                    if (HRObjectUtils.equals((Object)pkValue, (Object)flowruroleId)) {
                        turnoversort = (Integer)flowRuRoleBo.getFlowRuRole().get("turnoversort");
                    }
                    if (!HRObjectUtils.equals((Object)pkValue, (Object)currentFlowruroleId)) continue;
                    currentTurnoversort = (Integer)flowRuRoleBo.getFlowRuRole().get("turnoversort");
                }
                if (turnoversort >= currentTurnoversort) {
                    return true;
                }
            }
        }
        return false;
    }

    public void setProcInfoCtrlDataNotContainDynPerm() {
        CustomControl ctrl = (CustomControl)this.getView().getControl("procinfo");
        Long evalflowinsId = Long.valueOf(this.getPageCache().get("evalflowinsId"));
        String taskIdStr = this.getPageCache().get("taskId");
        Long taskId = null;
        if (!HRStringUtils.isEmpty((String)taskIdStr)) {
            taskId = Long.valueOf(taskIdStr);
        }
        String userId = "";
        int currentNodeIndex = 0;
        if (taskId != null) {
            Collection values;
            QFilter filter = new QFilter("interflowins", "=", (Object)evalflowinsId);
            DynamicObject actEvalObj = BusinessDataServiceHelper.loadSingle((String)"epa_interobj", (String)"id, person.id", (QFilter[])new QFilter[]{filter});
            Long personId = actEvalObj.getLong("person.id");
            Map userIdsByPersonIds = APP_SERVICE.getUserIdsByPersonIds(Collections.singletonList(personId));
            if (userIdsByPersonIds != null && (values = userIdsByPersonIds.values()).size() > 0) {
                userId = userIdsByPersonIds.values().toArray()[0].toString();
            }
            DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
            currentNodeIndex = taskObj.getInt("flowrunode.index");
        }
        String opSource = this.getPageCache().get("OP_SOURCE");
        WorkflowRuProcBo flowRuProcBo = this.flowRunSupDomainService.getRuProcInstance(evalflowinsId);
        HashMap<String, Object> procInfoMap = new HashMap<String, Object>(16);
        ArrayList procInfoList = new ArrayList(10);
        try {
            List flowRuNodeBoList = flowRuProcBo.getFlowRuNodeBoList();
            List flowDefNodeList = flowRuNodeBoList.stream().map(obj -> obj.getFlowDefNode().getLong("id")).collect(Collectors.toList());
            if (!flowDefNodeList.isEmpty()) {
                for (FlowRuNodeBo flowRuNodeBo : flowRuNodeBoList) {
                    HashMap<String, Object> flowRuNodeMap = new HashMap<String, Object>(16);
                    DynamicObject flowDefNode = flowRuNodeBo.getFlowDefNode();
                    DynamicObject flowRuNode = flowRuNodeBo.getFlowRuNode();
                    Long flowrunodeId = flowRuNode.getLong("id");
                    int flowrunodeIndex = flowRuNode.getInt("index");
                    flowRuNodeMap.put("name", flowDefNode.getString("nodename"));
                    Long flowDefNodeId = flowDefNode.getLong("id");
                    Long nodetypeId = flowDefNode.getLong("nodetype.id");
                    String scoreContent = "";
                    if (!HRStringUtils.equals((String)"formulate", (String)opSource)) {
                        if (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(nodetypeId)) {
                            flowRuNodeMap.put("weight", "");
                        } else {
                            BigDecimal nodeweight = flowDefNode.getBigDecimal("nodeweight");
                            flowRuNodeMap.put("weight", nodeweight.stripTrailingZeros().toPlainString());
                        }
                    }
                    String nodestatus = flowRuNode.getString("nodestatus");
                    flowRuNodeMap.put("status", nodestatus);
                    Boolean iscrossnode = flowRuNode.getBoolean("iscrossnode");
                    flowRuNodeMap.put("iscrossnode", iscrossnode);
                    ArrayList flowRuNodeChildrenList = new ArrayList(10);
                    if (!iscrossnode.booleanValue()) {
                        List flowRuRoleBoList = flowRuNodeBo.getFlowRuRoleBoList();
                        for (FlowRuRoleBo flowRuRoleBo : flowRuRoleBoList) {
                            String originalRoleName;
                            HashMap<String, Object> flowRuRoleMap = new HashMap<String, Object>(16);
                            DynamicObject flowDefRuRole = flowRuRoleBo.getFlowDefRole();
                            String roleName = originalRoleName = flowDefRuRole.getString("rolename");
                            BigDecimal roleweight = flowDefRuRole.getBigDecimal("roleweight");
                            flowRuRoleMap.put("weight", roleweight.stripTrailingZeros().toPlainString());
                            ArrayList flowRuRoleChildrenList = new ArrayList(10);
                            List flowRuTaskList = flowRuRoleBo.getFlowRuTaskList();
                            DynamicObject flowRuRole = flowRuRoleBo.getFlowRuRole();
                            Long flowruroleId = flowRuRole.getLong("id");
                            if (!ObjectUtils.isEmpty((Object)flowRuTaskList)) {
                                Boolean existCurrUser = false;
                                Boolean isAnonymous = false;
                                for (DynamicObject flowRuTaskObj : flowRuTaskList) {
                                    HashMap<String, String> flowRuTaskMap = new HashMap<String, String>(16);
                                    String photo = HRImageUrlUtil.getImageFullUrl((String)flowRuTaskObj.getString("handler.picturefield"));
                                    String handler = flowRuTaskObj.getString("handler.name");
                                    Long handlerId = flowRuTaskObj.getLong("handler.id");
                                    Long currUserId = RequestContext.get().getCurrUserId();
                                    Long flowrutaskId = flowRuTaskObj.getLong("id");
                                    if (HRStringUtils.equals((String)scoreContent, (String)ProcPermAnonymityEnum.ANONYMOUS.getCode()) && this.isBeforeRole(userId, flowrunodeIndex, currentNodeIndex, flowruroleId)) {
                                        isAnonymous = true;
                                        if (!handlerId.equals(currUserId)) {
                                            handler = ANONYMOUS_STR;
                                            photo = "";
                                        } else {
                                            existCurrUser = true;
                                        }
                                    }
                                    flowRuTaskMap.put("name", handler);
                                    flowRuTaskMap.put("photo", photo);
                                    String taskStatus = flowRuTaskObj.getString("taskstatus");
                                    flowRuTaskMap.put("status", taskStatus);
                                    flowRuTaskMap.put("statusText", FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatus).getText());
                                    flowRuTaskMap.put("date", flowRuTaskObj.getString("updatestatustime"));
                                    flowRuRoleChildrenList.add(flowRuTaskMap);
                                }
                                if (isAnonymous.booleanValue()) {
                                    roleName = existCurrUser != false ? originalRoleName : ANONYMOUS_STR;
                                }
                            }
                            flowRuRoleMap.put("name", roleName);
                            flowRuRoleMap.put("children", flowRuRoleChildrenList);
                            flowRuNodeChildrenList.add(flowRuRoleMap);
                        }
                    }
                    flowRuNodeMap.put("children", flowRuNodeChildrenList);
                    procInfoList.add(flowRuNodeMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            procInfoList = new ArrayList(10);
        }
        procInfoMap.put("evalProcStep", EvalProcStepEnum.INTERVIEW.getCode());
        procInfoMap.put("procInfoList", procInfoList);
        procInfoMap.put("timestamp", System.currentTimeMillis());
        ctrl.setData(procInfoMap);
    }

    private boolean isBeforeRole(String userId, int flowrunodeIndex, int currentNodeIndex, Long flowruroleId) {
        List flowRuRoleBoList;
        FlowRuNodeBo flowRuNodeBo;
        Long evalflowinsId;
        WorkflowRuProcBo flowRuProcBo;
        List flowRuNodeBoList;
        long currUserId = RequestContext.get().getCurrUserId();
        if (HRStringUtils.equals((String)String.valueOf(currUserId), (String)userId)) {
            return true;
        }
        if (flowrunodeIndex > currentNodeIndex) {
            return true;
        }
        if (flowrunodeIndex == currentNodeIndex && currentNodeIndex > 0 && (flowRuNodeBoList = (flowRuProcBo = FLOW_RUN_SUP_DOMAIN_SERVICE.getRuProcInstance(evalflowinsId = (Long)this.getView().getFormShowParameter().getCustomParam("evalflowinsId"))).getFlowRuNodeBoList()) != null && flowRuNodeBoList.size() >= currentNodeIndex && (flowRuNodeBo = (FlowRuNodeBo)flowRuNodeBoList.get(currentNodeIndex - 1)) != null && (flowRuRoleBoList = flowRuNodeBo.getFlowRuRoleBoList()) != null) {
            int turnoversort = 0;
            int currentTurnoversort = 1;
            for (FlowRuRoleBo flowRuRoleBo : flowRuRoleBoList) {
                Long pkValue = (Long)flowRuRoleBo.getFlowRuRole().getPkValue();
                if (!HRObjectUtils.equals((Object)pkValue, (Object)flowruroleId)) continue;
                turnoversort = (Integer)flowRuRoleBo.getFlowRuRole().get("turnoversort");
            }
            if (turnoversort >= currentTurnoversort) {
                return true;
            }
        }
        return false;
    }
}

